<!--suppress HtmlDeprecatedAttribute, HttpUrlsUsage -->

<div align="center">
  <p>
    <img src="https://s1.imagehub.cc/images/2023/03/07/af8ed087c9d354b9ab6142aae7bbafb6.png" alt="autojs6-banner_800×224" border="0" width="704" />
  </p>

  <p>Инструмент автоматизации на языке JavaScript для платформы Android с поддержкой службы доступности</p>

  <p>
    <a href="http://download.autojs6.com"><img alt="GitHub release (latest by date)" src="https://img.shields.io/github/v/release/SuperMonster003/AutoJs6"/></a>
    <a href="http://issues.autojs6.com"><img alt="GitHub closed issues" src="https://img.shields.io/github/issues/SuperMonster003/AutoJs6?color=A24232"/></a>
    <a href="http://commit.autojs6.com/99a1d8490fac5b6d55f6f183db59ad833a2064ed"><img alt="Created" src="https://img.shields.io/date/1636632233?color=2e7d32&label=created"/></a>
    <br>
    <a href="https://github.com/mozilla/rhino"><img alt="Rhino" src="https://img.shields.io/badge/rhino-1.8.1--SNAPSHOT-795548"/></a>
    <a href="https://developer.android.com/studio/archive"><img alt="Android Studio" src="https://img.shields.io/badge/android%20studio-2022.1+-B64FC8"/></a>
    <br>
    <a href="https://www.codefactor.io/repository/github/SuperMonster003/AutoJs6"><img alt="CodeFactor Grade" src="https://www.codefactor.io/repository/github/SuperMonster003/AutoJs6/badge"/></a>
    <a href="https://www.jetbrains.com/?from=AutoJs6"><img alt="JetBrains supporter" src="https://img.shields.io/badge/supporter-JetBrains-ee4677"/></a>
    <a href="http://project.autojs6.com/blob/master/LICENSE"><img alt="GitHub License" src="https://img.shields.io/github/license/SuperMonster003/AutoJs6?color=534BAE"/></a>
  </p>
</div>

******

### Языки

******

Текущий файл README.md поддерживает следующие языки:

 - [简体中文 [zh-Hans]](http://project.autojs6.com/blob/master/.readme/README-zh-Hans.md)
 - [繁體中文 (香港) [zh-Hant-HK]](http://project.autojs6.com/blob/master/.readme/README-zh-Hant-HK.md)
 - [繁體中文 (台灣) [zh-Hant-TW]](http://project.autojs6.com/blob/master/.readme/README-zh-Hant-TW.md)
 - [English [en]](http://project.autojs6.com/blob/master/.readme/README-en.md)
 - [Français [fr]](http://project.autojs6.com/blob/master/.readme/README-fr.md)
 - [Español [es]](http://project.autojs6.com/blob/master/.readme/README-es.md)
 - [日本語 [ja]](http://project.autojs6.com/blob/master/.readme/README-ja.md)
 - [한국어 [ko]](http://project.autojs6.com/blob/master/.readme/README-ko.md)
 - Русский [ru] # текущий
 - [العربية [ar]](http://project.autojs6.com/blob/master/.readme/README-ar.md)

******

### Введение

******

[Auto.js](https://github.com/hyb1996/Auto.js) — это инструмент автоматизации на языке JavaScript для платформы Android с поддержкой [службы доступности](https://developer.android.com/guide/topics/ui/accessibility/service?hl=zh-cn).

Auto.js был выпущен [hyb1996](https://github.com/hyb1996) в `2017/01/27`, и его поддержка прекратилась в `2020/03/13`, финальная версия - `4.1.1 Alpha2`, номер сборки - `461`.

AutoJs6 разработан на основе финальной версии проекта Auto.js и вышел в `2021/12/01`, оставаясь бесплатным с открытым исходным кодом.

В таблице ниже перечислены некоторые проекты, связанные с Auto.js (отсортированы по дате начала разработки):

| <span style="word-break:keep-all;white-space:nowrap">Проект</span> |                                                             <span style="word-break:keep-all;white-space:nowrap">Название приложения</span>                                                              | <span style="word-break:keep-all;white-space:nowrap">Разработчик</span> | <span style="word-break:keep-all;white-space:nowrap">Дата начала разработки</span> | <span style="word-break:keep-all;white-space:nowrap">Дата окончания разработки</span> |
|:------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------:|:---------------------------------------------------------------------------------------------------------------------------------:|:-------------------------------------------------------------------------------------------------------------------------------:|
|     <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/hyb1996/Auto.js)</span>      |    <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/TonyJiangWJ/Auto.js/commit/268ec8895bbfa28fc7715154eb15b1c1eaaefd14#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span>     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2017/01/27`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2020/03/13`</span>                             |
|                     <span style="word-break:keep-all;white-space:nowrap">Auto.js Pro 7</span>                      |                                                                                     <span style="word-break:keep-all;white-space:nowrap">Auto.js</span>                                                                                      |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2019/03/13`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2019/07/08`</span>                             |
|                     <span style="word-break:keep-all;white-space:nowrap">Auto.js Pro 8</span>                      |                                                                                    <span style="word-break:keep-all;white-space:nowrap">AutoJsPro</span>                                                                                     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2019/10/13`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2021/07/24`</span>                             |
|   <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/TonyJiangWJ/Auto.js)</span>    | <span style="word-break:keep-all;white-space:nowrap">[Auto.js&#160;M](https://github.com/TonyJiangWJ/Auto.js/commit/268ec8895bbfa28fc7715154eb15b1c1eaaefd14#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span> |      <span style="word-break:keep-all;white-space:nowrap">[TonyJiangWJ](https://github.com/TonyJiangWJ)</span>       |                             <span style="word-break:keep-all;white-space:nowrap">`2019/11/21`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|      <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/kkevsekk1/AutoX)</span>       |                 <span style="white-space:pre">[Autox.js](https://github.com/kkevsekk1/AutoX/commit/8143e4ed893d4af05d22aa791b83a962f9959873#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span>                  |        <span style="word-break:keep-all;white-space:nowrap">[kkevsekk1](https://github.com/kkevsekk1)</span>         |                             <span style="word-break:keep-all;white-space:nowrap">`2020/07/24`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|        <span style="word-break:keep-all;white-space:nowrap">[Auto.js Pro 9](https://pro.autojs.org/)</span>        |                                                                                    <span style="word-break:keep-all;white-space:nowrap">AutoJsPro</span>                                                                                     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2021/03/28`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2023/02/09`</span>                             |
| <span style="word-break:keep-all;white-space:nowrap">[AutoJs6](https://github.com/SuperMonster003/AutoJs6)</span>  |  <span style="word-break:keep-all;white-space:nowrap">[AutoJs6](https://github.com/SuperMonster003/AutoJs6/commit/a8ce1b9acb541e9736c33134be3194c3148a15a3#diff-833a46a97033e77558372a2dce103fd6fee29aaaa899f610022a7aece592ee7bR27)</span>  |  <span style="word-break:keep-all;white-space:nowrap">[SuperMonster003](https://github.com/SuperMonster003)</span>   |                             <span style="word-break:keep-all;white-space:nowrap">`2021/12/01`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|      <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/kkevsekk1/AutoX)</span>       |            <span style="white-space:pre">[Autox.js&#160;v6](https://github.com/kkevsekk1/AutoX/commit/8b6776cff8b0fca4be4a52719b7d7d07c0a058f3#diff-51a0b488f963eb0be6c6599bf5df497313877cf5bdff3950807373912ac1cdc9R130)</span>             |           <span style="word-break:keep-all;white-space:nowrap">[wilinz](https://github.com/wilinz)</span>            |                             <span style="word-break:keep-all;white-space:nowrap">`2022/05/26`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|        <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/aiselp/AutoX)</span>        |              <span style="white-space:pre">[Autox.js&#160;v7](https://github.com/aiselp/AutoX/commit/484491fd5fe12b8203d0b09c181eb0f471c0ea9f#diff-8cff73265af19c059547b76aca8882cbaa3209291406f52df1dafbbc78e80c46R120)</span>              |           <span style="word-break:keep-all;white-space:nowrap">[aiselp](https://github.com/aiselp)</span>            |                             <span style="word-break:keep-all;white-space:nowrap">`2024/04/21`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |

Даты в таблице являются оценочными и могут отличаться от фактических.

В таблице Auto.js Pro 7/8/9 указаны как платные версии, остальные являются бесплатными версиями с открытым исходным кодом.

******

### Функции

******

* Можно использовать в качестве JavaScript IDE (автодополнение кода / переименование переменных / форматирование кода)
* Поддержка автоматизации на основе [службы доступности](https://developer.android.com/reference/android/accessibilityservice/AccessibilityService)
* Поддержка быстрых действий через плавающую кнопку (запись скриптов и их выполнение / просмотр имени пакета и активности / анализ макета)
* Поддержка API селекторов, предоставляющая возможности обхода виджетов / получения информации / управления виджетами (аналогично [UiAutomator](https://developer.android.com/training/testing/ui-automator))
* Поддержка анализа интерфейса макета (аналогично LayoutInspector из Android Studio)
* Поддержка функции записи и воспроизведения записанного
* Поддержка создания скриншотов / сохранения скриншотов / поиска по изображениям / сопоставления изображений
* Поддержка написания интерфейсов с использованием [E4X](https://zh.wikipedia.org/wiki/E4X) (ECMAScript для XML)
* Поддержка упаковки файлов скриптов или проекта в APK файл
* Поддержка расширенных функций с использованием привилегий Root (нажатия на экран / пролистывания / записи / Shell)
* Поддержка работы в качестве плагина для Tasker
* Поддержка подключения к VSCode для разработки на рабочем столе (требуется плагин [AutoJs6-VSCode-Extension](http://vscext-project.autojs6.com))

******

### Окружение

******

- Операционная система Android
- [API](https://developer.android.com/guide/topics/manifest/uses-sdk-element#ApiLevels) [24](https://developer.android.com/reference/android/os/Build.VERSION_CODES#N) ([7.0](https://zh.wikipedia.org/wiki/Android_Nougat)) [[N](https://developer.android.com/reference/android/os/Build.VERSION_CODES#N)] и выше

******

### Руководство

******

* [Документация приложения](https://docs.autojs6.com)
* [Пользовательское руководство (в разработке)](https://docs.autojs6.com/#/manual)
* [Устранение неполадок](https://docs.autojs6.com/#/qa)
* [Компиляция и сборка проекта](#project-compilation-and-build)
* [Помощь в разработке скриптов](#script-development-assistance)

******

### Основные изменения

******

По сравнению с окончательной версией с открытым исходным кодом Auto.js `4.1.1 Alpha2`, AutoJs6 включает следующие основные обновления или изменения:

* Поддержка получения привилегий ADB через [Shizuku](https://shizuku.rikka.app/introduction/) и использование системных API
* Поддержка построения экземпляров [WebSocket](https://docs.autojs6.com/#/webSocketType) для выполнения сетевых запросов на основе [протокола WebSocket](https://zh.wikipedia.org/wiki/WebSocket)
* Добавлены новые модули [ [base64](https://docs.autojs6.com/#/base64) / [crypto](https://docs.autojs6.com/#/crypto) / [sqlite](https://docs.autojs6.com/#/sqlite) / [i18n](https://docs.autojs6.com/#/i18n) / [notice](https://docs.autojs6.com/#/notice) / [ocr](https://docs.autojs6.com/#/ocr) / [opencc](https://docs.autojs6.com/#/opencc) / [qrcode](https://docs.autojs6.com/#/qrcode) / [shizuku](https://docs.autojs6.com/#/shizuku) / ... ]
* Поддержка нескольких языков [ испанский / французский / русский / арабский / японский / корейский / английский / упрощенный китайский / традиционный китайский / ... ]
* Адаптация темы [ Группировка / Локация / Поиск / История / Автоматическая адаптация яркости и контрастности / ... ]
* Поддержка ночного режима [ страница настроек / страница документации / страница анализа макета / плавающее окно / ... ]
* Плагин [VSCode](http://vscext-project.autojs6.com) поддерживает варианты подключения клиента (LAN) и сервера (LAN/ADB)
* Движок [Rhino](https://github.com/mozilla/rhino/) обновлен с версии [v1.7.7.2](https://github.com/mozilla/rhino/releases/tag/Rhino1_7_7_2_Release) до версии [v1.8.1-SNAPSHOT](http://rhino.autojs6.com/blob/master/gradle.properties#L3)
    * Поддержка Unicode для [экранирования кодовых точек](https://developer.mozilla.org/zh-CN/docs/Glossary/Code_point) и символов [в дополнительных плоскостях](https://zh.wikipedia.org/wiki/Unicode%E5%AD%97%E7%AC%A6%E5%B9%B3%E9%9D%A2%E6%98%A0%E5%B0%84#%E7%AC%AC%E4%B8%80%E8%BC%94%E5%8A%A9%E5%B9%B3%E9%9D%A2)
       ```javascript
       '\u{1D160}'; /* означает "𝅘𝅥𝅮", традиционный метод: '\uD834\uDD60'. */
       ```
    * Поддержка [Object.values()](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Global_Objects/Object/values)
       ```javascript
       Object.values({name: 'Max', age: 4}); // ['max', 4]
       ```
    * Поддержка [Array.prototype.includes()](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Global_Objects/Array/includes)
       ```javascript
       [10, 20, NaN].includes(20); // true
       ```
    * Поддержка [BigInt](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Global_Objects/BigInt)
       ```javascript
       typeof 567n === 'bigint'; // true
       ```
    * Поддержка [шаблонных строк](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Template_literals)
       ```javascript
       `Lucky number: ${(Math.random() * 100).toFixed(0)}`
       ```
    * Просмотр новых функций движка Rhino [новые функции](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/RHINO.md)
    * Просмотр списка совместимости движка Rhino [список совместимости](https://mozilla.github.io/rhino/compat/engines.html)

******

### История версий

******

# v6.6.3

###### 2025/05/27

* `Новое` Функция истории версий: просмотр многоязычных журналов изменений и статистики
* `Новое` Метод timers.keepAlive (теперь глобальный) для поддержания активности скрипта
* `Новое` Слушатели событий, такие как engines.on('start/stop/error', callback), для глобальных событий движка
* `Новое` Метод images.detectMultiColors для проверки нескольких точек цвета _[`issue #374`](http://issues.autojs6.com/374)_
* `Новое` Методы images.matchFeatures/detectAndComputeFeatures: поиск изображений в полном разрешении (см. [Auto.js Pro](https://g.pro.autojs.org/)) _[`issue #366`](http://issues.autojs6.com/366)_
* `Новое` Метод images.compressToBytes для сжатия изображения и получения массива байтов
* `Новое` Метод images.downsample для понижения разрешения и создания нового ImageWrapper
* `Новое` Метод ui.keepScreenOn для удержания экрана включённым, пока UI-страница в фокусе
* `Новое` Свойство ui.root (getter) для получения узла «корневой контейнер содержимого окна» в макете UI
* `Новое` Элемент webview поддерживает макеты веб-страниц на базе JsBridge (см. [Auto.js Pro](https://g.pro.autojs.org/)) [пример: Layout > Interactive HTML / Vue2 + Vant (SFC)] _[`issue #281`](http://issues.autojs6.com/281)_
* `Исправление` Онлайн-документация на вкладке Docs и в активности Docs могла перекрываться системной навигационной панелью
* `Исправление` На некоторых страницах нажатие кнопок Toolbar могло ошибочно вызывать событие клика по заголовку
* `Исправление` Пустые строки в редакторе кода отображались квадратиками на ряде устройств
* `Исправление` Диалог выбора цвета в настройках темы мог бесконечно накладываться друг на друга
* `Исправление` Кнопка увеличения громкости не останавливала все скрипты при выключенной службе доступности
* `Исправление` IME перекрывал ввод при редактировании пользовательского широковещательного сообщения в расписании задач
* `Исправление` Элементы управления внутри webview не могли корректно вызвать программную клавиатуру
* `Исправление` Диалог информации APK мог не получать название приложения и сведения о SDK
* `Исправление` Пример файлового менеджера мог не загружать содержимое подпапок при входе в каталог проекта
* `Исправление` В режиме UI на Android 15 верхний контент перекрывался строкой состояния
* `Исправление` Фон строки состояния на некоторых страницах Android 15 не менялся вместе с цветом темы
* `Исправление` Модуль dialogs не поддерживал свойство customView _[`issue #364`](http://issues.autojs6.com/364)_
* `Исправление` Параметр выражения dialogs.input мог не возвращать результат выполнения
* `Исправление` Использование JavaAdapter приводило к переполнению стека ClassLoader _[`issue #376`](http://issues.autojs6.com/376)_
* `Исправление` console.setContentTextColor сбрасывал цвет текста по умолчанию _[`issue #346`](http://issues.autojs6.com/346)_
* `Исправление` console.setContentBackgroundColor не принимал названия цветов _[`issue #384`](http://issues.autojs6.com/384)_
* `Исправление` Реализация images.compress скорректирована: теперь меняет качество кодирования, а не выполняет даунсемплинг
* `Исправление` Метод images.resize работал некорректно
* `Исправление` engines.all мог вызывать ConcurrentModificationException _[`issue #394`](http://issues.autojs6.com/394)_
* `Исправление` Неверные форматы даты на некоторых языках в README.md
* `Исправление` Сборка Gradle могла падать из-за неверного размера архивного файла библиотеки _[`issue #389`](http://issues.autojs6.com/389)_
* `Улучшение` Анализ макета поддерживает скрытие элементов (автор [TonyJiangWJ](https://github.com/TonyJiangWJ)) _[`pr #371`](http://pr.autojs6.com/371)_ _[`issue #355`](http://issues.autojs6.com/355)_
* `Улучшение` В меню анализа макета добавлены градиентные разделители для группировки функций
* `Улучшение` Файл project.json поддерживает опцию permissions для проектов скриптов (автор [wirsnow](https://github.com/wirsnow)) _[`pr #391`](http://pr.autojs6.com/391)_ _[`issue #362`](http://issues.autojs6.com/362)_
* `Улучшение` При упаковке одного файла автоматически читаются и отмечаются заявленные разрешения установленного приложения _[`issue #362`](http://issues.autojs6.com/362)_
* `Улучшение` Расширена область применения цвета темы, добавлена поддержка большего числа виджетов
* `Улучшение` Ширина выдвижного меню на главной странице адаптируется к альбомному и ультраширокому экрану
* `Улучшение` Добавлены горизонтальный и компактный макеты для страниц «О приложении» и «О разработчике»
* `Улучшение` В диалогах настроек появилось меню «Использовать значение по умолчанию»
* `Улучшение` Плавающая кнопка файлового менеджера скрывается при нажатии вне её области
* `Улучшение` Форматтер кода поддерживает операторы `??`, `?.`, `??=`
* `Улучшение` Редактор кода поддерживает чтение и запись файлов в кодировках GB18030 / UTF-16 (LE/BE) / Shift_JIS и других
* `Улучшение` Редактор кода теперь отображает подробную информацию о файле (путь/кодировка/разделитель строк/общее количество байтов и символов и др.) _[`issue #395`](http://issues.autojs6.com/395)_
* `Улучшение` Добавлены сообщения об ошибках для действий Intent (редактировать / просмотреть / установить / отправить / воспроизвести и др.)
* `Улучшение` Атрибут url элемента webview поддерживает относительные пути
* `Улучшение` Параметр path в ImageWrapper#saveTo поддерживает относительные пути
* `Улучшение` images.save поддерживает сжатие PNG при использовании параметра quality _[`issue #367`](http://issues.autojs6.com/367)_
* `Улучшение` Добавлена возможность очистки списка игнорируемых обновлений и адресов клиентского режима
* `Улучшение` Информация об обновлении версии выводится на текущем языке интерфейса
* `Улучшение` Асинхронная загрузка повышает плавность прокрутки списка в файловом менеджере
* `Улучшение` Улучшено содержание и формат сообщений об исключениях скриптов в консоли
* `Улучшение` Примеры кода теперь можно сбросить до исходного содержимого папки
* `Улучшение` Увеличена скорость проверки подписи APK
* `Улучшение` Оптимизированы диалоги информации файлов APK/медиа по скорости и логике отображения
* `Улучшение` Скрипт сборки Gradle лучше адаптируется к новым версиям _[`discussion #369`](http://discussions.autojs6.com/369)_
* `Улучшение` Изменения версий некоторых зависимостей или локальных библиотек _[`CHANGELOG.md`](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG.md#v663)_

# v6.6.2

###### 2025/04/16

* `Новое` Методы, такие как ui.statusBarAppearanceLight, statusBarAppearanceLightBy и navigationBarColor и т.д.
* `Новое` Атрибут ui.statusBarHeight (getter), используемый для получения высоты строки состояния _[`issue #357`](http://issues.autojs6.com/357)_
* `Новое` Метод images.flip для переворачивания изображений _[`issue #349`](http://issues.autojs6.com/349)_
* `Новое` Добавлена опция «расширение файла» на странице настроек
* `Новое` Страница настройки темы теперь поддерживает новый макет (группировка, позиционирование, поиск, история, улучшенная цветовая палитра и т.д.)
* `Исправление` Проблема, при которой цвет фона строки состояния на Android 15 не соответствует цвету темы
* `Исправление` Проблема, при которой метод plugins.load не загружает плагины корректно _[`issue #290`](http://issues.autojs6.com/290)_
* `Исправление` Проблема, при которой библиотека dx работает некорректно на Android 7.x _[`issue #293`](http://issues.autojs6.com/293)_
* `Исправление` Проблема, при которой ScriptRuntime может испытывать проблемы синхронизации при использовании require для импорта встроенных модулей (предварительное решение) _[`issue #298`](http://issues.autojs6.com/298)_
* `Исправление` Проблема, при которой в модуле notice отсутствуют методы расширения, такие как getBuilder _[`issue #301`](http://issues.autojs6.com/301)_
* `Исправление` Проблема, при которой методы shizuku/shell не принимают строковые параметры _[`issue #310`](http://issues.autojs6.com/310)_
* `Исправление` Проблема, при которой метод colors.pixel не принимает параметры с изображением одного канала _[`issue #350`](http://issues.autojs6.com/350)_
* `Исправление` Проблема, при которой методы engines.execScript/execScriptFile используют некорректный рабочий каталог по умолчанию при выполнении скриптов _[`issue #358`](http://issues.autojs6.com/358)_ _[`issue #340`](http://issues.autojs6.com/340)_ _[`issue #339`](http://issues.autojs6.com/339)_
* `Исправление` Проблема, при которой floaty.window/floaty.rawWindow не могут выполняться в дополнительных потоках
* `Исправление` Проблема, при которой floaty.getClip может неправильно получать содержимое буфера обмена _[`issue #341`](http://issues.autojs6.com/341)_
* `Исправление` Проблема, при которой результат ui.inflate лишён методов прототипа, таких как attr, on и click
* `Исправление` Проблема, при которой некорректно связывается контекст области видимости при использовании XML-синтаксиса для задания выражения JavaScript в качестве значения атрибута _[`issue #319`](http://issues.autojs6.com/319)_
* `Исправление` Проблема, при которой исключения некоторых методов не перехватываются блоком try..catch _[`issue #345`](http://issues.autojs6.com/345)_
* `Исправление` Проблема, при которой генерация кода на странице анализа макета может приводить к сбою приложения _[`issue #288`](http://issues.autojs6.com/288)_
* `Исправление` Проблема, при которой упакованные приложения не могут корректно использовать модуль shizuku _[`issue #227`](http://issues.autojs6.com/227)_ _[`issue #231`](http://issues.autojs6.com/231)_ _[`issue #284`](http://issues.autojs6.com/284)_ _[`issue #287`](http://issues.autojs6.com/287)_ _[`issue #304`](http://issues.autojs6.com/304)_
* `Исправление` Проблема, при которой в редакторе кода переход к концу строки может перемещать курсор в начало следующей строки
* `Исправление` Проблема, при которой быстрые последовательные нажатия на диалоговые элементы в настройках могут приводить к сбою приложения
* `Улучшение` Оптимизация размера файла APK в шаблоне упакованных приложений
* `Улучшение` Приложение (и упакованные приложения) теперь поддерживают больше разрешений _[`issue #338`](http://issues.autojs6.com/338)_
* `Улучшение` Добавлена опция для библиотеки Pinyin на странице упаковки
* `Улучшение` Оптимизация фона строки состояния и цвета текста на главном экране упакованных приложений
* `Улучшение` Добавлены переключатели для специальных разрешений (доступ ко всем файлам и отправка уведомлений) на странице настроек упакованных приложений _[`issue #354`](http://issues.autojs6.com/354)_
* `Улучшение` Цвета текста и иконок элементов управления автоматически адаптируются в зависимости от яркости темы
* `Улучшение` Улучшение визуального восприятия при низком контрасте между цветом элемента и его фоном
* `Улучшение` Улучшена совместимость поля ввода HEX в палитре цветов при вставке значений из буфера обмена
* `Улучшение` Панель навигации приложения теперь может быть прозрачной или полупрозрачной для улучшения визуального восприятия
* `Улучшение` Режим UI по умолчанию для строки состояния и панели навигации установлен на цвет `md_grey_50` в светлом режиме
* `Улучшение` Переключатель службы доступности в боковом меню главного экрана теперь синхронизируется с кодом скрипта
* `Улучшение` На странице документации главного экрана добавлены кнопки двунаправленного поиска
* `Улучшение` Вкладка «Файлы» на главном экране позволяет изменять видимость плавающей кнопки посредством длительного нажатия
* `Улучшение` Заголовок редактора кода теперь автоматически настраивает размер шрифта
* `Улучшение` Видимость плавающей кнопки на странице журналов теперь связана с действиями прокрутки списка
* `Улучшение` Файл конфигурации project.json для проекта скрипта теперь поддерживает больше опций упаковки _[`issue #305`](http://issues.autojs6.com/305)_ _[`issue #306`](http://issues.autojs6.com/306)_
* `Улучшение` Файл project.json теперь поддерживает гибкое сопоставление наименований опций и совместимость с псевдонимами
* `Улучшение` Диалоговое окно информации о типе файла APK теперь включает информацию о размере файла и схеме подписи
* `Улучшение` Диалоговое окно информации о типе файла APK теперь поддерживает обработчики кликов для копирования текста и перехода к информации о приложении
* `Улучшение` Попытка восстановить пакеты с префиксом com.stardust для повышения совместимости кода _[`issue #290`](http://issues.autojs6.com/290)_
* `Улучшение` Методы floaty.window/floaty.rawWindow теперь поддерживают выполнение как в основном, так и в дополнительных потоках
* `Улучшение` Глобальный метод getClip теперь использует floaty.getClip при необходимости для повышения совместимости
* `Улучшение` Улучшена совместимость методов files.path и связанных с ним при передаче значения null для пути
* `Улучшение` Синхронизация с последней официальной версией движка Rhino и необходимые адаптации кода
* `Улучшение` Улучшение README.md с целью лучшей документации сборки и запуска проекта _[`issue #344`](http://issues.autojs6.com/344)_
* `Улучшение` Изменения версий некоторых зависимостей или локальных библиотек _[`CHANGELOG.md`](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG.md#v662)_

# v6.6.1

###### 2025/01/01

* `Новое` Модуль Pinyin для преобразования китайского пиньиня (См. документацию проекта > [Китайский Пиньинь](https://docs.autojs6.com/#/pinyin))
* `Новое` Модуль Pinyin4j для преобразования китайского пиньиня (См. документацию проекта > [Китайский Пиньинь](https://docs.autojs6.com/#/pinyin4j))
* `Новое` Методы UiObject#isSimilar и UiObjectCollection#isSimilar для определения, схожи ли элементы управления или их коллекции
* `Новое` Глобальный метод "currentComponent", используемый для получения информации о названии текущего активного компонента
* `Исправление` Ошибка, из-за которой проект не мог быть корректно скомпилирован в некоторых средах из-за отката на предыдущую версию
* `Исправление` Исключение "непримитивное значение", которое могло возникать при вызове несуществующих методов
* `Исправление` Ошибка, из-за которой ярлыки скриптов не могли быть корректно добавлены на некоторых устройствах (промежуточное исправление) _[`issue #221`](http://issues.autojs6.com/221)_
* `Исправление` Ошибка ограничения типа параметров для методов automator.click/longClick _[`issue #275`](http://issues.autojs6.com/275)_
* `Исправление` Ошибка, из-за которой селекторы не поддерживали параметры типа ConsString _[`issue #277`](http://issues.autojs6.com/277)_
* `Исправление` Ошибка, из-за которой экземпляры UiObjectCollection теряли собственные методы и свойства
* `Улучшение` Страница упаковки поддерживает настройку подписи, управление хранилищем ключей и настройку разрешений (автор [luckyloogn]()) _[`pr #286`]()_
* `Улучшение` Улучшена точность распознавания текущего имени пакета и имени активности для плавающего окна (приоритет: Shizuku > Root > A11Y)
* `Улучшение` Улучшена точность распознавания currentPackage и currentActivity (приоритет: Shizuku > Root > A11Y)
* `Улучшение` Восстановлена возможность выбора текста в отдельных записях в окне лога двойным щелчком или длительным нажатием _[`issue #280`](http://issues.autojs6.com/280)_
* `Улучшение` Максимальное восстановление ключевой информации для проектов скриптов в случае повреждения файла project.json
* `Улучшение` Автоматическая конвертация упрощенного китайского в пиньинь (включая многозначные символы) для суффиксов пакетов, создаваемых при упаковке отдельных файлов
* `Улучшение` Поддержка отрицательных аргументов в методах UiSelector#findOnce и UiSelector#find
* `Улучшение` Улучшена адаптивность методов app.startActivity/startDualActivity
* `Улучшение` Поддержка дополнительных сокращённых форм префиксов имён пакетов в селекторах, связанных с элементами UI и className (например, RecyclerView, Snackbar и т. д.)
* `Улучшение` Синхронизировать последний код из официального репозитория Rhino и адаптировать его к существующему проекту
* `Улучшение` Изменения версий некоторых зависимостей или локальных библиотек _[`CHANGELOG.md`](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG.md#v661)_

##### Для получения более подробной информации о версиях см. раздел

* [CHANGELOG.md](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG-ru.md)

******

### <a id="project-compilation-and-build"></a>Компиляция и сборка проекта

******

Для отладки или разработки проекта AutoJs6 с открытым исходным кодом можно использовать [Android Studio](https://pro.autojs.org/) (продукт компании [Google](https://www.google.com/)) или [IntelliJ IDEA](https://www.jetbrains.com/idea/) (продукт компании [Jetbrains](https://www.jetbrains.com/)).

В данном разделе приведён пример методов компиляции и сборки для проекта AutoJs6 с использованием Android Studio. IntelliJ IDEA аналогичен.

#### Подготовка Android Studio

Скачайте версию `Android Studio Meerkat Feature Drop | 2024.3.2` (выберите одну из них по необходимости):

- [android-studio-2024.3.2.14-windows.exe](https://redirector.gvt1.com/edgedl/android/studio/install/2024.3.2.14/android-studio-2024.3.2.14-windows.exe) (1.23 GB)
- [android-studio-2024.3.2.14-windows.zip](https://redirector.gvt1.com/edgedl/android/studio/ide-zips/2024.3.2.14/android-studio-2024.3.2.14-windows.zip) (1.23 GB)

> Примечание: Указанная версия была выпущена 6 May 2025 года. Для загрузки других версий или если указанная ссылка недействительна, посетите страницу [архива версий Android Studio](https://developer.android.com/studio/archive?hl=en).

Установите или распакуйте указанные файлы, запустите программное обеспечение Android Studio (например, `"D:\android-studio\bin\studio64.exe"`).

#### Подготовка Android SDK

> Примечание: Если на компьютере уже установлен Android SDK, раздел может быть пропущен.

Используйте сочетание клавиш `CTRL + ALT + S` для открытия страницы настроек в Android Studio:

```text
Appearance & Behavior (Внешний вид и поведение) -> 
System Settings (Системные настройки) -> 
Android SDK (Набор инструментов для разработки Android)
```

Если поле `Местоположение Android SDK (место расположения пакета SDK для Android)` пустое, нажмите кнопку `Редактировать (Edit)` справа и несколько раз нажимайте `Далее (Next)` в появившемся окне.

> Примечание: В процессе может потребоваться согласие с одним или несколькими соответствующими соглашениями для продолжения.

После завершения загрузки и установки соответствующих ресурсов нажмите кнопку `Завершить (Finish)`.  
Местоположение `Android SDK (место расположения пакета SDK для Android)` будет заполнено автоматически, что завершит подготовку SDK.

#### Подготовка инструментов Android SDK

Для работы AutoJs6 требуются некоторые инструменты SDK (например, NDK и CMake).

> Примечание: Если на компьютере уже установлены все необходимые инструменты Android SDK для AutoJs6, раздел может быть пропущен.

Используйте сочетание клавиш `CTRL + ALT + S` для открытия страницы настроек в Android Studio:

```text
Appearance & Behavior (Внешний вид и поведение) -> 
System Settings (Системные настройки) -> 
Android SDK (Набор инструментов для разработки Android) -> 
SDK Tools (SDK Инструменты) (находится в правом окне)
```

Отметьте `Show Package Details (Показать детали пакета)`, затем последовательно выберите NDK и CMake, убедитесь, что соответствующие версии инструментов отмечены, Информация о версиях инструментов SDK находится в файле `version.properties` в корневом каталоге проекта AutoJs6.

#### Подготовка JDK

Для проекта AutoJs6 требуется версия `JDK (Java Development Kit)` не ниже `17`, но рекомендуется не ниже `19`.

По состоянию на 27 May 2025 года AutoJs6 поддерживает JDK максимальной версии `24`.

> Примечание: Если на компьютере уже установлен JDK и версия соответствует указанным требованиям, этот раздел можно пропустить.

JDK можно скачать непосредственно через IDE или на [сайте Oracle](https://www.oracle.com/java/technologies/downloads/).

В программном обеспечении Android Studio используйте сочетание клавиш `CTRL + ALT + S` для открытия страницы настроек:

```text
Build, Execution, Deployment (Сборка, выполнение, развертывание) -> 
Build Tools (Инструменты сборки) -> 
Gradle
```

В разделе `Gradle JDK` можно выбрать или добавить разные версии JDK.

Если в списке уже существует подходящая версия JDK (>= `17`), выберите её напрямую.  
Либо можно выбрать `Download JDK` для загрузки соответствующего JDK, нажмите кнопку `Download` и дождитесь завершения загрузки.  
Вы также можете выбрать `Add JDK` и добавить уже установленный JDK, указав его путь, для завершения добавления JDK.

#### Клонирование ресурсов AutoJs6

На главной странице Android Studio нажмите кнопку `Get from VCS`.  
В поле `URL` введите `https://github.com/SuperMonster003/AutoJs6.git`,  
В поле `Directory` можно указать нужный путь.  
Нажмите кнопку `Clone`, и дождитесь, пока ресурсы проекта AutoJs6 склонируются на вашем устройстве.

> Примечание: В процессе может потребоваться установка [Git (система управления версиями)](https://git-scm.com/download).

#### Сборка проекта AutoJs6

После завершения клонирования Android Studio откроет окно проекта AutoJs6 и автоматически загрузит начальные зависимости `Dependencies` и выполнит сборку Gradle.

> Примечание: Процесс может занять много времени. При плохом состоянии сети возможно потребуется несколько попыток (нажмите кнопку Retry).

Если сборка не может быть выполнена автоматически или вам нужно пересобрать проект, выполните следующие шаги:

- В меню `Run/Debug Configurations` на панели инструментов выберите `app`, это основное приложение AutoJs6
- Нажмите кнопку `Build Project` (иконка молотка) слева, чтобы начать сборку проекта. Стандартное сочетание клавиш — CTRL + F9
- Дождитесь завершения сборки. Во вкладке `Builder Output` появится сообщение вроде "BUILD SUCCESSFUL in 1h 17m 34s"

Если сборка не удалась, вы можете сообщить об ошибке на странице [Issues](http://issues.autojs6.com) проекта AutoJs6.

> Примечание: Для получения дополнительной информации о том, как собрать и запустить приложение, смотрите [Android Docs](https://developer.android.com/studio/run?hl=en)

#### Развертывание проекта AutoJs6 (Запуск приложения)

После успешной сборки проекта его можно развернуть как приложение (App) на физическом устройстве (например, телефон/планшет) или на виртуальном устройстве (например, Android-эмулятор).

- На панели инструментов выберите `app` в меню `Run/Debug Configurations`, это основное приложение AutoJs6
- В выпадающем списке `Available Devices` справа выберите устройство, на котором должно запускаться приложение проекта (физическое или виртуальное)
- Нажмите кнопку `Run` (иконка треугольника) справа, чтобы запустить приложение. Стандартное сочетание клавиш — `F10`
- Дождитесь завершения развертывания; выбранное устройство автоматически установит и запустит приложение проекта

#### Развертывание проекта AutoJs6 (Создание APK)

Упакуйте проект и создайте APK-файл, который можно установить на устройства Android:

- Отладочная версия (Debug Version)
    - `Build (Сборка)` -> `Build Bundle(s) / APK(s)` -> `Build APK(s)`
    - Создание APK файла с отладочной подписью
    - Пример пути: `"D:\AutoJs6\app\build\outputs\apk\debug\"`
- Релизная версия (Release Version)
    - `Build (Сборка)` -> `Generate Signed Bundle / APK`
    - Выберите опцию `APK`
    - Подготовьте файл подписи (создайте или выберите), создайте подписанный релизный APK файл
    - Пример пути: `"D:\AutoJs6\app\release\"`

> Примечание: Для получения дополнительной информации о том, как собрать приложение для выпуска, смотрите [Android Docs](https://developer.android.com/build/build-for-release?hl=en)

#### Предопределенные задачи сборки Gradle для AutoJs6

Помимо сборки приложения проекта, AutoJs6 поддерживает несколько предопределенных задач сборки Gradle, которые помогают разработчикам выполнять удобные операции, связанные с проектом.

В меню `Run/Debug Configurations` на панели инструментов вы можете увидеть различные предопределенные задачи Gradle, каждая из которых имеет значок слона слева.

- AutoJs6 [inrt:assemble]

Соберите вариант сборки "inrt", который в первую очередь предназначен для функции упаковки скриптов AutoJs6.

Проект AutoJs6 имеет различные варианты сборки. Вариант "inrt" используется для упаковки скриптов, создавая шаблонный файл "template.apk", необходимый для упаковки.

При использовании функции упаковки может возникнуть следующая ошибка:

> java.io.FileNotFoundException: template.apk

Это указывает на то, что шаблонный файл отсутствует. Вы должны вручную запустить задачу `inrt:assemble`, чтобы создать шаблонный файл, а затем пересобрать и повторно развернуть приложение.

> Примечание: Если изменяется код основного проекта и необходимо синхронизировать эти изменения с упакованным приложением, требуется повторно запустить задачу `inrt:assemble` для генерации шаблонных файлов и повторного развёртывания приложения

- AutoJs6 [app:bundle]

Упакуйте артефакты сборки в режиме отладки, в первую очередь для проекта [определений AutoJs6](http://dts-project.autojs6.com).

После выполнения задачи генерируется последний JAR-файл проекта AutoJs6. С помощью инструмента [Android d.ts Generator](https://github.com/NativeScript/android-dts-generator) (от [NativeScript](https://github.com/NativeScript)) вы можете создать файлы определений типов (в формате d.ts) для основного приложения AutoJs6.

- AutoJs6 [app:digest]

Добавьте сводную информацию в APK, созданный релизной сборкой, что в первую очередь помогает определить финальное название файла перед публикацией последней версии AutoJs6 на GitHub.

Ниже приведено сравнение имен файлов до и после добавления сводной информации:

```text
До:
autojs6-v6.6.2-arm64-v8a.apk
После:
autojs6-v6.6.2-arm64-v8a-0f2a9d74.apk
```

> смотрите: [Android Docs](https://developer.android.com/studio/run?hl=zh-cn)

******

### <a id="script-development-assistance"></a>Помощь в разработке скриптов

******

Для разработки скриптов, работающих в AutoJs6, используйте соответствующую среду разработки:

- [VSCode](https://code.visualstudio.com/download) / [WebStorm](https://www.jetbrains.com/webstorm/download/) / [HBuilderX](https://www.dcloud.io/hbuilderx.html) ...

Для написания и отладки скриптов на ПК, плагин VSCode может обеспечить связь между ПК и телефоном:

- [AutoJs6-VSCode-Extension](http://vscext-project.autojs6.com) - Отладчик AutoJs6 (плагин для платформы VSCode)

При написании кода в среде разработки функция автодополнения кода может значительно облегчить процесс разработки:

- [AutoJs6-TypeScript-Declarations](http://dts-project.autojs6.com) - Файлы объявлений AutoJs6 (автодополнение кода)

При написании кода вы можете в любой момент обращаться к документации по API и способам использования AutoJs6:

- [AutoJs6-Documentation](http://docs-project.autojs6.com) - Документация приложения AutoJs6

Существующие проекты по разработке скриптов могут служить источником вдохновения для вашего собственного проекта:

- [Ant-Forest](https://github.com/TonyJiangWJ/Ant-Forest) - Скрипт для автоматической работы с энергией в Ант Форест от [TonyJiangWJ](https://github.com/TonyJiangWJ)
- [Ant-Forest](https://github.com/SuperMonster003/Ant-Forest) - Скрипт для автоматической работы с энергией в Ант Форест от [SuperMonster003](https://github.com/SuperMonster003)
- [autojs](https://github.com/e1399579/autojs) - Утилиты для Auto.js от [e1399579](https://github.com/e1399579)
- [autojsDemo](https://github.com/snailuncle/autojsDemo) - Демонстрационные примеры Auto.js от [snailuncle](https://github.com/snailuncle)
- [Связанные репозитории autojs](https://github.com/topics/autojs) - Все репозитории на GitHub с темой autojs

******

### Вклад участников

******

Благодарим всех участников проекта AutoJs6 за их вклад.

|         <span style="word-break:keep-all;white-space:nowrap">Участники</span>          |                   <span style="word-break:keep-all;white-space:nowrap">Количество коммитов</span>                    | <span style="word-break:keep-all;white-space:nowrap">Последние коммиты</span> |
|:-------------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------:|
|             <span style="word-break:keep-all;white-space:nowrap">[wirsnow](https://github.com/wirsnow)</span>             |         <span style="word-break:keep-all;white-space:nowrap">[1](https://github.com/SuperMonster003/AutoJs6/commits?author=wirsnow)</span>         |                    <span style="word-break:keep-all;white-space:nowrap">`2025/05/19`</span>                    |
|         <span style="word-break:keep-all;white-space:nowrap">[TonyJiangWJ](https://github.com/TonyJiangWJ)</span>         |       <span style="word-break:keep-all;white-space:nowrap">[5](https://github.com/SuperMonster003/AutoJs6/commits?author=TonyJiangWJ)</span>       |                    <span style="word-break:keep-all;white-space:nowrap">`2025/04/24`</span>                    |
|          <span style="word-break:keep-all;white-space:nowrap">[luckyloogn](https://github.com/luckyloogn)</span>          |       <span style="word-break:keep-all;white-space:nowrap">[3](https://github.com/SuperMonster003/AutoJs6/commits?author=luckyloogn)</span>        |                    <span style="word-break:keep-all;white-space:nowrap">`2025/01/01`</span>                    |
|                <span style="word-break:keep-all;white-space:nowrap">[kvii](https://github.com/kvii)</span>                |          <span style="word-break:keep-all;white-space:nowrap">[1](https://github.com/SuperMonster003/AutoJs6/commits?author=kvii)</span>           |                    <span style="word-break:keep-all;white-space:nowrap">`2024/10/16`</span>                    |
|   <span style="word-break:keep-all;white-space:nowrap">[chenguangming](https://github.com/chenguangming) `(Tom)`</span>   | <span style="word-break:keep-all;white-space:nowrap">[2](https://github.com/SuperMonster003/AutoJs6/pulls?q=is%3Apr+author%3Achenguangming)</span> |                    <span style="word-break:keep-all;white-space:nowrap">`2024/05/14`</span>                    |
|          <span style="word-break:keep-all;white-space:nowrap">[LZX284](https://github.com/LZX284) `(AI)`</span>           |         <span style="word-break:keep-all;white-space:nowrap">[17](https://github.com/SuperMonster003/AutoJs6/commits?author=LZX284)</span>         |                    <span style="word-break:keep-all;white-space:nowrap">`2023/11/19`</span>                    |
| <span style="word-break:keep-all;white-space:nowrap">[little&#x2011;alei](https://github.com/little-alei) `(抠脚本人)`</span> |      <span style="word-break:keep-all;white-space:nowrap">[12](https://github.com/SuperMonster003/AutoJs6/commits?author=little-alei)</span>       |                    <span style="word-break:keep-all;white-space:nowrap">`2023/07/12`</span>                    |
|              <span style="word-break:keep-all;white-space:nowrap">[aiselp](https://github.com/aiselp)</span>              |    <span style="word-break:keep-all;white-space:nowrap">[6](https://github.com/SuperMonster003/AutoJs6/pulls?q=is%3Apr+author%3Aaiselp)</span>     |                    <span style="word-break:keep-all;white-space:nowrap">`2023/06/14`</span>                    |
|           <span style="word-break:keep-all;white-space:nowrap">[LYS86](https://github.com/LYS86) `(Lin)`</span>           |          <span style="word-break:keep-all;white-space:nowrap">[2](https://github.com/SuperMonster003/AutoJs6/commits?author=LYS86)</span>          |                    <span style="word-break:keep-all;white-space:nowrap">`2023/06/03`</span>                    |

Данные обновлены на 27 May 2025 года.

Данные отсортированы по `последним отправкам` в порядке убывания.

Новые необработанные Pull Request будут учтены в статистике после объединения.

Некоторые участники не отображаются на [GitHub Contributors](https://github.com/SuperMonster003/AutoJs6/graphs/contributors), их записи пусты, но их вклад можно посмотреть через [Pull Request](https://github.com/SuperMonster003/AutoJs6/pulls).

[//]: # (
    # --------------------------------------------------------------#
    # Before committing and pushing to the remote GitHub repository #
    # --------------------------------------------------------------#
    - IDE
        - The summary of the latest changelog for committing to Git [ DO NOT commit or push ]
    - $projectDir/version.properties
        - Remove the part like [ alpha / beta / ... ] of VERSION_NAME
    - $projectDir/.changelog/lang_zh-Hans.json
        - Update version name and released date
        - Translate into other languages
        - Update TypeScript declarations according to section `dependency` if needed
    - $projectDir/.readme/template_readme.md
        - Update badges like [ android studio / rhino / ... ]
        - Update contribution section: Вклад участников
    - $projectDir/.readme/common.json
        - Update android studio download links and version names
        - Update contribution section: var_date_contribution_table_data_updated
    - $projectDir/.python/generate_markdown.py
        - Re-generate markdown by running the python script [ link: aj6mdgen ]
    - Others
        - Re-generate documentation by running the python script [ link: aj6docgen ]
        - Check the two-way versions for AutoJs6 and VSCode ext, then publish the ext to Microsoft if needed
        - Run Gradle task "app:assembleInrtRelease" [ shortcut: C+A+0#- ]
        - Build APK to determine the final VERSION_BUILD field [ shortcut: C+A+0#A ]
        - Run Gradle task "app:appendDigestToReleasedFiles" [ shortcut: C+A+0#= ]
        - Check VERSION_BUILD in version.properties with released apks
        - Commit and push to GitHub
        - Publish the latest release with signed APKs
)