/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import jdk.dynalink.StandardNamespace;
import jdk.dynalink.StandardOperation;
import jdk.dynalink.linker.GuardedInvocation;
import jdk.dynalink.linker.LinkRequest;
import jdk.dynalink.linker.LinkerServices;
import jdk.dynalink.linker.TypeBasedGuardingDynamicLinker;
import jdk.dynalink.linker.support.Guards;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.optimizer.DefaultLinker;
import org.mozilla.javascript.optimizer.ParsedOperation;
import org.mozilla.javascript.optimizer.RhinoOperation;

class BaseFunctionLinker
implements TypeBasedGuardingDynamicLinker {
    BaseFunctionLinker() {
    }

    @Override
    public boolean canLinkType(Class<?> type) {
        return BaseFunction.class.isAssignableFrom(type);
    }

    @Override
    public GuardedInvocation getGuardedInvocation(LinkRequest req, LinkerServices svc) throws Exception {
        if (req.isCallSiteUnstable()) {
            return null;
        }
        ParsedOperation op = new ParsedOperation(req.getCallSiteDescriptor().getOperation());
        MethodHandle mh = null;
        MethodHandle guard = null;
        if (op.isNamespace(StandardNamespace.PROPERTY) && op.isOperation(StandardOperation.GET, RhinoOperation.GETNOWARN) && "prototype".equals(op.getName())) {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodType mType = req.getCallSiteDescriptor().getMethodType();
            mh = lookup.findStatic(BaseFunctionLinker.class, "getPrototype", mType);
            guard = Guards.getInstanceOfGuard(BaseFunction.class);
        }
        if (mh != null) {
            assert (guard != null);
            if (DefaultLinker.DEBUG) {
                System.out.println(op + " base function operation");
            }
            return new GuardedInvocation(mh, guard);
        }
        return null;
    }

    private static Object getPrototype(Object o, Context cx, Scriptable scope) {
        return ((BaseFunction)o).getPrototypeProperty();
    }
}

