/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Hashtable;
import org.mozilla.javascript.IteratorLikeIterable;
import org.mozilla.javascript.LambdaConstructor;
import org.mozilla.javascript.LambdaFunction;
import org.mozilla.javascript.NativeCollectionIterator;
import org.mozilla.javascript.NativeMap;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.ScriptRuntimeES6;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SymbolKey;
import org.mozilla.javascript.Undefined;

public class NativeSet
extends ScriptableObject {
    private static final long serialVersionUID = -8442212766987072986L;
    private static final String CLASS_NAME = "Set";
    static final String ITERATOR_TAG = "Set Iterator";
    static final SymbolKey GETSIZE = new SymbolKey("[Symbol.getSize]");
    private final Hashtable entries = new Hashtable();
    private boolean instanceOfSet = false;

    static Object init(Context cx, Scriptable scope, boolean sealed) {
        LambdaConstructor constructor = new LambdaConstructor(scope, CLASS_NAME, 0, 2, NativeSet::jsConstructor);
        constructor.setPrototypePropertyAttributes(7);
        constructor.definePrototypeMethod(scope, "add", 1, (lcx, lscope, thisObj, args) -> NativeSet.realThis(thisObj, "add").js_add(NativeMap.key(args)), 2, 3);
        constructor.definePrototypeMethod(scope, "delete", 1, (lcx, lscope, thisObj, args) -> NativeSet.realThis(thisObj, "delete").js_delete(NativeMap.key(args)), 2, 3);
        constructor.definePrototypeMethod(scope, "has", 1, (lcx, lscope, thisObj, args) -> NativeSet.realThis(thisObj, "has").js_has(NativeMap.key(args)), 2, 3);
        constructor.definePrototypeMethod(scope, "clear", 0, (lcx, lscope, thisObj, args) -> NativeSet.realThis(thisObj, "clear").js_clear(), 2, 3);
        constructor.definePrototypeMethod(scope, "values", 0, (lcx, lscope, thisObj, args) -> NativeSet.realThis(thisObj, "values").js_iterator(scope, NativeCollectionIterator.Type.VALUES), 2, 3);
        constructor.definePrototypeAlias("values", "keys", 3);
        constructor.definePrototypeAlias("values", SymbolKey.ITERATOR, 2);
        constructor.definePrototypeMethod(scope, "forEach", 1, (lcx, lscope, thisObj, args) -> NativeSet.realThis(thisObj, "forEach").js_forEach(lcx, lscope, NativeMap.key(args), args.length > 1 ? args[1] : Undefined.instance), 2, 3);
        constructor.definePrototypeMethod(scope, "entries", 0, (lcx, lscope, thisObj, args) -> NativeSet.realThis(thisObj, "entries").js_iterator(scope, NativeCollectionIterator.Type.BOTH), 2, 3);
        ScriptableObject desc = (ScriptableObject)cx.newObject(scope);
        desc.put("enumerable", (Scriptable)desc, (Object)Boolean.FALSE);
        desc.put("configurable", (Scriptable)desc, (Object)Boolean.TRUE);
        LambdaFunction sizeFunc = new LambdaFunction(scope, "get size", 0, (lcx, lscope, thisObj, args) -> NativeSet.realThis(thisObj, "size").js_getSize());
        sizeFunc.setPrototypeProperty(Undefined.instance);
        desc.put("get", (Scriptable)desc, (Object)sizeFunc);
        constructor.definePrototypeProperty(cx, "size", desc);
        constructor.definePrototypeProperty(cx, GETSIZE, desc);
        constructor.definePrototypeProperty(SymbolKey.TO_STRING_TAG, (Object)CLASS_NAME, 3);
        ScriptRuntimeES6.addSymbolSpecies(cx, scope, constructor);
        if (sealed) {
            constructor.sealObject();
        }
        return constructor;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    private static Scriptable jsConstructor(Context cx, Scriptable scope, Object[] args) {
        NativeSet ns = new NativeSet();
        ns.instanceOfSet = true;
        if (args.length > 0) {
            NativeSet.loadFromIterable(cx, scope, ns, NativeMap.key(args));
        }
        return ns;
    }

    private Object js_add(Object k) {
        Object key = k;
        if (key instanceof Number && ((Number)key).doubleValue() == ScriptRuntime.negativeZero) {
            key = ScriptRuntime.zeroObj;
        }
        this.entries.put(key, key);
        return this;
    }

    private Object js_delete(Object arg) {
        return this.entries.deleteEntry(arg);
    }

    private Object js_has(Object arg) {
        return this.entries.has(arg);
    }

    private Object js_clear() {
        this.entries.clear();
        return Undefined.instance;
    }

    private Object js_getSize() {
        return this.entries.size();
    }

    private Object js_iterator(Scriptable scope, NativeCollectionIterator.Type type) {
        return new NativeCollectionIterator(scope, ITERATOR_TAG, type, this.entries.iterator());
    }

    private Object js_forEach(Context cx, Scriptable scope, Object arg1, Object arg2) {
        if (!(arg1 instanceof Callable)) {
            throw ScriptRuntime.notFunctionError(arg1);
        }
        Callable f = (Callable)arg1;
        boolean isStrict = cx.isStrictMode();
        for (Hashtable.Entry entry : this.entries) {
            Scriptable thisObj = ScriptRuntime.toObjectOrNull(cx, arg2, scope);
            if (thisObj == null && !isStrict) {
                thisObj = scope;
            }
            if (thisObj == null) {
                thisObj = Undefined.SCRIPTABLE_UNDEFINED;
            }
            Hashtable.Entry e = entry;
            f.call(cx, scope, thisObj, new Object[]{e.value, e.value, this});
        }
        return Undefined.instance;
    }

    static void loadFromIterable(Context cx, Scriptable scope, ScriptableObject set, Object arg1) {
        if (arg1 == null || Undefined.instance.equals(arg1)) {
            return;
        }
        Object ito = ScriptRuntime.callIterator(arg1, cx, scope);
        if (Undefined.instance.equals(ito)) {
            return;
        }
        ScriptableObject dummy = NativeSet.ensureScriptableObject(cx.newObject(scope, set.getClassName()));
        Callable add = ScriptRuntime.getPropFunctionAndThis(dummy.getPrototype(), "add", cx, scope);
        ScriptRuntime.lastStoredScriptable(cx);
        try (IteratorLikeIterable it = new IteratorLikeIterable(cx, scope, ito);){
            for (Object val : it) {
                Object finalVal = val == Scriptable.NOT_FOUND ? Undefined.instance : val;
                add.call(cx, scope, set, new Object[]{finalVal});
            }
        }
    }

    private static NativeSet realThis(Scriptable thisObj, String name) {
        NativeSet ns = LambdaConstructor.convertThisObject(thisObj, NativeSet.class);
        if (!ns.instanceOfSet) {
            throw ScriptRuntime.typeErrorById("msg.incompat.call", name);
        }
        return ns;
    }
}

