/*
 * Decompiled with CFR 0.152.
 */
package eu.medsea.mimeutil;

import eu.medsea.mimeutil.MimeType;
import eu.medsea.util.EncodingGuesser;

public class TextMimeType
extends MimeType {
    private static final long serialVersionUID = -4798584119063522367L;
    private String encoding = "Unknown";

    public TextMimeType(String mimeType, String encoding) {
        super(mimeType);
        this.encoding = this.getValidEncoding(encoding);
    }

    public TextMimeType(MimeType mimeType, String encoding) {
        super(mimeType);
        this.encoding = this.getValidEncoding(encoding);
    }

    public TextMimeType(MimeType mimeType) {
        super(mimeType);
    }

    public void setMimeType(MimeType mimeType) {
        this.type = mimeType.type;
        this.subtype = mimeType.subtype;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String toString() {
        return super.toString() + ";charset=" + this.getEncoding();
    }

    private boolean isKnownEncoding(String encoding) {
        return EncodingGuesser.isKnownEncoding(encoding);
    }

    private String getValidEncoding(String encoding) {
        if (this.isKnownEncoding(encoding)) {
            return encoding;
        }
        return "Unknown";
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setSubtype(String subtype) {
        this.subtype = subtype;
    }
}

