## 顏色搜尋

顏色搜尋支援以下 5 種搜尋方式, 所有方式均不區分大小寫.

### 1. 顏色名稱 (當前語言)

以當前語言顯示的顏色名稱作為關鍵字的搜尋方式.

#### 示例 1.1: 紅

可匹配全部顏色名稱中包含 "紅" 的顏色, 如 "紅", "緋紅", "紅寶石", "紅 (200)" 等.

#### 示例 1.2: 藍50

可匹配全部顏色名稱中包含 "藍50" 的顏色, 匹配時會忽略所有 "非字母或數字字元", 如 [空格/括號/斜槓/連字元] 等. 因此 "藍50" 可以匹配 "藍 (50)", "藍 (500)" 以及 "淺藍 (50)" 等, 但不可以匹配 "藍綠 (50)", 因為 "綠" 不可被忽略.

### 2. 顏色名稱 (英文)

以 "$" 開頭, 啟用英文顏色名稱搜尋方式.

#### 示例 2.1: $red

可匹配全部英文顏色名稱中包含 "red" 的顏色, 如 "紅", "鮮紅", "橙紅" 等. 即使當前顯示語言並非英語, 也可透過英文關鍵字搜尋到對應的顏色.

#### 示例 2.2: $blue50

同示例 1.2, 可匹配 "藍 (50)", "藍 (500)" 以及 "淺藍 (50)" 等.

### 3. HEX

以 "#" 開頭, 啟用 HEX 搜尋方式.

#### 示例 3.1: #FF007F

可匹配 HEX 為 "#FF007F" 的 "玫瑰紅" 顏色.

#### 示例 3.2: #FF

可匹配所有 HEX 以 "#FF" 開頭的顏色, 如 "#FF8099", "#FF00CB", "#FFFAFA" 等.

### 4. 正則表示式

以 "/" 開頭, 以 "/" 結尾, 啟用正則表示式搜尋方式, 類似 JavaScript 語法.

#### 示例 4.1: /紅|橙|黃/

可匹配所有顏色名稱中包含 "紅" 或 "橙" 或 "黃" 的顏色.

#### 示例 4.2: /\b50\b/

可匹配所有顏色名稱中包含 50 且前後均有分詞邊界的顏色, 如 "紅 (50)", "粉 (50)", "黃 (50)" 等, 但不包含 "紅 (500)", "粉 (500)" 等.

#### 示例 4.3: /石\B/

可匹配所有顏色名稱中包含 "石" 但不以其作為分詞結尾邊界的顏色, 如 "紅雀石綠", "尖晶石紅" 等, 但不包含 "綠松石", "紅寶石" 等.

#### 示例 4.4: /^[\u4e00-\u9fff]{5}$/

可匹配所有顏色名稱中恰好包含且僅包含 5 個常用漢字的顏色, 如 "薰衣草紫紅", "勃艮第酒紅", "橄欖軍服綠" 等.

#### 示例 4.5: /red|orange/

類似示例 2.2, 正則表示式也會匹配英文名稱顏色. /red|orange/ 可匹配 "鮮紅", "燃橙", "灰紫紅" 等.

### 5. HEX 正則表示式

以 "#/" 開頭, 以 "/" 結尾, 啟用 HEX 正則表示式搜尋方式.

#### 示例 5.1: #/FF\b/

可匹配所有 HEX 包含 "FF" 且作為分詞結尾邊界的顏色, 可表示為 "#xxxxFF". 如 "#2962FF", "#D94DFF", "#F0F8FF" 等.

#### 示例 5.2: #/#FF/

可匹配所有 HEX 包含 "#FF" 的顏色, 與示例 3.2 效果完全相同, 可表示為 "#FFxxxx".

#### 示例 5.3: #/#..FF/

可匹配所有 HEX "中間" 包含 "FF" 的顏色, 可表示為 "#xxFFxx". 如 "#CCFF00", "#66FFE6", "#00FF7F" 等.

#### 示例 5.4: #/#((?<!0).){2}0000/

可匹配所有 HEX 僅包含紅色分量的顏色, 可表示為 "#xx0000" (排除黑色). 如 "#8B0000", "#D50000", "#FF0000" 等.

#### 示例 5.5: #/#0000(.(?!0)){2}/

可匹配所有 HEX 僅包含藍色分量的顏色, 可表示為 "#0000xx" (排除黑色). 如 "#00008B", "#0000CD", "#0000FF" 等.

#### 示例 5.6: #/#00((?!0).)(.(?<!0))00/

可匹配所有 HEX 僅包含綠色分量的顏色, 可表示為 "#00xx00" (排除黑色). 如 "#006400", "#00FF00" 等.