## 색상 검색

색상 검색은 다음의 5가지 방식을 지원합니다. 모든 방식은 대소문자를 구분하지 않습니다.

### 1. 색상 이름 (현재 언어)

현재 언어로 표시되는 색상 이름을 검색 키워드로 사용합니다.

#### 예시 1.1: 레드

"레드" 을 포함하는 모든 색상 이름과 일치합니다. 예: "레드", "다크 레드", "스피넬 레드", "레드 (200)" 등.

#### 예시 1.2: 블루50

"블루50" 을 포함하는 모든 색상 이름과 일치합니다. 이때 공백, 괄호, 슬래시, 하이픈 등의 영숫자가 아닌 문자는 무시됩니다. 따라서 "블루50"은 "블루 (50)", "블루 (500)" 과 일치할 수 있지만, "블루 그레이 (50)" 은 "그레이" 이 무시될 수 없으므로 일치하지 않습니다.

### 2. 색상 이름 (영어)

"$" 로 시작하여 영어 색상 이름 검색 모드를 활성화합니다.

#### 예시 2.1: $red

"red" 를 포함하는 모든 영어 색상 이름과 일치합니다. 예: "레드", "다크 레드", "스피넬 레드" 등. 현재 언어가 영어가 아니더라도, 영어 키워드를 통해 해당 색상을 검색할 수 있습니다.

#### 예시 2.2: $blue50

예시 1.2 와 동일하게 "블루 (50)", "블루 (500)", "밝은 파란색 (50)" 등에 일치합니다.

### 3. HEX

"#" 로 시작하면 HEX 검색 모드가 활성화됩니다.

#### 예시 3.1: #FF007F

HEX 가 "#FF007F" 인 색상과 일치합니다. 예: "로즈".

#### 예시 3.2: #FF

HEX 가 "#FF" 로 시작하는 모든 색상과 일치합니다. 예: "#FF8099", "#FF00CB", "#FFFAFA" 등.

### 4. 정규 표현식

"/" 로 시작하고 "/" 로 끝나면 JavaScript 와 유사한 정규 표현식 검색 모드가 활성화됩니다.

#### 예시 4.1: /레드|오렌지|옐로우/

"레드", "오렌지", "옐로우" 을 포함하는 모든 색상 이름과 일치합니다.

#### 예시 4.2: /\b50\b/

양옆에 단어 구분이 있는 "50" 을 포함하는 모든 색상 이름과 일치합니다. 예: "레드 (50)", "핑크 (50)", "옐로우 (50)" 등. "레드 (500)"이나 "핑크 (500)" 등은 일치하지 않습니다.

#### 예시 4.3: /red|orange/

예시 2.2 와 유사하게, 정규 표현식 또한 영어 색상 이름에 일치합니다. /red|orange/ 는 "스트롱 레드", "번트 오렌지", "페일 바이올렛 레드" 등을 일치시킬 수 있습니다.

### 5. HEX 정규 표현식

"#/" 로 시작하고 "/"로 끝나면, HEX 에 대한 정규 표현식 검색 모드가 활성화됩니다.

#### 예시 5.1: #/FF\b/

단어 경계로 끝나는 "FF" 를 포함하는 모든 HEX 에 일치합니다 (형태: "#xxxxFF"). 예: "#2962FF", "#D94DFF", "#F0F8FF" 등.

#### 예시 5.2: #/#FF/

"#FF" 를 포함하는 모든 HEX 에 일치합니다. 예시 3.2 와 동일한 효과로 "#FFxxxx" 형태입니다.

#### 예시 5.3: #/#..FF/

중간에 "FF" 가 있는 모든 HEX 에 일치합니다 (형태: "#xxFFxx"). 예: "#CCFF00", "#66FFE6", "#00FF7F" 등.

#### 예시 5.4: #/#((?<!0).){2}0000/

빨간색 성분만 포함하는 HEX 에 일치합니다 (형태: "#xx0000"). 검정색은 제외됩니다. 예: "#8B0000", "#D50000", "#FF0000" 등.

#### 예시 5.5: #/#0000(.(?!0)){2}/

파란색 성분만 포함하는 HEX 에 일치합니다 (형태: "#0000xx"). 검정색은 제외됩니다. 예: "#00008B", "#0000CD", "#0000FF" 등.

#### 예시 5.6: #/#00((?!0).)(.(?<!0))00/

초록색 성분만 포함하는 HEX 에 일치합니다 (형태: "#00xx00"). 검정색은 제외됩니다. 예: "#006400", "#00FF00" 등.