## بحث الألوان

يدعم البحث عن الألوان خمسة أساليب مختلفة، وجميعها لا تميز بين الأحرف الكبيرة والصغيرة.

### 1. اسم اللون (اللغة الحالية)

ابحث باستخدام اسم اللون كما يتم عرضه حاليًا في اللغة الحالية.

#### المثال 1.1: أحمر

يطابق جميع أسماء الألوان التي تحتوي على "أحمر"، مثل "أحمر"، "أحمر برتقالي"، "أحمر قوي"، "أحمر (200)"، إلخ.

#### المثال 1.2: أزرق50

يطابق جميع أسماء الألوان التي تحتوي على "أزرق50". أثناء المطابقة، يتم تجاهل كل الأحرف غير الأبجدية أو الأرقام (مثل المسافات، والأقواس، والشرطات المائلة، والواصلات، إلخ). وبالتالي، يمكن أن يطابق "أزرق50" الألوان "أزرق (50)"، "أزرق (500)"، "الأزرق الفاتح (50)"

### 2. اسم اللون (بالإنجليزية)

ابدأ بـ "$" لتفعيل وضع البحث عن اسم اللون بالإنجليزية.

#### المثال 2.1: $red

يطابق جميع أسماء الألوان بالإنجليزية التي تحتوي على "red"، مثل "أحمر"، "أحمر قوي"، "أحمر برتقالي"، إلخ. حتى إذا لم تكن لغة العرض الحالية هي الإنجليزية، لا يزال بإمكانك البحث عن اللون المقابل باستخدام الكلمة المفتاحية الإنجليزية.

#### المثال 2.2: $blue50

يشبه المثال 1.2، إذ يمكن أن يطابق "أزرق (50)"، "أزرق (500)" و"الأزرق الفاتح (50)"، إلخ.

### 3. HEX

ابدأ بـ "#" لتفعيل وضع البحث بنمط HEX.

#### المثال 3.1: #FF007F

يطابق اللون الذي لديه قيمة HEX "#FF007F"، على سبيل المثال "وردي".

#### المثال 3.2: #FF

يطابق كل الألوان التي تبدأ قيمة HEX الخاصة بها بـ "#FF"، مثل "#FF8099"، "#FF00CB"، "#FFFAFA"، إلخ.

### 4. التعبيرات النمطية (Regular Expression)

ابدأ بـ "/" وأنهِ بـ "/" لتفعيل البحث باستخدام التعبير النمطي (يشبه بناء جملة JavaScript).

#### المثال 4.1: /أحمر|برتقالي|أصفر/

يطابق جميع أسماء الألوان التي تحتوي على "أحمر" أو "برتقالي" أو "أصفر".

#### المثال 4.2: /\b50\b/

يطابق جميع أسماء الألوان التي تحتوي على "50" مع حدود كلمة على كلا الجانبين، مثل "أحمر (50)"، "بينك (50)"، "أصفر (50)"، إلخ، ولكنه لا يشمل "أحمر (500)" أو "بينك (500)"، إلخ.

#### المثال 4.3: /red|orange/

على غرار المثال 2.2، يطابق التعبير النمطي أيضًا أسماء الألوان بالإنجليزية. /red|orange/ يمكنه مطابقة "أحمر قوي"، "برتقالي محترق"، "أحمر بنفسجي باهت"، إلخ.

### 5. التعبيرات النمطية لـ HEX

ابدأ بـ "#/" وأنهِ بـ "/" لتفعيل البحث باستخدام التعبير النمطي على قيم HEX.

#### المثال 5.1: #/FF\b/

يطابق جميع قيم HEX التي تحتوي على "FF" في نهاية الكلمة (مثل "#xxxxFF")، على سبيل المثال "#2962FF"، "#D94DFF"، "#F0F8FF"، إلخ.

#### المثال 5.2: #/#FF/

يطابق جميع قيم HEX التي تحتوي على "#FF"، مماثل للمثال 3.2، بشكل "#FFxxxx".

#### المثال 5.3: #/#..FF/

يطابق جميع قيم HEX التي تحتوي على "FF" في المنتصف (بشكل "#xxFFxx")، مثل "#CCFF00"، "#66FFE6"، "#00FF7F"، إلخ.

#### المثال 5.4: #/#((?<!0).){2}0000/

يطابق جميع قيم HEX التي تحتوي على المكون الأحمر فقط (بشكل "#xx0000")، مع استثناء اللون الأسود. أمثلة: "#8B0000"، "#D50000"، "#FF0000"، إلخ.

#### المثال 5.5: #/#0000(.(?!0)){2}/

يطابق جميع قيم HEX التي تحتوي على المكون الأزرق فقط (بشكل "#0000xx")، مع استثناء اللون الأسود. أمثلة: "#00008B"، "#0000CD"، "#0000FF"، إلخ.

#### المثال 5.6: #/#00((?!0).)(.(?<!0))00/

يطابق جميع قيم HEX التي تحتوي على المكون الأخضر فقط (بشكل "#00xx00")، مع استثناء اللون الأسود. أمثلة: "#006400"، "#00FF00"، إلخ.