package org.autojs.autojs.runtime.api.augment.pinyin

object Dict {

    /* 带声调字符. */
    val PHONETIC_SYMBOL = mapOf(
        "ā" to "a1",
        "á" to "a2",
        "ǎ" to "a3",
        "à" to "a4",
        "ē" to "e1",
        "é" to "e2",
        "ě" to "e3",
        "è" to "e4",
        "ō" to "o1",
        "ó" to "o2",
        "ǒ" to "o3",
        "ò" to "o4",
        "ī" to "i1",
        "í" to "i2",
        "ǐ" to "i3",
        "ì" to "i4",
        "ū" to "u1",
        "ú" to "u2",
        "ǔ" to "u3",
        "ù" to "u4",
        "ü" to "v0",
        "ǘ" to "v2",
        "ǚ" to "v3",
        "ǜ" to "v4",
        "ń" to "n2",
        "ň" to "n3",
        "" to "m2",
    )

    /* 百家姓. */
    /* https://zh.wikipedia.org/wiki/%E7%99%BE%E5%AE%B6%E5%A7%93 */
    val SURNAME = mapOf(
        "赵" to listOf(listOf("zhào")),
        "钱" to listOf(listOf("qián")),
        "孙" to listOf(listOf("sūn")),
        "李" to listOf(listOf("lǐ")),
        "周" to listOf(listOf("zhōu")),
        "吴" to listOf(listOf("wú")),
        "郑" to listOf(listOf("zhèng")),
        "王" to listOf(listOf("wáng")),
        "冯" to listOf(listOf("féng")),
        "陈" to listOf(listOf("chén")),
        "褚" to listOf(listOf("chǔ")),
        "卫" to listOf(listOf("wèi")),
        "蒋" to listOf(listOf("jiǎng")),
        "沈" to listOf(listOf("shěn")),
        "韩" to listOf(listOf("hán")),
        "杨" to listOf(listOf("yáng")),
        "朱" to listOf(listOf("zhū")),
        "秦" to listOf(listOf("qín")),
        "尤" to listOf(listOf("yóu")),
        "许" to listOf(listOf("xǔ")),
        "何" to listOf(listOf("hé")),
        "吕" to listOf(listOf("lǚ")),
        "施" to listOf(listOf("shī")),
        "张" to listOf(listOf("zhāng")),
        "孔" to listOf(listOf("kǒng")),
        "曹" to listOf(listOf("cáo")),
        "严" to listOf(listOf("yán")),
        "华" to listOf(listOf("huà")),
        "金" to listOf(listOf("jīn")),
        "魏" to listOf(listOf("wèi")),
        "陶" to listOf(listOf("táo")),
        "姜" to listOf(listOf("jiāng")),
        "戚" to listOf(listOf("qī")),
        "谢" to listOf(listOf("xiè")),
        "邹" to listOf(listOf("zōu")),
        "喻" to listOf(listOf("yù")),
        "柏" to listOf(listOf("bǎi")),
        "水" to listOf(listOf("shuǐ")),
        "窦" to listOf(listOf("dòu")),
        "章" to listOf(listOf("zhāng")),
        "云" to listOf(listOf("yún")),
        "苏" to listOf(listOf("sū")),
        "潘" to listOf(listOf("pān")),
        "葛" to listOf(listOf("gě")),
        "奚" to listOf(listOf("xī")),
        "范" to listOf(listOf("fàn")),
        "彭" to listOf(listOf("péng")),
        "郎" to listOf(listOf("láng")),
        "鲁" to listOf(listOf("lǔ")),
        "韦" to listOf(listOf("wéi")),
        "昌" to listOf(listOf("chāng")),
        "马" to listOf(listOf("mǎ")),
        "苗" to listOf(listOf("miáo")),
        "凤" to listOf(listOf("fèng")),
        "花" to listOf(listOf("huā")),
        "方" to listOf(listOf("fāng")),
        "俞" to listOf(listOf("yú")),
        "任" to listOf(listOf("rèn")),
        "袁" to listOf(listOf("yuán")),
        "柳" to listOf(listOf("liǔ")),
        "酆" to listOf(listOf("fēng")),
        "鲍" to listOf(listOf("bào")),
        "史" to listOf(listOf("shǐ")),
        "唐" to listOf(listOf("táng")),
        "费" to listOf(listOf("fèi")),
        "廉" to listOf(listOf("lián")),
        "岑" to listOf(listOf("cén")),
        "薛" to listOf(listOf("xuē")),
        "雷" to listOf(listOf("léi")),
        "贺" to listOf(listOf("hè")),
        "倪" to listOf(listOf("ní")),
        "汤" to listOf(listOf("tāng")),
        "滕" to listOf(listOf("téng")),
        "殷" to listOf(listOf("yīn")),
        "罗" to listOf(listOf("luó")),
        "毕" to listOf(listOf("bì")),
        "郝" to listOf(listOf("hǎo")),
        "邬" to listOf(listOf("wū")),
        "安" to listOf(listOf("ān")),
        "常" to listOf(listOf("cháng")),
        "乐" to listOf(listOf("yuè")),
        "于" to listOf(listOf("yú")),
        "时" to listOf(listOf("shí")),
        "傅" to listOf(listOf("fù")),
        "皮" to listOf(listOf("pí")),
        "卞" to listOf(listOf("biàn")),
        "齐" to listOf(listOf("qí")),
        "康" to listOf(listOf("kāng")),
        "伍" to listOf(listOf("wǔ")),
        "余" to listOf(listOf("yú")),
        "元" to listOf(listOf("yuán")),
        "卜" to listOf(listOf("bǔ")),
        "顾" to listOf(listOf("gù")),
        "孟" to listOf(listOf("mèng")),
        "平" to listOf(listOf("píng")),
        "黄" to listOf(listOf("huáng")),
        "和" to listOf(listOf("hé")),
        "穆" to listOf(listOf("mù")),
        "萧" to listOf(listOf("xiāo")),
        "尹" to listOf(listOf("yǐn")),
        "姚" to listOf(listOf("yáo")),
        "邵" to listOf(listOf("shào")),
        "湛" to listOf(listOf("zhàn")),
        "汪" to listOf(listOf("wāng")),
        "祁" to listOf(listOf("qí")),
        "毛" to listOf(listOf("máo")),
        "禹" to listOf(listOf("yǔ")),
        "狄" to listOf(listOf("dí")),
        "米" to listOf(listOf("mǐ")),
        "贝" to listOf(listOf("bèi")),
        "明" to listOf(listOf("míng")),
        "臧" to listOf(listOf("zāng")),
        "计" to listOf(listOf("jì")),
        "伏" to listOf(listOf("fú")),
        "成" to listOf(listOf("chéng")),
        "戴" to listOf(listOf("dài")),
        "谈" to listOf(listOf("tán")),
        "宋" to listOf(listOf("sòng")),
        "茅" to listOf(listOf("máo")),
        "庞" to listOf(listOf("páng")),
        "熊" to listOf(listOf("xióng")),
        "纪" to listOf(listOf("jì")),
        "舒" to listOf(listOf("shū")),
        "屈" to listOf(listOf("qū")),
        "项" to listOf(listOf("xiàng")),
        "祝" to listOf(listOf("zhù")),
        "董" to listOf(listOf("dǒng")),
        "梁" to listOf(listOf("liáng")),
        "杜" to listOf(listOf("dù")),
        "阮" to listOf(listOf("ruǎn")),
        "蓝" to listOf(listOf("lán")),
        "闵" to listOf(listOf("mǐn")),
        "席" to listOf(listOf("xí")),
        "季" to listOf(listOf("jì")),
        "麻" to listOf(listOf("má")),
        "强" to listOf(listOf("qiáng")),
        "贾" to listOf(listOf("jiǎ")),
        "路" to listOf(listOf("lù")),
        "娄" to listOf(listOf("lóu")),
        "危" to listOf(listOf("wēi")),
        "江" to listOf(listOf("jiāng")),
        "童" to listOf(listOf("tóng")),
        "颜" to listOf(listOf("yán")),
        "郭" to listOf(listOf("guō")),
        "梅" to listOf(listOf("méi")),
        "盛" to listOf(listOf("shèng")),
        "林" to listOf(listOf("lín")),
        "刁" to listOf(listOf("diāo")),
        "钟" to listOf(listOf("zhōng")),
        "徐" to listOf(listOf("xú")),
        "邱" to listOf(listOf("qiū")),
        "骆" to listOf(listOf("luò")),
        "高" to listOf(listOf("gāo")),
        "夏" to listOf(listOf("xià")),
        "蔡" to listOf(listOf("cài")),
        "田" to listOf(listOf("tián")),
        "樊" to listOf(listOf("fán")),
        "胡" to listOf(listOf("hú")),
        "凌" to listOf(listOf("líng")),
        "霍" to listOf(listOf("huò")),
        "虞" to listOf(listOf("yú")),
        "万" to listOf(listOf("wàn")),
        "支" to listOf(listOf("zhī")),
        "柯" to listOf(listOf("kē")),
        "昝" to listOf(listOf("zǎn")),
        "管" to listOf(listOf("guǎn")),
        "卢" to listOf(listOf("lú")),
        "莫" to listOf(listOf("mò")),
        "经" to listOf(listOf("jīng")),
        "房" to listOf(listOf("fáng")),
        "裘" to listOf(listOf("qiú")),
        "缪" to listOf(listOf("miào")),
        "干" to listOf(listOf("gān")),
        "解" to listOf(listOf("xiè")),
        "应" to listOf(listOf("yīng")),
        "宗" to listOf(listOf("zōng")),
        "丁" to listOf(listOf("dīng")),
        "宣" to listOf(listOf("xuān")),
        "贲" to listOf(listOf("bēn")),
        "邓" to listOf(listOf("dèng")),
        "郁" to listOf(listOf("yù")),
        "单" to listOf(listOf("shàn")),
        "杭" to listOf(listOf("háng")),
        "洪" to listOf(listOf("hóng")),
        "包" to listOf(listOf("bāo")),
        "诸" to listOf(listOf("zhū")),
        "左" to listOf(listOf("zuǒ")),
        "石" to listOf(listOf("shí")),
        "崔" to listOf(listOf("cuī")),
        "吉" to listOf(listOf("jí")),
        "钮" to listOf(listOf("niǔ")),
        "龚" to listOf(listOf("gōng")),
        "程" to listOf(listOf("chéng")),
        "嵇" to listOf(listOf("jī")),
        "邢" to listOf(listOf("xíng")),
        "滑" to listOf(listOf("huá")),
        "裴" to listOf(listOf("péi")),
        "陆" to listOf(listOf("lù")),
        "荣" to listOf(listOf("róng")),
        "翁" to listOf(listOf("wēng")),
        "荀" to listOf(listOf("xún")),
        "羊" to listOf(listOf("yáng")),
        "於" to listOf(listOf("yū")),
        "惠" to listOf(listOf("huì")),
        "甄" to listOf(listOf("zhēn")),
        "曲" to listOf(listOf("qū")),
        "家" to listOf(listOf("jiā")),
        "封" to listOf(listOf("fēng")),
        "芮" to listOf(listOf("ruì")),
        "羿" to listOf(listOf("yì")),
        "储" to listOf(listOf("chǔ")),
        "靳" to listOf(listOf("jìn")),
        "汲" to listOf(listOf("jí")),
        "邴" to listOf(listOf("bǐng")),
        "糜" to listOf(listOf("mí")),
        "松" to listOf(listOf("sōng")),
        "井" to listOf(listOf("jǐng")),
        "段" to listOf(listOf("duàn")),
        "富" to listOf(listOf("fù")),
        "巫" to listOf(listOf("wū")),
        "乌" to listOf(listOf("wū")),
        "焦" to listOf(listOf("jiāo")),
        "巴" to listOf(listOf("bā")),
        "弓" to listOf(listOf("gōng")),
        "牧" to listOf(listOf("mù")),
        "隗" to listOf(listOf("kuí")),
        "山" to listOf(listOf("shān")),
        "谷" to listOf(listOf("gǔ")),
        "车" to listOf(listOf("chē")),
        "侯" to listOf(listOf("hóu")),
        "宓" to listOf(listOf("mì")),
        "蓬" to listOf(listOf("péng")),
        "全" to listOf(listOf("quán")),
        "郗" to listOf(listOf("xī")),
        "班" to listOf(listOf("bān")),
        "仰" to listOf(listOf("yǎng")),
        "秋" to listOf(listOf("qiū")),
        "仲" to listOf(listOf("zhòng")),
        "伊" to listOf(listOf("yī")),
        "宫" to listOf(listOf("gōng")),
        "宁" to listOf(listOf("nìng")),
        "仇" to listOf(listOf("qiú")),
        "栾" to listOf(listOf("luán")),
        "暴" to listOf(listOf("bào")),
        "甘" to listOf(listOf("gān")),
        "钭" to listOf(listOf("tǒu")),
        "厉" to listOf(listOf("lì")),
        "戎" to listOf(listOf("róng")),
        "祖" to listOf(listOf("zǔ")),
        "武" to listOf(listOf("wǔ")),
        "符" to listOf(listOf("fú")),
        "刘" to listOf(listOf("liú")),
        "景" to listOf(listOf("jǐng")),
        "詹" to listOf(listOf("zhān")),
        "束" to listOf(listOf("shù")),
        "龙" to listOf(listOf("lóng")),
        "叶" to listOf(listOf("yè")),
        "幸" to listOf(listOf("xìng")),
        "司" to listOf(listOf("sī")),
        "韶" to listOf(listOf("sháo")),
        "郜" to listOf(listOf("gào")),
        "黎" to listOf(listOf("lí")),
        "蓟" to listOf(listOf("jì")),
        "薄" to listOf(listOf("bó")),
        "印" to listOf(listOf("yìn")),
        "宿" to listOf(listOf("sù")),
        "白" to listOf(listOf("bái")),
        "怀" to listOf(listOf("huái")),
        "蒲" to listOf(listOf("pú")),
        "邰" to listOf(listOf("tái")),
        "从" to listOf(listOf("cóng")),
        "鄂" to listOf(listOf("è")),
        "索" to listOf(listOf("suǒ")),
        "咸" to listOf(listOf("xián")),
        "籍" to listOf(listOf("jí")),
        "赖" to listOf(listOf("lài")),
        "卓" to listOf(listOf("zhuó")),
        "蔺" to listOf(listOf("lìn")),
        "屠" to listOf(listOf("tú")),
        "蒙" to listOf(listOf("méng")),
        "池" to listOf(listOf("chí")),
        "乔" to listOf(listOf("qiáo")),
        "阴" to listOf(listOf("yīn")),
        "鬱" to listOf(listOf("yù")),
        "胥" to listOf(listOf("xū")),
        "能" to listOf(listOf("nài")),
        "苍" to listOf(listOf("cāng")),
        "双" to listOf(listOf("shuāng")),
        "闻" to listOf(listOf("wén")),
        "莘" to listOf(listOf("shēn")),
        "党" to listOf(listOf("dǎng")),
        "翟" to listOf(listOf("zhái")),
        "谭" to listOf(listOf("tán")),
        "贡" to listOf(listOf("gòng")),
        "劳" to listOf(listOf("láo")),
        "逄" to listOf(listOf("páng")),
        "姬" to listOf(listOf("jī")),
        "申" to listOf(listOf("shēn")),
        "扶" to listOf(listOf("fú")),
        "堵" to listOf(listOf("dǔ")),
        "冉" to listOf(listOf("rǎn")),
        "宰" to listOf(listOf("zǎi")),
        "郦" to listOf(listOf("lì")),
        "雍" to listOf(listOf("yōng")),
        "郤" to listOf(listOf("xì")),
        "璩" to listOf(listOf("qú")),
        "桑" to listOf(listOf("sāng")),
        "桂" to listOf(listOf("guì")),
        "濮" to listOf(listOf("pú")),
        "牛" to listOf(listOf("niú")),
        "寿" to listOf(listOf("shòu")),
        "通" to listOf(listOf("tōng")),
        "边" to listOf(listOf("biān")),
        "扈" to listOf(listOf("hù")),
        "燕" to listOf(listOf("yān")),
        "冀" to listOf(listOf("jì")),
        "郏" to listOf(listOf("jiá")),
        "浦" to listOf(listOf("pǔ")),
        "尚" to listOf(listOf("shàng")),
        "农" to listOf(listOf("nóng")),
        "温" to listOf(listOf("wēn")),
        "别" to listOf(listOf("bié")),
        "庄" to listOf(listOf("zhuāng")),
        "晏" to listOf(listOf("yàn")),
        "柴" to listOf(listOf("chái")),
        "瞿" to listOf(listOf("qú")),
        "阎" to listOf(listOf("yán")),
        "充" to listOf(listOf("chōng")),
        "慕" to listOf(listOf("mù")),
        "连" to listOf(listOf("lián")),
        "茹" to listOf(listOf("rú")),
        "习" to listOf(listOf("xí")),
        "宦" to listOf(listOf("huàn")),
        "艾" to listOf(listOf("ài")),
        "鱼" to listOf(listOf("yú")),
        "容" to listOf(listOf("róng")),
        "向" to listOf(listOf("xiàng")),
        "古" to listOf(listOf("gǔ")),
        "易" to listOf(listOf("yì")),
        "慎" to listOf(listOf("shèn")),
        "戈" to listOf(listOf("gē")),
        "廖" to listOf(listOf("liào")),
        "庾" to listOf(listOf("yǔ")),
        "终" to listOf(listOf("zhōng")),
        "暨" to listOf(listOf("jì")),
        "居" to listOf(listOf("jū")),
        "衡" to listOf(listOf("héng")),
        "步" to listOf(listOf("bù")),
        "都" to listOf(listOf("dū")),
        "耿" to listOf(listOf("gěng")),
        "满" to listOf(listOf("mǎn")),
        "弘" to listOf(listOf("hóng")),
        "匡" to listOf(listOf("kuāng")),
        "国" to listOf(listOf("guó")),
        "文" to listOf(listOf("wén")),
        "寇" to listOf(listOf("kòu")),
        "广" to listOf(listOf("guǎng")),
        "禄" to listOf(listOf("lù")),
        "阙" to listOf(listOf("quē")),
        "东" to listOf(listOf("dōng")),
        "欧" to listOf(listOf("ōu")),
        "殳" to listOf(listOf("shū")),
        "沃" to listOf(listOf("wò")),
        "利" to listOf(listOf("lì")),
        "蔚" to listOf(listOf("wèi")),
        "越" to listOf(listOf("yuè")),
        "夔" to listOf(listOf("kuí")),
        "隆" to listOf(listOf("lóng")),
        "师" to listOf(listOf("shī")),
        "巩" to listOf(listOf("gǒng")),
        "厍" to listOf(listOf("shè")),
        "聂" to listOf(listOf("niè")),
        "晁" to listOf(listOf("cháo")),
        "勾" to listOf(listOf("gōu")),
        "敖" to listOf(listOf("áo")),
        "融" to listOf(listOf("róng")),
        "冷" to listOf(listOf("lěng")),
        "訾" to listOf(listOf("zǐ")),
        "辛" to listOf(listOf("xīn")),
        "阚" to listOf(listOf("kàn")),
        "那" to listOf(listOf("nā")),
        "简" to listOf(listOf("jiǎn")),
        "饶" to listOf(listOf("ráo")),
        "空" to listOf(listOf("kōng")),
        "曾" to listOf(listOf("zēng")),
        "母" to listOf(listOf("mǔ")),
        "沙" to listOf(listOf("shā")),
        "乜" to listOf(listOf("niè")),
        "养" to listOf(listOf("yǎng")),
        "鞠" to listOf(listOf("jū")),
        "须" to listOf(listOf("xū")),
        "丰" to listOf(listOf("fēng")),
        "巢" to listOf(listOf("cháo")),
        "关" to listOf(listOf("guān")),
        "蒯" to listOf(listOf("kuǎi")),
        "相" to listOf(listOf("xiàng")),
        "查" to listOf(listOf("zhā")),
        "后" to listOf(listOf("hòu")),
        "荆" to listOf(listOf("jīng")),
        "红" to listOf(listOf("hóng")),
        "游" to listOf(listOf("yóu")),
        "竺" to listOf(listOf("zhú")),
        "权" to listOf(listOf("quán")),
        "逯" to listOf(listOf("lù")),
        "盖" to listOf(listOf("gài")),
        "益" to listOf(listOf("yì")),
        "桓" to listOf(listOf("huán")),
        "公" to listOf(listOf("gōng")),
        "牟" to listOf(listOf("móu")),
        "哈" to listOf(listOf("hǎ")),
        "言" to listOf(listOf("yán")),
        "福" to listOf(listOf("fú")),
    )

    /* 复姓. */
    val COMPOUND_SURNAME = mapOf(
        "万俟" to listOf(listOf("mò"), listOf("qí")),
        "上官" to listOf(listOf("shàng"), listOf("guān")),
        "东方" to listOf(listOf("dōng"), listOf("fāng")),
        "东郭" to listOf(listOf("dōng"), listOf("guō")),
        "东门" to listOf(listOf("dōng"), listOf("mén")),
        "乐正" to listOf(listOf("yuè"), listOf("zhèng")),
        "亓官" to listOf(listOf("qí"), listOf("guān")),
        "仉督" to listOf(listOf("zhǎng"), listOf("dū")),
        "令狐" to listOf(listOf("líng"), listOf("hú")),
        "仲孙" to listOf(listOf("zhòng"), listOf("sūn")),
        "公冶" to listOf(listOf("gōng"), listOf("yě")),
        "公孙" to listOf(listOf("gōng"), listOf("sūn")),
        "公羊" to listOf(listOf("gōng"), listOf("yáng")),
        "公良" to listOf(listOf("gōng"), listOf("liáng")),
        "公西" to listOf(listOf("gōng"), listOf("xī")),
        "单于" to listOf(listOf("chán"), listOf("yú")),
        "南宫" to listOf(listOf("nán"), listOf("gōng")),
        "南门" to listOf(listOf("nán"), listOf("mén")),
        "司寇" to listOf(listOf("sī"), listOf("kòu")),
        "司徒" to listOf(listOf("sī"), listOf("tú")),
        "司空" to listOf(listOf("sī"), listOf("kōng")),
        "司马" to listOf(listOf("sī"), listOf("mǎ")),
        "呼延" to listOf(listOf("hū"), listOf("yán")),
        "壤驷" to listOf(listOf("rǎng"), listOf("sì")),
        "夏侯" to listOf(listOf("xià"), listOf("hóu")),
        "太叔" to listOf(listOf("tài"), listOf("shū")),
        "夹谷" to listOf(listOf("jiá"), listOf("gǔ")),
        "子车" to listOf(listOf("zǐ"), listOf("jū")),
        "宇文" to listOf(listOf("yǔ"), listOf("wén")),
        "宗政" to listOf(listOf("zōng"), listOf("zhèng")),
        "宰父" to listOf(listOf("zǎi"), listOf("fǔ")),
        "尉迟" to listOf(listOf("yù"), listOf("chí")),
        "左丘" to listOf(listOf("zuǒ"), listOf("qiū")),
        "巫马" to listOf(listOf("wū"), listOf("mǎ")),
        "慕容" to listOf(listOf("mù"), listOf("róng")),
        "拓跋" to listOf(listOf("tuò"), listOf("bá")),
        "梁丘" to listOf(listOf("liáng"), listOf("qiū")),
        "榖梁" to listOf(listOf("gǔ"), listOf("liáng")),
        "欧阳" to listOf(listOf("ōu"), listOf("yáng")),
        "段干" to listOf(listOf("duàn"), listOf("gān")),
        "淳于" to listOf(listOf("chún"), listOf("yú")),
        "漆雕" to listOf(listOf("qī"), listOf("diāo")),
        "澹台" to listOf(listOf("tán"), listOf("tái")),
        "濮阳" to listOf(listOf("pú"), listOf("yáng")),
        "申屠" to listOf(listOf("shēn"), listOf("tú")),
        "百里" to listOf(listOf("bǎi"), listOf("lǐ")),
        "皇甫" to listOf(listOf("huáng"), listOf("pǔ")),
        "端木" to listOf(listOf("duān"), listOf("mù")),
        "第五" to listOf(listOf("dì"), listOf("wǔ")),
        "羊舌" to listOf(listOf("yáng"), listOf("shé")),
        "西门" to listOf(listOf("xī"), listOf("mén")),
        "诸葛" to listOf(listOf("zhū"), listOf("gě")),
        "赫连" to listOf(listOf("hè"), listOf("lián")),
        "轩辕" to listOf(listOf("xuān"), listOf("yuán")),
        "钟离" to listOf(listOf("zhōng"), listOf("lí")),
        "长孙" to listOf(listOf("zhǎng"), listOf("sūn")),
        "闻人" to listOf(listOf("wén"), listOf("rén")),
        "闾丘" to listOf(listOf("lǘ"), listOf("qiū")),
        "颛孙" to listOf(listOf("zhuān"), listOf("sūn")),
        "鲜于" to listOf(listOf("xiān"), listOf("yú")),
    )

}