<!--suppress HtmlDeprecatedAttribute, HttpUrlsUsage -->

<div align="center">
  <p>
    <img src="https://s1.imagehub.cc/images/2023/03/07/af8ed087c9d354b9ab6142aae7bbafb6.png" alt="autojs6-banner_800×224" border="0" width="704" />
  </p>

  <p>アクセシビリティサービスをサポートする Android プラットフォーム用の JavaScript 自動化ツール</p>

  <p>
    <a href="http://download.autojs6.com"><img alt="GitHub release (latest by date)" src="https://img.shields.io/github/v/release/SuperMonster003/AutoJs6"/></a>
    <a href="http://issues.autojs6.com"><img alt="GitHub closed issues" src="https://img.shields.io/github/issues/SuperMonster003/AutoJs6?color=A24232"/></a>
    <a href="http://commit.autojs6.com/99a1d8490fac5b6d55f6f183db59ad833a2064ed"><img alt="Created" src="https://img.shields.io/date/1636632233?color=2e7d32&label=created"/></a>
    <br>
    <a href="https://github.com/mozilla/rhino"><img alt="Rhino" src="https://img.shields.io/badge/rhino-1.8.1--SNAPSHOT-795548"/></a>
    <a href="https://developer.android.com/studio/archive"><img alt="Android Studio" src="https://img.shields.io/badge/android%20studio-2022.1+-B64FC8"/></a>
    <br>
    <a href="https://www.codefactor.io/repository/github/SuperMonster003/AutoJs6"><img alt="CodeFactor Grade" src="https://www.codefactor.io/repository/github/SuperMonster003/AutoJs6/badge"/></a>
    <a href="https://www.jetbrains.com/?from=AutoJs6"><img alt="JetBrains supporter" src="https://img.shields.io/badge/supporter-JetBrains-ee4677"/></a>
    <a href="http://project.autojs6.com/blob/master/LICENSE"><img alt="GitHub License" src="https://img.shields.io/github/license/SuperMonster003/AutoJs6?color=534BAE"/></a>
  </p>
</div>

******

### 言語

******

現在の README.md ファイルは以下の言語に対応しています:

 - [简体中文 [zh-Hans]](http://project.autojs6.com/blob/master/.readme/README-zh-Hans.md)
 - [繁體中文 (香港) [zh-Hant-HK]](http://project.autojs6.com/blob/master/.readme/README-zh-Hant-HK.md)
 - [繁體中文 (台灣) [zh-Hant-TW]](http://project.autojs6.com/blob/master/.readme/README-zh-Hant-TW.md)
 - [English [en]](http://project.autojs6.com/blob/master/.readme/README-en.md)
 - [Français [fr]](http://project.autojs6.com/blob/master/.readme/README-fr.md)
 - [Español [es]](http://project.autojs6.com/blob/master/.readme/README-es.md)
 - 日本語 [ja] # 現在
 - [한국어 [ko]](http://project.autojs6.com/blob/master/.readme/README-ko.md)
 - [Русский [ru]](http://project.autojs6.com/blob/master/.readme/README-ru.md)
 - [العربية [ar]](http://project.autojs6.com/blob/master/.readme/README-ar.md)

******

### 紹介

******

[Auto.js](https://github.com/hyb1996/Auto.js) は Android プラットフォーム用の [アクセシビリティサービス](https://developer.android.com/guide/topics/ui/accessibility/service?hl=zh-cn) をサポートする JavaScript 自動化ツールです.

Auto.js は [hyb1996](https://github.com/hyb1996) によって `2017/01/27` に初めてリリースされ, `2020/03/13` にメンテナンスを停止しました. 最終バージョンの名前は `4.1.1 Alpha2` で, ビルドバージョンは `461` です.

AutoJs6 は `2021/12/01` に Auto.js 最終プロジェクトを基に二次開発され, 引き続きオープンソースとして無料で提供されています.

以下の表には, Auto.js に関連するプロジェクトの一部が記載されています (開発日順に並べ替えられています):

| <span style="word-break:keep-all;white-space:nowrap">プロジェクト</span> |                                                             <span style="word-break:keep-all;white-space:nowrap">アプリ名</span>                                                              | <span style="word-break:keep-all;white-space:nowrap">開発者</span> | <span style="word-break:keep-all;white-space:nowrap">開発開始日</span> | <span style="word-break:keep-all;white-space:nowrap">開発終了日</span> |
|:------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------:|:---------------------------------------------------------------------------------------------------------------------------------:|:-------------------------------------------------------------------------------------------------------------------------------:|
|     <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/hyb1996/Auto.js)</span>      |    <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/TonyJiangWJ/Auto.js/commit/268ec8895bbfa28fc7715154eb15b1c1eaaefd14#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span>     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2017/01/27`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2020/03/13`</span>                             |
|                     <span style="word-break:keep-all;white-space:nowrap">Auto.js Pro 7</span>                      |                                                                                     <span style="word-break:keep-all;white-space:nowrap">Auto.js</span>                                                                                      |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2019/03/13`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2019/07/08`</span>                             |
|                     <span style="word-break:keep-all;white-space:nowrap">Auto.js Pro 8</span>                      |                                                                                    <span style="word-break:keep-all;white-space:nowrap">AutoJsPro</span>                                                                                     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2019/10/13`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2021/07/24`</span>                             |
|   <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/TonyJiangWJ/Auto.js)</span>    | <span style="word-break:keep-all;white-space:nowrap">[Auto.js&#160;M](https://github.com/TonyJiangWJ/Auto.js/commit/268ec8895bbfa28fc7715154eb15b1c1eaaefd14#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span> |      <span style="word-break:keep-all;white-space:nowrap">[TonyJiangWJ](https://github.com/TonyJiangWJ)</span>       |                             <span style="word-break:keep-all;white-space:nowrap">`2019/11/21`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|      <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/kkevsekk1/AutoX)</span>       |                 <span style="white-space:pre">[Autox.js](https://github.com/kkevsekk1/AutoX/commit/8143e4ed893d4af05d22aa791b83a962f9959873#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span>                  |        <span style="word-break:keep-all;white-space:nowrap">[kkevsekk1](https://github.com/kkevsekk1)</span>         |                             <span style="word-break:keep-all;white-space:nowrap">`2020/07/24`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|        <span style="word-break:keep-all;white-space:nowrap">[Auto.js Pro 9](https://pro.autojs.org/)</span>        |                                                                                    <span style="word-break:keep-all;white-space:nowrap">AutoJsPro</span>                                                                                     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2021/03/28`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2023/02/09`</span>                             |
| <span style="word-break:keep-all;white-space:nowrap">[AutoJs6](https://github.com/SuperMonster003/AutoJs6)</span>  |  <span style="word-break:keep-all;white-space:nowrap">[AutoJs6](https://github.com/SuperMonster003/AutoJs6/commit/a8ce1b9acb541e9736c33134be3194c3148a15a3#diff-833a46a97033e77558372a2dce103fd6fee29aaaa899f610022a7aece592ee7bR27)</span>  |  <span style="word-break:keep-all;white-space:nowrap">[SuperMonster003](https://github.com/SuperMonster003)</span>   |                             <span style="word-break:keep-all;white-space:nowrap">`2021/12/01`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|      <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/kkevsekk1/AutoX)</span>       |            <span style="white-space:pre">[Autox.js&#160;v6](https://github.com/kkevsekk1/AutoX/commit/8b6776cff8b0fca4be4a52719b7d7d07c0a058f3#diff-51a0b488f963eb0be6c6599bf5df497313877cf5bdff3950807373912ac1cdc9R130)</span>             |           <span style="word-break:keep-all;white-space:nowrap">[wilinz](https://github.com/wilinz)</span>            |                             <span style="word-break:keep-all;white-space:nowrap">`2022/05/26`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|        <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/aiselp/AutoX)</span>        |              <span style="white-space:pre">[Autox.js&#160;v7](https://github.com/aiselp/AutoX/commit/484491fd5fe12b8203d0b09c181eb0f471c0ea9f#diff-8cff73265af19c059547b76aca8882cbaa3209291406f52df1dafbbc78e80c46R120)</span>              |           <span style="word-break:keep-all;white-space:nowrap">[aiselp](https://github.com/aiselp)</span>            |                             <span style="word-break:keep-all;white-space:nowrap">`2024/04/21`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |

表の日付は推定値であり, 実際とは異なる場合があります.

表の Auto.js Pro 7/8/9 は有料バージョンです. その他は無料のオープンソースバージョンです.

******

### 機能

******

* JavaScript IDEとして使用可能 (コード補完/変数リネーム/コードフォーマッティング)
* 無障害サービスに基づく自動化操作をサポート ([AccessibilityService](https://developer.android.com/reference/android/accessibilityservice/AccessibilityService))
* 浮動ボタンのクイックアクションをサポート (スクリプトの録画および再生/パッケージの表示/レイアウト分析)
* セレクタAPIをサポートし, コントロールのトラバース/情報の取得/コントロール操作を提供 (UiAutomatorに類似: [UiAutomator](https://developer.android.com/training/testing/ui-automator))
* レイアウトインターフェイスの分析をサポート (Android StudioのLayoutInspectorに類似)
* 録画機能および録画再生機能をサポート
* スクリーンショット/スクリーン保存/画像検索/画像マッチングをサポート
* E4X (ECMAScript for XML)の記述インターフェースをサポート ([E4X](https://ja.wikipedia.org/wiki/E4X))
* スクリプトファイルまたはプロジェクトをAPKファイルにパッケージ化する機能をサポート
* ルート権限を使用して機能を拡張 (スクリーンのクリック/スワイプ/録画/Shell)
* Taskerプラグインとして使用可能
* VS Code拡張機能との連携をサポート (AutoJs6-VSCode-Extensionプラグインが必要です: [AutoJs6-VSCode-Extension](http://vscext-project.autojs6.com))

******

### 環境

******

- Androidオペレーティングシステム
- [API](https://developer.android.com/guide/topics/manifest/uses-sdk-element#ApiLevels) [24](https://developer.android.com/reference/android/os/Build.VERSION_CODES#N) ([7.0](https://ja.wikipedia.org/wiki/Android_Nougat)) [[N](https://developer.android.com/reference/android/os/Build.VERSION_CODES#N)] 以上

******

### マニュアル

******

* [アプリケーションドキュメント](https://docs.autojs6.com)
* [ユーザーマニュアル (作成中)](https://docs.autojs6.com/#/manual)
* [トラブルシューティング](https://docs.autojs6.com/#/qa)
* [プロジェクトのコンパイルとビルド](#project-compilation-and-build)
* [スクリプト開発アシスト](#script-development-assistance)

******

### 主な変更

******

Auto.js の最終オープンソースバージョン `4.1.1 Alpha2` と比較して, AutoJs6 は以下のアップグレードまたは変更を行いました:

* [Shizuku](https://shizuku.rikka.app/introduction/)経由でADB特権を取得し, システムAPIを使用可能
* [WebSocket](https://docs.autojs6.com/#/webSocketType)インスタンスの作成, および[WebSocketプロトコル](https://ja.wikipedia.org/wiki/WebSocket)に基づくネットワークリクエストの処理をサポート
* 新モジュール [ [base64](https://docs.autojs6.com/#/base64) / [crypto](https://docs.autojs6.com/#/crypto) / [sqlite](https://docs.autojs6.com/#/sqlite) / [i18n](https://docs.autojs6.com/#/i18n) / [notice](https://docs.autojs6.com/#/notice) / [ocr](https://docs.autojs6.com/#/ocr) / [opencc](https://docs.autojs6.com/#/opencc) / [qrcode](https://docs.autojs6.com/#/qrcode) / [shizuku](https://docs.autojs6.com/#/shizuku) / ... ]
* 多言語対応 [ 西 / 仏 / 露 / 阿 / 日 / 韓 / 英 / 簡中 / 繁中 / ... ]
* テーマカラーの適応 [ グループ化 / ロケーション / 検索 / 履歴 / 明るさとコントラストの自動適応 / ... ]
* ナイトモード対応 [ 設定ページ / ドキュメントページ / レイアウト分析ページ / 浮動ウィンドウ / ... ]
* [VSCodeプラグイン](http://vscext-project.autojs6.com)がクライアント (LAN)とサーバ (LAN/ADB)接続方法をサポート
* [Rhino](https://github.com/mozilla/rhino/)エンジンが [v1.7.7.2](https://github.com/mozilla/rhino/releases/tag/Rhino1_7_7_2_Release) から [v1.8.1-SNAPSHOT](http://rhino.autojs6.com/blob/master/gradle.properties#L3) にアップグレードされました
    * Unicode [コードポイント](https://developer.mozilla.org/ja/docs/Glossary/Code_point)エスケープのサポート [補助平面](https://ja.wikipedia.org/wiki/多言語面#補助平面)文字
       ```javascript
       '\u{1D160}'; /* を表します "𝅘𝅥𝅮", 従来の方法: '\uD834\uDD60'. */
       ```
    * [Object.values()](https://developer.mozilla.org/ja/docs/Web/JavaScript/Reference/Global_Objects/Object/values)のサポート
       ```javascript
       Object.values({name: 'Max', age: 4}); // ['max', 4]
       ```
    * [Array.prototype.includes()](https://developer.mozilla.org/ja/docs/Web/JavaScript/Reference/Global_Objects/Array/includes)のサポート
       ```javascript
       [10, 20, NaN].includes(20); // true
       ```
    * [BigInt](https://developer.mozilla.org/ja/docs/Web/JavaScript/Reference/Global_Objects/BigInt)のサポート
       ```javascript
       typeof 567n === 'bigint'; // true
       ```
    * [テンプレート文字列](https://developer.mozilla.org/ja/docs/Web/JavaScript/Reference/Template_literals)のサポート
       ```javascript
       `Lucky number: ${(Math.random() * 100).toFixed(0)}`
       ```
    * Rhinoエンジンの[新機能](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/RHINO.md)を見る
    * Rhinoエンジンの[互換リスト](https://mozilla.github.io/rhino/compat/engines.html)を見る

******

### バージョン履歴

******

# v6.6.3

###### 2025/05/27

* `新機能` バージョン履歴機能: 多言語の変更履歴と統計を閲覧
* `新機能` timers.keepAlive メソッド (グローバルへ昇格) によりスクリプトの活動を維持
* `新機能` engines.on('start/stop/error', callback) などのイベントリスナーでエンジンのグローバルイベントを受信
* `新機能` images.detectMultiColors メソッドで複数点のカラーを検査 _[`issue #374`](http://issues.autojs6.com/374)_
* `新機能` images.matchFeatures/detectAndComputeFeatures メソッド: フル解像度画像検索 (参照 [Auto.js Pro](https://g.pro.autojs.org/)) _[`issue #366`](http://issues.autojs6.com/366)_
* `新機能` images.compressToBytes メソッドで画像を圧縮してバイト配列を取得
* `新機能` images.downsample メソッドで解像度を下げて新しい ImageWrapper を生成
* `新機能` ui.keepScreenOn メソッドで UI ページがフォーカス中は画面を点灯したまま維持
* `新機能` ui.root プロパティ (getter) で UI レイアウト内の「ウィンドウコンテンツのルートコンテナ」ノードを取得
* `新機能` webview 要素が JsBridge ベースのウェブページレイアウトをサポート (参照 [Auto.js Pro](https://g.pro.autojs.org/)) [例: Layout > Interactive HTML / Vue2 + Vant (SFC)] _[`issue #281`](http://issues.autojs6.com/281)_
* `修正` Docs タブおよび Docs アクティビティのオンラインドキュメントがシステムナビゲーションバーと重なる場合がある問題を修正
* `修正` 一部ページで Toolbar ボタンをタップすると誤ってタイトルのクリックイベントが発火する問題を修正
* `修正` コードエディタの空行が一部デバイスで四角形として表示される問題を修正
* `修正` テーマカラー設定のカラーピッカーダイアログが無限に重なる問題を修正
* `修正` アクセシビリティサービスが無効のときに音量アップキーが全スクリプトを停止しない問題を修正
* `修正` スケジュールタスクでユーザー定義ブロードキャストメッセージを編集する際に IME が入力エリアを覆う問題を修正
* `修正` webview 内のコントロールがソフトキーボードを正常に呼び出せない問題を修正
* `修正` APK 情報ダイアログがアプリ名や SDK 情報を取得できない場合がある問題を修正
* `修正` ファイルマネージャーのサンプルでプロジェクトディレクトリに入る際にサブフォルダーの内容が読み込まれない問題を修正
* `修正` Android 15 の UI モードでステータスバーが上部コンテンツを覆う問題を修正
* `修正` Android 15 の一部ページでステータスバー背景色がテーマカラーと同期しない問題を修正
* `修正` dialogs モジュールが customView プロパティをサポートしていない問題を修正 _[`issue #364`](http://issues.autojs6.com/364)_
* `修正` dialogs.input の expression パラメータが実行結果を返さない問題を修正
* `修正` JavaAdapter 使用時に ClassLoader スタックオーバーフローが発生する問題を修正 _[`issue #376`](http://issues.autojs6.com/376)_
* `修正` console.setContentTextColor がデフォルト文字色をリセットしてしまう問題を修正 _[`issue #346`](http://issues.autojs6.com/346)_
* `修正` console.setContentBackgroundColor がカラー名を受け付けない問題を修正 _[`issue #384`](http://issues.autojs6.com/384)_
* `修正` images.compress 実装を修正: ダウンサンプリングではなくエンコード品質を変更
* `修正` images.resize メソッドが正しく動作しない問題を修正
* `修正` engines.all が ConcurrentModificationException を投げる場合がある問題を修正 _[`issue #394`](http://issues.autojs6.com/394)_
* `修正` README.md の一部言語で日付フォーマットが誤っていた問題を修正
* `修正` Gradle ビルドがライブラリアーカイブのサイズ不正で失敗する問題を修正 _[`issue #389`](http://issues.autojs6.com/389)_
* `改善` レイアウトインスペクターが要素の非表示をサポート (寄稿 [TonyJiangWJ](https://github.com/TonyJiangWJ)) _[`pr #371`](http://pr.autojs6.com/371)_ _[`issue #355`](http://issues.autojs6.com/355)_
* `改善` レイアウトインスペクターのメニューに機能グループ化用のグラデーション区切りを追加
* `改善` project.json がスクリプトプロジェクト用 permissions オプションをサポート (寄稿 [wirsnow](https://github.com/wirsnow)) _[`pr #391`](http://pr.autojs6.com/391)_ _[`issue #362`](http://issues.autojs6.com/362)_
* `改善` 単一ファイルをパッケージングする際、インストール済みアプリの宣言パーミッションを自動読み取り・選択 _[`issue #362`](http://issues.autojs6.com/362)_
* `改善` テーマカラーの適用範囲を拡大、より多くのウィジェットをサポート
* `改善` メインページのドロワー幅がランドスケープおよび超ワイド画面に適応
* `改善` 『アプリについて』と『開発者について』ページに横向きとコンパクトレイアウトを追加
* `改善` 設定ダイアログに「デフォルト値を使用」メニューを追加
* `改善` ファイルマネージャーの FAB が外部タップ時に自動で隠れるように
* `改善` コードフォーマッターが `??`, `?.`, `??=` 演算子をサポート
* `改善` コードエディタが GB18030 / UTF-16 (LE/BE) / Shift_JIS などのエンコーディングでのファイル読み書きに対応
* `改善` コードエディタがファイルの詳細情報 (パス/エンコーディング/改行コード/総バイト数・文字数 など) の表示に対応 _[`issue #395`](http://issues.autojs6.com/395)_
* `改善` Intent 操作 (編集/閲覧/インストール/送信/再生など) にエラーメッセージを追加
* `改善` webview 要素の url 属性が相対パスをサポート
* `改善` ImageWrapper#saveTo の path パラメータが相対パスをサポート
* `改善` images.save が PNG 圧縮を quality パラメータでサポート _[`issue #367`](http://issues.autojs6.com/367)_
* `改善` 無視した更新リストとクライアントモードアドレスをクリア可能に
* `改善` バージョンアップデート情報を UI 言語に合わせて表示
* `改善` 非同期ロードでファイルマネージャーリストのスクロールがよりスムーズに
* `改善` コンソールでのスクリプト例外メッセージの内容とフォーマットを改善
* `改善` サンプルコードをフォルダーの初期内容にリセット可能
* `改善` APK 署名検証を高速化
* `改善` APK/メディアファイル情報ダイアログを速度と表示ロジック面で最適化
* `改善` Gradle ビルドスクリプトが新しいバージョンに柔軟に対応 _[`discussion #369`](http://discussions.autojs6.com/369)_
* `改善` 一部の依存関係またはローカルライブラリのバージョン調整 _[`CHANGELOG.md`](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG.md#v663)_

# v6.6.2

###### 2025/04/16

* `新機能` ui.statusBarAppearanceLight, statusBarAppearanceLightBy, navigationBarColor などのメソッド
* `新機能` ui.statusBarHeight 属性 (getter) により, ステータスバーの高さを取得可能 _[`issue #357`](http://issues.autojs6.com/357)_
* `新機能` images.flip メソッドで画像を反転 _[`issue #349`](http://issues.autojs6.com/349)_
* `新機能` 設定ページに『ファイル拡張子』オプションを追加
* `新機能` テーマ設定ページが新しいレイアウト (グルーピング, 配置, 検索, 履歴, カラーピッカーの改善など) に対応
* `修正` Android 15 において, ステータスバーの背景色がテーマカラーと一致しない問題を修正
* `修正` plugins.load メソッドでプラグインが正しくロードされない問題を修正 _[`issue #290`](http://issues.autojs6.com/290)_
* `修正` Android 7.x で dx ライブラリが正しく動作しない問題を修正 _[`issue #293`](http://issues.autojs6.com/293)_
* `修正` require を使用して組み込みモジュールをインポートする際, ScriptRuntime の同期状態に問題が生じる (暫定対応) _[`issue #298`](http://issues.autojs6.com/298)_
* `修正` notice モジュールに getBuilder などの拡張メソッドが欠如している問題を修正 _[`issue #301`](http://issues.autojs6.com/301)_
* `修正` shizuku/shell メソッドが文字列パラメータを受け付けない問題を修正 _[`issue #310`](http://issues.autojs6.com/310)_
* `修正` colors.pixel メソッドがシングルチャンネル画像のパラメータを受け付けない問題を修正 _[`issue #350`](http://issues.autojs6.com/350)_
* `修正` engines.execScript / execScriptFile メソッドが, スクリプト実行時にワーキングディレクトリを誤って設定する問題を修正 _[`issue #358`](http://issues.autojs6.com/358)_ _[`issue #340`](http://issues.autojs6.com/340)_ _[`issue #339`](http://issues.autojs6.com/339)_
* `修正` floaty.window / floaty.rawWindow がサブスレッドで実行できない問題を修正
* `修正` floaty.getClip がクリップボードの内容を正しく取得できない場合がある問題を修正 _[`issue #341`](http://issues.autojs6.com/341)_
* `修正` ui.inflate の返り値から attr, on, click などのプロトタイプメソッドが欠落する問題を修正
* `修正` XML 構文を用いて JavaScript の式を属性値として使用する際, スコープのコンテキストが不正にバインドされる問題 _[`issue #319`](http://issues.autojs6.com/319)_
* `修正` 一部メソッドで発生する例外が try..catch によって捕捉されない問題を修正 _[`issue #345`](http://issues.autojs6.com/345)_
* `修正` レイアウト解析ページでコード生成時にアプリがクラッシュする可能性がある問題を修正 _[`issue #288`](http://issues.autojs6.com/288)_
* `修正` パッケージ化されたアプリが shizuku モジュールを正しく利用できない問題を修正 _[`issue #227`](http://issues.autojs6.com/227)_ _[`issue #231`](http://issues.autojs6.com/231)_ _[`issue #284`](http://issues.autojs6.com/284)_ _[`issue #287`](http://issues.autojs6.com/287)_ _[`issue #304`](http://issues.autojs6.com/304)_
* `修正` コードエディタで行末へ移動すると, カーソルが次の行の先頭に位置してしまう問題を修正
* `修正` 設定ページのダイアログ要素を連続して高速にタップすると, アプリがクラッシュする問題を修正
* `改善` パッケージアプリのテンプレートにおける APK ファイルサイズの最適化
* `改善` アプリ (およびパッケージアプリ) がより多くの権限に対応 _[`issue #338`](http://issues.autojs6.com/338)_
* `改善` パッケージングページに Pinyin ライブラリのオプションを追加
* `改善` パッケージアプリのメインページにおいて, ステータスバーの背景とテキスト色を最適化
* `改善` パッケージアプリの設定ページに, 特別な権限 (全ファイルアクセスや通知送信) 用のトグルスイッチを追加 _[`issue #354`](http://issues.autojs6.com/354)_
* `改善` コントロールのテキストとアイコンが, テーマの明るさに合わせて自動で調整されるよう改善
* `改善` コントロールの色と背景とのコントラストが低い場合の視認性を向上
* `改善` カラーピッカー内の HEX 入力欄に, クリップボードからの貼り付け時の互換性を向上
* `改善` アプリのナビゲーションバーを, より良いビジュアル体験のために透明または半透明に設定
* `改善` ライトモード時, ステータスバーとナビゲーションバーのデフォルト UI モードをカラー `md_grey_50` に設定
* `改善` ホームドロワー内のアクセシビリティサービスのスイッチを, スクリプトコードと同期するよう改善
* `改善` ホームページのドキュメントページに双方向検索ボタンを追加
* `改善` ホームページの『ファイル』タブで, 長押しによりフローティングボタンの表示状態を切り替え可能に
* `改善` コードエディタのタイトルがフォントサイズを自動調整するよう改善
* `改善` ログページのフローティングボタンの表示が, リストのスクロール動作と連動するよう改善
* `改善` スクリプトプロジェクトの project.json 設定ファイルが, より多くのパッケージオプションに対応 _[`issue #305`](http://issues.autojs6.com/305)_ _[`issue #306`](http://issues.autojs6.com/306)_
* `改善` project.json 設定ファイルが, オプション名の柔軟なマッチングとエイリアスに対応するよう改善
* `改善` APK ファイル情報ダイアログに, ファイルサイズと署名スキームの情報を追加
* `改善` APK ファイル情報ダイアログで, テキストコピーやアプリ詳細への遷移用クリックリスナーに対応
* `改善` com.stardust 接頭辞のパッケージを復元し, コード互換性を向上 _[`issue #290`](http://issues.autojs6.com/290)_
* `改善` floaty.window / floaty.rawWindow メソッドを, メインスレッドおよびサブスレッドの両方で実行可能に改善
* `改善` グローバルメソッド getClip が, 必要に応じて floaty.getClip を利用するよう改善し, 互換性を向上
* `改善` files.path および関連メソッドが, null のパス指定時にも適切に動作するよう改善
* `改善` 最新の公式 Rhino エンジンへの同期およびコードの調整
* `改善` README.md を改善し, プロジェクトのビルドおよび実行方法のドキュメントを充実 _[`issue #344`](http://issues.autojs6.com/344)_
* `改善` 一部の依存関係またはローカルライブラリのバージョン調整 _[`CHANGELOG.md`](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG.md#v662)_

# v6.6.1

###### 2025/01/01

* `新機能` 中国語のピンイン変換用の Pinyin モジュール (プロジェクトドキュメントを参照 > [中国語ピンイン](https://docs.autojs6.com/#/pinyin))
* `新機能` 中国語のピンイン変換用の Pinyin4j モジュール (プロジェクトドキュメントを参照 > [中国語ピンイン](https://docs.autojs6.com/#/pinyin4j))
* `新機能` コントロールまたはコントロールコレクションが類似しているかを判定する UiObject#isSimilar と UiObjectCollection#isSimilar メソッド
* `新機能` グローバルメソッド "currentComponent", 現在アクティブなコンポーネントの名前情報を取得するために使用されます
* `修正` 一部の環境でバージョンを低く戻すことでプロジェクトが正常にコンパイルできなくなる問題
* `修正` 存在しないメソッドを呼び出す際に発生する可能性がある「非プリミティブ型の値」エラー
* `修正` 一部のデバイスでスクリプトショートカットが正常に追加できない問題 (暫定修正) _[`issue #221`](http://issues.autojs6.com/221)_
* `修正` automator.click/longClick メソッドのパラメーター型制限の誤り _[`issue #275`](http://issues.autojs6.com/275)_
* `修正` セレクターが ConsString 型のパラメーターをサポートしない問題 _[`issue #277`](http://issues.autojs6.com/277)_
* `修正` UiObjectCollection インスタンスにメソッドおよびプロパティが欠如している問題
* `改善` パッケージ化ページで署名設定, キーストア管理, 権限設定をサポートします ([luckyloogn]() による) _[`pr #286`]()_
* `改善` フローティングウィンドウの現在のパッケージ名および現在のアクティビティ名の認識精度を向上 (優先順位: Shizuku > Root > A11Y)
* `改善` currentPackage と currentActivity の認識精度を向上 (優先順位: Shizuku > Root > A11Y)
* `改善` ログアクティビティウィンドウの個別エントリのテキスト内容をダブルクリックまたは長押しで選択する機能を復元 _[`issue #280`](http://issues.autojs6.com/280)_
* `改善` project.json ファイルが破損した場合でも, スクリプトプロジェクトの重要な情報を可能な限り復元
* `改善` 単一ファイルをパッケージ化する際に, 自動生成されるパッケージ名のサフィックスを簡体字中国語からピンインに変換 (多音字対応)
* `改善` UiSelector#findOnce と UiSelector#find メソッドで負の引数をサポート
* `改善` app.startActivity/startDualActivity メソッドの適応性が向上しました
* `改善` UI 要素や className に関連するセレクターが RecyclerView や Snackbar などのパッケージ名プレフィックス省略形式にさらに対応
* `改善` Rhino エンジンの最新の上流コードを同期し, 既存のプロジェクトに適応させる
* `改善` 一部の依存関係またはローカルライブラリのバージョン調整 _[`CHANGELOG.md`](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG.md#v661)_

##### 他のバージョン履歴については以下を参照してください

* [CHANGELOG.md](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG-ja.md)

******

### <a id="project-compilation-and-build"></a>プロジェクトのコンパイルとビルド

******

AutoJs6 オープンソース プロジェクトのデバッグや開発が必要な場合は, [Android Studio](https://pro.autojs.org/) ([Google](https://www.google.com/) 社製品) または [IntelliJ IDEA](https://www.jetbrains.com/idea/) ([Jetbrains](https://www.jetbrains.com/) 社製品) を使用できます.

このセクションでは, AutoJs6 オープンソース プロジェクトのコンパイルとビルド方法を Android Studio を例に説明します. IntelliJ IDEA も同様です.

#### Android Studioの準備

`Android Studio Meerkat Feature Drop | 2024.3.2` バージョンをダウンロードしてください (いずれかを選択):

- [android-studio-2024.3.2.14-windows.exe](https://redirector.gvt1.com/edgedl/android/studio/install/2024.3.2.14/android-studio-2024.3.2.14-windows.exe) (1.23 GB)
- [android-studio-2024.3.2.14-windows.zip](https://redirector.gvt1.com/edgedl/android/studio/ide-zips/2024.3.2.14/android-studio-2024.3.2.14-windows.zip) (1.23 GB)

> 注: 上述バージョンのリリース日は 2025 年 5 月 6 日 です. その他のバージョンをダウンロードするか, 上記のリンクが失効している場合は, [Android Studioリリースアーカイブ](https://developer.android.com/studio/archive?hl=en)のページをご覧ください.

上記のファイルをインストールまたは解凍し, Android Studio ソフトウェアを実行します (例: `"D:\android-studio\bin\studio64.exe"`).

#### Android SDK の準備

> 注: コンピュータシステムに既にAndroid SDK (Androidソフトウェア開発キット)がインストールされている場合, この節の内容をスキップできます.

Android Studioソフトウェアで `CTRL + ALT + S` のショートカットキーを使用して設定ページを開く:

```text
Appearance & Behavior (外観と動作) -> 
System Settings (システム設定) -> 
Android SDK (Android ソフトウェア開発キット)
```

`Android SDK場所` の欄が空白の場合は, 右側の `編集` ボタンをクリックし, 表示されるウィンドウで `次へ` ボタンを数回クリックします.

> 注: プロセス中に1つまたは複数の関連契約に同意する必要がある場合があります.

関連するリソースのダウンロードとインストールが完了したら, `完了` ボタンをクリックします.  
上記の `Android SDK場所` の欄が自動的に入力され, SDKの準備が完了します.

#### Android SDKツールの準備

AutoJs6では一部のSDKツール(NDKやCMakeなど)が必要です.

> 注: コンピュータシステムにAutoJs6ですべて必要なAndroid SDKツールがインストールされている場合, この節の内容をスキップできます.

Android Studioソフトウェアで `CTRL + ALT + S` のショートカットキーを使用して設定ページを開く:

```text
Appearance & Behavior (外観と動作) -> 
System Settings (システム設定) -> 
Android SDK (Android ソフトウェア開発キット) -> 
SDK Tools (SDK ツール) (右側のウィンドウにあります)
```

`パッケージの詳細を表示` を選択し, NDKおよびCMakeをそれぞれクリックして, 対応するバージョンのツールが選択されていることを確認してください, SDKツールのバージョン情報は, AutoJs6プロジェクトのルートディレクトリにある `version.properties` ファイルに記載されています.

#### JDKの準備

AutoJs6プロジェクトが依存する `JDK (Java開発キット)` のリリースバージョンは少なくとも `17` で, それ以下のバージョンは推奨されませんが, 最低でも `19` の使用を推奨します.

2025 年 5 月 27 日 現在, AutoJs6がサポートする最大のJDKバージョンは `24` です.

> 注: コンピュータシステムに適切なバージョンのJDKがインストールされている場合, この節の内容をスキップできます.

JDK は IDE から直接ダウンロードするか, [Oracle サイト](https://www.oracle.com/java/technologies/downloads/) にアクセスしてダウンロードできます.

Android Studio ソフトウェアでショートカットキー `CTRL + ALT + S` を使用して設定ページを開きます:

```text
Build, Execution, Deployment (ビルド, 実行, 展開) -> 
Build Tools (ビルドツール) -> 
Gradle
```

`Gradle JDK` で異なるバージョンの JDK を選択または追加できます.

リストに適切なバージョンのJDKが存在する場合(>= `17`), それを選択してください.  
または, `Download JDK (JDK をダウンロード)` を選択して適切な JDK をダウンロードし, `Download (ダウンロード)` ボタンをクリックしてダウンロードが完了するのを待ちます.  
`Add JDK (JDK を追加)` を選択して既存のローカル JDK を追加し, そのディレクトリを指定して JDK を追加することも可能です.

#### AutoJs6リソースのクローン

Android Studio のメインページで `Get from VCS (バージョン管理システムから取得)` ボタンをクリックします.  
`URL (統一リソースロケーターロケーション)` の欄に `https://github.com/SuperMonster003/AutoJs6.git` を入力します,  
`Directory (ディレクトリ)` の欄を必要に応じて特定のパスに変更できます.  
`Clone (クローン)` ボタンをクリックし, AutoJs6 プロジェクト リソースがデバイスにローカルにクローンされるのを待ちます.

> 注: 上記プロセスには[Git (バージョン管理システム)](https://git-scm.com/download)をインストールする必要がある場合があります.

#### AutoJs6プロジェクトのビルド

クローンが完了すると, Android Studio は AutoJs6 のプロジェクト ウィンドウを開き, `Dependencies (依存関係)` の初期ダウンロードおよび Gradle の構築作業を自動的に完了します.

> 注: 上記のプロセスは非常に時間がかかる可能性があります. ネットワーク条件が悪い場合, 異なるボタンをクリックして再試行する必要がある場合があります.

ビルドが自動的に進行しなかった場合, またはプロジェクトを再ビルドする必要がある場合は, 次の手順に従ってください:

- ツールバーの `Run/Debug Configurations` メニューから `app` を選択します. これは AutoJs6 のメインアプリです
- `Build Project` (ハンマーアイコン) のボタンを左側でクリックして, プロジェクトのビルドを開始します. デフォルトのショートカットは CTRL + F9 です
- ビルドが完了するのを待ちます. `Builder Output` タブに "BUILD SUCCESSFUL in 1h 17m 34s" のようなメッセージが表示されます

ビルドに失敗した場合は, エラーメッセージを AutoJs6 プロジェクトの [Issues](http://issues.autojs6.com) ページに報告できます.

> 注: アプリのビルドおよび実行方法の詳細については, [Android Docs](https://developer.android.com/studio/run?hl=en) を参照してください

#### AutoJs6 プロジェクトのデプロイ (アプリの実行)

プロジェクトが正常にビルドされた後, 実機 (例: スマートフォン/タブレット) や仮想デバイス (例: Android エミュレーター) にアプリとしてデプロイできます.

- ツールバーで `Run/Debug Configurations` メニューから `app` を選択します. これが AutoJs6 のメインアプリです
- 右側の `Available Devices` ドロップダウンから, プロジェクトアプリを実行するデバイス (実機または仮想デバイス) を選択します
- 右側の `Run` (三角形アイコン) のボタンをクリックして, アプリを起動します. デフォルトのショートカットは `F10` です
- デプロイが完了するのを待ちます. 選択したデバイスが自動的にアプリをインストールして実行します

#### AutoJs6 プロジェクトのデプロイ (APKの生成)

プロジェクトをパッケージして, Android デバイスにインストール可能な APK ファイルを生成します:

- デバッグ版 (デバッグバージョン)
    - `Build (ビルド)` -> `Build Bundle(s) / APK(s)` -> `Build APK(s)`
    - デフォルトの署名が含まれたデバッグ版のインストールパッケージを生成します
    - パスの例: `"D:\AutoJs6\app\build\outputs\apk\debug\"`
- リリース版 (リリースバージョン)
    - `Build (ビルド)` -> `Generate Signed Bundle / APK`
    - `APK` オプションを選択します
    - 署名ファイル (新規または選択) を準備して署名付きのリリース版インストールパッケージを生成します
    - パスの例: `"D:\AutoJs6\app\release\"`

> 注: ユーザー向けにリリースするアプリのビルド方法の詳細については, [Android Docs](https://developer.android.com/build/build-for-release?hl=en) を参照してください

#### AutoJs6 用の定義済み Gradle ビルドタスク

プロジェクトのアプリをビルドする以外にも, AutoJs6 はいくつかの定義済み Gradle ビルドタスクをサポートしており, これらは開発者がプロジェクト関連の便利な操作を行うのに役立ちます.

ツールバーの `Run/Debug Configurations` メニューには, 各タスクの左側に象のアイコンが表示される様々な定義済み Gradle タスクがあります.

- AutoJs6 [inrt:assemble]

"inrt" ビルドバリアントをアセンブルします. これは主に AutoJs6 のスクリプトパッケージ機能のためのものです.

AutoJs6 プロジェクトにはさまざまなビルドバリアントがあります. その中で "inrt" バリアントは, スクリプトパッケージ機能のために使用され, パッケージ用のテンプレートファイル "template.apk" を生成します.

パッケージ機能を使用する際に, 次のエラーメッセージが表示される場合があります:

> java.io.FileNotFoundException: template.apk

これはテンプレートファイルが存在しないことを示しています. テンプレートファイルを生成するために, 手動で `inrt:assemble` タスクを実行し, その後に再度ビルドしてデプロイしてください.

> 注: メインプロジェクトのコードに変更があり, パッケージ化されたアプリに変更を反映させたい場合は, `inrt:assemble` タスクを再実行してテンプレートファイルを生成し, アプリを再デプロイする必要があります

- AutoJs6 [app:bundle]

デバッグビルドプロセスの成果物をパッケージします. これは主に [AutoJs6 型定義](http://dts-project.autojs6.com) プロジェクトに使用されます.

タスク実行後, AutoJs6 プロジェクトの最新の JAR ファイルが生成されます. [Android d.ts Generator](https://github.com/NativeScript/android-dts-generator) ([NativeScript](https://github.com/NativeScript) 作) のツールを使用して, AutoJs6 メインアプリの型定義 (d.ts 形式のファイル) を生成できます.

- AutoJs6 [app:digest]

リリースビルドで生成された APK ファイルにダイジェスト情報を付加します. これは, GitHub に最新バージョンの AutoJs6 を公開する前に, 最終的なファイル名を確定するためのものです.

以下は, ダイジェスト情報を付加する前後のファイル名の比較です:

```text
前:
autojs6-v6.6.2-arm64-v8a.apk
後:
autojs6-v6.6.2-arm64-v8a-0f2a9d74.apk
```

> 参照: [Android Docs](https://developer.android.com/studio/run?hl=zh-cn)

******

### <a id="script-development-assistance"></a>スクリプト開発アシスト

******

AutoJs6に対応するスクリプトを開発するには, 適切な開発ツールを使用する必要があります:

- [VSCode](https://code.visualstudio.com/download) / [WebStorm](https://www.jetbrains.com/webstorm/download/) / [HBuilderX](https://www.dcloud.io/hbuilderx.html) ...

PCでスクリプトを作成してデバッグする場合, VSCodeプラグインを使用してPCと携帯電話を接続できます:

- [AutoJs6-VSCode-Extension](http://vscext-project.autojs6.com) - AutoJs6 デバッガ (VSCode プラットフォーム エクステンション)

開発ツールを使用してコードを記述する際, コードのインテリセンス機能が開発者のコード記述を支援します:

- [AutoJs6-TypeScript-Declarations](http://dts-project.autojs6.com) - AutoJs6型宣言ファイル (コード補完機能)

AutoJs6に関するAPIおよび使用方法については, 常にアプリケーションドキュメントを参照できます:

- [AutoJs6-Documentation](http://docs-project.autojs6.com) - AutoJs6アプリケーションドキュメント

既存のスクリプト開発プロジェクトを参考にして, 個人のスクリプトプロジェクトのインスピレーションを得ることができます:

- [Ant-Forest](https://github.com/TonyJiangWJ/Ant-Forest) - 蚂蚁森林のエネルギー自動収集スクリプト by [TonyJiangWJ](https://github.com/TonyJiangWJ)
- [Ant-Forest](https://github.com/SuperMonster003/Ant-Forest) - 蚂蚁森林のエネルギー自動収集スクリプト by [SuperMonster003](https://github.com/SuperMonster003)
- [autojs](https://github.com/e1399579/autojs) - Auto.jsのユーティリティスクリプト by [e1399579](https://github.com/e1399579)
- [autojsDemo](https://github.com/snailuncle/autojsDemo) - Auto.jsのデモ例 by [snailuncle](https://github.com/snailuncle)
- [autojs関連リポジトリ](https://github.com/topics/autojs) - GitHubでautojs話題に関するすべてのリポジトリ

******

### 貢献の参加

******

AutoJs6 プロジェクト開発に参加したすべての貢献者に感謝します.

|         <span style="word-break:keep-all;white-space:nowrap">貢献者</span>          |                   <span style="word-break:keep-all;white-space:nowrap">コミット数</span>                    | <span style="word-break:keep-all;white-space:nowrap">最近の提出</span> |
|:-------------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------:|
|             <span style="word-break:keep-all;white-space:nowrap">[wirsnow](https://github.com/wirsnow)</span>             |         <span style="word-break:keep-all;white-space:nowrap">[1](https://github.com/SuperMonster003/AutoJs6/commits?author=wirsnow)</span>         |                    <span style="word-break:keep-all;white-space:nowrap">`2025/05/19`</span>                    |
|         <span style="word-break:keep-all;white-space:nowrap">[TonyJiangWJ](https://github.com/TonyJiangWJ)</span>         |       <span style="word-break:keep-all;white-space:nowrap">[5](https://github.com/SuperMonster003/AutoJs6/commits?author=TonyJiangWJ)</span>       |                    <span style="word-break:keep-all;white-space:nowrap">`2025/04/24`</span>                    |
|          <span style="word-break:keep-all;white-space:nowrap">[luckyloogn](https://github.com/luckyloogn)</span>          |       <span style="word-break:keep-all;white-space:nowrap">[3](https://github.com/SuperMonster003/AutoJs6/commits?author=luckyloogn)</span>        |                    <span style="word-break:keep-all;white-space:nowrap">`2025/01/01`</span>                    |
|                <span style="word-break:keep-all;white-space:nowrap">[kvii](https://github.com/kvii)</span>                |          <span style="word-break:keep-all;white-space:nowrap">[1](https://github.com/SuperMonster003/AutoJs6/commits?author=kvii)</span>           |                    <span style="word-break:keep-all;white-space:nowrap">`2024/10/16`</span>                    |
|   <span style="word-break:keep-all;white-space:nowrap">[chenguangming](https://github.com/chenguangming) `(Tom)`</span>   | <span style="word-break:keep-all;white-space:nowrap">[2](https://github.com/SuperMonster003/AutoJs6/pulls?q=is%3Apr+author%3Achenguangming)</span> |                    <span style="word-break:keep-all;white-space:nowrap">`2024/05/14`</span>                    |
|          <span style="word-break:keep-all;white-space:nowrap">[LZX284](https://github.com/LZX284) `(AI)`</span>           |         <span style="word-break:keep-all;white-space:nowrap">[17](https://github.com/SuperMonster003/AutoJs6/commits?author=LZX284)</span>         |                    <span style="word-break:keep-all;white-space:nowrap">`2023/11/19`</span>                    |
| <span style="word-break:keep-all;white-space:nowrap">[little&#x2011;alei](https://github.com/little-alei) `(抠脚本人)`</span> |      <span style="word-break:keep-all;white-space:nowrap">[12](https://github.com/SuperMonster003/AutoJs6/commits?author=little-alei)</span>       |                    <span style="word-break:keep-all;white-space:nowrap">`2023/07/12`</span>                    |
|              <span style="word-break:keep-all;white-space:nowrap">[aiselp](https://github.com/aiselp)</span>              |    <span style="word-break:keep-all;white-space:nowrap">[6](https://github.com/SuperMonster003/AutoJs6/pulls?q=is%3Apr+author%3Aaiselp)</span>     |                    <span style="word-break:keep-all;white-space:nowrap">`2023/06/14`</span>                    |
|           <span style="word-break:keep-all;white-space:nowrap">[LYS86](https://github.com/LYS86) `(Lin)`</span>           |          <span style="word-break:keep-all;white-space:nowrap">[2](https://github.com/SuperMonster003/AutoJs6/commits?author=LYS86)</span>          |                    <span style="word-break:keep-all;white-space:nowrap">`2023/06/03`</span>                    |

データは 2025 年 5 月 27 日 に更新されました.

データ項目は `最近の提出` の降順で並べ替えられます.

新たに発行された未処理のプルリクエストは, マージされた後にデータ統計に含まれます.

一部の貢献者は [GitHub Contributors](https://github.com/SuperMonster003/AutoJs6/graphs/contributors) に正常に表示されず, コミット記録が空のままです. 貢献履歴は [プルリクエスト](https://github.com/SuperMonster003/AutoJs6/pulls) から確認できます.

[//]: # (
    # --------------------------------------------------------------#
    # Before committing and pushing to the remote GitHub repository #
    # --------------------------------------------------------------#
    - IDE
        - The summary of the latest changelog for committing to Git [ DO NOT commit or push ]
    - $projectDir/version.properties
        - Remove the part like [ alpha / beta / ... ] of VERSION_NAME
    - $projectDir/.changelog/lang_zh-Hans.json
        - Update version name and released date
        - Translate into other languages
        - Update TypeScript declarations according to section `dependency` if needed
    - $projectDir/.readme/template_readme.md
        - Update badges like [ android studio / rhino / ... ]
        - Update contribution section: 貢献の参加
    - $projectDir/.readme/common.json
        - Update android studio download links and version names
        - Update contribution section: var_date_contribution_table_data_updated
    - $projectDir/.python/generate_markdown.py
        - Re-generate markdown by running the python script [ link: aj6mdgen ]
    - Others
        - Re-generate documentation by running the python script [ link: aj6docgen ]
        - Check the two-way versions for AutoJs6 and VSCode ext, then publish the ext to Microsoft if needed
        - Run Gradle task "app:assembleInrtRelease" [ shortcut: C+A+0#- ]
        - Build APK to determine the final VERSION_BUILD field [ shortcut: C+A+0#A ]
        - Run Gradle task "app:appendDigestToReleasedFiles" [ shortcut: C+A+0#= ]
        - Check VERSION_BUILD in version.properties with released apks
        - Commit and push to GitHub
        - Publish the latest release with signed APKs
)