/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Iterator;
import java.util.LinkedHashMap;
import org.mozilla.javascript.Slot;
import org.mozilla.javascript.SlotMap;
import org.mozilla.javascript.SlotMapOwner;

public class HashSlotMap
implements SlotMap {
    private final LinkedHashMap<Object, Slot> map;

    public HashSlotMap() {
        this.map = new LinkedHashMap();
    }

    protected HashSlotMap(int capacity) {
        this.map = new LinkedHashMap(capacity);
    }

    public HashSlotMap(SlotMap oldMap) {
        this.map = new LinkedHashMap(oldMap.size());
        for (Slot n : oldMap) {
            this.add(null, n.copySlot());
        }
    }

    public HashSlotMap(SlotMap oldMap, Slot newSlot) {
        this.map = new LinkedHashMap(oldMap.dirtySize() + 1);
        for (Slot n : oldMap) {
            this.add(null, n.copySlot());
        }
        this.add(null, newSlot);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Slot query(Object key, int index) {
        Object name = this.makeKey(key, index);
        return this.map.get(name);
    }

    @Override
    public Slot modify(SlotMapOwner owner, Object key, int index, int attributes) {
        Object name = this.makeKey(key, index);
        return this.map.computeIfAbsent(name, n -> new Slot(key, index, attributes));
    }

    @Override
    public <S extends Slot> S compute(SlotMapOwner owner, Object key, int index, SlotMap.SlotComputer<S> c) {
        Object name = this.makeKey(key, index);
        Slot ret = this.map.compute(name, (n, existing) -> c.compute(key, index, (Slot)existing));
        return (S)ret;
    }

    @Override
    public void add(SlotMapOwner owner, Slot newSlot) {
        Object name = this.makeKey(newSlot);
        this.map.put(name, newSlot);
    }

    @Override
    public Iterator<Slot> iterator() {
        return this.map.values().iterator();
    }

    private Object makeKey(Object name, int index) {
        return name == null ? String.valueOf(index) : name;
    }

    private Object makeKey(Slot slot) {
        return slot.name == null ? String.valueOf(slot.indexOrHash) : slot.name;
    }
}

