/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.kohsuke.github.GHCreateRepositoryBuilder;
import org.kohsuke.github.GHEvent;
import org.kohsuke.github.GHEventInfo;
import org.kohsuke.github.GHHook;
import org.kohsuke.github.GHHooks;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHPerson;
import org.kohsuke.github.GHProject;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHTeam;
import org.kohsuke.github.GHTeamBuilder;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Requester;
import org.kohsuke.github.internal.Previews;

public class GHOrganization
extends GHPerson {
    private boolean has_organization_projects;

    @Deprecated
    public GHRepository createRepository(String name, String description, String homepage, String team, boolean isPublic) throws IOException {
        GHTeam t = this.getTeams().get(team);
        if (t == null) {
            throw new IllegalArgumentException("No such team: " + team);
        }
        return this.createRepository(name, description, homepage, t, isPublic);
    }

    @Deprecated
    public GHRepository createRepository(String name, String description, String homepage, GHTeam team, boolean isPublic) throws IOException {
        if (team == null) {
            throw new IllegalArgumentException("Invalid team");
        }
        return ((GHCreateRepositoryBuilder)((GHCreateRepositoryBuilder)((GHCreateRepositoryBuilder)this.createRepository(name).description(description)).homepage(homepage)).private_(!isPublic)).team(team).create();
    }

    public GHCreateRepositoryBuilder createRepository(String name) {
        return new GHCreateRepositoryBuilder(name, this.root(), "/orgs/" + this.login + "/repos");
    }

    public Map<String, GHTeam> getTeams() throws IOException {
        TreeMap<String, GHTeam> r = new TreeMap<String, GHTeam>();
        for (GHTeam t : this.listTeams()) {
            r.put(t.getName(), t);
        }
        return r;
    }

    public PagedIterable<GHTeam> listTeams() throws IOException {
        return ((Requester)this.root().createRequest().withUrlPath(String.format("/orgs/%s/teams", this.login), new String[0])).toIterable(GHTeam[].class, item -> item.wrapUp(this));
    }

    @Deprecated
    public GHTeam getTeam(int teamId) throws IOException {
        return this.getTeam((long)teamId);
    }

    public GHTeam getTeam(long teamId) throws IOException {
        return ((Requester)this.root().createRequest().withUrlPath(String.format("/organizations/%d/team/%d", this.getId(), teamId), new String[0])).fetch(GHTeam.class).wrapUp(this);
    }

    public GHTeam getTeamByName(String name) throws IOException {
        for (GHTeam t : this.listTeams()) {
            if (!t.getName().equals(name)) continue;
            return t;
        }
        return null;
    }

    public GHTeam getTeamBySlug(String slug) throws IOException {
        return ((Requester)this.root().createRequest().withUrlPath(String.format("/orgs/%s/teams/%s", this.login, slug), new String[0])).fetch(GHTeam.class).wrapUp(this);
    }

    public void add(GHUser user, Role role) throws IOException {
        ((Requester)((Requester)((Requester)this.root().createRequest().method("PUT")).with("role", role.name().toLowerCase())).withUrlPath("/orgs/" + this.login + "/memberships/" + user.getLogin(), new String[0])).send();
    }

    public boolean hasMember(GHUser user) {
        try {
            ((Requester)this.root().createRequest().withUrlPath("/orgs/" + this.login + "/members/" + user.getLogin(), new String[0])).send();
            return true;
        }
        catch (IOException ignore) {
            return false;
        }
    }

    public void remove(GHUser user) throws IOException {
        ((Requester)((Requester)this.root().createRequest().method("DELETE")).withUrlPath("/orgs/" + this.login + "/members/" + user.getLogin(), new String[0])).send();
    }

    public boolean hasPublicMember(GHUser user) {
        try {
            ((Requester)this.root().createRequest().withUrlPath("/orgs/" + this.login + "/public_members/" + user.getLogin(), new String[0])).send();
            return true;
        }
        catch (IOException ignore) {
            return false;
        }
    }

    public void publicize(GHUser u) throws IOException {
        ((Requester)((Requester)this.root().createRequest().method("PUT")).withUrlPath("/orgs/" + this.login + "/public_members/" + u.getLogin(), new String[0])).send();
    }

    public List<GHUser> getMembers() throws IOException {
        return this.listMembers().toList();
    }

    public PagedIterable<GHUser> listMembers() throws IOException {
        return this.listMembers("members");
    }

    public PagedIterable<GHUser> listPublicMembers() throws IOException {
        return this.listMembers("public_members");
    }

    private PagedIterable<GHUser> listMembers(String suffix) throws IOException {
        return this.listMembers(suffix, null, null);
    }

    public PagedIterable<GHUser> listMembersWithFilter(String filter) throws IOException {
        return this.listMembers("members", filter, null);
    }

    public PagedIterable<GHUser> listMembersWithRole(String role) throws IOException {
        return this.listMembers("members", null, role);
    }

    private PagedIterable<GHUser> listMembers(String suffix, String filter, String role) throws IOException {
        return ((Requester)((Requester)((Requester)this.root().createRequest().withUrlPath(String.format("/orgs/%s/%s", this.login, suffix), new String[0])).with("filter", filter)).with("role", role)).toIterable(GHUser[].class, null);
    }

    public void conceal(GHUser u) throws IOException {
        ((Requester)((Requester)this.root().createRequest().method("DELETE")).withUrlPath("/orgs/" + this.login + "/public_members/" + u.getLogin(), new String[0])).send();
    }

    public boolean areOrganizationProjectsEnabled() {
        return this.has_organization_projects;
    }

    public void enableOrganizationProjects(boolean newStatus) throws IOException {
        this.edit("has_organization_projects", newStatus);
    }

    private void edit(String key, Object value) throws IOException {
        ((Requester)((Requester)((Requester)this.root().createRequest().withUrlPath(String.format("/orgs/%s", this.login), new String[0])).method("PATCH")).with(key, value)).fetchInto(this);
    }

    public PagedIterable<GHProject> listProjects(GHProject.ProjectStateFilter status) throws IOException {
        return ((Requester)((Requester)((Requester)this.root().createRequest().withPreview(Previews.INERTIA)).with("state", status)).withUrlPath(String.format("/orgs/%s/projects", this.login), new String[0])).toIterable(GHProject[].class, null);
    }

    public PagedIterable<GHProject> listProjects() throws IOException {
        return this.listProjects(GHProject.ProjectStateFilter.OPEN);
    }

    public GHProject createProject(String name, String body) throws IOException {
        return ((Requester)((Requester)((Requester)((Requester)((Requester)this.root().createRequest().method("POST")).withPreview(Previews.INERTIA)).with("name", name)).with("body", body)).withUrlPath(String.format("/orgs/%s/projects", this.login), new String[0])).fetch(GHProject.class);
    }

    @Deprecated
    public GHTeam createTeam(String name, Permission p, Collection<GHRepository> repositories) throws IOException {
        Requester post = (Requester)((Requester)((Requester)this.root().createRequest().method("POST")).with("name", name)).with("permission", p);
        ArrayList<String> repo_names = new ArrayList<String>();
        for (GHRepository r : repositories) {
            repo_names.add(this.login + "/" + r.getName());
        }
        post.with("repo_names", repo_names);
        return ((Requester)post.withUrlPath("/orgs/" + this.login + "/teams", new String[0])).fetch(GHTeam.class).wrapUp(this);
    }

    @Deprecated
    public GHTeam createTeam(String name, Permission p, GHRepository ... repositories) throws IOException {
        return this.createTeam(name, p, Arrays.asList(repositories));
    }

    @Deprecated
    public GHTeam createTeam(String name, Collection<GHRepository> repositories) throws IOException {
        Requester post = (Requester)((Requester)this.root().createRequest().method("POST")).with("name", name);
        ArrayList<String> repo_names = new ArrayList<String>();
        for (GHRepository r : repositories) {
            repo_names.add(this.login + "/" + r.getName());
        }
        post.with("repo_names", repo_names);
        return ((Requester)post.withUrlPath("/orgs/" + this.login + "/teams", new String[0])).fetch(GHTeam.class).wrapUp(this);
    }

    @Deprecated
    public GHTeam createTeam(String name, GHRepository ... repositories) throws IOException {
        return this.createTeam(name, Arrays.asList(repositories));
    }

    public GHTeamBuilder createTeam(String name) {
        return new GHTeamBuilder(this.root(), this.login, name);
    }

    public List<GHRepository> getRepositoriesWithOpenPullRequests() throws IOException {
        ArrayList<GHRepository> r = new ArrayList<GHRepository>();
        for (GHRepository repository : this.listRepositories(100)) {
            List<GHPullRequest> pullRequests = repository.getPullRequests(GHIssueState.OPEN);
            if (pullRequests.size() <= 0) continue;
            r.add(repository);
        }
        return r;
    }

    public List<GHPullRequest> getPullRequests() throws IOException {
        ArrayList<GHPullRequest> all = new ArrayList<GHPullRequest>();
        for (GHRepository r : this.getRepositoriesWithOpenPullRequests()) {
            all.addAll(r.getPullRequests(GHIssueState.OPEN));
        }
        return all;
    }

    @Override
    public PagedIterable<GHEventInfo> listEvents() throws IOException {
        return ((Requester)this.root().createRequest().withUrlPath(String.format("/orgs/%s/events", this.login), new String[0])).toIterable(GHEventInfo[].class, null);
    }

    @Override
    public PagedIterable<GHRepository> listRepositories(int pageSize) {
        return ((Requester)this.root().createRequest().withUrlPath("/orgs/" + this.login + "/repos", new String[0])).toIterable(GHRepository[].class, null).withPageSize(pageSize);
    }

    public List<GHHook> getHooks() throws IOException {
        return GHHooks.orgContext(this).getHooks();
    }

    public GHHook getHook(int id) throws IOException {
        return GHHooks.orgContext(this).getHook(id);
    }

    public void deleteHook(int id) throws IOException {
        GHHooks.orgContext(this).deleteHook(id);
    }

    public GHHook createHook(String name, Map<String, String> config, Collection<GHEvent> events, boolean active) throws IOException {
        return GHHooks.orgContext(this).createHook(name, config, events, active);
    }

    public GHHook createWebHook(URL url, Collection<GHEvent> events) throws IOException {
        return this.createHook("web", Collections.singletonMap("url", url.toExternalForm()), events, true);
    }

    public GHHook createWebHook(URL url) throws IOException {
        return this.createWebHook(url, null);
    }

    public static enum Role {
        ADMIN,
        MEMBER;

    }

    public static enum Permission {
        ADMIN,
        MAINTAIN,
        PUSH,
        TRIAGE,
        PULL;

    }

    public static class RepositoryRole {
        private final String permission;

        private RepositoryRole(String permission) {
            this.permission = permission;
        }

        public static RepositoryRole custom(String permission) {
            return new RepositoryRole(permission);
        }

        public static RepositoryRole from(Permission permission) {
            return RepositoryRole.custom(permission.toString().toLowerCase());
        }

        public String toString() {
            return this.permission;
        }
    }
}

