/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.android.dx.dex.file;

import com.legacy.android.dex.DexIndexOverflowException;
import com.legacy.android.dx.command.dexer.Main;
import com.legacy.android.dx.dex.file.DexFile;
import com.legacy.android.dx.dex.file.Item;
import com.legacy.android.dx.dex.file.MemberIdItem;
import com.legacy.android.dx.dex.file.MethodIdsSection;
import com.legacy.android.dx.dex.file.UniformItemSection;
import java.util.Formatter;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class MemberIdsSection
extends UniformItemSection {
    public MemberIdsSection(String name, DexFile file) {
        super(name, file, 4);
    }

    @Override
    protected void orderItems() {
        int idx = 0;
        if (this.items().size() > 65536) {
            throw new DexIndexOverflowException(this.getTooManyMembersMessage());
        }
        for (Item item : this.items()) {
            ((MemberIdItem)item).setIndex(idx);
            ++idx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTooManyMembersMessage() {
        TreeMap<String, AtomicInteger> membersByPackage = new TreeMap<String, AtomicInteger>();
        for (Item item : this.items()) {
            String packageName = ((MemberIdItem)item).getDefiningClass().getPackageName();
            AtomicInteger count = (AtomicInteger)membersByPackage.get(packageName);
            if (count == null) {
                count = new AtomicInteger();
                membersByPackage.put(packageName, count);
            }
            count.incrementAndGet();
        }
        Formatter formatter = new Formatter();
        try {
            String string = this instanceof MethodIdsSection ? "method" : "field";
            formatter.format("Too many %s references: %d; max is %d.%n" + Main.getTooManyIdsErrorMessage() + "%n" + "References by package:", string, this.items().size(), 65536);
            for (Map.Entry entry : membersByPackage.entrySet()) {
                formatter.format("%n%6d %s", ((AtomicInteger)entry.getValue()).get(), entry.getKey());
            }
            String string2 = formatter.toString();
            return string2;
        }
        finally {
            formatter.close();
        }
    }
}

