/*
 * Decompiled with CFR 0.152.
 */
package eu.medsea.mimeutil;

import eu.medsea.mimeutil.MimeException;
import java.io.Serializable;
import java.util.regex.Pattern;

public class MimeType
implements Comparable,
Serializable {
    private static final long serialVersionUID = -1324243127744494894L;
    private static final Pattern mimeSplitter = Pattern.compile("[/;]++");
    protected String type = "*";
    protected String subtype = "*";
    private int specificity = 1;

    public MimeType(MimeType mimeType) {
        this.type = mimeType.type;
        this.subtype = mimeType.subtype;
        this.specificity = mimeType.specificity;
    }

    public MimeType(String mimeType) throws MimeException {
        if (mimeType == null || mimeType.trim().length() == 0) {
            throw new MimeException("Invalid MimeType [" + mimeType + "]");
        }
        String[] parts = mimeSplitter.split(mimeType.trim());
        if (parts.length > 0) {
            this.type = this.getValidType(parts[0]);
        }
        if (parts.length > 1) {
            this.subtype = this.getValidSubtype(parts[1]);
        }
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    private boolean match(String mimeType) {
        return this.toString().equals(mimeType);
    }

    public int hashCode() {
        return 31 * this.type.hashCode() + this.subtype.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof MimeType) {
            if (this.type.equals(((MimeType)o).type) && this.subtype.equals(((MimeType)o).subtype)) {
                return true;
            }
        } else if (o instanceof String) {
            return this.match((String)o);
        }
        return false;
    }

    public String toString() {
        return this.type + "/" + this.subtype;
    }

    public int getSpecificity() {
        return this.specificity;
    }

    void setSpecificity(int specificity) {
        this.specificity = specificity;
    }

    private String getValidType(String type) {
        if (type == null || type.trim().length() == 0) {
            return "*";
        }
        return type;
    }

    private String getValidSubtype(String subtype) {
        if (subtype == null || subtype.trim().length() == 0 || "*".equals(this.type)) {
            return "*";
        }
        return subtype;
    }

    public int compareTo(Object arg0) {
        if (arg0 instanceof MimeType) {
            return this.toString().compareTo(((MimeType)arg0).toString());
        }
        return 0;
    }
}

