## Поиск цвета

Поиск цвета поддерживает следующие 5 методов. Все методы не зависят от регистра (case-insensitive).

### 1. Название цвета (текущий язык)

Искать, используя название цвета на текущем языке интерфейса.

#### Пример 1.1: красный

Находит все названия цветов, содержащие «красный», например «Красный», «Кирпичный красный», «Оранжево-красный», «Красный (200)» и т. д.

#### Пример 1.2: синий50

Находит все названия цветов, содержащие «синий50». При сопоставлении игнорируются все неалфавитные и нецифровые символы (пробелы, скобки, слэши, дефисы и т. д.). Поэтому «синий50» может совпадать с «Синий (50)», «Синий (500)», но не с «Синий серый (50)», потому что «серый» нельзя игнорировать.

### 2. Название цвета (английское)

Начните со знака "$", чтобы включить режим поиска по английскому названию цвета.

#### Пример 2.1: $red

Находит все английские названия цветов, содержащие «red», например «Красный», «Кирпичный красный», «Оранжево-красный» и т. д. Даже если язык интерфейса не английский, можно искать соответствующий цвет с помощью английского ключевого слова.

#### Пример 2.2: $blue50

Аналогично примеру 1.2, совпадает с «Синий (50)», «Синий (500)», «Светло-голубой (50)» и т. д.

### 3. HEX

Чтобы включить поиск в формате HEX, начинайте строку с «#».

#### Пример 3.1: #FF007F

Находит цвет с HEX «#FF007F», например «Розовый».

#### Пример 3.2: #FF

Находит все цвета, в которых HEX начинается с «#FF», например «#FF8099», «#FF00CB», «#FFFAFA» и т. д.

### 4. Регулярное выражение

Чтобы включить поиск по регулярному выражению, начинайте строку с «/» и заканчивайте «/» (аналогично синтаксису JavaScript).

#### Пример 4.1: /красный|оранжевый|желтый/

Находит все названия цветов, содержащие «Красный», «Оранжевый» или «Желтый».

#### Пример 4.2: /\b50\b/

Находит все названия цветов, содержащие «50» с границами слова по обе стороны, например «Красный (50)», «Розовый (50)», «Желтый (50)» и т. д., но исключает «Красный (500)», «Розовый (500)» и т. п.

#### Пример 4.3: /red|orange/

Аналогично примеру 2.2, данное регулярное выражение также находит английские названия цветов. /red|orange/ может совпадать с «Насыщенный красный», «Обожжённый оранжевый», «Бледный фиолетово-красный» и др.

### 5. HEX. Регулярное выражение

Чтобы включить поиск по регулярному выражению в HEX, начинайте строку с «#/» и заканчивайте «/».

#### Пример 5.1: #/FF\b/

Находит все HEX, содержащие «FF» как границу слова в конце (формат «#xxxxFF»), например «#2962FF», «#D94DFF», «#F0F8FF» и т. д.

#### Пример 5.2: #/#FF/

Находит все HEX, содержащие «#FF» (аналогично примеру 3.2), в формате «#FFxxxx».

#### Пример 5.3: #/#..FF/

Находит все HEX, содержащие «FF» посередине (формат «#xxFFxx»), например «#CCFF00», «#66FFE6», «#00FF7F» и т. д.

#### Пример 5.4: #/#((?<!0).){2}0000/

Находит все HEX, в которых присутствует только красный канал («#xx0000»), исключая чёрный. Примеры: «#8B0000», «#D50000», «#FF0000» и др.

#### Пример 5.5: #/#0000(.(?!0)){2}/

Находит все HEX, содержащие только синий канал («#0000xx»), исключая чёрный. Примеры: «#00008B», «#0000CD», «#0000FF» и др.

#### Пример 5.6: #/#00((?!0).)(.(?<!0))00/

Находит все HEX, содержащие только зелёный канал («#00xx00»), исключая чёрный. Примеры: «#006400», «#00FF00» и др.