<!--suppress HtmlDeprecatedAttribute, HttpUrlsUsage -->

<div align="center">
  <p>
    <img src="https://s1.imagehub.cc/images/2023/03/07/af8ed087c9d354b9ab6142aae7bbafb6.png" alt="autojs6-banner_800×224" border="0" width="704" />
  </p>

  <p>Herramienta de automatización JavaScript que soporta servicios de accesibilidad en la plataforma Android</p>

  <p>
    <a href="http://download.autojs6.com"><img alt="GitHub release (latest by date)" src="https://img.shields.io/github/v/release/SuperMonster003/AutoJs6"/></a>
    <a href="http://issues.autojs6.com"><img alt="GitHub closed issues" src="https://img.shields.io/github/issues/SuperMonster003/AutoJs6?color=A24232"/></a>
    <a href="http://commit.autojs6.com/99a1d8490fac5b6d55f6f183db59ad833a2064ed"><img alt="Created" src="https://img.shields.io/date/1636632233?color=2e7d32&label=created"/></a>
    <br>
    <a href="https://github.com/mozilla/rhino"><img alt="Rhino" src="https://img.shields.io/badge/rhino-1.8.1--SNAPSHOT-795548"/></a>
    <a href="https://developer.android.com/studio/archive"><img alt="Android Studio" src="https://img.shields.io/badge/android%20studio-2022.1+-B64FC8"/></a>
    <br>
    <a href="https://www.codefactor.io/repository/github/SuperMonster003/AutoJs6"><img alt="CodeFactor Grade" src="https://www.codefactor.io/repository/github/SuperMonster003/AutoJs6/badge"/></a>
    <a href="https://www.jetbrains.com/?from=AutoJs6"><img alt="JetBrains supporter" src="https://img.shields.io/badge/supporter-JetBrains-ee4677"/></a>
    <a href="http://project.autojs6.com/blob/master/LICENSE"><img alt="GitHub License" src="https://img.shields.io/github/license/SuperMonster003/AutoJs6?color=534BAE"/></a>
  </p>
</div>

******

### Idiomas

******

El archivo actual `README.md` admite los siguientes idiomas:

 - [简体中文 [zh-Hans]](http://project.autojs6.com/blob/master/.readme/README-zh-Hans.md)
 - [繁體中文 (香港) [zh-Hant-HK]](http://project.autojs6.com/blob/master/.readme/README-zh-Hant-HK.md)
 - [繁體中文 (台灣) [zh-Hant-TW]](http://project.autojs6.com/blob/master/.readme/README-zh-Hant-TW.md)
 - [English [en]](http://project.autojs6.com/blob/master/.readme/README-en.md)
 - [Français [fr]](http://project.autojs6.com/blob/master/.readme/README-fr.md)
 - Español [es] # actualmente
 - [日本語 [ja]](http://project.autojs6.com/blob/master/.readme/README-ja.md)
 - [한국어 [ko]](http://project.autojs6.com/blob/master/.readme/README-ko.md)
 - [Русский [ru]](http://project.autojs6.com/blob/master/.readme/README-ru.md)
 - [العربية [ar]](http://project.autojs6.com/blob/master/.readme/README-ar.md)

******

### Introducción

******

[Auto.js](https://github.com/hyb1996/Auto.js) es una herramienta de automatización para la plataforma Android que admite [servicios de accesibilidad](https://developer.android.com/guide/topics/ui/accessibility/service?hl=zh-cn).

Auto.js fue lanzado por [hyb1996](https://github.com/hyb1996) el `27/01/2017` y dejó de ser mantenido el `13/03/2020`, con su versión final denominada `4.1.1 Alpha2` y número de construcción `461`.

AutoJs6 se desarrolló sobre el proyecto final de Auto.js el `01/12/2021` y continúa siendo gratuito y de código abierto.

La siguiente tabla enumera algunos proyectos relacionados con Auto.js (ordenados por fecha de desarrollo):

| <span style="word-break:keep-all;white-space:nowrap">Proyecto</span> |                                                             <span style="word-break:keep-all;white-space:nowrap">Nombre de la app</span>                                                              | <span style="word-break:keep-all;white-space:nowrap">Desarrollador</span> | <span style="word-break:keep-all;white-space:nowrap">Fecha de inicio del desarrollo</span> | <span style="word-break:keep-all;white-space:nowrap">Fecha de finalización del desarrollo</span> |
|:------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------:|:---------------------------------------------------------------------------------------------------------------------------------:|:-------------------------------------------------------------------------------------------------------------------------------:|
|     <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/hyb1996/Auto.js)</span>      |    <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/TonyJiangWJ/Auto.js/commit/268ec8895bbfa28fc7715154eb15b1c1eaaefd14#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span>     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2017/01/27`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2020/03/13`</span>                             |
|                     <span style="word-break:keep-all;white-space:nowrap">Auto.js Pro 7</span>                      |                                                                                     <span style="word-break:keep-all;white-space:nowrap">Auto.js</span>                                                                                      |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2019/03/13`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2019/07/08`</span>                             |
|                     <span style="word-break:keep-all;white-space:nowrap">Auto.js Pro 8</span>                      |                                                                                    <span style="word-break:keep-all;white-space:nowrap">AutoJsPro</span>                                                                                     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2019/10/13`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2021/07/24`</span>                             |
|   <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/TonyJiangWJ/Auto.js)</span>    | <span style="word-break:keep-all;white-space:nowrap">[Auto.js&#160;M](https://github.com/TonyJiangWJ/Auto.js/commit/268ec8895bbfa28fc7715154eb15b1c1eaaefd14#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span> |      <span style="word-break:keep-all;white-space:nowrap">[TonyJiangWJ](https://github.com/TonyJiangWJ)</span>       |                             <span style="word-break:keep-all;white-space:nowrap">`2019/11/21`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|      <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/kkevsekk1/AutoX)</span>       |                 <span style="white-space:pre">[Autox.js](https://github.com/kkevsekk1/AutoX/commit/8143e4ed893d4af05d22aa791b83a962f9959873#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span>                  |        <span style="word-break:keep-all;white-space:nowrap">[kkevsekk1](https://github.com/kkevsekk1)</span>         |                             <span style="word-break:keep-all;white-space:nowrap">`2020/07/24`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|        <span style="word-break:keep-all;white-space:nowrap">[Auto.js Pro 9](https://pro.autojs.org/)</span>        |                                                                                    <span style="word-break:keep-all;white-space:nowrap">AutoJsPro</span>                                                                                     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2021/03/28`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2023/02/09`</span>                             |
| <span style="word-break:keep-all;white-space:nowrap">[AutoJs6](https://github.com/SuperMonster003/AutoJs6)</span>  |  <span style="word-break:keep-all;white-space:nowrap">[AutoJs6](https://github.com/SuperMonster003/AutoJs6/commit/a8ce1b9acb541e9736c33134be3194c3148a15a3#diff-833a46a97033e77558372a2dce103fd6fee29aaaa899f610022a7aece592ee7bR27)</span>  |  <span style="word-break:keep-all;white-space:nowrap">[SuperMonster003](https://github.com/SuperMonster003)</span>   |                             <span style="word-break:keep-all;white-space:nowrap">`2021/12/01`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|      <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/kkevsekk1/AutoX)</span>       |            <span style="white-space:pre">[Autox.js&#160;v6](https://github.com/kkevsekk1/AutoX/commit/8b6776cff8b0fca4be4a52719b7d7d07c0a058f3#diff-51a0b488f963eb0be6c6599bf5df497313877cf5bdff3950807373912ac1cdc9R130)</span>             |           <span style="word-break:keep-all;white-space:nowrap">[wilinz](https://github.com/wilinz)</span>            |                             <span style="word-break:keep-all;white-space:nowrap">`2022/05/26`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|        <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/aiselp/AutoX)</span>        |              <span style="white-space:pre">[Autox.js&#160;v7](https://github.com/aiselp/AutoX/commit/484491fd5fe12b8203d0b09c181eb0f471c0ea9f#diff-8cff73265af19c059547b76aca8882cbaa3209291406f52df1dafbbc78e80c46R120)</span>              |           <span style="word-break:keep-all;white-space:nowrap">[aiselp](https://github.com/aiselp)</span>            |                             <span style="word-break:keep-all;white-space:nowrap">`2024/04/21`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |

Las fechas en la tabla son estimadas y pueden no coincidir con las reales.

En la tabla, Auto.js Pro 7/8/9 son versiones pagas, mientras que las demás son versiones gratuitas y de código abierto.

******

### Funciones

******

* Puede utilizarse como IDE de JavaScript (autocompletado/renombrado de variables/formateo de código)
* Soporte para operaciones automatizadas basadas en el [servicio de accesibilidad](https://developer.android.com/reference/android/accessibilityservice/AccessibilityService)
* Soporte para acciones rápidas con botón flotante (grabación y ejecución de scripts/visualización del nombre del paquete y actividad/análisis de diseño)
* Soporte para la API de selectores proporcionando recorridos y acciones de control sobre los elementos (similar a [UiAutomator](https://developer.android.com/training/testing/ui-automator))
* Soporte para análisis de interfaz de diseño (similar al LayoutInspector de Android Studio)
* Soporte para grabación y reproducción de grabaciones
* Soporte para captura de pantalla/guardar capturas/búsqueda de color en imágenes/matching de imágenes
* Soporte para escribir interfaces usando [E4X](https://zh.wikipedia.org/wiki/E4X) (ECMAScript para XML)
* Soporte para empaquetar archivos o proyectos de scripts en archivos APK
* Soporte para funcionalidades extendidas utilizando permisos Root (clic y deslizamiento de pantalla/grabar/Shell)
* Soporte para su uso como un complemento de Tasker
* Soporte para la integración con VSCode para desarrollo de escritorio (requiere el [AutoJs6-VSCode-Extension](http://vscext-project.autojs6.com))

******

### Entorno

******

- Sistema operativo Android
- [API](https://developer.android.com/guide/topics/manifest/uses-sdk-element#ApiLevels) [24](https://developer.android.com/reference/android/os/Build.VERSION_CODES#N) ([7.0](https://zh.wikipedia.org/wiki/Android_Nougat)) [[N](https://developer.android.com/reference/android/os/Build.VERSION_CODES#N)] o superior

******

### Manual

******

* [Documentación de la aplicación](https://docs.autojs6.com)
* [Manual del usuario (Por escribir)](https://docs.autojs6.com/#/manual)
* [Solución de problemas](https://docs.autojs6.com/#/qa)
* [Compilación y construcción del proyecto](#project-compilation-and-build)
* [Asistencia en el desarrollo de scripts](#script-development-assistance)

******

### Principales cambios

******

En comparación con la versión final de Auto.js `4.1.1 Alpha2`, AutoJs6 ha realizado las siguientes actualizaciones o cambios principales:

* Soporte para obtener privilegios ADB usando [Shizuku](https://shizuku.rikka.app/introduction/) y usar las API del sistema
* Soporte para construir instancias de [WebSocket](https://docs.autojs6.com/#/webSocketType) para realizar solicitudes de red basadas en el [protocolo WebSocket](https://zh.wikipedia.org/wiki/WebSocket)
* Nuevos módulos [ [base64](https://docs.autojs6.com/#/base64) / [crypto](https://docs.autojs6.com/#/crypto) / [sqlite](https://docs.autojs6.com/#/sqlite) / [i18n](https://docs.autojs6.com/#/i18n) / [notice](https://docs.autojs6.com/#/notice) / [ocr](https://docs.autojs6.com/#/ocr) / [opencc](https://docs.autojs6.com/#/opencc) / [qrcode](https://docs.autojs6.com/#/qrcode) / [shizuku](https://docs.autojs6.com/#/shizuku) / ... ]
* Soporte multilingüe [Español / Francés / Ruso / Árabe / Japonés / Coreano / Inglés / Chino Simplificado / Chino Tradicional / ...]
* Adaptation des couleurs du thème [ Groupement / Localisation / Recherche / Historique / Adaptation automatique de la luminosité et du contraste / ... ]
* Soporte para modo nocturno en varias páginas [ página de configuración / página de documentación / página de análisis de diseño / ventana flotante / ... ]
* El [complemento de VSCode](http://vscext-project.autojs6.com) soporta conexiones cliente (LAN) y servidor (LAN/ADB)
* El motor [Rhino](https://github.com/mozilla/rhino/) se ha actualizado de [v1.7.7.2](https://github.com/mozilla/rhino/releases/tag/Rhino1_7_7_2_Release) a [v1.8.1-SNAPSHOT](http://rhino.autojs6.com/blob/master/gradle.properties#L3)
    * Soporte para secuencias de escape de [puntos de código](https://developer.mozilla.org/zh-CN/docs/Glossary/Code_point) Unicode [ plano suplementario](https://zh.wikipedia.org/wiki/Unicode%E5%AD%97%E7%AC%A6%E5%B9%B3%E9%9D%A2%E6%98%A0%E5%B0%84#%E7%AC%AC%E4%B8%80%E8%BC%94%E5%8A%A9%E5%B9%B3%E9%9D%A2)
       ```javascript
       '\u{1D160}'; /* significa "𝅘𝅥𝅮", método tradicional: '\uD834\uDD60'. */
       ```
    * Soporte para [Object.values()](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Global_Objects/Object/values)
       ```javascript
       Object.values({name: 'Max', age: 4}); // ['max', 4]
       ```
    * Soporte para [Array.prototype.includes()](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Global_Objects/Array/includes)
       ```javascript
       [10, 20, NaN].includes(20); // true
       ```
    * Soporte para [BigInt](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Global_Objects/BigInt)
       ```javascript
       typeof 567n === 'bigint'; // true
       ```
    * Soporte para [plantillas de cadena](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Template_literals)
       ```javascript
       `Lucky number: ${(Math.random() * 100).toFixed(0)}`
       ```
    * Consulta [más características nuevas](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/RHINO.md) del motor Rhino
    * Consulta la [lista de compatibilidad](https://mozilla.github.io/rhino/compat/engines.html) del motor Rhino

******

### Historial de versiones

******

# v6.6.2

###### 2025/04/16

* `Nuevo` Métodos como ui.statusBarAppearanceLight, statusBarAppearanceLightBy y navigationBarColor, etc.
* `Nuevo` Atributo ui.statusBarHeight (getter), utilizado para obtener la altura de la barra de estado _[`issue #357`](http://issues.autojs6.com/357)_
* `Nuevo` Método images.flip para voltear imágenes _[`issue #349`](http://issues.autojs6.com/349)_
* `Nuevo` Se añadió la opción 'extensión de archivo' en la página de configuración
* `Nuevo` La página de configuración del color del tema añade soporte para nuevos diseños (agrupación, posicionamiento, búsqueda, historial, mejora del selector de color, etc.)
* `Corrección` Problema en el que el color de fondo de la barra de estado de Android 15 no coincide con el color del tema
* `Corrección` Problema en el que el método plugins.load no carga correctamente los plugins _[`issue #290`](http://issues.autojs6.com/290)_
* `Corrección` Problema en el que la biblioteca dx no funciona correctamente en Android 7.x _[`issue #293`](http://issues.autojs6.com/293)_
* `Corrección` Problema en el que ScriptRuntime puede presentar un estado de sincronización anómalo al utilizar require para importar módulos integrados (solución tentativa) _[`issue #298`](http://issues.autojs6.com/298)_
* `Corrección` Problema en el que el módulo notice carece de métodos de extensión como getBuilder _[`issue #301`](http://issues.autojs6.com/301)_
* `Corrección` Problema en el que los métodos shizuku/shell no aceptan parámetros de tipo cadena _[`issue #310`](http://issues.autojs6.com/310)_
* `Corrección` Problema en el que el método colors.pixel no acepta parámetros con imágenes de un solo canal _[`issue #350`](http://issues.autojs6.com/350)_
* `Corrección` Problema en el que los métodos engines.execScript / execScriptFile asignan de forma anómala el directorio de trabajo predeterminado al ejecutar scripts _[`issue #358`](http://issues.autojs6.com/358)_ _[`issue #340`](http://issues.autojs6.com/340)_ _[`issue #339`](http://issues.autojs6.com/339)_
* `Corrección` Problema en el que floaty.window / floaty.rawWindow no puede ejecutarse en subprocesos
* `Corrección` Problema en el que floaty.getClip puede no obtener correctamente el contenido del portapapeles _[`issue #341`](http://issues.autojs6.com/341)_
* `Corrección` Problema en el que el retorno de ui.inflate pierde métodos de prototipo como attr, on y click
* `Corrección` Problema en el que algunas llamadas a métodos, al producir excepciones, no son capturadas por bloques try..catch _[`issue #345`](http://issues.autojs6.com/345)_
* `Corrección` Problema en el que la generación de código en la página de análisis de layouts puede provocar que la aplicación se bloquee _[`issue #288`](http://issues.autojs6.com/288)_
* `Corrección` Problema en el que las aplicaciones empaquetadas no pueden utilizar correctamente el módulo shizuku _[`issue #227`](http://issues.autojs6.com/227)_ _[`issue #231`](http://issues.autojs6.com/231)_ _[`issue #284`](http://issues.autojs6.com/284)_ _[`issue #287`](http://issues.autojs6.com/287)_ _[`issue #304`](http://issues.autojs6.com/304)_
* `Corrección` Problema en el que el editor de código, al saltar al final de una línea, puede mover el cursor al inicio de la siguiente línea
* `Corrección` Problema en el que pulsaciones rápidas consecutivas en elementos tipo diálogo de la página de configuración pueden provocar que la aplicación se bloquee
* `Mejora` Optimización del tamaño del archivo APK en la plantilla de aplicaciones empaquetadas
* `Mejora` La aplicación (y las aplicaciones empaquetadas) ahora soportan más permisos _[`issue #338`](http://issues.autojs6.com/338)_
* `Mejora` La página de empaquetado añade la opción para la biblioteca Pinyin
* `Mejora` Optimización del fondo de la barra de estado y del color del texto en la página principal de la aplicación empaquetada
* `Mejora` La página de configuración de la aplicación empaquetada añade interruptores para permisos especiales (acceso a todos los archivos y envío de notificaciones) _[`issue #354`](http://issues.autojs6.com/354)_
* `Mejora` Los textos e iconos de los controles cambian automáticamente a un color adecuado en función de la luminosidad del tema
* `Mejora` Mejora en la experiencia visual cuando el contraste entre el color del tema de un control y su fondo es bajo
* `Mejora` Mejora en la compatibilidad del control de entrada HEX en la paleta de colores al pegar valores desde el portapapeles
* `Mejora` La barra de navegación de la aplicación se configura para ser transparente o semi-transparente y así mejorar la experiencia visual
* `Mejora` El modo UI por defecto de la barra de estado y de la barra de navegación se establece en el color `md_grey_50` en modo claro
* `Mejora` El interruptor del servicio de accesibilidad en el cajón de la página principal ahora se sincroniza con el código del script
* `Mejora` La página de documentación de la página principal ahora soporta botones de búsqueda bidireccionales
* `Mejora` La pestaña 'Archivos' de la página principal permite cambiar la visibilidad del botón flotante mediante pulsación prolongada
* `Mejora` El título del editor de código ahora soporta el ajuste automático del tamaño de la fuente
* `Mejora` La visibilidad del botón flotante en la página de registros se vincula a las acciones de desplazamiento de la lista
* `Mejora` El archivo de configuración project.json del proyecto de script ahora soporta más opciones de empaquetado _[`issue #305`](http://issues.autojs6.com/305)_ _[`issue #306`](http://issues.autojs6.com/306)_
* `Mejora` El archivo project.json ahora admite coincidencia flexible de nombres de opción y compatibilidad con alias
* `Mejora` El diálogo de información de tipo de archivo APK ahora incluye el tamaño del archivo y la información del esquema de firma
* `Mejora` El diálogo de información de tipo de archivo APK ahora admite escuchas de clic para copiar texto y navegar a los detalles de la aplicación
* `Mejora` Intento de restaurar los paquetes con prefijo com.stardust para mejorar la compatibilidad del código _[`issue #290`](http://issues.autojs6.com/290)_
* `Mejora` Los métodos floaty.window / floaty.rawWindow ahora soportan la ejecución tanto en el hilo principal como en hilos secundarios
* `Mejora` El método global getClip ahora utiliza floaty.getClip según sea necesario para mejorar la compatibilidad
* `Mejora` Mejora en la compatibilidad de files.path y métodos relacionados al recibir rutas nulas
* `Mejora` Sincronización con la última versión oficial del motor Rhino y adaptación necesaria del código
* `Mejora` Mejoras en el README.md para documentar la construcción y ejecución del proyecto _[`issue #344`](http://issues.autojs6.com/344)_
* `Mejora` Ajustes en algunas dependencias o versiones de bibliotecas locales _[`CHANGELOG.md`](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG.md#v662)_

# v6.6.1

###### 2025/01/01

* `Nuevo` Módulo Pinyin para la conversión de pinyin en chino (Consulte la documentación del proyecto > [Pinyin chino](https://docs.autojs6.com/#/pinyin))
* `Nuevo` Módulo Pinyin4j para la conversión de pinyin en chino (Consulte la documentación del proyecto > [Pinyin chino](https://docs.autojs6.com/#/pinyin4j))
* `Nuevo` Métodos UiObject#isSimilar y UiObjectCollection#isSimilar para determinar si un control o una colección de controles son similares
* `Nuevo` Método global "currentComponent", utilizado para obtener el nombre del componente activo actual
* `Corrección` Problema donde no se podía compilar correctamente el proyecto en determinados entornos debido a una reversión a una versión anterior
* `Corrección` Excepción de "valor no primitivo" que puede ocurrir al llamar a métodos inexistentes
* `Corrección` Problema donde los accesos directos de scripts no se podían agregar correctamente en algunos dispositivos (arreglo tentativa) _[`issue #221`](http://issues.autojs6.com/221)_
* `Corrección` Restricción de tipo de parámetro incorrecta en los métodos automator.click/longClick _[`issue #275`](http://issues.autojs6.com/275)_
* `Corrección` Problema donde los selectores no admitían parámetros del tipo ConsString _[`issue #277`](http://issues.autojs6.com/277)_
* `Corrección` Problema donde las instancias de UiObjectCollection carecían de métodos y propiedades propios
* `Mejora` La página de empaquetado admite configuración de firma, gestión de almacenes de claves y configuración de permisos (por [luckyloogn]()) _[`pr #286`]()_
* `Mejora` Mejorada la precisión en la identificación del nombre del paquete y de la actividad actual de la ventana flotante (Prioridad: Shizuku > Root > A11Y)
* `Mejora` Mejorada la precisión en la identificación de currentPackage y currentActivity (Prioridad: Shizuku > Root > A11Y)
* `Mejora` Restaurar la capacidad de seleccionar el contenido del texto de entradas individuales en la ventana de actividad del registro mediante doble clic o pulsación larga _[`issue #280`](http://issues.autojs6.com/280)_
* `Mejora` Recuperar la mayor cantidad de información crítica posible para proyectos de scripts cuando el archivo project.json está dañado
* `Mejora` Convertir automáticamente chino simplificado a Pinyin (incluyendo caracteres con múltiples tonos) para los sufijos de nombres de paquetes generados al empaquetar archivos individuales
* `Mejora` Soporte para argumentos negativos en los métodos UiSelector#findOnce y UiSelector#find
* `Mejora` Se mejoró la adaptabilidad de los métodos app.startActivity/startDualActivity
* `Mejora` Mayor soporte para formas abreviadas de prefijos de nombres de paquetes en selectores relacionados con elementos UI y className (por ejemplo, RecyclerView, Snackbar, etc.)
* `Mejora` Sincronizar el código más reciente del upstream del motor Rhino y adaptarlo al proyecto existente
* `Mejora` Ajustes en algunas dependencias o versiones de bibliotecas locales _[`CHANGELOG.md`](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG.md#v661)_

# v6.6.0

###### 2024/12/02 - Reescritura de módulos integrados, actualización con precaución

* `Sugerencia` Los módulos integrados se reescriben en Kotlin para mejorar la eficiencia de ejecución del script, pero se necesitan mejoras iterativas.
* `Sugerencia` El archivo init.js integrado está vacío por defecto, lo que permite a los desarrolladores ampliar los módulos integrados o montar módulos externos.
* `Nuevo` Módulo Axios / Módulo Cheerio (Ref a [AutoX](https://github.com/kkevsekk1/AutoX))
* `Nuevo` Módulo SQLite para operaciones simples en bases de datos SQLite (Ref a [Auto.js Pro](https://g.pro.autojs.org/)) (Consulte la documentación del proyecto > [SQLite](https://docs.autojs6.com/#/sqlite))
* `Nuevo` Módulo MIME para procesamiento y análisis de cadenas de tipos MIME (Consulte la documentación del proyecto > [MIME](https://docs.autojs6.com/#/mime))
* `Nuevo` Módulo Nanoid para generación de ID de cadenas (Ref a [ai/nanoid](https://github.com/ai/nanoid))
* `Nuevo` Módulo Sysprops para obtener datos de configuración del entorno de ejecución (Consulte la documentación del proyecto > [Propiedades del sistema](https://docs.autojs6.com/#/sysprops))
* `Nuevo` El módulo OCR admite el motor [Rapid OCR](https://github.com/RapidAI/RapidOCR)
* `Nuevo` El análisis de diseño admite el cambio de ventanas (Ref a [Auto.js Pro](https://g.pro.autojs.org/))
* `Nuevo` El método auto.clearCache admite la limpieza de cachés de control (Ref a [Auto.js Pro](https://g.pro.autojs.org/))
* `Nuevo` El método threads.pool admite la aplicación simple de grupos de hilos (Ref a [Auto.js Pro](https://g.pro.autojs.org/))
* `Nuevo` El método images.matchTemplate agrega el parámetro de opción useTransparentMask para soportar la búsqueda de imágenes transparentes (Ref a [Auto.js Pro](https://g.pro.autojs.org/))
* `Nuevo` El método images.requestScreenCaptureAsync se usa para solicitar permisos de captura de pantalla de manera asíncrona en el modo UI (Ref a [Auto.js Pro](https://g.pro.autojs.org/))
* `Nuevo` El método images.requestScreenCapture agrega el parámetro de opción isAsync para soportar la captura de pantalla de manera asíncrona (Ref a [Auto.js Pro](https://g.pro.autojs.org/))
* `Nuevo` images.on('screen_capture', callback) y otros métodos de escucha de eventos admiten la escucha de eventos de disponibilidad de captura de pantalla (Ref a [Auto.js Pro](https://g.pro.autojs.org/))
* `Nuevo` El método images.stopScreenCapture soporta la liberación activa de recursos relacionados con la aplicación de captura de pantalla (Ref a [Auto.js Pro](https://g.pro.autojs.org/))
* `Nuevo` Los métodos Images.psnr/mse/ssim/mssim/hist/ncc y images.getSimilarity se utilizan para obtener métricas de similitud de imágenes
* `Nuevo` El método images.isGrayscale se utiliza para determinar si una imagen es en escala de grises
* `Nuevo` El método images.invert se utiliza para la conversión de imagen en negativo
* `Nuevo` Los métodos s13n.point/time se utilizan para estandarizar objetos de punto y objetos de duración (Consulte la documentación del proyecto > [Normalización](https://docs.autojs6.com/#/s13n))
* `Nuevo` Los métodos gravity, touchThrough, backgroundTint del módulo console (Consulte la documentación del proyecto > [Consola](https://docs.autojs6.com/#/console))
* `Nuevo` Los métodos Mathx.randomInt/Mathx.randomFloat se utilizan para devolver enteros aleatorios o números de coma flotante aleatorios dentro de un rango especificado
* `Nuevo` Los métodos app.launchDual/startDualActivity se utilizan para manejar el lanzamiento dual de aplicaciones (Requiere permisos de Shizuku o Root) (Experimental)
* `Nuevo` El método app.kill se utiliza para detener forzosamente una aplicación (Requiere permisos de Shizuku o Root)
* `Nuevo` El método floaty.getClip se utiliza para obtener indirectamente el contenido del portapapeles mediante una ventana flotante
* `Corrección` Fuga de memoria en el View Binding de subclases de Fragment (por ejemplo, [DrawerFragment](https://github.com/SuperMonster003/AutoJs6/blob/17616504ab0bba93b30ab7abc67108ee5253f39a/app/src/main/java/org/autojs/autojs/ui/main/drawer/DrawerFragment.kt#L369) / [ExplorerFragment](https://github.com/SuperMonster003/AutoJs6/blob/17616504ab0bba93b30ab7abc67108ee5253f39a/app/src/main/java/org/autojs/autojs/ui/main/scripts/ExplorerFragment.kt#L48))
* `Corrección` Fuga de memoria de instancia en clases como [ScreenCapture](https://github.com/SuperMonster003/AutoJs6/blob/17616504ab0bba93b30ab7abc67108ee5253f39a/app/src/main/java/org/autojs/autojs/core/image/capture/ScreenCapturer.java#L70) / [ThemeColorPreference](https://github.com/SuperMonster003/AutoJs6/blob/10960ddbee71f75ef80907ad5b6ab42f3e1bf31e/app/src/main/java/org/autojs/autojs/ui/settings/ThemeColorPreference.kt#L21)
* `Corrección` Problema que causa que la aplicación se bloquee al solicitar permisos de captura de pantalla en Android 14 (por [chenguangming](https://github.com/chenguangming)) _[`pr #242`](http://pr.autojs6.com/242)_
* `Corrección` Problema que causa que la aplicación se bloquee al iniciar el servicio en primer plano en Android 14
* `Corrección` Problema con el botón de ejecución en el editor de código que no se enciende correctamente en Android 14
* `Corrección` La aplicación puede no funcionar correctamente después de empaquetar debido a la falta de archivos de biblioteca necesarios _[`issue #202`](http://issues.autojs6.com/202)_ _[`issue #223`](http://issues.autojs6.com/223)_ _[`pr #264`](http://pr.autojs6.com/264)_
* `Corrección` Bloqueo de la aplicación cuando se edita el proyecto debido a recursos de icono especificados que faltan _[`issue #203`](http://issues.autojs6.com/203)_
* `Corrección` Incapacidad para usar parámetros adecuadamente para obtener recursos de captura de pantalla de orientación de pantalla especificada al solicitar permisos de captura de pantalla
* `Corrección` Problema con algunos dispositivos que no pueden agregar accesos directos de script correctamente (Reparación de prueba) _[`issue #221`](http://issues.autojs6.com/221)_
* `Corrección` Problema de retraso acumulativo en el envío de solicitudes con métodos relacionados con el envío de solicitudes en el módulo http _[`issue #192`](http://issues.autojs6.com/192)_
* `Corrección` El servicio Shizuku puede no funcionar correctamente antes de que AutoJs6 entre en la página de actividad principal (Reparación de prueba) _[`issue #255`](http://issues.autojs6.com/255)_
* `Corrección` El método random(min, max) puede tener resultados fuera de límites
* `Corrección` Problema donde el tipo de parámetro de resultado de los métodos pickup no puede pasar adecuadamente matrices vacías
* `Corrección` Problema donde el rectángulo de control obtenido por UiObject#bounds() puede ser modificado inadvertidamente, rompiendo su inmutabilidad
* `Corrección` Problema con elementos de texto/botón/entrada donde el texto que contiene comillas dobles de ancho medio no puede ser analizado correctamente
* `Corrección` Problema con elementos de text/textswitcher donde la funcionalidad del atributo autoLink falla
* `Corrección` Problema con diferentes scripts que comparten erróneamente el mismo objeto ScriptRuntime
* `Corrección` Problema con variables globales HEIGHT y WIDTH perdiendo propiedades Getter generadas dinámicamente
* `Corrección` Problema con un alto tiempo de inicio potencial causado por la carga de RootShell al iniciar un script
* `Corrección` Problema con la configuración del color de fondo de la ventana flotante de la consola que conduce a la pérdida del estilo de redondeo rectangular
* `Corrección` El inicio automático del servicio de accesibilidad puede encontrar problemas de servicio anormales (Reparación de prueba)
* `Corrección` Problema con el desencadenante de ViewPager al deslizar el control WebView a la izquierda o derecha en la página de documentos de la página principal
* `Corrección` Problema donde el administrador de archivos no puede reconocer extensiones de archivo que contienen letras mayúsculas
* `Corrección` El administrador de archivos puede no reconocer automáticamente el proyecto al ingresar por primera vez al directorio del proyecto
* `Corrección` Problema donde la página del administrador de archivos no puede refrescarse automáticamente después de eliminar la carpeta
* `Corrección` Problema con la clasificación de archivos y carpetas en el administrador de archivos donde los nombres de letra inicial ASCII se colocan detrás
* `Corrección` Excepción 'FAILED ASSERTION' en la función de depuración del editor de código
* `Corrección` Problema con la imposibilidad de volver a depurar adecuadamente después de cerrar el editor durante el proceso de depuración del editor de código
* `Corrección` Problema de omisión potencial de caracteres finales al saltar al final de la línea en el editor de código
* `Corrección` Problema con la pantalla parpadeante al iniciar la página de actividad de registro en la página de actividad principal
* `Corrección` Problema con la aplicación empaquetada que no puede utilizar adecuadamente el módulo opencc
* `Mejora` Experiencia de aviso de clic para el control 'ABI no disponible' en la página de paquete
* `Mejora` Admite el uso de Shizuku para controlar el interruptor de visualización 'Ubicación del puntero'
* `Mejora` Admite el uso de Shizuku para controlar los interruptores de permisos 'Medios de proyección' y 'Modificar configuraciones seguras'
* `Mejora` Automator.gestureAsync/gesturesAsync admite parámetros de función de devolución de llamada
* `Mejora` El módulo tasks utiliza una forma síncrona para las operaciones de base de datos para evitar inconsistencias potenciales de acceso a datos
* `Mejora` El modo de ejecución de script admite parámetros de separación de modo con símbolo de tubería (por ejemplo, comenzando con `"ui|auto";`)
* `Mejora` El modo de ejecución de script admite comillas simples y comillas invertidas y permite omitir puntos y comas (por ejemplo, comenzando con `'ui';` o `'ui'`)
* `Mejora` El modo de ejecución de script admite la importación rápida de módulos de extensión integrados como axios, cheerio y dayjs (por ejemplo, comenzando con `"axios";`)
* `Mejora` El modo de ejecución de script admite parámetros de modo x o jsox para habilitar rápidamente los módulos de extensión de objetos integrados de JavaScript (por ejemplo, comenzando con `"x";`)
* `Mejora` Los atributos src y path del elemento img admiten rutas relativas locales (por ejemplo, `<img src="a.png"` />)
* `Mejora` El editor de código admite la determinación inteligente de la ubicación de inserción al importar clases Java y nombres de paquetes
* `Mejora` El módulo images admite el uso de rutas directamente como parámetros de imagen
* `Mejora` importPackage admite parámetros de cadena
* `Mejora` La dirección IP del modo servidor admite la importación del portapapeles con reconocimiento inteligente y conversión inteligente con la tecla de espacio
* `Mejora` El administrador de archivos admite la selección de prefijos predeterminados al crear nuevos archivos y genera automáticamente el sufijo numérico apropiado
* `Mejora` El administrador de archivos informa específicamente sobre el mensaje de excepción al ejecutar el proyecto _[`issue #268`](http://issues.autojs6.com/268)_
* `Mejora` El administrador de archivos admite más tipos y muestra símbolos de icono correspondientes (admite más de 800 tipos de archivos)
* `Mejora` Los tipos de archivos editables (jpg/doc/pdf, etc.) en el administrador de archivos han añadido botones de edición
* `Mejora` Los archivos APK en el administrador de archivos admiten la visualización de información básica, información de Manifesto y lista de permisos
* `Mejora` Los archivos de medios de audio/video en el administrador de archivos admiten la visualización de información básica e información de MediaInfo
* `Mejora` El paquete de archivo único admite el autocompletado de nombre de paquete estandarizado apropiado y el aviso de filtro de caracteres no válidos
* `Mejora` El paquete de archivo único admite la configuración automática del ícono y el incremento automático del número de versión y del nombre de versión basado en la misma aplicación de nombre de paquete instalada
* `Mejora` El archivo de configuración del paquete admite la opción abis/libs para especificar la arquitectura ABI incluidos por defecto y las bibliotecas
* `Mejora` Admite avisos de mensajes relevantes cuando las opciones abis/libs del archivo de configuración del paquete son inválidas o no están disponibles
* `Mejora` LeakCanary se excluye de la versión oficial para evitar un crecimiento innecesario
* `Mejora` Todos los comentarios en inglés en el código fuente del proyecto vienen acompañados de traducciones al chino simplificado para mejorar la legibilidad
* `Mejora` README y CHANGELOG admiten varios idiomas (Generado automáticamente por el script)
* `Mejora` Mejorar la adaptabilidad de la versión del script de construcción de Gradle
* `Mejora` Ajustes en algunas dependencias o versiones de bibliotecas locales _[`CHANGELOG.md`](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG.md#v660)_

##### Para más historial de versiones, consulte

* [CHANGELOG.md](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG-es.md)

******

### <a id="project-compilation-and-build"></a>Compilación y construcción del proyecto

******

Para depurar o desarrollar el proyecto de código abierto AutoJs6, puedes usar [Android Studio](https://pro.autojs.org/) (producto de [Google](https://www.google.com/)) o [IntelliJ IDEA](https://www.jetbrains.com/idea/) (producto de [JetBrains](https://www.jetbrains.com/)).

Esta sección toma como ejemplo Android Studio para presentar los métodos de compilación y construcción del proyecto de código abierto AutoJs6; IntelliJ IDEA es similar.

#### Preparación de Android Studio

Descarga la versión `Android Studio Meerkat | 2024.3.1 Patch 1` (elige una según tus necesidades):

- [android-studio-2024.3.1.14-windows.exe](https://redirector.gvt1.com/edgedl/android/studio/install/2024.3.1.14/android-studio-2024.3.1.14-windows.exe) (1.22 GB)
- [android-studio-2024.3.1.14-windows.zip](https://redirector.gvt1.com/edgedl/android/studio/ide-zips/2024.3.1.14/android-studio-2024.3.1.14-windows.zip) (1.23 GB)

> Nota: La fecha de lanzamiento de la versión anterior es el 24 de March de 2025. Para descargar otras versiones, o si los enlaces anteriores ya no funcionan, puedes visitar la página del [Archivo de versiones de Android Studio](https://developer.android.com/studio/archive?hl=en).

Instala o descomprime los archivos mencionados anteriormente y ejecuta el software Android Studio (por ejemplo, `"D:\android-studio\bin\studio64.exe"`).

#### Preparación del SDK de Android

> Nota: Si el sistema ya tiene instalado el SDK de Android (Kit de Desarrollo de Software de Android), puedes omitir esta sección.

En el software Android Studio, abre la página de configuración con el atajo de teclado `CTRL + ALT + S`:

```text
Appearance & Behavior (Apariencia y comportamiento) -> 
System Settings (Configuración del sistema) -> 
Android SDK (Kit de Desarrollo de Software de Android)
```

Si `Android SDK Location (Ubicación del SDK de Android)` está en blanco, haz clic en el botón `Edit (Editar)` a la derecha y continúa haciendo clic en `Next (Siguiente)` en la ventana emergente.

> Nota: Puede ser necesario aceptar uno o varios acuerdos durante el proceso para continuar.

Una vez que los recursos relacionados se hayan descargado e instalado, haz clic en el botón `Finish (Finalizar)`.  
La ruta se completará automáticamente en `Android SDK Location (Ubicación del SDK de Android)`, completando así la preparación del SDK.

#### Preparación de herramientas del SDK de Android

AutoJs6 requiere usar algunas herramientas del SDK (como NDK y CMake).

> Nota: Si el sistema ya tiene instaladas todas las herramientas necesarias del SDK de Android para AutoJs6, puedes omitir esta sección.

En el software Android Studio, abre la página de configuración con el atajo de teclado `CTRL + ALT + S`:

```text
Appearance & Behavior (Apariencia y comportamiento) -> 
System Settings (Configuración del sistema) -> 
Android SDK (Kit de Desarrollo de Software de Android) -> 
SDK Tools (Herramientas del SDK) (situado en la ventana de la derecha)
```

Marca `Show Package Details (Mostrar detalles del paquete)`, haz clic en NDK y CMake para asegurarte de que las versiones requeridas están seleccionadas, La información de la versión de las herramientas del SDK se encuentra en el archivo `version.properties` en el directorio raíz del proyecto AutoJs6.

#### Preparación del JDK

La versión mínima requerida del `JDK (Kit de Desarrollo de Java)` para el proyecto AutoJs6 es `17`, pero se recomienda usar una versión no inferior a `19`.

Hasta el 16 de April de 2025, AutoJs6 soporta hasta la versión `24` de JDK.

> Nota: Si el sistema ya tiene instalado JDK y cumple con los requisitos anteriores, puedes omitir esta sección.

Puedes descargar el JDK directamente desde la IDE, o desde el [sitio web de Oracle](https://www.oracle.com/java/technologies/downloads/).

En el software Android Studio, abre la página de configuración con el atajo de teclado `CTRL + ALT + S`:

```text
Build, Execution, Deployment (Compilación, ejecución, despliegue) -> 
Build Tools (Herramientas de compilación) -> 
Gradle
```

En `Gradle JDK`, puedes seleccionar o agregar diferentes versiones de JDK.

Si ya existe una versión adecuada de JDK (>= `17`) en la lista, simplemente selecciónala.  
De lo contrario, puedes seleccionar `Download JDK (Descargar JDK)` para descargar el JDK adecuado, haz clic en el botón `Download (Descargar)` y espera a que se complete la descarga.  
También puedes seleccionar `Add JDK (Añadir JDK)` para agregar un JDK local existente, ubica su directorio y completa la adición del JDK.

#### Clonación de recursos de AutoJs6

En la página principal de Android Studio, haz clic en el botón `Get from VCS (Obtener desde VCS)`.  
En `URL (dirección URL)`, ingresa `https://github.com/SuperMonster003/AutoJs6.git`,  
En `Directory (directorio)`, puedes cambiarlo a una ruta específica según sea necesario.  
Haz clic en el botón `Clone (clonar)` y espera a que los recursos del proyecto AutoJs6 se clonen localmente en el dispositivo.

> Nota: Este proceso puede requerir la instalación de [Git (sistema de control de versiones distribuido)](https://git-scm.com/download).

#### Construcción del proyecto AutoJs6

Una vez completada la clonación, Android Studio abrirá la ventana del proyecto AutoJs6 y completará automáticamente la descarga inicial de `Dependencies (dependencias)` y el trabajo de construcción de Gradle.

> Nota: Este proceso puede ser muy largo. Si las condiciones de la red no son buenas, puede ser necesario reintentar varias veces (haga clic en el botón Retry).

If the build couldn't proceed automatically or you need to rebuild the project, follow these steps:

- From the `Run/Debug Configurations` menu in the Toolbar, select `app`, which is the main AutoJs6 application.
- Click the `Build Project` (hammer icon) button on the left to start building the project. The default shortcut is CTRL + F9.
- Wait for the build to complete. The `Builder Output` tab will display a message such as "BUILD SUCCESSFUL in 1h 17m 34s".

If the build fails, you can report the error message to the AutoJs6 project's [Issues](http://issues.autojs6.com) page..

> Note: For more details on building and running the app, please refer to [Android Docs](https://developer.android.com/studio/run?hl=en).

#### AutoJs6 Project Deployment (Run App)

Once the project is built successfully, it can be deployed as an application (App) to a physical device (e.g., phone/tablet) or a virtual device (e.g., Android emulator)..

- In the Toolbar, select `app` from the `Run/Debug Configurations` menu, which is the main AutoJs6 application.
- In the `Available Devices` dropdown on the right, choose the device on which the project app should run (physical or virtual).
- Click the `Run` (triangle icon) button on the right to launch the app. The default shortcut is `F10`.
- Wait for the deployment to finish; the chosen device will automatically install and run the project app.

#### AutoJs6 Project Deployment (Generate APK)

Package the project and generate an APK file that can be installed on Android devices.:

- Versión de depuración (Debug Version)
    - `Build (Compilar)` -> `Build Bundle(s) / APK(s)` -> `Build APK(s)`
    - Generar un paquete de instalación de versión de depuración
    - Ruta de ejemplo: `"D:\AutoJs6\app\build\outputs\apk\debug\"`
- Versión de lanzamiento (Release Version)
    - `Build (Compilar)` -> `Generate Signed Bundle / APK`
    - Selecciona la opción `APK`
    - Prepara el archivo de firma (crear o seleccionar uno nuevo) para generar un paquete de instalación de versión de lanzamiento firmado
    - Ruta de ejemplo: `"D:\AutoJs6\app\release\"`

> Note: For more information on building an app for user release, please refer to [Android Docs](https://developer.android.com/build/build-for-release?hl=en).

#### Predefined Gradle Build Tasks for AutoJs6

Besides building the project App, AutoJs6 supports several predefined Gradle build tasks that help developers perform convenient project-related operations..

Under the `Run/Debug Configurations` menu in the Toolbar, you can find various predefined Gradle tasks, each indicated by an elephant icon on the left..

- AutoJs6 [inrt:assemble]

Assemble the "inrt" build variant, which primarily serves the AutoJs6 script packaging feature..

The AutoJs6 project has various build variants. The "inrt" variant is used for packaging scripts, generating the template file "template.apk" required for packaging..

When using the packaging feature, you might encounter the following error message:

> java.io.FileNotFoundException: template.apk

This indicates that the template file does not exist. You need to manually run the `inrt:assemble` task to generate the template file, then rebuild and redeploy the app..

> Note: The template file is missing; run the `inrt:assemble` task manually to generate it before rebuilding and redeploying the app.

- AutoJs6 [app:bundle]

Package the outputs of the debug build process, primarily for the [AutoJs6 TypeScript definitions](http://dts-project.autojs6.com) project..

After running the task, it produces the latest JAR file for the AutoJs6 project. Using the [Android d.ts Generator](https://github.com/NativeScript/android-dts-generator) (by [NativeScript](https://github.com/NativeScript)), you can generate the type definitions (d.ts format) for the main AutoJs6 app..

- AutoJs6 [app:digest]

Append digest information to the APK produced by the release build, mainly to finalize the filename before publishing the latest version of AutoJs6 to GitHub..

Below is the comparison of filenames before and after appending the digest information:

```text
Before:
autojs6-v6.6.2-arm64-v8a.apk
After:
autojs6-v6.6.2-arm64-v8a-0f2a9d74.apk
```

> Consultar: [Android Docs](https://developer.android.com/studio/run?hl=zh-cn)

******

### <a id="script-development-assistance"></a>Asistencia en el desarrollo de scripts

******

Para desarrollar scripts ejecutables en AutoJs6, utiliza las herramientas de desarrollo adecuadas:

- [VSCode](https://code.visualstudio.com/download) / [WebStorm](https://www.jetbrains.com/webstorm/download/) / [HBuilderX](https://www.dcloud.io/hbuilderx.html) ...

Para escribir y depurar scripts en PC, el complemento de VSCode puede conectar el PC y el teléfono:

- [AutoJs6-VSCode-Extension](http://vscext-project.autojs6.com) - Depurador de AutoJs6 (extensión para la plataforma VSCode)

Al escribir código con herramientas de desarrollo, la función de autocompletado puede ayudar al desarrollador a completar el código:

- [AutoJs6-TypeScript-Declarations](http://dts-project.autojs6.com) - Archivos de declaración de AutoJs6 (autocompletado del código)

Al escribir el código, puedes consultar la documentación sobre la API y el uso de AutoJs6 en cualquier momento:

- [AutoJs6-Documentation](http://docs-project.autojs6.com) - Documentación de la aplicación AutoJs6

Los proyectos de desarrollo de scripts existentes pueden servir como referencia e inspiración para tus propios proyectos de scripts:

- [Ant-Forest](https://github.com/TonyJiangWJ/Ant-Forest) - Script de recolección automática de energía de Ant Forest por [TonyJiangWJ](https://github.com/TonyJiangWJ)
- [Ant-Forest](https://github.com/SuperMonster003/Ant-Forest) - Script de recolección automática de energía de Ant Forest por [SuperMonster003](https://github.com/SuperMonster003)
- [autojs](https://github.com/e1399579/autojs) - Scripts útiles de Auto.js por [e1399579](https://github.com/e1399579)
- [autojsDemo](https://github.com/snailuncle/autojsDemo) - Ejemplo de demostración de Auto.js por [snailuncle](https://github.com/snailuncle)
- [Repositorios relacionados con autojs](https://github.com/topics/autojs) - Todos los repositorios relacionados con el tema autojs en GitHub

******

### Contribución

******

Agradecemos a todos los que han contribuido al desarrollo del proyecto AutoJs6.

|         <span style="word-break:keep-all;white-space:nowrap">Contribuyentes</span>          |                   <span style="word-break:keep-all;white-space:nowrap">Número de commits</span>                    | <span style="word-break:keep-all;white-space:nowrap">Últimas presentaciones</span> |
|:-------------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------:|
|          <span style="word-break:keep-all;white-space:nowrap">[luckyloogn](https://github.com/luckyloogn)</span>          |       <span style="word-break:keep-all;white-space:nowrap">[3](https://github.com/SuperMonster003/AutoJs6/commits?author=luckyloogn)</span>        |                    <span style="word-break:keep-all;white-space:nowrap">`2025/01/01`</span>                    |
|                <span style="word-break:keep-all;white-space:nowrap">[kvii](https://github.com/kvii)</span>                |          <span style="word-break:keep-all;white-space:nowrap">[1](https://github.com/SuperMonster003/AutoJs6/commits?author=kvii)</span>           |                    <span style="word-break:keep-all;white-space:nowrap">`2024/10/16`</span>                    |
|   <span style="word-break:keep-all;white-space:nowrap">[chenguangming](https://github.com/chenguangming) `(Tom)`</span>   | <span style="word-break:keep-all;white-space:nowrap">[2](https://github.com/SuperMonster003/AutoJs6/pulls?q=is%3Apr+author%3Achenguangming)</span> |                    <span style="word-break:keep-all;white-space:nowrap">`2024/05/14`</span>                    |
|          <span style="word-break:keep-all;white-space:nowrap">[LZX284](https://github.com/LZX284) `(AI)`</span>           |         <span style="word-break:keep-all;white-space:nowrap">[17](https://github.com/SuperMonster003/AutoJs6/commits?author=LZX284)</span>         |                    <span style="word-break:keep-all;white-space:nowrap">`2023/11/19`</span>                    |
|         <span style="word-break:keep-all;white-space:nowrap">[TonyJiangWJ](https://github.com/TonyJiangWJ)</span>         |       <span style="word-break:keep-all;white-space:nowrap">[4](https://github.com/SuperMonster003/AutoJs6/commits?author=TonyJiangWJ)</span>       |                    <span style="word-break:keep-all;white-space:nowrap">`2023/10/31`</span>                    |
| <span style="word-break:keep-all;white-space:nowrap">[little&#x2011;alei](https://github.com/little-alei) `(抠脚本人)`</span> |      <span style="word-break:keep-all;white-space:nowrap">[12](https://github.com/SuperMonster003/AutoJs6/commits?author=little-alei)</span>       |                    <span style="word-break:keep-all;white-space:nowrap">`2023/07/12`</span>                    |
|              <span style="word-break:keep-all;white-space:nowrap">[aiselp](https://github.com/aiselp)</span>              |    <span style="word-break:keep-all;white-space:nowrap">[6](https://github.com/SuperMonster003/AutoJs6/pulls?q=is%3Apr+author%3Aaiselp)</span>     |                    <span style="word-break:keep-all;white-space:nowrap">`2023/06/14`</span>                    |
|           <span style="word-break:keep-all;white-space:nowrap">[LYS86](https://github.com/LYS86) `(Lin)`</span>           |          <span style="word-break:keep-all;white-space:nowrap">[2](https://github.com/SuperMonster003/AutoJs6/commits?author=LYS86)</span>          |                    <span style="word-break:keep-all;white-space:nowrap">`2023/06/03`</span>                    |

Datos actualizados el 1 de January de 2025.

Las entradas de datos están ordenadas en orden descendente por `últimas presentaciones`.

Las nuevas Pull Requests pendientes de procesamiento se añadirán a las estadísticas de datos una vez procesadas.

Algunos contribuyentes no aparecen en [GitHub Contributors](https://github.com/SuperMonster003/AutoJs6/graphs/contributors) con sus registros de contribución vacíos, pero aún puedes verificar sus registros de contribución a través de [Pull Request](https://github.com/SuperMonster003/AutoJs6/pulls).

[//]: # (
    # --------------------------------------------------------------#
    # Before committing and pushing to the remote GitHub repository #
    # --------------------------------------------------------------#
    - CHANGELOG.md
        - Update entries for AutoJs6 by checking all changed files
        - Update entries for Gradle plugins [ implementation ]
        - Update version name and released date
        - Append related GitHub issues to changelog entries
    - README.md
        - The summary of the latest changelog for committing to Git [ DO NOT commit or push ]
        - Update badges like [ android studio / rhino / ... ]
        - Update android studio download links and version names
        - Update contribution section
    - Remove the part like [ alpha / beta / ... ] of VERSION_NAME in version.properties
    - Update dependencies TypeScript declarations if needed.
    - Re-generate documentation/markdown by running the python script
    - Check the two-way versions for AutoJs6 and VSCode ext, then publish the ext to Microsoft
    - Run Gradle task "app:assembleInrtRelease"
    - Build APK to determine the final VERSION_BUILD field
    - Run Gradle task "app:appendDigestToReleasedFiles"
    - Check VERSION_BUILD in version.properties with released apks
    - Commit and push to GitHub
    - Publish the latest release with signed APKs
)