<!--suppress HtmlDeprecatedAttribute, HttpUrlsUsage -->

<div align="center">
  <p>
    <img src="https://s1.imagehub.cc/images/2023/03/07/af8ed087c9d354b9ab6142aae7bbafb6.png" alt="autojs6-banner_800×224" border="0" width="704" />
  </p>

  <p>أداة أتمتة JavaScript لنظام Android مدعومة بخدمة الوصول</p>

  <p>
    <a href="http://download.autojs6.com"><img alt="GitHub release (latest by date)" src="https://img.shields.io/github/v/release/SuperMonster003/AutoJs6"/></a>
    <a href="http://issues.autojs6.com"><img alt="GitHub closed issues" src="https://img.shields.io/github/issues/SuperMonster003/AutoJs6?color=A24232"/></a>
    <a href="http://commit.autojs6.com/99a1d8490fac5b6d55f6f183db59ad833a2064ed"><img alt="Created" src="https://img.shields.io/date/1636632233?color=2e7d32&label=created"/></a>
    <br>
    <a href="https://github.com/mozilla/rhino"><img alt="Rhino" src="https://img.shields.io/badge/rhino-1.8.1--SNAPSHOT-795548"/></a>
    <a href="https://developer.android.com/studio/archive"><img alt="Android Studio" src="https://img.shields.io/badge/android%20studio-2022.1+-B64FC8"/></a>
    <br>
    <a href="https://www.codefactor.io/repository/github/SuperMonster003/AutoJs6"><img alt="CodeFactor Grade" src="https://www.codefactor.io/repository/github/SuperMonster003/AutoJs6/badge"/></a>
    <a href="https://www.jetbrains.com/?from=AutoJs6"><img alt="JetBrains supporter" src="https://img.shields.io/badge/supporter-JetBrains-ee4677"/></a>
    <a href="http://project.autojs6.com/blob/master/LICENSE"><img alt="GitHub License" src="https://img.shields.io/github/license/SuperMonster003/AutoJs6?color=534BAE"/></a>
  </p>
</div>

******

### اللغات

******

ملف README.md الحالي يدعم اللغات التالية:

 - [简体中文 [zh-Hans]](http://project.autojs6.com/blob/master/.readme/README-zh-Hans.md)
 - [繁體中文 (香港) [zh-Hant-HK]](http://project.autojs6.com/blob/master/.readme/README-zh-Hant-HK.md)
 - [繁體中文 (台灣) [zh-Hant-TW]](http://project.autojs6.com/blob/master/.readme/README-zh-Hant-TW.md)
 - [English [en]](http://project.autojs6.com/blob/master/.readme/README-en.md)
 - [Français [fr]](http://project.autojs6.com/blob/master/.readme/README-fr.md)
 - [Español [es]](http://project.autojs6.com/blob/master/.readme/README-es.md)
 - [日本語 [ja]](http://project.autojs6.com/blob/master/.readme/README-ja.md)
 - [한국어 [ko]](http://project.autojs6.com/blob/master/.readme/README-ko.md)
 - [Русский [ru]](http://project.autojs6.com/blob/master/.readme/README-ru.md)
 - العربية [ar] # حالي

******

### المقدمة

******

[Auto.js](https://github.com/hyb1996/Auto.js) هو برنامج أتمتة JavaScript مدعوم على منصة Android مع [خدمة الوصول](https://developer.android.com/guide/topics/ui/accessibility/service?hl=zh-cn).

تم إصدار Auto.js لأول مرة بواسطة [hyb1996](https://github.com/hyb1996) في `2017/01/27`، وتوقف الصيانة في `2020/03/13`، وكان الإصدار الأخير هو `4.1.1 Alpha2` ورقم البنية `461`.

تم تطوير AutoJs6 استنادًا إلى المشروع النهائي لـ Auto.js في `2021/12/01`، ويستمر في أن يكون مفتوح المصدر ومجاني.

الجدول أدناه يضم بعض المشاريع ذات الصلة بـ Auto.js (مرتبة حسب تاريخ التطوير):

| <span style="word-break:keep-all;white-space:nowrap">المشروع</span> |                                                             <span style="word-break:keep-all;white-space:nowrap">اسم التطبيق</span>                                                              | <span style="word-break:keep-all;white-space:nowrap">المطور</span> | <span style="word-break:keep-all;white-space:nowrap">تاريخ بداية التطوير</span> | <span style="word-break:keep-all;white-space:nowrap">تاريخ نهاية التطوير</span> |
|:------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------:|:---------------------------------------------------------------------------------------------------------------------------------:|:-------------------------------------------------------------------------------------------------------------------------------:|
|     <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/hyb1996/Auto.js)</span>      |    <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/TonyJiangWJ/Auto.js/commit/268ec8895bbfa28fc7715154eb15b1c1eaaefd14#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span>     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2017/01/27`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2020/03/13`</span>                             |
|                     <span style="word-break:keep-all;white-space:nowrap">Auto.js Pro 7</span>                      |                                                                                     <span style="word-break:keep-all;white-space:nowrap">Auto.js</span>                                                                                      |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2019/03/13`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2019/07/08`</span>                             |
|                     <span style="word-break:keep-all;white-space:nowrap">Auto.js Pro 8</span>                      |                                                                                    <span style="word-break:keep-all;white-space:nowrap">AutoJsPro</span>                                                                                     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2019/10/13`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2021/07/24`</span>                             |
|   <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/TonyJiangWJ/Auto.js)</span>    | <span style="word-break:keep-all;white-space:nowrap">[Auto.js&#160;M](https://github.com/TonyJiangWJ/Auto.js/commit/268ec8895bbfa28fc7715154eb15b1c1eaaefd14#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span> |      <span style="word-break:keep-all;white-space:nowrap">[TonyJiangWJ](https://github.com/TonyJiangWJ)</span>       |                             <span style="word-break:keep-all;white-space:nowrap">`2019/11/21`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|      <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/kkevsekk1/AutoX)</span>       |                 <span style="white-space:pre">[Autox.js](https://github.com/kkevsekk1/AutoX/commit/8143e4ed893d4af05d22aa791b83a962f9959873#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span>                  |        <span style="word-break:keep-all;white-space:nowrap">[kkevsekk1](https://github.com/kkevsekk1)</span>         |                             <span style="word-break:keep-all;white-space:nowrap">`2020/07/24`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|        <span style="word-break:keep-all;white-space:nowrap">[Auto.js Pro 9](https://pro.autojs.org/)</span>        |                                                                                    <span style="word-break:keep-all;white-space:nowrap">AutoJsPro</span>                                                                                     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2021/03/28`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2023/02/09`</span>                             |
| <span style="word-break:keep-all;white-space:nowrap">[AutoJs6](https://github.com/SuperMonster003/AutoJs6)</span>  |  <span style="word-break:keep-all;white-space:nowrap">[AutoJs6](https://github.com/SuperMonster003/AutoJs6/commit/a8ce1b9acb541e9736c33134be3194c3148a15a3#diff-833a46a97033e77558372a2dce103fd6fee29aaaa899f610022a7aece592ee7bR27)</span>  |  <span style="word-break:keep-all;white-space:nowrap">[SuperMonster003](https://github.com/SuperMonster003)</span>   |                             <span style="word-break:keep-all;white-space:nowrap">`2021/12/01`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|      <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/kkevsekk1/AutoX)</span>       |            <span style="white-space:pre">[Autox.js&#160;v6](https://github.com/kkevsekk1/AutoX/commit/8b6776cff8b0fca4be4a52719b7d7d07c0a058f3#diff-51a0b488f963eb0be6c6599bf5df497313877cf5bdff3950807373912ac1cdc9R130)</span>             |           <span style="word-break:keep-all;white-space:nowrap">[wilinz](https://github.com/wilinz)</span>            |                             <span style="word-break:keep-all;white-space:nowrap">`2022/05/26`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|        <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/aiselp/AutoX)</span>        |              <span style="white-space:pre">[Autox.js&#160;v7](https://github.com/aiselp/AutoX/commit/484491fd5fe12b8203d0b09c181eb0f471c0ea9f#diff-8cff73265af19c059547b76aca8882cbaa3209291406f52df1dafbbc78e80c46R120)</span>              |           <span style="word-break:keep-all;white-space:nowrap">[aiselp](https://github.com/aiselp)</span>            |                             <span style="word-break:keep-all;white-space:nowrap">`2024/04/21`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |

التواريخ في الجدول هي تقديرات وقد تختلف عن الواقع.

في الجدول، تعد إصدارات Auto.js Pro 7/8/9 مدفوعة، والبقية مفتوحة المصدر ومجانية.

******

### الوظائف

******

* يمكن استخدامه كبيئة تطوير تكاملية (IDE) لـ JavaScript (إكمال الكود / إعادة تسمية المتغيرات / تنسيق الكود)
* دعم تشغيل الأتمتة باستناد إلى [خدمة الوصول](https://developer.android.com/reference/android/accessibilityservice/AccessibilityService)
* دعم الإجراءات السريعة لزر الطفو (تسجيل وتشغيل السكربت / عرض حزمة النشاط / تحليل التخطيط)
* دعم واجهة برمجة التطبيقات الخاصة بالموصل وتوفير التصفح/استرجاع المعلومات/تشغيل الموصلات (مشابه لـ [UiAutomator](https://developer.android.com/training/testing/ui-automator))
* دعم تحليل واجهة التخطيط (مشابه لـ LayoutInspector في Android Studio)
* دعم ميزة التسجيل وتشغيل التسجيل
* دعم لقطة الشاشة/حفظ لقطة الشاشة/البحث عن اللون في الصورة/مطابقة الصورة
* دعم كتابة الواجهة باستخدام [E4X](https://zh.wikipedia.org/wiki/E4X) (ECMAScript for XML)
* دعم تجميع ملفات أو مشاريع السكربت إلى ملفات APK
* دعم توسيع الميزات باستخدام صلاحيات الروت (النقر, السحب, التسجيل, أوامر shell)
* دعم الاستخدام كمكون إضافي لـ Tasker
* دعم الاتصال بـ VSCode وتطوير سطح المكتب (تحتاج إلى المكون الإضافي [AutoJs6-VSCode-Extension](http://vscext-project.autojs6.com))

******

### البيئة

******

- نظام تشغيل Android
- [API](https://developer.android.com/guide/topics/manifest/uses-sdk-element#ApiLevels) [24](https://developer.android.com/reference/android/os/Build.VERSION_CODES#N) ([7.0](https://zh.wikipedia.org/wiki/Android_Nougat)) [[N](https://developer.android.com/reference/android/os/Build.VERSION_CODES#N)] وما بعده

******

### الدليل

******

* [وثائق التطبيق](https://docs.autojs6.com)
* [دليل المستخدم (قيد الإنشاء)](https://docs.autojs6.com/#/manual)
* [استكشاف الأخطاء وإصلاحها](https://docs.autojs6.com/#/qa)
* [تجميع وبناء المشروع](#project-compilation-and-build)
* [مساعدة تطوير السكريبت](#script-development-assistance)

******

### التغييرات الرئيسية

******

مقارنةً بالإصدار النهائي المفتوح المصدر لـ Auto.js `4.1.1 Alpha2`، فإن AutoJs6 قد أجرت التحديثات أو التغييرات الرئيسية التالية:

* دعم امتيازات ADB باستخدام [Shizuku](https://shizuku.rikka.app/introduction/) واستخدام واجهة برمجة التطبيقات للنظام
* دعم بناء مثيلات [WebSocket](https://docs.autojs6.com/#/webSocketType) لإرسال طلبات الشبكة استنادًا إلى [بروتوكول WebSocket](https://zh.wikipedia.org/wiki/WebSocket)
* وحدات جديدة [ [base64](https://docs.autojs6.com/#/base64) / [crypto](https://docs.autojs6.com/#/crypto) / [sqlite](https://docs.autojs6.com/#/sqlite) / [i18n](https://docs.autojs6.com/#/i18n) / [notice](https://docs.autojs6.com/#/notice) / [ocr](https://docs.autojs6.com/#/ocr) / [opencc](https://docs.autojs6.com/#/opencc) / [qrcode](https://docs.autojs6.com/#/qrcode) / [shizuku](https://docs.autojs6.com/#/shizuku) / ... ]
* دعم التكيف متعدد اللغات [ الإسبانية / الفرنسية / الروسية / العربية / اليابانية / الكورية / الإنجليزية / الصينية المبسطة / الصينية التقليدية / ... ]
* تكييف ألوان الموضوع [ التجميع / الموقع / البحث / السجل / التكييف التلقائي للسطوع والتباين / ... ]
* دعم وضع الليل [ صفحة الإعدادات / صفحة الوثائق / صفحة تحليل التخطيط / النافذة العائمة / ... ]
* دعم الاتصال بـ [المكون الإضافي لـ VSCode](http://vscext-project.autojs6.com) بطرق الاتصال عبر الشبكة المحلية (LAN) و ADB
* تم ترقية محرك [Rhino](https://github.com/mozilla/rhino/) من [v1.7.7.2](https://github.com/mozilla/rhino/releases/tag/Rhino1_7_7_2_Release) إلى [v1.8.1-SNAPSHOT](http://rhino.autojs6.com/blob/master/gradle.properties#L3)
    * دعم هروب نقطة الرمز Unicode [للأحرف متعددة المستويات](https://zh.wikipedia.org/wiki/Unicode%E5%AD%97%E7%AC%A6%E5%B9%B3%E9%9D%A2%E6%98%A0%E5%B0%84#%E7%AC%AC%E4%B8%80%E8%BC%94%E5%8A%A9%E5%B9%B3%E9%9D%A2)
       ```javascript
       '\u{1D160}'; /* تمثل "𝅘𝅥𝅮", طريقة تقليدية: '\uD834\uDD60'. */
       ```
    * دعم [Object.values()](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Global_Objects/Object/values)
       ```javascript
       Object.values({name: 'Max', age: 4}); // ['max', 4]
       ```
    * دعم [Array.prototype.includes()](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Global_Objects/Array/includes)
       ```javascript
       [10, 20, NaN].includes(20); // true
       ```
    * دعم [BigInt](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Global_Objects/BigInt)
       ```javascript
       typeof 567n === 'bigint'; // true
       ```
    * دعم [القوالب النصية](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Template_literals)
       ```javascript
       `Lucky number: ${(Math.random() * 100).toFixed(0)}`
       ```
    * عرض [المزيد من الميزات الجديدة](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/RHINO.md) لمحرك Rhino
    * عرض [قائمة التوافق](https://mozilla.github.io/rhino/compat/engines.html) لمحرك Rhino

******

### تاريخ الإصدارات

******

# v6.6.2

###### 2025/04/16

* `إضافة جديدة` طرق مثل ui.statusBarAppearanceLight و statusBarAppearanceLightBy و navigationBarColor وغيرها.
* `إضافة جديدة` الخاصية ui.statusBarHeight (getter) المستخدمة للحصول على ارتفاع شريط الحالة _[`issue #357`](http://issues.autojs6.com/357)_
* `إضافة جديدة` طريقة images.flip لقلب الصور _[`issue #349`](http://issues.autojs6.com/349)_
* `إضافة جديدة` تمت إضافة خيار "امتداد الملف" في صفحة الإعدادات
* `إضافة جديدة` صفحة إعدادات اللون الموضوع تدعم الآن تنسيقاً جديداً (تجميع، تحديد موضع، بحث، سجل، تحسين لوحة الألوان، الخ)
* `تصليح` المشكلة التي كان فيها لون خلفية شريط الحالة على Android 15 لا يتطابق مع لون الموضوع
* `تصليح` المشكلة التي كان فيها طريقة plugins.load لا تحمل الإضافات بشكل صحيح _[`issue #290`](http://issues.autojs6.com/290)_
* `تصليح` المشكلة التي كان فيها مكتبة dx لا تعمل بشكل صحيح على Android 7.x _[`issue #293`](http://issues.autojs6.com/293)_
* `تصليح` المشكلة التي كان فيها ScriptRuntime قد يظهر حالة تزامن غير طبيعية عند استخدام require لاستيراد الوحدات المدمجة (حل مؤقت) _[`issue #298`](http://issues.autojs6.com/298)_
* `تصليح` المشكلة التي كان فيها وحدة notice تفتقر إلى طرق التمديد مثل getBuilder _[`issue #301`](http://issues.autojs6.com/301)_
* `تصليح` المشكلة التي كان فيها طرق shizuku/shell لا تقبل معاملات نصية _[`issue #310`](http://issues.autojs6.com/310)_
* `تصليح` المشكلة التي كان فيها طريقة colors.pixel لا تقبل معاملات الصور ذات القناة الواحدة _[`issue #350`](http://issues.autojs6.com/350)_
* `تصليح` المشكلة التي كان فيها طرق engines.execScript/execScriptFile تستخدم مسار عمل افتراضي غير صحيح عند تنفيذ السكريبتات _[`issue #358`](http://issues.autojs6.com/358)_ _[`issue #340`](http://issues.autojs6.com/340)_ _[`issue #339`](http://issues.autojs6.com/339)_
* `تصليح` المشكلة التي كان فيها floaty.window/floaty.rawWindow لا يمكن تنفيذها في الخيوط الثانوية
* `تصليح` المشكلة التي كان فيها floaty.getClip قد لا يسترجع محتوى الحافظة بشكل صحيح _[`issue #341`](http://issues.autojs6.com/341)_
* `تصليح` المشكلة التي كان فيها ناتج ui.inflate يفتقد إلى طرق البروتوتايب مثل attr و on و click
* `تصليح` المشكلة التي كانت فيها استثناءات بعض الطرق لا يتم التقاطها بواسطة كتلة try..catch _[`issue #345`](http://issues.autojs6.com/345)_
* `تصليح` المشكلة التي كان فيها توليد الكود في صفحة تحليل التخطيطات قد يؤدي إلى تعطل التطبيق _[`issue #288`](http://issues.autojs6.com/288)_
* `تصليح` المشكلة التي كان فيها التطبيقات المعبأة لا يمكنها استخدام وحدة shizuku بشكل صحيح _[`issue #227`](http://issues.autojs6.com/227)_ _[`issue #231`](http://issues.autojs6.com/231)_ _[`issue #284`](http://issues.autojs6.com/284)_ _[`issue #287`](http://issues.autojs6.com/287)_ _[`issue #304`](http://issues.autojs6.com/304)_
* `تصليح` المشكلة في محرر الكود حيث الانتقال إلى نهاية السطر قد ينقل المؤشر إلى بداية السطر التالي
* `تصليح` المشكلة التي كان فيها النقر المتتالي السريع على العناصر الحوارية في صفحة الإعدادات قد يؤدي إلى تعطل التطبيق
* `تحسين` تحسين حجم ملف APK في قالب التطبيق المعبأ
* `تحسين` التطبيق (والتطبيقات المعبأة) الآن يدعم المزيد من الأذونات _[`issue #338`](http://issues.autojs6.com/338)_
* `تحسين` تمت إضافة خيار لمكتبة Pinyin في صفحة التعبئة
* `تحسين` تحسين خلفية شريط الحالة ولون النص في الصفحة الرئيسية للتطبيقات المعبأة
* `تحسين` إضافة مفاتيح لتبديل الأذونات الخاصة (الوصول إلى جميع الملفات وإرسال الإشعارات) في صفحة إعدادات التطبيقات المعبأة _[`issue #354`](http://issues.autojs6.com/354)_
* `تحسين` التكيف التلقائي لألوان نصوص وأيقونات عناصر التحكم بناءً على سطوع لون الموضوع
* `تحسين` تحسين التجربة البصرية عند انخفاض التباين بين لون عنصر التحكم وخلفيته
* `تحسين` تحسين توافقية حقل إدخال HEX في لوحة الألوان عند لصق القيم من الحافظة
* `تحسين` تعيين شريط التنقل في التطبيق ليكون شفافاً أو شبه شفاف لتحسين التجربة البصرية
* `تحسين` وضع واجهة المستخدم الافتراضي لشريط الحالة وشريط التنقل مضبوط على اللون `md_grey_50` في الوضع الفاتح
* `تحسين` مفتاح خدمة إمكانية الوصول في القائمة الرئيسية يتزامن الآن مع كود السكريبت
* `تحسين` صفحة الوثائق في الصفحة الرئيسية تدعم الآن أزرار البحث الثنائي الاتجاه
* `تحسين` علامة تبويب "الملفات" في الصفحة الرئيسية تسمح بتغيير ظهور الزر العائم عبر الضغط المطول
* `تحسين` عنوان محرر الكود يدعم الآن تغيير حجم الخط تلقائياً
* `تحسين` ظهور الزر العائم في صفحة السجلات مرتبط بحركات التمرير في القائمة
* `تحسين` ملف إعداد project.json لمشروع السكريبت يدعم الآن المزيد من خيارات التعبئة _[`issue #305`](http://issues.autojs6.com/305)_ _[`issue #306`](http://issues.autojs6.com/306)_
* `تحسين` ملف project.json يدعم الآن مطابقة أكثر مرونة لأسماء الخيارات والتوافق مع الأسماء المستعارة
* `تحسين` حوار معلومات نوع ملف APK يشمل الآن حجم الملف ومعلومات توقيع المخطط
* `تحسين` حوار معلومات نوع ملف APK يدعم الآن مستمعي النقر لنسخ النص والتنقل إلى تفاصيل التطبيق
* `تحسين` محاولة لاستعادة الحزم التي تحمل بادئة com.stardust لتحسين توافقية الكود _[`issue #290`](http://issues.autojs6.com/290)_
* `تحسين` طرق floaty.window/floaty.rawWindow أصبحت تدعم التنفيذ في الخيط الرئيسي والثانوي
* `تحسين` الطريقة العامة getClip تستخدم الآن floaty.getClip عند الحاجة لتحسين التوافقية
* `تحسين` تحسين توافقية طرق files.path والطرق المرتبطة عند تمرير قيمة فارغة لمسار
* `تحسين` المزامنة مع أحدث إصدار رسمي لمحرك Rhino وتعديل الكود اللازم
* `تحسين` تحسين README.md لتوثيق أفضل لعملية بناء وتشغيل المشروع _[`issue #344`](http://issues.autojs6.com/344)_
* `تحسين` تعديلات على إصدارات بعض التبعيات أو المكتبات المحلية _[`CHANGELOG.md`](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG.md#v662)_

# v6.6.1

###### 2025/01/01

* `إضافة جديدة` وحدة Pinyin لتحويل النصوص الصينية إلى بينيين (راجع وثائق المشروع > [البينيين الصيني](https://docs.autojs6.com/#/pinyin))
* `إضافة جديدة` وحدة Pinyin4j لتحويل النصوص الصينية إلى بينيين (راجع وثائق المشروع > [البينيين الصيني](https://docs.autojs6.com/#/pinyin4j))
* `إضافة جديدة` الطرق UiObject#isSimilar و UiObjectCollection#isSimilar لتحديد ما إذا كان العنصر أو مجموعة العناصر متشابهة
* `إضافة جديدة` الطريقة العامة "currentComponent"، تُستخدم للحصول على اسم المكون النشط الحالي
* `تصليح` مشكلة عدم قدرة المشروع على التجميع بشكل صحيح في بعض البيئات بسبب الرجوع إلى إصدار أقدم
* `تصليح` خطأ "قيمة غير أولية" قد يحدث عند استدعاء طرق غير موجودة
* `تصليح` مشكلة عدم إمكانية إضافة اختصارات النصوص على بعض الأجهزة (إصلاح مؤقت) _[`issue #221`](http://issues.autojs6.com/221)_
* `تصليح` خطأ في قيود نوع الوسائط للطرق automator.click/longClick _[`issue #275`](http://issues.autojs6.com/275)_
* `تصليح` مشكلة عدم دعم المصفوفات مع الوسائط من نوع ConsString _[`issue #277`](http://issues.autojs6.com/277)_
* `تصليح` مشكلة فقدان الطرق والخصائص في مثيلات UiObjectCollection
* `تحسين` تدعم صفحة التغليف إعداد التوقيعات وإدارة مستودعات المفاتيح وإعداد الأذونات (بواسطة [luckyloogn]()) _[`pr #286`]()_
* `تحسين` تم تحسين دقة التعرف على اسم الحزمة الحالية واسم النشاط الحالي في النوافذ العائمة (الأولوية: Shizuku > Root > A11Y)
* `تحسين` تم تحسين دقة التعرف على currentPackage و currentActivity (الأولوية: Shizuku > Root > A11Y)
* `تحسين` استعادة إمكانية اختيار محتوى النص لكل عنصر في نافذة النشاط الخاصة بالسجلات بالنقر المزدوج أو الضغط المطول _[`issue #280`](http://issues.autojs6.com/280)_
* `تحسين` استعادة أكبر قدر ممكن من المعلومات الأساسية لمشاريع النصوص عند تلف ملف project.json
* `تحسين` تحويل اللغة الصينية المبسطة تلقائيًا إلى نظام بينيين (بما في ذلك الحروف متعددة النغمات) عند توليد اللواحق للأسماء في الملفات المفردة
* `تحسين` دعم الوسائط السلبية في الطرق UiSelector#findOnce و UiSelector#find
* `تحسين` تم تحسين تكيفية أساليب app.startActivity/startDualActivity
* `تحسين` دعم أشكال مختصرة إضافية لبادئات الأسماء في المصفوفات المرتبطة بعناصر الواجهة (مثل RecyclerView و Snackbar وغيرها)
* `تحسين` مزامنة أحدث كود من المصدر الرئيسي لمحرك Rhino وتكييفه مع المشروع الحالي
* `تحسين` تعديلات على إصدارات بعض التبعيات أو المكتبات المحلية _[`CHANGELOG.md`](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG.md#v661)_

# v6.6.0

###### 2024/12/02 - إعادة كتابة الوحدات المدمجة، الترقي بحذر

* `تلميح` تمت إعادة كتابة الوحدات المدمجة باستخدام Kotlin لتحسين كفاءة تشغيل البرامج النصية ولكن قد يتطلب ذلك عدة تكرارات للتطوير بشكل تدريجي
* `تلميح` ملف init.js المدمج هو فارغ بشكل افتراضي ولكنه يدعم توسيع الوحدات المدمجة أو تحميل وحدات خارجية بواسطة المطورين
* `إضافة جديدة` وحدة axios / وحدة cheerio (راجع إلى [AutoX](https://github.com/kkevsekk1/AutoX))
* `إضافة جديدة` وحدة sqlite، تُستخدم للعمليات البسيطة على قواعد بيانات SQLite (راجع إلى [Auto.js Pro](https://g.pro.autojs.org/)) (ارجع إلى مستندات المشروع > [SQLite](https://docs.autojs6.com/#/sqlite))
* `إضافة جديدة` وحدة mime، تُستخدم لمعالجة وتحليل سلاسل نوع MIME (ارجع إلى مستندات المشروع > [MIME](https://docs.autojs6.com/#/mime))
* `إضافة جديدة` وحدة nanoid، يمكن استخدامها كمولد لسلاسل معرفات (راجع إلى [ai/nanoid](https://github.com/ai/nanoid))
* `إضافة جديدة` وحدة sysprops، تُستخدم للحصول على بيانات تكوين بيئة التشغيل (ارجع إلى مستندات المشروع > [خصائص النظام](https://docs.autojs6.com/#/sysprops))
* `إضافة جديدة` تدعم وحدة ocr محرك [Rapid OCR](https://github.com/RapidAI/RapidOCR)
* `إضافة جديدة` دعم تحليل التخطيط لتبديل النوافذ (راجع إلى [Auto.js Pro](https://g.pro.autojs.org/))
* `إضافة جديدة` طريقة auto.clearCache، تدعم مسح ذاكرة الكاش (راجع إلى [Auto.js Pro](https://g.pro.autojs.org/))
* `إضافة جديدة` طريقة threads.pool، تدعم تطبيق بسيط للمؤشرات (راجع إلى [Auto.js Pro](https://g.pro.autojs.org/))
* `إضافة جديدة` طريقة images.matchTemplate تضيف خيار useTransparentMask لدعم البحث الشفاف عن الصور (راجع إلى [Auto.js Pro](https://g.pro.autojs.org/))
* `إضافة جديدة` طريقة images.requestScreenCaptureAsync، تُستخدم لطلب إذن لالتقاط الشاشة بشكل غير متزامن في وضع UI (راجع إلى [Auto.js Pro](https://g.pro.autojs.org/))
* `إضافة جديدة` طريقة images.requestScreenCapture تضيف خيار isAsync لدعم الحصول على لقطة الشاشة بشكل غير متزامن (راجع إلى [Auto.js Pro](https://g.pro.autojs.org/))
* `إضافة جديدة` طرق مراقبة الأحداث مثل images.on('screen_capture', callback)، تدعم مراقبة توافر لقطة الشاشة (راجع إلى [Auto.js Pro](https://g.pro.autojs.org/))
* `إضافة جديدة` طريقة images.stopScreenCapture، تدعم تحرير الموارد المتعلقة بطلب لقطة الشاشة (راجع إلى [Auto.js Pro](https://g.pro.autojs.org/))
* `إضافة جديدة` طرق images.psnr/mse/ssim/mssim/hist/ncc وimages.getSimilarity، تُستخدم للحصول على مقادير تشابه الصور
* `إضافة جديدة` طريقة images.isGrayscale، لتحديد ما إذا كانت الصورة رمادية أم لا
* `إضافة جديدة` طريقة images.invert، تُستخدم لعكس ألوان الصورة
* `إضافة جديدة` طرق s13n.point/time، لتوحيد كائنات النقاط وكائنات الوقت (ارجع إلى مستندات المشروع > [التوحيد](https://docs.autojs6.com/#/s13n))
* `إضافة جديدة` طرق وحدة console، مثل gravity (الجاذبية)، touchThrough (النقر عبر)، وbackgroundTint (تلوين الخلفية) (ارجع إلى مستندات المشروع > [وحدة التحكم](https://docs.autojs6.com/#/console))
* `إضافة جديدة` طرائق Mathx.randomInt/Mathx.randomFloat، تستخدم لإرجاع عدد صحيح أو نقطة عشوائية ضمن النطاق المحدد
* `إضافة جديدة` طرق app.launchDual/startDualActivity، تُستخدم للتعامل مع التطبيقات المزدوجة (تتطلب Shizuku أو Root) (تجريبي)
* `إضافة جديدة` طريقة app.kill، تُستخدم لإيقاف التطبيق بالقوة (تتطلب Shizuku أو Root)
* `إضافة جديدة` طريقة floaty.getClip، تُستخدم للحصول على محتوى الحافظة بشكل غير مباشر باستخدام نافذة عائمة
* `تصليح` تسرب الذاكرة في الارتباط العرضي في الفئات الفرعية لFragment (مثل [DrawerFragment](https://github.com/SuperMonster003/AutoJs6/blob/17616504ab0bba93b30ab7abc67108ee5253f39a/app/src/main/java/org/autojs/autojs/ui/main/drawer/DrawerFragment.kt#L369) / [ExplorerFragment](https://github.com/SuperMonster003/AutoJs6/blob/17616504ab0bba93b30ab7abc67108ee5253f39a/app/src/main/java/org/autojs/autojs/ui/main/scripts/ExplorerFragment.kt#L48) إلخ)
* `تصليح` تسرب الذاكرة في مثيلات الفئات مثل [ScreenCapture](https://github.com/SuperMonster003/AutoJs6/blob/17616504ab0bba93b30ab7abc67108ee5253f39a/app/src/main/java/org/autojs/autojs/core/image/capture/ScreenCapturer.java#L70) / [ThemeColorPreference](https://github.com/SuperMonster003/AutoJs6/blob/10960ddbee71f75ef80907ad5b6ab42f3e1bf31e/app/src/main/java/org/autojs/autojs/ui/settings/ThemeColorPreference.kt#L21) إلخ
* `تصليح` مشكلة تسبب تعطل التطبيق عند طلب إذن لقطة الشاشة على Android 14 (by [chenguangming](https://github.com/chenguangming)) _[`pr #242`](http://pr.autojs6.com/242)_
* `تصليح` مشكلة تسبب تعطل التطبيق عند تشغيل الخدمة الأمامية على Android 14
* `تصليح` مشكلة بطئ إضاءة زر تشغيل محرر الأكواد على Android 14
* `تصليح` مشكلة تؤدي إلى عدم القدرة على تشغيل التطبيق نتيجة نقص الملفات الأساسية بعد حزم المشروع _[`issue #202`](http://issues.autojs6.com/202)_ _[`issue #223`](http://issues.autojs6.com/223)_ _[`pr #264`](http://pr.autojs6.com/264)_
* `تصليح` مشكلة تعطل التطبيق بسبب عدم وجود موارد الأيقونات المخصصة أثناء تحرير المشروع _[`issue #203`](http://issues.autojs6.com/203)_
* `تصليح` عدم القدرة على استخدام المعلمات للحصول على لقطة الشاشة باتجاه معين أثناء طلب إذن لقطة الشاشة
* `تصليح` مشكلة في بعض الأجهزة التي لا يمكنها إضافة اختصارات البرامج النصية بشكل سليم (محاولة إصلاح) _[`issue #221`](http://issues.autojs6.com/221)_
* `تصليح` مشكلة تأخير تراكمي في إرسال الطلبات عند استدعاء الطرائق المتعلقة بوحدة http
* `تصليح` مشكلة في عدم قدرة خدمة Shizuku على العمل بشكل صحيح قبل الدخول إلى النشاط الرئيسي لـ AutoJs6 (محاولة إصلاح) _[`issue #255`](http://issues.autojs6.com/255)_
* `تصليح` مشكلة تجاوز النتيجة في طريقة random(min, max)
* `تصليح` عدم القدرة على تمرير المعلمات من النوع الفارغ في طريقة pickup
* `تصليح` مشكلة في تحريف الشكل الثابت للمعامل عند الحصول على المربعات باستخدام UiObject#bounds()
* `تصليح` مشكلة عدم القدرة على تحليل النصوص التي تحتوي على علامات تنصيص نصف عريضة في العناصر text/button/input
* `تصليح` مشكلة عدم فعالية وظيفة autoLink في عناصر text/textswitcher
* `تصليح` مشكلة في مشاركة كائن ScriptRuntime بين السكريبتات المختلفة
* `تصليح` فقدان الخواص الديناميكية للمتغيرات العامة HEIGHT وWIDTH
* `تصليح` مشكلة في التأخير في بدء التحميل المفاجئ لـ RootShell أثناء بدء تشغيل البرنامج النصي
* `تصليح` مشكلة في ضبط لون الخلفية التي تسبب فقدان الزوايا المستديرة للنافذة العائمة في وحدة التحكم
* `تصليح` مشاكل تعطل الخدمة في التشغيل التلقائي لنظام التشغيل بدون حزمة كاملة (محاولة إصلاح)
* `تصليح` مشكلة تبديل ViewPager عند التمرير الأفقي في WebView في صفحة المستندات الرئيسية
* `تصليح` مشكلة عدم القدرة على تحديد الملفات ذات الامتداد الكبير في مدير الملفات
* `تصليح` مشكلة عدم قدرة مدير الملفات على التعرف التلقائي على المشروع عند الدخول الأول إلى دليله
* `تصليح` مشكلة عدم تحديث الصفحة تلقائيًا بعد حذف المجلد في مدير الملفات
* `تصليح` مشكلة في ترتيب الملفات والمجلدات في مدير الملفات بسبب وضع اسم الحرف الأول في ASCII في نهاية القائمة
* `تصليح` خطأ فشل التثبت في وظيفة تصحيح الأخطاء لمحرر الأكواد
* `تصليح` مشكلة عدم القدرة على بدء التصحيح بعد إغلاق محرر الأكواد أثناء التصحيح
* `تصليح` مشكلة تجاوز العناصر عند التنقل إلى نهاية السطر في محرر الأكواد
* `تصليح` مشكلة وميض عند تشغيل صفحة السجلات في الصفحة الرئيسية للنشاط
* `تصليح` عدم القدرة على استخدام وحدة opencc مع التطبيقات المعبأة بشكل صحيح
* `تحسين` تحسين تجربة النقر على عنصر تحكم ABI غير متاح في صفحة التعبئة
* `تحسين` دعم التحكم في تشغيل عرض مواقع المؤشر باستخدام Shizuku
* `تحسين` دعم التحكم في تشغيل "إبراز وسائل الإعلام" و"تعديل إعدادات الأمان" باستخدام Shizuku
* `تحسين` تدعم طرائق automator.gestureAsync/gesturesAsync معلمات دالة الاستدعاء
* `تحسين` استخدام الوحدات النمطية كوحدة tasks لتنفيذ العمليات على قاعدة البيانات بطريقة متزامنة لتجنب التناقضات المحتملة في الوصول إلى البيانات
* `تحسين` دعم وضع التشغيل البرمجي باستخدام فواصل الأنابيب (مثل `"ui|auto";` في البداية)
* `تحسين` دعم وضع التشغيل البرمجي باستخدم الأقواس الفردية و`الخلفية بالتخطي`; وتقديم القدرة على إغفال الفواصل المنقوطة (مثل بدايةً `'ui';` أو `'ui'`)
* `تحسين` دعم استيراد النماذج المدمجة مثل axios, cheerio, dayjs وغيرها من النماذج باستخدام معلم الأوضاع السريعة (مثل `"axios";` في البداية)
* `تحسين` دعم استيراد وحدات JavaScript الداخلية باستخدام "x" أو "jsox" كمعلم الأوضاع السريعة (مثل `"x";` في البداية)
* `تحسين` دعم مسارات محلية نسبية في خصائص عنصر img src و path (مثل `<img src="a.png"` />)
* `تحسين` دعم التعرف الذكي على موقع الإدراج عند استيراد فئات وحزم Java في محرر الأكواد
* `تحسين` دعم استخدام المسارات كمعلمات الصور مباشرة في وحدة images
* `تحسين` دعم المعلمات في استيراد الحزم باستخدام importPackage
* `تحسين` دعم التعرف الذكي على عناوين IP في وضع الخادم من الحافظة ودعم التحويل الذكي باستخدام مفتاح المسافة
* `تحسين` دعم إنشاء الملفات برقم تسلسلي افتراضي ومناسب مع اختيار تلقائي للبادئة في مدير الملفات
* `تحسين` توفر رسائل خطأ مفصلة عند تشغيل مشروع معين في مدير الملفات _[`issue #268`](http://issues.autojs6.com/268)_
* `تحسين` دعم المزيد من أنواع الملفات ودعم عرض الرموز المقابلة (يدعم أكثر من 800 نوع من الملفات) في مدير الملفات
* `تحسين` إضافة زر لتعديل أنواع الملفات القابلة للتحرير (jpg/doc/pdf...) في مدير الملفات
* `تحسين` إضافة دعم لعرض المعلومات الأساسية وبيانات Manifest وقائمة الأذونات لملفات APK في مدير الملفات
* `تحسين` دعم عرض المعلومات الأساسية وبيانات MediaInfo للملفات الوسائطية (الصوت والفيديو) في مدير الملفات
* `تحسين` دعم إدخال اسم الحزمة القياسي تلقائيًا عند تعبئة ملف فردي وتقديم تحذيرات حول الشخصيات غير الصالحة
* `تحسين` دعم إعداد الأيقونة وزيادة رقم الإصدار واسم الإصدار تلقائيًا بناءً على التطبيقات المثبتة من نفس اسم الحزمة عند تعبئة ملف فردي
* `تحسين` دعم تحديد وحدات ABI والمكتبات الافتراضية المتضمنة باستخدام خيارات abis/libs في ملفات تكوين المشاريع التعبئة
* `تحسين` دعم الرسائل التحذيرية عند تعذر فاعلية الخيارات المحددة لـ abis/libs في ملفات تكوين المشاريع التعبئة
* `تحسين` استبعاد LeakCanary في إصدارات الإنتاج لتقليل الأعباء غير الضرورية
* `تحسين` إضافة ترجمات باللغة الصينية للتعليقات الإنجليزية في الشيفرة المصدرية للمشروع لتحسين قابلية القراءة للتعليقات
* `تحسين` دعم README وCHANGELOG للغات متعددة (توليد النصوص تلقائيًا)
* `تحسين` تحسين التكيف الذاتي لإصدارات السكريبت الإنشائي لـ Gradle
* `تحسين` تعديلات على إصدارات بعض التبعيات أو المكتبات المحلية _[`CHANGELOG.md`](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG.md#v660)_

##### لمزيد من تاريخ الإصدارات، ارجع إلى

* [CHANGELOG.md](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG-ar.md)

******

### <a id="project-compilation-and-build"></a>تجميع وبناء المشروع

******

لتصحيح أو تطوير مشروع AutoJs6، يمكنك استخدام [Android Studio](https://pro.autojs.org/) (منتج من [Google](https://www.google.com/)) أو [IntelliJ IDEA](https://www.jetbrains.com/idea/) (منتج من [Jetbrains](https://www.jetbrains.com/)).

يتناول هذا القسم طرق بناء وتجميع مشروع AutoJs6 المفتوح المصدر مستخدمًا Android Studio كمثال، يمكن استخدام IntelliJ IDEA بنفس الطريقة.

#### تحضير Android Studio

قم بتنزيل إصدار `Android Studio Meerkat | 2024.3.1 Patch 1` (حدد أحدها حسب الحاجة):

- [android-studio-2024.3.1.14-windows.exe](https://redirector.gvt1.com/edgedl/android/studio/install/2024.3.1.14/android-studio-2024.3.1.14-windows.exe) (1.22 GB)
- [android-studio-2024.3.1.14-windows.zip](https://redirector.gvt1.com/edgedl/android/studio/ide-zips/2024.3.1.14/android-studio-2024.3.1.14-windows.zip) (1.23 GB)

> ملاحظة: تاريخ الإصدار بالنسخة المذكورة أعلاه هو 24 March 2025. إذا كنت بحاجة إلى تنزيل إصدار آخر، أو إذا كان الرابط المذكور غير صالح، يمكنك زيارة [أرشيف إصدارات Android Studio](https://developer.android.com/studio/archive?hl=en).

قم بتثبيت أو فك ضغط الملف المذكور سابقًا، ثم قم بتشغيل برنامج Android Studio (مثل `"D:\android-studio\bin\studio64.exe"`).

#### تحضير Android SDK

> ملاحظة: إذا كان نظام الكمبيوتر يحتوي بالفعل على Android SDK (مجموعة تطوير البرمجيات لنظام أندرويد)، فيمكنك تخطي هذا القسم.

في برنامج Android Studio، استخدم الاختصار `CTRL + ALT + S` لفتح صفحة الإعدادات:

```text
Appearance & Behavior (الشكل العام والسلوك) -> 
System Settings (إعدادات النظام) -> 
Android SDK (مجموعة تطوير البرامج لنظام Android)
```

إذا كان حقل `موقع Android SDK (Android SDK Location)` فارغًا، يمكنك النقر على زر `تحرير (Edit)` على اليمين، والنقر على `التالي (Next)` عدة مرات في النافذة المنبثقة.

> ملاحظة: قد يتطلب الأمر الموافقة على اتفاقية واحدة أو أكثر للاستمرار في العملية.

عندما يتم تنزيل وتثبيت الموارد ذات الصلة، انقر على زر `إنهاء (Finish)`.  
سيتم تلقائيًا ملء المسار في حقل `موقع Android SDK (Android SDK Location)` المشار إليه أعلاه، وسيتم إنجاز أعمال التحضير للـ SDK.

#### تحضير أدوات Android SDK

AutoJs6 يتطلب استخدام بعض أدوات SDK (مثل NDK وCMake).

> ملاحظة: إذا كان النظام يحتوي بالفعل على جميع أدوات Android SDK المطلوبة لمشروع AutoJs6، فيمكنك تخطي هذا القسم.

استخدام اختصار `CTRL + ALT + S` في برنامج Android Studio لفتح صفحة الإعدادات:

```text
Appearance & Behavior (الشكل العام والسلوك) -> 
System Settings (إعدادات النظام) -> 
Android SDK (مجموعة تطوير البرامج لنظام Android) -> 
SDK Tools  (أدوات SDK) (في النافذة اليمنى)
```

حدد `إظهار تفاصيل الحزمة (Show Package Details)`، وقم بالنقر على NDK و CMake، وتأكد من تحديد الأدوات الخاصة بها ,تقع معلومات إصدار أدوات SDK في ملف `version.properties` في جذر مشروع AutoJs6.

#### تحضير JDK

يعتمد مشروع AutoJs6 على إصدار `JDK (مجموعة تطوير جافا)` بإصدار لا يقل عن `17`، ولكن يفضل الإصدار الذي لا يقل عن `19`.

اعتبارًا من 16 April 2025، الإصدار الأقصى المدعوم من JDK لمشروع AutoJs6 هو `24`.

> ملاحظة: إذا كان نظام الكمبيوتر يحتوي على JDK والإصدار يفي بالمتطلبات المذكورة أعلاه، فيمكنك تخطي هذا القسم.

يمكن تنزيل JDK مباشرةً باستخدام IDE، أو زيارة [موقع Oracle](https://www.oracle.com/java/technologies/downloads/) لتنزيله.

استخدم اختصار `CTRL + ALT + S` في برنامج Android Studio لفتح صفحة الإعدادات:

```text
Build, Execution, Deployment (البناء، التنفيذ، التوزيع) -> 
Build Tools (أدوات البناء) -> 
Gradle
```

يمكنك اختيار أو إضافة إصدار JDK مختلف في حقل `Gradle JDK`.

إذا كان الإصدار المناسب للـ JDK (>= `17`) موجوداً بالفعل في القائمة، فيمكنك تحديده مباشرةً.  
يمكنك اختيار `Download JDK (تنزيل JDK)` لتنزيل JDK المناسب، انقر على زر `Download (تنزيل)` وانتظر حتى يكتمل التنزيل.  
يمكنك أيضًا اختيار `Add JDK (إضافة JDK)` لإضافة JDK موجود محليًا، وتحديد مساره وإكمال الإضافة.

#### استنساخ موارد AutoJs6

في شاشة Android Studio الرئيسية، انقر على زر `Get from VCS (الحصول من نظام التحكم في الإصدارات)`.  
أدخل العنوان `https://github.com/SuperMonster003/AutoJs6.git` في حقل `URL (عنوان الموارد الموحدة)`,  
يمكن تعديل المسار في حقل `Directory (المجلد)` حسب الحاجة.  
انقر على زر `Clone (استنساخ)`، وانتظر حتى يكتمل استنساخ موارد مشروع AutoJs6 محليًا.

> ملاحظة: قد تتطلب العملية المذكورة أعلاه تثبيت [Git (نظام التحكم في الإصدار الموزع)](https://git-scm.com/download).

#### بناء مشروع AutoJs6

عند اكتمال الاستنساخ، سيفتح Android Studio نافذة مشروع AutoJs6، ويكمل تلقائيًا تنزيل `Dependencies (التبعيات)` الأساسية وبناء Gradle.

> ملاحظة: قد تستغرق العملية المذكورة أعلاه وقتًا طويلًا. إذا كانت حالة الشبكة غير جيدة، قد تحتاج إلى المحاولة عدة مرات (بالنقر على زر Retry).

إذا لم يتمكن البناء من المتابعة تلقائيًا أو إذا كنت بحاجة إلى إعادة بناء المشروع، فاتبع الخطوات التالية:

- من قائمة `Run/Debug Configurations` في شريط الأدوات، اختر `app`، وهو التطبيق الرئيسي لـ AutoJs6
- انقر على زر `Build Project` (رمز المطرقة) على اليسار لبدء بناء المشروع. الاختصار الافتراضي هو CTRL + F9
- انتظر انتهاء البناء. ستظهر رسالة في تبويب `Builder Output` مثل "BUILD SUCCESSFUL in 1h 17m 34s"

إذا فشل البناء، يمكنك الإبلاغ عن رسالة الخطأ في صفحة [Issues](http://issues.autojs6.com) لمشروع AutoJs6.

> ملحوظة: لمزيد من التفاصيل حول كيفية بناء وتشغيل التطبيق، يرجى الرجوع إلى [Android Docs](https://developer.android.com/studio/run?hl=en)

#### نشر مشروع AutoJs6 (تشغيل التطبيق)

بمجرد بناء المشروع بنجاح، يمكن نشره كتطبيق (App) على جهاز فعلي (مثل الهاتف/اللوحي) أو جهاز افتراضي (مثل محاكي Android).

- في شريط الأدوات، اختر `app` من قائمة `Run/Debug Configurations`، وهو التطبيق الرئيسي لـ AutoJs6
- في القائمة المنسدلة `Available Devices` على اليمين، اختر الجهاز الذي يجب تشغيل تطبيق المشروع عليه (جهاز فعلي أو افتراضي)
- انقر على زر `Run` (رمز المثلث) على اليمين لتشغيل التطبيق. الاختصار الافتراضي هو `F10`
- انتظر انتهاء النشر؛ سيقوم الجهاز المحدد بتثبيت وتشغيل التطبيق تلقائيًا

#### نشر مشروع AutoJs6 (إنشاء APK)

حزم المشروع وإنشاء ملف APK يمكن تثبيته على أجهزة Android:

- نسخة تجريبية (Debug Version)
    - `Build (بناء)` -> `Build Bundle(s) / APK(s)` -> `Build APK(s)`
    - توليد حزمة تثبيت الإصدار التجريبي مع التوقيع الافتراضي
    - مثال على المسار: `"D:\AutoJs6\app\build\outputs\apk\debug\"`
- نسخة مطروحة (Release Version)
    - `Build (بناء)` -> `Generate Signed Bundle / APK`
    - اختيار خيار `APK`
    - قم بإعداد ملف التوقيع (تكوين جديد أو اختيار موجود)، وتوليد حزمة تثبيت الإصدار المطروح
    - مثال على المسار: `"D:\AutoJs6\app\release\"`

> ملحوظة: لمزيد من المعلومات حول كيفية بناء التطبيق لإصداره للمستخدمين، يرجى الرجوع إلى [Android Docs](https://developer.android.com/build/build-for-release?hl=en)

#### مهام بناء Gradle المحددة مسبقًا لـ AutoJs6

بالإضافة إلى بناء التطبيق، يدعم AutoJs6 عدة مهام بناء Gradle المحددة مسبقًا التي تساعد المطورين في تنفيذ العمليات المتعلقة بالمشروع بسهولة.

ضمن قائمة `Run/Debug Configurations` في شريط الأدوات، يمكنك العثور على المهام المحددة مسبقًا لـ Gradle، حيث تظهر أيقونة الفيل على اليسار لكل مهمة.

- AutoJs6 [inrt:assemble]

تجميع نسخة البناء "inrt"، التي تخدم بشكل أساسي ميزة تغليف نصوص AutoJs6.

يمتلك مشروع AutoJs6 نسخ بناء مختلفة. النسخة "inrt" تُستخدم لتغليف النصوص، حيث تقوم بإنشاء ملف النموذج "template.apk" المطلوب للتغليف.

عند استخدام ميزة التغليف، قد تواجه رسالة الخطأ التالية:

> java.io.FileNotFoundException: template.apk

هذا يشير إلى أن ملف النموذج غير موجود. يجب تشغيل مهمة `inrt:assemble` يدويًا لإنشاء ملف النموذج، ثم إعادة البناء والنشر مرة أخرى.

> ملحوظة: ملف النموذج مفقود؛ قم بتشغيل مهمة `inrt:assemble` يدويًا لإنشائه قبل إعادة البناء والنشر مرة أخرى

- AutoJs6 [app:bundle]

حزم مخرجات عملية البناء بوضع التصحيح، وتستخدم بشكل رئيسي لمشروع [تعريفات AutoJs6](http://dts-project.autojs6.com).

بعد تشغيل المهمة، يتم إنتاج أحدث ملف JAR لمشروع AutoJs6. باستخدام أداة [Android d.ts Generator](https://github.com/NativeScript/android-dts-generator) (من [NativeScript](https://github.com/NativeScript)) يمكنك إنشاء تعريفات الأنواع (بتنسيق d.ts) للتطبيق الرئيسي لـ AutoJs6.

- AutoJs6 [app:digest]

إلحاق معلومات الملخص بملف APK الذي تم إنتاجه من بناء الإصدار، وذلك لتحديد الاسم النهائي للملف قبل نشر أحدث نسخة من AutoJs6 على GitHub.

فيما يلي مقارنة بين أسماء الملفات قبل وبعد إلحاق معلومات الملخص:

```text
قبل:
autojs6-v6.6.2-arm64-v8a.apk
بعد:
autojs6-v6.6.2-arm64-v8a-0f2a9d74.apk
```

> مرجع: [Android Docs](https://developer.android.com/studio/run?hl=zh-cn)

******

### <a id="script-development-assistance"></a>مساعدة تطوير السكريبت

******

لتطوير سكربتات يمكن تشغيلها بواسطة AutoJs6، تحتاج إلى استخدام أدوات تطوير مناسبة:

- [VSCode](https://code.visualstudio.com/download) / [WebStorm](https://www.jetbrains.com/webstorm/download/) / [HBuilderX](https://www.dcloud.io/hbuilderx.html) ...

إذا كنت بحاجة إلى كتابة وتصحيح السكربتات على الكمبيوتر الشخصي، يمكن لمكون VSCode الإضافي تحقيق الاتصال بين الكمبيوتر والهاتف:

- [AutoJs6-VSCode-Extension](http://vscext-project.autojs6.com) - مصحح الأخطاء لـ AutoJs6 (مكون إضافي لـ VSCode)

أثناء كتابة الكود باستخدام أدوات التطوير، يمكن أن تساعد ميزة الإكمال التلقائي الذكية في إكمال الكود:

- [AutoJs6-TypeScript-Declarations](http://dts-project.autojs6.com) - ملفات تعريف AutoJs6 (إكمال الكود الذكي)

أثناء كتابة الكود، يمكن الرجوع إلى الوثائق التطبيقية لـ AutoJs6 والمعلومات حول استخدام API ذات الصلة:

- [AutoJs6-Documentation](http://docs-project.autojs6.com) - وثائق تطبيق AutoJs6

مشاريع تطوير السكربتات الموجودة يمكن أن تكون مرجعًا وإلهامًا لإنشاء المشاريع الشخصية:

- [Ant-Forest](https://github.com/TonyJiangWJ/Ant-Forest) - سكربت لجمع الطاقة تلقائيًا في غابة النمل بواسطة [TonyJiangWJ](https://github.com/TonyJiangWJ)
- [Ant-Forest](https://github.com/SuperMonster003/Ant-Forest) - سكربت لجمع الطاقة تلقائيًا في غابة النمل بواسطة [SuperMonster003](https://github.com/SuperMonster003)
- [autojs](https://github.com/e1399579/autojs) - سكربتات مفيدة لـ Auto.js بواسطة [e1399579](https://github.com/e1399579)
- [autojsDemo](https://github.com/snailuncle/autojsDemo) - أمثلة تجريبية لـ Auto.js بواسطة [snailuncle](https://github.com/snailuncle)
- [المستودعات ذات الصلة بـ autojs](https://github.com/topics/autojs) - جميع المستودعات المتعلقة بـ autojs على GitHub

******

### المشاركة بالإسهام

******

شكرًا لكل من ساهم في تطوير مشروع AutoJs6.

|         <span style="word-break:keep-all;white-space:nowrap">المساهمون</span>          |                   <span style="word-break:keep-all;white-space:nowrap">عدد الإرساليات</span>                    | <span style="word-break:keep-all;white-space:nowrap">أحدث الإرساليات</span> |
|:-------------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------:|
|          <span style="word-break:keep-all;white-space:nowrap">[luckyloogn](https://github.com/luckyloogn)</span>          |       <span style="word-break:keep-all;white-space:nowrap">[3](https://github.com/SuperMonster003/AutoJs6/commits?author=luckyloogn)</span>        |                    <span style="word-break:keep-all;white-space:nowrap">`2025/01/01`</span>                    |
|                <span style="word-break:keep-all;white-space:nowrap">[kvii](https://github.com/kvii)</span>                |          <span style="word-break:keep-all;white-space:nowrap">[1](https://github.com/SuperMonster003/AutoJs6/commits?author=kvii)</span>           |                    <span style="word-break:keep-all;white-space:nowrap">`2024/10/16`</span>                    |
|   <span style="word-break:keep-all;white-space:nowrap">[chenguangming](https://github.com/chenguangming) `(Tom)`</span>   | <span style="word-break:keep-all;white-space:nowrap">[2](https://github.com/SuperMonster003/AutoJs6/pulls?q=is%3Apr+author%3Achenguangming)</span> |                    <span style="word-break:keep-all;white-space:nowrap">`2024/05/14`</span>                    |
|          <span style="word-break:keep-all;white-space:nowrap">[LZX284](https://github.com/LZX284) `(AI)`</span>           |         <span style="word-break:keep-all;white-space:nowrap">[17](https://github.com/SuperMonster003/AutoJs6/commits?author=LZX284)</span>         |                    <span style="word-break:keep-all;white-space:nowrap">`2023/11/19`</span>                    |
|         <span style="word-break:keep-all;white-space:nowrap">[TonyJiangWJ](https://github.com/TonyJiangWJ)</span>         |       <span style="word-break:keep-all;white-space:nowrap">[4](https://github.com/SuperMonster003/AutoJs6/commits?author=TonyJiangWJ)</span>       |                    <span style="word-break:keep-all;white-space:nowrap">`2023/10/31`</span>                    |
| <span style="word-break:keep-all;white-space:nowrap">[little&#x2011;alei](https://github.com/little-alei) `(抠脚本人)`</span> |      <span style="word-break:keep-all;white-space:nowrap">[12](https://github.com/SuperMonster003/AutoJs6/commits?author=little-alei)</span>       |                    <span style="word-break:keep-all;white-space:nowrap">`2023/07/12`</span>                    |
|              <span style="word-break:keep-all;white-space:nowrap">[aiselp](https://github.com/aiselp)</span>              |    <span style="word-break:keep-all;white-space:nowrap">[6](https://github.com/SuperMonster003/AutoJs6/pulls?q=is%3Apr+author%3Aaiselp)</span>     |                    <span style="word-break:keep-all;white-space:nowrap">`2023/06/14`</span>                    |
|           <span style="word-break:keep-all;white-space:nowrap">[LYS86](https://github.com/LYS86) `(Lin)`</span>           |          <span style="word-break:keep-all;white-space:nowrap">[2](https://github.com/SuperMonster003/AutoJs6/commits?author=LYS86)</span>          |                    <span style="word-break:keep-all;white-space:nowrap">`2023/06/03`</span>                    |

تم تحديث البيانات في 1 January 2025.

تم تصنيف سجلات البيانات بترتيب تنازلي حسب `أحدث الإرساليات`.

طلبات السحب الجديدة غير المعالجة بعد، سيتم إدراجها في الإحصاءات بعد الدمج.

بعض المساهمين قد لا يظهرون بشكل صحيح في [GitHub Contributors](https://github.com/SuperMonster003/AutoJs6/graphs/contributors)، سجلات إسهاماتهم قد تكون فارغة، لكن يمكن مراجعة سجلات الإسهامات عبر [Pull Request](https://github.com/SuperMonster003/AutoJs6/pulls).

[//]: # (
    # --------------------------------------------------------------#
    # Before committing and pushing to the remote GitHub repository #
    # --------------------------------------------------------------#
    - CHANGELOG.md
        - Update entries for AutoJs6 by checking all changed files
        - Update entries for Gradle plugins [ implementation ]
        - Update version name and released date
        - Append related GitHub issues to changelog entries
    - README.md
        - The summary of the latest changelog for committing to Git [ DO NOT commit or push ]
        - Update badges like [ android studio / rhino / ... ]
        - Update android studio download links and version names
        - Update contribution section
    - Remove the part like [ alpha / beta / ... ] of VERSION_NAME in version.properties
    - Update dependencies TypeScript declarations if needed.
    - Re-generate documentation/markdown by running the python script
    - Check the two-way versions for AutoJs6 and VSCode ext, then publish the ext to Microsoft
    - Run Gradle task "app:assembleInrtRelease"
    - Build APK to determine the final VERSION_BUILD field
    - Run Gradle task "app:appendDigestToReleasedFiles"
    - Check VERSION_BUILD in version.properties with released apks
    - Commit and push to GitHub
    - Publish the latest release with signed APKs
)