/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.regex.Pattern;
import jdk.dynalink.CallSiteDescriptor;
import jdk.dynalink.DynamicLinker;
import jdk.dynalink.DynamicLinkerFactory;
import jdk.dynalink.Operation;
import jdk.dynalink.StandardNamespace;
import jdk.dynalink.StandardOperation;
import jdk.dynalink.linker.support.CompositeTypeBasedGuardingDynamicLinker;
import jdk.dynalink.support.ChainedCallSite;
import org.mozilla.classfile.ClassFileWriter;
import org.mozilla.javascript.optimizer.BaseFunctionLinker;
import org.mozilla.javascript.optimizer.BooleanLinker;
import org.mozilla.javascript.optimizer.ConsStringLinker;
import org.mozilla.javascript.optimizer.ConstAwareLinker;
import org.mozilla.javascript.optimizer.DefaultLinker;
import org.mozilla.javascript.optimizer.DoubleLinker;
import org.mozilla.javascript.optimizer.IntegerLinker;
import org.mozilla.javascript.optimizer.NativeArrayLinker;
import org.mozilla.javascript.optimizer.RhinoNamespace;
import org.mozilla.javascript.optimizer.RhinoOperation;
import org.mozilla.javascript.optimizer.StringLinker;

public class Bootstrapper {
    private static final Pattern SEPARATOR = Pattern.compile(":");
    public static final ClassFileWriter.MHandle BOOTSTRAP_HANDLE = new ClassFileWriter.MHandle(6, "org.mozilla.javascript.optimizer.Bootstrapper", "bootstrap", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;");
    private static final DynamicLinker linker;

    public static CallSite bootstrap(MethodHandles.Lookup lookup, String name, MethodType mType) throws NoSuchMethodException {
        Operation op = Bootstrapper.parseOperation(name);
        return linker.link(new ChainedCallSite(new CallSiteDescriptor(lookup, op, mType)));
    }

    private static Operation parseOperation(String name) throws NoSuchMethodException {
        String[] tokens = SEPARATOR.split(name, -1);
        String namespaceName = Bootstrapper.getNameSegment(tokens, name, 0);
        String opName = Bootstrapper.getNameSegment(tokens, name, 1);
        if ("PROP".equals(namespaceName)) {
            switch (opName) {
                case "GET": {
                    return StandardOperation.GET.withNamespace(StandardNamespace.PROPERTY).named(Bootstrapper.getNameSegment(tokens, name, 2));
                }
                case "GETNOWARN": {
                    return RhinoOperation.GETNOWARN.withNamespace(StandardNamespace.PROPERTY).named(Bootstrapper.getNameSegment(tokens, name, 2));
                }
                case "GETSUPER": {
                    return RhinoOperation.GETSUPER.withNamespace(StandardNamespace.PROPERTY).named(Bootstrapper.getNameSegment(tokens, name, 2));
                }
                case "GETWITHTHIS": {
                    return RhinoOperation.GETWITHTHIS.withNamespace(StandardNamespace.PROPERTY).named(Bootstrapper.getNameSegment(tokens, name, 2));
                }
                case "GETWITHTHISOPTIONAL": {
                    return RhinoOperation.GETWITHTHISOPTIONAL.withNamespace(StandardNamespace.PROPERTY).named(Bootstrapper.getNameSegment(tokens, name, 2));
                }
                case "GETELEMENT": {
                    return RhinoOperation.GETELEMENT.withNamespace(StandardNamespace.PROPERTY);
                }
                case "GETELEMENTSUPER": {
                    return RhinoOperation.GETELEMENTSUPER.withNamespace(StandardNamespace.PROPERTY);
                }
                case "GETINDEX": {
                    return RhinoOperation.GETINDEX.withNamespace(StandardNamespace.PROPERTY);
                }
                case "SET": {
                    return StandardOperation.SET.withNamespace(StandardNamespace.PROPERTY).named(Bootstrapper.getNameSegment(tokens, name, 2));
                }
                case "SETSUPER": {
                    return RhinoOperation.SETSUPER.withNamespace(StandardNamespace.PROPERTY).named(Bootstrapper.getNameSegment(tokens, name, 2));
                }
                case "SETELEMENT": {
                    return RhinoOperation.SETELEMENT.withNamespace(StandardNamespace.PROPERTY);
                }
                case "SETELEMENTSUPER": {
                    return RhinoOperation.SETELEMENTSUPER.withNamespace(StandardNamespace.PROPERTY);
                }
                case "SETINDEX": {
                    return RhinoOperation.SETINDEX.withNamespace(StandardNamespace.PROPERTY);
                }
            }
        } else if ("NAME".equals(namespaceName)) {
            switch (opName) {
                case "BIND": {
                    return RhinoOperation.BIND.withNamespace(RhinoNamespace.NAME).named(Bootstrapper.getNameSegment(tokens, name, 2));
                }
                case "GET": {
                    return StandardOperation.GET.withNamespace(RhinoNamespace.NAME).named(Bootstrapper.getNameSegment(tokens, name, 2));
                }
                case "GETWITHTHIS": {
                    return RhinoOperation.GETWITHTHIS.withNamespace(RhinoNamespace.NAME).named(Bootstrapper.getNameSegment(tokens, name, 2));
                }
                case "GETWITHTHISOPTIONAL": {
                    return RhinoOperation.GETWITHTHISOPTIONAL.withNamespace(RhinoNamespace.NAME).named(Bootstrapper.getNameSegment(tokens, name, 2));
                }
                case "SET": {
                    return StandardOperation.SET.withNamespace(RhinoNamespace.NAME).named(Bootstrapper.getNameSegment(tokens, name, 2));
                }
                case "SETSTRICT": {
                    return RhinoOperation.SETSTRICT.withNamespace(RhinoNamespace.NAME).named(Bootstrapper.getNameSegment(tokens, name, 2));
                }
                case "SETCONST": {
                    return RhinoOperation.SETCONST.withNamespace(RhinoNamespace.NAME).named(Bootstrapper.getNameSegment(tokens, name, 2));
                }
            }
        } else if ("MATH".equals(namespaceName)) {
            switch (opName) {
                case "ADD": {
                    return RhinoOperation.ADD.withNamespace(RhinoNamespace.MATH);
                }
                case "TOBOOLEAN": {
                    return RhinoOperation.TOBOOLEAN.withNamespace(RhinoNamespace.MATH);
                }
                case "TOINT32": {
                    return RhinoOperation.TOINT32.withNamespace(RhinoNamespace.MATH);
                }
                case "TOUINT32": {
                    return RhinoOperation.TOUINT32.withNamespace(RhinoNamespace.MATH);
                }
                case "EQ": {
                    return RhinoOperation.EQ.withNamespace(RhinoNamespace.MATH);
                }
                case "SHALLOWEQ": {
                    return RhinoOperation.SHALLOWEQ.withNamespace(RhinoNamespace.MATH);
                }
                case "TONUMBER": {
                    return RhinoOperation.TONUMBER.withNamespace(RhinoNamespace.MATH);
                }
                case "TONUMERIC": {
                    return RhinoOperation.TONUMERIC.withNamespace(RhinoNamespace.MATH);
                }
                case "COMPAREGT": {
                    return RhinoOperation.COMPARE_GT.withNamespace(RhinoNamespace.MATH);
                }
                case "COMPARELT": {
                    return RhinoOperation.COMPARE_LT.withNamespace(RhinoNamespace.MATH);
                }
                case "COMPAREGE": {
                    return RhinoOperation.COMPARE_GE.withNamespace(RhinoNamespace.MATH);
                }
                case "COMPARELE": {
                    return RhinoOperation.COMPARE_LE.withNamespace(RhinoNamespace.MATH);
                }
            }
        }
        throw new NoSuchMethodException(name);
    }

    private static String getNameSegment(String[] segments, String name, int pos) {
        if (pos >= segments.length) {
            return "";
        }
        return segments[pos].intern();
    }

    static {
        DynamicLinkerFactory factory = new DynamicLinkerFactory();
        CompositeTypeBasedGuardingDynamicLinker typeLinker = new CompositeTypeBasedGuardingDynamicLinker(Arrays.asList(new ConstAwareLinker(), new BooleanLinker(), new IntegerLinker(), new DoubleLinker(), new StringLinker(), new ConsStringLinker(), new NativeArrayLinker(), new BaseFunctionLinker()));
        factory.setPrioritizedLinkers(typeLinker, new DefaultLinker());
        linker = factory.createLinker();
    }
}

