/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Slot;

public class BuiltInSlot<T extends ScriptableObject>
extends Slot {
    private final Getter<T> getter;
    private final Setter<T> setter;
    private final AttributeSetter<T> attrUpdater;
    private final PropDescriptionSetter<T> propDescSetter;

    BuiltInSlot(Object name, int index, int attr, T builtIn, Getter<T> getter, Setter<T> setter, AttributeSetter<T> attrUpdater) {
        this(name, index, attr, (ScriptableObject)builtIn, (Getter<ScriptableObject>)getter, (Setter<ScriptableObject>)setter, (AttributeSetter<ScriptableObject>)attrUpdater, BuiltInSlot::defaultPropDescSetter);
    }

    BuiltInSlot(Object name, int index, int attr, T builtIn, Getter<T> getter, Setter<T> setter, AttributeSetter<T> attrUpdater, PropDescriptionSetter<T> propDescSetter) {
        super(name, index, attr);
        this.value = builtIn;
        this.getter = getter;
        this.setter = setter;
        this.attrUpdater = attrUpdater;
        this.propDescSetter = propDescSetter;
    }

    BuiltInSlot(BuiltInSlot<T> slot) {
        super(slot);
        this.getter = slot.getter;
        this.setter = slot.setter;
        this.attrUpdater = slot.attrUpdater;
        this.propDescSetter = slot.propDescSetter;
    }

    @Override
    Slot copySlot() {
        BuiltInSlot<T> res = new BuiltInSlot<T>(this);
        res.next = null;
        res.orderedNext = null;
        return res;
    }

    @Override
    public Object getValue(Scriptable start) {
        return this.getter.apply((ScriptableObject)this.value, start);
    }

    @Override
    public boolean setValue(Object value, Scriptable owner, Scriptable start, boolean isThrow) {
        return this.setter.apply((ScriptableObject)this.value, value, owner, start, isThrow);
    }

    @Override
    void setAttributes(int value) {
        this.attrUpdater.apply((ScriptableObject)this.value, value);
        super.setAttributes(value);
    }

    @Override
    ScriptableObject getPropertyDescriptor(Context cx, Scriptable scope) {
        return ScriptableObject.buildDataDescriptor(scope, this.getValue((ScriptableObject)this.value), this.getAttributes());
    }

    boolean applyNewDescriptor(Object id, ScriptableObject desc, boolean checkValid, Object key, int index) {
        return this.propDescSetter.apply((ScriptableObject)this.value, this, id, desc, checkValid, key, index);
    }

    private static <T extends ScriptableObject> boolean defaultPropDescSetter(T builtIn, BuiltInSlot<T> current, Object id, ScriptableObject desc, boolean checkValid, Object key, int index) {
        return ScriptableObject.defineOrdinaryProperty(builtIn, id, desc, checkValid, key, index);
    }

    public static interface PropDescriptionSetter<U extends ScriptableObject>
    extends Serializable {
        public boolean apply(U var1, BuiltInSlot<U> var2, Object var3, ScriptableObject var4, boolean var5, Object var6, int var7);
    }

    public static interface Getter<U extends ScriptableObject>
    extends Serializable {
        public Object apply(U var1, Scriptable var2);
    }

    public static interface Setter<U extends ScriptableObject>
    extends Serializable {
        public boolean apply(U var1, Object var2, Scriptable var3, Scriptable var4, boolean var5);
    }

    public static interface AttributeSetter<U extends ScriptableObject>
    extends Serializable {
        public void apply(U var1, int var2);
    }
}

