/*
 * Decompiled with CFR 0.152.
 */
package eu.medsea.mimeutil.detector;

import eu.medsea.mimeutil.MimeException;
import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.MimeUtil;
import eu.medsea.mimeutil.detector.InvalidMagicMimeEntryException;
import eu.medsea.mimeutil.detector.MagicMimeEntry;
import eu.medsea.mimeutil.detector.MimeDetector;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MagicMimeMimeDetector
extends MimeDetector {
    private static Logger log = LoggerFactory.getLogger((Class)MagicMimeMimeDetector.class);
    protected static String[] defaultLocations = new String[]{"/usr/share/mimelnk/magic", "/usr/share/file/magic.mime", "/etc/magic.mime"};
    private static List magicMimeFileLocations = Arrays.asList(defaultLocations);
    private static ArrayList mMagicMimeEntries = new ArrayList();

    public MagicMimeMimeDetector() {
        MagicMimeMimeDetector.initMagicRules();
    }

    public String getDescription() {
        return "Get the mime types of files or streams using the Unix file(5) magic.mime files";
    }

    public Collection getMimeTypesByteArray(byte[] data) throws UnsupportedOperationException {
        LinkedHashSet<MimeType> mimeTypes = new LinkedHashSet<MimeType>();
        int len = mMagicMimeEntries.size();
        try {
            for (int i = 0; i < len; ++i) {
                MagicMimeEntry me = (MagicMimeEntry)mMagicMimeEntries.get(i);
                MagicMimeEntry matchingMagicMimeEntry = me.getMatch(data);
                if (matchingMagicMimeEntry == null) continue;
                mimeTypes.add(matchingMagicMimeEntry.getMimeType());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return mimeTypes;
    }

    public Collection getMimeTypesInputStream(InputStream in) throws UnsupportedOperationException {
        LinkedHashSet<MimeType> mimeTypes = new LinkedHashSet<MimeType>();
        int len = mMagicMimeEntries.size();
        try {
            for (int i = 0; i < len; ++i) {
                MagicMimeEntry me = (MagicMimeEntry)mMagicMimeEntries.get(i);
                MagicMimeEntry matchingMagicMimeEntry = me.getMatch(in);
                if (matchingMagicMimeEntry == null) continue;
                mimeTypes.add(matchingMagicMimeEntry.getMimeType());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return mimeTypes;
    }

    public Collection getMimeTypesFileName(String fileName) throws UnsupportedOperationException {
        return this.getMimeTypesFile(new File(fileName));
    }

    public Collection getMimeTypesURL(URL url) throws UnsupportedOperationException {
        Collection collection;
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(MimeUtil.getInputStreamForURL(url));
            collection = this.getMimeTypesInputStream(in);
        }
        catch (Exception e) {
            try {
                throw new MimeException(e);
            }
            catch (Throwable throwable) {
                MagicMimeMimeDetector.closeStream(in);
                throw throwable;
            }
        }
        MagicMimeMimeDetector.closeStream(in);
        return collection;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection getMimeTypesFile(File file) throws UnsupportedOperationException {
        Collection collection;
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            collection = this.getMimeTypesInputStream(in);
        }
        catch (FileNotFoundException e) {
            try {
                throw new UnsupportedOperationException(e.getLocalizedMessage());
                catch (Exception e2) {
                    throw new MimeException(e2);
                }
            }
            catch (Throwable throwable) {
                MagicMimeMimeDetector.closeStream(in);
                throw throwable;
            }
        }
        MagicMimeMimeDetector.closeStream(in);
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initMagicRules() {
        InputStream in;
        block38: {
            in = null;
            try {
                String fname = System.getProperty("magic-mime");
                if (fname == null || fname.length() == 0 || (in = new FileInputStream(fname)) == null) break block38;
                MagicMimeMimeDetector.parse("-Dmagic-mime=" + fname, new InputStreamReader(in));
            }
            catch (Exception e) {
                try {
                    log.error("Failed to parse custom magic mime file defined by system property -Dmagic-mime [" + System.getProperty("magic-mime") + "]. File will be ignored.", (Throwable)e);
                }
                catch (Throwable throwable) {
                    in = MagicMimeMimeDetector.closeStream(in);
                    throw throwable;
                }
                in = MagicMimeMimeDetector.closeStream(in);
            }
        }
        in = MagicMimeMimeDetector.closeStream(in);
        try {
            Enumeration<URL> en = MimeUtil.class.getClassLoader().getResources("magic.mime");
            while (en.hasMoreElements()) {
                URL url = en.nextElement();
                in = url.openStream();
                if (in == null) continue;
                try {
                    MagicMimeMimeDetector.parse("classpath:[" + url + "]", new InputStreamReader(in));
                }
                catch (Exception ex) {
                    log.error("Failed to parse magic.mime rule file [" + url + "] on the classpath. File will be ignored.", (Throwable)ex);
                }
            }
        }
        catch (Exception e) {
            log.error("Problem while processing magic.mime files from classpath. Files will be ignored.", (Throwable)e);
        }
        finally {
            in = MagicMimeMimeDetector.closeStream(in);
        }
        try {
            File f = new File(System.getProperty("user.home") + File.separator + ".magic.mime");
            if (f.exists() && (in = new FileInputStream(f)) != null) {
                try {
                    MagicMimeMimeDetector.parse(f.getAbsolutePath(), new InputStreamReader(in));
                }
                catch (Exception ex) {
                    log.error("Failed to parse .magic.mime file from the users home directory. File will be ignored.", (Throwable)ex);
                }
            }
        }
        catch (Exception e) {
            log.error("Problem while processing .magic.mime file from the users home directory. File will be ignored.", (Throwable)e);
        }
        finally {
            in = MagicMimeMimeDetector.closeStream(in);
        }
        try {
            File f;
            String name = System.getProperty("MAGIC");
            if (name != null && name.length() != 0 && (f = new File(name = name.indexOf(46) < 0 ? name + ".mime" : name.substring(0, name.indexOf(46) - 1) + "mime")).exists() && (in = new FileInputStream(f)) != null) {
                try {
                    MagicMimeMimeDetector.parse(f.getAbsolutePath(), new InputStreamReader(in));
                }
                catch (Exception ex) {
                    log.error("Failed to parse magic.mime file from directory located by environment variable MAGIC. File will be ignored.", (Throwable)ex);
                }
            }
        }
        catch (Exception e) {
            log.error("Problem while processing magic.mime file from directory located by environment variable MAGIC. File will be ignored.", (Throwable)e);
        }
        finally {
            in = MagicMimeMimeDetector.closeStream(in);
        }
        int mMagicMimeEntriesSizeBeforeReadingOS = mMagicMimeEntries.size();
        Iterator it = magicMimeFileLocations.iterator();
        while (it.hasNext()) {
            MagicMimeMimeDetector.parseMagicMimeFileLocation((String)it.next());
        }
        if (mMagicMimeEntriesSizeBeforeReadingOS == mMagicMimeEntries.size()) {
            try {
                String resource = "eu/medsea/mimeutil/magic.mime";
                in = MimeUtil.class.getClassLoader().getResourceAsStream(resource);
                if (in != null) {
                    try {
                        MagicMimeMimeDetector.parse("resource:" + resource, new InputStreamReader(in));
                    }
                    catch (Exception ex) {
                        log.error("Failed to parse internal magic.mime file.", (Throwable)ex);
                    }
                }
            }
            catch (Exception e) {
                log.error("Problem while processing internal magic.mime file.", (Throwable)e);
            }
            finally {
                in = MagicMimeMimeDetector.closeStream(in);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseMagicMimeFileLocation(String location) {
        InputStream is = null;
        List magicMimeFiles = MagicMimeMimeDetector.getMagicFilesFromMagicMimeFileLocation(location);
        Iterator itFile = magicMimeFiles.iterator();
        while (itFile.hasNext()) {
            block7: {
                File f = (File)itFile.next();
                try {
                    if (!f.exists()) break block7;
                    is = new FileInputStream(f);
                    try {
                        MagicMimeMimeDetector.parse(f.getAbsolutePath(), new InputStreamReader(is));
                    }
                    catch (Exception e) {
                        log.error("Failed to parse " + f.getName() + ". File will be ignored.");
                    }
                }
                catch (Exception e) {
                    try {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        is = MagicMimeMimeDetector.closeStream(is);
                        throw throwable;
                    }
                    is = MagicMimeMimeDetector.closeStream(is);
                    continue;
                }
            }
            is = MagicMimeMimeDetector.closeStream(is);
        }
    }

    private static List getMagicFilesFromMagicMimeFileLocation(String magicMimeFileLocation) {
        LinkedList<File> magicMimeFiles = new LinkedList<File>();
        if (magicMimeFileLocation.indexOf(42) < 0) {
            magicMimeFiles.add(new File(magicMimeFileLocation));
        } else {
            String fileNameSimplePattern;
            File dir;
            int lastSlashPos = magicMimeFileLocation.lastIndexOf(47);
            if (lastSlashPos < 0) {
                dir = new File("someProbablyNotExistingFile").getAbsoluteFile().getParentFile();
                fileNameSimplePattern = magicMimeFileLocation;
            } else {
                String dirName = magicMimeFileLocation.substring(0, lastSlashPos);
                if (dirName.indexOf(42) >= 0) {
                    throw new UnsupportedOperationException("The wildcard '*' is not allowed in directory part of the location! Do you want to implement expressions like /path/**/*.mime for recursive search? Please do!");
                }
                dir = new File(dirName);
                fileNameSimplePattern = magicMimeFileLocation.substring(lastSlashPos + 1);
            }
            if (!dir.isDirectory()) {
                return Collections.EMPTY_LIST;
            }
            String s = fileNameSimplePattern.replaceAll("\\.", "\\\\.");
            s = s.replaceAll("\\*", ".*");
            Pattern fileNamePattern = Pattern.compile(s);
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (!fileNamePattern.matcher(file.getName()).matches()) continue;
                magicMimeFiles.add(file);
            }
        }
        return magicMimeFiles;
    }

    private static void parse(String magicFile, Reader r) throws IOException {
        long start = System.currentTimeMillis();
        BufferedReader br = new BufferedReader(r);
        ArrayList<String> sequence = new ArrayList<String>();
        long lineNumber = 0L;
        String line = br.readLine();
        if (line != null) {
            ++lineNumber;
        }
        block0: while (line != null) {
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
                line = br.readLine();
                if (line == null) continue;
                ++lineNumber;
                continue;
            }
            sequence.add(line);
            while (true) {
                if ((line = br.readLine()) != null) {
                    ++lineNumber;
                }
                if (line == null) {
                    MagicMimeMimeDetector.addEntry(magicFile, lineNumber, sequence);
                    sequence.clear();
                    continue block0;
                }
                if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                if (line.charAt(0) != '>') {
                    MagicMimeMimeDetector.addEntry(magicFile, lineNumber, sequence);
                    sequence.clear();
                    continue block0;
                }
                sequence.add(line);
            }
        }
        if (!sequence.isEmpty()) {
            MagicMimeMimeDetector.addEntry(magicFile, lineNumber, sequence);
        }
        if (log.isDebugEnabled()) {
            log.debug("Parsing \"" + magicFile + "\" took " + (System.currentTimeMillis() - start) + " msec.");
        }
    }

    private static void addEntry(String magicFile, long lineNumber, ArrayList aStringArray) {
        try {
            MagicMimeEntry magicEntry = new MagicMimeEntry(aStringArray);
            mMagicMimeEntries.add(magicEntry);
            if (magicEntry.getMimeType() != null) {
                MimeUtil.addKnownMimeType(magicEntry.getMimeType());
            }
        }
        catch (InvalidMagicMimeEntryException e) {
            log.warn(e.getClass().getName() + ": " + e.getMessage() + ": file \"" + magicFile + "\": before or at line " + lineNumber, (Throwable)e);
        }
    }
}

