## カラー検索

カラー検索では, 以下の 5 種類の検索方法をサポートしています. いずれも大文字小文字を区別しません.

### 1. カラー名 (現在の言語)

現在の言語で表示されるカラー名をキーワードとして検索します.

#### 例 1.1: レッド

"レッド" という文字列を含むすべてのカラー名にマッチします. たとえば "レッド", "オレンジレッド", "インディアンレッド", "レッド (200)" など.

#### 例 1.2: ブルー50

"ブルー50" という文字列を含むすべてのカラー名にマッチします. 検索時には, スペースや括弧, スラッシュ, ハイフンなどの英数字以外の文字は無視されます. そのため "ブルー50" は "ブルー (50)", "ブルー (500)" などにマッチしますが, "ブルーグレー (50)" にはマッチしません. "グレー" が無視できないからです.

### 2. カラー名 (英語)

"$" で始めると, 英語のカラーネーム検索モードが有効になります.

#### 例 2.1: $red

"red" を含むすべての英語カラー名がマッチします. たとえば "レッド", "オレンジレッド", "インディアンレッド" など. 表示言語が英語でなくても, 英語のキーワードで該当するカラーを検索できます.

#### 例 2.2: $blue50

例 1.2 と同様に, "ブルー (50)", "ブルー (500)", "水色 (50)" などにマッチします.

### 3. HEX

先頭を "#" とすることで, HEX 検索モードを有効にします.

#### 例 3.1: #FF007F

HEX が "#FF007F" であるカラーにマッチします. 例: "ローズ" .

#### 例 3.2: #FF

HEX が "#FF" から始まるカラーすべてにマッチします. 例: "#FF8099", "#FF00CB", "#FFFAFA" など.

### 4. 正規表現

先頭を "/" , 末尾を "/" とすることで, JavaScript に類似した正規表現検索モードを有効にします.

#### 例 4.1: /レッド|オレンジ|イエロー/

"レッド", "オレンジ", "イエロー" を含むすべてのカラー名にマッチします.

#### 例 4.2: /\b50\b/

単語境界に囲まれた "50" を含むすべてのカラー名にマッチします. 例: "レッド (50)", "ピンク (50)", "イエロー (50)" など. ただし "レッド (500)", "ピンク (500)" などは含まれません.

#### 例 4.3: /red|orange/

例 2.2 と同様に, 正規表現でも英語のカラー名がマッチします. /red|orange/ は "ストロングレッド", "バーントオレンジ", "ペールバイオレットレッド" などにマッチします.

### 5. HEX の正規表現

先頭を "#/" , 末尾を "/" とすることで, HEX に対する正規表現検索モードを有効にします.

#### 例 5.1: #/FF\b/

単語境界として終わる "FF" を含むすべての HEX にマッチします (形式: "#xxxxFF"). 例: "#2962FF", "#D94DFF", "#F0F8FF" など.

#### 例 5.2: #/#FF/

"#FF" を含むすべての HEX にマッチします. 例 3.2 と同じく, "#FFxxxx" の形式です.

#### 例 5.3: #/#..FF/

中間に "FF" を含むすべての HEX にマッチします (形式: "#xxFFxx"). 例: "#CCFF00", "#66FFE6", "#00FF7F" など.

#### 例 5.4: #/#((?<!0).){2}0000/

赤成分のみを含む HEX にマッチします (形式: "#xx0000"). 黒色は除外. 例: "#8B0000", "#D50000", "#FF0000" など.

#### 例 5.5: #/#0000(.(?!0)){2}/

青成分のみを含む HEX にマッチします (形式: "#0000xx"). 黒色は除外. 例: "#00008B", "#0000CD", "#0000FF" など.

#### 例 5.6: #/#00((?!0).)(.(?<!0))00/

緑成分のみを含む HEX にマッチします (形式: "#00xx00"). 黒色は除外. 例: "#006400", "#00FF00" など. 