<!--suppress HtmlDeprecatedAttribute, HttpUrlsUsage -->

<div align="center">
  <p>
    <img src="https://s1.imagehub.cc/images/2023/03/07/af8ed087c9d354b9ab6142aae7bbafb6.png" alt="autojs6-banner_800×224" border="0" width="704" />
  </p>

  <p>Android 平台支持無障礙服務的 JavaScript 自動化工具</p>

  <p>
    <a href="http://download.autojs6.com"><img alt="GitHub release (latest by date)" src="https://img.shields.io/github/v/release/SuperMonster003/AutoJs6"/></a>
    <a href="http://issues.autojs6.com"><img alt="GitHub closed issues" src="https://img.shields.io/github/issues/SuperMonster003/AutoJs6?color=A24232"/></a>
    <a href="http://commit.autojs6.com/99a1d8490fac5b6d55f6f183db59ad833a2064ed"><img alt="Created" src="https://img.shields.io/date/1636632233?color=2e7d32&label=created"/></a>
    <br>
    <a href="https://github.com/mozilla/rhino"><img alt="Rhino" src="https://img.shields.io/badge/rhino-1.8.1--SNAPSHOT-795548"/></a>
    <a href="https://developer.android.com/studio/archive"><img alt="Android Studio" src="https://img.shields.io/badge/android%20studio-2022.1+-B64FC8"/></a>
    <br>
    <a href="https://www.codefactor.io/repository/github/SuperMonster003/AutoJs6"><img alt="CodeFactor Grade" src="https://www.codefactor.io/repository/github/SuperMonster003/AutoJs6/badge"/></a>
    <a href="https://www.jetbrains.com/?from=AutoJs6"><img alt="JetBrains supporter" src="https://img.shields.io/badge/supporter-JetBrains-ee4677"/></a>
    <a href="http://project.autojs6.com/blob/master/LICENSE"><img alt="GitHub License" src="https://img.shields.io/github/license/SuperMonster003/AutoJs6?color=534BAE"/></a>
  </p>
</div>

******

### 語言 (Languages)

******

當前自述文件 `README.md` 支持以下語言:

 - [简体中文 [zh-Hans]](http://project.autojs6.com/blob/master/.readme/README-zh-Hans.md)
 - 繁體中文 (香港) [zh-Hant-HK] # 當前
 - [繁體中文 (台灣) [zh-Hant-TW]](http://project.autojs6.com/blob/master/.readme/README-zh-Hant-TW.md)
 - [English [en]](http://project.autojs6.com/blob/master/.readme/README-en.md)
 - [Français [fr]](http://project.autojs6.com/blob/master/.readme/README-fr.md)
 - [Español [es]](http://project.autojs6.com/blob/master/.readme/README-es.md)
 - [日本語 [ja]](http://project.autojs6.com/blob/master/.readme/README-ja.md)
 - [한국어 [ko]](http://project.autojs6.com/blob/master/.readme/README-ko.md)
 - [Русский [ru]](http://project.autojs6.com/blob/master/.readme/README-ru.md)
 - [العربية [ar]](http://project.autojs6.com/blob/master/.readme/README-ar.md)

******

### 簡介

******

[Auto.js](https://github.com/hyb1996/Auto.js) 是一款 Android 平台支持 [無障礙服務](https://developer.android.com/guide/topics/ui/accessibility/service?hl=zh-cn) 的 JavaScript 自動化工具軟件.

Auto.js 由 [hyb1996](https://github.com/hyb1996) 於 `2017/01/27` 初次發佈, 於 `2020/03/13` 停止維護, 最終版本名稱為 `4.1.1 Alpha2`, 構建版本號為 `461`.

AutoJs6 在 Auto.js 最終項目的基礎上, 於 `2021/12/01` 進行二次開發, 繼續保持開源免費.

下表列舉了部分 Auto.js 相關項目 (按開發日期排序):

| <span style="word-break:keep-all;white-space:nowrap">項目</span> |                                                             <span style="word-break:keep-all;white-space:nowrap">應用名稱</span>                                                              | <span style="word-break:keep-all;white-space:nowrap">開發者</span> | <span style="word-break:keep-all;white-space:nowrap">開發日期</span> | <span style="word-break:keep-all;white-space:nowrap">終止開發日期</span> |
|:------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------:|:---------------------------------------------------------------------------------------------------------------------------------:|:-------------------------------------------------------------------------------------------------------------------------------:|
|     <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/hyb1996/Auto.js)</span>      |    <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/TonyJiangWJ/Auto.js/commit/268ec8895bbfa28fc7715154eb15b1c1eaaefd14#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span>     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2017/01/27`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2020/03/13`</span>                             |
|                     <span style="word-break:keep-all;white-space:nowrap">Auto.js Pro 7</span>                      |                                                                                     <span style="word-break:keep-all;white-space:nowrap">Auto.js</span>                                                                                      |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2019/03/13`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2019/07/08`</span>                             |
|                     <span style="word-break:keep-all;white-space:nowrap">Auto.js Pro 8</span>                      |                                                                                    <span style="word-break:keep-all;white-space:nowrap">AutoJsPro</span>                                                                                     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2019/10/13`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2021/07/24`</span>                             |
|   <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/TonyJiangWJ/Auto.js)</span>    | <span style="word-break:keep-all;white-space:nowrap">[Auto.js&#160;M](https://github.com/TonyJiangWJ/Auto.js/commit/268ec8895bbfa28fc7715154eb15b1c1eaaefd14#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span> |      <span style="word-break:keep-all;white-space:nowrap">[TonyJiangWJ](https://github.com/TonyJiangWJ)</span>       |                             <span style="word-break:keep-all;white-space:nowrap">`2019/11/21`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|      <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/kkevsekk1/AutoX)</span>       |                 <span style="white-space:pre">[Autox.js](https://github.com/kkevsekk1/AutoX/commit/8143e4ed893d4af05d22aa791b83a962f9959873#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span>                  |        <span style="word-break:keep-all;white-space:nowrap">[kkevsekk1](https://github.com/kkevsekk1)</span>         |                             <span style="word-break:keep-all;white-space:nowrap">`2020/07/24`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|        <span style="word-break:keep-all;white-space:nowrap">[Auto.js Pro 9](https://pro.autojs.org/)</span>        |                                                                                    <span style="word-break:keep-all;white-space:nowrap">AutoJsPro</span>                                                                                     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2021/03/28`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2023/02/09`</span>                             |
| <span style="word-break:keep-all;white-space:nowrap">[AutoJs6](https://github.com/SuperMonster003/AutoJs6)</span>  |  <span style="word-break:keep-all;white-space:nowrap">[AutoJs6](https://github.com/SuperMonster003/AutoJs6/commit/a8ce1b9acb541e9736c33134be3194c3148a15a3#diff-833a46a97033e77558372a2dce103fd6fee29aaaa899f610022a7aece592ee7bR27)</span>  |  <span style="word-break:keep-all;white-space:nowrap">[SuperMonster003](https://github.com/SuperMonster003)</span>   |                             <span style="word-break:keep-all;white-space:nowrap">`2021/12/01`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|      <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/kkevsekk1/AutoX)</span>       |            <span style="white-space:pre">[Autox.js&#160;v6](https://github.com/kkevsekk1/AutoX/commit/8b6776cff8b0fca4be4a52719b7d7d07c0a058f3#diff-51a0b488f963eb0be6c6599bf5df497313877cf5bdff3950807373912ac1cdc9R130)</span>             |           <span style="word-break:keep-all;white-space:nowrap">[wilinz](https://github.com/wilinz)</span>            |                             <span style="word-break:keep-all;white-space:nowrap">`2022/05/26`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|        <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/aiselp/AutoX)</span>        |              <span style="white-space:pre">[Autox.js&#160;v7](https://github.com/aiselp/AutoX/commit/484491fd5fe12b8203d0b09c181eb0f471c0ea9f#diff-8cff73265af19c059547b76aca8882cbaa3209291406f52df1dafbbc78e80c46R120)</span>              |           <span style="word-break:keep-all;white-space:nowrap">[aiselp](https://github.com/aiselp)</span>            |                             <span style="word-break:keep-all;white-space:nowrap">`2024/04/21`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |

表格中的日期為預估值, 與實際可能存在出入.

表格中 Auto.js Pro 7/8/9 為付費版本, 其餘為免費開源版本.

******

### 功能

******

* 可用作 JavaScript IDE (代碼補全/變量重命名/代碼格式化)
* 支持基於 [無障礙服務](https://developer.android.com/reference/android/accessibilityservice/AccessibilityService) 的自動化操作
* 支持浮動按鈕快捷操作 (腳本錄製及運行/查看包名及活動/佈局分析)
* 支持選擇器 API 並提供控件遍歷/獲取信息/控件操作 (類似 [UiAutomator](https://developer.android.com/training/testing/ui-automator))
* 支持佈局界面分析 (類似 Android Studio 的 LayoutInspector)
* 支持錄製功能及錄製回放
* 支持屏幕截圖/保存截圖/圖片找色/圖片匹配
* 支持 [E4X](https://zh.wikipedia.org/wiki/E4X) (ECMAScript for XML) 編寫界面
* 支持將腳本文件或項目打包為 APK 文件
* 支持利用 Root 權限擴展功能 (屏幕點擊/滑動/錄製/Shell)
* 支持作為 Tasker 插件使用
* 支持與 VSCode 連接並進行桌面開發 (需要 [AutoJs6-VSCode-Extension](http://vscext-project.autojs6.com) 插件)

******

### 環境

******

- Android 操作系統
- [API](https://developer.android.com/guide/topics/manifest/uses-sdk-element#ApiLevels) [24](https://developer.android.com/reference/android/os/Build.VERSION_CODES#N) ([7.0](https://zh.wikipedia.org/wiki/Android_Nougat)) [[N](https://developer.android.com/reference/android/os/Build.VERSION_CODES#N)] 及以上

******

### 指南

******

* [應用文檔](https://docs.autojs6.com)
* [使用手冊 (待編寫)](https://docs.autojs6.com/#/manual)
* [疑難解答](https://docs.autojs6.com/#/qa)
* [項目編譯構建](#project-compilation-and-build)
* [腳本開發輔助](#script-development-assistance)

******

### 主要變更

******

相較於 Auto.js 最終開源版本 `4.1.1 Alpha2`, AutoJs6 主要進行了以下升級或變更:

* 支持通過 [Shizuku](https://shizuku.rikka.app/introduction/) 獲得 ADB 特權並使用系統 API
* 支持構建 [WebSocket](https://docs.autojs6.com/#/webSocketType) 實例以完成基於 [WebSocket 協議](https://zh.wikipedia.org/wiki/WebSocket) 的網絡請求
* 新增模塊 [ [base64](https://docs.autojs6.com/#/base64) / [crypto](https://docs.autojs6.com/#/crypto) / [sqlite](https://docs.autojs6.com/#/sqlite) / [i18n](https://docs.autojs6.com/#/i18n) / [notice](https://docs.autojs6.com/#/notice) / [ocr](https://docs.autojs6.com/#/ocr) / [opencc](https://docs.autojs6.com/#/opencc) / [qrcode](https://docs.autojs6.com/#/qrcode) / [shizuku](https://docs.autojs6.com/#/shizuku) / ... ]
* 多語言適配 [ 西 / 法 / 俄 / 阿 / 日 / 韓 / 英 / 簡中 / 繁中 / ... ]
* 主題色適配 [ 分組 / 定位 / 搜索 / 歷史記錄 / 亮度及對比度自動適配 / ... ]
* 夜間模式適配 [ 設置頁面 / 文檔頁面 / 佈局分析頁面 / 浮動窗口 / ... ]
* [VSCode 插件](http://vscext-project.autojs6.com) 支持客户端 (LAN) 及服務端 (LAN/ADB) 連接方式
* [Rhino](https://github.com/mozilla/rhino/) 引擎由 [v1.7.7.2](https://github.com/mozilla/rhino/releases/tag/Rhino1_7_7_2_Release) 升級至 [v1.8.1-SNAPSHOT](http://rhino.autojs6.com/blob/master/gradle.properties#L3)
    * Unicode [碼位](https://developer.mozilla.org/zh-CN/docs/Glossary/Code_point) 轉義支持 [輔助平面](https://zh.wikipedia.org/wiki/Unicode%E5%AD%97%E7%AC%A6%E5%B9%B3%E9%9D%A2%E6%98%A0%E5%B0%84#%E7%AC%AC%E4%B8%80%E8%BC%94%E5%8A%A9%E5%B9%B3%E9%9D%A2) 字符
       ```javascript
       '\u{1D160}'; /* 表示 "𝅘𝅥𝅮", 傳統方式: '\uD834\uDD60'. */
       ```
    * 支持 [Object.values()](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Global_Objects/Object/values)
       ```javascript
       Object.values({name: 'Max', age: 4}); // ['max', 4]
       ```
    * 支持 [Array.prototype.includes()](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Global_Objects/Array/includes)
       ```javascript
       [10, 20, NaN].includes(20); // true
       ```
    * 支持 [BigInt](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Global_Objects/BigInt)
       ```javascript
       typeof 567n === 'bigint'; // true
       ```
    * 支持 [模板字符串](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Template_literals)
       ```javascript
       `Lucky number: ${(Math.random() * 100).toFixed(0)}`
       ```
    * 查看 Rhino 引擎 [更多新特性](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/RHINO.md)
    * 查看 Rhino 引擎 [兼容性列表](https://mozilla.github.io/rhino/compat/engines.html)

******

### 版本歷史

******

# v6.6.2

###### 2025/04/16

* `新增` ui.statusBarAppearanceLight/statusBarAppearanceLightBy/navigationBarColor 等方法
* `新增` ui.statusBarHeight 屬性 (getter), 用於獲取狀態欄高度 _[`issue #357`](http://issues.autojs6.com/357)_
* `新增` images.flip 方法, 用於圖像翻轉 _[`issue #349`](http://issues.autojs6.com/349)_
* `新增` 設置頁面增加 "文件擴展名" 設置選項
* `新增` 主題色設置頁面增加新佈局支持 (分組/定位/搜索/歷史記錄/調色盤增強等)
* `修復` Android 15 狀態欄背景顏色與主題色不一致的問題
* `修復` plugins.load 方法無法正常加載插件的問題 _[`issue #290`](http://issues.autojs6.com/290)_
* `修復` dx 庫在 Android 7.x 無法正常使用的問題 _[`issue #293`](http://issues.autojs6.com/293)_
* `修復` ScriptRuntime 使用 require 引用內置模塊時可能出現的同步狀態異常 (試修) _[`issue #298`](http://issues.autojs6.com/298)_
* `修復` notice 模塊缺失 getBuilder 等擴展方法的問題 _[`issue #301`](http://issues.autojs6.com/301)_
* `修復` shizuku/shell 等方法無法接受字符串參數的問題 _[`issue #310`](http://issues.autojs6.com/310)_
* `修復` colors.pixel 方法無法接受單通道圖像參數的問題 _[`issue #350`](http://issues.autojs6.com/350)_
* `修復` engines.execScript/execScriptFile 等方法執行腳本時默認工作路徑異常 _[`issue #358`](http://issues.autojs6.com/358)_ _[`issue #340`](http://issues.autojs6.com/340)_ _[`issue #339`](http://issues.autojs6.com/339)_
* `修復` floaty.window/floaty.rawWindow 無法在子線程執行的問題
* `修復` floaty.getClip 可能無法正常獲取剪切板內容的問題 _[`issue #341`](http://issues.autojs6.com/341)_
* `修復` ui.inflate 返回值丟失 attr/on/click 等原型方法的問題
* `修復` 部分方法調用出現異常時無法被 try..catch 塊捕獲的問題 _[`issue #345`](http://issues.autojs6.com/345)_
* `修復` 佈局分析頁面生成代碼時可能導致應用崩潰的問題 _[`issue #288`](http://issues.autojs6.com/288)_
* `修復` 打包應用無法正常使用 shizuku 模塊的問題 _[`issue #227`](http://issues.autojs6.com/227)_ _[`issue #231`](http://issues.autojs6.com/231)_ _[`issue #284`](http://issues.autojs6.com/284)_ _[`issue #287`](http://issues.autojs6.com/287)_ _[`issue #304`](http://issues.autojs6.com/304)_
* `修復` 代碼編輯器跳轉到行尾時可能跳轉到下一行起始位置的問題
* `修復` 設置頁面連續快速點擊對話框類型項目時可能導致應用崩潰的問題
* `優化` 精簡打包應用模板 APK 文件大小
* `優化` 應用 (以及打包應用) 支持更多權限 _[`issue #338`](http://issues.autojs6.com/338)_
* `優化` 打包頁面支持 Pinyin 庫選項
* `優化` 打包應用主活動頁面優化狀態欄背景及文字顏色
* `優化` 打包應用設置頁面增加訪問所有文件和發送通知等特殊權限開關 _[`issue #354`](http://issues.autojs6.com/354)_
* `優化` 控件的文字及圖標根據主題色亮度值自動切換合適的顏色
* `優化` 部分控件主題色與背景色對比度過低時的視覺體驗
* `優化` 調色盤 HEX 輸入控件增強剪貼板粘貼色值時的兼容性
* `優化` 應用內頁面導航欄設置為透明或半透明以增強視覺體驗
* `優化` UI 模式狀態欄及導航欄默認為 `md_grey_50` 色值且設置為亮色模式
* `優化` 主頁抽屜無障礙服務開關支持與腳本代碼同步
* `優化` 主頁文檔頁面搜索時支持雙向查找按鈕
* `優化` 主頁 "文件" 標籤支持通過長按切換浮動按鈕可見狀態
* `優化` 代碼編輯器標題文字支持字體大小自適應
* `優化` 日誌頁面浮動按鈕可見狀態與列表滾動操作聯動
* `優化` 腳本項目配置文件 project.json 支持更多打包選項 _[`issue #305`](http://issues.autojs6.com/305)_ _[`issue #306`](http://issues.autojs6.com/306)_
* `優化` 腳本項目配置文件 project.json 支持選項名稱寬鬆匹配及別名兼容
* `優化` APK 文件類型信息對話框增加文件大小與簽名方案信息
* `優化` APK 文件類型信息對話框增加點擊監聽器支持文本複製與應用詳情跳轉
* `優化` 嘗試恢復 com.stardust 前綴包以便提升代碼兼容性 _[`issue #290`](http://issues.autojs6.com/290)_
* `優化` floaty.window/floaty.rawWindow 同時支持主線程和子線程執行
* `優化` getClip 全局方法適時藉助 floaty.getClip 方法以提升兼容性
* `優化` files.path 及相關方法傳入空值路徑參數時的兼容性
* `優化` 同步最新的 Rhino 引擎官方上游代碼並進行必要的代碼適配
* `優化` README.md 完善項目構建與運行相關內容 _[`issue #344`](http://issues.autojs6.com/344)_
* `優化` 部分依賴或本地庫版本調整 _[`CHANGELOG.md`](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG.md#v662)_

# v6.6.1

###### 2025/01/01

* `新增` pinyin 模塊, 用於漢語拼音轉換 (參閲 項目文檔 > [漢語拼音](https://docs.autojs6.com/#/pinyin))
* `新增` pinyin4j 模塊, 用於漢語拼音轉換 (參閲 項目文檔 > [漢語拼音](https://docs.autojs6.com/#/pinyin4j))
* `新增` UiObject#isSimilar 及 UiObjectCollection#isSimilar 方法, 用於確定控件或控件集合是否相似
* `新增` currentComponent 全局方法, 用於獲取當前活動的組件名稱信息
* `修復` 部分環境因回退版本過低而無法正常編譯項目的問題
* `修復` 調用不存在的方法時可能出現的 "非原始類型值" 異常
* `修復` 部分設備無法正常添加腳本快捷方式的問題 (試修) _[`issue #221`](http://issues.autojs6.com/221)_
* `修復` automator.click/longClick 方法參數類型限制錯誤 _[`issue #275`](http://issues.autojs6.com/275)_
* `修復` 選擇器不支持 ConsString 類型參數的問題 _[`issue #277`](http://issues.autojs6.com/277)_
* `修復` UiObjectCollection 實例缺失自身方法及屬性的問題
* `優化` 打包頁面支持簽名配置/密鑰庫管理/權限設置 (by [luckyloogn](https://github.com/luckyloogn)) _[`pr #286`](http://pr.autojs6.com/286)_
* `優化` 提升浮動窗口當前包名及當前活動名的識別準確性 (優先級: Shizuku > Root > A11Y)
* `優化` 提升 currentPackage/currentActivity 識別準確性 (優先級: Shizuku > Root > A11Y)
* `優化` 恢復日誌活動窗口單個條目文本內容的雙擊或長按選擇功能 _[`issue #280`](http://issues.autojs6.com/280)_
* `優化` 腳本項目識別在 project.json 損壞情況下儘可能還原關鍵信息
* `優化` 打包單文件時自動生成的包名後綴支持將簡體中文轉換為拼音 (支持多音字)
* `優化` UiSelector#findOnce 及 UiSelector#find 方法支持負數參數
* `優化` app.startActivity/startDualActivity 方法增強適配性
* `優化` UI 元素及 className 相關選擇器支持更多的包名前綴省略形式 (如 RecyclerView, Snackbar 等)
* `優化` 同步最新的 Rhino 引擎官方上游代碼並進行必要的代碼適配
* `優化` 部分依賴或本地庫版本調整 _[`CHANGELOG.md`](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG.md#v661)_

# v6.6.0

###### 2024/12/02 - 內置模塊重寫, 謹慎升級

* `提示` 內置模塊使用 Kotlin 重新編寫以提升腳本運行效率但可能需要多次迭代逐步完善
* `提示` 內置 init.js 文件默認為空但支持開發者自行擴展內置模塊或掛載外部模塊
* `新增` axios 模塊 / cheerio 模塊 (Ref to [AutoX](https://github.com/kkevsekk1/AutoX))
* `新增` sqlite 模塊, 用於 SQLite 數據庫簡單操作 (Ref to [Auto.js Pro](https://g.pro.autojs.org/)) (參閲 項目文檔 > [SQLite](https://docs.autojs6.com/#/sqlite))
* `新增` mime 模塊, 用於處理和解析 MIME 類型字符串 (參閲 項目文檔 > [MIME](https://docs.autojs6.com/#/mime))
* `新增` nanoid 模塊, 可作為字符串 ID 生成器 (Ref to [ai/nanoid](https://github.com/ai/nanoid))
* `新增` sysprops 模塊, 用於獲取運行時環境配置數據 (參閲 項目文檔 > [系統屬性](https://docs.autojs6.com/#/sysprops))
* `新增` ocr 模塊支持 [Rapid OCR](https://github.com/RapidAI/RapidOCR) 引擎
* `新增` 佈局分析支持切換窗口 (Ref to [Auto.js Pro](https://g.pro.autojs.org/))
* `新增` auto.clearCache 方法, 支持清除控件緩存 (Ref to [Auto.js Pro](https://g.pro.autojs.org/))
* `新增` threads.pool 方法, 支持線程池簡單應用 (Ref to [Auto.js Pro](https://g.pro.autojs.org/))
* `新增` images.matchTemplate 方法增加 useTransparentMask 選項參數, 支持透明找圖 (Ref to [Auto.js Pro](https://g.pro.autojs.org/))
* `新增` images.requestScreenCaptureAsync 方法, 用於 UI 模式異步方式申請截圖權限 (Ref to [Auto.js Pro](https://g.pro.autojs.org/))
* `新增` images.requestScreenCapture 方法增加 isAsync 選項參數, 支持異步方式獲取屏幕截圖 (Ref to [Auto.js Pro](https://g.pro.autojs.org/))
* `新增` images.on('screen_capture', callback) 等事件監聽方法, 支持監聽屏幕截圖可用事件 (Ref to [Auto.js Pro](https://g.pro.autojs.org/))
* `新增` images.stopScreenCapture 方法, 支持主動釋放截圖申請的相關資源 (Ref to [Auto.js Pro](https://g.pro.autojs.org/))
* `新增` images.psnr/mse/ssim/mssim/hist/ncc 及 images.getSimilarity 方法, 用於獲取圖像相似性度量值
* `新增` images.isGrayscale 方法, 用於判斷圖像是否為灰度圖像
* `新增` images.invert 方法, 用於反色圖像轉換
* `新增` s13n.point/time 方法, 用於標準化點對象及時長對象 (參閲 項目文檔 > [標準化](https://docs.autojs6.com/#/s13n))
* `新增` console 模塊 gravity (重力), touchThrough (穿透點擊), backgroundTint (背景着色) 等相關方法 (參閲 項目文檔 > [控制枱](https://docs.autojs6.com/#/console))
* `新增` Mathx.randomInt/Mathx.randomFloat 方法, 用於返回指定範圍內的隨機整數或隨機浮點數
* `新增` app.launchDual/startDualActivity 等方法, 用於處理雙開應用 (需要 Shizuku 或 Root 權限) (實驗性)
* `新增` app.kill 方法, 用於強制停止應用 (需要 Shizuku 或 Root 權限)
* `新增` floaty.getClip 方法, 用於藉助浮動窗口聚焦間接獲取剪切板內容
* `修復` Fragment 子類 (如 [DrawerFragment](https://github.com/SuperMonster003/AutoJs6/blob/17616504ab0bba93b30ab7abc67108ee5253f39a/app/src/main/java/org/autojs/autojs/ui/main/drawer/DrawerFragment.kt#L369) / [ExplorerFragment](https://github.com/SuperMonster003/AutoJs6/blob/17616504ab0bba93b30ab7abc67108ee5253f39a/app/src/main/java/org/autojs/autojs/ui/main/scripts/ExplorerFragment.kt#L48) 等) 中存在的 View Binding 內存泄漏
* `修復` [ScreenCapture](https://github.com/SuperMonster003/AutoJs6/blob/17616504ab0bba93b30ab7abc67108ee5253f39a/app/src/main/java/org/autojs/autojs/core/image/capture/ScreenCapturer.java#L70) / [ThemeColorPreference](https://github.com/SuperMonster003/AutoJs6/blob/10960ddbee71f75ef80907ad5b6ab42f3e1bf31e/app/src/main/java/org/autojs/autojs/ui/settings/ThemeColorPreference.kt#L21) 等類中存在的實例內存泄漏
* `修復` Android 14 申請截圖權限導致應用崩潰的問題 (by [chenguangming](https://github.com/chenguangming)) _[`pr #242`](http://pr.autojs6.com/242)_
* `修復` Android 14 開啓前台服務導致應用崩潰的問題
* `修復` Android 14 代碼編輯器運行按鈕點擊後無法正常亮起的問題
* `修復` 項目打包後應用可能因缺少必要庫文件無法正常運行的問題 _[`issue #202`](http://issues.autojs6.com/202)_ _[`issue #223`](http://issues.autojs6.com/223)_ _[`pr #264`](http://pr.autojs6.com/264)_
* `修復` 編輯項目時可能因指定圖標資源不存在而導致應用崩潰的問題 _[`issue #203`](http://issues.autojs6.com/203)_
* `修復` 截圖權限申請時無法正常使用參數獲取指定屏幕方向的截圖資源
* `修復` 部分設備無法正常添加腳本快捷方式的問題 (試修) _[`issue #221`](http://issues.autojs6.com/221)_
* `修復` 調用 http 模塊與發送請求相關的方法將出現累積性請求發送延遲的問題 _[`issue #192`](http://issues.autojs6.com/192)_
* `修復` Shizuku 服務在 AutoJs6 進入主活動頁面之前可能無法正常使用的問題 (試修) _[`issue #255`](http://issues.autojs6.com/255)_
* `修復` random(min, max) 方法可能出現結果越界的問題
* `修復` pickup 方法結果類型參數無法正常傳入空數組的問題
* `修復` UiObject#bounds() 得到的控件矩形可能被意外修改而破壞其不變性的問題
* `修復` text/button/input 元素的文本內容包含半角雙引號時無法正常解析的問題
* `修復` text/textswitcher 元素的 autoLink 屬性功能失效的問題
* `修復` 不同腳本可能錯誤地共享同一個 ScriptRuntime 對象的問題
* `修復` 全局變量 HEIGHT 及 WIDTH 丟失 Getter 動態屬性的問題
* `修復` 腳本啓動時 RootShell 隨即加載可能導致啓動高延遲的問題
* `修復` 控制枱浮動窗口設置背景顏色導致矩形圓角樣式丟失的問題
* `修復` 無障礙服務自動啓動可能出現的服務異常問題 (試修)
* `修復` 主頁文檔頁面左右滑動 WebView 控件時可能觸發 ViewPager 切換的問題
* `修復` 文件管理器無法識別包含大寫字母文件擴展名的問題
* `修復` 文件管理器首次進入項目目錄時可能無法自動識別項目的問題
* `修復` 文件管理器刪除文件夾後頁面無法自動刷新的問題
* `修復` 文件管理器排序文件及文件夾時可能出現 ASCII 首字母名稱置後的問題
* `修復` 代碼編輯器調試功能的 FAILED ASSERTION 異常
* `修復` 代碼編輯器調試過程中關閉編輯器後無法再次正常調試的問題
* `修復` 代碼編輯器跳轉到行尾時可能遺漏末尾字符的問題
* `修復` 主活動頁面啓動日誌活動頁面時可能出現閃屏的問題
* `修復` 打包應用無法正常使用 opencc 模塊的問題
* `優化` 打包頁面中 "不可用 ABI" 控件的點擊提示體驗
* `優化` 支持使用 Shizuku 控制 "指針位置" 顯示開關
* `優化` 支持使用 Shizuku 控制 "投影媒體" 及 "修改安全設置" 權限開關
* `優化` automator.gestureAsync/gesturesAsync 支持回調函數參數
* `優化` tasks 模塊使用同步方式進行數據庫操作避免可能的數據訪問不一致問題
* `優化` 腳本執行模式支持管道符號分隔模式參數 (如 `"ui|auto";` 開頭)
* `優化` 腳本執行模式支持單引號及反引號且支持省略分號 (如 `'ui';` 或 `'ui'` 開頭)
* `優化` 腳本執行模式支持 axios, cheerio, dayjs 等模式參數快捷導入內置擴展模塊 (如 `"axios";` 開頭)
* `優化` 腳本執行模式支持 x 或 jsox 模式參數快捷啓用 JavaScript 內置對象擴展模塊 (如 `"x";` 開頭)
* `優化` img 元素 src 及 path 屬性支持本地相對路徑 (如 `<img src="a.png"` />)
* `優化` 代碼編輯器導入 Java 類和包名時支持智能判斷插入位置
* `優化` images 模塊支持直接使用路徑作為圖像參數
* `優化` importPackage 支持字符串參數
* `優化` 服務端模式 IP 地址支持剪切板導入智能識別且支持空格按鍵智能轉換
* `優化` 文件管理器新建文件時支持默認前綴選擇並自動生成合適的數字後綴
* `優化` 文件管理器運行項目時具體化異常消息提示 _[`issue #268`](http://issues.autojs6.com/268)_
* `優化` 文件管理器支持更多類型並支持顯示對應的圖標符號 (支持 800 多種文件類型)
* `優化` 文件管理器可編輯的文件類型 (jpg/doc/pdf...) 增加編輯按鈕
* `優化` 文件管理器 APK 文件支持查看基礎信息, Manifest 信息及權限列表
* `優化` 文件管理器音視頻等媒體文件支持查看基礎信息及 MediaInfo 信息
* `優化` 打包單文件時支持自動填入合適的標準化名包並支持無效字符過濾提示
* `優化` 打包單文件時支持根據已安裝同包名應用自動設置圖標並自增版本號及版本名稱
* `優化` 打包項目配置文件支持 abis/libs 選項指定默認包含的 ABI 架構及擴展庫
* `優化` 打包項目配置文件 abis/libs 選項無效或無可用時支持相關消息提示
* `優化` LeakCanary 在正式發行版本中被排除以避免增加不必要性
* `優化` 項目源代碼所有英文註釋增加簡體中文翻譯以增強註釋可讀性
* `優化` README 及 CHANGELOG 支持多語言 (由腳本自動生成)
* `優化` Gradle 構建腳本提升版本自適應能力
* `優化` 部分依賴或本地庫版本調整 _[`CHANGELOG.md`](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG.md#v660)_

##### 更多版本歷史可參閲

* [CHANGELOG.md](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG-zh-Hant-HK.md)

******

### <a id="project-compilation-and-build"></a>項目編譯構建

******

如需對 AutoJs6 開源項目進行調試或開發, 可使用 [Android Studio](https://pro.autojs.org/) ([Google](https://www.google.com/) 公司產品) 或 [IntelliJ IDEA](https://www.jetbrains.com/idea/) ([Jetbrains](https://www.jetbrains.com/) 公司產品).

本小節以 Android Studio 為例介紹 AutoJs6 開源項目的編譯構建方法, IntelliJ IDEA 與之類似.

#### Android Studio 準備

下載 `Android Studio Meerkat | 2024.3.1 Patch 1` 版本 (按需選擇其一):

- [android-studio-2024.3.1.14-windows.exe](https://redirector.gvt1.com/edgedl/android/studio/install/2024.3.1.14/android-studio-2024.3.1.14-windows.exe) (1.22 GB)
- [android-studio-2024.3.1.14-windows.zip](https://redirector.gvt1.com/edgedl/android/studio/ide-zips/2024.3.1.14/android-studio-2024.3.1.14-windows.zip) (1.23 GB)

> 注: 上述版本發佈時間為 2025 年 3 月 24 日. 如需下載其他版本, 或上述鏈接已失效, 可訪問 [Android Studio 發行版本歸檔](https://developer.android.com/studio/archive?hl=en) 頁面.

安裝或解壓上述文件, 運行 Android Studio 軟件 (如 `"D:\android-studio\bin\studio64.exe"`).

#### Android SDK 準備

> 注: 如果計算機系統已安裝 Android SDK (安卓軟件開發工具包), 則可跳過此小節內容.

在 Android Studio 軟件中使用快捷鍵 `CTRL + ALT + S` 打開設置頁面:

```text
Appearance & Behavior (外觀與表現) -> 
System Settings (系統設置) -> 
Android SDK (安卓軟件開發工具包)
```

`Android SDK Location (安卓軟件開發工具包位置)` 處如果是空白內容, 可點擊右側 `Edit (編輯)` 按鈕, 在彈出的窗口中多次點擊 `Next (下一步)`.

> 注: 過程中可能需要同意一個或多個相關協議才能繼續.

待相關資源下載並安裝完畢, 點擊 `Finish (完成)` 按鈕.  
上述 `Android SDK Location (安卓軟件開發工具包位置)` 處將自動完成路徑填寫, SDK 準備工作隨即完成.

#### Android SDK Tools 準備

AutoJs6 需要使用部分 SDK 工具 (如 NDK 及 CMake).

> 注: 如果計算機系統已安裝 AutoJs6 全部所需的 Android SDK Tools, 則可跳過此小節內容.

在 Android Studio 軟件中使用快捷鍵 `CTRL + ALT + S` 打開設置頁面:

```text
Appearance & Behavior (外觀與表現) -> 
System Settings (系統設置) -> 
Android SDK (安卓軟件開發工具包) -> 
SDK Tools (SDK 工具) (位於右側窗口)
```

勾選 `Show Package Details (顯示包詳情)`, 依次點擊 NDK 及 CMake, 確保相應版本的工具已勾選, SDK 工具的版本信息位於 AutoJs6 項目根目錄的 `version.properties` 文件中.

#### JDK 準備

AutoJs6 項目依賴的 `JDK (Java 開發工具包)` 發行版本不低於 `17`, 但建議不低於 `19`.

截至 2025 年 4 月 16 日, AutoJs6 可支持 JDK 最高版本為 `24`.

> 注: 如果計算機系統已安裝 JDK 且版本滿足上述要求, 則可跳過此小節內容.

JDK 可使用 IDE 直接下載, 或訪問 [Oracle 網站](https://www.oracle.com/java/technologies/downloads/) 下載.

在 Android Studio 軟件中使用快捷鍵 `CTRL + ALT + S` 打開設置頁面:

```text
Build, Execution, Deployment (構建, 執行, 開發) -> 
Build Tools (構建工具) -> 
Gradle
```

`Gradle JDK` 處可選擇或添加不同版本的 JDK.

如果列表中已存在合適版本的 JDK (>= `17`), 則直接選擇即可.  
否則可以選擇 `Download JDK (下載 JDK)` 下載合適的 JDK, 點擊 `Download (下載)` 按鈕並等待下載完成.  
也可以選擇 `Add JDK (添加 JDK)` 添加已存在的本地 JDK, 定位其目錄並完成 JDK 添加.

#### AutoJs6 資源克隆

在 Android Studio 主頁面點擊 `Get from VCS (從版本控制系統獲取)` 按鈕.  
`URL (統一資源定位地址)` 處填入 `https://github.com/SuperMonster003/AutoJs6.git`,  
`Directory (目錄)` 處可根據需要修改為特定路徑.  
點擊 `Clone (克隆)` 按鈕, 等待 AutoJs6 項目資源在設備本地完成克隆.

> 注: 上述過程可能需要安裝 [Git (分佈式版本控制系統)](https://git-scm.com/download).

#### AutoJs6 項目構建

克隆完成後, Android Studio 將打開 AutoJs6 的項目窗口, 並自動完成初步的 `Dependencies (依賴)` 下載及 Gradle 構建工作.

> 注: 上述過程可能非常耗時. 若網絡條件欠佳, 可能需要重試多次 (點擊 Retry 按鈕).

如果構建未能自動進行, 或需要再次構建項目, 可執行以下步驟:

- 在 `Toolbar (工具欄)` 中, 從 `Run/Debug Configurations (運行/調試配置)` 菜單中選擇 `app`, 這是 AutoJs6 的主應用
- 點擊左側的 `Build Project (構建項目)` 按鈕 (形如鐵錘) 開始構建項目, 默認快捷鍵為 CTRL + F9
- 等待構建完成, `Builder Output (構建輸出)` 標籤頁將出現類似 "BUILD SUCCESSFUL in 1h 17m 34s" 的消息

如果構建失敗, 可將異常消息反饋到 AutoJs6 項目的 [議題 (Issues)](http://issues.autojs6.com) 頁面.

> 注: 關於如何構建並運行應用的更多內容, 可參閲 [Android Docs](https://developer.android.com/studio/run?hl=zh-cn)

#### AutoJs6 項目部署 (運行 App)

項目構建成功後, 可將項目作為應用程序 (簡稱 App) 部署到實體設備 (如手機/平板電腦) 或虛擬設備 (如 Android 模擬器) 中.

- 在 `Toolbar (工具欄)` 中, 從 `Run/Debug Configurations (運行/調試配置)` 菜單中選擇 `app`, 這是 AutoJs6 的主應用
- 在右側 `Available Devices (可用設備)` 菜單中, 選擇需要運行項目 App 的設備 (實體設備或虛擬設備)
- 點擊右側的 `Run (運行)` 按鈕 (形如三角形) 開始運行項目, 默認快捷鍵為 `F10`
- 等待部署完成, 指定設備將自動安裝並運行項目 App

#### AutoJs6 項目部署 (生成 APK)

打包項目並生成可安裝到安卓設備的 APK 文件:

- 調試版 (Debug Version)
    - `Build (構建)` -> `Build Bundle(s) / APK(s)` -> `Build APK(s)`
    - 生成帶默認簽名的調試版安裝包
    - 路徑示例: `"D:\AutoJs6\app\build\outputs\apk\debug\"`
- 發佈版 (Release Version)
    - `Build (構建)` -> `Generate Signed Bundle / APK`
    - 選擇 `APK` 選項
    - 準備好簽名文件 (新建或選取), 生成已簽名的發佈版安裝包
    - 路徑示例: `"D:\AutoJs6\app\release\"`

> 注: 關於如何構建應用以向用户發佈的更多內容, 可參閲 [Android Docs](https://developer.android.com/build/build-for-release?hl=zh-cn)

#### AutoJs6 預置 Gradle 構建任務

除了構建項目 App 之外, AutoJs6 還支持一些預置的 Gradle 構建任務, 這些任務可以幫助開發者完成與項目相關的便捷操作.

在 `Toolbar (工具欄)` 的 `Run/Debug Configurations (運行/調試配置)` 菜單中, 可看到各個 Gradle 預置任務, 每個任務左側均顯示帶小象圖標的任務標識.

- AutoJs6 [inrt:assemble]

組裝 "inrt" 構建變體, 主要服務於 AutoJs6 腳本打包功能.

AutoJs6 項目擁有不同的構建變體, 其中 "inrt" 變體用於實現 AutoJs6 的腳本打包功能, 生成打包功能依賴的模板文件 "template.apk".

使用打包功能時可能會出現以下異常消息:

> java.io.FileNotFoundException: template.apk

這表明模板文件不存在, 需要手動運行一次 `inrt:assemble` 任務, 生成模板文件, 然後再次構建並部署 App.

> 這表明模板文件不存在, 需要手動運行一次 `inrt:assemble` 任務, 生成模板文件, 然後再次構建並部署 App

- AutoJs6 [app:bundle]

打包 debug 版本編譯過程產物, 主要服務於 [AutoJs6 聲明文件](http://dts-project.autojs6.com) 項目.

任務運行後生成一個 AutoJs6 項目最新的 JAR 文件, 利用 [Android d.ts Generator](https://github.com/NativeScript/android-dts-generator) (by [NativeScript](https://github.com/NativeScript)) 工具可生成 AutoJs6 主應用的聲明文件 (d.ts 格式).

- AutoJs6 [app:digest]

附加摘要信息到 release 版本編譯產生的 APK 文件, 主要服務於 AutoJs6 發佈最新版本到 GitHub 前確定最終的文件名.

以下為附加摘要信息前後的文件名對比:

```text
前:
autojs6-v6.6.2-arm64-v8a.apk
後:
autojs6-v6.6.2-arm64-v8a-0f2a9d74.apk
```

> 參閲: [Android Docs](https://developer.android.com/studio/run?hl=zh-cn)

******

### <a id="script-development-assistance"></a>腳本開發輔助

******

開發 AutoJs6 可運行的腳本, 需使用合適的開發工具:

- [VSCode](https://code.visualstudio.com/download) / [WebStorm](https://www.jetbrains.com/webstorm/download/) / [HBuilderX](https://www.dcloud.io/hbuilderx.html) ...

如需在 PC 上進行腳本編寫與調試, VSCode 插件可以實現 PC 與手機的互聯:

- [AutoJs6-VSCode-Extension](http://vscext-project.autojs6.com) - AutoJs6 調試器 (VSCode 平台插件)

使用開發工具編寫代碼時, 代碼智能補全功能可以更好地輔助開發者完成代碼編寫:

- [AutoJs6-TypeScript-Declarations](http://dts-project.autojs6.com) - AutoJs6 聲明文件 (代碼智能補全)

編寫代碼時, AutoJs6 相關 API 及使用方式, 可隨時查閲應用文檔:

- [AutoJs6-Documentation](http://docs-project.autojs6.com) - AutoJs6 應用文檔

現有的腳本開發項目可作為參考, 激發個人腳本項目的創作靈感:

- [Ant-Forest](https://github.com/TonyJiangWJ/Ant-Forest) - 螞蟻森林能量自動收取腳本 by [TonyJiangWJ](https://github.com/TonyJiangWJ)
- [Ant-Forest](https://github.com/SuperMonster003/Ant-Forest) - 螞蟻森林能量自動收取腳本 by [SuperMonster003](https://github.com/SuperMonster003)
- [autojs](https://github.com/e1399579/autojs) - Auto.js 實用腳本 by  [e1399579](https://github.com/e1399579)
- [autojsDemo](https://github.com/snailuncle/autojsDemo) - Auto.js 演示示例 by  [snailuncle](https://github.com/snailuncle)
- [autojs 相關倉庫](https://github.com/topics/autojs) - GitHub 與 autojs 話題相關的全部倉庫

******

### 貢獻參與

******

感謝每一位參與 AutoJs6 項目開發的貢獻人員.

|         <span style="word-break:keep-all;white-space:nowrap">貢獻人員</span>          |                   <span style="word-break:keep-all;white-space:nowrap">提交數</span>                    | <span style="word-break:keep-all;white-space:nowrap">最近提交</span> |
|:-------------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------:|
|          <span style="word-break:keep-all;white-space:nowrap">[luckyloogn](https://github.com/luckyloogn)</span>          |       <span style="word-break:keep-all;white-space:nowrap">[3](https://github.com/SuperMonster003/AutoJs6/commits?author=luckyloogn)</span>        |                    <span style="word-break:keep-all;white-space:nowrap">`2025/01/01`</span>                    |
|                <span style="word-break:keep-all;white-space:nowrap">[kvii](https://github.com/kvii)</span>                |          <span style="word-break:keep-all;white-space:nowrap">[1](https://github.com/SuperMonster003/AutoJs6/commits?author=kvii)</span>           |                    <span style="word-break:keep-all;white-space:nowrap">`2024/10/16`</span>                    |
|   <span style="word-break:keep-all;white-space:nowrap">[chenguangming](https://github.com/chenguangming) `(Tom)`</span>   | <span style="word-break:keep-all;white-space:nowrap">[2](https://github.com/SuperMonster003/AutoJs6/pulls?q=is%3Apr+author%3Achenguangming)</span> |                    <span style="word-break:keep-all;white-space:nowrap">`2024/05/14`</span>                    |
|          <span style="word-break:keep-all;white-space:nowrap">[LZX284](https://github.com/LZX284) `(AI)`</span>           |         <span style="word-break:keep-all;white-space:nowrap">[17](https://github.com/SuperMonster003/AutoJs6/commits?author=LZX284)</span>         |                    <span style="word-break:keep-all;white-space:nowrap">`2023/11/19`</span>                    |
|         <span style="word-break:keep-all;white-space:nowrap">[TonyJiangWJ](https://github.com/TonyJiangWJ)</span>         |       <span style="word-break:keep-all;white-space:nowrap">[4](https://github.com/SuperMonster003/AutoJs6/commits?author=TonyJiangWJ)</span>       |                    <span style="word-break:keep-all;white-space:nowrap">`2023/10/31`</span>                    |
| <span style="word-break:keep-all;white-space:nowrap">[little&#x2011;alei](https://github.com/little-alei) `(抠脚本人)`</span> |      <span style="word-break:keep-all;white-space:nowrap">[12](https://github.com/SuperMonster003/AutoJs6/commits?author=little-alei)</span>       |                    <span style="word-break:keep-all;white-space:nowrap">`2023/07/12`</span>                    |
|              <span style="word-break:keep-all;white-space:nowrap">[aiselp](https://github.com/aiselp)</span>              |    <span style="word-break:keep-all;white-space:nowrap">[6](https://github.com/SuperMonster003/AutoJs6/pulls?q=is%3Apr+author%3Aaiselp)</span>     |                    <span style="word-break:keep-all;white-space:nowrap">`2023/06/14`</span>                    |
|           <span style="word-break:keep-all;white-space:nowrap">[LYS86](https://github.com/LYS86) `(Lin)`</span>           |          <span style="word-break:keep-all;white-space:nowrap">[2](https://github.com/SuperMonster003/AutoJs6/commits?author=LYS86)</span>          |                    <span style="word-break:keep-all;white-space:nowrap">`2023/06/03`</span>                    |

數據更新於 2025 年 1 月 1 日.

數據條目按 `最近提交` 降序排序.

新發起的暫未處理的 Pull Request, 將在合併處理後加入數據統計.

部分貢獻人員在 [GitHub Contributors](https://github.com/SuperMonster003/AutoJs6/graphs/contributors) 未能正常出現, 其提交記錄為空, 仍可通過 [Pull Request](https://github.com/SuperMonster003/AutoJs6/pulls) 查看貢獻記錄.

[//]: # (
    # --------------------------------------------------------------#
    # Before committing and pushing to the remote GitHub repository #
    # --------------------------------------------------------------#
    - CHANGELOG.md
        - Update entries for AutoJs6 by checking all changed files
        - Update entries for Gradle plugins [ implementation ]
        - Update version name and released date
        - Append related GitHub issues to changelog entries
    - README.md
        - The summary of the latest changelog for committing to Git [ DO NOT commit or push ]
        - Update badges like [ android studio / rhino / ... ]
        - Update android studio download links and version names
        - Update contribution section
    - Remove the part like [ alpha / beta / ... ] of VERSION_NAME in version.properties
    - Update dependencies TypeScript declarations if needed.
    - Re-generate documentation/markdown by running the python script
    - Check the two-way versions for AutoJs6 and VSCode ext, then publish the ext to Microsoft
    - Run Gradle task "app:assembleInrtRelease"
    - Build APK to determine the final VERSION_BUILD field
    - Run Gradle task "app:appendDigestToReleasedFiles"
    - Check VERSION_BUILD in version.properties with released apks
    - Commit and push to GitHub
    - Publish the latest release with signed APKs
)