/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public class AbstractEcmaStringOperations {
    public static String getSubstitution(Context cx, Scriptable scope, String matched, String str, int position, NativeArray capturesArray, Object namedCaptures, String replacementTemplate) {
        int stringLength = str.length();
        if (position > stringLength) {
            Kit.codeBug();
        }
        StringBuilder result = new StringBuilder();
        String templateRemainder = replacementTemplate;
        while (!templateRemainder.isEmpty()) {
            String ref;
            String refReplacement = ref = templateRemainder.substring(0, 1);
            if (templateRemainder.charAt(0) == '$' && templateRemainder.length() > 1) {
                char c = templateRemainder.charAt(1);
                switch (c) {
                    case '$': {
                        ref = "$$";
                        refReplacement = "$";
                        break;
                    }
                    case '`': {
                        ref = "$`";
                        refReplacement = str.substring(0, position);
                        break;
                    }
                    case '&': {
                        ref = "$&";
                        refReplacement = matched;
                        break;
                    }
                    case '\'': {
                        ref = "$'";
                        int matchLength = matched.length();
                        int tailPos = position + matchLength;
                        refReplacement = str.substring(Math.min(tailPos, stringLength));
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        long captureLen;
                        String digits;
                        int index;
                        char c2;
                        int digitCount = 1;
                        if (templateRemainder.length() > 2 && AbstractEcmaStringOperations.isAsciiDigit(c2 = templateRemainder.charAt(2))) {
                            digitCount = 2;
                        }
                        if ((long)(index = Integer.parseInt(digits = templateRemainder.substring(1, 1 + digitCount))) > (captureLen = capturesArray.getLength()) && digitCount == 2) {
                            digitCount = 1;
                            digits = digits.substring(0, 1);
                            index = Integer.parseInt(digits);
                        }
                        ref = templateRemainder.substring(0, 1 + digitCount);
                        if (1 <= index && (long)index <= captureLen) {
                            Object capture = capturesArray.get(index - 1);
                            if (capture == null) {
                                refReplacement = "";
                                break;
                            }
                            refReplacement = ScriptRuntime.toString(capture);
                            break;
                        }
                        refReplacement = ref;
                        break;
                    }
                    case '<': {
                        int gtPos = templateRemainder.indexOf(62);
                        if (gtPos == -1 || Undefined.isUndefined(namedCaptures)) {
                            refReplacement = ref = "$<";
                            break;
                        }
                        ref = templateRemainder.substring(0, gtPos + 1);
                        String groupName = templateRemainder.substring(2, gtPos);
                        Object capture = ScriptRuntime.getObjectProp(namedCaptures, groupName, cx, scope);
                        refReplacement = Undefined.isUndefined(capture) ? "" : ScriptRuntime.toString(capture);
                    }
                }
            }
            int refLength = ref.length();
            templateRemainder = templateRemainder.substring(refLength);
            result.append(refReplacement);
        }
        return result.toString();
    }

    private static boolean isAsciiDigit(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return true;
            }
        }
        return false;
    }
}

