<!--suppress HtmlDeprecatedAttribute, HttpUrlsUsage -->

<div align="center">
  <p>
    <img src="https://s1.imagehub.cc/images/2023/03/07/af8ed087c9d354b9ab6142aae7bbafb6.png" alt="autojs6-banner_800×224" border="0" width="704" />
  </p>

  <p>Инструмент автоматизации на языке JavaScript для платформы Android с поддержкой службы доступности</p>

  <p>
    <a href="http://download.autojs6.com"><img alt="GitHub release (latest by date)" src="https://img.shields.io/github/v/release/SuperMonster003/AutoJs6"/></a>
    <a href="http://issues.autojs6.com"><img alt="GitHub closed issues" src="https://img.shields.io/github/issues/SuperMonster003/AutoJs6?color=009688"/></a>
    <a href="http://commit.autojs6.com/99a1d8490fac5b6d55f6f183db59ad833a2064ed"><img alt="Created" src="https://img.shields.io/date/1636632233?color=2e7d32&label=created"/></a>
    <br>
    <a href="https://github.com/mozilla/rhino"><img alt="Rhino" src="https://img.shields.io/badge/rhino-1.7.16--snapshot-A24232"/></a>
    <a href="https://developer.android.com/studio/archive"><img alt="Android Studio" src="https://img.shields.io/badge/android%20studio-2022.1+-B64FC8"/></a>
    <br>
    <a href="https://www.codefactor.io/repository/github/SuperMonster003/AutoJs6"><img alt="CodeFactor Grade" src="https://www.codefactor.io/repository/github/SuperMonster003/AutoJs6/badge"/></a>
    <a href="https://www.jetbrains.com/?from=AutoJs6"><img alt="JetBrains supporter" src="https://img.shields.io/badge/supporter-JetBrains-ee4677"/></a>
    <a href="http://project.autojs6.com/blob/master/LICENSE"><img alt="GitHub License" src="https://img.shields.io/github/license/SuperMonster003/AutoJs6?color=534BAE"/></a>
  </p>
</div>

******

### Языки

******

Текущий файл README.md поддерживает следующие языки:

 - [简体中文 [zh-Hans]](http://project.autojs6.com/blob/master/.readme/README-zh-Hans.md)
 - [繁體中文 (香港) [zh-Hant-HK]](http://project.autojs6.com/blob/master/.readme/README-zh-Hant-HK.md)
 - [繁體中文 (台灣) [zh-Hant-TW]](http://project.autojs6.com/blob/master/.readme/README-zh-Hant-TW.md)
 - [English [en]](http://project.autojs6.com/blob/master/.readme/README-en.md)
 - [Français [fr]](http://project.autojs6.com/blob/master/.readme/README-fr.md)
 - [Español [es]](http://project.autojs6.com/blob/master/.readme/README-es.md)
 - [日本語 [ja]](http://project.autojs6.com/blob/master/.readme/README-ja.md)
 - [한국어 [ko]](http://project.autojs6.com/blob/master/.readme/README-ko.md)
 - Русский [ru] # текущий
 - [العربية [ar]](http://project.autojs6.com/blob/master/.readme/README-ar.md)

******

### Введение

******

[Auto.js](https://github.com/hyb1996/Auto.js) — это инструмент автоматизации на языке JavaScript для платформы Android с поддержкой [службы доступности](https://developer.android.com/guide/topics/ui/accessibility/service?hl=zh-cn).

Auto.js был выпущен [hyb1996](https://github.com/hyb1996) в `2017/01/27`, и его поддержка прекратилась в `2020/03/13`, финальная версия - `4.1.1 Alpha2`, номер сборки - `461`.

AutoJs6 разработан на основе финальной версии проекта Auto.js и вышел в `2021/12/01`, оставаясь бесплатным с открытым исходным кодом.

В таблице ниже перечислены некоторые проекты, связанные с Auto.js (отсортированы по дате начала разработки):

| <span style="word-break:keep-all;white-space:nowrap">Проект</span> |                                                             <span style="word-break:keep-all;white-space:nowrap">Название приложения</span>                                                              | <span style="word-break:keep-all;white-space:nowrap">Разработчик</span> | <span style="word-break:keep-all;white-space:nowrap">Дата начала разработки</span> | <span style="word-break:keep-all;white-space:nowrap">Дата окончания разработки</span> |
|:------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------:|:---------------------------------------------------------------------------------------------------------------------------------:|:-------------------------------------------------------------------------------------------------------------------------------:|
|     <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/hyb1996/Auto.js)</span>      |    <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/TonyJiangWJ/Auto.js/commit/268ec8895bbfa28fc7715154eb15b1c1eaaefd14#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span>     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2017/01/27`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2020/03/13`</span>                             |
|                     <span style="word-break:keep-all;white-space:nowrap">Auto.js Pro 7</span>                      |                                                                                     <span style="word-break:keep-all;white-space:nowrap">Auto.js</span>                                                                                      |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2019/03/13`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2019/07/08`</span>                             |
|                     <span style="word-break:keep-all;white-space:nowrap">Auto.js Pro 8</span>                      |                                                                                    <span style="word-break:keep-all;white-space:nowrap">AutoJsPro</span>                                                                                     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2019/10/13`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2021/07/24`</span>                             |
|   <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/TonyJiangWJ/Auto.js)</span>    | <span style="word-break:keep-all;white-space:nowrap">[Auto.js&#160;M](https://github.com/TonyJiangWJ/Auto.js/commit/268ec8895bbfa28fc7715154eb15b1c1eaaefd14#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span> |      <span style="word-break:keep-all;white-space:nowrap">[TonyJiangWJ](https://github.com/TonyJiangWJ)</span>       |                             <span style="word-break:keep-all;white-space:nowrap">`2019/11/21`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|      <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/kkevsekk1/AutoX)</span>       |                 <span style="white-space:pre">[Autox.js](https://github.com/kkevsekk1/AutoX/commit/8143e4ed893d4af05d22aa791b83a962f9959873#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span>                  |        <span style="word-break:keep-all;white-space:nowrap">[kkevsekk1](https://github.com/kkevsekk1)</span>         |                             <span style="word-break:keep-all;white-space:nowrap">`2020/07/24`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|        <span style="word-break:keep-all;white-space:nowrap">[Auto.js Pro 9](https://pro.autojs.org/)</span>        |                                                                                    <span style="word-break:keep-all;white-space:nowrap">AutoJsPro</span>                                                                                     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2021/03/28`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2023/02/09`</span>                             |
| <span style="word-break:keep-all;white-space:nowrap">[AutoJs6](https://github.com/SuperMonster003/AutoJs6)</span>  |  <span style="word-break:keep-all;white-space:nowrap">[AutoJs6](https://github.com/SuperMonster003/AutoJs6/commit/a8ce1b9acb541e9736c33134be3194c3148a15a3#diff-833a46a97033e77558372a2dce103fd6fee29aaaa899f610022a7aece592ee7bR27)</span>  |  <span style="word-break:keep-all;white-space:nowrap">[SuperMonster003](https://github.com/SuperMonster003)</span>   |                             <span style="word-break:keep-all;white-space:nowrap">`2021/12/01`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|      <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/kkevsekk1/AutoX)</span>       |            <span style="white-space:pre">[Autox.js&#160;v6](https://github.com/kkevsekk1/AutoX/commit/8b6776cff8b0fca4be4a52719b7d7d07c0a058f3#diff-51a0b488f963eb0be6c6599bf5df497313877cf5bdff3950807373912ac1cdc9R130)</span>             |           <span style="word-break:keep-all;white-space:nowrap">[wilinz](https://github.com/wilinz)</span>            |                             <span style="word-break:keep-all;white-space:nowrap">`2022/05/26`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|      <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/kkevsekk1/AutoX)</span>       |            <span style="white-space:pre">[Autox.js&#160;v7](https://github.com/kkevsekk1/AutoX/commit/484491fd5fe12b8203d0b09c181eb0f471c0ea9f#diff-8cff73265af19c059547b76aca8882cbaa3209291406f52df1dafbbc78e80c46R120)</span>             |           <span style="word-break:keep-all;white-space:nowrap">[aiselp](https://github.com/aiselp)</span>            |                             <span style="word-break:keep-all;white-space:nowrap">`2024/04/21`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |

Даты в таблице являются оценочными и могут отличаться от фактических.

В таблице Auto.js Pro 7/8/9 указаны как платные версии, остальные являются бесплатными версиями с открытым исходным кодом.

******

### Функции

******

* Можно использовать в качестве JavaScript IDE (автодополнение кода / переименование переменных / форматирование кода)
* Поддержка автоматизации на основе [службы доступности](https://developer.android.com/reference/android/accessibilityservice/AccessibilityService)
* Поддержка быстрых действий через плавающую кнопку (запись скриптов и их выполнение / просмотр имени пакета и активности / анализ макета)
* Поддержка API селекторов, предоставляющая возможности обхода виджетов / получения информации / управления виджетами (аналогично [UiAutomator](https://developer.android.com/training/testing/ui-automator))
* Поддержка анализа интерфейса макета (аналогично LayoutInspector из Android Studio)
* Поддержка функции записи и воспроизведения записанного
* Поддержка создания скриншотов / сохранения скриншотов / поиска по изображениям / сопоставления изображений
* Поддержка написания интерфейсов с использованием [E4X](https://zh.wikipedia.org/wiki/E4X) (ECMAScript для XML)
* Поддержка упаковки файлов скриптов или проекта в APK файл
* Поддержка расширенных функций с использованием привилегий Root (нажатия на экран / пролистывания / записи / Shell)
* Поддержка работы в качестве плагина для Tasker
* Поддержка подключения к VSCode для разработки на рабочем столе (требуется плагин [AutoJs6-VSCode-Extension](http://vscext-project.autojs6.com))

******

### Окружение

******

- Операционная система Android
- [API](https://developer.android.com/guide/topics/manifest/uses-sdk-element#ApiLevels) [24](https://developer.android.com/reference/android/os/Build.VERSION_CODES#N) ([7.0](https://zh.wikipedia.org/wiki/Android_Nougat)) [[N](https://developer.android.com/reference/android/os/Build.VERSION_CODES#N)] и выше

******

### Руководство

******

* [Документация приложения](https://docs.autojs6.com)
* [Пользовательское руководство (в разработке)](https://docs.autojs6.com/#/manual)
* [Устранение неполадок](https://docs.autojs6.com/#/qa)
* [Компиляция и сборка проекта](#project-compilation-and-build)
* [Помощь в разработке скриптов](#script-development-assistance)

******

### Основные изменения

******

По сравнению с окончательной версией с открытым исходным кодом Auto.js `4.1.1 Alpha2`, AutoJs6 включает следующие основные обновления или изменения:

* Поддержка получения привилегий ADB через [Shizuku](https://shizuku.rikka.app/introduction/) и использование системных API
* Поддержка построения экземпляров [WebSocket](https://docs.autojs6.com/#/webSocketType) для выполнения сетевых запросов на основе [протокола WebSocket](https://zh.wikipedia.org/wiki/WebSocket)
* Добавлены новые модули [ [base64](https://docs.autojs6.com/#/base64) / [crypto](https://docs.autojs6.com/#/crypto) / [sqlite](https://docs.autojs6.com/#/sqlite) / [i18n](https://docs.autojs6.com/#/i18n) / [notice](https://docs.autojs6.com/#/notice) / [ocr](https://docs.autojs6.com/#/ocr) / [opencc](https://docs.autojs6.com/#/opencc) / [qrcode](https://docs.autojs6.com/#/qrcode) / [shizuku](https://docs.autojs6.com/#/shizuku) / ... ]
* Поддержка нескольких языков [ испанский / французский / русский / арабский / японский / корейский / английский / упрощенный китайский / традиционный китайский / ... ]
* Поддержка ночного режима [ страница настроек / страница документации / страница анализа макета / плавающее окно / ... ]
* Плагин [VSCode](http://vscext-project.autojs6.com) поддерживает варианты подключения клиента (LAN) и сервера (LAN/ADB)
* Движок [Rhino](https://github.com/mozilla/rhino/) обновлен с версии [v1.7.7.2](https://github.com/mozilla/rhino/releases/tag/Rhino1_7_7_2_Release) до версии [v1.7.16-SNAPSHOT](http://rhino.autojs6.com/blob/master/gradle.properties#L3)
    * Поддержка Unicode для [экранирования кодовых точек](https://developer.mozilla.org/zh-CN/docs/Glossary/Code_point) и символов [в дополнительных плоскостях](https://zh.wikipedia.org/wiki/Unicode%E5%AD%97%E7%AC%A6%E5%B9%B3%E9%9D%A2%E6%98%A0%E5%B0%84#%E7%AC%AC%E4%B8%80%E8%BC%94%E5%8A%A9%E5%B9%B3%E9%9D%A2)
       ```javascript
       '\u{1D160}'; /* означает "𝅘𝅥𝅮", традиционный метод: '\uD834\uDD60'. */
       ```
    * Поддержка [Object.values()](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Global_Objects/Object/values)
       ```javascript
       Object.values({name: 'Max', age: 4}); // ['max', 4]
       ```
    * Поддержка [Array.prototype.includes()](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Global_Objects/Array/includes)
       ```javascript
       [10, 20, NaN].includes(20); // true
       ```
    * Поддержка [BigInt](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Global_Objects/BigInt)
       ```javascript
       typeof 567n === 'bigint'; // true
       ```
    * Поддержка [шаблонных строк](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Template_literals)
       ```javascript
       `Lucky number: ${(Math.random() * 100).toFixed(0)}`
       ```
    * Просмотр новых функций движка Rhino [новые функции](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/RHINO.md)
    * Просмотр списка совместимости движка Rhino [список совместимости](https://mozilla.github.io/rhino/compat/engines.html)

******

### История версий

******

# v6.6.1

###### 2025/01/01

* `Новое` Модуль Pinyin для преобразования китайского пиньиня (См. документацию проекта > [Китайский Пиньинь](https://docs.autojs6.com/#/pinyin))
* `Новое` Модуль Pinyin4j для преобразования китайского пиньиня (См. документацию проекта > [Китайский Пиньинь](https://docs.autojs6.com/#/pinyin4j))
* `Новое` Методы UiObject#isSimilar и UiObjectCollection#isSimilar для определения, схожи ли элементы управления или их коллекции
* `Новое` Глобальный метод "currentComponent", используемый для получения информации о названии текущего активного компонента
* `Исправление` Ошибка, из-за которой проект не мог быть корректно скомпилирован в некоторых средах из-за отката на предыдущую версию
* `Исправление` Исключение "непримитивное значение", которое могло возникать при вызове несуществующих методов
* `Исправление` Ошибка, из-за которой ярлыки скриптов не могли быть корректно добавлены на некоторых устройствах (промежуточное исправление) _[`issue #221`](http://issues.autojs6.com/221)_
* `Исправление` Ошибка ограничения типа параметров для методов automator.click/longClick _[`issue #275`](http://issues.autojs6.com/275)_
* `Исправление` Ошибка, из-за которой селекторы не поддерживали параметры типа ConsString _[`issue #277`](http://issues.autojs6.com/277)_
* `Исправление` Ошибка, из-за которой экземпляры UiObjectCollection теряли собственные методы и свойства
* `Улучшение` Страница упаковки поддерживает настройку подписи, управление хранилищем ключей и настройку разрешений (автор [luckyloogn]()) _[`pr #286`]()_
* `Улучшение` Улучшена точность распознавания текущего имени пакета и имени активности для плавающего окна (приоритет: Shizuku > Root > A11Y)
* `Улучшение` Улучшена точность распознавания currentPackage и currentActivity (приоритет: Shizuku > Root > A11Y)
* `Улучшение` Восстановлена возможность выбора текста в отдельных записях в окне лога двойным щелчком или длительным нажатием _[`issue #280`](http://issues.autojs6.com/280)_
* `Улучшение` Максимальное восстановление ключевой информации для проектов скриптов в случае повреждения файла project.json
* `Улучшение` Автоматическая конвертация упрощенного китайского в пиньинь (включая многозначные символы) для суффиксов пакетов, создаваемых при упаковке отдельных файлов
* `Улучшение` Поддержка отрицательных аргументов в методах UiSelector#findOnce и UiSelector#find
* `Улучшение` Улучшена адаптивность методов app.startActivity/startDualActivity
* `Улучшение` Поддержка дополнительных сокращённых форм префиксов имён пакетов в селекторах, связанных с элементами UI и className (например, RecyclerView, Snackbar и т. д.)
* `Улучшение` Синхронизировать последний код из официального репозитория Rhino и адаптировать его к существующему проекту
* `Улучшение` Изменения версий некоторых зависимостей или локальных библиотек _[`CHANGELOG.md`](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG.md#v661)_

# v6.6.0

###### 2024/12/02 - Переписаны встроенные модули, обновляйте осторожно

* `Подсказка` Встроенные модули переписываются на Kotlin для повышения эффективности выполнения сценариев, но необходимы итеративные улучшения.
* `Подсказка` Встроенный файл init.js по умолчанию пуст, что позволяет разработчикам расширять встроенные модули или монтировать внешние модули.
* `Новое` Модуль Axios / Модуль Cheerio (Ссылка на [AutoX](https://github.com/kkevsekk1/AutoX))
* `Новое` Модуль SQLite для простых операций с базами данных SQLite (Ссылка на [Auto.js Pro](https://g.pro.autojs.org/)) (См. документацию проекта > [SQLite](https://docs.autojs6.com/#/sqlite))
* `Новое` Модуль MIME для обработки и анализа строк MIME-типов (См. документацию проекта > [MIME](https://docs.autojs6.com/#/mime))
* `Новое` Модуль Nanoid для генерации строковых идентификаторов (Ссылка на [ai/nanoid](https://github.com/ai/nanoid))
* `Новое` Модуль Sysprops для получения данных конфигурации среды выполнения (См. документацию проекта > [Системные свойства](https://docs.autojs6.com/#/sysprops))
* `Новое` Модуль OCR поддерживает движок [Rapid OCR](https://github.com/RapidAI/RapidOCR)
* `Новое` Анализ макета поддерживает изменение окна (Ссылка на [Auto.js Pro](https://g.pro.autojs.org/))
* `Новое` Метод auto.clearCache поддерживает очистку кешей управления (Ссылка на [Auto.js Pro](https://g.pro.autojs.org/))
* `Новое` Метод threads.pool поддерживает простое применение пулов потоков (Ссылка на [Auto.js Pro](https://g.pro.autojs.org/))
* `Новое` Метод images.matchTemplate добавляет параметр опции useTransparentMask для поддержки поиска прозрачного изображения (Ссылка на [Auto.js Pro](https://g.pro.autojs.org/))
* `Новое` Метод images.requestScreenCaptureAsync позволяет запрашивать разрешения на запись экрана асинхронно в режиме интерфейса (Ссылка на [Auto.js Pro](https://g.pro.autojs.org/))
* `Новое` Метод images.requestScreenCapture добавляет параметр опции isAsync для поддержки асинхронного захвата экрана (Ссылка на [Auto.js Pro](https://g.pro.autojs.org/))
* `Новое` images.on('screen_capture', callback) и другие методы прослушивания событий поддерживают прослушивание событий доступности захвата экрана (Ссылка на [Auto.js Pro](https://g.pro.autojs.org/))
* `Новое` Метод images.stopScreenCapture поддерживает активное освобождение ресурсов, связанных с приложениями захвата экрана (Ссылка на [Auto.js Pro](https://g.pro.autojs.org/))
* `Новое` Методы Images.psnr/mse/ssim/mssim/hist/ncc и images.getSimilarity для получения метрик сходства изображений
* `Новое` Метод images.isGrayscale для определения, является ли изображение в градациях серого
* `Новое` Метод images.invert для преобразования изображения в негатив
* `Новое` Методы s13n.point/time для нормализации объектов точки и времени (См. документацию проекта > [Нормализация](https://docs.autojs6.com/#/s13n))
* `Новое` Методы gravity, touchThrough, backgroundTint модуля console (См. документацию проекта > [Консоль](https://docs.autojs6.com/#/console))
* `Новое` Методы Mathx.randomInt/Mathx.randomFloat для возврата случайных целых чисел или чисел с плавающей точкой в указанном диапазоне
* `Новое` Методы app.launchDual/startDualActivity для управления двойным запуском приложений (Требуются права Shizuku или Root) (Экспериментально)
* `Новое` Метод app.kill для принудительного остановки приложения (Требуются права Shizuku или Root)
* `Новое` Метод floaty.getClip для получения содержимого буфера обмена через плавающее окно
* `Исправление` Утечка памяти в View Binding подклассов Fragment (например, [DrawerFragment](https://github.com/SuperMonster003/AutoJs6/blob/17616504ab0bba93b30ab7abc67108ee5253f39a/app/src/main/java/org/autojs/autojs/ui/main/drawer/DrawerFragment.kt#L369) / [ExplorerFragment](https://github.com/SuperMonster003/AutoJs6/blob/17616504ab0bba93b30ab7abc67108ee5253f39a/app/src/main/java/org/autojs/autojs/ui/main/scripts/ExplorerFragment.kt#L48))
* `Исправление` Утечка экземпляра в таких классах, как [ScreenCapture](https://github.com/SuperMonster003/AutoJs6/blob/17616504ab0bba93b30ab7abc67108ee5253f39a/app/src/main/java/org/autojs/autojs/core/image/capture/ScreenCapturer.java#L70) / [ThemeColorPreference](https://github.com/SuperMonster003/AutoJs6/blob/10960ddbee71f75ef80907ad5b6ab42f3e1bf31e/app/src/main/java/org/autojs/autojs/ui/settings/ThemeColorPreference.kt#L21)
* `Исправление` Проблема, вызывающая сбой приложения при запросе разрешений на запись экрана на Android 14+ (от [chenguangming](https://github.com/chenguangming)) _[`pr #242`](http://pr.autojs6.com/242)_
* `Исправление` Проблема, вызывающая сбой приложения при запуске службы на переднем плане на Android 14+
* `Исправление` Проблема с кнопкой запуска в редакторе кода, которая не загорается правильно на Android 14+
* `Исправление` Приложение может работать неправильно после упаковки из-за отсутствия необходимых файлов библиотеки _[`issue #202`](http://issues.autojs6.com/202)_ _[`issue #223`](http://issues.autojs6.com/223)_ _[`pr #264`](http://pr.autojs6.com/264)_
* `Исправление` Сбой приложения при редактировании проекта из-за отсутствия указанных ресурсов значков _[`issue #203`](http://issues.autojs6.com/203)_
* `Исправление` Невозможность правильно использовать параметры для получения ресурсов захвата экрана указанной ориентации при запросе разрешений на запись экрана
* `Исправление` Проблема с некоторыми устройствами, неспособностью правильно добавлять ярлыки для сценариев (Пробная поправка) _[`issue #221`](http://issues.autojs6.com/221)_
* `Исправление` Проблема кумулятивной задержки отправки запросов с методами, связанными с отправкой запросов в HTTP модуле _[`issue #192`](http://issues.autojs6.com/192)_
* `Исправление` Сервис Shizuku может работать неправильно перед тем, как AutoJs6 войдет в главную страницу активности (Пробная поправка) _[`issue #255`](http://issues.autojs6.com/255)_
* `Исправление` Метод random(min, max) может иметь выходящие за пределы результаты
* `Исправление` Проблема, при которой параметр типа результата методов pickup не может корректно пройти пустые массивы
* `Исправление` Проблема, при которой прямоугольник управления, полученный методом UiObject#bounds(), может быть случайно изменен, нарушая его неизменяемость
* `Исправление` Проблема с текстовыми/кнопочными/вводными элементами, где текст, содержащий узкие двойные кавычки, не может быть правильно проанализирован
* `Исправление` Проблема с элементами text/textswitcher, где функция автоссылки атрибута не работает
* `Исправление` Проблема, при которой различные скрипты по ошибке делят один и тот же объект ScriptRuntime
* `Исправление` Проблема, при которой глобальные переменные HEIGHT и WIDTH теряют создаваемые динамически свойства Getter
* `Исправление` Проблема с потенциально высоким временем запуска, вызванным загрузкой RootShell при запуске скрипта
* `Исправление` Проблема с настройкой цвета фона плавающего окна консоли, приводящая к потере стиля закругленного прямоугольника
* `Исправление` Автозапуск службы доступа может сталкиваться с аномальной проблемой службы (Пробная поправка)
* `Исправление` Проблема с триггером изменения ViewPager при проведении по контролю WebView влево или вправо на странице документа домашней страницы
* `Исправление` Проблема с файловым менеджером, который не может распознать расширения файлов, содержащих заглавные буквы
* `Исправление` Файловый менеджер может не распознавать проект автоматически при первом входе в каталог проекта
* `Исправление` Проблема с тем, что страница файлового менеджера не может автоматически обновляться после удаления папки
* `Исправление` Проблема с сортировкой файлов и папок в файловом менеджере, где символы с начальной буквой ASCII размещены в конце
* `Исправление` Исключение 'FAILED ASSERTION' в функции отладки редактора кода
* `Исправление` Проблема возможности неподдерживанием корректной отладки после закрытия редактора во время процесса отладки редактора кода
* `Исправление` Проблема с потенциальным пропуском символов при переходе в конец строки в редакторе кода
* `Исправление` Проблема с мерцанием экрана при запуске страницы активности журнала на главной странице активности
* `Исправление` Проблема с упакованным приложением, не способным корректно использовать модуль opencc
* `Улучшение` Индикация клика для контроля "ABI недоступно" на странице пакета
* `Улучшение` Поддержка использования Shizuku для управления переключателем отображения "Местоположение указателя"
* `Улучшение` Поддержка использования Shizuku для управления переключателями разрешения "Медиа проекции" и "Изменение безопасных настроек"
* `Улучшение` Automator.gestureAsync/gesturesAsync поддерживает параметры функции обратного вызова
* `Улучшение` Модуль tasks использует синхронный метод для операций с базой данных, чтобы избежать потенциальных несоответствий при доступе к данным
* `Улучшение` Сценарий выполнения поддерживает настройку режима разделения символами пайплайна (например, начиная с `"ui|auto";`)
* `Улучшение` Сценарий выполнения поддерживает одиночные и обратные кавычки и позволяет опускать точки с запятой (например, начиная с `'ui';` или `'ui'`)
* `Улучшение` Сценарий выполнения поддерживает быструю импорт встроенных модулей расширения, таких как axios, cheerio и dayjs (например, начиная с `"axios";`)
* `Улучшение` Сценарий выполнения поддерживает параметры x или jsox для быстрого включения встроенных расширений объектов JavaScript (например, начиная с `"x";`)
* `Улучшение` Атрибуты src и path элемента img поддерживают локальные относительные пути (например, `<img src="a.png" />`)
* `Улучшение` Редактор кода поддерживает интеллектуальное определение места вставки при импорте Java классов и пакетов имен
* `Улучшение` Модуль images поддерживает использование путей напрямую в качестве параметров изображений
* `Улучшение` importPackage поддерживает строковые параметры
* `Улучшение` IP-адрес в режиме сервера поддерживает импорт из буфера обмена с интеллектуальным определением и конверсией с пробелом
* `Улучшение` Файловый менеджер поддерживает выбор префиксов по умолчанию при создании новых файлов и автоматически генерирует подходящее числовое расширение
* `Улучшение` Файловый менеджер четко уведомляет об ошибке при выполнении проекта _[`issue #268`](http://issues.autojs6.com/268)_
* `Улучшение` Файловый менеджер поддерживает больше типов и отображает соответствующие значки (поддерживает более 800 типов файлов)
* `Улучшение` Редактируемые типы файлов (jpg/doc/pdf и т.д.) в файловом менеджере добавлены кнопки для редактирования
* `Улучшение` APK-файлы в файловом менеджере поддерживают просмотр базовой информации, информации о манифесте и списке разрешений
* `Улучшение` Мультимедийные аудио/видео файлы в файловом менеджере поддерживают просмотр базовой информации и MediaInfo
* `Улучшение` Упаковка файлов в одном пакете поддерживает автоматическое заполнение стандартизированного имени пакета и индикацию фильтра недопустимого символа
* `Улучшение` Упаковка файлов в одном пакете поддерживает автоматическую настройку значка и автоинкремент номера и имени версии на основе приложений с тем же установленным именем пакета
* `Улучшение` Настройка конфигурации пакета поддерживает опции abis/libs для указания включенной по умолчанию библиотеки и архитектуры ABI
* `Улучшение` Предоставляет предупреждения о релевантных сообщениях, когда настройки abis/libs конфигурационного файла пакета недействительны или недоступны
* `Улучшение` LeakCanary исключен из официального релиза для предотвращения ненужного увеличения
* `Улучшение` Все английские комментарии в исходном коде проекта сопровождаются переводами на упрощенный китайский для улучшения читаемости
* `Улучшение` README и CHANGELOG поддерживают несколько языков (автоматически генерируются скриптом)
* `Улучшение` Улучшить адаптируемость версии скрипта сборки Gradle
* `Улучшение` Изменения версий некоторых зависимостей или локальных библиотек _[`CHANGELOG.md`](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG.md#v660)_

# v6.5.0

###### 2023/12/02

* `Новое` Модуль opencc (см. Документацию проекта > [Конвертация китайских символов](https://docs.autojs6.com/#/opencc)) (см. [LZX284](https://github.com/SuperMonster003/AutoJs6/pull/187/files#diff-8cff73265af19c059547b76aca8882cbaa3209291406f52df1dafbbc78e80c46R268))
* `Новое` Добавлены методы [plus](https://docs.autojs6.com/#/uiObjectType?id=m-plus) и [append](https://docs.autojs6.com/#/uiObjectType?id=m-append) в UiSelector _[`issue #115`](http://issues.autojs6.com/115)_
* `Новое` Добавлена поддержка фильтрации ABI и библиотек на странице упаковки (см. [AutoX](https://github.com/kkevsekk1/AutoX)) _[`issue #189`](http://issues.autojs6.com/189)_
* `Исправление` Проблема с аномально большим размером упакованных приложений (см. [AutoX](https://github.com/kkevsekk1/AutoX) / [LZX284](https://github.com/SuperMonster003/AutoJs6/pull/187/files#diff-d932ac49867d4610f8eeb21b59306e8e923d016cbca192b254caebd829198856R61)) _[`issue #176`](http://issues.autojs6.com/176)_
* `Исправление` Проблема с невозможностью отображения и печати некоторых сообщений об ошибках в упакованных приложениях
* `Исправление` Проблема с отображением пустого значка после выбора значка приложения на странице упаковки
* `Исправление` Проблема с необработанным исключением при инициализации контекста при использовании библиотеки Google OCR MLKit
* `Исправление` Неисправность методов ocr.<u>mlkit/ocr</u>.<u>recognizeText/detect</u>
* `Исправление` Проблема с несоответствием языка отображения текста (например, на странице журнала) языковому параметру приложения
* `Исправление` Проблема с переполнением текста в некоторых языках в пункте меню основного экрана
* `Исправление` Проблема с автоматическим выключением сервиса специальных возможностей без сообщения на некоторых устройствах _[`issue #181`](http://issues.autojs6.com/181)_
* `Исправление` Проблема с аварийным завершением приложения при использовании физических кнопок устройств при включенной службе специальных возможностей на некоторых устройствах (попытка исправления) _[`issue #183`](http://issues.autojs6.com/183)_ _[`issue #186`](http://issues.autojs6.com/186#issuecomment-1817307790)_
* `Исправление` Проблема с некорректной работой функции pickup после перезапуска службы специальных возможностей с помощью auto(true) (попытка исправления) _[`issue #184`](http://issues.autojs6.com/184)_
* `Исправление` Проблема с аварийным завершением приложения при перетаскивании плавающего окна, созданного с помощью модуля floaty (попытка исправления)
* `Исправление` Проблема с невозможностью использования короткого имени параметра в app.startActivity _[`issue #182`](http://issues.autojs6.com/182)_ _[`issue #188`](http://issues.autojs6.com/188)_
* `Исправление` Проблема с исключением при конфликте импортируемых имен и глобальных переменных в importClass _[`issue #185`](http://issues.autojs6.com/185)_
* `Исправление` Проблема с невозможностью использования службы специальных возможностей в Android 7.x
* `Исправление` Проблема с возможной неспособностью использования методов runtime.<u>loadJar/loadDex</u> в Android 14 (попытка исправления)
* `Исправление` Проблема с недоступностью функций "Анализировать диапазон раскладки" и "Анализировать иерархию раскладки" в панели быстрых настроек Android _[`issue #193`](http://issues.autojs6.com/193)_
* `Исправление` Проблема с возможным появлением ANR (в приложении [ANR](https://developer.android.com/topic/performance/vitals/anr)) при автоматической проверке обновлений (попытка исправления) _[`issue #186`](http://issues.autojs6.com/186)_
* `Исправление` Проблема с невозможностью вернуться на рабочую страницу после нажатия кнопки "Вверх" в примерах кода файлового менеджера _[`issue #129`](http://issues.autojs6.com/129)_
* `Исправление` Проблема с отображением кнопки замены в редакторе кода при использовании функции замены
* `Исправление` Проблема с аварийным завершением приложения при долгом нажатии на удалении в редакторе кода (попытка исправления)
* `Исправление` Проблема с кнопкой fx, не отображающей панель быстрого доступа к функциям модуля в редакторе кода
* `Исправление` Проблема с переполнением названий функций кнопок на панели быстрого доступа к функциям модуля редактора кода
* `Улучшение` Панель быстрых функций модуля редактора кода адаптируется к ночному режиму.
* `Улучшение` Стартовая страница упакованного приложения адаптируется к ночному режиму, а размещение значков приложения корректируется.
* `Улучшение` Страница упакованного приложения поддерживает навигацию курсора с помощью клавиши ENTER на программной клавиатуре.
* `Улучшение` Страница упакованного приложения поддерживает переключение состояния выбора всего при нажатии на заголовки ABI и библиотеки.
* `Улучшение` Выбор ABI по умолчанию осуществляется интеллектуально на странице упакованного приложения с добавлением приглашений для неселектируемых элементов.
* `Улучшение` Файловый менеджер корректирует отображение элементов меню в зависимости от типа и характеристик файлов и папок.
* `Улучшение` Контекстное меню для папок в файловом менеджере добавляет опцию упаковки приложений.
* `Улучшение` Когда службы доступности включены, но работают некорректно, аномальное состояние отображается в переключателе ящика на главной странице AutoJs6.
* `Улучшение` Консоль включает подробную информацию о стеке при печати сообщений об ошибках.
* `Улучшение` Изменения версий некоторых зависимостей или локальных библиотек _[`CHANGELOG.md`](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG.md#v650)_

##### Для получения более подробной информации о версиях см. раздел

* [CHANGELOG.md](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG-ru.md)

******

### <a id="project-compilation-and-build"></a>Компиляция и сборка проекта

******

Для отладки или разработки проекта AutoJs6 с открытым исходным кодом можно использовать [Android Studio](https://pro.autojs.org/) (продукт компании [Google](https://www.google.com/)) или [IntelliJ IDEA](https://www.jetbrains.com/idea/) (продукт компании [Jetbrains](https://www.jetbrains.com/)).

В данном разделе приведён пример методов компиляции и сборки для проекта AutoJs6 с использованием Android Studio. IntelliJ IDEA аналогичен.

#### Подготовка Android Studio

Скачайте версию `Android Studio Ladybug Feature Drop | 2024.2.2 RC 2` (выберите одну из них по необходимости):

- [android-studio-2024.2.2.12-windows.exe](https://redirector.gvt1.com/edgedl/android/studio/install/2024.2.2.12/android-studio-2024.2.2.12-windows.exe) (1.14 GB)
- [android-studio-2024.2.2.12-windows.zip](https://redirector.gvt1.com/edgedl/android/studio/ide-zips/2024.2.2.12/android-studio-2024.2.2.12-windows.zip) (1.15 GB)

> Примечание: Указанная версия была выпущена 16 December 2024 г.. Для загрузки других версий или если указанная ссылка недействительна, посетите страницу [архива версий Android Studio](https://developer.android.com/studio/archive?hl=en).

Установите или распакуйте указанные файлы, запустите программное обеспечение Android Studio (например, `"D:\android-studio\bin\studio64.exe"`).

#### Подготовка Android SDK

> Примечание: Если на компьютере уже установлен Android SDK, раздел может быть пропущен.

Используйте сочетание клавиш `CTRL + ALT + S` для открытия страницы настроек в Android Studio:

```text
Appearance & Behavior (Внешний вид и поведение) -> 
System Settings (Системные настройки) -> 
Android SDK (Набор инструментов для разработки Android)
```

Если поле `Местоположение Android SDK (место расположения пакета SDK для Android)` пустое, нажмите кнопку `Редактировать (Edit)` справа и несколько раз нажимайте `Далее (Next)` в появившемся окне.

> Примечание: В процессе может потребоваться согласие с одним или несколькими соответствующими соглашениями для продолжения.

После завершения загрузки и установки соответствующих ресурсов нажмите кнопку `Завершить (Finish)`.  
Местоположение `Android SDK (место расположения пакета SDK для Android)` будет заполнено автоматически, что завершит подготовку SDK.

#### Подготовка инструментов Android SDK

Для работы AutoJs6 требуются некоторые инструменты SDK (например, NDK и CMake).

> Примечание: Если на компьютере уже установлены все необходимые инструменты Android SDK для AutoJs6, раздел может быть пропущен.

Используйте сочетание клавиш `CTRL + ALT + S` для открытия страницы настроек в Android Studio:

```text
Appearance & Behavior (Внешний вид и поведение) -> 
System Settings (Системные настройки) -> 
Android SDK (Набор инструментов для разработки Android) -> 
SDK Tools (SDK Инструменты) (находится в правом окне)
```

Отметьте `Show Package Details (Показать детали пакета)`, затем последовательно выберите NDK и CMake, убедитесь, что соответствующие версии инструментов отмечены, Информация о версиях инструментов SDK находится в файле `version.properties` в корневом каталоге проекта AutoJs6.

#### Подготовка JDK

Для проекта AutoJs6 требуется версия `JDK (Java Development Kit)` не ниже `17`, но рекомендуется не ниже `19`.

По состоянию на 1 January 2025 г. AutoJs6 поддерживает JDK максимальной версии `23`.

> Примечание: Если на компьютере уже установлен JDK и версия соответствует указанным требованиям, этот раздел можно пропустить.

JDK можно скачать непосредственно через IDE или на [сайте Oracle](https://www.oracle.com/java/technologies/downloads/).

В программном обеспечении Android Studio используйте сочетание клавиш `CTRL + ALT + S` для открытия страницы настроек:

```text
Build, Execution, Deployment (Сборка, выполнение, развертывание) -> 
Build Tools (Инструменты сборки) -> 
Gradle
```

В разделе `Gradle JDK` можно выбрать или добавить разные версии JDK.

Если в списке уже существует подходящая версия JDK (>= `17`), выберите её напрямую.  
Либо можно выбрать `Download JDK` для загрузки соответствующего JDK, нажмите кнопку `Download` и дождитесь завершения загрузки.  
Вы также можете выбрать `Add JDK` и добавить уже установленный JDK, указав его путь, для завершения добавления JDK.

#### Клонирование ресурсов AutoJs6

На главной странице Android Studio нажмите кнопку `Get from VCS`.  
В поле `URL` введите `https://github.com/SuperMonster003/AutoJs6.git`,  
В поле `Directory` можно указать нужный путь.  
Нажмите кнопку `Clone`, и дождитесь, пока ресурсы проекта AutoJs6 склонируются на вашем устройстве.

> Примечание: В процессе может потребоваться установка [Git (система управления версиями)](https://git-scm.com/download).

#### Сборка проекта AutoJs6

После завершения клонирования Android Studio откроет окно проекта AutoJs6 и автоматически загрузит начальные зависимости `Dependencies` и выполнит сборку Gradle.

> Примечание: Процесс может занять много времени. При плохом состоянии сети возможно потребуется несколько попыток (нажмите кнопку Retry).

После завершения сборки на вкладке `Build` в Android Studio появится сообщение типа `BUILD SUCCESSFUL in 1h 17m 34s`.

Упакуйте проект и создайте файл APK для установки на устройство Android:

- Отладочная версия (Debug Version)
    - `Build (Сборка)` -> `Build Bundle(s) / APK(s)` -> `Build APK(s)`
    - Создание APK файла с отладочной подписью
    - Пример пути: `"D:\AutoJs6\app\build\outputs\apk\debug\"`
- Релизная версия (Release Version)
    - `Build (Сборка)` -> `Generate Signed Bundle / APK`
    - Выберите опцию `APK`
    - Подготовьте файл подписи (создайте или выберите), создайте подписанный релизный APK файл
    - Пример пути: `"D:\AutoJs6\app\release\"`

> смотрите: [Android Docs](https://developer.android.com/studio/run?hl=zh-cn)

******

### <a id="script-development-assistance"></a>Помощь в разработке скриптов

******

Для разработки скриптов, работающих в AutoJs6, используйте соответствующую среду разработки:

- [VSCode](https://code.visualstudio.com/download) / [WebStorm](https://www.jetbrains.com/webstorm/download/) / [HBuilderX](https://www.dcloud.io/hbuilderx.html) ...

Для написания и отладки скриптов на ПК, плагин VSCode может обеспечить связь между ПК и телефоном:

- [AutoJs6-VSCode-Extension](http://vscext-project.autojs6.com) - Отладчик AutoJs6 (плагин для платформы VSCode)

При написании кода в среде разработки функция автодополнения кода может значительно облегчить процесс разработки:

- [AutoJs6-TypeScript-Declarations](http://dts-project.autojs6.com) - Файлы объявлений AutoJs6 (автодополнение кода)

При написании кода вы можете в любой момент обращаться к документации по API и способам использования AutoJs6:

- [AutoJs6-Documentation](http://docs-project.autojs6.com) - Документация приложения AutoJs6

Существующие проекты по разработке скриптов могут служить источником вдохновения для вашего собственного проекта:

- [Ant-Forest](https://github.com/TonyJiangWJ/Ant-Forest) - Скрипт для автоматической работы с энергией в Ант Форест от [TonyJiangWJ](https://github.com/TonyJiangWJ)
- [Ant-Forest](https://github.com/SuperMonster003/Ant-Forest) - Скрипт для автоматической работы с энергией в Ант Форест от [SuperMonster003](https://github.com/SuperMonster003)
- [autojs](https://github.com/e1399579/autojs) - Утилиты для Auto.js от [e1399579](https://github.com/e1399579)
- [autojsDemo](https://github.com/snailuncle/autojsDemo) - Демонстрационные примеры Auto.js от [snailuncle](https://github.com/snailuncle)
- [Связанные репозитории autojs](https://github.com/topics/autojs) - Все репозитории на GitHub с темой autojs

******

### Вклад участников

******

Благодарим всех участников проекта AutoJs6 за их вклад.

|     <span style="word-break:keep-all;white-space:nowrap">Участники</span>     |                   <span style="word-break:keep-all;white-space:nowrap">Количество коммитов</span>                    | <span style="word-break:keep-all;white-space:nowrap">Последние коммиты</span> |
|:----------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------:|
|     <span style="word-break:keep-all;white-space:nowrap">[luckyloogn](https://github.com/luckyloogn)</span>      |       <span style="word-break:keep-all;white-space:nowrap">[3](https://github.com/SuperMonster003/AutoJs6/commits?author=luckyloogn)</span>        |                    <span style="word-break:keep-all;white-space:nowrap">`2025/01/01`</span>                    |
|           <span style="word-break:keep-all;white-space:nowrap">[kvii](https://github.com/kvii)</span>            |          <span style="word-break:keep-all;white-space:nowrap">[1](https://github.com/SuperMonster003/AutoJs6/commits?author=kvii)</span>           |                    <span style="word-break:keep-all;white-space:nowrap">`2024/10/16`</span>                    |
|  <span style="word-break:keep-all;white-space:nowrap">[chenguangming](https://github.com/chenguangming)</span>   | <span style="word-break:keep-all;white-space:nowrap">[2](https://github.com/SuperMonster003/AutoJs6/pulls?q=is%3Apr+author%3Achenguangming)</span> |                    <span style="word-break:keep-all;white-space:nowrap">`2024/05/14`</span>                    |
|         <span style="word-break:keep-all;white-space:nowrap">[LZX284](https://github.com/LZX284)</span>          |         <span style="word-break:keep-all;white-space:nowrap">[17](https://github.com/SuperMonster003/AutoJs6/commits?author=LZX284)</span>         |                    <span style="word-break:keep-all;white-space:nowrap">`2023/11/19`</span>                    |
|    <span style="word-break:keep-all;white-space:nowrap">[TonyJiangWJ](https://github.com/TonyJiangWJ)</span>     |       <span style="word-break:keep-all;white-space:nowrap">[4](https://github.com/SuperMonster003/AutoJs6/commits?author=TonyJiangWJ)</span>       |                    <span style="word-break:keep-all;white-space:nowrap">`2023/10/31`</span>                    |
| <span style="word-break:keep-all;white-space:nowrap">[little&#x2011;alei](https://github.com/little-alei)</span> |      <span style="word-break:keep-all;white-space:nowrap">[12](https://github.com/SuperMonster003/AutoJs6/commits?author=little-alei)</span>       |                    <span style="word-break:keep-all;white-space:nowrap">`2023/07/12`</span>                    |
|         <span style="word-break:keep-all;white-space:nowrap">[aiselp](https://github.com/aiselp)</span>          |    <span style="word-break:keep-all;white-space:nowrap">[6](https://github.com/SuperMonster003/AutoJs6/pulls?q=is%3Apr+author%3Aaiselp)</span>     |                    <span style="word-break:keep-all;white-space:nowrap">`2023/06/14`</span>                    |
|          <span style="word-break:keep-all;white-space:nowrap">[LYS86](https://github.com/LYS86)</span>           |          <span style="word-break:keep-all;white-space:nowrap">[2](https://github.com/SuperMonster003/AutoJs6/commits?author=LYS86)</span>          |                    <span style="word-break:keep-all;white-space:nowrap">`2023/06/03`</span>                    |

Данные обновлены на 1 January 2025 г..

Данные отсортированы по `последним отправкам` в порядке убывания.

Новые необработанные Pull Request будут учтены в статистике после объединения.

Некоторые участники не отображаются на [GitHub Contributors](https://github.com/SuperMonster003/AutoJs6/graphs/contributors), их записи пусты, но их вклад можно посмотреть через [Pull Request](https://github.com/SuperMonster003/AutoJs6/pulls).

[//]: # (
    # --------------------------------------------------------------#
    # Before committing and pushing to the remote GitHub repository #
    # --------------------------------------------------------------#
    - CHANGELOG.md
        - Update entries for AutoJs6 by checking all changed files
        - Update entries for Gradle plugins [ implementation ]
        - Update version name and released date
        - Append related GitHub issues to changelog entries
    - README.md
        - The summary of the latest changelog for committing to Git [ DO NOT commit or push ]
        - Update badges like [ android studio / rhino / ... ]
        - Update android studio download links and version names
        - Update contribution section
    - Remove the part like [ alpha / beta / ... ] of VERSION_NAME in version.properties
    - Update dependencies TypeScript declarations if needed.
    - Re-generate documentation/markdown by running the python script
    - Check the two-way versions for AutoJs6 and VSCode ext, then publish the ext to Microsoft
    - Run Gradle task "app:assembleInrtRelease"
    - Build APK to determine the final VERSION_BUILD field
    - Run Gradle task "app:appendDigestToReleasedFiles"
    - Commit and push to GitHub
    - Publish the latest release with signed APKs
)