<!--suppress HtmlDeprecatedAttribute, HttpUrlsUsage -->

<div align="center">
  <p>
    <img src="https://s1.imagehub.cc/images/2023/03/07/af8ed087c9d354b9ab6142aae7bbafb6.png" alt="autojs6-banner_800×224" border="0" width="704" />
  </p>

  <p>안드로이드 플랫폼에서 접근성 서비스를 지원하는 JavaScript 자동화 도구</p>

  <p>
    <a href="http://download.autojs6.com"><img alt="GitHub release (latest by date)" src="https://img.shields.io/github/v/release/SuperMonster003/AutoJs6"/></a>
    <a href="http://issues.autojs6.com"><img alt="GitHub closed issues" src="https://img.shields.io/github/issues/SuperMonster003/AutoJs6?color=009688"/></a>
    <a href="http://commit.autojs6.com/99a1d8490fac5b6d55f6f183db59ad833a2064ed"><img alt="Created" src="https://img.shields.io/date/1636632233?color=2e7d32&label=created"/></a>
    <br>
    <a href="https://github.com/mozilla/rhino"><img alt="Rhino" src="https://img.shields.io/badge/rhino-1.7.16--snapshot-A24232"/></a>
    <a href="https://developer.android.com/studio/archive"><img alt="Android Studio" src="https://img.shields.io/badge/android%20studio-2022.1+-B64FC8"/></a>
    <br>
    <a href="https://www.codefactor.io/repository/github/SuperMonster003/AutoJs6"><img alt="CodeFactor Grade" src="https://www.codefactor.io/repository/github/SuperMonster003/AutoJs6/badge"/></a>
    <a href="https://www.jetbrains.com/?from=AutoJs6"><img alt="JetBrains supporter" src="https://img.shields.io/badge/supporter-JetBrains-ee4677"/></a>
    <a href="http://project.autojs6.com/blob/master/LICENSE"><img alt="GitHub License" src="https://img.shields.io/github/license/SuperMonster003/AutoJs6?color=534BAE"/></a>
  </p>
</div>

******

### 언어 (Languages)

******

현재 README.md 파일에서 지원하는 언어:

 - [简体中文 [zh-Hans]](http://project.autojs6.com/blob/master/.readme/README-zh-Hans.md)
 - [繁體中文 (香港) [zh-Hant-HK]](http://project.autojs6.com/blob/master/.readme/README-zh-Hant-HK.md)
 - [繁體中文 (台灣) [zh-Hant-TW]](http://project.autojs6.com/blob/master/.readme/README-zh-Hant-TW.md)
 - [English [en]](http://project.autojs6.com/blob/master/.readme/README-en.md)
 - [Français [fr]](http://project.autojs6.com/blob/master/.readme/README-fr.md)
 - [Español [es]](http://project.autojs6.com/blob/master/.readme/README-es.md)
 - [日本語 [ja]](http://project.autojs6.com/blob/master/.readme/README-ja.md)
 - 한국어 [ko] # 현재
 - [Русский [ru]](http://project.autojs6.com/blob/master/.readme/README-ru.md)
 - [العربية [ar]](http://project.autojs6.com/blob/master/.readme/README-ar.md)

******

### 소개

******

[Auto.js](https://github.com/hyb1996/Auto.js) Android 플랫폼에서 [접근성 서비스](https://developer.android.com/guide/topics/ui/accessibility/service?hl=zh-cn)를 지원하는 JavaScript 자동화 도구 소프트웨어입니다.

Auto.js는 [hyb1996](https://github.com/hyb1996)에 의해 `2017/01/27` 처음 출시되었으며, `2020/03/13` 에 유지보수가 중단되었고, 최종 버전 이름은 `4.1.1 Alpha2`, 빌드 버전 번호는 `461`입니다.

AutoJs6는 Auto.js 최종 프로젝트를 기반으로 `2021/12/01`에 다시 개발되어 계속해서 오픈 소스로 무료로 유지됩니다.

다음 표는 일부 Auto.js 관련 프로젝트를 나열한 것입니다 (개발 날짜 순으로 정렬됨):

| <span style="word-break:keep-all;white-space:nowrap">프로젝트</span> |                                                             <span style="word-break:keep-all;white-space:nowrap">앱 이름</span>                                                              | <span style="word-break:keep-all;white-space:nowrap">개발자</span> | <span style="word-break:keep-all;white-space:nowrap">개발 시작 날짜</span> | <span style="word-break:keep-all;white-space:nowrap">개발 종료 날짜</span> |
|:------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------:|:---------------------------------------------------------------------------------------------------------------------------------:|:-------------------------------------------------------------------------------------------------------------------------------:|
|     <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/hyb1996/Auto.js)</span>      |    <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/TonyJiangWJ/Auto.js/commit/268ec8895bbfa28fc7715154eb15b1c1eaaefd14#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span>     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2017/01/27`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2020/03/13`</span>                             |
|                     <span style="word-break:keep-all;white-space:nowrap">Auto.js Pro 7</span>                      |                                                                                     <span style="word-break:keep-all;white-space:nowrap">Auto.js</span>                                                                                      |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2019/03/13`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2019/07/08`</span>                             |
|                     <span style="word-break:keep-all;white-space:nowrap">Auto.js Pro 8</span>                      |                                                                                    <span style="word-break:keep-all;white-space:nowrap">AutoJsPro</span>                                                                                     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2019/10/13`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2021/07/24`</span>                             |
|   <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/TonyJiangWJ/Auto.js)</span>    | <span style="word-break:keep-all;white-space:nowrap">[Auto.js&#160;M](https://github.com/TonyJiangWJ/Auto.js/commit/268ec8895bbfa28fc7715154eb15b1c1eaaefd14#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span> |      <span style="word-break:keep-all;white-space:nowrap">[TonyJiangWJ](https://github.com/TonyJiangWJ)</span>       |                             <span style="word-break:keep-all;white-space:nowrap">`2019/11/21`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|      <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/kkevsekk1/AutoX)</span>       |                 <span style="white-space:pre">[Autox.js](https://github.com/kkevsekk1/AutoX/commit/8143e4ed893d4af05d22aa791b83a962f9959873#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span>                  |        <span style="word-break:keep-all;white-space:nowrap">[kkevsekk1](https://github.com/kkevsekk1)</span>         |                             <span style="word-break:keep-all;white-space:nowrap">`2020/07/24`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|        <span style="word-break:keep-all;white-space:nowrap">[Auto.js Pro 9](https://pro.autojs.org/)</span>        |                                                                                    <span style="word-break:keep-all;white-space:nowrap">AutoJsPro</span>                                                                                     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2021/03/28`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2023/02/09`</span>                             |
| <span style="word-break:keep-all;white-space:nowrap">[AutoJs6](https://github.com/SuperMonster003/AutoJs6)</span>  |  <span style="word-break:keep-all;white-space:nowrap">[AutoJs6](https://github.com/SuperMonster003/AutoJs6/commit/a8ce1b9acb541e9736c33134be3194c3148a15a3#diff-833a46a97033e77558372a2dce103fd6fee29aaaa899f610022a7aece592ee7bR27)</span>  |  <span style="word-break:keep-all;white-space:nowrap">[SuperMonster003](https://github.com/SuperMonster003)</span>   |                             <span style="word-break:keep-all;white-space:nowrap">`2021/12/01`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|      <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/kkevsekk1/AutoX)</span>       |            <span style="white-space:pre">[Autox.js&#160;v6](https://github.com/kkevsekk1/AutoX/commit/8b6776cff8b0fca4be4a52719b7d7d07c0a058f3#diff-51a0b488f963eb0be6c6599bf5df497313877cf5bdff3950807373912ac1cdc9R130)</span>             |           <span style="word-break:keep-all;white-space:nowrap">[wilinz](https://github.com/wilinz)</span>            |                             <span style="word-break:keep-all;white-space:nowrap">`2022/05/26`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|      <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/kkevsekk1/AutoX)</span>       |            <span style="white-space:pre">[Autox.js&#160;v7](https://github.com/kkevsekk1/AutoX/commit/484491fd5fe12b8203d0b09c181eb0f471c0ea9f#diff-8cff73265af19c059547b76aca8882cbaa3209291406f52df1dafbbc78e80c46R120)</span>             |           <span style="word-break:keep-all;white-space:nowrap">[aiselp](https://github.com/aiselp)</span>            |                             <span style="word-break:keep-all;white-space:nowrap">`2024/04/21`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |

표에 표시된 날짜는 예상 날짜로, 실제 날짜와 다를 수 있습니다.

표에 나열된 Auto.js Pro 7/8/9 는 유료 버전이며, 그 외는 무료 오픈 소스 버전입니다.

******

### 기능

******

* JavaScript IDE로 사용 가능 (코드 자동 완성/변수 이름 변경/코드 포맷팅)
* [접근성 서비스](https://developer.android.com/reference/android/accessibilityservice/AccessibilityService)를 기반으로 한 자동화 작업 지원
* 플로팅 버튼 단축 작업 지원 (스크립트 녹화 및 실행/패키지명 및 활동 보기/레이아웃 분석)
* 선택기 API 지원 및 컨트롤 탐색/정보 가져오기/컨트롤 작업 지원 ( [UiAutomator](https://developer.android.com/training/testing/ui-automator)와 유사)
* 레이아웃 화면 분석 지원 (안드로이드 스튜디오의 LayoutInspector와 유사)
* 녹화 기능 및 녹화 재생 지원
* 스크린샷 찍기/스크린샷 저장/이미지 색상 찾기/이미지 매칭 지원
* [E4X](https://zh.wikipedia.org/wiki/E4X) (ECMAScript for XML) 인터페이스 작성 지원
* 스크립트 파일 또는 프로젝트를 APK 파일로 패키징 지원
* Root 권한을 이용한 기능 확장 지원 (화면 클릭/스크롤/녹화/Shell)
* Tasker 플러그인으로 사용 가능
* VSCode와 연결하여 데스크톱 개발 지원 ( [AutoJs6-VSCode-Extension](http://vscext-project.autojs6.com) 플러그인 필요)

******

### 환경

******

- Android 운영 체제
- [API](https://developer.android.com/guide/topics/manifest/uses-sdk-element#ApiLevels) [24](https://developer.android.com/reference/android/os/Build.VERSION_CODES#N) ([7.0](https://zh.wikipedia.org/wiki/Android_Nougat)) [[N](https://developer.android.com/reference/android/os/Build.VERSION_CODES#N)] 이상

******

### 매뉴얼

******

* [문서](https://docs.autojs6.com)
* [사용 설명서 (작성 중)](https://docs.autojs6.com/#/manual)
* [문제 해결](https://docs.autojs6.com/#/qa)
* [프로젝트 컴파일 및 빌드](#project-compilation-and-build)
* [스크립트 개발 지원](#script-development-assistance)

******

### 주요 변경 사항

******

Auto.js 최종 오픈 소스 버전 `4.1.1 Alpha2`와 비교하여 AutoJs6는 주요한 다음과 같은 업그레이드 및 변동사항이 있습니다:

* [Shizuku](https://shizuku.rikka.app/introduction/)를 통해 ADB 특권을 얻고 시스템 API 사용 지원
* [WebSocket](https://docs.autojs6.com/#/webSocketType) 인스턴스를 생성하여 [WebSocket 프로토콜](https://zh.wikipedia.org/wiki/WebSocket)에 기반한 네트워크 요청 지원
* 새로운 모듈 추가 [ [base64](https://docs.autojs6.com/#/base64) / [crypto](https://docs.autojs6.com/#/crypto) / [sqlite](https://docs.autojs6.com/#/sqlite) / [i18n](https://docs.autojs6.com/#/i18n) / [notice](https://docs.autojs6.com/#/notice) / [ocr](https://docs.autojs6.com/#/ocr) / [opencc](https://docs.autojs6.com/#/opencc) / [qrcode](https://docs.autojs6.com/#/qrcode) / [shizuku](https://docs.autojs6.com/#/shizuku) / ... ]
* 다국어 지원 [ 서 / 프 / 러 / 아 / 일 / 한 / 영어 / 중국어 / 번체 중 ... ]
* 야경 모드 지원 [ 설정 페이지 / 문서 페이지 / 레이아웃 분석 페이지 / 플로팅 창 / ... ]
* [VSCode 플러그인](http://vscext-project.autojs6.com) 지원 클라이언트 (LAN) 및 서버 (LAN/ADB) 연결 방식
* [Rhino](https://github.com/mozilla/rhino/) 엔진을 [v1.7.7.2](https://github.com/mozilla/rhino/releases/tag/Rhino1_7_7_2_Release)에서 [v1.7.16-SNAPSHOT](http://rhino.autojs6.com/blob/master/gradle.properties#L3)로 업그레이드
    * 유니코드 [코드 포인트](https://developer.mozilla.org/zh-CN/docs/Glossary/Code_point) 이스케이프 지원 [보조 평면](https://zh.wikipedia.org/wiki/Unicode%E5%AD%97%E7%AC%A6%E5%B9%B3%E9%9D%A2%E6%98%A0%E5%B0%84#%E7%AC%AC%E4%B8%80%E8%BC%94%E5%8A%A9%E5%B9%B3%E9%9D%A2) 문자
       ```javascript
       '\u{1D160}'; /* 의 의미 "𝅘𝅥𝅮", 전통적인 방법: '\uD834\uDD60'. */
       ```
    * [Object.values()](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Global_Objects/Object/values) 지원
       ```javascript
       Object.values({name: 'Max', age: 4}); // ['max', 4]
       ```
    * [Array.prototype.includes()](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Global_Objects/Array/includes) 지원
       ```javascript
       [10, 20, NaN].includes(20); // true
       ```
    * [BigInt](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Global_Objects/BigInt) 지원
       ```javascript
       typeof 567n === 'bigint'; // true
       ```
    * [템플릿 문자열](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Template_literals) 지원
       ```javascript
       `Lucky number: ${(Math.random() * 100).toFixed(0)}`
       ```
    * Rhino 엔진의 [더 많은 새로운 기능](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/RHINO.md) 보기
    * Rhino 엔진 [호환성 목록](https://mozilla.github.io/rhino/compat/engines.html) 보기

******

### 버전 역사

******

# v6.6.1

###### 2025/01/01

* `추가` 중국어 병음 변환을 위한 Pinyin 모듈 (프로젝트 문서 참고 > [중국어 병음](https://docs.autojs6.com/#/pinyin))
* `추가` 중국어 병음 변환을 위한 Pinyin4j 모듈 (프로젝트 문서 참고 > [중국어 병음](https://docs.autojs6.com/#/pinyin4j))
* `추가` 컨트롤 또는 컨트롤 컬렉션이 유사한지 여부를 확인하는 UiObject#isSimilar 및 UiObjectCollection#isSimilar 메서드
* `추가` "currentComponent" 전역 메서드로, 현재 활성화된 구성 요소의 이름 정보를 가져오는 데 사용됩니다
* `수정` 일부 환경에서 이전 버전으로 롤백하여 프로젝트가 정상적으로 컴파일되지 않는 문제
* `수정` 존재하지 않는 메서드를 호출할 때 발생할 수 있는 "비원시 값" 예외
* `수정` 일부 기기에서 스크립트 바로가기를 정상적으로 추가할 수 없는 문제 (임시 수정) _[`issue #221`](http://issues.autojs6.com/221)_
* `수정` automator.click/longClick 메서드의 파라미터 유형 제한 오류 _[`issue #275`](http://issues.autojs6.com/275)_
* `수정` 선택자가 ConsString 유형의 파라미터를 지원하지 않는 문제 _[`issue #277`](http://issues.autojs6.com/277)_
* `수정` UiObjectCollection 인스턴스에서 메서드 및 속성이 누락된 문제
* `개선` 패키징 페이지에서 서명 구성, 키 저장소 관리 및 권한 설정을 지원합니다. ([luckyloogn]()) _[`pr #286`]()_
* `개선` 플로팅 윈도우의 현재 패키지 이름 및 현재 활동 이름의 인식 정확도가 향상되었습니다 (우선 순위: Shizuku > Root > A11Y)
* `개선` currentPackage 및 currentActivity의 인식 정확도가 향상되었습니다 (우선 순위: Shizuku > Root > A11Y)
* `개선` 로그 활동 창의 개별 항목 텍스트 내용을 더블 클릭 또는 길게 눌러 선택하는 기능 복원 _[`issue #280`](http://issues.autojs6.com/280)_
* `개선` project.json 파일이 손상된 경우에도 가능한 한 중요한 정보를 복원
* `개선` 단일 파일을 패키징할 때 자동 생성된 패키지 이름 접미사를 간체자로부터 병음으로 변환 (다음 음도 지원)
* `개선` UiSelector#findOnce 및 UiSelector#find 메서드에서 음수 인수 지원
* `개선` app.startActivity/startDualActivity 메서드의 적응성이 향상되었습니다
* `개선` UI 요소 및 className 관련 선택자가 RecyclerView, Snackbar 등과 같은 더욱 다양한 패키지 이름 접두사 생략 형식을 지원
* `개선` Rhino 엔진의 최신 업스트림 코드를 동기화하고 기존 프로젝트에 맞게 조정합니다
* `개선` 일부 의존성 또는 로컬 라이브러리 버전 조정 _[`CHANGELOG.md`](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG.md#v661)_

# v6.6.0

###### 2024/12/02 - 내장 모듈 재작성, 신중한 업그레이드 필요

* `힌트` 기존 모듈이 스크립트 실행 효율성을 높이기 위해 Kotlin으로 재작성되었으나, 개선을 위한 몇 가지 반복이 필요합니다
* `힌트` 내장된 init.js 파일은 기본적으로 비어 있지만, 개발자가 사용자 정의를 위해 모듈을 마운트할 수 있습니다
* `추가` axios 모듈 / cheerio 모듈 ([AutoX](https://github.com/kkevsekk1/AutoX) 참조)
* `추가` sqlite 모듈, SQLite 데이터베이스 간단 조작에 사용됩니다 ([Auto.js Pro](https://g.pro.autojs.org/) 참조) (프로젝트 문서 > [SQLite](https://docs.autojs6.com/#/sqlite) 참조)
* `추가` mime 모듈, MIME 유형 문자열을 처리하고 구문 분석하는 데 사용됩니다 (프로젝트 문서 > [MIME](https://docs.autojs6.com/#/mime) 참조)
* `추가` nanoid 모듈, 문자열 ID 생성기로 사용할 수 있습니다 ([ai/nanoid](https://github.com/ai/nanoid) 참조)
* `추가` sysprops 모듈, 런타임 환경의 구성 데이터를 얻는 데 사용됩니다 (프로젝트 문서 > [시스템 속성](https://docs.autojs6.com/#/sysprops) 참조)
* `추가` ocr 모듈은 [Rapid OCR](https://github.com/RapidAI/RapidOCR) 엔진을 지원합니다
* `추가` 레이아웃 분석은 창 전환을 지원합니다 (Auto.js Pro
* `추가` auto.clearCache 메소드는 제어 캐시를 지우는 것을 지원합니다 (Auto.js Pro
* `추가` threads.pool 메소드는 간단한 스레드 풀 응용 프로그램을 지원합니다 (Auto.js Pro
* `추가` images.matchTemplate 메소드는 useTransparentMask 옵션 매개변수를 추가하여 투명 이미지 검색을 지원합니다 (Auto.js Pro
* `추가` images.requestScreenCaptureAsync 메소드는 UI 모드에서 비동기적으로 스크린 캡처 권한을 요청하는 데 사용됩니다  (Auto.js Pro
* `추가` images.requestScreenCapture 메소드는 isAsync 옵션 매개변수를 추가하여 비동기적으로 스크린 캡처를 획득하는 것을 지원합니다 (Auto.js Pro
* `추가` images.on('screen_capture', callback) 등의 이벤트 리스닝 메소드는 스크린 캡처가 사용 가능 이벤트를 모니터링하는 것을 지원합니다 (Auto.js Pro
* `추가` images.stopScreenCapture 메소드는 스크린 캡처 요청과 관련된 리소스를 적극 해제하는 것을 지원합니다 (Auto.js Pro
* `추가` images.psnr/mse/ssim/mssim/hist/ncc 및 images.getSimilarity 메소드는 이미지 유사성 측정값을 얻는 데 사용됩니다
* `추가` images.isGrayscale 메소드는 이미지가 그레이스케일인지 여부를 결정하는 데 사용됩니다
* `추가` images.invert 메소드는 이미지의 색상을 반전하는 데 사용됩니다
* `추가` s13n.point/time 메소드는 포인트 객체와 시간 객체를 정규화하는 데 사용됩니다 (프로젝트 문서 > [정규화](https://docs.autojs6.com/#/s13n) 참조)
* `추가` console 모듈의 gravity (중력), touchThrough (터치 스루), backgroundTint (배경 색조) 등의 관련 메소드 (프로젝트 문서 > [콘솔](https://docs.autojs6.com/#/console) 참조)
* `추가` Mathx.randomInt/Mathx.randomFloat 메소드는 주어진 범위 내의 난수 또는 랜덤 부동 소수점을 반환하는 데 사용됩니다
* `추가` app.launchDual/startDualActivity 등의 메소드는 듀얼 실행 애플리케이션 처리를 위해 사용됩니다 (Shizuku 또는 Root 권한이 필요) (실험적)
* `추가` app.kill 메소드는 애플리케이션을 강제로 종료하는 데 사용됩니다 (Shizuku 또는 Root 권한이 필요)
* `추가` floaty.getClip 메소드는 플로팅 창의 포커스를 통해 클립보드 내용을 간접적으로 얻는 데 사용됩니다
* `수정` Fragment 하위 클래스 (예: [DrawerFragment](https://github.com/SuperMonster003/AutoJs6/blob/17616504ab0bba93b30ab7abc67108ee5253f39a/app/src/main/java/org/autojs/autojs/ui/main/drawer/DrawerFragment.kt#L369) / [ExplorerFragment](https://github.com/SuperMonster003/AutoJs6/blob/17616504ab0bba93b30ab7abc67108ee5253f39a/app/src/main/java/org/autojs/autojs/ui/main/scripts/ExplorerFragment.kt#L48) 등) 내의 View Binding 메모리 누수
* `수정` [ScreenCapture](https://github.com/SuperMonster003/AutoJs6/blob/17616504ab0bba93b30ab7abc67108ee5253f39a/app/src/main/java/org/autojs/autojs/core/image/capture/ScreenCapturer.java#L70) / [ThemeColorPreference](https://github.com/SuperMonster003/AutoJs6/blob/10960ddbee71f75ef80907ad5b6ab42f3e1bf31e/app/src/main/java/org/autojs/autojs/ui/settings/ThemeColorPreference.kt#L21) 등의 클래스 내의 인스턴스 메모리 누수
* `수정` Android 14+에서 스크린 캡처 권한을 요청할 때 앱이 충돌하는 문제 (by [chenguangming](https://github.com/chenguangming)) _[`pr #242`](http://pr.autojs6.com/242)_
* `수정` Android 14+에서 포어그라운드 서비스를 시작할 때 앱이 충돌하는 문제
* `수정` Android 14+에서 코드 에디터에서 실행 버튼을 클릭해도 점등되지 않는 문제
* `수정` 프로젝트 패키징 후 필요한 라이브러리 파일이 부족하여 앱이 정상적으로 실행되지 않을 수 있는 문제 _[`issue #202`](http://issues.autojs6.com/202)_ _[`issue #223`](http://issues.autojs6.com/223)_ _[`pr #264`](http://pr.autojs6.com/264)_
* `수정` 프로젝트 편집 시 지정된 아이콘 리소스가 없는 경우 앱이 충돌하는 문제 _[`issue #203`](http://issues.autojs6.com/203)_
* `수정` 스크린 캡처 권한 획득 시 지정된 화면 방향의 스크린샷 리소스를 매개변수로 얻지 못할 수 있는 문제
* `수정` 일부 기기에서 스크립트 바로가기를 정상적으로 추가할 수 없는 문제 (시도 수정) _[`issue #221`](http://issues.autojs6.com/221)_
* `수정` http 모듈 및 관련 메소드를 호출할 때 축적된 요청으로 인해 전송 지연이 발생하는 문제 _[`issue #192`](http://issues.autojs6.com/192)_
* `수정` AutoJs6가 메인 액티비티 페이지에 들어가기 전에 Shizuku 서비스가 정상적으로 사용할 수 없는 문제 (시도 수정) _[`issue #255`](http://issues.autojs6.com/255)_
* `수정` random(min, max) 메소드에서 결과가 오버플로우할 가능성이 있는 문제
* `수정` pickup 메소드의 결과형 매개변수가 빈 배열을 올바르게 전달할 수 없는 문제
* `수정` UiObject#bounds()에서 얻은 컨트롤 경계가 의도와 다르게 변경될 수 있는 문제
* `수정` text/button/input 요소의 텍스트 내용에 하프 사이즈의 이중 따옴표가 포함된 경우 올바르게 구문 분석되지 않는 문제
* `수정` text/textswitcher 요소의 autoLink 속성이 작동하지 않는 문제
* `수정` 다른 스크립트가 동일한 ScriptRuntime 객체를 잘못 공유할 가능성이 있는 문제
* `수정` 전역 변수 HEIGHT 및 WIDTH가 Getter 동적 속성을 잃는 문제
* `수정` 스크립트 시작 시 RootShell이 즉시 로드되어 시작이 느려지는 문제
* `수정` 콘솔 플로팅 창에서 배경색을 설정하면 사각형의 모서리가 사라지는 문제
* `수정` 서비스 이상 문제를 일으킬 수 있는 접근성 서비스의 자동 시작 (시도 수정)
* `수정` 홈페이지의 문서 페이지에서 왼쪽 또는 오른쪽으로 이동할 때 WebView 컨트롤이 ViewPager 전환을 유발할 수 있는 문제
* `수정` 파일 확장명이 대문자를 포함하는 경우 파일 관리자에서 인식하지 않는 문제
* `수정` 파일 관리자가 프로젝트 디렉토리에 처음 들어갔을 때 프로젝트를 자동으로 인식하지 못할 수 있는 문제
* `수정` 파일 관리자에서 폴더를 삭제 후 페이지가 자동 갱신되지 않는 문제
* `수정` 파일 관리자에서 파일 및 폴더를 정렬할 때 ASCII의 선행 문자명을 멀리 두는 문제
* `수정` 코드 편집기의 디버그 기능에서 FAILED ASSERTION 예외 발생
* `수정` 코드 편집기에서 디버그 중 편집기를 닫은 후 다시 정상적으로 디버그할 수 없는 문제
* `수정` 코드 편집기에서 행의 끝으로 이동할 때 끝 문자 누락 가능성 있는 문제
* `수정` 메인 액티비티 페이지에서 로그 액티비티 페이지를 실행할 때 플래시 스크린 문제 발생 가능성
* `수정` 앱 패키지가 opencc 모듈을 정상적으로 사용할 수 없는 문제
* `개선` 패키지 페이지 내 '사용 불가 ABI' 컨트롤의 클릭 힌트 사용자 경험
* `개선` Shizuku를 사용하여 '포인터 위치' 디스플레이 스위치를 제어하는 것을 지원
* `개선` Shizuku를 사용하여 '미디어 프로젝션' 및 '보안 설정 수정' 권한 스위치를 제어하는 것을 지원
* `개선` automator.gestureAsync/gesturesAsync가 콜백 함수 매개변수를 지원
* `개선` tasks 모듈이 동기화 방식으로 데이터베이스 작업을 수행하는 것을 지원, 데이터 액세스의 불일치 문제 방지
* `개선` 스크립트 실행 모드가 파이프 기호로 구분된 모드 매개변수 (예: 'ui|auto';처럼 시작)를 지원
* `개선` 스크립트 실행 모드가 싱글 쿼테이션 및 백틱을 지원하여 세미콜론 생략 (예: 'ui'; 또는 'ui'처럼 시작) 가능
* `개선` 스크립트 실행 모드가 axios, cheerio, dayjs 등의 모드 매개변수로 내장 확장 모듈의 빠른 가져오기를 지원 (예: 'axios';처럼 시작)
* `개선` 스크립트 실행 모드가 x 또는 jsox 모드 매개변수로 JavaScript 내장 객체 확장 모듈의 빠른 활성화를 지원 (예: 'x';처럼 시작)
* `개선` img 요소의 src 및 path 속성이 로컬 상대 경로를 지원 (예: '<img src="a.png" />'처럼)
* `개선` 코드 편집기에서 Java 클래스나 패키지명을 가져오는 위치의 지능형 판단을 지원
* `개선` images 모듈이 이미지 매개변수로 경로의 직접 사용을 지원
* `개선` importPackage가 문자열 매개변수를 지원
* `개선` 서버 모드의 IP 주소가 클립보드 가져오기를 스마트하게 인식하고, 스페이스 키 스마트 변환을 지원
* `개선` 파일 관리자가 새 파일을 생성할 때 기본 접두사 선택 및 적절한 숫자 접미사의 자동 생성을 지원
* `개선` 파일 관리 프로젝트 실행 시 예외 메시지 구체화 _[`issue #268`](http://issues.autojs6.com/268)_
* `개선` 파일 관리자가 더 많은 유형을 지원하고, 해당 아이콘 심볼을 표시 (800 이상의 파일 타입 지원)
* `개선` 파일 관리자에서 편집 가능한 파일 타입(jpg/doc/pdf...)에 편집 버튼 추가
* `개선` 파일 관리자가 APK 파일의 기본 정보, Manifest 정보 및 권한 목록을 표시하는 것을 지원
* `개선` 파일 관리자가 오디오 및 비디오 같은 미디어 파일의 기본 정보 및 MediaInfo 정보를 표시하는 것을 지원
* `개선` 단일 파일 패키징 시 적절한 정규화 이름 패키지를 자동 입력하며, 유효하지 않은 문자 필터링을 권장
* `개선` 단일 파일 패키징 시 동일한 패키지 이름의 앱이 설치된 경우 아이콘을 자동 설정하고, 버전 번호와 버전명을 증가시키는 것을 지원
* `개선` 패키지 프로젝트 설정 파일이 abis/libs 옵션을 지원하고, 기본적으로 포함되는 ABI 아키텍처와 확장 라이브러리를 지정
* `개선` 패키지 프로젝트 설정 파일의 abis/libs 옵션이 무효하거나 사용할 수 없을 때 관련 메시지를 지원
* `개선` 불필요한 증가 방지를 위해 릭 캐너리를 릴리스 버전에서 제외
* `개선` 프로젝트 소스 코드 내 모든 영어 주석에 한국어 번역 추가하여 읽기 쉬운 주석 개선
* `개선` README 및 CHANGELOG에 여러 언어 지원 (스크립트를 통한 자동 생성)
* `개선` Gradle 빌드 스크립트의 버전 적응 능력을 개선
* `개선` 일부 의존성 또는 로컬 라이브러리 버전 조정 _[`CHANGELOG.md`](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG.md#v660)_

# v6.5.0

###### 2023/12/02

* `추가` opencc 모듈 (프로젝트 문서 > [중국어 변환](https://docs.autojs6.com/#/opencc)) (참조 [LZX284](https://github.com/SuperMonster003/AutoJs6/pull/187/files#diff-8cff73265af19c059547b76aca8882cbaa3209291406f52df1dafbbc78e80c46R268))
* `추가` UiSelector에 [plus](https://docs.autojs6.com/#/uiObjectType?id=m-plus) 및 [append](https://docs.autojs6.com/#/uiObjectType?id=m-append) 메소드 추가 _[`issue #115`](http://issues.autojs6.com/115)_
* `추가` 번들 앱 페이지에 ABI 및 라이브러리 필터링 지원 추가 (참조 [AutoX](https://github.com/kkevsekk1/AutoX)) _[`issue #189`](http://issues.autojs6.com/189)_
* `수정` 번들 앱 파일 크기 비정상적으로 큰 문제 (참조 [AutoX](https://github.com/kkevsekk1/AutoX) / [LZX284](https://github.com/SuperMonster003/AutoJs6/pull/187/files#diff-d932ac49867d4610f8eeb21b59306e8e923d016cbca192b254caebd829198856R61)) _[`issue #176`](http://issues.autojs6.com/176)_
* `수정` 번들 앱이 일부 예외 메시지를 표시하지 못하고 인쇄하지 않는 문제
* `수정` 번들 앱 페이지에서 앱 아이콘을 선택한 후 빈 아이콘이 표시될 수 있는 문제
* `수정` 번들 앱이 MLKit Google OCR 라이브러리를 포함할 때 발생할 수 있는 초기화되지 않은 컨텍스트 예외
* `수정` ocr.<u>mlkit/ocr</u>.<u>recognizeText/detect</u> 메소드가 작동하지 않는 문제
* `수정` 일부 텍스트 (로그 페이지 등)의 언어가 앱 설정 언어와 일치하지 않는 문제
* `수정` 홈페이지 드로워 스위치 항목에서 일부 언어가 글자 넘침 현상이 발생할 수 있는 문제
* `수정` 일부 장치에서 접근성 서비스가 켜진 후 즉시 자동으로 꺼지고 아무 메시지도 표시되지 않는 문제 _[`issue #181`](http://issues.autojs6.com/181)_
* `수정` 일부 장치에서 접근성 서비스가 켜진 후 물리 버튼이 앱 충돌을 유발하는 문제 (시도됨) _[`issue #183`](http://issues.autojs6.com/183)_ _[`issue #186`](http://issues.autojs6.com/186#issuecomment-1817307790)_
* `수정` auto(true)로 접근성 서비스를 다시 시작한 후 발생하는 pickup 기능 오류 문제 (시도됨) _[`issue #184`](http://issues.autojs6.com/184)_
* `수정` floaty 모듈에서 떠있는 창을 만들 때 발생할 수 있는 앱 충돌 문제 (시도됨)
* `수정` app.startActivity에서 약칭 매개변수를 사용할 수 없는 문제 _[`issue #182`](http://issues.autojs6.com/182)_ _[`issue #188`](http://issues.autojs6.com/188)_
* `수정` importClass를 사용할 때 클래스 이름이 전역 변수와 충돌하면 코드가 예외를 발생시키는 문제 _[`issue #185`](http://issues.autojs6.com/185)_
* `수정` Android 7.x에서 접근성 서비스를 사용할 수 없는 문제
* `수정` Android 14에서 runtime.<u>loadJar/loadDex</u> 메소드가 정상적으로 작동하지 않는 문제 (시도됨)
* `수정` 안드로이드 시스템의 빠른 설정 패널에서 "레이아웃 범위 분석" 및 "레이아웃 계층 분석"을 사용할 수 없는 문제 _[`issue #193`](http://issues.autojs6.com/193)_
* `수정` 자동 업데이트 검사가 앱 [ANR](https://developer.android.com/topic/performance/vitals/anr)을 유발할 수 있는 문제 (시도됨) _[`issue #186`](http://issues.autojs6.com/186)_
* `수정` 파일 관리자에서 샘플 코드 폴더 클릭 후 '위로' 버튼을 클릭 시 작업 디렉터리 페이지로 돌아가지 않는 문제 _[`issue #129`](http://issues.autojs6.com/129)_
* `수정` 코드 편집기의 바꾸기 기능 사용 시 바꾸기 버튼이 표시되지 않는 문제
* `수정` 코드 편집기에서 길게 눌러 삭제 시 앱 충돌 문제가 발생할 수 있는 문제 (시도됨)
* `수정` 코드 편집기에서 fx 버튼 클릭 시 모듈 함수 빠른 선택 패널이 표시되지 않는 문제
* `수정` 코드 편집기 모듈 함수 빠른 선택 패널에 표시되는 함수 이름이 넘칠 수 있는 문제
* `개선` 코드 편집기 모듈의 빠른 기능 패널이 야간 모드에 적응합니다.
* `개선` 포장된 애플리케이션의 시작 페이지가 야간 모드에 적응하고 애플리케이션 아이콘의 레이아웃이 조정됩니다.
* `개선` 포장된 애플리케이션 페이지는 소프트웨어 키보드의 ENTER 키를 사용하여 커서 내비게이션을 지원합니다.
* `개선` 포장된 애플리케이션 페이지는 ABI 및 라이브러리 제목을 클릭하여 전체 선택 상태를 토글할 수 있습니다.
* `개선` 포장된 애플리케이션 페이지의 기본 ABI 선택은 비선택 항목에 대한 가이드 프롬프트가 추가된 지능형 방식으로 이루어집니다.
* `개선` 파일 관리자에서는 파일 및 폴더의 유형 및 특성에 따라 메뉴 항목의 표시가 조정됩니다.
* `개선` 파일 관리자의 폴더 마우스 오른쪽 클릭 메뉴에 애플리케이션 포장 옵션이 추가됩니다.
* `개선` 접근성 서비스가 활성화되었지만 제대로 작동하지 않는 경우, AutoJs6 홈페이지의 드로어 스위치에 비정상적인 상태가 반영됩니다.
* `개선` 콘솔에는 오류 메시지를 인쇄할 때 상세한 스택 정보가 포함됩니다.
* `개선` 일부 의존성 또는 로컬 라이브러리 버전 조정 _[`CHANGELOG.md`](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG.md#v650)_

##### 더 많은 버전 기록은 참조하십시오.

* [CHANGELOG.md](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG-ko.md)

******

### <a id="project-compilation-and-build"></a>프로젝트 컴파일 및 빌드

******

AutoJs6 오픈 소스 프로젝트를 디버깅하거나 개발하려면 [Android Studio](https://pro.autojs.org/) ([Google](https://www.google.com/) 제품) 또는 [IntelliJ IDEA](https://www.jetbrains.com/idea/) ([Jetbrains](https://www.jetbrains.com/) 제품)를 사용할 수 있습니다.

이 섹션에서는 Android Studio를 사용하여 AutoJs6 오픈 소스 프로젝트를 컴파일하고 빌드하는 방법에 대해 설명합니다. IntelliJ IDEA도 이와 유사합니다.

#### Android Studio 준비

`Android Studio Ladybug Feature Drop | 2024.2.2 RC 2` 버전을 다운로드하십시오 (필요에 따라 선택):

- [android-studio-2024.2.2.12-windows.exe](https://redirector.gvt1.com/edgedl/android/studio/install/2024.2.2.12/android-studio-2024.2.2.12-windows.exe) (1.14 GB)
- [android-studio-2024.2.2.12-windows.zip](https://redirector.gvt1.com/edgedl/android/studio/ide-zips/2024.2.2.12/android-studio-2024.2.2.12-windows.zip) (1.15 GB)

> 메모: 상기 버전 출시 날짜는 2024 년 12 월 16 일입니다. 다른 버전을 다운로드하거나 상기 링크가 만료되었을 경우, [Android Studio 릴리스 아카이브](https://developer.android.com/studio/archive?hl=en) 페이지를 방문하십시오..

위의 파일을 설치하거나 압축을 풀고 Android Studio 소프트웨어를 실행합니다 (예: `"D:\android-studio\bin\studio64.exe"`).

#### Android SDK 준비

> 메모: 시스템에 이미 Android SDK(안드로이드 소프트웨어 개발 키트)가 설치되어 있는 경우, 이 섹션을 건너뛸 수 있습니다..

Android Studio 소프트웨어에서 `CTRL + ALT + S` 단축키를 사용하여 설정 페이지를 엽니다.:

```text
Appearance & Behavior (외관 및 행동) -> 
System Settings (시스템 설정) -> 
Android SDK (안드로이드 소프트웨어 개발 키트)
```

`Android SDK Location`(안드로이드 소프트웨어 개발 키트 위치) 필드가 비어 있는 경우, 오른쪽의 `Edit`(편집) 버튼을 클릭하고, 팝업 창에서 여러 번 `Next`(다음)를 클릭합니다..

> 메모: 과정 중 하나 이상의 관련 계약을 동의해야 계속 진행할 수 있습니다..

관련 리소스가 다운로드 및 설치를 완료하면, `Finish`(완료) 버튼을 클릭합니다..  
위의 `Android SDK Location`(안드로이드 소프트웨어 개발 키트 위치) 필드에 경로가 자동으로 작성되고, SDK 준비 작업이 완료됩니다..

#### Android SDK 도구 준비

AutoJs6은 일부 SDK 도구 (예: NDK 및 CMake)를 사용해야 합니다..

> 메모: 시스템에 AutoJs6이 필요한 모든 Android SDK 도구가 설치되어 있는 경우, 이 섹션을 건너뛸 수 있습니다..

Android Studio 소프트웨어에서 `CTRL + ALT + S` 단축키를 사용하여 설정 페이지를 엽니다.:

```text
Appearance & Behavior (외관 및 행동) -> 
System Settings (시스템 설정) -> 
Android SDK (안드로이드 소프트웨어 개발 키트) -> 
SDK Tools (SDK 도구) (오른쪽 창에 위치)
```

`Show Package Details` (패키지 세부사항 표시)를 선택하고, NDK와 CMake를 차례로 클릭하여 해당 버전의 도구가 선택되었는지 확인하십시오, SDK 도구 버전 정보는 AutoJs6 프로젝트 루트 디렉터리에 있는 `version.properties` 파일에 있습니다..

#### JDK 준비

AutoJs6 프로젝트는 `JDK (Java 개발 도구 키트)` 버전이 `17` 이상이어야 하지만, `19` 이상을 권장합니다..

2025 년 1 월 1 일 기준으로, AutoJs6이 지원하는 최대 JDK 버전은 `23`입니다..

> 메모: 시스템에 JDK가 설치되어 있고, 버전이 위의 요구 사항을 충족하는 경우, 이 섹션을 건너뛸 수 있습니다..

JDK는 IDE에서 직접 다운로드하거나 [Oracle 웹사이트](https://www.oracle.com/java/technologies/downloads/) 에서 다운로드할 수 있습니다.

Android Studio 소프트웨어에서 단축키 `CTRL + ALT + S` 를 사용하여 설정 페이지를 여십시오:

```text
Build, Execution, Deployment (구축, 실행, 개발) -> 
Build Tools (구축 도구) -> 
Gradle
```

`Gradle JDK` 에서 다양한 버전의 JDK를 선택하거나 추가할 수 있습니다.

목록에 적합한 버전의 JDK(>= `17`)가 있는 경우, 직접 선택하십시오..  
그렇지 않으면 `Download JDK (JDK 다운로드)`를 선택하여 적절한 JDK를 다운로드하고, `Download (다운로드)` 버튼을 클릭하여 완료될 때까지 기다립니다.  
`Add JDK (JDK 추가)`를 선택하여 이미 존재하는 로컬 JDK를 추가하고 디렉토리를 지정하여 JDK 추가를 완료할 수 있습니다.

#### AutoJs6 자원 복제

Android Studio 메인 화면에서 `Get from VCS (버전 관리 시스템에서 가져오기)` 버튼을 클릭합니다.  
`URL (통합 자원 위치)`에 `https://github.com/SuperMonster003/AutoJs6.git`을 입력합니다,  
`Directory (디렉토리)`에서 필요한 경우 특정 경로로 수정할 수 있습니다.  
`Clone (복제)` 버튼을 클릭하고 AutoJs6 프로젝트 리소스를 장치에 로컬로 복제될 때까지 기다립니다.

> 메모: 과정 중 [Git (분산 버전 관리 시스템)](https://git-scm.com/download)을 설치해야 할 수도 있습니다..

#### AutoJs6 프로젝트 빌드

복제가 완료된 후, Android Studio가 AutoJs6 프로젝트 창을 열고 초기 `Dependencies(의존성)` 다운로드 및 Gradle 빌드를 자동으로 완료합니다.

> 메모: 상기 과정은 시간이 많이 소요될 수 있습니다. 네트워크 상태가 좋지 않으면 여러 번 재시도해야 할 수 있습니다 (Retry 버튼을 클릭)..

빌드가 완료되면 Android Studio의 `Build` 탭에 `BUILD SUCCESSFUL in 1h 17m 34s` 와 같은 메시지가 나타납니다.

프로젝트를 패키징하고 설치 가능한 APK 파일을 안드로이드 장치에서 생성합니다:

- 디버그 버전 (Debug Version)
    - `Build (구축)` -> `Build Bundle(s) / APK(s)` -> `Build APK(s)`
    - 기본 서명을 포함한 디버그 버전 APK 생성
    - 경로 예시: `"D:\AutoJs6\app\build\outputs\apk\debug\"`
- 릴리즈 버전 (Release Version)
    - `Build (구축)` -> `Generate Signed Bundle / APK`
    - `APK` 옵션 선택
    - 서명 파일을 준비하고 (새로 만들거나 선택) 서명된 릴리즈 버전 설치 패키지를 생성합니다
    - 경로 예시: `"D:\AutoJs6\app\release\"`

> 참조: [Android Docs](https://developer.android.com/studio/run?hl=zh-cn)

******

### <a id="script-development-assistance"></a>스크립트 개발 지원

******

AutoJs6에서 실행 가능한 스크립트를 개발하려면 적합한 개발 도구를 사용하십시오.:

- [VSCode](https://code.visualstudio.com/download) / [WebStorm](https://www.jetbrains.com/webstorm/download/) / [HBuilderX](https://www.dcloud.io/hbuilderx.html) ...

PC에서 스크립트를 작성하고 디버깅하려면 VSCode 플러그인을 사용하여 PC와 휴대폰을 연결할 수 있습니다.:

- [AutoJs6-VSCode-Extension](http://vscext-project.autojs6.com) - AutoJs6 디버거 (VSCode 플랫폼 플러그인)

개발 도구를 사용하여 코드를 작성할 때, 코드 자동 완성 기능은 개발자를 더 잘 도울 수 있습니다.:

- [AutoJs6-TypeScript-Declarations](http://dts-project.autojs6.com) - AutoJs6 선언 파일 (코드 자동 완성)

코드를 작성할 때, AutoJs6 관련 API 및 사용 방법을 문서에서 조회할 수 있습니다.:

- [AutoJs6-Documentation](http://docs-project.autojs6.com) - AutoJs6 문서

기존의 스크립트 개발 프로젝트는 개인 스크립트 프로젝트 창작에 영감을 줄 수 있습니다.:

- [Ant-Forest](https://github.com/TonyJiangWJ/Ant-Forest) - ant forest 에너지 자동 수집 스크립트 by [TonyJiangWJ](https://github.com/TonyJiangWJ)
- [Ant-Forest](https://github.com/SuperMonster003/Ant-Forest) - ant forest 에너지 자동 수집 스크립트 by [SuperMonster003](https://github.com/SuperMonster003)
- [autojs](https://github.com/e1399579/autojs) - Auto.js 유용한 스크립트 by [e1399579](https://github.com/e1399579)
- [autojsDemo](https://github.com/snailuncle/autojsDemo) - Auto.js 데모 예제 by [snailuncle](https://github.com/snailuncle)
- [autojs 관련 저장소](https://github.com/topics/autojs) - GitHub에서 autojs 주제와 관련된 모든 저장소

******

### 기여 참여

******

AutoJs6 프로젝트 개발에 참여한 모든 기여자분들께 감사합니다.

|     <span style="word-break:keep-all;white-space:nowrap">기여자</span>     |                   <span style="word-break:keep-all;white-space:nowrap">커밋 수</span>                    | <span style="word-break:keep-all;white-space:nowrap">최근 제출</span> |
|:----------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------:|
|     <span style="word-break:keep-all;white-space:nowrap">[luckyloogn](https://github.com/luckyloogn)</span>      |       <span style="word-break:keep-all;white-space:nowrap">[3](https://github.com/SuperMonster003/AutoJs6/commits?author=luckyloogn)</span>        |                    <span style="word-break:keep-all;white-space:nowrap">`2025/01/01`</span>                    |
|           <span style="word-break:keep-all;white-space:nowrap">[kvii](https://github.com/kvii)</span>            |          <span style="word-break:keep-all;white-space:nowrap">[1](https://github.com/SuperMonster003/AutoJs6/commits?author=kvii)</span>           |                    <span style="word-break:keep-all;white-space:nowrap">`2024/10/16`</span>                    |
|  <span style="word-break:keep-all;white-space:nowrap">[chenguangming](https://github.com/chenguangming)</span>   | <span style="word-break:keep-all;white-space:nowrap">[2](https://github.com/SuperMonster003/AutoJs6/pulls?q=is%3Apr+author%3Achenguangming)</span> |                    <span style="word-break:keep-all;white-space:nowrap">`2024/05/14`</span>                    |
|         <span style="word-break:keep-all;white-space:nowrap">[LZX284](https://github.com/LZX284)</span>          |         <span style="word-break:keep-all;white-space:nowrap">[17](https://github.com/SuperMonster003/AutoJs6/commits?author=LZX284)</span>         |                    <span style="word-break:keep-all;white-space:nowrap">`2023/11/19`</span>                    |
|    <span style="word-break:keep-all;white-space:nowrap">[TonyJiangWJ](https://github.com/TonyJiangWJ)</span>     |       <span style="word-break:keep-all;white-space:nowrap">[4](https://github.com/SuperMonster003/AutoJs6/commits?author=TonyJiangWJ)</span>       |                    <span style="word-break:keep-all;white-space:nowrap">`2023/10/31`</span>                    |
| <span style="word-break:keep-all;white-space:nowrap">[little&#x2011;alei](https://github.com/little-alei)</span> |      <span style="word-break:keep-all;white-space:nowrap">[12](https://github.com/SuperMonster003/AutoJs6/commits?author=little-alei)</span>       |                    <span style="word-break:keep-all;white-space:nowrap">`2023/07/12`</span>                    |
|         <span style="word-break:keep-all;white-space:nowrap">[aiselp](https://github.com/aiselp)</span>          |    <span style="word-break:keep-all;white-space:nowrap">[6](https://github.com/SuperMonster003/AutoJs6/pulls?q=is%3Apr+author%3Aaiselp)</span>     |                    <span style="word-break:keep-all;white-space:nowrap">`2023/06/14`</span>                    |
|          <span style="word-break:keep-all;white-space:nowrap">[LYS86](https://github.com/LYS86)</span>           |          <span style="word-break:keep-all;white-space:nowrap">[2](https://github.com/SuperMonster003/AutoJs6/commits?author=LYS86)</span>          |                    <span style="word-break:keep-all;white-space:nowrap">`2023/06/03`</span>                    |

데이터 갱신일: 2025 년 1 월 1 일.

데이터 항목은 `최근 제출` 순으로 내림차순 정렬됩니다.

처리되지 않은 새로 발행된 Pull Request는 병합 처리 후 데이터 통계에 추가될 것입니다.

일부 기여자는 [GitHub Contributors](https://github.com/SuperMonster003/AutoJs6/graphs/contributors)에서 정상적으로 표시되지 않으며, 그들의 제출 기록이 비어 있습니다. 그러나 [Pull Request](https://github.com/SuperMonster003/AutoJs6/pulls)를 통해 기여 기록을 확인할 수 있습니다.

[//]: # (
    # --------------------------------------------------------------#
    # Before committing and pushing to the remote GitHub repository #
    # --------------------------------------------------------------#
    - CHANGELOG.md
        - Update entries for AutoJs6 by checking all changed files
        - Update entries for Gradle plugins [ implementation ]
        - Update version name and released date
        - Append related GitHub issues to changelog entries
    - README.md
        - The summary of the latest changelog for committing to Git [ DO NOT commit or push ]
        - Update badges like [ android studio / rhino / ... ]
        - Update android studio download links and version names
        - Update contribution section
    - Remove the part like [ alpha / beta / ... ] of VERSION_NAME in version.properties
    - Update dependencies TypeScript declarations if needed.
    - Re-generate documentation/markdown by running the python script
    - Check the two-way versions for AutoJs6 and VSCode ext, then publish the ext to Microsoft
    - Run Gradle task "app:assembleInrtRelease"
    - Build APK to determine the final VERSION_BUILD field
    - Run Gradle task "app:appendDigestToReleasedFiles"
    - Commit and push to GitHub
    - Publish the latest release with signed APKs
)