<!--suppress HtmlDeprecatedAttribute, HttpUrlsUsage -->

<div align="center">
  <p>
    <img src="https://s1.imagehub.cc/images/2023/03/07/af8ed087c9d354b9ab6142aae7bbafb6.png" alt="autojs6-banner_800×224" border="0" width="704" />
  </p>

  <p>アクセシビリティサービスをサポートする Android プラットフォーム用の JavaScript 自動化ツール</p>

  <p>
    <a href="http://download.autojs6.com"><img alt="GitHub release (latest by date)" src="https://img.shields.io/github/v/release/SuperMonster003/AutoJs6"/></a>
    <a href="http://issues.autojs6.com"><img alt="GitHub closed issues" src="https://img.shields.io/github/issues/SuperMonster003/AutoJs6?color=009688"/></a>
    <a href="http://commit.autojs6.com/99a1d8490fac5b6d55f6f183db59ad833a2064ed"><img alt="Created" src="https://img.shields.io/date/1636632233?color=2e7d32&label=created"/></a>
    <br>
    <a href="https://github.com/mozilla/rhino"><img alt="Rhino" src="https://img.shields.io/badge/rhino-1.7.16--snapshot-A24232"/></a>
    <a href="https://developer.android.com/studio/archive"><img alt="Android Studio" src="https://img.shields.io/badge/android%20studio-2022.1+-B64FC8"/></a>
    <br>
    <a href="https://www.codefactor.io/repository/github/SuperMonster003/AutoJs6"><img alt="CodeFactor Grade" src="https://www.codefactor.io/repository/github/SuperMonster003/AutoJs6/badge"/></a>
    <a href="https://www.jetbrains.com/?from=AutoJs6"><img alt="JetBrains supporter" src="https://img.shields.io/badge/supporter-JetBrains-ee4677"/></a>
    <a href="http://project.autojs6.com/blob/master/LICENSE"><img alt="GitHub License" src="https://img.shields.io/github/license/SuperMonster003/AutoJs6?color=534BAE"/></a>
  </p>
</div>

******

### 言語

******

現在の README.md ファイルは以下の言語に対応しています:

 - [简体中文 [zh-Hans]](http://project.autojs6.com/blob/master/.readme/README-zh-Hans.md)
 - [繁體中文 (香港) [zh-Hant-HK]](http://project.autojs6.com/blob/master/.readme/README-zh-Hant-HK.md)
 - [繁體中文 (台灣) [zh-Hant-TW]](http://project.autojs6.com/blob/master/.readme/README-zh-Hant-TW.md)
 - [English [en]](http://project.autojs6.com/blob/master/.readme/README-en.md)
 - [Français [fr]](http://project.autojs6.com/blob/master/.readme/README-fr.md)
 - [Español [es]](http://project.autojs6.com/blob/master/.readme/README-es.md)
 - 日本語 [ja] # 現在
 - [한국어 [ko]](http://project.autojs6.com/blob/master/.readme/README-ko.md)
 - [Русский [ru]](http://project.autojs6.com/blob/master/.readme/README-ru.md)
 - [العربية [ar]](http://project.autojs6.com/blob/master/.readme/README-ar.md)

******

### 紹介

******

[Auto.js](https://github.com/hyb1996/Auto.js) は Android プラットフォーム用の [アクセシビリティサービス](https://developer.android.com/guide/topics/ui/accessibility/service?hl=zh-cn) をサポートする JavaScript 自動化ツールです.

Auto.js は [hyb1996](https://github.com/hyb1996) によって `2017/01/27` に初めてリリースされ、`2020/03/13` にメンテナンスを停止しました。最終バージョンの名前は `4.1.1 Alpha2` で、ビルドバージョンは `461` です.

AutoJs6 は `2021/12/01` に Auto.js 最終プロジェクトを基に二次開発され、引き続きオープンソースとして無料で提供されています.

以下の表には、Auto.js に関連するプロジェクトの一部が記載されています (開発日順に並べ替えられています):

| <span style="word-break:keep-all;white-space:nowrap">プロジェクト</span> |                                                             <span style="word-break:keep-all;white-space:nowrap">アプリ名</span>                                                              | <span style="word-break:keep-all;white-space:nowrap">開発者</span> | <span style="word-break:keep-all;white-space:nowrap">開発開始日</span> | <span style="word-break:keep-all;white-space:nowrap">開発終了日</span> |
|:------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------:|:---------------------------------------------------------------------------------------------------------------------------------:|:-------------------------------------------------------------------------------------------------------------------------------:|
|     <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/hyb1996/Auto.js)</span>      |    <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/TonyJiangWJ/Auto.js/commit/268ec8895bbfa28fc7715154eb15b1c1eaaefd14#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span>     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2017/01/27`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2020/03/13`</span>                             |
|                     <span style="word-break:keep-all;white-space:nowrap">Auto.js Pro 7</span>                      |                                                                                     <span style="word-break:keep-all;white-space:nowrap">Auto.js</span>                                                                                      |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2019/03/13`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2019/07/08`</span>                             |
|                     <span style="word-break:keep-all;white-space:nowrap">Auto.js Pro 8</span>                      |                                                                                    <span style="word-break:keep-all;white-space:nowrap">AutoJsPro</span>                                                                                     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2019/10/13`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2021/07/24`</span>                             |
|   <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/TonyJiangWJ/Auto.js)</span>    | <span style="word-break:keep-all;white-space:nowrap">[Auto.js&#160;M](https://github.com/TonyJiangWJ/Auto.js/commit/268ec8895bbfa28fc7715154eb15b1c1eaaefd14#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span> |      <span style="word-break:keep-all;white-space:nowrap">[TonyJiangWJ](https://github.com/TonyJiangWJ)</span>       |                             <span style="word-break:keep-all;white-space:nowrap">`2019/11/21`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|      <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/kkevsekk1/AutoX)</span>       |                 <span style="white-space:pre">[Autox.js](https://github.com/kkevsekk1/AutoX/commit/8143e4ed893d4af05d22aa791b83a962f9959873#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span>                  |        <span style="word-break:keep-all;white-space:nowrap">[kkevsekk1](https://github.com/kkevsekk1)</span>         |                             <span style="word-break:keep-all;white-space:nowrap">`2020/07/24`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|        <span style="word-break:keep-all;white-space:nowrap">[Auto.js Pro 9](https://pro.autojs.org/)</span>        |                                                                                    <span style="word-break:keep-all;white-space:nowrap">AutoJsPro</span>                                                                                     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2021/03/28`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2023/02/09`</span>                             |
| <span style="word-break:keep-all;white-space:nowrap">[AutoJs6](https://github.com/SuperMonster003/AutoJs6)</span>  |  <span style="word-break:keep-all;white-space:nowrap">[AutoJs6](https://github.com/SuperMonster003/AutoJs6/commit/a8ce1b9acb541e9736c33134be3194c3148a15a3#diff-833a46a97033e77558372a2dce103fd6fee29aaaa899f610022a7aece592ee7bR27)</span>  |  <span style="word-break:keep-all;white-space:nowrap">[SuperMonster003](https://github.com/SuperMonster003)</span>   |                             <span style="word-break:keep-all;white-space:nowrap">`2021/12/01`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|      <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/kkevsekk1/AutoX)</span>       |            <span style="white-space:pre">[Autox.js&#160;v6](https://github.com/kkevsekk1/AutoX/commit/8b6776cff8b0fca4be4a52719b7d7d07c0a058f3#diff-51a0b488f963eb0be6c6599bf5df497313877cf5bdff3950807373912ac1cdc9R130)</span>             |           <span style="word-break:keep-all;white-space:nowrap">[wilinz](https://github.com/wilinz)</span>            |                             <span style="word-break:keep-all;white-space:nowrap">`2022/05/26`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|      <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/kkevsekk1/AutoX)</span>       |            <span style="white-space:pre">[Autox.js&#160;v7](https://github.com/kkevsekk1/AutoX/commit/484491fd5fe12b8203d0b09c181eb0f471c0ea9f#diff-8cff73265af19c059547b76aca8882cbaa3209291406f52df1dafbbc78e80c46R120)</span>             |           <span style="word-break:keep-all;white-space:nowrap">[aiselp](https://github.com/aiselp)</span>            |                             <span style="word-break:keep-all;white-space:nowrap">`2024/04/21`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |

表の日付は推定値であり、実際とは異なる場合があります.

表の Auto.js Pro 7/8/9 は有料バージョンです。その他は無料のオープンソースバージョンです.

******

### 機能

******

* JavaScript IDEとして使用可能 (コード補完/変数リネーム/コードフォーマッティング)
* 無障害サービスに基づく自動化操作をサポート ([AccessibilityService](https://developer.android.com/reference/android/accessibilityservice/AccessibilityService))
* 浮動ボタンのクイックアクションをサポート (スクリプトの録画および再生/パッケージの表示/レイアウト分析)
* セレクタAPIをサポートし、コントロールのトラバース/情報の取得/コントロール操作を提供 (UiAutomatorに類似: [UiAutomator](https://developer.android.com/training/testing/ui-automator))
* レイアウトインターフェイスの分析をサポート (Android StudioのLayoutInspectorに類似)
* 録画機能および録画再生機能をサポート
* スクリーンショット/スクリーン保存/画像検索/画像マッチングをサポート
* E4X (ECMAScript for XML)の記述インターフェースをサポート ([E4X](https://ja.wikipedia.org/wiki/E4X))
* スクリプトファイルまたはプロジェクトをAPKファイルにパッケージ化する機能をサポート
* ルート権限を使用して機能を拡張 (スクリーンのクリック/スワイプ/録画/Shell)
* Taskerプラグインとして使用可能
* VS Code拡張機能との連携をサポート (AutoJs6-VSCode-Extensionプラグインが必要です: [AutoJs6-VSCode-Extension](http://vscext-project.autojs6.com))

******

### 環境

******

- Androidオペレーティングシステム
- [API](https://developer.android.com/guide/topics/manifest/uses-sdk-element#ApiLevels) [24](https://developer.android.com/reference/android/os/Build.VERSION_CODES#N) ([7.0](https://ja.wikipedia.org/wiki/Android_Nougat)) [[N](https://developer.android.com/reference/android/os/Build.VERSION_CODES#N)] 以上

******

### マニュアル

******

* [アプリケーションドキュメント](https://docs.autojs6.com)
* [ユーザーマニュアル (作成中)](https://docs.autojs6.com/#/manual)
* [トラブルシューティング](https://docs.autojs6.com/#/qa)
* [プロジェクトのコンパイルとビルド](#project-compilation-and-build)
* [スクリプト開発アシスト](#script-development-assistance)

******

### 主な変更

******

Auto.js の最終オープンソースバージョン `4.1.1 Alpha2` と比較して、AutoJs6 は以下のアップグレードまたは変更を行いました:

* [Shizuku](https://shizuku.rikka.app/introduction/)経由でADB特権を取得し、システムAPIを使用可能
* [WebSocket](https://docs.autojs6.com/#/webSocketType)インスタンスの作成、および[WebSocketプロトコル](https://ja.wikipedia.org/wiki/WebSocket)に基づくネットワークリクエストの処理をサポート
* 新モジュール [ [base64](https://docs.autojs6.com/#/base64) / [crypto](https://docs.autojs6.com/#/crypto) / [sqlite](https://docs.autojs6.com/#/sqlite) / [i18n](https://docs.autojs6.com/#/i18n) / [notice](https://docs.autojs6.com/#/notice) / [ocr](https://docs.autojs6.com/#/ocr) / [opencc](https://docs.autojs6.com/#/opencc) / [qrcode](https://docs.autojs6.com/#/qrcode) / [shizuku](https://docs.autojs6.com/#/shizuku) / ... ]
* 多言語対応 [ 西 / 仏 / 露 / 阿 / 日 / 韓 / 英 / 簡中 / 繁中 / ... ]
* ナイトモード対応 [ 設定ページ / ドキュメントページ / レイアウト分析ページ / 浮動ウィンドウ / ... ]
* [VSCodeプラグイン](http://vscext-project.autojs6.com)がクライアント (LAN)とサーバ (LAN/ADB)接続方法をサポート
* [Rhino](https://github.com/mozilla/rhino/)エンジンが [v1.7.7.2](https://github.com/mozilla/rhino/releases/tag/Rhino1_7_7_2_Release) から [v1.7.16-SNAPSHOT](http://rhino.autojs6.com/blob/master/gradle.properties#L3) にアップグレードされました。
    * Unicode [コードポイント](https://developer.mozilla.org/ja/docs/Glossary/Code_point)エスケープのサポート [補助平面](https://ja.wikipedia.org/wiki/多言語面#補助平面)文字
       ```javascript
       '\u{1D160}'; /* を表します "𝅘𝅥𝅮", 従来の方法: '\uD834\uDD60'. */
       ```
    * [Object.values()](https://developer.mozilla.org/ja/docs/Web/JavaScript/Reference/Global_Objects/Object/values)のサポート
       ```javascript
       Object.values({name: 'Max', age: 4}); // ['max', 4]
       ```
    * [Array.prototype.includes()](https://developer.mozilla.org/ja/docs/Web/JavaScript/Reference/Global_Objects/Array/includes)のサポート
       ```javascript
       [10, 20, NaN].includes(20); // true
       ```
    * [BigInt](https://developer.mozilla.org/ja/docs/Web/JavaScript/Reference/Global_Objects/BigInt)のサポート
       ```javascript
       typeof 567n === 'bigint'; // true
       ```
    * [テンプレート文字列](https://developer.mozilla.org/ja/docs/Web/JavaScript/Reference/Template_literals)のサポート
       ```javascript
       `Lucky number: ${(Math.random() * 100).toFixed(0)}`
       ```
    * Rhinoエンジンの[新機能](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/RHINO.md)を見る
    * Rhinoエンジンの[互換リスト](https://mozilla.github.io/rhino/compat/engines.html)を見る

******

### バージョン履歴

******

# v6.6.1

###### 2025/01/01

* `新機能` 中国語のピンイン変換用の Pinyin モジュール (プロジェクトドキュメントを参照 > [中国語ピンイン](https://docs.autojs6.com/#/pinyin))
* `新機能` 中国語のピンイン変換用の Pinyin4j モジュール (プロジェクトドキュメントを参照 > [中国語ピンイン](https://docs.autojs6.com/#/pinyin4j))
* `新機能` コントロールまたはコントロールコレクションが類似しているかを判定する UiObject#isSimilar と UiObjectCollection#isSimilar メソッド
* `新機能` グローバルメソッド「currentComponent」、現在アクティブなコンポーネントの名前情報を取得するために使用されます
* `修正` 一部の環境でバージョンを低く戻すことでプロジェクトが正常にコンパイルできなくなる問題
* `修正` 存在しないメソッドを呼び出す際に発生する可能性がある「非プリミティブ型の値」エラー
* `修正` 一部のデバイスでスクリプトショートカットが正常に追加できない問題 (暫定修正) _[`issue #221`](http://issues.autojs6.com/221)_
* `修正` automator.click/longClick メソッドのパラメーター型制限の誤り _[`issue #275`](http://issues.autojs6.com/275)_
* `修正` セレクターが ConsString 型のパラメーターをサポートしない問題 _[`issue #277`](http://issues.autojs6.com/277)_
* `修正` UiObjectCollection インスタンスにメソッドおよびプロパティが欠如している問題
* `改善` パッケージ化ページで署名設定、キーストア管理、権限設定をサポートします（[luckyloogn]() による） _[`pr #286`]()_
* `改善` フローティングウィンドウの現在のパッケージ名および現在のアクティビティ名の認識精度を向上 (優先順位: Shizuku > Root > A11Y)
* `改善` currentPackage と currentActivity の認識精度を向上 (優先順位: Shizuku > Root > A11Y)
* `改善` ログアクティビティウィンドウの個別エントリのテキスト内容をダブルクリックまたは長押しで選択する機能を復元 _[`issue #280`](http://issues.autojs6.com/280)_
* `改善` project.json ファイルが破損した場合でも, スクリプトプロジェクトの重要な情報を可能な限り復元
* `改善` 単一ファイルをパッケージ化する際に, 自動生成されるパッケージ名のサフィックスを簡体字中国語からピンインに変換 (多音字対応)
* `改善` UiSelector#findOnce と UiSelector#find メソッドで負の引数をサポート
* `改善` app.startActivity/startDualActivity メソッドの適応性が向上しました
* `改善` UI要素や className に関連するセレクターが RecyclerView や Snackbar などのパッケージ名プレフィックス省略形式にさらに対応
* `改善` Rhino エンジンの最新の上流コードを同期し, 既存のプロジェクトに適応させる
* `改善` 一部の依存関係またはローカルライブラリのバージョン調整 _[`CHANGELOG.md`](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG.md#v661)_

# v6.6.0

###### 2024/12/02 - 組み込みモジュールの書き換え, 慎重にアップグレードしてください

* `ヒント` 既存のモジュールは, スクリプトの実行効率を高めるために Kotlin によって再作成されましたが, 改良にはいくつかの反復が必要です
* `ヒント` 組み込みの init.js ファイルはデフォルトでは空ですが, 開発者がカスタマイズするためのモジュールをマウントできます
* `新機能` axios モジュール / cheerio モジュール ([AutoX](https://github.com/kkevsekk1/AutoX) 参照)
* `新機能` sqlite モジュール, SQLite データベースの簡単な操作に使用されます ([Auto.js Pro](https://g.pro.autojs.org/) 参照) (プロジェクトドキュメント > [SQLite](https://docs.autojs6.com/#/sqlite) を参照)
* `新機能` mime モジュール, MIME タイプ文字列を処理および解析するために使用されます (プロジェクトドキュメント > [MIME](https://docs.autojs6.com/#/mime) を参照)
* `新機能` nanoid モジュール, 文字列 ID ジェネレーターとして使用できます ([ai/nanoid](https://github.com/ai/nanoid) 参照)
* `新機能` sysprops モジュール, ランタイム環境の構成データを取得するために使用されます (プロジェクトドキュメント > [システムプロパティ](https://docs.autojs6.com/#/sysprops) を参照)
* `新機能` ocr モジュールは [Rapid OCR](https://github.com/RapidAI/RapidOCR) エンジンをサポートしています
* `新機能` レイアウト解析はウィンドウの切り替えをサポートしています (Auto.js Pro
* `新機能` auto.clearCache メソッド, コントロールキャッシュをクリアすることをサポートします (Auto.js Pro
* `新機能` threads.pool メソッド, シンプルなスレッドプールアプリケーションをサポートします (Auto.js Pro
* `新機能` images.matchTemplate メソッドは useTransparentMask オプションパラメーターを追加し, 透明画像検索をサポートします (Auto.js Pro
* `新機能` images.requestScreenCaptureAsync メソッド, UI モードで非同期にスクリーンキャプチャの許可を要求するために使用されます  (Auto.js Pro
* `新機能` images.requestScreenCapture メソッドは isAsync オプションパラメーターを追加し, 非同期でスクリーンキャプチャを取得することをサポートします (Auto.js Pro
* `新機能` images.on('screen_capture', callback) などのイベントリスニングメソッドは, スクリーンキャプチャが使用可能なイベントをモニターすることをサポートします (Auto.js Pro
* `新機能` images.stopScreenCapture メソッドは, スクリーンキャプチャ要求に関連するリソースを積極的に解放することをサポートします (Auto.js Pro
* `新機能` images.psnr/mse/ssim/mssim/hist/ncc および images.getSimilarity メソッドは, 画像類似度測定値を取得するために使用されます
* `新機能` images.isGrayscale メソッドは, 画像がグレースケールかどうかを判断するために使用されます
* `新機能` images.invert メソッドは, 画像の色を反転するために使用されます
* `新機能` s13n.point/time メソッドは, ポイントオブジェクトと時間オブジェクトを正規化するために使用されます (プロジェクトドキュメント > [正規化](https://docs.autojs6.com/#/s13n) を参照)
* `新機能` console モジュールの gravity (重力), touchThrough (タッチスルー), backgroundTint (背景の色調) などの関連メソッド (プロジェクトドキュメント > [コンソール](https://docs.autojs6.com/#/console) を参照)
* `新機能` Mathx.randomInt/Mathx.randomFloat メソッドは, 指定された範囲内の乱数またはランダム浮動小数点数を戻すために使用されます
* `新機能` app.launchDual/startDualActivity などのメソッドは二重起動アプリケーションの処理に使用されます (Shizuku または Root 権限が必要) (実験的)
* `新機能` app.kill メソッド, アプリケーションを強制終了するために使用されます (Shizuku または Root 権限が必要)
* `新機能` floaty.getClip メソッドは, フローティングウィンドウのフォーカスを通じてクリップボードの内容を間接的に取得するために使用されます
* `修正` Fragment のサブクラス (例 [DrawerFragment](https://github.com/SuperMonster003/AutoJs6/blob/17616504ab0bba93b30ab7abc67108ee5253f39a/app/src/main/java/org/autojs/autojs/ui/main/drawer/DrawerFragment.kt#L369) / [ExplorerFragment](https://github.com/SuperMonster003/AutoJs6/blob/17616504ab0bba93b30ab7abc67108ee5253f39a/app/src/main/java/org/autojs/autojs/ui/main/scripts/ExplorerFragment.kt#L48) 等) 内の View Binding のメモリリーク
* `修正` [ScreenCapture](https://github.com/SuperMonster003/AutoJs6/blob/17616504ab0bba93b30ab7abc67108ee5253f39a/app/src/main/java/org/autojs/autojs/core/image/capture/ScreenCapturer.java#L70) / [ThemeColorPreference](https://github.com/SuperMonster003/AutoJs6/blob/10960ddbee71f75ef80907ad5b6ab42f3e1bf31e/app/src/main/java/org/autojs/autojs/ui/settings/ThemeColorPreference.kt#L21) 等のクラス内のインスタンスのメモリリーク
* `修正` Android 14+ でスクリーンキャプチャの許可を求めるとアプリがクラッシュする問題 (by [chenguangming](https://github.com/chenguangming)) _[`pr #242`](http://pr.autojs6.com/242)_
* `修正` Android 14+ でフォアグラウンドサービスを開始するとアプリがクラッシュする問題
* `修正` Android 14+ でコードエディタの実行ボタンをクリックしても点灯しない問題
* `修正` プロジェクトのパッケージ後に必要なライブラリファイルが不足してアプリが正常に動作しない可能性がある問題 _[`issue #202`](http://issues.autojs6.com/202)_ _[`issue #223`](http://issues.autojs6.com/223)_ _[`pr #264`](http://pr.autojs6.com/264)_
* `修正` プロジェクトの編集時に指定されたアイコンリソースが存在しない場合にアプリがクラッシュする問題 _[`issue #203`](http://issues.autojs6.com/203)_
* `修正` スクリーンキャプチャの許可を取得時に指定された画面方向のスクリーンショットリソースをパラメータで正常に取得できない場合がある問題
* `修正` 一部デバイスでスクリプトショートカットを正常に追加できない問題 (試み修正) _[`issue #221`](http://issues.autojs6.com/221)_
* `修正` http モジュールと関連する方法を呼び出すと蓄積される要求による送信遅延の問題 _[`issue #192`](http://issues.autojs6.com/192)_
* `修正` AutoJs6 がメインアクティビティページに入る前に Shizuku サービスが正常に利用できない可能性がある問題 (試み修正) _[`issue #255`](http://issues.autojs6.com/255)_
* `修正` random(min, max) メソッドが結果がオーバーフローする問題の可能性
* `修正` pickup メソッドの結果型パラメータが空配列を正しく渡せない問題
* `修正` UiObject#bounds() で取得したコントロール矩形が意図と異なる形で変更される可能性がある問題
* `修正` text/button/input 要素のテキスト内容にハーフサイズの二重引用符が含まれている場合に正しく解析されない問題
* `修正` text/textswitcher 要素の autoLink 属性が機能しない問題
* `修正` 異なるスクリプトが同じ ScriptRuntime オブジェクトを誤って共有する可能性がある問題
* `修正` グローバル変数 HEIGHT および WIDTH が Getter 動的属性を失う問題
* `修正` スクリプトの起動時に RootShell が即時ロードされることで起動が遅くなる問題
* `修正` コンソールフローティングウィンドウで背景色を設定すると矩形の角が失われる問題
* `修正` サービスの異常の問題が発生する可能性のあるアクセシビリティサービスの自動開始 (試み修正)
* `修正` ホームページのドキュメントページで左右に滑動すると WebView コントロールが ViewPager の切り替えを誘発する可能性がある問題
* `修正` ファイル拡張子が大文字を含む場合ファイルマネージャが認識できない問題
* `修正` ファイルマネージャがプロジェクトディレクトリに最初に入った時点でプロジェクトを自動的に認識できない可能性がある問題
* `修正` ファイルマネージャでフォルダを削除した後にページが自動更新されない問題
* `修正` ファイルマネージャでファイルおよびフォルダを並べ替える際に ASCII の先頭文字名を後置する可能性がある問題
* `修正` コードエディタのデバッグ機能で FAILED ASSERTION 例外が発生する
* `修正` コードエディタでデバッグ中にエディタを閉じた後に再度正常にデバッグできない問題
* `修正` コードエディタで行の端へ移動すると末尾の文字が漏れ可能性がある問題
* `修正` メインアクティビティページでログアクティビティページを起動するときにフラッシュスクリーンの問題が発生する可能性がある
* `修正` アプリパッケージが opencc モジュールを正常に使用できない問題
* `改善` パッケージページ内の「利用不可 ABI」コントロールのクリックヒントユーザー体験
* `改善` Shizuku を使用して「ポインタ位置」表示スイッチをコントロールするサポート
* `改善` Shizuku を使用して「メディアの投影」および「セキュリティ設定の変更」許可スイッチをコントロールするサポート
* `改善` automator.gestureAsync/gesturesAsync がコールバック関数パラメータをサポート
* `改善` tasks モジュールが同期方式でデータベース操作を実行するサポート, データアクセスの不一致問題を回避
* `改善` スクリプト実行モードがパイプ記号区切りモードパラメータ (例 `"ui|auto";` のように開始) をサポート
* `改善` スクリプト実行モードがシングルクォーテーションおよびバックティックをサポートし, セミコロンを省略 (例 `'ui';` または `'ui'` のように開始) 可能
* `改善` スクリプト実行モードが axios, cheerio, dayjs などのモードパラメータで内蔵拡張モジュールのクイックインポートをサポート (例 `"axios";` のように開始)
* `改善` スクリプト実行モードが x または jsox モードパラメータで JavaScript 内蔵オブジェクト拡張モジュールをクイック有効化をサポート (例 `"x";` のように開始)
* `改善` img 要素の src および path 属性がローカル相対パスをサポート (例 `<img src="a.png"` />)
* `改善` コードエディタで Java クラスやパッケージ名をインポートする位置のインテリジェント判断をサポート
* `改善` images モジュールが画像パラメータとしてパスの直接使用をサポート
* `改善` importPackage が文字列パラメータをサポート
* `改善` サーバーモードの IP アドレスがクリップボードインポートをスマートに認識し, スペースキーのスマート変換をサポート
* `改善` ファイルマネージャが新しいファイルを作成する際にデフォルトのプレフィックス選択と適切な数字サフィックスの自動生成をサポート
* `改善` ファイル管理プロジェクトの実行時の例外メッセージを具体化 _[`issue #268`](http://issues.autojs6.com/268)_
* `改善` ファイルマネージャがより多くの種類をサポートし, 対応するアイコンシンボルを表示 (800 種類以上のファイルタイプをサポート)
* `改善` ファイルマネージャで編集可能なファイルタイプ (jpg/doc/pdf...) に編集ボタンを追加
* `改善` ファイルマネージャが APK ファイルの基本情報, Manifest 情報, 許可リストを表示するサポート
* `改善` ファイルマネージャがオーディオおよびビデオなどのメディアファイルの基本情報および MediaInfo 情報を表示するサポート
* `改善` 単一ファイルパッケージング時に適切な正規化名パッケージを自動入力し, 無効な文字フィルタリング推奨をサポート
* `改善` 単一ファイルパッケージング時に同じパッケージ名のアプリがインストールされている場合にアイコンを自動設定し, バージョン番号とバージョン名を増加させるサポート
* `改善` パックプロジェクト設定ファイルが abis/libs オプションをサポートし, デフォルトで含まれる ABI アーキテクチャと拡張ライブラリを指定
* `改善` パックプロジェクト設定ファイルの abis/libs オプションが無効または使用可能でない場合に関連メッセージをサポート
* `改善` 不必要な増加を避けるためにリークキャナリーをリリースバージョンから除外
* `改善` プロジェクトのソースコード内のすべての英語コメントに中国語の簡体字翻訳を追加してコメントの読みやすさを向上
* `改善` README および CHANGELOG に複数言語をサポート (スクリプトによる自動生成)
* `改善` Gradle のビルドスクリプトのバージョン適応能力を向上
* `改善` 一部の依存関係またはローカルライブラリのバージョン調整 _[`CHANGELOG.md`](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG.md#v660)_

# v6.5.0

###### 2023/12/02

* `新機能` opencc モジュール (参照 プロジェクトドキュメント > [中文変換](https://docs.autojs6.com/#/opencc)) (Ref to [LZX284](https://github.com/SuperMonster003/AutoJs6/pull/187/files#diff-8cff73265af19c059547b76aca8882cbaa3209291406f52df1dafbbc78e80c46R268))
* `新機能` UiSelector に [plus](https://docs.autojs6.com/#/uiObjectType?id=m-plus) 及び [append](https://docs.autojs6.com/#/uiObjectType?id=m-append) メソッドを追加 _[`issue #115`](http://issues.autojs6.com/115)_
* `新機能` パッケージ化アプリページに ABI およびライブラリのフィルタリングを追加 (Ref to [AutoX](https://github.com/kkevsekk1/AutoX)) _[`issue #189`](http://issues.autojs6.com/189)_
* `修正` パッケージ化アプリのファイルサイズが異常に大きい問題 (Ref to [AutoX](https://github.com/kkevsekk1/AutoX) / [LZX284](https://github.com/SuperMonster003/AutoJs6/pull/187/files#diff-d932ac49867d4610f8eeb21b59306e8e923d016cbca192b254caebd829198856R61)) _[`issue #176`](http://issues.autojs6.com/176)_
* `修正` パッケージ化アプリで一部の例外メッセージが表示されないおよび印刷されない問題
* `修正` パッケージ化ページでアプリアイコンを選択すると空のアイコンが表示される可能性のある問題
* `修正` パッケージ化アプリに MLKit Google OCR ライブラリを含むと初期化コンテキスト例外が発生する可能性がある
* `修正` ocr.<u>mlkit/ocr</u>.<u>recognizeText/detect</u> メソッドが無効である問題
* `修正` 一部のテキスト (例:ログページ) 表示言語がアプリ設定言語と一致しない可能性のある問題
* `修正` 一部の言語でホームページドロワースイッチ項目にテキストが溢れる可能性のある問題
* `修正` 一部のデバイスでアクセシビリティサービスが有効化直後に自動的に無効化され, 通知メッセージが表示されない問題 _[`issue #181`](http://issues.autojs6.com/181)_
* `修正` 一部のデバイスでアクセシビリティサービスが有効化後に物理的なボタンでアプリがクラッシュする問題 (試修) _[`issue #183`](http://issues.autojs6.com/183)_ _[`issue #186`](http://issues.autojs6.com/186#issuecomment-1817307790)_
* `修正` auto(true) メソッドでアクセシビリティサービスを再起動後, pickup 関数が異常を起こす問題 (試修) _[`issue #184`](http://issues.autojs6.com/184)_
* `修正` floaty モジュールでフローティングウィンドウを作成するとアプリがクラッシュする可能性のある問題 (試修)
* `修正` app.startActivity メソッドが略語パラメータを使用できない問題 _[`issue #182`](http://issues.autojs6.com/182)_ _[`issue #188`](http://issues.autojs6.com/188)_
* `修正` importClass でインポートしたクラス名とグローバル変数が衝突するとコードが例外をスローする問題 _[`issue #185`](http://issues.autojs6.com/185)_
* `修正` Android 7.x でアクセシビリティサービスが使用できない問題
* `修正` Android 14 で runtime.<u>loadJar/loadDex</u> メソッドが正常に使用できない可能性がある問題 (試修)
* `修正` Android システムのクイック設定パネルに「レイアウト範囲分析」と「レイアウト階層分析」が表示されない問題 _[`issue #193`](http://issues.autojs6.com/193)_
* `修正` 自動更新チェック機能がアプリの [ANR](https://developer.android.com/topic/performance/vitals/anr) を引き起こす可能性がある問題 (試修) _[`issue #186`](http://issues.autojs6.com/186)_
* `修正` ファイルマネージャーでサンプルコードフォルダーをクリックして「上へ」ボタンを押すとワーキングパスページに戻れない問題 _[`issue #129`](http://issues.autojs6.com/129)_
* `修正` コードエディターで置換機能を使用時に置換ボタンが表示されない問題
* `修正` コードエディターで長押し削除するとアプリがクラッシュする可能性のある問題 (試修)
* `修正` コードエディターで fx ボタンをクリックしてモジュール関数クイックパネルが表示されない問題
* `修正` コードエディターのモジュール関数クイックパネルのボタン名が溢れる可能性のある問題
* `改善` コードエディターのモジュール関数クイックパネルがナイトモードに適応します
* `改善` パッケージ化されたアプリケーションの起動画面がナイトモードに適応し, アプリアイコンのレイアウトが調整されます
* `改善` パッケージ化されたアプリのページは, ソフトウェアキーボードのENTERキーを使用してカーソルナビゲーションをサポートします
* `改善` パッケージ化されたアプリのページでは, ABIおよびライブラリのタイトルをクリックして全選択状態を切り替えることができます
* `改善` パッケージ化されたアプリのページでは, デフォルトのABI選択がインテリジェントになり, 選択不可の項目にガイドプロンプトが追加されます
* `改善` ファイルマネージャーは, ファイルとフォルダの種類と特性に基づいてメニュー項目の表示を調整します
* `改善` ファイルマネージャーのフォルダ右クリックメニューには, パッケージ化アプリのオプションが追加されます
* `改善` アクセシビリティサービスが有効になっているが機能していない場合, 異常状態はAutoJs6ホームページのドロワースイッチに反映されます
* `改善` コンソールはエラーメッセージを印刷するときに詳細なスタック情報を含みます
* `改善` 一部の依存関係またはローカルライブラリのバージョン調整 _[`CHANGELOG.md`](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG.md#v650)_

##### 他のバージョン履歴については以下を参照してください。

* [CHANGELOG.md](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG-ja.md)

******

### <a id="project-compilation-and-build"></a>プロジェクトのコンパイルとビルド

******

AutoJs6 オープンソース プロジェクトのデバッグや開発が必要な場合は、[Android Studio](https://pro.autojs.org/) ([Google](https://www.google.com/) 社製品) または [IntelliJ IDEA](https://www.jetbrains.com/idea/) ([Jetbrains](https://www.jetbrains.com/) 社製品) を使用できます.

このセクションでは、AutoJs6 オープンソース プロジェクトのコンパイルとビルド方法を Android Studio を例に説明します。IntelliJ IDEA も同様です.

#### Android Studioの準備

`Android Studio Ladybug Feature Drop | 2024.2.2 RC 2` バージョンをダウンロードしてください (いずれかを選択)。:

- [android-studio-2024.2.2.12-windows.exe](https://redirector.gvt1.com/edgedl/android/studio/install/2024.2.2.12/android-studio-2024.2.2.12-windows.exe) (1.14 GB)
- [android-studio-2024.2.2.12-windows.zip](https://redirector.gvt1.com/edgedl/android/studio/ide-zips/2024.2.2.12/android-studio-2024.2.2.12-windows.zip) (1.15 GB)

> 注: 上述バージョンのリリース日は 2024 年 12 月 16 日 です。その他のバージョンをダウンロードするか、上記のリンクが失効している場合は、[Android Studioリリースアーカイブ](https://developer.android.com/studio/archive?hl=en)のページをご覧ください。.

上記のファイルをインストールまたは解凍し、Android Studio ソフトウェアを実行します (例: `"D:\android-studio\bin\studio64.exe"`).

#### Android SDK の準備

> 注: コンピュータシステムに既にAndroid SDK (Androidソフトウェア開発キット)がインストールされている場合、この節の内容をスキップできます。.

Android Studioソフトウェアで`CTRL + ALT + S`のショートカットキーを使用して設定ページを開く:

```text
Appearance & Behavior (外観と動作) -> 
System Settings (システム設定) -> 
Android SDK (Android ソフトウェア開発キット)
```

`Android SDK場所` の欄が空白の場合は、右側の `編集` ボタンをクリックし、表示されるウィンドウで `次へ` ボタンを数回クリックします。.

> 注: プロセス中に1つまたは複数の関連契約に同意する必要がある場合があります。.

関連するリソースのダウンロードとインストールが完了したら、 `完了` ボタンをクリックします。.  
上記の `Android SDK場所` の欄が自動的に入力され、SDKの準備が完了します。.

#### Android SDKツールの準備

AutoJs6では一部のSDKツール(NDKやCMakeなど)が必要です。.

> 注: コンピュータシステムにAutoJs6ですべて必要なAndroid SDKツールがインストールされている場合、この節の内容をスキップできます。.

Android Studioソフトウェアで`CTRL + ALT + S`のショートカットキーを使用して設定ページを開く:

```text
Appearance & Behavior (外観と動作) -> 
System Settings (システム設定) -> 
Android SDK (Android ソフトウェア開発キット) -> 
SDK Tools (SDK ツール) (右側のウィンドウにあります)
```

`パッケージの詳細を表示`を選択し、NDKおよびCMakeをそれぞれクリックして、対応するバージョンのツールが選択されていることを確認してください, SDKツールのバージョン情報は、AutoJs6プロジェクトのルートディレクトリにある`version.properties`ファイルに記載されています。.

#### JDKの準備

AutoJs6プロジェクトが依存する `JDK (Java開発キット)` のリリースバージョンは少なくとも `17` で、それ以下のバージョンは推奨されませんが、最低でも `19` の使用を推奨します。.

2025 年 1 月 1 日 現在、AutoJs6がサポートする最大のJDKバージョンは `23` です。.

> 注: コンピュータシステムに適切なバージョンのJDKがインストールされている場合、この節の内容をスキップできます。.

JDK は IDE から直接ダウンロードするか、[Oracle サイト](https://www.oracle.com/java/technologies/downloads/) にアクセスしてダウンロードできます.

Android Studio ソフトウェアでショートカットキー `CTRL + ALT + S` を使用して設定ページを開きます:

```text
Build, Execution, Deployment (ビルド、実行、展開) -> 
Build Tools (ビルドツール) -> 
Gradle
```

`Gradle JDK` で異なるバージョンの JDK を選択または追加できます.

リストに適切なバージョンのJDKが存在する場合(>= `17`)、それを選択してください。.  
または、`Download JDK (JDK をダウンロード)` を選択して適切な JDK をダウンロードし、`Download (ダウンロード)` ボタンをクリックしてダウンロードが完了するのを待ちます.  
`Add JDK (JDK を追加)` を選択して既存のローカル JDK を追加し、そのディレクトリを指定して JDK を追加することも可能です.

#### AutoJs6リソースのクローン

Android Studio のメインページで `Get from VCS (バージョン管理システムから取得)` ボタンをクリックします.  
`URL (統一リソースロケーターロケーション)` の欄に `https://github.com/SuperMonster003/AutoJs6.git` を入力します,  
`Directory (ディレクトリ)` の欄を必要に応じて特定のパスに変更できます.  
`Clone (クローン)` ボタンをクリックし、AutoJs6 プロジェクト リソースがデバイスにローカルにクローンされるのを待ちます.

> 注: 上記プロセスには[Git (バージョン管理システム)](https://git-scm.com/download)をインストールする必要がある場合があります。.

#### AutoJs6プロジェクトのビルド

クローンが完了すると、Android Studio は AutoJs6 のプロジェクト ウィンドウを開き、`Dependencies (依存関係)` の初期ダウンロードおよび Gradle の構築作業を自動的に完了します.

> 注: 上記のプロセスは非常に時間がかかる可能性があります。ネットワーク条件が悪い場合、異なるボタンをクリックして再試行する必要がある場合があります。.

ビルドが完了すると、Android Studio の `Build` タブに `BUILD SUCCESSFUL in 1h 17m 34s` のようなメッセージが表示されます.

プロジェクトをパッケージ化して、Android デバイスにインストール可能な APK ファイルを生成します:

- デバッグ版 (デバッグバージョン)
    - `Build (ビルド)` -> `Build Bundle(s) / APK(s)` -> `Build APK(s)`
    - デフォルトの署名が含まれたデバッグ版のインストールパッケージを生成します
    - パスの例: `"D:\AutoJs6\app\build\outputs\apk\debug\"`
- リリース版 (リリースバージョン)
    - `Build (ビルド)` -> `Generate Signed Bundle / APK`
    - `APK` オプションを選択します
    - 署名ファイル (新規または選択) を準備して署名付きのリリース版インストールパッケージを生成します
    - パスの例: `"D:\AutoJs6\app\release\"`

> 参照: [Android Docs](https://developer.android.com/studio/run?hl=zh-cn)

******

### <a id="script-development-assistance"></a>スクリプト開発アシスト

******

AutoJs6に対応するスクリプトを開発するには、適切な開発ツールを使用する必要があります。:

- [VSCode](https://code.visualstudio.com/download) / [WebStorm](https://www.jetbrains.com/webstorm/download/) / [HBuilderX](https://www.dcloud.io/hbuilderx.html) ...

PCでスクリプトを作成してデバッグする場合、VSCodeプラグインを使用してPCと携帯電話を接続できます。:

- [AutoJs6-VSCode-Extension](http://vscext-project.autojs6.com) - AutoJs6 デバッガ (VSCode プラットフォーム エクステンション)

開発ツールを使用してコードを記述する際、コードのインテリセンス機能が開発者のコード記述を支援します。:

- [AutoJs6-TypeScript-Declarations](http://dts-project.autojs6.com) - AutoJs6型宣言ファイル (コード補完機能)

AutoJs6に関するAPIおよび使用方法については、常にアプリケーションドキュメントを参照できます。:

- [AutoJs6-Documentation](http://docs-project.autojs6.com) - AutoJs6アプリケーションドキュメント

既存のスクリプト開発プロジェクトを参考にして、個人のスクリプトプロジェクトのインスピレーションを得ることができます。:

- [Ant-Forest](https://github.com/TonyJiangWJ/Ant-Forest) - 蚂蚁森林のエネルギー自動収集スクリプト by [TonyJiangWJ](https://github.com/TonyJiangWJ)
- [Ant-Forest](https://github.com/SuperMonster003/Ant-Forest) - 蚂蚁森林のエネルギー自動収集スクリプト by [SuperMonster003](https://github.com/SuperMonster003)
- [autojs](https://github.com/e1399579/autojs) - Auto.jsのユーティリティスクリプト by [e1399579](https://github.com/e1399579)
- [autojsDemo](https://github.com/snailuncle/autojsDemo) - Auto.jsのデモ例 by [snailuncle](https://github.com/snailuncle)
- [autojs関連リポジトリ](https://github.com/topics/autojs) - GitHubでautojs話題に関するすべてのリポジトリ

******

### 貢献の参加

******

AutoJs6 プロジェクト開発に参加したすべての貢献者に感謝します.

|     <span style="word-break:keep-all;white-space:nowrap">貢献者</span>     |                   <span style="word-break:keep-all;white-space:nowrap">コミット数</span>                    | <span style="word-break:keep-all;white-space:nowrap">最近の提出</span> |
|:----------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------:|
|     <span style="word-break:keep-all;white-space:nowrap">[luckyloogn](https://github.com/luckyloogn)</span>      |       <span style="word-break:keep-all;white-space:nowrap">[3](https://github.com/SuperMonster003/AutoJs6/commits?author=luckyloogn)</span>        |                    <span style="word-break:keep-all;white-space:nowrap">`2025/01/01`</span>                    |
|           <span style="word-break:keep-all;white-space:nowrap">[kvii](https://github.com/kvii)</span>            |          <span style="word-break:keep-all;white-space:nowrap">[1](https://github.com/SuperMonster003/AutoJs6/commits?author=kvii)</span>           |                    <span style="word-break:keep-all;white-space:nowrap">`2024/10/16`</span>                    |
|  <span style="word-break:keep-all;white-space:nowrap">[chenguangming](https://github.com/chenguangming)</span>   | <span style="word-break:keep-all;white-space:nowrap">[2](https://github.com/SuperMonster003/AutoJs6/pulls?q=is%3Apr+author%3Achenguangming)</span> |                    <span style="word-break:keep-all;white-space:nowrap">`2024/05/14`</span>                    |
|         <span style="word-break:keep-all;white-space:nowrap">[LZX284](https://github.com/LZX284)</span>          |         <span style="word-break:keep-all;white-space:nowrap">[17](https://github.com/SuperMonster003/AutoJs6/commits?author=LZX284)</span>         |                    <span style="word-break:keep-all;white-space:nowrap">`2023/11/19`</span>                    |
|    <span style="word-break:keep-all;white-space:nowrap">[TonyJiangWJ](https://github.com/TonyJiangWJ)</span>     |       <span style="word-break:keep-all;white-space:nowrap">[4](https://github.com/SuperMonster003/AutoJs6/commits?author=TonyJiangWJ)</span>       |                    <span style="word-break:keep-all;white-space:nowrap">`2023/10/31`</span>                    |
| <span style="word-break:keep-all;white-space:nowrap">[little&#x2011;alei](https://github.com/little-alei)</span> |      <span style="word-break:keep-all;white-space:nowrap">[12](https://github.com/SuperMonster003/AutoJs6/commits?author=little-alei)</span>       |                    <span style="word-break:keep-all;white-space:nowrap">`2023/07/12`</span>                    |
|         <span style="word-break:keep-all;white-space:nowrap">[aiselp](https://github.com/aiselp)</span>          |    <span style="word-break:keep-all;white-space:nowrap">[6](https://github.com/SuperMonster003/AutoJs6/pulls?q=is%3Apr+author%3Aaiselp)</span>     |                    <span style="word-break:keep-all;white-space:nowrap">`2023/06/14`</span>                    |
|          <span style="word-break:keep-all;white-space:nowrap">[LYS86](https://github.com/LYS86)</span>           |          <span style="word-break:keep-all;white-space:nowrap">[2](https://github.com/SuperMonster003/AutoJs6/commits?author=LYS86)</span>          |                    <span style="word-break:keep-all;white-space:nowrap">`2023/06/03`</span>                    |

データは 2025 年 1 月 1 日 に更新されました。.

データ項目は `最近の提出` の降順で並べ替えられます.

新たに発行された未処理のプルリクエストは、マージされた後にデータ統計に含まれます.

一部の貢献者は [GitHub Contributors](https://github.com/SuperMonster003/AutoJs6/graphs/contributors) に正常に表示されず、コミット記録が空のままです。貢献履歴は [プルリクエスト](https://github.com/SuperMonster003/AutoJs6/pulls) から確認できます.

[//]: # (
    # --------------------------------------------------------------#
    # Before committing and pushing to the remote GitHub repository #
    # --------------------------------------------------------------#
    - CHANGELOG.md
        - Update entries for AutoJs6 by checking all changed files
        - Update entries for Gradle plugins [ implementation ]
        - Update version name and released date
        - Append related GitHub issues to changelog entries
    - README.md
        - The summary of the latest changelog for committing to Git [ DO NOT commit or push ]
        - Update badges like [ android studio / rhino / ... ]
        - Update android studio download links and version names
        - Update contribution section
    - Remove the part like [ alpha / beta / ... ] of VERSION_NAME in version.properties
    - Update dependencies TypeScript declarations if needed.
    - Re-generate documentation/markdown by running the python script
    - Check the two-way versions for AutoJs6 and VSCode ext, then publish the ext to Microsoft
    - Run Gradle task "app:assembleInrtRelease"
    - Build APK to determine the final VERSION_BUILD field
    - Run Gradle task "app:appendDigestToReleasedFiles"
    - Commit and push to GitHub
    - Publish the latest release with signed APKs
)