<!--suppress HtmlDeprecatedAttribute, HttpUrlsUsage -->

<div align="center">
  <p>
    <img src="https://s1.imagehub.cc/images/2023/03/07/af8ed087c9d354b9ab6142aae7bbafb6.png" alt="autojs6-banner_800×224" border="0" width="704" />
  </p>

  <p>JavaScript automation tool supporting accessibility service on the Android platform</p>

  <p>
    <a href="http://download.autojs6.com"><img alt="GitHub release (latest by date)" src="https://img.shields.io/github/v/release/SuperMonster003/AutoJs6"/></a>
    <a href="http://issues.autojs6.com"><img alt="GitHub closed issues" src="https://img.shields.io/github/issues/SuperMonster003/AutoJs6?color=009688"/></a>
    <a href="http://commit.autojs6.com/99a1d8490fac5b6d55f6f183db59ad833a2064ed"><img alt="Created" src="https://img.shields.io/date/1636632233?color=2e7d32&label=created"/></a>
    <br>
    <a href="https://github.com/mozilla/rhino"><img alt="Rhino" src="https://img.shields.io/badge/rhino-1.7.16--snapshot-A24232"/></a>
    <a href="https://developer.android.com/studio/archive"><img alt="Android Studio" src="https://img.shields.io/badge/android%20studio-2022.1+-B64FC8"/></a>
    <br>
    <a href="https://www.codefactor.io/repository/github/SuperMonster003/AutoJs6"><img alt="CodeFactor Grade" src="https://www.codefactor.io/repository/github/SuperMonster003/AutoJs6/badge"/></a>
    <a href="https://www.jetbrains.com/?from=AutoJs6"><img alt="JetBrains supporter" src="https://img.shields.io/badge/supporter-JetBrains-ee4677"/></a>
    <a href="http://project.autojs6.com/blob/master/LICENSE"><img alt="GitHub License" src="https://img.shields.io/github/license/SuperMonster003/AutoJs6?color=534BAE"/></a>
  </p>
</div>

******

### Languages

******

The current README.md supports the following languages:

 - [简体中文 [zh-Hans]](http://project.autojs6.com/blob/master/.readme/README-zh-Hans.md)
 - [繁體中文 (香港) [zh-Hant-HK]](http://project.autojs6.com/blob/master/.readme/README-zh-Hant-HK.md)
 - [繁體中文 (台灣) [zh-Hant-TW]](http://project.autojs6.com/blob/master/.readme/README-zh-Hant-TW.md)
 - English [en] # current
 - [Français [fr]](http://project.autojs6.com/blob/master/.readme/README-fr.md)
 - [Español [es]](http://project.autojs6.com/blob/master/.readme/README-es.md)
 - [日本語 [ja]](http://project.autojs6.com/blob/master/.readme/README-ja.md)
 - [한국어 [ko]](http://project.autojs6.com/blob/master/.readme/README-ko.md)
 - [Русский [ru]](http://project.autojs6.com/blob/master/.readme/README-ru.md)
 - [العربية [ar]](http://project.autojs6.com/blob/master/.readme/README-ar.md)

******

### Introduction

******

[Auto.js](https://github.com/hyb1996/Auto.js) is a JavaScript automation tool software for the Android platform that supports [Accessibility Service](https://developer.android.com/guide/topics/ui/accessibility/service?hl=en).

Auto.js was first released by [hyb1996](https://github.com/hyb1996) on `2017/01/27` and ceased maintenance on `2020/03/13`, with the final version name being `4.1.1 Alpha2` and build number `461`.

AutoJs6 is based on the final project of Auto.js, undergoing secondary development on `2021/12/01` and continues to be open-source and free.

The table below lists some Auto.js-related projects (sorted by development date):

| <span style="word-break:keep-all;white-space:nowrap">Project</span> |                                                             <span style="word-break:keep-all;white-space:nowrap">App Name</span>                                                              | <span style="word-break:keep-all;white-space:nowrap">Developer</span> | <span style="word-break:keep-all;white-space:nowrap">Development Start Date</span> | <span style="word-break:keep-all;white-space:nowrap">Development End Date</span> |
|:------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------:|:---------------------------------------------------------------------------------------------------------------------------------:|:-------------------------------------------------------------------------------------------------------------------------------:|
|     <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/hyb1996/Auto.js)</span>      |    <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/TonyJiangWJ/Auto.js/commit/268ec8895bbfa28fc7715154eb15b1c1eaaefd14#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span>     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2017/01/27`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2020/03/13`</span>                             |
|                     <span style="word-break:keep-all;white-space:nowrap">Auto.js Pro 7</span>                      |                                                                                     <span style="word-break:keep-all;white-space:nowrap">Auto.js</span>                                                                                      |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2019/03/13`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2019/07/08`</span>                             |
|                     <span style="word-break:keep-all;white-space:nowrap">Auto.js Pro 8</span>                      |                                                                                    <span style="word-break:keep-all;white-space:nowrap">AutoJsPro</span>                                                                                     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2019/10/13`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2021/07/24`</span>                             |
|   <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/TonyJiangWJ/Auto.js)</span>    | <span style="word-break:keep-all;white-space:nowrap">[Auto.js&#160;M](https://github.com/TonyJiangWJ/Auto.js/commit/268ec8895bbfa28fc7715154eb15b1c1eaaefd14#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span> |      <span style="word-break:keep-all;white-space:nowrap">[TonyJiangWJ](https://github.com/TonyJiangWJ)</span>       |                             <span style="word-break:keep-all;white-space:nowrap">`2019/11/21`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|      <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/kkevsekk1/AutoX)</span>       |                 <span style="white-space:pre">[Autox.js](https://github.com/kkevsekk1/AutoX/commit/8143e4ed893d4af05d22aa791b83a962f9959873#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span>                  |        <span style="word-break:keep-all;white-space:nowrap">[kkevsekk1](https://github.com/kkevsekk1)</span>         |                             <span style="word-break:keep-all;white-space:nowrap">`2020/07/24`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|        <span style="word-break:keep-all;white-space:nowrap">[Auto.js Pro 9](https://pro.autojs.org/)</span>        |                                                                                    <span style="word-break:keep-all;white-space:nowrap">AutoJsPro</span>                                                                                     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2021/03/28`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2023/02/09`</span>                             |
| <span style="word-break:keep-all;white-space:nowrap">[AutoJs6](https://github.com/SuperMonster003/AutoJs6)</span>  |  <span style="word-break:keep-all;white-space:nowrap">[AutoJs6](https://github.com/SuperMonster003/AutoJs6/commit/a8ce1b9acb541e9736c33134be3194c3148a15a3#diff-833a46a97033e77558372a2dce103fd6fee29aaaa899f610022a7aece592ee7bR27)</span>  |  <span style="word-break:keep-all;white-space:nowrap">[SuperMonster003](https://github.com/SuperMonster003)</span>   |                             <span style="word-break:keep-all;white-space:nowrap">`2021/12/01`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|      <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/kkevsekk1/AutoX)</span>       |            <span style="white-space:pre">[Autox.js&#160;v6](https://github.com/kkevsekk1/AutoX/commit/8b6776cff8b0fca4be4a52719b7d7d07c0a058f3#diff-51a0b488f963eb0be6c6599bf5df497313877cf5bdff3950807373912ac1cdc9R130)</span>             |           <span style="word-break:keep-all;white-space:nowrap">[wilinz](https://github.com/wilinz)</span>            |                             <span style="word-break:keep-all;white-space:nowrap">`2022/05/26`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|      <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/kkevsekk1/AutoX)</span>       |            <span style="white-space:pre">[Autox.js&#160;v7](https://github.com/kkevsekk1/AutoX/commit/484491fd5fe12b8203d0b09c181eb0f471c0ea9f#diff-8cff73265af19c059547b76aca8882cbaa3209291406f52df1dafbbc78e80c46R120)</span>             |           <span style="word-break:keep-all;white-space:nowrap">[aiselp](https://github.com/aiselp)</span>            |                             <span style="word-break:keep-all;white-space:nowrap">`2024/04/21`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |

The dates in the table are estimated and may differ from actual dates.

Auto.js Pro 7/8/9 in the table are paid versions, and the rest are free open-source versions.

******

### Functions

******

* Can be used as a JavaScript IDE (code completion/variable renaming/code formatting)
* Supports automation based on [Accessibility Service](https://developer.android.com/reference/android/accessibilityservice/AccessibilityService)
* Supports floating button quick actions (script recording and running/view package name and activity/layout analysis)
* Supports Selector API and provides control traversal/information retrieval/control operations (similar to [UiAutomator](https://developer.android.com/training/testing/ui-automator))
* Supports layout interface analysis (similar to Android Studio's LayoutInspector)
* Supports recording functionality and playback of recorded actions
* Supports screen capture/save screenshots/color search in images/image matching
* Supports [E4X](https://en.wikipedia.org/wiki/E4X) (ECMAScript for XML) for interface writing
* Supports packaging script files or projects into APK files
* Supports expanded functionality using Root privileges (screen click/slide/record/Shell)
* Supports use as a Tasker plugin
* Supports connection with VSCode for desktop development (requires [AutoJs6-VSCode-Extension](http://vscext-project.autojs6.com) plugin)

******

### Environment

******

- Android Operating System
- [API](https://developer.android.com/guide/topics/manifest/uses-sdk-element#ApiLevels) [24](https://developer.android.com/reference/android/os/Build.VERSION_CODES#N) ([7.0](https://zh.wikipedia.org/wiki/Android_Nougat)) [[N](https://developer.android.com/reference/android/os/Build.VERSION_CODES#N)] and above

******

### Manual

******

* [Application Documentation](https://docs.autojs6.com)
* [User Manual (to be written)](https://docs.autojs6.com/#/manual)
* [Troubleshooting](https://docs.autojs6.com/#/qa)
* [Project Compilation and Build](#project-compilation-and-build)
* [Script Development Assistance](#script-development-assistance)

******

### Major Changes

******

Compared to the final open-source version `4.1.1 Alpha2` of Auto.js, the main upgrades or changes in AutoJs6 are:

* Supports obtaining ADB privileges through [Shizuku](https://shizuku.rikka.app/introduction/) and using system API
* Supports building [WebSocket](https://docs.autojs6.com/#/webSocketType) instances to perform network requests based on the [WebSocket protocol](https://en.wikipedia.org/wiki/WebSocket)
* New modules [ [base64](https://docs.autojs6.com/#/base64) / [crypto](https://docs.autojs6.com/#/crypto) / [sqlite](https://docs.autojs6.com/#/sqlite) / [i18n](https://docs.autojs6.com/#/i18n) / [notice](https://docs.autojs6.com/#/notice) / [ocr](https://docs.autojs6.com/#/ocr) / [opencc](https://docs.autojs6.com/#/opencc) / [qrcode](https://docs.autojs6.com/#/qrcode) / [shizuku](https://docs.autojs6.com/#/shizuku) / ... ]
* Multilingual support [ Spanish / French / Russian / Arabic / Japanese / Korean / English / Simplified Chinese / Traditional Chinese / ... ]
* Night mode adaptation [ Settings page / Documentation page / Layout analysis page / Floating window / ... ]
* [VSCode plugin](http://vscext-project.autojs6.com) supports both client (LAN) and server (LAN/ADB) connection methods
* [Rhino](https://github.com/mozilla/rhino/) engine upgraded from [v1.7.7.2](https://github.com/mozilla/rhino/releases/tag/Rhino1_7_7_2_Release) to [v1.7.16-SNAPSHOT](http://rhino.autojs6.com/blob/master/gradle.properties#L3)
    * Unicode [code point](https://developer.mozilla.org/en-US/docs/Glossary/Code_point) escape support for [supplementary plane](https://en.wikipedia.org/wiki/Plane_(Unicode)#Supplementary_Multilingual_Plane) characters
       ```javascript
       '\u{1D160}'; /* stands for "𝅘𝅥𝅮", traditional method: '\uD834\uDD60'. */
       ```
    * Supports [Object.values()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/values)
       ```javascript
       Object.values({name: 'Max', age: 4}); // ['max', 4]
       ```
    * Supports [Array.prototype.includes()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/includes)
       ```javascript
       [10, 20, NaN].includes(20); // true
       ```
    * Supports [BigInt](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/BigInt)
       ```javascript
       typeof 567n === 'bigint'; // true
       ```
    * Supports [template strings](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Template_literals)
       ```javascript
       `Lucky number: ${(Math.random() * 100).toFixed(0)}`
       ```
    * View more new features of the Rhino engine [here](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/RHINO.md)
    * View Rhino engine [compatibility list](https://mozilla.github.io/rhino/compat/engines.html)

******

### Version Histories

******

# v6.6.1

###### 2025/01/01

* `Feature` Pinyin module for Chinese Pinyin conversion (Refer to Project Documentation > [Chinese Pinyin](https://docs.autojs6.com/#/pinyin))
* `Feature` Pinyin4j module for Chinese Pinyin conversion (Refer to Project Documentation > [Chinese Pinyin](https://docs.autojs6.com/#/pinyin4j))
* `Feature` Methods UiObject#isSimilar and UiObjectCollection#isSimilar for determining whether a control or a collection of controls is similar
* `Feature` Global method "currentComponent", used to obtain the name information of the currently active component
* `Fix` Issue where the project could not compile properly in certain environments due to a rollback to an earlier version
* `Fix` "Non-primitive value" exception that may occur when calling non-existent methods
* `Fix` Issue where script shortcuts could not be added properly on certain devices (tentative fix) _[`issue #221`](http://issues.autojs6.com/221)_
* `Fix` Incorrect parameter type restrictions for the automator.click/longClick methods _[`issue #275`](http://issues.autojs6.com/275)_
* `Fix` Issue where selectors did not support ConsString type parameters _[`issue #277`](http://issues.autojs6.com/277)_
* `Fix` Missing methods and properties on UiObjectCollection instances
* `Improvement` The packaging page supports signature configuration, keystore management, and permission settings (by [luckyloogn]()) _[`pr #286`]()_
* `Improvement` Improved accuracy in identifying the current package name and activity name of the floating window (Priority: Shizuku > Root > A11Y)
* `Improvement` Improved accuracy in recognizing `currentPackage` and `currentActivity` (Priority: Shizuku > Root > A11Y)
* `Improvement` Restore the ability to select text content of individual entries in the log activity window via double-click or long press _[`issue #280`](http://issues.autojs6.com/280)_
* `Improvement` Recover as much critical information as possible for script projects when project.json is corrupted
* `Improvement` Automatically convert Simplified Chinese to Pinyin (including multi-tone characters) for generated package name suffixes when packaging single files
* `Improvement` Support for negative arguments in the UiSelector#findOnce and UiSelector#find methods
* `Improvement` Enhanced adaptability of app.startActivity/startDualActivity methods
* `Improvement` UI elements and className-related selectors now support more package name prefix omission forms (e.g., RecyclerView, Snackbar, etc.)
* `Improvement` Synchronize with the latest upstream code of the Rhino engine and adapt it to the existing project
* `Improvement` Some dependency or local library version adjustments _[`CHANGELOG.md`](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG.md#v661)_

# v6.6.0

###### 2024/12/02 - Built-in module rewrite, upgrade cautiously

* `Hint` The built-in modules are rewritten in Kotlin to enhance script execution efficiency, but iterative improvements are needed.
* `Hint` The built-in init.js file is empty by default, allowing developers to extend built-in modules or mount external modules.
* `Feature` Axios module / Cheerio module (Ref to [AutoX](https://github.com/kkevsekk1/AutoX))
* `Feature` SQLite module for simple operations on SQLite databases (Ref to [Auto.js Pro](https://g.pro.autojs.org/)) (See project documentation > [SQLite](https://docs.autojs6.com/#/sqlite))
* `Feature` MIME module for processing and parsing MIME type strings (See project documentation > [MIME](https://docs.autojs6.com/#/mime))
* `Feature` Nanoid module for string ID generation (Ref to [ai/nanoid](https://github.com/ai/nanoid))
* `Feature` Sysprops module for obtaining runtime environment configuration data (See project documentation > [System Properties](https://docs.autojs6.com/#/sysprops))
* `Feature` OCR module supports [Rapid OCR](https://github.com/RapidAI/RapidOCR) engine
* `Feature` Layout analysis supports window switching (Ref to [Auto.js Pro](https://g.pro.autojs.org/))
* `Feature` auto.clearCache method supports clearing control caches (Ref to [Auto.js Pro](https://g.pro.autojs.org/))
* `Feature` threads.pool method supports simple application of thread pools (Ref to [Auto.js Pro](https://g.pro.autojs.org/))
* `Feature` images.matchTemplate method adds useTransparentMask option parameter to support transparent image search (Ref to [Auto.js Pro](https://g.pro.autojs.org/))
* `Feature` images.requestScreenCaptureAsync method for asynchronously requesting screenshot permissions in UI mode (Ref to [Auto.js Pro](https://g.pro.autojs.org/))
* `Feature` images.requestScreenCapture method adds isAsync option parameter to support asynchronous screenshot capture (Ref to [Auto.js Pro](https://g.pro.autojs.org/))
* `Feature` images.on('screen_capture', callback) and other event listener methods support listening for screen capture availability events (Ref to [Auto.js Pro](https://g.pro.autojs.org/))
* `Feature` images.stopScreenCapture method supports actively releasing resources related to screenshot applications (Ref to [Auto.js Pro](https://g.pro.autojs.org/))
* `Feature` Images.psnr/mse/ssim/mssim/hist/ncc and images.getSimilarity methods for obtaining image similarity metrics
* `Feature` images.isGrayscale method for determining whether an image is grayscale
* `Feature` images.invert method for negative image conversion
* `Feature` s13n.point/time methods for standardizing point objects and duration objects (See project documentation > [Normalization](https://docs.autojs6.com/#/s13n))
* `Feature` console module's gravity, touchThrough, backgroundTint methods (See project documentation > [Console](https://docs.autojs6.com/#/console))
* `Feature` Mathx.randomInt/Mathx.randomFloat methods for returning random integers or random floating-point numbers within a specified range
* `Feature` app.launchDual/startDualActivity methods for handling dual app launch (Requires Shizuku or Root permissions) (Experimental)
* `Feature` app.kill method for forcefully stopping an app (Requires Shizuku or Root permissions)
* `Feature` floaty.getClip method for indirectly obtaining clipboard content using a floating window
* `Fix` Memory leak in View Binding of Fragment subclasses (e.g., [DrawerFragment](https://github.com/SuperMonster003/AutoJs6/blob/17616504ab0bba93b30ab7abc67108ee5253f39a/app/src/main/java/org/autojs/autojs/ui/main/drawer/DrawerFragment.kt#L369) / [ExplorerFragment](https://github.com/SuperMonster003/AutoJs6/blob/17616504ab0bba93b30ab7abc67108ee5253f39a/app/src/main/java/org/autojs/autojs/ui/main/scripts/ExplorerFragment.kt#L48))
* `Fix` Instance memory leak in classes such as [ScreenCapture](https://github.com/SuperMonster003/AutoJs6/blob/17616504ab0bba93b30ab7abc67108ee5253f39a/app/src/main/java/org/autojs/autojs/core/image/capture/ScreenCapturer.java#L70) / [ThemeColorPreference](https://github.com/SuperMonster003/AutoJs6/blob/10960ddbee71f75ef80907ad5b6ab42f3e1bf31e/app/src/main/java/org/autojs/autojs/ui/settings/ThemeColorPreference.kt#L21)
* `Fix` Issue causing app crash when requesting screenshot permissions on Android 14+ (by [chenguangming](https://github.com/chenguangming)) _[`pr #242`](http://pr.autojs6.com/242)_
* `Fix` Issue causing app crash when starting foreground service on Android 14+
* `Fix` Issue with run button in code editor not lighting up properly on Android 14+
* `Fix` App may not run properly after packaging due to missing necessary library files _[`issue #202`](http://issues.autojs6.com/202)_ _[`issue #223`](http://issues.autojs6.com/223)_ _[`pr #264`](http://pr.autojs6.com/264)_
* `Fix` App crash when editing project due to missing specified icon resources _[`issue #203`](http://issues.autojs6.com/203)_
* `Fix` Unable to use parameters properly to obtain screenshot resources of specified screen orientation when requesting screenshot permissions
* `Fix` Issue with some devices unable to add script shortcuts properly (Trial fix) _[`issue #221`](http://issues.autojs6.com/221)_
* `Fix` Cumulative request sending delay issue with methods related to sending requests in http module _[`issue #192`](http://issues.autojs6.com/192)_
* `Fix` Shizuku service may not work properly before AutoJs6 enters the main activity page (Trial fix) _[`issue #255`](http://issues.autojs6.com/255)_
* `Fix` random(min, max) method may have out-of-bounds results
* `Fix` Issue where result type parameter of pickup methods cannot be properly passed empty arrays
* `Fix` Issue where control rectangle obtained by UiObject#bounds() may be inadvertently modified, breaking its immutability
* `Fix` Issue with text/button/input elements where text containing half-width double quotes cannot be parsed properly
* `Fix` Issue with text/textswitcher elements where autoLink attribute functionality fails
* `Fix` Issue with different scripts erroneously sharing the same ScriptRuntime object
* `Fix` Issue with global variables HEIGHT and WIDTH losing dynamically-generated Getter properties
* `Fix` Issue with potential high-latency startup caused by RootShell loading on script startup
* `Fix` Issue with floating console window background color setting leading to loss of rectangular rounding style
* `Fix` Access service auto-start may encounter abnormal service issues (Trial fix)
* `Fix` Issue with triggering ViewPager switch when swiping left or right on WebView control on homepage document page
* `Fix` Issue with file manager unable to recognize file extensions containing uppercase letters
* `Fix` File manager may not automatically recognize project when first entering project directory
* `Fix` Issue with file manager page unable to refresh automatically after deleting folder
* `Fix` Issue with file manager sorting files and folders where ASCII initial letter names are put back
* `Fix` FAILED ASSERTION exception in code editor debug function
* `Fix` Issue with unable to debug again properly after closing editor during code editor debug process
* `Fix` Issue with potentially omitting end characters when jumping to line end in code editor
* `Fix` Issue with flickering screen when starting log activity page on main activity page
* `Fix` Issue with packaged app unable to use opencc module properly
* `Improvement` Click prompt experience for 'Unavailable ABI' control on package page
* `Improvement` Supports using Shizuku to control 'Pointer Location' display switch
* `Improvement` Supports using Shizuku to control 'Projection Media' and 'Modify Secure Settings' permission switches
* `Improvement` Automator.gestureAsync/gesturesAsync supports callback function parameters
* `Improvement` tasks module uses synchronous way for database operations to avoid potential data access inconsistencies
* `Improvement` Script execution mode supports pipeline symbol separation mode parameters (e.g., starting with `"ui|auto";`)
* `Improvement` Script execution mode supports single quotes and backticks and allows omitting semicolons (e.g., starting with `'ui';` or `'ui'`)
* `Improvement` Script execution mode supports quick import of built-in extension modules such as axios, cheerio, and dayjs (e.g., starting with `"axios";`)
* `Improvement` Script execution mode supports x or jsox mode parameters for quick enabling of JavaScript built-in object extension modules (e.g., starting with `"x";`)
* `Improvement` img element src and path attributes support local relative paths (e.g., `<img src="a.png"` />)
* `Improvement` Code editor supports intelligently determining insertion location when importing Java classes and package names
* `Improvement` images module supports using paths directly as image parameters
* `Improvement` importPackage supports string parameters
* `Improvement` Server mode IP address supports clipboard import with intelligent recognition and smart conversion with space key
* `Improvement` File manager supports default prefix selection when creating new files and automatically generates appropriate numeric suffix
* `Improvement` File manager specifically informs on exception message when running project _[`issue #268`](http://issues.autojs6.com/268)_
* `Improvement` File manager supports more types and displays corresponding icon symbols (supports over 800 file types)
* `Improvement` Editable file types (jpg/doc/pdf, etc.) in file manager have added edit buttons
* `Improvement` APK files in file manager support viewing basic information, Manifest information, and permissions list
* `Improvement` Audio/video media files in file manager support viewing basic information and MediaInfo information
* `Improvement` Package single file support auto-fill appropriate standardized package name and invalid character filter prompt
* `Improvement` Package single file support automatically sets icon and auto-increments version number and version name based on installed same package name application
* `Improvement` Package configuration file supports abis/libs option to specify default included ABI architecture and libraries
* `Improvement` Support relevant message prompts when abis/libs options of package configuration file are invalid or unavailable
* `Improvement` LeakCanary is excluded from official release version to avoid unnecessary growth
* `Improvement` All English comments in project source code are accompanied by Simplified Chinese translations to enhance readability
* `Improvement` README and CHANGELOG support multi-language (Automatically generated by script)
* `Improvement` Enhance Gradle build script's version adaptability
* `Improvement` Some dependency or local library version adjustments _[`CHANGELOG.md`](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG.md#v660)_

# v6.5.0

###### 2023/12/02

* `Feature` opencc module (Refer to Project Documentation > [Chinese Conversion](https://docs.autojs6.com/#/opencc)) (Ref to [LZX284](https://github.com/SuperMonster003/AutoJs6/pull/187/files#diff-8cff73265af19c059547b76aca8882cbaa3209291406f52df1dafbbc78e80c46R268))
* `Feature` UiSelector adds [plus](https://docs.autojs6.com/#/uiObjectType?id=m-plus) and [append](https://docs.autojs6.com/#/uiObjectType?id=m-append) methods _[`issue #115`](http://issues.autojs6.com/115)_
* `Feature` Packaging application page adds support for filtering ABIs and libraries (Ref to [AutoX](https://github.com/kkevsekk1/AutoX)) _[`issue #189`](http://issues.autojs6.com/189)_
* `Fix` Abnormally large file size issue in packaged applications (Ref to [AutoX](https://github.com/kkevsekk1/AutoX) / [LZX284](https://github.com/SuperMonster003/AutoJs6/pull/187/files#diff-d932ac49867d4610f8eeb21b59306e8e923d016cbca192b254caebd829198856R61)) _[`issue #176`](http://issues.autojs6.com/176)_
* `Fix` Issue where packaged applications cannot display and print some exception messages
* `Fix` Issue where selecting application icon on packaging application page might show empty icon
* `Fix` Context not initialized exception when packaging application includes MLKit Google OCR library
* `Fix` ocr.<u>mlkit/ocr</u>.<u>recognizeText/detect</u> methods not working
* `Fix` Mismatch between displayed language and application setting language for some texts (such as log page)
* `Fix` Text overflow issue in home page drawer switch items for some languages
* `Fix` Issue where accessibility service automatically closes immediately after being enabled on some devices without any prompt messages _[`issue #181`](http://issues.autojs6.com/181)_
* `Fix` Issue where enabling accessibility service on some devices might cause application crash due to physical keys (attempted fix) _[`issue #183`](http://issues.autojs6.com/183)_ _[`issue #186`](http://issues.autojs6.com/186#issuecomment-1817307790)_
* `Fix` Issue with pickup functionality after restarting accessibility service using auto(true) (attempted fix) _[`issue #184`](http://issues.autojs6.com/184)_
* `Fix` Issue where creating floating window in floaty module might cause application crash when dragging (attempted fix)
* `Fix` Issue where app.startActivity cannot use shorthand parameters _[`issue #182`](http://issues.autojs6.com/182)_ _[`issue #188`](http://issues.autojs6.com/188)_
* `Fix` Issue where code throws exception when imported class name conflicts with global variable using importClass _[`issue #185`](http://issues.autojs6.com/185)_
* `Fix` Issue where accessibility service cannot be used on Android 7.x
* `Fix` Issue where runtime.<u>loadJar/loadDex</u> methods might not work properly on Android 14 (attempted fix)
* `Fix` Issue where 'Layout Bounds Analysis' and 'Layout Hierarchy Analysis' are unavailable in Android system quick settings panel _[`issue #193`](http://issues.autojs6.com/193)_
* `Fix` Issue where auto-update check might cause application [ANR](https://developer.android.com/topic/performance/vitals/anr) (attempted fix) _[`issue #186`](http://issues.autojs6.com/186)_
* `Fix` Issue where file manager cannot return to workspace path page after clicking 'Up' button in example code folder _[`issue #129`](http://issues.autojs6.com/129)_
* `Fix` Issue where replace button is not shown when using replace function in code editor
* `Fix` Issue where long-press delete in code editor might cause application crash (attempted fix)
* `Fix` Issue where fx button in code editor cannot show module function quick panel
* `Fix` Issue where module function quick panel button function name might overflow in code editor
* `Improvement` The code editor module's quick function panel adapts to night mode.
* `Improvement` The startup page of the packaged application is adapted to night mode, and the layout of application icons is adjusted.
* `Improvement` The packaged application page supports cursor navigation using the ENTER key on the software keyboard.
* `Improvement` The packaged application page supports toggling select-all state by clicking on ABI and library titles.
* `Improvement` The default ABI selection is made intelligent on the packaged application page with added guide prompts for unselectable items.
* `Improvement` The file manager adjusts the display of menu items based on the type and characteristics of files and folders.
* `Improvement` The file manager's folder right-click menu adds a packaging application option.
* `Improvement` When accessibility services are enabled but malfunction, an abnormal state is reflected in the drawer switch of the AutoJs6 homepage.
* `Improvement` The console includes detailed stack information when printing error messages.
* `Improvement` Some dependency or local library version adjustments _[`CHANGELOG.md`](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG.md#v650)_

##### For more version history, refer to

* [CHANGELOG.md](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG-en.md)

******

### <a id="project-compilation-and-build"></a>Project Compilation and Build

******

For debugging or developing the AutoJs6 open-source project, you can use [Android Studio](https://pro.autojs.org/) (a product of [Google](https://www.google.com/)) or [IntelliJ IDEA](https://www.jetbrains.com/idea/) (a product of [Jetbrains](https://www.jetbrains.com/)).

This section introduces the compilation and build methods of the AutoJs6 open-source project using Android Studio as an example. IntelliJ IDEA is similar.

#### Android Studio Preparation

Download `Android Studio Ladybug Feature Drop | 2024.2.2 RC 2` version (choose one as needed):

- [android-studio-2024.2.2.12-windows.exe](https://redirector.gvt1.com/edgedl/android/studio/install/2024.2.2.12/android-studio-2024.2.2.12-windows.exe) (1.14 GB)
- [android-studio-2024.2.2.12-windows.zip](https://redirector.gvt1.com/edgedl/android/studio/ide-zips/2024.2.2.12/android-studio-2024.2.2.12-windows.zip) (1.15 GB)

> Note: The release date for the above version is Dec 16 , 2024. To download other versions, or if the above link is invalid, you can visit the [Android Studio release archive](https://developer.android.com/studio/archive?hl=en) page..

Install or extract the above file, then run the Android Studio software (e.g., `"D:\android-studio\bin\studio64.exe"`).

#### Android SDK Preparation

> Note: If the Android SDK is already installed on the computer system, this section can be skipped.

Use `CTRL + ALT + S` in Android Studio to open the settings page:

```text
Appearance & Behavior -> 
System Settings -> 
Android SDK
```

If the `Android SDK Location` field is blank, click the `Edit` button on the right and click `Next` multiple times in the pop-up window.

> Note: During the process, one or more relevant agreements may need to be accepted to continue.

Once the related resources are downloaded and installed, click the `Finish` button.  
The `Android SDK Location` field above will auto-populate with the path, completing the SDK preparation work.

#### Android SDK Tools Preparation

AutoJs6 requires certain SDK tools (like NDK and CMake).

> Note: If all required Android SDK Tools for AutoJs6 are already installed on the computer system, this section can be skipped.

Use `CTRL + ALT + S` in Android Studio to open the settings page:

```text
Appearance & Behavior -> 
System Settings -> 
Android SDK -> 
SDK Tools (located in the right window)
```

Check `Show Package Details`, click NDK and CMake respectively to ensure the corresponding version tools are checked, the version information of the SDK tools is located in the `version.properties` file in the root directory of the AutoJs6 project.

#### JDK Preparation

The `JDK (Java Development Kit)` version required for the AutoJs6 project should be at least `17`, but `19` or higher is recommended.

As of Jan 1 , 2025, AutoJs6 supports up to version `23` of the JDK.

> Note: If the JDK is already installed on the computer system and the version meets the above requirements, this section can be skipped.

JDK can be downloaded directly via the IDE or from the [Oracle website](https://www.oracle.com/java/technologies/downloads/).

Use `CTRL + ALT + S` in Android Studio to open the settings page:

```text
Build, Execution, Deployment -> 
Build Tools -> 
Gradle
```

`Gradle JDK` can be chosen or added with different versions of JDK.

If a suitable version of the JDK (>= `17`) already exists in the list, it can be selected directly.  
Alternatively, you can choose `Download JDK` to download a suitable JDK, click the `Download` button and wait for the download to complete.  
You can also choose `Add JDK` to add an existing local JDK, locating its directory and completing the JDK addition.

#### AutoJs6 Resources Cloning

Click `Get from VCS` button on the main page of Android Studio.  
Fill `URL` field with `https://github.com/SuperMonster003/AutoJs6.git`,  
The `Directory` field can be modified to a specific path if needed.  
Click the `Clone` button, wait for the AutoJs6 project resources to be cloned to the local device.

> Note: The above process may require the installation of [Git](https://git-scm.com/download).

#### AutoJs6 Project Building

After cloning, Android Studio will open the AutoJs6 project window and automatically complete the preliminary `Dependencies` download and Gradle build work.

> Note: The above process may take a long time. If network conditions are poor, it may need to be retried multiple times (click the Retry button).

Upon completion of the build, the `Build` tab in Android Studio will show a message similar to `BUILD SUCCESSFUL in 1h 17m 34s`.

Package the project and generate an APK file that can be installed on an Android device:

- Debug Version
    - `Build` -> `Build Bundle(s) / APK(s)` -> `Build APK(s)`
    - Generate signed debug APK
    - Path example: `"D:\AutoJs6\app\build\outputs\apk\debug\"`
- Release Version
    - `Build` -> `Generate Signed Bundle / APK`
    - Select `APK` option
    - Prepare the signing file (create new or select existing), generate the signed release package
    - Path example: `"D:\AutoJs6\app\release\"`

> Reference: [Android Docs](https://developer.android.com/studio/run?hl=zh-cn)

******

### <a id="script-development-assistance"></a>Script Development Assistance

******

To develop scripts that run with AutoJs6, appropriate development tools must be used:

- [VSCode](https://code.visualstudio.com/download) / [WebStorm](https://www.jetbrains.com/webstorm/download/) / [HBuilderX](https://www.dcloud.io/hbuilderx.html) ...

For writing and debugging scripts on a PC, the VSCode plugin can enable PC-to-phone connectivity:

- [AutoJs6-VSCode-Extension](http://vscext-project.autojs6.com) - AutoJs6 debugger (VSCode platform plugin)

When writing code using development tools, code completion functionality can better assist developers in completing code:

- [AutoJs6-TypeScript-Declarations](http://dts-project.autojs6.com) - AutoJs6 declaration files (code completion)

When writing code, AutoJs6-related API and usage can be consulted in the documentation at any time:

- [AutoJs6-Documentation](http://docs-project.autojs6.com) - AutoJs6 application documentation

Existing script development projects can serve as references and inspire creativity for personal script projects:

- [Ant-Forest](https://github.com/TonyJiangWJ/Ant-Forest) - Ant Forest energy auto-collect script by [TonyJiangWJ](https://github.com/TonyJiangWJ)
- [Ant-Forest](https://github.com/SuperMonster003/Ant-Forest) - Ant Forest energy auto-collect script by [SuperMonster003](https://github.com/SuperMonster003)
- [autojs](https://github.com/e1399579/autojs) - Auto.js utility scripts by [e1399579](https://github.com/e1399579)
- [autojsDemo](https://github.com/snailuncle/autojsDemo) - Auto.js demonstration example by [snailuncle](https://github.com/snailuncle)
- [autojs related repositories](https://github.com/topics/autojs) - All repositories related to the autojs topic on GitHub

******

### Contribution

******

Thank you to everyone who contributed to the AutoJs6 project development.

|     <span style="word-break:keep-all;white-space:nowrap">Contributors</span>     |                   <span style="word-break:keep-all;white-space:nowrap">Number of Commits</span>                    | <span style="word-break:keep-all;white-space:nowrap">Recent Submissions</span> |
|:----------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------:|
|     <span style="word-break:keep-all;white-space:nowrap">[luckyloogn](https://github.com/luckyloogn)</span>      |       <span style="word-break:keep-all;white-space:nowrap">[3](https://github.com/SuperMonster003/AutoJs6/commits?author=luckyloogn)</span>        |                    <span style="word-break:keep-all;white-space:nowrap">`2025/01/01`</span>                    |
|           <span style="word-break:keep-all;white-space:nowrap">[kvii](https://github.com/kvii)</span>            |          <span style="word-break:keep-all;white-space:nowrap">[1](https://github.com/SuperMonster003/AutoJs6/commits?author=kvii)</span>           |                    <span style="word-break:keep-all;white-space:nowrap">`2024/10/16`</span>                    |
|  <span style="word-break:keep-all;white-space:nowrap">[chenguangming](https://github.com/chenguangming)</span>   | <span style="word-break:keep-all;white-space:nowrap">[2](https://github.com/SuperMonster003/AutoJs6/pulls?q=is%3Apr+author%3Achenguangming)</span> |                    <span style="word-break:keep-all;white-space:nowrap">`2024/05/14`</span>                    |
|         <span style="word-break:keep-all;white-space:nowrap">[LZX284](https://github.com/LZX284)</span>          |         <span style="word-break:keep-all;white-space:nowrap">[17](https://github.com/SuperMonster003/AutoJs6/commits?author=LZX284)</span>         |                    <span style="word-break:keep-all;white-space:nowrap">`2023/11/19`</span>                    |
|    <span style="word-break:keep-all;white-space:nowrap">[TonyJiangWJ](https://github.com/TonyJiangWJ)</span>     |       <span style="word-break:keep-all;white-space:nowrap">[4](https://github.com/SuperMonster003/AutoJs6/commits?author=TonyJiangWJ)</span>       |                    <span style="word-break:keep-all;white-space:nowrap">`2023/10/31`</span>                    |
| <span style="word-break:keep-all;white-space:nowrap">[little&#x2011;alei](https://github.com/little-alei)</span> |      <span style="word-break:keep-all;white-space:nowrap">[12](https://github.com/SuperMonster003/AutoJs6/commits?author=little-alei)</span>       |                    <span style="word-break:keep-all;white-space:nowrap">`2023/07/12`</span>                    |
|         <span style="word-break:keep-all;white-space:nowrap">[aiselp](https://github.com/aiselp)</span>          |    <span style="word-break:keep-all;white-space:nowrap">[6](https://github.com/SuperMonster003/AutoJs6/pulls?q=is%3Apr+author%3Aaiselp)</span>     |                    <span style="word-break:keep-all;white-space:nowrap">`2023/06/14`</span>                    |
|          <span style="word-break:keep-all;white-space:nowrap">[LYS86](https://github.com/LYS86)</span>           |          <span style="word-break:keep-all;white-space:nowrap">[2](https://github.com/SuperMonster003/AutoJs6/commits?author=LYS86)</span>          |                    <span style="word-break:keep-all;white-space:nowrap">`2023/06/03`</span>                    |

Data updated on Jan 1 , 2025.

Data entries sorted in descending order by `recent submissions`.

Newly initiated, unprocessed Pull Requests will be included in the data statistics after merging.

Some contributors do not appear correctly in the [GitHub Contributors](https://github.com/SuperMonster003/AutoJs6/graphs/contributors) due to empty contribution records, but their contribution records can still be viewed via [Pull Request](https://github.com/SuperMonster003/AutoJs6/pulls).

[//]: # (
    # --------------------------------------------------------------#
    # Before committing and pushing to the remote GitHub repository #
    # --------------------------------------------------------------#
    - CHANGELOG.md
        - Update entries for AutoJs6 by checking all changed files
        - Update entries for Gradle plugins [ implementation ]
        - Update version name and released date
        - Append related GitHub issues to changelog entries
    - README.md
        - The summary of the latest changelog for committing to Git [ DO NOT commit or push ]
        - Update badges like [ android studio / rhino / ... ]
        - Update android studio download links and version names
        - Update contribution section
    - Remove the part like [ alpha / beta / ... ] of VERSION_NAME in version.properties
    - Update dependencies TypeScript declarations if needed.
    - Re-generate documentation/markdown by running the python script
    - Check the two-way versions for AutoJs6 and VSCode ext, then publish the ext to Microsoft
    - Run Gradle task "app:assembleInrtRelease"
    - Build APK to determine the final VERSION_BUILD field
    - Run Gradle task "app:appendDigestToReleasedFiles"
    - Commit and push to GitHub
    - Publish the latest release with signed APKs
)