******

### История версий

******

# v6.6.1

###### 2025/01/01

* `Новое` Модуль Pinyin для преобразования китайского пиньиня (См. документацию проекта > [Китайский Пиньинь](https://docs.autojs6.com/#/pinyin))
* `Новое` Модуль Pinyin4j для преобразования китайского пиньиня (См. документацию проекта > [Китайский Пиньинь](https://docs.autojs6.com/#/pinyin4j))
* `Новое` Методы UiObject#isSimilar и UiObjectCollection#isSimilar для определения, схожи ли элементы управления или их коллекции
* `Новое` Глобальный метод "currentComponent", используемый для получения информации о названии текущего активного компонента
* `Исправление` Ошибка, из-за которой проект не мог быть корректно скомпилирован в некоторых средах из-за отката на предыдущую версию
* `Исправление` Исключение "непримитивное значение", которое могло возникать при вызове несуществующих методов
* `Исправление` Ошибка, из-за которой ярлыки скриптов не могли быть корректно добавлены на некоторых устройствах (промежуточное исправление) _[`issue #221`](http://issues.autojs6.com/221)_
* `Исправление` Ошибка ограничения типа параметров для методов automator.click/longClick _[`issue #275`](http://issues.autojs6.com/275)_
* `Исправление` Ошибка, из-за которой селекторы не поддерживали параметры типа ConsString _[`issue #277`](http://issues.autojs6.com/277)_
* `Исправление` Ошибка, из-за которой экземпляры UiObjectCollection теряли собственные методы и свойства
* `Улучшение` Страница упаковки поддерживает настройку подписи, управление хранилищем ключей и настройку разрешений (автор [luckyloogn]()) _[`pr #286`]()_
* `Улучшение` Улучшена точность распознавания текущего имени пакета и имени активности для плавающего окна (приоритет: Shizuku > Root > A11Y)
* `Улучшение` Улучшена точность распознавания currentPackage и currentActivity (приоритет: Shizuku > Root > A11Y)
* `Улучшение` Восстановлена возможность выбора текста в отдельных записях в окне лога двойным щелчком или длительным нажатием _[`issue #280`](http://issues.autojs6.com/280)_
* `Улучшение` Максимальное восстановление ключевой информации для проектов скриптов в случае повреждения файла project.json
* `Улучшение` Автоматическая конвертация упрощенного китайского в пиньинь (включая многозначные символы) для суффиксов пакетов, создаваемых при упаковке отдельных файлов
* `Улучшение` Поддержка отрицательных аргументов в методах UiSelector#findOnce и UiSelector#find
* `Улучшение` Улучшена адаптивность методов app.startActivity/startDualActivity
* `Улучшение` Поддержка дополнительных сокращённых форм префиксов имён пакетов в селекторах, связанных с элементами UI и className (например, RecyclerView, Snackbar и т. д.)
* `Улучшение` Синхронизировать последний код из официального репозитория Rhino и адаптировать его к существующему проекту
* `Зависимость` Добавлена Pinyin4j версии 2.5.0
* `Зависимость` Добавлена Jieba Analysis версии 1.0.3-SNAPSHOT (изменённая версия)
* `Зависимость` Обновление версии Gradle с 8.11.1 до 8.12

# v6.6.0

###### 2024/12/02 - Переписаны встроенные модули, обновляйте осторожно

* `Подсказка` Встроенные модули переписываются на Kotlin для повышения эффективности выполнения сценариев, но необходимы итеративные улучшения.
* `Подсказка` Встроенный файл init.js по умолчанию пуст, что позволяет разработчикам расширять встроенные модули или монтировать внешние модули.
* `Новое` Модуль Axios / Модуль Cheerio (Ссылка на [AutoX](https://github.com/kkevsekk1/AutoX))
* `Новое` Модуль SQLite для простых операций с базами данных SQLite (Ссылка на [Auto.js Pro](https://g.pro.autojs.org/)) (См. документацию проекта > [SQLite](https://docs.autojs6.com/#/sqlite))
* `Новое` Модуль MIME для обработки и анализа строк MIME-типов (См. документацию проекта > [MIME](https://docs.autojs6.com/#/mime))
* `Новое` Модуль Nanoid для генерации строковых идентификаторов (Ссылка на [ai/nanoid](https://github.com/ai/nanoid))
* `Новое` Модуль Sysprops для получения данных конфигурации среды выполнения (См. документацию проекта > [Системные свойства](https://docs.autojs6.com/#/sysprops))
* `Новое` Модуль OCR поддерживает движок [Rapid OCR](https://github.com/RapidAI/RapidOCR)
* `Новое` Анализ макета поддерживает изменение окна (Ссылка на [Auto.js Pro](https://g.pro.autojs.org/))
* `Новое` Метод auto.clearCache поддерживает очистку кешей управления (Ссылка на [Auto.js Pro](https://g.pro.autojs.org/))
* `Новое` Метод threads.pool поддерживает простое применение пулов потоков (Ссылка на [Auto.js Pro](https://g.pro.autojs.org/))
* `Новое` Метод images.matchTemplate добавляет параметр опции useTransparentMask для поддержки поиска прозрачного изображения (Ссылка на [Auto.js Pro](https://g.pro.autojs.org/))
* `Новое` Метод images.requestScreenCaptureAsync позволяет запрашивать разрешения на запись экрана асинхронно в режиме интерфейса (Ссылка на [Auto.js Pro](https://g.pro.autojs.org/))
* `Новое` Метод images.requestScreenCapture добавляет параметр опции isAsync для поддержки асинхронного захвата экрана (Ссылка на [Auto.js Pro](https://g.pro.autojs.org/))
* `Новое` images.on('screen_capture', callback) и другие методы прослушивания событий поддерживают прослушивание событий доступности захвата экрана (Ссылка на [Auto.js Pro](https://g.pro.autojs.org/))
* `Новое` Метод images.stopScreenCapture поддерживает активное освобождение ресурсов, связанных с приложениями захвата экрана (Ссылка на [Auto.js Pro](https://g.pro.autojs.org/))
* `Новое` Методы Images.psnr/mse/ssim/mssim/hist/ncc и images.getSimilarity для получения метрик сходства изображений
* `Новое` Метод images.isGrayscale для определения, является ли изображение в градациях серого
* `Новое` Метод images.invert для преобразования изображения в негатив
* `Новое` Методы s13n.point/time для нормализации объектов точки и времени (См. документацию проекта > [Нормализация](https://docs.autojs6.com/#/s13n))
* `Новое` Методы gravity, touchThrough, backgroundTint модуля console (См. документацию проекта > [Консоль](https://docs.autojs6.com/#/console))
* `Новое` Методы Mathx.randomInt/Mathx.randomFloat для возврата случайных целых чисел или чисел с плавающей точкой в указанном диапазоне
* `Новое` Методы app.launchDual/startDualActivity для управления двойным запуском приложений (Требуются права Shizuku или Root) (Экспериментально)
* `Новое` Метод app.kill для принудительного остановки приложения (Требуются права Shizuku или Root)
* `Новое` Метод floaty.getClip для получения содержимого буфера обмена через плавающее окно
* `Исправление` Утечка памяти в View Binding подклассов Fragment (например, [DrawerFragment](https://github.com/SuperMonster003/AutoJs6/blob/17616504ab0bba93b30ab7abc67108ee5253f39a/app/src/main/java/org/autojs/autojs/ui/main/drawer/DrawerFragment.kt#L369) / [ExplorerFragment](https://github.com/SuperMonster003/AutoJs6/blob/17616504ab0bba93b30ab7abc67108ee5253f39a/app/src/main/java/org/autojs/autojs/ui/main/scripts/ExplorerFragment.kt#L48))
* `Исправление` Утечка экземпляра в таких классах, как [ScreenCapture](https://github.com/SuperMonster003/AutoJs6/blob/17616504ab0bba93b30ab7abc67108ee5253f39a/app/src/main/java/org/autojs/autojs/core/image/capture/ScreenCapturer.java#L70) / [ThemeColorPreference](https://github.com/SuperMonster003/AutoJs6/blob/10960ddbee71f75ef80907ad5b6ab42f3e1bf31e/app/src/main/java/org/autojs/autojs/ui/settings/ThemeColorPreference.kt#L21)
* `Исправление` Проблема, вызывающая сбой приложения при запросе разрешений на запись экрана на Android 14+ (от [chenguangming](https://github.com/chenguangming)) _[`pr #242`](http://pr.autojs6.com/242)_
* `Исправление` Проблема, вызывающая сбой приложения при запуске службы на переднем плане на Android 14+
* `Исправление` Проблема с кнопкой запуска в редакторе кода, которая не загорается правильно на Android 14+
* `Исправление` Приложение может работать неправильно после упаковки из-за отсутствия необходимых файлов библиотеки _[`issue #202`](http://issues.autojs6.com/202)_ _[`issue #223`](http://issues.autojs6.com/223)_ _[`pr #264`](http://pr.autojs6.com/264)_
* `Исправление` Сбой приложения при редактировании проекта из-за отсутствия указанных ресурсов значков _[`issue #203`](http://issues.autojs6.com/203)_
* `Исправление` Невозможность правильно использовать параметры для получения ресурсов захвата экрана указанной ориентации при запросе разрешений на запись экрана
* `Исправление` Проблема с некоторыми устройствами, неспособностью правильно добавлять ярлыки для сценариев (Пробная поправка) _[`issue #221`](http://issues.autojs6.com/221)_
* `Исправление` Проблема кумулятивной задержки отправки запросов с методами, связанными с отправкой запросов в HTTP модуле _[`issue #192`](http://issues.autojs6.com/192)_
* `Исправление` Сервис Shizuku может работать неправильно перед тем, как AutoJs6 войдет в главную страницу активности (Пробная поправка) _[`issue #255`](http://issues.autojs6.com/255)_
* `Исправление` Метод random(min, max) может иметь выходящие за пределы результаты
* `Исправление` Проблема, при которой параметр типа результата методов pickup не может корректно пройти пустые массивы
* `Исправление` Проблема, при которой прямоугольник управления, полученный методом UiObject#bounds(), может быть случайно изменен, нарушая его неизменяемость
* `Исправление` Проблема с текстовыми/кнопочными/вводными элементами, где текст, содержащий узкие двойные кавычки, не может быть правильно проанализирован
* `Исправление` Проблема с элементами text/textswitcher, где функция автоссылки атрибута не работает
* `Исправление` Проблема, при которой различные скрипты по ошибке делят один и тот же объект ScriptRuntime
* `Исправление` Проблема, при которой глобальные переменные HEIGHT и WIDTH теряют создаваемые динамически свойства Getter
* `Исправление` Проблема с потенциально высоким временем запуска, вызванным загрузкой RootShell при запуске скрипта
* `Исправление` Проблема с настройкой цвета фона плавающего окна консоли, приводящая к потере стиля закругленного прямоугольника
* `Исправление` Автозапуск службы доступа может сталкиваться с аномальной проблемой службы (Пробная поправка)
* `Исправление` Проблема с триггером изменения ViewPager при проведении по контролю WebView влево или вправо на странице документа домашней страницы
* `Исправление` Проблема с файловым менеджером, который не может распознать расширения файлов, содержащих заглавные буквы
* `Исправление` Файловый менеджер может не распознавать проект автоматически при первом входе в каталог проекта
* `Исправление` Проблема с тем, что страница файлового менеджера не может автоматически обновляться после удаления папки
* `Исправление` Проблема с сортировкой файлов и папок в файловом менеджере, где символы с начальной буквой ASCII размещены в конце
* `Исправление` Исключение 'FAILED ASSERTION' в функции отладки редактора кода
* `Исправление` Проблема возможности неподдерживанием корректной отладки после закрытия редактора во время процесса отладки редактора кода
* `Исправление` Проблема с потенциальным пропуском символов при переходе в конец строки в редакторе кода
* `Исправление` Проблема с мерцанием экрана при запуске страницы активности журнала на главной странице активности
* `Исправление` Проблема с упакованным приложением, не способным корректно использовать модуль opencc
* `Улучшение` Индикация клика для контроля "ABI недоступно" на странице пакета
* `Улучшение` Поддержка использования Shizuku для управления переключателем отображения "Местоположение указателя"
* `Улучшение` Поддержка использования Shizuku для управления переключателями разрешения "Медиа проекции" и "Изменение безопасных настроек"
* `Улучшение` Automator.gestureAsync/gesturesAsync поддерживает параметры функции обратного вызова
* `Улучшение` Модуль tasks использует синхронный метод для операций с базой данных, чтобы избежать потенциальных несоответствий при доступе к данным
* `Улучшение` Сценарий выполнения поддерживает настройку режима разделения символами пайплайна (например, начиная с `"ui|auto";`)
* `Улучшение` Сценарий выполнения поддерживает одиночные и обратные кавычки и позволяет опускать точки с запятой (например, начиная с `'ui';` или `'ui'`)
* `Улучшение` Сценарий выполнения поддерживает быструю импорт встроенных модулей расширения, таких как axios, cheerio и dayjs (например, начиная с `"axios";`)
* `Улучшение` Сценарий выполнения поддерживает параметры x или jsox для быстрого включения встроенных расширений объектов JavaScript (например, начиная с `"x";`)
* `Улучшение` Атрибуты src и path элемента img поддерживают локальные относительные пути (например, `<img src="a.png" />`)
* `Улучшение` Редактор кода поддерживает интеллектуальное определение места вставки при импорте Java классов и пакетов имен
* `Улучшение` Модуль images поддерживает использование путей напрямую в качестве параметров изображений
* `Улучшение` importPackage поддерживает строковые параметры
* `Улучшение` IP-адрес в режиме сервера поддерживает импорт из буфера обмена с интеллектуальным определением и конверсией с пробелом
* `Улучшение` Файловый менеджер поддерживает выбор префиксов по умолчанию при создании новых файлов и автоматически генерирует подходящее числовое расширение
* `Улучшение` Файловый менеджер четко уведомляет об ошибке при выполнении проекта _[`issue #268`](http://issues.autojs6.com/268)_
* `Улучшение` Файловый менеджер поддерживает больше типов и отображает соответствующие значки (поддерживает более 800 типов файлов)
* `Улучшение` Редактируемые типы файлов (jpg/doc/pdf и т.д.) в файловом менеджере добавлены кнопки для редактирования
* `Улучшение` APK-файлы в файловом менеджере поддерживают просмотр базовой информации, информации о манифесте и списке разрешений
* `Улучшение` Мультимедийные аудио/видео файлы в файловом менеджере поддерживают просмотр базовой информации и MediaInfo
* `Улучшение` Упаковка файлов в одном пакете поддерживает автоматическое заполнение стандартизированного имени пакета и индикацию фильтра недопустимого символа
* `Улучшение` Упаковка файлов в одном пакете поддерживает автоматическую настройку значка и автоинкремент номера и имени версии на основе приложений с тем же установленным именем пакета
* `Улучшение` Настройка конфигурации пакета поддерживает опции abis/libs для указания включенной по умолчанию библиотеки и архитектуры ABI
* `Улучшение` Предоставляет предупреждения о релевантных сообщениях, когда настройки abis/libs конфигурационного файла пакета недействительны или недоступны
* `Улучшение` LeakCanary исключен из официального релиза для предотвращения ненужного увеличения
* `Улучшение` Все английские комментарии в исходном коде проекта сопровождаются переводами на упрощенный китайский для улучшения читаемости
* `Улучшение` README и CHANGELOG поддерживают несколько языков (автоматически генерируются скриптом)
* `Улучшение` Улучшить адаптируемость версии скрипта сборки Gradle
* `Зависимость` Включить версию 2.3.1 MIME Util
* `Зависимость` Включить версию 12.6 Toaster
* `Зависимость` Включить версию 10.3 EasyWindow (для Toaster)
* `Зависимость` Обновить Gradle с версии 8.5 до 8.11.1
* `Зависимость` Обновить Rhino с версии 1.7.15-snapshot до 1.7.16-snapshot
* `Зависимость` Обновить Android Material Lang3 с версии 1.10.0 до 1.12.0
* `Зависимость` Обновить Androidx Annotation с версии 1.7.0 до 1.9.1
* `Зависимость` Обновить Androidx AppCompat с версии 1.6.1 до 1.7.0
* `Зависимость` Обновить Androidx WebKit с версии 1.8.0 до 1.12.1
* `Зависимость` Обновить Apache Commons с версии 3.13.0 до 3.16.0
* `Зависимость` Обновить ARSCLib с версии 1.2.4 до 1.3.1
* `Зависимость` Обновить Gson с версии 2.10.1 до 2.11.0
* `Зависимость` Обновить Jackson DataBind с версии 2.13.3 до 2.13.4.2
* `Зависимость` Обновить Joda Time с версии 2.12.5 до 2.12.7
* `Зависимость` Обновить LeakCanary с версии 2.12 до 2.14
* `Зависимость` Обновить MLKit Barcode Scanning с версии 17.2.0 до 17.3.0
* `Зависимость` Обновить MLKit Text Recognition Chinese с версии 16.0.0 до 16.0.1
* `Зависимость` Обновить Retrofit2 Converter Gson с версии 2.9.0 до 2.11.0
* `Зависимость` Обновить Retrofit2 Retrofit с версии 2.9.0 до 2.11.0
* `Зависимость` Обновить Desugar JDK Libs с версии 2.0.3 до 2.0.4
* `Зависимость` Обновить Test Runner с версии 1.5.2 до 1.6.2
* `Зависимость` Обновить Junit Jupiter с версии 5.10.0 до 5.10.3
* `Зависимость` Понизить версию OkHttp3 с 5.0.0-alpha.11 до 4.12.0

# v6.5.0

###### 2023/12/02

* `Новое` Модуль opencc (см. Документацию проекта > [Конвертация китайских символов](https://docs.autojs6.com/#/opencc)) (см. [LZX284](https://github.com/SuperMonster003/AutoJs6/pull/187/files#diff-8cff73265af19c059547b76aca8882cbaa3209291406f52df1dafbbc78e80c46R268))
* `Новое` Добавлены методы [plus](https://docs.autojs6.com/#/uiObjectType?id=m-plus) и [append](https://docs.autojs6.com/#/uiObjectType?id=m-append) в UiSelector _[`issue #115`](http://issues.autojs6.com/115)_
* `Новое` Добавлена поддержка фильтрации ABI и библиотек на странице упаковки (см. [AutoX](https://github.com/kkevsekk1/AutoX)) _[`issue #189`](http://issues.autojs6.com/189)_
* `Исправление` Проблема с аномально большим размером упакованных приложений (см. [AutoX](https://github.com/kkevsekk1/AutoX) / [LZX284](https://github.com/SuperMonster003/AutoJs6/pull/187/files#diff-d932ac49867d4610f8eeb21b59306e8e923d016cbca192b254caebd829198856R61)) _[`issue #176`](http://issues.autojs6.com/176)_
* `Исправление` Проблема с невозможностью отображения и печати некоторых сообщений об ошибках в упакованных приложениях
* `Исправление` Проблема с отображением пустого значка после выбора значка приложения на странице упаковки
* `Исправление` Проблема с необработанным исключением при инициализации контекста при использовании библиотеки Google OCR MLKit
* `Исправление` Неисправность методов ocr.<u>mlkit/ocr</u>.<u>recognizeText/detect</u>
* `Исправление` Проблема с несоответствием языка отображения текста (например, на странице журнала) языковому параметру приложения
* `Исправление` Проблема с переполнением текста в некоторых языках в пункте меню основного экрана
* `Исправление` Проблема с автоматическим выключением сервиса специальных возможностей без сообщения на некоторых устройствах _[`issue #181`](http://issues.autojs6.com/181)_
* `Исправление` Проблема с аварийным завершением приложения при использовании физических кнопок устройств при включенной службе специальных возможностей на некоторых устройствах (попытка исправления) _[`issue #183`](http://issues.autojs6.com/183)_ _[`issue #186`](http://issues.autojs6.com/186#issuecomment-1817307790)_
* `Исправление` Проблема с некорректной работой функции pickup после перезапуска службы специальных возможностей с помощью auto(true) (попытка исправления) _[`issue #184`](http://issues.autojs6.com/184)_
* `Исправление` Проблема с аварийным завершением приложения при перетаскивании плавающего окна, созданного с помощью модуля floaty (попытка исправления)
* `Исправление` Проблема с невозможностью использования короткого имени параметра в app.startActivity _[`issue #182`](http://issues.autojs6.com/182)_ _[`issue #188`](http://issues.autojs6.com/188)_
* `Исправление` Проблема с исключением при конфликте импортируемых имен и глобальных переменных в importClass _[`issue #185`](http://issues.autojs6.com/185)_
* `Исправление` Проблема с невозможностью использования службы специальных возможностей в Android 7.x
* `Исправление` Проблема с возможной неспособностью использования методов runtime.<u>loadJar/loadDex</u> в Android 14 (попытка исправления)
* `Исправление` Проблема с недоступностью функций "Анализировать диапазон раскладки" и "Анализировать иерархию раскладки" в панели быстрых настроек Android _[`issue #193`](http://issues.autojs6.com/193)_
* `Исправление` Проблема с возможным появлением ANR (в приложении [ANR](https://developer.android.com/topic/performance/vitals/anr)) при автоматической проверке обновлений (попытка исправления) _[`issue #186`](http://issues.autojs6.com/186)_
* `Исправление` Проблема с невозможностью вернуться на рабочую страницу после нажатия кнопки "Вверх" в примерах кода файлового менеджера _[`issue #129`](http://issues.autojs6.com/129)_
* `Исправление` Проблема с отображением кнопки замены в редакторе кода при использовании функции замены
* `Исправление` Проблема с аварийным завершением приложения при долгом нажатии на удалении в редакторе кода (попытка исправления)
* `Исправление` Проблема с кнопкой fx, не отображающей панель быстрого доступа к функциям модуля в редакторе кода
* `Исправление` Проблема с переполнением названий функций кнопок на панели быстрого доступа к функциям модуля редактора кода
* `Улучшение` Панель быстрых функций модуля редактора кода адаптируется к ночному режиму.
* `Улучшение` Стартовая страница упакованного приложения адаптируется к ночному режиму, а размещение значков приложения корректируется.
* `Улучшение` Страница упакованного приложения поддерживает навигацию курсора с помощью клавиши ENTER на программной клавиатуре.
* `Улучшение` Страница упакованного приложения поддерживает переключение состояния выбора всего при нажатии на заголовки ABI и библиотеки.
* `Улучшение` Выбор ABI по умолчанию осуществляется интеллектуально на странице упакованного приложения с добавлением приглашений для неселектируемых элементов.
* `Улучшение` Файловый менеджер корректирует отображение элементов меню в зависимости от типа и характеристик файлов и папок.
* `Улучшение` Контекстное меню для папок в файловом менеджере добавляет опцию упаковки приложений.
* `Улучшение` Когда службы доступности включены, но работают некорректно, аномальное состояние отображается в переключателе ящика на главной странице AutoJs6.
* `Улучшение` Консоль включает подробную информацию о стеке при печати сообщений об ошибках.
* `Зависимость` Добавлено ARSCLib версии 1.2.4
* `Зависимость` Добавлено Flexbox версии 3.0.0
* `Зависимость` Добавлено Android OpenCC версии 1.2.0
* `Зависимость` Обновление версии Gradle с 8.5-rc-1 на 8.5

# v6.4.2

###### 2023/11/15

* `Новое` Параметр опции inputSingleLine для dialogs.build()
* `Новое` Метод console.setTouchable _[`issue #122`](http://issues.autojs6.com/122)_
* `Исправление` Проблема с распознаванием параметров области в некоторых методах ocr модуля _[`issue #162`](http://issues.autojs6.com/162)_ _[`issue #175`](http://issues.autojs6.com/175)_
* `Исправление` Проблема с получением деталей версии при обнаружении новой версии на Android 7.x
* `Исправление` Проблема краха приложения при запросе разрешения на скриншот на Android 14
* `Исправление` Проблема краха приложения при быстром переключении "плавающая кнопка" в главном меню
* `Исправление` Проблема отображения плавающей кнопки после перезапуска приложения при ее закрытии через меню
* `Исправление` Проблема, при которой выбор и переключение языка AutoJs6 на странице настроек на Android 13 и выше не вступает в силу
* `Исправление` Проблема невозможности автоматического завершения развертывания ресурсов OpenCV при первом создании билдов
* `Улучшение` Нативизация модуля bridges для повышения эффективности выполнения скриптов (Ref to [aiselp](https://github.com/aiselp/AutoX/commit/7c41af6d2b9b36d00440a9c8b7e971d025f98327))
* `Улучшение` Рефакторинг кода, связанного со службой доступности, для улучшения стабильности службы доступности (экспериментально) _[`issue #167`](http://issues.autojs6.com/167)_
* `Улучшение` Формат вывода данных для UiObject и UiObjectCollection
* `Улучшение` Подсказки обновлений для Gradle JDK версии в окружении создания
* `Зависимость` Обновление Gradle версии с 8.4 до 8.5-rc-1
* `Зависимость` Понижение версии Commons IO с 2.14.0 до 2.8.0
* `Зависимость` Понижение версии Jackson DataBind с 2.14.3 до 2.13.3

# v6.4.1

###### 2023/11/02

* `Исправление` Проблема несовместимости инструмента сборки с неизвестной платформой (by [TonyJiangWJ](https://github.com/TonyJiangWJ)) _[`pr #158`](http://pr.autojs6.com/158)_
* `Исправление` Проблема краха приложения при выходе из скрипта _[`issue #159`](http://issues.autojs6.com/159)_
* `Исправление` Неправильный тип возвращаемого значения body.contentType объекта ответа в http модуле _[`issue #142`](http://issues.autojs6.com/142)_
* `Исправление` Проблема неправильного возвращаемого значения device.width и device.height _[`issue #160`](http://issues.autojs6.com/160)_
* `Исправление` Проблема краха приложения при долгом нажатии для удаления кода в редакторе кода (попытка исправления) _[`issue #156`](http://issues.autojs6.com/156)_
* `Исправление` Проблема краха приложения при совершении обычных операций вслед за обратным выделением текста в редакторе кода
* `Исправление` Проблема, при которой на некоторых устройствах долгий клик на иконке приложения AutoJs6 не показывает контекстное меню
* `Исправление` Проблема, при которой кнопка подтверждения не работает при упаковке проекта на некоторых устройствах
* `Исправление` Проблема, при которой app.sendBroadcast и app.startActivity невозможно использовать с короткими параметрами
* `Исправление` Аномалии при первом вызове методов JsWindow#setPosition и других в модуле Floaty
* `Улучшение` Добавлены разрешения для Termux для поддержки вызова Intent выполнения команд ADB _[`issue #136`](http://issues.autojs6.com/136)_
* `Улучшение` Объект ответа http может повторно использовать методы body.string() и body.bytes()
* `Улучшение` Добавлена поддержка автоматической упаковки через GitHub Actions (by [TonyJiangWJ](https://github.com/TonyJiangWJ)) _[`pr #158`](http://pr.autojs6.com/158)_
* `Улучшение` Инструмент сборки адаптирован к платформе Temurin
* `Зависимость` Обновление Gradle версии с 8.4-rc-3 до 8.4
* `Зависимость` Обновление Android dx версии с 1.11 до 1.14

# v6.4.0

###### 2023/10/30

* `Новое` Поддержка движка Paddle Lite в ocr модуле (by [TonyJiangWJ](https://github.com/TonyJiangWJ)) _[`pr #120`](http://pr.autojs6.com/120)_
* `Новое` Функция упаковки поддерживает как встроенные, так и внешние плагины (by [LZX284](https://github.com/LZX284)) _[`pr #151`](http://pr.autojs6.com/151)_
* `Новое` Модуль WebSocket (см. документацию по проекту > [WebSocket](https://docs.autojs6.com/#/webSocketType))
* `Новое` Модули barcode / qrcode (см. документацию по проекту > [Штрих-код](https://docs.autojs6.com/#/barcode) / [QR-код](https://docs.autojs6.com/#/qrcode))
* `Новое` Модуль shizuku (см. документацию по проекту > [Shizuku](https://docs.autojs6.com/#/shizuku)) и переключатель разрешений в главном меню
* `Новое` Методы device.rotation / device.orientation
* `Новое` Поддержка доступа к статическим свойствам классов внутренних Java классов
* `Новое` Поддержка выбора и переключения языка приложения на странице настроек Android (Android 13 и выше)
* `Новое` Добавление или долгое нажатие на иконке приложения для активации [ярлыка приложения](https://developer.android.com/guide/topics/ui/shortcuts?hl=zh-cn), который может запускать страницы документации и настройки
* `Исправление` Повторное объединение некоторых PR (by [aiselp](https://github.com/aiselp)) для решения проблемы, при которой некоторые скрипты не могли корректно завершаться _[`pr #75`](http://pr.autojs6.com/75)_ _[`pr #78`](http://pr.autojs6.com/78)_
* `Исправление` Проблема с использованием новых API AutoJs6 в упакованных приложениях (by [LZX284](https://github.com/LZX284)) _[`pr #151`](http://pr.autojs6.com/151)_ _[`issue #149`](http://issues.autojs6.com/149)_
* `Исправление` Аномалии стиля упакованных приложений в ночном режиме системы
* `Исправление` Проблема с потерей информации о расширении файла при сохранении с помощью плагина VSCode
* `Исправление` Проблема краха приложения при возникновении необработанных исключений во время выполнения проекта с использованием корутин
* `Исправление` Проблема, при которой после перезапуска или выхода из приложения плавающая кнопка не сохраняет свое положение
* `Исправление` Проблема, при которой невозможно получить обновленную информацию о конфигурации устройства при изменении ориентации экрана _[`issue #153`](http://issues.autojs6.com/153)_
* `Исправление` Проблема с слишком маленьким шрифтом заголовка на панеле инструментов при повороте экрана в ландшафтный режим
* `Исправление` Проблема с перегруженным макетом главной страницы приложения при повороте экрана в ландшафтный режим
* `Исправление` Проблема с вылетом плавающей кнопки за экран при повороте в ландшафтный режим _[`issue #90`](http://issues.autojs6.com/90)_
* `Исправление` Проблема с восстановлением координат и ориентации плавающей кнопки при многократном повороте экрана
* `Исправление` Проблема с пропуском или повторным отображением всплывающих сообщений на некоторых устройствах
* `Исправление` Проблема скрытого отображения всплывающих сообщений при одновременном запуске нескольких скриптов _[`issue #67`](http://issues.autojs6.com/67)_
* `Исправление` Проблема краха приложения при открытии меню после нажатия на макет в анализе трансляции
* `Исправление` Проблема с некорректной работой слушателей для WebSocket экземпляров, созданных после первого
* `Исправление` Отмена метода глобальной перенаправления importPackage для предотвращения ошибок импорта пакетов в некоторых областях видимости _[`issue #88`](http://issues.autojs6.com/88)_
* `Исправление` Проблема краха приложения при использовании функций копирования или экспорта на странице активности журнала
* `Улучшение` Переименование функции экспорта в функцию отправки на странице активности журнала и его переработка в соответствии с реальным значением
* `Улучшение` Функция отправки на странице активности журнала автоматически обрезает большое количество элементов и уведомляет об этом
* `Улучшение` Модуль ocr поддерживает как Google MLKit, так и движок Paddle Lite (см. документацию по проекту > [Оптическое распознавание символов](https://docs.autojs6.com/#/ocr?id=p-mode))
* `Улучшение` Повышение вероятности автоматического запуска службы доступности
* `Улучшение` Миграция обработки аннотаций Kotlin с kapt на KSP
* `Улучшение` Инструмент сборки поддерживает EAP версии IntelliJ Idea
* `Улучшение` Инструмент сборки адаптируется под версии Java, чтобы по возможности избежать проблемы "недействительной версии"
* `Улучшение` Оптимизация логики понижения версии IDE и связанных плагинов в инструменте сборки и добавление функции предсказания версий
* `Улучшение` Адаптация версии 1.0.7 плагина VSCode
* `Зависимость` Добавлена версия Rikka Shizuku 13.1.5
* `Зависимость` Добавлена версия MLKit Barcode Scanning 17.2.0
* `Зависимость` Обновление версии OpenCV с 4.5.5 до 4.8.0 (Ref to [TonyJiangWJ](https://github.com/TonyJiangWJ))
* `Зависимость` Обновление версии Gradle Compile с 33 до 34
* `Зависимость` Обновление версии Gradle с 8.3-rc-1 до 8.4-rc-3
* `Зависимость` Обновление версии Apache Commons Lang3 с 3.12.0 до 3.13.0
* `Зависимость` Обновление версии Glide с 4.15.1 до 4.16.0
* `Зависимость` Обновление версии Android Analytics с 14.3.0 до 14.4.0
* `Зависимость` Обновление версии Androidx WebKit с 1.7.0 до 1.8.0
* `Зависимость` Обновление версии Androidx Preference с 1.2.0 до 1.2.1
* `Зависимость` Обновление версии Androidx Annotation с 1.6.0 до 1.7.0
* `Зависимость` Обновление версии Androidx Recyclerview с 1.3.0 до 1.3.2
* `Зависимость` Обновление версии Android Material с 1.9.0 до 1.10.0
* `Зависимость` Обновление версии Androidx AppCompat с 1.4.2 до 1.6.1
* `Зависимость` Обновление версии Commons IO с 2.8.0 до 2.14.0
* `Зависимость` Обновление версии Jackson DataBind с 2.13.3 до 2.14.3
* `Зависимость` Удаление версии Zeugma Solutions LocaleHelper 1.5.1

# v6.3.3

###### 2023/07/21

* `Новое` Функция комментирования кода в редакторе кода (by [little-alei](https://github.com/little-alei)) _[`pr #98`](http://pr.autojs6.com/98)_
* `Новое` auto.stateListener для прослушивания состояния подключения службы доступности (by [little-alei](https://github.com/little-alei)) _[`pr #98`](http://pr.autojs6.com/98)_
* `Новое` Добавлены методы nextSibling / lastChild / offset для типа UiObject (см. документацию по проекту > [Узлы UI](https://docs.autojs6.com/#/uiObjectType))
* `Исправление` Проблема невозможности обработки данных плагином VSCode при общей длине символов скрипта более четырехзначного числа в десятичной системе _[`issue #91`](http://issues.autojs6.com/91)_ _[`issue #93`](http://issues.autojs6.com/93)_ _[`issue #100`](http://issues.autojs6.com/100)_ _[`issue #109`](http://issues.autojs6.com/109)_
* `Исправление` Проблема невозможности корректного сохранения файлов плагином VSCode _[`issue #92`](http://issues.autojs6.com/91)_ _[`issue #94`](http://issues.autojs6.com/93)_
* `Исправление` Проблема, при которой элемент меню "управление службой доступности" в плавающем меню не всегда приводит к переходу на соответствующую страницу
* `Исправление` Проблема с отсутствием метода runtime.requestPermissions _[`issue #104`](http://issues.autojs6.com/104)_
* `Исправление` Проблема несовместимости параметра MainThreadProxy в events.emitter _[`issue #103`](http://issues.autojs6.com/103)_
* `Исправление` Проблема невозможности форматирования кода в редакторе кода в _[`pr #78`](http://pr.autojs6.com/78)_
* `Исправление` Проблема переполнения стека вызовов ClassLoader при использовании JavaAdapter _[`issue #99`](http://issues.autojs6.com/99)_ _[`issue #110`](http://issues.autojs6.com/110)_
* `Улучшение` Адаптация области видимости модулей (by [aiselp](https://github.com/aiselp)) _[`pr #75`](http://pr.autojs6.com/75)_ _[`pr #78`](http://pr.autojs6.com/78)_
* `Улучшение` Удаление проверки подписи при запуске для выпусков (by [LZX284](https://github.com/LZX284)) _[`pr #81`](http://pr.autojs6.com/81)_
* `Улучшение` Улучшения функции комментирования кода в редакторе, стиля и обработки курсора на основе _[`pr #98`](http://pr.autojs6.com/98)_
* `Улучшение` Добавление элемента меню для комментирования кода на основе _[`pr #98`](http://pr.autojs6.com/98)_
* `Улучшение` Адаптация плагина VSCode версии 1.0.6
* `Улучшение` Добавление поддержки количества уровней в методе UiObject#parent (см. документацию по проекту > [Узлы UI](https://docs.autojs6.com/#/uiObjectType))
* `Зависимость` Обновление версии Gradle с 8.2 до 8.3-rc-1

# v6.3.2

###### 2023/07/06

* `Новое` модуль crypto (см. Документация проекта > [Шифрование](https://docs.autojs6.com/#/crypto)) _[`issue #70`](http://issues.autojs6.com/70)_
* `Новое` В UI-режиме добавлены элементы управления: textswitcher / viewswitcher / viewflipper / numberpicker / video / search и другие
* `Новое` На странице активности журнала добавлены функции копирования и экспорта журнала _[`issue #76`](http://issues.autojs6.com/76)_
* `Новое` В клиентском режиме добавлена функция истории IP-адресов
* `Исправление` Проблема, при которой после автоматического подключения в клиентском режиме или автоматического запуска в серверном режиме IP-адрес не отображается
* `Исправление` Проблема, при которой при переключении языка или ночного режима после подключения в клиентском и серверном режиме соединение разрывается и не может быть восстановлено
* `Исправление` Проблема, при которой в клиентском режиме при вводе целевого адреса невозможно использовать пользовательский порт
* `Исправление` Проблема, при которой в клиентском режиме ввод некоторых символов в целевой адрес приводит к сбою AutoJs6
* `Исправление` Проблема, при которой удаленные команды, выполняемые через плагин VSCode, могут не обрабатываться должным образом (попытка исправления)
* `Исправление` Проблема с получением информации о новой версии на Android 7.x
* `Исправление` Проблема с получением цветовых значений пикселей скриншотов с помощью функции images.pixel _[`issue #73`](http://issues.autojs6.com/73)_
* `Исправление` Проблема с использованием предустановленных атрибутов для родных элементов управления Android в UI-режиме (с заглавной буквы)
* `Исправление` Проблема, из-за которой при загрузке нескольких файлов с помощью функций runtime.loadDex/loadJar действует только первый файл _[`issue #88`](http://issues.autojs6.com/88)_
* `Исправление` Проблема, при которой на некоторых устройствах после установки приложение показывает только иконку документа (попытка исправления) _[`issue #85`](http://issues.autojs6.com/85)_
* `Улучшение` Поддержка плагина VSCode версии 1.0.5
* `Улучшение` Поддержка модуля cheerio (Ссылат на [aiselp](https://github.com/aiselp/AutoX/commit/7176f5ad52d6904383024fb700bf19af75e22903)) _[`issue #65`](http://issues.autojs6.com/65)_
* `Улучшение` Экземпляр JsWebSocket поддерживает метод rebuild для повторного создания экземпляра и подключения _[`issue #69`](http://issues.autojs6.com/69)_
* `Улучшение` Модуль base64 поддерживает кодирование и декодирование массивов чисел и массивов байтов Java в качестве основных параметров
* `Улучшение` Добавлена поддержка JavaMail для Android _[`issue #71`](http://issues.autojs6.com/71)_
* `Улучшение` Использование типа данных Blob для получения информации об обновлениях версии для улучшения работы в сетях без прокси
* `Улучшение` В клиентском режиме отображение целевого IP-адреса в подзаголовке главного экрана во время процесса подключения
* `Улучшение` В клиентском режиме добавлена поддержка предупреждений для некорректного ввода адреса
* `Улучшение` В клиентском режиме поддержка подключения с помощью клавиши ввода на программной клавиатуре
* `Улучшение` В серверном режиме поддерживается состояние всегда включено (кроме случаев ручного отключения или завершения процесса приложения) _[`issue #64`](http://issues.autojs6.com/64#issuecomment-1596990158)_
* `Улучшение` Реализация двустороннего обнаружения версий между AutoJs6 и плагином VSCode с оповещением о несоответствиях _[`issue #89`](http://issues.autojs6.com/89)_
* `Улучшение` Добавлены разрешения на чтение данных SMS (android.permission.READ_SMS) (по умолчанию отключены)
* `Улучшение` Внутренняя реализация метода findMultiColors (от [LYS86](https://github.com/LYS86)) _[`pr #72`](http://pr.autojs6.com/72)_
* `Улучшение` Поддержка загрузки нескольких файлов или каталогов с помощью функций runtime.loadDex/loadJar/load
* `Зависимость` Обновлена версия LeakCanary 2.11 -> 2.12
* `Зависимость` Обновлена версия Android Analytics 14.2.0 -> 14.3.0
* `Зависимость` Обновлена версия Gradle 8.2-milestone-1 -> 8.2

# v6.3.1

###### 2023/05/26

* `Новое` Уведомления о выпуске и переключатель домашнего ящика _[`issue #55`](http://issues.autojs6.com/55)_
* `Новое` UI-режим поддерживает простой разбор макетов Android (см. Примеры кода > Макеты > Простой макет Android)
* `Новое` В UI-режиме добавлены элементы управления: console / imagebutton / ratingbar / switch / textclock / togglebutton и другие
* `Новое` Элементы управления UI-режима поддерживают цветовые значения типа [OmniColor](https://docs.autojs6.com/#/omniTypes?id=omnicolor) (например, color="orange")
* `Новое` Метод attr полностью поддерживает установку атрибутов для всех элементов управления в UI-режиме (например, ui.text.attr('color', 'blue'))
* `Новое` Элементы управления UI-режима поддерживают сокращенные формы значений логического типа (например, clickable="true" можно записать как просто clickable или isClickable)
* `Новое` Элемент управления button поддерживает логические атрибуты isColored и isBorderless
* `Новое` Метод console.resetGlobalLogConfig для сброса глобальной конфигурации журнала
* `Новое` Метод web.newWebSocket для создания экземпляра Web Socket (см. Документация проекта > [Интернет](https://docs.autojs6.com/#/web?id=m-newwebsocket))
* `Исправление` Аномальная сортировка папок в файловом менеджере
* `Исправление` Проблема невозможности регулировки стиля и положения плавающего окна, построенного с помощью модуля floaty _[`issue #60`](http://issues.autojs6.com/60)_
* `Исправление` Проблема наложения плавающего окна, созданного с помощью модуля floaty, на системную панель состояния
* `Исправление` Проблема с работой метода http.postMultipart _[`issue #56`](http://issues.autojs6.com/56)_
* `Исправление` Проблема невозможности запуска любого скрипта на Android 7.x _[`issue #61`](http://issues.autojs6.com/61)_
* `Исправление` Проблема невозможности сборки проекта при отсутствии файла sign.property
* `Исправление` Проблема сбоя приложения AutoJs6 при отсутствии разрешения на уведомления на устройствах с API >= 33
* `Исправление` Проблема невозможности очистки журнала нажатием кнопки FAB в окне журнала после вызова метода console.show
* `Исправление` Проблема с прототипами null pointer exceptions при отладке в редакторе скриптов
* `Исправление` Проблема выполнения временных скриптов из папки кеша вместо исходного файла скрипта, что могло приводить к потере кода при запуске в редакторе скриптов
* `Исправление` Проблема с отображением имен элементов управления в анализаторе макетов при наличии большого количества уровней вложенности _[`issue #46`](http://issues.autojs6.com/46)_
* `Улучшение` Добавлена кнопка выхода для закрытия окна анализатора макетов _[`issue #63`](http://issues.autojs6.com/63)_
* `Улучшение` Использование сокращенных форм абсолютных путей к файлам для экономии места и повышения читаемости
* `Улучшение` Замена Error на Exception для предотвращения сбоя приложения AutoJs6 при возникновении исключений
* `Улучшение` Перенос метода View Binding с ButterKnife для связи представлений (View) _[`issue #48`](http://issues.autojs6.com/48)_
* `Улучшение` Автоматическое повторное включение серверного режима при аварийном завершении после запуска AutoJs6 _[`issue #64`](http://issues.autojs6.com/64)_
* `Улучшение` Автоматическое повторное подключение в клиентском режиме к последнему использованному адресу после запуска AutoJs6 при аварийном завершении
* `Зависимость` Обновлена версия LeakCanary 2.10 -> 2.11
* `Зависимость` Обновлена версия Android Material 1.8.0 -> 1.9.0
* `Зависимость` Обновлена версия Androidx WebKit 1.6.1 -> 1.7.0
* `Зависимость` Обновлены версии OkHttp3 3.10.0 -> 5.0.0-alpha.9 -> 5.0.0-alpha.11
* `Зависимость` Обновлена версия MLKit Text Recognition Chinese 16.0.0-beta6 -> 16.0.0

# v6.3.0

###### 2023/04/29

* `Новое` модуль ocr (см. Документация проекта > [Оптическое распознавание символов](https://docs.autojs6.com/#/ocr)) _[`issue #8`](http://issues.autojs6.com/8)_
* `Новое` модуль notice (см. Документация проекта > [Уведомления](https://docs.autojs6.com/#/notice))
* `Новое` модуль s13n (см. Документация проекта > [Стандартизация](https://docs.autojs6.com/#/s13n))
* `Новое` модуль Color (см. Документация проекта > [Цвет](https://docs.autojs6.com/#/colorType))
* `Новое` Функция удержания экрана включенным при активном приложении и настройки для неё
* `Новое` Дополнительный лаунчер для документации (launcher) для независимого чтения документации (с возможностью скрытия или отображения в настройках)
* `Исправление` Неисправность метода colors.toString
* `Исправление` Неисправность автоматического добавления префикса протокола методом app.openUrl
* `Исправление` Некорректное поведение методов app.viewFile/editFile при передаче несуществующего файла
* `Исправление` Проблема с вызовом callback-функции метода pickup
* `Исправление` Проблема замены знака минуса на запятую в значении атрибута bounds в элементах управления анализатора макетов
* `Исправление` Неисправность фильтрации narrow empty rectangle для селекторов bounds/boundsInside/boundsContains _[`issue #49`](http://issues.autojs6.com/49)_
* `Исправление` Проблема сбоя приложения после смены темы или языка при нажатии или долгом нажатии на вкладку документации домашней страницы
* `Исправление` Проблема трясущихся символов при изменении размеров с помощью двух пальцев в текстовом редакторе
* `Исправление` Проблема с загрузкой зависимостей в сборочном скрипте (все они теперь объединены) _[`issue #40`](http://issues.autojs6.com/40)_
* `Исправление` Проблема с добавлением действия AutoJs6 в Tasker (попытка исправления) _[`issue #41`](http://issues.autojs6.com/41)_
* `Исправление` Проблема с аннотациями ButterKnife при сборке проекта с высокой версией JDK _[`issue #48`](http://issues.autojs6.com/48)_
* `Исправление` Проблема с частыми сбоями службы доступности (попытка исправления)
* `Исправление` Проблема документации метода параметра size для images.medianBlur
* `Исправление` Проблема отброшенных символов между именем файла и расширением при выводе полного имени в модуле engines
* `Исправление` Проблемы вычислений в алгоритме взвешенного RGB (попытка исправления)
* `Исправление` Проблема использования методов плавующего окна console модуля перед show
* `Исправление` Проблема бездействия методов console.setSize и остальных _[`issue #50`](http://issues.autojs6.com/50)_
* `Исправление` Проблема цветовых констант в цветовом пространстве colors.material
* `Исправление` Некорректное разборка формата даты для атрибутов minDate и maxDate в элементе выбора даты в UI-режиме
* `Исправление` Проблема появления двух одинаковых активных задач при быстром переключении на вкладку "Задачи" после запуска скрипта
* `Исправление` Проблема сброса состояния страницы файлового менеджера при возврате обратно с другой страницы _[`issue #52`](http://issues.autojs6.com/52)_
* `Исправление` Проблема несоответствия состояния сортировки и отображения значков в файловом менеджере
* `Улучшение` На странице управления файлами добавлено отображение времени изменения файлов и папок.
* `Улучшение` На странице управления файлами поддерживается запоминание типа сортировки.
* `Улучшение` В README.md добавлены разделы по компиляции проекта и помощник по разработке скриптов _[`issue #33`](http://issues.autojs6.com/33)_
* `Улучшение` Параметр опции области (region) в методах модуля images поддерживает больше способов передачи (см. документацию проекта > [Универсальные типы](https://docs.autojs6.com/#/omniTypes?id=omniregion))
* `Улучшение` На странице app.startActivity добавлена поддержка сокращённых параметров таких как pref/homepage/docs/about.
* `Улучшение` Глобальные методы модуля web зарегистрированы в самом модуле для повышения удобства (см. документацию проекта > [Всемирная паутина](https://docs.autojs6.com/#/web))
* `Улучшение` Метод web.newInjectableWebView реализует по умолчанию часть часто используемых опций настроек WebView.
* `Улучшение` Модуль colors добавляет различные методы конверсии и инструментальные методы, также добавлено больше статических констант и цветовых названий, которые можно использовать непосредственно в качестве параметров.
* `Улучшение` Модуль консоли добавляет методы настройки стиля для плавающих окон консоли и поддерживает унифицированную конфигурацию стиля окон через конструктор build.
* `Улучшение` Плавающие окна консоли поддерживают перемещение позиций окна путем перетаскивания области заголовка.
* `Улучшение` Плавающие окна консоли поддерживают автоматическое задержанное закрытие после завершения скрипта.
* `Улучшение` Плавающие окна консоли и окна активности поддерживают масштабирование шрифта двумя пальцами.
* `Улучшение` Методы, связанные с модулем http, поддерживают параметр тайм-аута (timeout).
* `Улучшение` Скрипт сборки Gradle поддерживает инициативное понижение версии JDK (fallback).
* `Улучшение` Скрипт сборки Gradle поддерживает автоматический выбор подходящей версии инструментов сборки в зависимости от типа и версии платформы (в ограниченной степени).
* `Зависимость` Локализована версия Auto.js APK Builder 1.0.3
* `Зависимость` Локализована версия MultiLevelListView 1.1
* `Зависимость` Локализована версия Settings Compat 1.1.5
* `Зависимость` Локализована версия Enhanced Floaty 0.31
* `Зависимость` Добавлена версия MLKit Text Recognition Chinese 16.0.0-beta6
* `Зависимость` Обновлена версия Gradle 8.0-rc-1 -> 8.2-milestone-1
* `Зависимость` Обновлена версия Android Material 1.7.0 -> 1.8.0
* `Зависимость` Обновлена версия Glide 4.14.2 -> 4.15.1
* `Зависимость` Обновлена версия Joda Time 2.12.2 -> 2.12.5
* `Зависимость` Обновлена версия Android Analytics 14.0.0 -> 14.2.0
* `Зависимость` Обновлена версия Androidx WebKit 1.5.0 -> 1.6.1
* `Зависимость` Обновлена версия Androidx Recyclerview 1.2.1 -> 1.3.0
* `Зависимость` Обновлена версия Zip4j 2.11.2 -> 2.11.5
* `Зависимость` Обновлена версия Junit Jupiter 5.9.2 -> 5.9.3
* `Зависимость` Обновлена версия Androidx Annotation 1.5.0 -> 1.6.0
* `Зависимость` Обновлена версия Jackson DataBind 2.14.1 -> 2.14.2
* `Зависимость` Обновлена версия Desugar JDK Libs 2.0.0 -> 2.0.3

# v6.2.0

###### 2023/01/21

* `Новое` Переразработка и переписывание проектной документации (частично завершена)
* `Новое` Адаптация для множественных языков, включая: западный, французский, русский, арабский, японский, корейский, английский, традиционный китайский и другие
* `Новое` Добавлены функции выбора пути, истории и умные подсказки по умолчанию при настройке рабочего пути
* `Новое` Файловый менеджер поддерживает переход к предыдущему каталогу из любого каталога (до каталога "внутренняя память")
* `Новое` Файловый менеджер поддерживает установку любого каталога в качестве рабочего пути
* `Новое` Игнорирование и управление игнорированными обновлениями версии
* `Новое` Поддержка масштабирования размера шрифта в текстовом редакторе
* `Новое` IdHex селектор (UiSelector#idHex) (см. проектную документацию > [селекторы](https://docs.autojs6.com/#/uiSelectorType))
* `Новое` Action селектор (UiSelector#action) (см. проектную документацию > [селекторы](https://docs.autojs6.com/#/uiSelectorType))
* `Новое` Серия селекторов Match (UiSelector#xxxMatch) (см. проектную документацию > [селекторы](https://docs.autojs6.com/#/uiSelectorType))
* `Новое` Селектор захвата (UiSelector#pickup) (см. проектную документацию > [селекторы](https://docs.autojs6.com/#/uiSelectorType)) _[`вопрос #22`](http://issues.autojs6.com/22)_
* `Новое` Детектор элементов управления (UiObject#detect) (см. проектную документацию > [узлы управления](https://docs.autojs6.com/#/uiObjectType))
* `Новое` Компас элементов управления (UiObject#compass) (см. проектную документацию > [узлы управления](https://docs.autojs6.com/#/uiObjectType)) _[`вопрос #23`](http://issues.autojs6.com/23)_
* `Новое` Глобальный метод ожидания wait (см. проектную документацию > [глобальные объекты](https://docs.autojs6.com/#/global?id=m-wait))
* `Новое` Глобальные методы масштабирования cX/cY/cYx (см. проектную документацию > [глобальные объекты](https://docs.autojs6.com/#/global?id=m-wait))
* `Новое` Глобальный тип App (см. проектную документацию > [перечисления приложений](https://docs.autojs6.com/#/appType))
* `Новое` Модуль i18n (многоязыковое решение на основе banana-i18n для JavaScript) (см. проектную документацию > интернационализация)
* `Исправление` Проблемы с отображением текста страниц и функцией кнопок после смены языка приложения
* `Исправление` Не отображается панель инструментов проекта после запуска приложения, если рабочий путь является проектом
* `Исправление` Проблема автоматического изменения рабочего пути после смены языка приложения _[`вопрос #19`](http://issues.autojs6.com/19)_
* `Исправление` Значительная задержка запуска таймеров (пробное исправление) _[`вопрос #21`](http://issues.autojs6.com/21)_
* `Исправление` Проблема с правильной работой внутренних модулей, имеющих зависимости, при перекрытии имени модуля JavaScript _[`вопрос #29`](http://issues.autojs6.com/29)_
* `Исправление` Проблема, когда панель быстрых настроек не закрывается автоматически при клике на иконку в системах Android последних версий (пробное исправление) _[`вопрос #7`](http://issues.autojs6.com/7)_
* `Исправление` Перекрытие страницы и области уведомлений в системах Android последних версий
* `Исправление` Проблема с запуском примеров кода по установке цвета кисти на системах Android 10 и новее
* `Исправление` Исправление имени файла примера кода "Музыкальный менеджер" на "Файловый менеджер" и восстановление нормальной работы
* `Исправление` Проблема с появлением дрейфа местоположения при обновлении файлового менеджера
* `Исправление` Проблема с доступом к свойствам компонентов в скриптах на основе UI из-за неправильной привязки области видимости модуля ui
* `Исправление` Проблема утраты записанного содержимого при клике вне диалогового окна ввода имени файла после записи скрипта
* `Исправление` Проблемы с автоматическим переносом заголовков разделов документации при превышении ширины экрана, что приводило к утрате содержимого
* `Исправление` Проблемы с горизонтальным скроллингом в области примеров кода в документации
* `Исправление` Неправильное поведение и невозможность отмены операции при обновлении страницы документации (пробное исправление)
* `Исправление` Проблема неработающего переключения ночного режима главного экрана после первоначальной установки приложения
* `Исправление` Проблема принудительного включения ночного режима при запуске приложения, если включен системный ночной режим
* `Исправление` Проблема неактивности установленного цвета темы при включенном ночном режиме
* `Исправление` Проблема неразличимых текстов и фона некоторых параметров при включенном ночном режиме
* `Исправление` Проблема отображения текста функциональных кнопок на странице "О программе" из-за слишком длинных строк
* `Исправление` Проблема наложения текста и кнопок на главной странице из-за слишком длинных заголовков настроек
* `Исправление` Проблема несинхронизации состояния переключателей разрешений на главной странице после закрытия подсказок
* `Исправление` Проблема отсутствия предложений по инструментам ADB при сбое изменений переключателей разрешений главной страницы с root-правами
* `Исправление` Проблема уведомления о нехватке прав при первом использовании отображения позиции указателя с root-правами
* `Исправление` Проблема с компоновкой элементов на странице выбора значков
* `Исправление` Проблема моргания экрана при запуске текстового редактора в ночном режиме (пробное исправление)
* `Исправление` Проблема с ограничением максимального значения размера шрифта в текстовом редакторе
* `Исправление` Проблемы с учетом времени выполнения в логах при завершении скриптов на некоторых системах Android
* `Исправление` Проблема с отображением плавающей кнопки после перезапуска приложения, если меню плавающих кнопок было закрыто
* `Исправление` Проблема с переполнением иконок, всплывающего меню при длительном нажатии на элемент списка при анализе иерархии макета
* `Исправление` Проблема с трудночитаемыми кнопками панели навигации при отключенном ночном режиме на системах Android 7.x
* `Исправление` Проблема закрытия запросов в методах http.post и других
* `Исправление` Проблема отсутствия альфа-канала в результате при вызове метода colors.toString с альфа-каналом равным 0
* `Улучшение` Перенаправление публичных классов версии Auto.js 4.x для обеспечения обратной совместимости (в ограниченной степени)
* `Улучшение` Объединение всех модулей проекта для предотвращения возможных проблем циклических ссылок (временно удален модуль inrt)
* `Улучшение` Миграция конфигурации сборки Gradle с Groovy на KTS
* `Улучшение` Добавлена многоязыковая поддержка сообщений о исключениях Rhino
* `Улучшение` Отображение всплывающих сообщений только при включении переключателей разрешений на главной странице
* `Улучшение` Упрощение компоновки главной страницы за счет размещения под статусной строкой для улучшенной совместимости с верхней полосой цветов
* `Улучшение` Совместимость функций проверки обновлений, загрузки обновлений и уведомлений об обновлениях с системами Android 7.x
* `Улучшение` Переработка страницы настроек (миграция на AndroidX)
* `Улучшение` Поддержка длительного нажатия на параметры настроек для получения подробной информации
* `Улучшение` Добавлен параметр "следовать за системой" для ночного режима (Android 9 и выше)
* `Улучшение` Адаптация экрана запуска приложения для ночного режима
* `Улучшение` Добавлены цифровые идентификаторы на иконки приложения для улучшения использования многими версиями open-source
* `Улучшение` Добавлены дополнительные варианты цветов Material Design для цветовой темы
* `Улучшение` Облегчение значков элементов списков файлового менеджера и панели задач для соответствия теме
* `Улучшение` Адаптация цвета текста в поисковой строке главной страницы для ночного режима
* `Улучшение` Адаптация диалогов, текста, кнопок Fabs, панелей приложений и других компонентов для ночного режима
* `Улучшение` Адаптация страниц документации, настроек, страницы "О программе", цветовой темы, анализа макета и меню плавающих кнопок для ночного режима
* `Улучшение` Максимально возможная совместимость макета страниц с RTL (справа налево)
* `Улучшение` Добавление анимации иконок на странице "О программе"
* `Улучшение` Автоматическое обновление текста авторского права на странице "О программе"
* `Улучшение` Автоматическое решение и установка подходящего рабочего каталога после начальной установки приложения
* `Улучшение` Отключение функции масштабирования двумя пальцами на страницах документации для предотвращения неправильного отображения содержимого
* `Улучшение` Упрощенное отображение названия задач и пути в относительно пути на панели задач
* `Улучшение` Сокращение текста кнопок в текстовом редакторе для предотвращения переполнения текста
* `Улучшение` Добавлена поддержка восстановления значения размера шрифта по умолчанию в текстовом редакторе
* `Улучшение` Обеспечение увеличенной скорости отклика плавающих кнопок
* `Улучшение` Запуск анализа области макета при прямом нажатии на кнопку анализа макета в плавающих кнопках
* `Улучшение` Адаптация темы анализа макета (плавающие окна соответствуют теме приложения, быстрого доступа панели соответствуют теме системы)
* `Улучшение` Пересортировка списка информации об элементах макета по предполагаемой частоте использования
* `Улучшение` Автоматическая оптимизация формата вывода при копировании информации об элементах макета в зависимости от типа селектора
* `Улучшение` Поддержка возврата к предыдущему каталогу при нажатии клавиши назад вместо закрытия окна при выборе файла в плавающем окне
* `Улучшение` Включение проверки числовых значений и автоматической конверсии точек при вводе адреса на компьютере в клиентском режиме
* `Улучшение` Отображение IP-адреса соответствующего устройства на главной странице после установления соединения в клиентском и серверном режимах
* `Улучшение` Добавление защиты от перезаписи для некоторых глобальных объектов и встроенных модулей (см. проектную документацию > глобальные объекты > [защита от перезаписи](https://docs.autojs6.com/#/global?id=%e8%a6%86%e5%86%99%e4%bf%9d%e6%8a%a4))
* `Улучшение` Поддержка строковых параметров и переменного числа параметров в importClass и importPackage
* `Улучшение` Вывод информации о трассировке стека при возникновении исключений в ui.run
* `Улучшение` Удобное получение ID ресурсов AutoJs6 в ui.R и auto.R
* `Улучшение` Поддержка параметров типа App и псевдонимов приложений в методах модуля app, связанных с операциями с приложением
* `Улучшение` Поддержка опускания заполненных параметров в методах модуля dialogs, связанных с асинхронными обратными вызовами
* `Улучшение` Поддержка параметров url в app.startActivity и других методах (см. исходный код > приложение > намерение)
* `Улучшение` Возврат null вместо выбрасывания исключения при неудаче в получении IMEI или серийного номера устройства в модуле device
* `Улучшение` Увеличение яркости текста в окнах логов, отображаемых с помощью console.show, для улучшения читаемости
* `Улучшение` Поддержка сохранения файлов изображений по относительному пути в ImageWrapper#saveTo
* `Улучшение` Переработка глобального объекта colors и добавление поддержки цветовых режимов HSV / HSL (см. проектную документацию > [цвета](https://docs.autojs6.com/#/color))
* `Зависимость` Обновление версии сборщика Gradle с 32 до 33
* `Зависимость` Локализация версии Android Job до 1.4.3
* `Зависимость` Локализация версии Android Plugin Client SDK For Locale до 9.0.0
* `Зависимость` Локализация версии GitHub API до 1.306
* `Зависимость` Добавлена версия JCIP Annotations 1.0
* `Зависимость` Добавлена версия androidx WebKit 1.5.0
* `Зависимость` Добавлена версия Commons IO 2.8.0
* `Зависимость` Добавлена версия Desugar JDK Libs 2.0.0
* `Зависимость` Добавлена версия Jackson DataBind 2.13.3
* `Зависимость` Добавлена версия Jaredrummler Android Device Names 2.1.0
* `Зависимость` Добавлена версия Jaredrummler Animated SVG View 1.0.6
* `Зависимость` Замена Jrummyapps ColorPicker версии 2.1.7 на Jaredrummler ColorPicker версии 1.1.0
* `Зависимость` Обновление версии Gradle с 7.5-rc-1 до 8.0-rc-1
* `Зависимость` Обновление версии инструментов сборки Gradle с 7.4.0-alpha02 до 8.0.0-alpha09
* `Зависимость` Обновление версии плагина Kotlin Gradle с 1.6.10 до 1.8.0-RC2
* `Зависимость` Обновление версии Android Material с 1.6.0 до 1.7.0
* `Зависимость` Обновление версии androidx Annotation с 1.3.0 до 1.5.0
* `Зависимость` Обновление версии androidx AppCompat с 1.4.1 до 1.4.2
* `Зависимость` Обновление версии Android Analytics с 13.3.0 до 14.0.0
* `Зависимость` Обновление версии Gson с 2.9.0 до 2.10
* `Зависимость` Обновление версии Joda Time с 2.10.14 до 2.12.1
* `Зависимость` Обновление версии Kotlinx Coroutines с 1.6.1-native-mt до 1.6.1
* `Зависимость` Обновление версии OkHttp3 с 3.10.0 до 5.0.0-alpha.7 и далее до 5.0.0-alpha.9
* `Зависимость` Обновление версии Zip4j с 2.10.0 до 2.11.2
* `Зависимость` Обновление версии Glide с 4.13.2 до 4.14.2
* `Зависимость` Обновление версии Junit Jupiter с 5.9.0 до 5.9.1

# v6.1.1

###### 2022/05/31

* `Новое` Функции проверки обновлений, загрузки обновлений и уведомлений об обновлениях (см. страницу настроек) (временная отсутствует поддержка систем Android 7.x)
* `Исправление` Проблема с невозможностью чтения и записи на внешнюю память в системах Android 10 _[`вопрос #17`](http://issues.autojs6.com/17)_
* `Исправление` Проблема с возможностью сбоя приложения при длительном нажатии на странице редактора _[`вопрос #18`](http://issues.autojs6.com/18)_
* `Исправление` Проблема неработающих функций "Удалить строку" и "Копировать строку" в контекстном меню страницы редактора при длительном нажатии
* `Исправление` Проблема отсутствия функции "Вставить" в меню опций страницы редактора
* `Улучшение` Локализация некоторых строк сообщений об исключениях (en / zh)
* `Улучшение` Изменение компоновки кнопок и добавление цветовой дифференциации в диалоговом окне несохраненного содержимого
* `Зависимость` Добавлена версия github-api 1.306
* `Зависимость` Замена retrofit2-rxjava2-adapter версии 1.0.0 на adapter-rxjava2 версии 2.9.0

# v6.1.0

###### 2022/05/26 - Изменение имени пакета, осторожно обновляйтесь

* `Подсказка` Изменение имени приложения на org.autojs.autojs6 для избежания конфликта с именем пакета Auto.js с открытым исходным кодом
* `Новое` Добавлен переключатель "Проекционные медиа разрешения" в главное меню (Root / ADB способ) (экспериментальное)
* `Новое` Файловый менеджер поддерживает отображение скрытых файлов и папок (см. страницу настроек)
* `Новое` Функция обязательной проверки Root (см. страницу настроек и пример кода)
* `Новое` Модуль autojs (см. Примеры > AutoJs6)
* `Новое` Модуль tasks (см. Примеры > Задачи)
* `Новое` Метод console.launch() запускает страницу логов
* `Новое` Утилита util.morseCode (см. Примеры > Утилиты > Морзянка)
* `Новое` Утилита util.versionCodes (см. Примеры > Утилиты > Версии Android)
* `Новое` Метод util.getClass() и другие (см. Примеры > Утилиты > Получение класса и имени класса)
* `Новое` Метод timers.setIntervalExt() (см. Примеры > Таймеры > Условное циклическое выполнение)
* `Новое` Методы colors.toInt() / rgba() и другие (см. Примеры > Изображения и цвета > Основные преобразования цвета)
* `Новое` Методы automator.isServiceRunning() / ensureService()
* `Новое` Методы automator.lockScreen() и другие (см. Примеры > Сервисы доступности > Новое в Android 9)
* `Новое` Методы automator.headsethook() и другие (см. Примеры > Сервисы доступности > Новое в Android 11)
* `Новое` Метод automator.captureScreen() (см. Примеры > Сервисы доступности > Получение скриншотов)
* `Новое` Параметры опций метода dialogs.build() animation, linkify и другие (см. Примеры > Диалоги > Персонализированные диалоги)
* `Исправление` Неисправность параметров опций метода dialogs.build() inputHint, itemsSelectedIndex и другие
* `Исправление` Неисправность параметров обратного вызова метода JsDialog#on('multi_choice')
* `Исправление` Проблема, в которой UiObject#parent().indexInParent() всегда возвращает -1 _[`issue #16`](http://issues.autojs6.com/16)_
* `Исправление` Возможная проблема с невызывающимся Thenable в Promise.resolve() в конце скрипта
* `Исправление` Возможные опечатки в именах пакетов или классов (boardcast -> broadcast / auojs -> autojs)
* `Исправление` Возможный сбой приложения при вызове images.requestScreenCapture() на высоких версиях Android (API >= 31)
* `Исправление` Возможный сбой приложения при одновременном вызове images.requestScreenCapture() несколькими экземплярами скриптов
* `Исправление` Возможная проблема с зависанием при вызове new RootAutomator()
* `Улучшение` RootAutomator не может быть создан без Root прав
* `Улучшение` Переработана страница "О приложении и разработчике"
* `Улучшение` Рефакторинг всех встроенных модулей JavaScript
* `Улучшение` Рефакторинг всех скриптов сборки Gradle и добавление общего конфигурационного скрипта (config.gradle)
* `Улучшение` Инструмент сборки Gradle поддерживает автоматическое управление номерами версий и автоматическое именование файлов сборки
* `Улучшение` Инструмент сборки Gradle добавляет задачу для добавления CRC32 к файлам сборки (appendDigestToReleasedFiles)
* `Улучшение` Запись исключений в результат при вызове shell() вместо выбрасывания исключений напрямую (без необходимости try/catch)
* `Улучшение` Использование Rhino встроенного JSON вместо модуля json2
* `Улучшение` Поддержка параметра таймаута в auto.waitFor()
* `Улучшение` Поддержка параметров функций стрелочных в threads.start()
* `Улучшение` Поддержка параметра уровня логов в console.trace() (см. Примеры > Консоль > Печать стека вызовов)
* `Улучшение` Поддержка режима вибрации и вибрации Морзянкой в device.vibrate() (см. Примеры > Устройства > Режим вибрации / Вибрация Морзянкой)
* `Улучшение` Адаптация разрешений на чтение и запись внешнего хранилища для высоких версий Android (API >= 30)
* `Улучшение` Добавление шрифта Material Color для улучшения читаемости шрифтов в обычной и ночной темах
* `Улучшение` Слабые ссылки на все экземпляры ImageWrapper и автоматическая очистка в конце скрипта (экспериментальное)
* `Зависимость` Добавлен CircleImageView версии 3.1.0
* `Зависимость` Обновлен Android Analytics до версии 13.1.0 -> 13.3.0
* `Зависимость` Обновлен Gradle сборочный инструмент до версии 7.3.0-alpha06 -> 7.4.0-alpha02
* `Зависимость` Обновлен Android Job до версии 1.4.2 -> 1.4.3
* `Зависимость` Обновлен Android Material до версии 1.5.0 -> 1.6.0
* `Зависимость` Обновлен CrashReport до версии 2.6.6 -> 4.0.4
* `Зависимость` Обновлен Glide до версии 4.13.1 -> 4.13.2
* `Зависимость` Обновлен Joda Time до версии 2.10.13 -> 2.10.14
* `Зависимость` Обновлен Kotlin Gradle плагин до версии 1.6.10 -> 1.6.21
* `Зависимость` Обновлены Kotlinx Coroutines до версии 1.6.0 -> 1.6.1-native-mt
* `Зависимость` Обновлен LeakCanary до версии 2.8.1 -> 2.9.1
* `Зависимость` Обновлен OkHttp3 до версии 5.0.0-alpha.6 -> 5.0.0-alpha.7
* `Зависимость` Обновлен Rhino двигатель до версии 1.7.14 -> 1.7.15-snapshot
* `Зависимость` Обновлен Zip4j до версии 2.9.1 -> 2.10.0
* `Зависимость` Удален Groovy JSON версии 3.0.8
* `Зависимость` Удалена Kotlin Stdlib JDK7 версии 1.6.21

# v6.0.3

###### 2022/03/19

* `Новое` Функция переключения языков (не завершена)
* `Новое` Модуль recorder (см. Примеры > Таймеры)
* `Новое` Использование "Изменение разрешений безопасности" для автоматического включения сервисов доступности и переключателей
* `Исправление` Проблема с невыпадающими значками панели быстрого доступа после нажатия (поправка) _[`issue #7`](http://issues.autojs6.com/7)_
* `Исправление` Проблема с возможным сбоем AutoJs6 при использовании параметра обязательного отображения в toast
* `Исправление` Проблема с возможным сбоем AutoJs6 при неполной передаче заголовков данных в Socket
* `Улучшение` Автоматическое включение сервиса доступности при запуске или перезапуске AutoJs6 согласно настройкам
* `Улучшение` Попытка автоматического включения сервиса доступности при включении плавающей кнопки
* `Улучшение` Добавление английских переводов для всех ресурсов
* `Улучшение` Небольшие изменения макета главного меню для уменьшения расстояния между элементами
* `Улучшение` Синхронизация состояния переключателя службы переднего плана в главном меню
* `Улучшение` Немедленная синхронизация состояния переключателя при развернутом главном меню
* `Улучшение` Добавление состояния и результата проверки положения курсора
* `Улучшение` Поддержка 64-битных операционных систем (Ref to [TonyJiangWJ](https://github.com/TonyJiangWJ))
* `Улучшение` Применение настроек прозрачности при инициализации плавающей кнопки без необходимости клика
* `Улучшение` Проверка, является ли файл примером кода при сбросе содержимого файла и добавление информации о результате
* `Улучшение` Перенос адреса загрузки плагинов сборки из GitHub в JsDelivr
* `Зависимость` Добавлен Zeugma Solutions LocaleHelper версии 1.5.1
* `Зависимость` Понижена версия Android Material до 1.6.0-alpha02 -> 1.5.0
* `Зависимость` Обновлены Kotlinx Coroutines до версии 1.6.0-native-mt -> 1.6.0
* `Зависимость` Обновлен OpenCV до версии 3.4.3 -> 4.5.4 -> 4.5.5 (Ref to [TonyJiangWJ](https://github.com/TonyJiangWJ))
* `Зависимость` Обновлен OkHttp3 до версии 3.10.0 -> 5.0.0-alpha.4 -> 5.0.0-alpha.6
* `Зависимость` Обновлен Gradle сборочный инструмент до версии 7.2.0-beta01 -> 7.3.0-alpha06
* `Зависимость` Обновлен Auto.js-ApkBuilder до версии 1.0.1 -> 1.0.3
* `Зависимость` Обновлен Glide Compiler до версии 4.12.0 -> 4.13.1
* `Зависимость` Обновлен Gradle выпуск до версии 7.4-rc-2 -> 7.4.1
* `Зависимость` Обновлен Gradle Compile до версии 31 -> 32
* `Зависимость` Обновлен Gson до версии 2.8.9 -> 2.9.0

# v6.0.2

###### 2022/02/05

* `Новое` Метод обработки изображений images.bilateralFilter() для двусторонней фильтрации
* `Исправление` Проблема с использованием только последнего вызова toast при многократных вызовах
* `Исправление` Проблема с возможной неэффективностью toast.dismiss()
* `Исправление` Проблемы с некорректной работой клиентского и серверного режимов
* `Исправление` Проблемы с некорректным обновлением состояния переключателей клиентского и серверного режимов
* `Исправление` Ошибка разбора UI элементов текстового режима в Android 7.x (Ref to [TonyJiangWJ](https://github.com/TonyJiangWJ)) _[`issue #4`](http://issues.autojs6.com/4)_ _[`issue #9`](http://issues.autojs6.com/9)_
* `Улучшение` Игнорирование ScriptInterruptedException исключений в sleep()
* `Зависимость` Добавлен Androidx AppCompat (Legacy) версии 1.0.2
* `Зависимость` Обновлен Androidx AppCompat до версии 1.4.0 -> 1.4.1
* `Зависимость` Обновлен Androidx Preference до версии 1.1.1 -> 1.2.0
* `Зависимость` Обновлен Rhino двигатель до версии 1.7.14-snapshot -> 1.7.14
* `Зависимость` Обновлен OkHttp3 до версии 3.10.0 -> 5.0.0-alpha.3 -> 5.0.0-alpha.4
* `Зависимость` Обновлен Android Material до версии 1.6.0-alpha01 -> 1.6.0-alpha02
* `Зависимость` Обновлен Gradle сборочный инструмент до версии 7.2.0-alpha06 -> 7.2.0-beta01
* `Зависимость` Обновлен Gradle выпуск до версии 7.3.3 -> 7.4-rc-2

# v6.0.1

###### 2022/01/01

* `Новое` Поддержка подключения VSCode плагина в режиме клиента (LAN) и сервера (LAN/ADB) (ссылка на [Auto.js Pro](https://g.pro.autojs.org/))
* `Новое` Модуль base64 (ссылка на [Auto.js Pro](https://g.pro.autojs.org/))
* `Новое` Добавлены глобальные методы isInteger/isNullish/isObject/isPrimitive/isReference
* `Новое` Добавлен polyfill (Object.getOwnPropertyDescriptors)
* `Новое` Добавлен polyfill (Array.prototype.flat)
* `Улучшение` Расширение функции global.sleep для поддержки случайного диапазона/отрицательных значений
* `Улучшение` Расширение функции global.toast для поддержки продолжительности/принудительного перекрытия/dismiss
* `Улучшение` Глобализация объектов пакетов (okhttp3/androidx/de)
* `Зависимость` Обновлена версия Android Material с 1.5.0-beta01 до 1.6.0-alpha01
* `Зависимость` Обновлена версия сборочного инструмента Gradle с 7.2.0-alpha04 до 7.2.0-alpha06
* `Зависимость` Обновлена версия Kotlinx Coroutines с 1.5.2-native-mt до 1.6.0-native-mt
* `Зависимость` Обновлена версия плагина Kotlin Gradle с 1.6.0 до 1.6.10
* `Зависимость` Обновлена версия Gradle с 7.3 до 7.3.3

# v6.0.0

###### 2021/12/01

* `Новое` Добавлена кнопка перезапуска приложения в нижней части главного меню
* `Новое` Добавлены переключатели для отключения оптимизации батареи/отображения поверх других приложений в главном меню
* `Исправление` Исправление проблемы с аномальной цветовой темой в некоторых регионах после первичной установки приложения
* `Исправление` Исправление проблемы невозможности сборки проекта при отсутствии файла sign.property
* `Исправление` Исправление ошибки хранения месяца одноразовых задач на панели задач
* `Исправление` Исправление проблемы несовпадения цвета переключателей в настройках приложения при изменении темы
* `Исправление` Исправление проблемы распознавания пакетов и неверного адреса загрузки пакетов
* `Исправление` Исправление возможной несинхронизации состояния переключателя «Классические права доступа» в главном меню
* `Исправление` Исправление потенциальной утечки памяти Mat в TemplateMatching.fastTemplateMatching
* `Улучшение` Обновление версии двигателя Rhino с 1.7.7.2 до 1.7.13 и до 1.7.14-snapshot
* `Улучшение` Обновление OpenCV с версии 3.4.3 до 4.5.4
* `Улучшение` Улучшение совместимости функции ViewUtil.getStatusBarHeight
* `Улучшение` Удаление модуля входа пользователя и элементов интерфейса в главном меню
* `Улучшение` Удаление вкладок сообщества и маркетплейса из главной страницы и оптимизация макета
* `Улучшение` Изменение некоторых параметров настроек по умолчанию
* `Улучшение` Добавление даты с начала на страницу «О приложении» и улучшение отображения авторских прав
* `Улучшение` Обновление модуля JSON до версии 2017-06-12 и интеграция cycle.js
* `Улучшение` Удаление функции автоматической проверки обновлений при запуске Activity и удаление связанных кнопок
* `Улучшение` Улучшение логики внутреннего кода в AppOpsKt#isOpPermissionGranted
* `Улучшение` Улучшение безопасности использования ResourceMonitor с ReentrantLock (ссылка на [TonyJiangWJ](https://github.com/TonyJiangWJ))
* `Улучшение` Замена репозитория JCenter на Maven Central и аналогичные
* `Улучшение` Рефакторинг и удаление повторяющихся локальных библиотек
* `Зависимость` Локализованная версия CrashReport 2.6.6
* `Зависимость` Локализованная версия MutableTheme 1.0.0
* `Зависимость` Добавлена версия Androidx Preference 1.1.1
* `Зависимость` Добавлена версия SwipeRefreshLayout 1.1.0
* `Зависимость` Обновление версии Android Analytics с 7.0.0 до 13.1.0
* `Зависимость` Обновление версии Android Annotations с 4.5.2 до 4.8.0
* `Зависимость` Обновление сборочного инструмента Gradle с 3.2.1 до 4.1.0, затем до 7.0.3 и до 7.2.0-alpha04
* `Зависимость` Обновление версии Android Job с 1.2.6 до 1.4.2
* `Зависимость` Обновление версии Android Material с 1.1.0-alpha01 до 1.5.0-beta01
* `Зависимость` Обновление версии Androidx MultiDex с 2.0.0 до 2.0.1
* `Зависимость` Обновление версии Apache Commons Lang3 с 3.6 до 3.12.0
* `Зависимость` Обновление версии Appcompat с 1.0.2 до 1.4.0
* `Зависимость` Обновление версии плагина ButterKnife Gradle с 9.0.0-rc2 до 10.2.1 и до 10.2.3
* `Зависимость` Обновление версии ColorPicker с 2.1.5 до 2.1.7
* `Зависимость` Обновление версии Espresso Core с 3.1.1-alpha01 до 3.5.0-alpha03
* `Зависимость` Обновление версии Eventbus с 3.0.0 до 3.2.0
* `Зависимость` Обновление версии Glide Compiler с 4.8.0 до 4.12.0
* `Зависимость` Обновление версии Gradle Build Tool с 29.0.2 до 30.0.2
* `Зависимость` Обновление версии Gradle Compile с 28 до 30 и до 31
* `Зависимость` Обновление версии Gradle с 4.10.2 до 6.5, затем до 7.0.2 и до 7.3
* `Зависимость` Обновление версии плагина Groovy-Json с 3.0.7 до 3.0.8
* `Зависимость` Обновление версии Gson с 2.8.2 до 2.8.9
* `Зависимость` Обновление версии JavaVersion с 1.8 до 11 и до 16
* `Зависимость` Обновление версии Joda Time с 2.9.9 до 2.10.13
* `Зависимость` Обновление версии Junit с 4.12 до 4.13.2
* `Зависимость` Обновление версии плагина Kotlin Gradle с 1.3.10 до 1.4.10 и до 1.6.0
* `Зависимость` Обновление версии Kotlinx Coroutines с 1.0.1 до 1.5.2-native-mt
* `Зависимость` Обновление версии LeakCanary с 1.6.1 до 2.7
* `Зависимость` Обновление версии LicensesDialog с 1.8.1 до 2.2.0
* `Зависимость` Обновление версии Material Dialogs с 0.9.2.3 до 0.9.6.0
* `Зависимость` Обновление версии OkHttp3 с 3.10.0 до 5.0.0-alpha.2 и до 5.0.0-alpha.3
* `Зависимость` Обновление версии Reactivex RxJava2 RxAndroid с 2.0.1 до 2.1.1
* `Зависимость` Обновление версии Reactivex RxJava2 с 2.1.2 до 2.2.21
* `Зависимость` Обновление версии Retrofit2 Converter Gson с 2.3.0 до 2.9.0
* `Зависимость` Обновление версии Retrofit2 с 2.3.0 до 2.9.0
* `Зависимость` Обновление версии Zip4j с 1.3.2 до 2.9.1