<!--suppress HtmlDeprecatedAttribute, HttpUrlsUsage -->

<div align="center">
  <p>
    <img src="https://s1.imagehub.cc/images/2023/03/07/af8ed087c9d354b9ab6142aae7bbafb6.png" alt="autojs6-banner_800×224" border="0" width="704" />
  </p>

  <p>Android 平臺支援無障礙服務的 JavaScript 自動化工具</p>

  <p>
    <a href="http://download.autojs6.com"><img alt="GitHub release (latest by date)" src="https://img.shields.io/github/v/release/SuperMonster003/AutoJs6"/></a>
    <a href="http://issues.autojs6.com"><img alt="GitHub closed issues" src="https://img.shields.io/github/issues/SuperMonster003/AutoJs6?color=009688"/></a>
    <a href="http://commit.autojs6.com/99a1d8490fac5b6d55f6f183db59ad833a2064ed"><img alt="Created" src="https://img.shields.io/date/1636632233?color=2e7d32&label=created"/></a>
    <br>
    <a href="https://github.com/mozilla/rhino"><img alt="Rhino" src="https://img.shields.io/badge/rhino-1.7.16--snapshot-A24232"/></a>
    <a href="https://developer.android.com/studio/archive"><img alt="Android Studio" src="https://img.shields.io/badge/android%20studio-2022.1+-B64FC8"/></a>
    <br>
    <a href="https://www.codefactor.io/repository/github/SuperMonster003/AutoJs6"><img alt="CodeFactor Grade" src="https://www.codefactor.io/repository/github/SuperMonster003/AutoJs6/badge"/></a>
    <a href="https://www.jetbrains.com/?from=AutoJs6"><img alt="JetBrains supporter" src="https://img.shields.io/badge/supporter-JetBrains-ee4677"/></a>
    <a href="http://project.autojs6.com/blob/master/LICENSE"><img alt="GitHub License" src="https://img.shields.io/github/license/SuperMonster003/AutoJs6?color=534BAE"/></a>
  </p>
</div>

******

### 語言 (Languages)

******

當前自述檔案 `README.md` 支援以下語言:

 - [简体中文 [zh-Hans]](http://project.autojs6.com/blob/master/.readme/README-zh-Hans.md)
 - [繁體中文 (香港) [zh-Hant-HK]](http://project.autojs6.com/blob/master/.readme/README-zh-Hant-HK.md)
 - 繁體中文 (台灣) [zh-Hant-TW] # 當前
 - [English [en]](http://project.autojs6.com/blob/master/.readme/README-en.md)
 - [Français [fr]](http://project.autojs6.com/blob/master/.readme/README-fr.md)
 - [Español [es]](http://project.autojs6.com/blob/master/.readme/README-es.md)
 - [日本語 [ja]](http://project.autojs6.com/blob/master/.readme/README-ja.md)
 - [한국어 [ko]](http://project.autojs6.com/blob/master/.readme/README-ko.md)
 - [Русский [ru]](http://project.autojs6.com/blob/master/.readme/README-ru.md)
 - [العربية [ar]](http://project.autojs6.com/blob/master/.readme/README-ar.md)

******

### 簡介

******

[Auto.js](https://github.com/hyb1996/Auto.js) 是一款 Android 平臺支援 [無障礙服務](https://developer.android.com/guide/topics/ui/accessibility/service?hl=zh-cn) 的 JavaScript 自動化工具軟體.

Auto.js 由 [hyb1996](https://github.com/hyb1996) 於 `2017/01/27` 初次釋出, 於 `2020/03/13` 停止維護, 最終版本名稱為 `4.1.1 Alpha2`, 構建版本號為 `461`.

AutoJs6 在 Auto.js 最終專案的基礎上, 於 `2021/12/01` 進行二次開發, 繼續保持開源免費.

下表列舉了部分 Auto.js 相關專案 (按開發日期排序):

| <span style="word-break:keep-all;white-space:nowrap">專案</span> |                                                             <span style="word-break:keep-all;white-space:nowrap">應用名稱</span>                                                              | <span style="word-break:keep-all;white-space:nowrap">開發者</span> | <span style="word-break:keep-all;white-space:nowrap">開發日期</span> | <span style="word-break:keep-all;white-space:nowrap">終止開發日期</span> |
|:------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------:|:---------------------------------------------------------------------------------------------------------------------------------:|:-------------------------------------------------------------------------------------------------------------------------------:|
|     <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/hyb1996/Auto.js)</span>      |    <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/TonyJiangWJ/Auto.js/commit/268ec8895bbfa28fc7715154eb15b1c1eaaefd14#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span>     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2017/01/27`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2020/03/13`</span>                             |
|                     <span style="word-break:keep-all;white-space:nowrap">Auto.js Pro 7</span>                      |                                                                                     <span style="word-break:keep-all;white-space:nowrap">Auto.js</span>                                                                                      |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2019/03/13`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2019/07/08`</span>                             |
|                     <span style="word-break:keep-all;white-space:nowrap">Auto.js Pro 8</span>                      |                                                                                    <span style="word-break:keep-all;white-space:nowrap">AutoJsPro</span>                                                                                     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2019/10/13`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2021/07/24`</span>                             |
|   <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/TonyJiangWJ/Auto.js)</span>    | <span style="word-break:keep-all;white-space:nowrap">[Auto.js&#160;M](https://github.com/TonyJiangWJ/Auto.js/commit/268ec8895bbfa28fc7715154eb15b1c1eaaefd14#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span> |      <span style="word-break:keep-all;white-space:nowrap">[TonyJiangWJ](https://github.com/TonyJiangWJ)</span>       |                             <span style="word-break:keep-all;white-space:nowrap">`2019/11/21`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|      <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/kkevsekk1/AutoX)</span>       |                 <span style="white-space:pre">[Autox.js](https://github.com/kkevsekk1/AutoX/commit/8143e4ed893d4af05d22aa791b83a962f9959873#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span>                  |        <span style="word-break:keep-all;white-space:nowrap">[kkevsekk1](https://github.com/kkevsekk1)</span>         |                             <span style="word-break:keep-all;white-space:nowrap">`2020/07/24`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|        <span style="word-break:keep-all;white-space:nowrap">[Auto.js Pro 9](https://pro.autojs.org/)</span>        |                                                                                    <span style="word-break:keep-all;white-space:nowrap">AutoJsPro</span>                                                                                     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2021/03/28`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2023/02/09`</span>                             |
| <span style="word-break:keep-all;white-space:nowrap">[AutoJs6](https://github.com/SuperMonster003/AutoJs6)</span>  |  <span style="word-break:keep-all;white-space:nowrap">[AutoJs6](https://github.com/SuperMonster003/AutoJs6/commit/a8ce1b9acb541e9736c33134be3194c3148a15a3#diff-833a46a97033e77558372a2dce103fd6fee29aaaa899f610022a7aece592ee7bR27)</span>  |  <span style="word-break:keep-all;white-space:nowrap">[SuperMonster003](https://github.com/SuperMonster003)</span>   |                             <span style="word-break:keep-all;white-space:nowrap">`2021/12/01`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|      <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/kkevsekk1/AutoX)</span>       |            <span style="white-space:pre">[Autox.js&#160;v6](https://github.com/kkevsekk1/AutoX/commit/8b6776cff8b0fca4be4a52719b7d7d07c0a058f3#diff-51a0b488f963eb0be6c6599bf5df497313877cf5bdff3950807373912ac1cdc9R130)</span>             |           <span style="word-break:keep-all;white-space:nowrap">[wilinz](https://github.com/wilinz)</span>            |                             <span style="word-break:keep-all;white-space:nowrap">`2022/05/26`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|      <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/kkevsekk1/AutoX)</span>       |            <span style="white-space:pre">[Autox.js&#160;v7](https://github.com/kkevsekk1/AutoX/commit/484491fd5fe12b8203d0b09c181eb0f471c0ea9f#diff-8cff73265af19c059547b76aca8882cbaa3209291406f52df1dafbbc78e80c46R120)</span>             |           <span style="word-break:keep-all;white-space:nowrap">[aiselp](https://github.com/aiselp)</span>            |                             <span style="word-break:keep-all;white-space:nowrap">`2024/04/21`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |

表格中的日期為預估值, 與實際可能存在出入.

表格中 Auto.js Pro 7/8/9 為付費版本, 其餘為免費開源版本.

******

### 功能

******

* 可用作 JavaScript IDE (程式碼補全/變數重新命名/程式碼格式化)
* 支援基於 [無障礙服務](https://developer.android.com/reference/android/accessibilityservice/AccessibilityService) 的自動化操作
* 支援浮動按鈕快捷操作 (指令碼錄製及執行/檢視包名及活動/佈局分析)
* 支援選擇器 API 並提供控制元件遍歷/獲取資訊/控制元件操作 (類似 [UiAutomator](https://developer.android.com/training/testing/ui-automator))
* 支援佈局介面分析 (類似 Android Studio 的 LayoutInspector)
* 支援錄製功能及錄製回放
* 支援螢幕截圖/儲存截圖/圖片找色/圖片匹配
* 支援 [E4X](https://zh.wikipedia.org/wiki/E4X) (ECMAScript for XML) 編寫介面
* 支援將指令碼檔案或專案打包為 APK 檔案
* 支援利用 Root 許可權擴充套件功能 (螢幕點選/滑動/錄製/Shell)
* 支援作為 Tasker 外掛使用
* 支援與 VSCode 連線並進行桌面開發 (需要 [AutoJs6-VSCode-Extension](http://vscext-project.autojs6.com) 外掛)

******

### 環境

******

- Android 作業系統
- [API](https://developer.android.com/guide/topics/manifest/uses-sdk-element#ApiLevels) [24](https://developer.android.com/reference/android/os/Build.VERSION_CODES#N) ([7.0](https://zh.wikipedia.org/wiki/Android_Nougat)) [[N](https://developer.android.com/reference/android/os/Build.VERSION_CODES#N)] 及以上

******

### 指南

******

* [應用文件](https://docs.autojs6.com)
* [使用手冊 (待編寫)](https://docs.autojs6.com/#/manual)
* [疑難解答](https://docs.autojs6.com/#/qa)
* [專案編譯構建](#project-compilation-and-build)
* [指令碼開發輔助](#script-development-assistance)

******

### 主要變更

******

相較於 Auto.js 最終開源版本 `4.1.1 Alpha2`, AutoJs6 主要進行了以下升級或變更:

* 支援透過 [Shizuku](https://shizuku.rikka.app/introduction/) 獲得 ADB 特權並使用系統 API
* 支援構建 [WebSocket](https://docs.autojs6.com/#/webSocketType) 例項以完成基於 [WebSocket 協議](https://zh.wikipedia.org/wiki/WebSocket) 的網路請求
* 新增模組 [ [base64](https://docs.autojs6.com/#/base64) / [crypto](https://docs.autojs6.com/#/crypto) / [sqlite](https://docs.autojs6.com/#/sqlite) / [i18n](https://docs.autojs6.com/#/i18n) / [notice](https://docs.autojs6.com/#/notice) / [ocr](https://docs.autojs6.com/#/ocr) / [opencc](https://docs.autojs6.com/#/opencc) / [qrcode](https://docs.autojs6.com/#/qrcode) / [shizuku](https://docs.autojs6.com/#/shizuku) / ... ]
* 多語言適配 [ 西 / 法 / 俄 / 阿 / 日 / 韓 / 英 / 簡中 / 繁中 / ... ]
* 夜間模式適配 [ 設定頁面 / 文件頁面 / 佈局分析頁面 / 浮動視窗 / ... ]
* [VSCode 外掛](http://vscext-project.autojs6.com) 支援客戶端 (LAN) 及服務端 (LAN/ADB) 連線方式
* [Rhino](https://github.com/mozilla/rhino/) 引擎由 [v1.7.7.2](https://github.com/mozilla/rhino/releases/tag/Rhino1_7_7_2_Release) 升級至 [v1.7.16-SNAPSHOT](http://rhino.autojs6.com/blob/master/gradle.properties#L3)
    * Unicode [碼位](https://developer.mozilla.org/zh-CN/docs/Glossary/Code_point) 轉義支援 [輔助平面](https://zh.wikipedia.org/wiki/Unicode%E5%AD%97%E7%AC%A6%E5%B9%B3%E9%9D%A2%E6%98%A0%E5%B0%84#%E7%AC%AC%E4%B8%80%E8%BC%94%E5%8A%A9%E5%B9%B3%E9%9D%A2) 字元
       ```javascript
       '\u{1D160}'; /* 表示 "𝅘𝅥𝅮", 傳統方式: '\uD834\uDD60'. */
       ```
    * 支援 [Object.values()](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Global_Objects/Object/values)
       ```javascript
       Object.values({name: 'Max', age: 4}); // ['max', 4]
       ```
    * 支援 [Array.prototype.includes()](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Global_Objects/Array/includes)
       ```javascript
       [10, 20, NaN].includes(20); // true
       ```
    * 支援 [BigInt](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Global_Objects/BigInt)
       ```javascript
       typeof 567n === 'bigint'; // true
       ```
    * 支援 [模板字串](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Template_literals)
       ```javascript
       `Lucky number: ${(Math.random() * 100).toFixed(0)}`
       ```
    * 檢視 Rhino 引擎 [更多新特性](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/RHINO.md)
    * 檢視 Rhino 引擎 [相容性列表](https://mozilla.github.io/rhino/compat/engines.html)

******

### 版本歷史

******

# v6.6.1

###### 2025/01/01

* `新增` pinyin 模組, 用於漢語拼音轉換 (參閱 專案文件 > [漢語拼音](https://docs.autojs6.com/#/pinyin))
* `新增` pinyin4j 模組, 用於漢語拼音轉換 (參閱 專案文件 > [漢語拼音](https://docs.autojs6.com/#/pinyin4j))
* `新增` UiObject#isSimilar 及 UiObjectCollection#isSimilar 方法, 用於確定控制元件或控制元件集合是否相似
* `新增` currentComponent 全域性方法, 用於獲取當前活動的元件名稱資訊
* `修復` 部分環境因回退版本過低而無法正常編譯專案的問題
* `修復` 呼叫不存在的方法時可能出現的 "非原始型別值" 異常
* `修復` 部分裝置無法正常新增指令碼快捷方式的問題 (試修) _[`issue #221`](http://issues.autojs6.com/221)_
* `修復` automator.click/longClick 方法引數型別限制錯誤 _[`issue #275`](http://issues.autojs6.com/275)_
* `修復` 選擇器不支援 ConsString 型別引數的問題 _[`issue #277`](http://issues.autojs6.com/277)_
* `修復` UiObjectCollection 例項缺失自身方法及屬性的問題
* `最佳化` 打包頁面支援簽名配置/金鑰庫管理/許可權設定 (by [luckyloogn](https://github.com/luckyloogn)) _[`pr #286`](http://pr.autojs6.com/286)_
* `最佳化` 提升浮動視窗當前包名及當前活動名的識別準確性 (優先順序: Shizuku > Root > A11Y)
* `最佳化` 提升 currentPackage/currentActivity 識別準確性 (優先順序: Shizuku > Root > A11Y)
* `最佳化` 恢復日誌活動視窗單個條目文字內容的雙擊或長按選擇功能 _[`issue #280`](http://issues.autojs6.com/280)_
* `最佳化` 指令碼專案識別在 project.json 損壞情況下儘可能還原關鍵資訊
* `最佳化` 打包單檔案時自動生成的包名字尾支援將簡體中文轉換為拼音 (支援多音字)
* `最佳化` UiSelector#findOnce 及 UiSelector#find 方法支援負數引數
* `最佳化` app.startActivity/startDualActivity 方法增強適配性
* `最佳化` UI 元素及 className 相關選擇器支援更多的包名字首省略形式 (如 RecyclerView, Snackbar 等)
* `最佳化` 同步最新的 Rhino 引擎官方上游程式碼並進行必要的程式碼適配
* `最佳化` 部分依賴或本地庫版本調整 _[`CHANGELOG.md`](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG.md#v661)_

# v6.6.0

###### 2024/12/02 - 內建模組重寫, 謹慎升級

* `提示` 內建模組使用 Kotlin 重新編寫以提升指令碼執行效率但可能需要多次迭代逐步完善
* `提示` 內建 init.js 檔案預設為空但支援開發者自行擴充套件內建模組或掛載外部模組
* `新增` axios 模組 / cheerio 模組 (Ref to [AutoX](https://github.com/kkevsekk1/AutoX))
* `新增` sqlite 模組, 用於 SQLite 資料庫簡單操作 (Ref to [Auto.js Pro](https://g.pro.autojs.org/)) (參閱 專案文件 > [SQLite](https://docs.autojs6.com/#/sqlite))
* `新增` mime 模組, 用於處理和解析 MIME 型別字串 (參閱 專案文件 > [MIME](https://docs.autojs6.com/#/mime))
* `新增` nanoid 模組, 可作為字串 ID 生成器 (Ref to [ai/nanoid](https://github.com/ai/nanoid))
* `新增` sysprops 模組, 用於獲取執行時環境配置資料 (參閱 專案文件 > [系統屬性](https://docs.autojs6.com/#/sysprops))
* `新增` ocr 模組支援 [Rapid OCR](https://github.com/RapidAI/RapidOCR) 引擎
* `新增` 佈局分析支援切換視窗 (Ref to [Auto.js Pro](https://g.pro.autojs.org/))
* `新增` auto.clearCache 方法, 支援清除控制元件快取 (Ref to [Auto.js Pro](https://g.pro.autojs.org/))
* `新增` threads.pool 方法, 支援執行緒池簡單應用 (Ref to [Auto.js Pro](https://g.pro.autojs.org/))
* `新增` images.matchTemplate 方法增加 useTransparentMask 選項引數, 支援透明找圖 (Ref to [Auto.js Pro](https://g.pro.autojs.org/))
* `新增` images.requestScreenCaptureAsync 方法, 用於 UI 模式非同步方式申請截圖許可權 (Ref to [Auto.js Pro](https://g.pro.autojs.org/))
* `新增` images.requestScreenCapture 方法增加 isAsync 選項引數, 支援非同步方式獲取螢幕截圖 (Ref to [Auto.js Pro](https://g.pro.autojs.org/))
* `新增` images.on('screen_capture', callback) 等事件監聽方法, 支援監聽螢幕截圖可用事件 (Ref to [Auto.js Pro](https://g.pro.autojs.org/))
* `新增` images.stopScreenCapture 方法, 支援主動釋放截圖申請的相關資源 (Ref to [Auto.js Pro](https://g.pro.autojs.org/))
* `新增` images.psnr/mse/ssim/mssim/hist/ncc 及 images.getSimilarity 方法, 用於獲取影象相似性度量值
* `新增` images.isGrayscale 方法, 用於判斷影象是否為灰度影象
* `新增` images.invert 方法, 用於反色影象轉換
* `新增` s13n.point/time 方法, 用於標準化點物件及時長物件 (參閱 專案文件 > [標準化](https://docs.autojs6.com/#/s13n))
* `新增` console 模組 gravity (重力), touchThrough (穿透點選), backgroundTint (背景著色) 等相關方法 (參閱 專案文件 > [控制檯](https://docs.autojs6.com/#/console))
* `新增` Mathx.randomInt/Mathx.randomFloat 方法, 用於返回指定範圍內的隨機整數或隨機浮點數
* `新增` app.launchDual/startDualActivity 等方法, 用於處理雙開應用 (需要 Shizuku 或 Root 許可權) (實驗性)
* `新增` app.kill 方法, 用於強制停止應用 (需要 Shizuku 或 Root 許可權)
* `新增` floaty.getClip 方法, 用於藉助浮動視窗聚焦間接獲取剪下板內容
* `修復` Fragment 子類 (如 [DrawerFragment](https://github.com/SuperMonster003/AutoJs6/blob/17616504ab0bba93b30ab7abc67108ee5253f39a/app/src/main/java/org/autojs/autojs/ui/main/drawer/DrawerFragment.kt#L369) / [ExplorerFragment](https://github.com/SuperMonster003/AutoJs6/blob/17616504ab0bba93b30ab7abc67108ee5253f39a/app/src/main/java/org/autojs/autojs/ui/main/scripts/ExplorerFragment.kt#L48) 等) 中存在的 View Binding 記憶體洩漏
* `修復` [ScreenCapture](https://github.com/SuperMonster003/AutoJs6/blob/17616504ab0bba93b30ab7abc67108ee5253f39a/app/src/main/java/org/autojs/autojs/core/image/capture/ScreenCapturer.java#L70) / [ThemeColorPreference](https://github.com/SuperMonster003/AutoJs6/blob/10960ddbee71f75ef80907ad5b6ab42f3e1bf31e/app/src/main/java/org/autojs/autojs/ui/settings/ThemeColorPreference.kt#L21) 等類中存在的例項記憶體洩漏
* `修復` Android 14+ 申請截圖許可權導致應用崩潰的問題 (by [chenguangming](https://github.com/chenguangming)) _[`pr #242`](http://pr.autojs6.com/242)_
* `修復` Android 14+ 開啟前臺服務導致應用崩潰的問題
* `修復` Android 14+ 程式碼編輯器執行按鈕點選後無法正常亮起的問題
* `修復` 專案打包後應用可能因缺少必要庫檔案無法正常執行的問題 _[`issue #202`](http://issues.autojs6.com/202)_ _[`issue #223`](http://issues.autojs6.com/223)_ _[`pr #264`](http://pr.autojs6.com/264)_
* `修復` 編輯專案時可能因指定圖示資源不存在而導致應用崩潰的問題 _[`issue #203`](http://issues.autojs6.com/203)_
* `修復` 截圖許可權申請時無法正常使用引數獲取指定螢幕方向的截圖資源
* `修復` 部分裝置無法正常新增指令碼快捷方式的問題 (試修) _[`issue #221`](http://issues.autojs6.com/221)_
* `修復` 呼叫 http 模組與傳送請求相關的方法將出現累積性請求傳送延遲的問題 _[`issue #192`](http://issues.autojs6.com/192)_
* `修復` Shizuku 服務在 AutoJs6 進入主活動頁面之前可能無法正常使用的問題 (試修) _[`issue #255`](http://issues.autojs6.com/255)_
* `修復` random(min, max) 方法可能出現結果越界的問題
* `修復` pickup 方法結果型別引數無法正常傳入空陣列的問題
* `修復` UiObject#bounds() 得到的控制元件矩形可能被意外修改而破壞其不變性的問題
* `修復` text/button/input 元素的文字內容包含半形雙引號時無法正常解析的問題
* `修復` text/textswitcher 元素的 autoLink 屬性功能失效的問題
* `修復` 不同指令碼可能錯誤地共享同一個 ScriptRuntime 物件的問題
* `修復` 全域性變數 HEIGHT 及 WIDTH 丟失 Getter 動態屬性的問題
* `修復` 指令碼啟動時 RootShell 隨即載入可能導致啟動高延遲的問題
* `修復` 控制檯浮動視窗設定背景顏色導致矩形圓角樣式丟失的問題
* `修復` 無障礙服務自動啟動可能出現的服務異常問題 (試修)
* `修復` 主頁文件頁面左右滑動 WebView 控制元件時可能觸發 ViewPager 切換的問題
* `修復` 檔案管理器無法識別包含大寫字母副檔名的問題
* `修復` 檔案管理器首次進入專案目錄時可能無法自動識別專案的問題
* `修復` 檔案管理器刪除資料夾後頁面無法自動重新整理的問題
* `修復` 檔案管理器排序檔案及資料夾時可能出現 ASCII 首字母名稱置後的問題
* `修復` 程式碼編輯器除錯功能的 FAILED ASSERTION 異常
* `修復` 程式碼編輯器除錯過程中關閉編輯器後無法再次正常除錯的問題
* `修復` 程式碼編輯器跳轉到行尾時可能遺漏末尾字元的問題
* `修復` 主活動頁面啟動日誌活動頁面時可能出現閃屏的問題
* `修復` 打包應用無法正常使用 opencc 模組的問題
* `最佳化` 打包頁面中 "不可用 ABI" 控制元件的點選提示體驗
* `最佳化` 支援使用 Shizuku 控制 "指標位置" 顯示開關
* `最佳化` 支援使用 Shizuku 控制 "投影媒體" 及 "修改安全設定" 許可權開關
* `最佳化` automator.gestureAsync/gesturesAsync 支援回撥函式引數
* `最佳化` tasks 模組使用同步方式進行資料庫操作避免可能的資料訪問不一致問題
* `最佳化` 指令碼執行模式支援管道符號分隔模式引數 (如 `"ui|auto";` 開頭)
* `最佳化` 指令碼執行模式支援單引號及反引號且支援省略分號 (如 `'ui';` 或 `'ui'` 開頭)
* `最佳化` 指令碼執行模式支援 axios, cheerio, dayjs 等模式引數快捷匯入內建擴充套件模組 (如 `"axios";` 開頭)
* `最佳化` 指令碼執行模式支援 x 或 jsox 模式引數快捷啟用 JavaScript 內建物件擴充套件模組 (如 `"x";` 開頭)
* `最佳化` img 元素 src 及 path 屬性支援本地相對路徑 (如 `<img src="a.png"` />)
* `最佳化` 程式碼編輯器匯入 Java 類和包名時支援智慧判斷插入位置
* `最佳化` images 模組支援直接使用路徑作為影象引數
* `最佳化` importPackage 支援字串引數
* `最佳化` 服務端模式 IP 地址支援剪下板匯入智慧識別且支援空格按鍵智慧轉換
* `最佳化` 檔案管理器新建檔案時支援預設字首選擇並自動生成合適的數字字尾
* `最佳化` 檔案管理器執行專案時具體化異常訊息提示 _[`issue #268`](http://issues.autojs6.com/268)_
* `最佳化` 檔案管理器支援更多型別並支援顯示對應的圖示符號 (支援 800 多種檔案型別)
* `最佳化` 檔案管理器可編輯的檔案型別 (jpg/doc/pdf...) 增加編輯按鈕
* `最佳化` 檔案管理器 APK 檔案支援檢視基礎資訊, Manifest 資訊及許可權列表
* `最佳化` 檔案管理器音影片等媒體檔案支援檢視基礎資訊及 MediaInfo 資訊
* `最佳化` 打包單檔案時支援自動填入合適的標準化名包並支援無效字元過濾提示
* `最佳化` 打包單檔案時支援根據已安裝同包名應用自動設定圖示並自增版本號及版本名稱
* `最佳化` 打包專案配置檔案支援 abis/libs 選項指定預設包含的 ABI 架構及擴充套件庫
* `最佳化` 打包專案配置檔案 abis/libs 選項無效或無可用時支援相關訊息提示
* `最佳化` LeakCanary 在正式發行版本中被排除以避免增加不必要性
* `最佳化` 專案原始碼所有英文註釋增加簡體中文翻譯以增強註釋可讀性
* `最佳化` README 及 CHANGELOG 支援多語言 (由指令碼自動生成)
* `最佳化` Gradle 構建指令碼提升版本自適應能力
* `最佳化` 部分依賴或本地庫版本調整 _[`CHANGELOG.md`](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG.md#v660)_

# v6.5.0

###### 2023/12/02

* `新增` opencc 模組 (參閱 專案文件 > [中文轉換](https://docs.autojs6.com/#/opencc)) (Ref to [LZX284](https://github.com/SuperMonster003/AutoJs6/pull/187/files#diff-8cff73265af19c059547b76aca8882cbaa3209291406f52df1dafbbc78e80c46R268))
* `新增` UiSelector 增加 [plus](https://docs.autojs6.com/#/uiObjectType?id=m-plus) 及 [append](https://docs.autojs6.com/#/uiObjectType?id=m-append) 方法 _[`issue #115`](http://issues.autojs6.com/115)_
* `新增` 打包應用頁面增加 ABI 及庫的篩選支援 (Ref to [AutoX](https://github.com/kkevsekk1/AutoX)) _[`issue #189`](http://issues.autojs6.com/189)_
* `修復` 打包應用檔案體積異常龐大的問題 (Ref to [AutoX](https://github.com/kkevsekk1/AutoX) / [LZX284](https://github.com/SuperMonster003/AutoJs6/pull/187/files#diff-d932ac49867d4610f8eeb21b59306e8e923d016cbca192b254caebd829198856R61)) _[`issue #176`](http://issues.autojs6.com/176)_
* `修復` 打包應用無法顯示並列印部分異常訊息的問題
* `修復` 打包應用頁面選擇應用圖示後可能顯示空圖示的問題
* `修復` 打包應用包含 MLKit Google OCR 庫時可能出現的上下文未初始化異常
* `修復` ocr.<u>mlkit/ocr</u>.<u>recognizeText/detect</u> 方法無效的問題
* `修復` 部分文字 (如日誌頁面) 顯示語言與應用設定語言可能不相符的問題
* `修復` 部分語言在主頁抽屜開關項可能出現文字溢位的問題
* `修復` 部分裝置無障礙服務開啟後立即自動關閉且無任何提示訊息的問題 _[`issue #181`](http://issues.autojs6.com/181)_
* `修復` 部分裝置無障礙服務開啟後設備物理按鍵可能導致應用崩潰的問題 (試修) _[`issue #183`](http://issues.autojs6.com/183)_ _[`issue #186`](http://issues.autojs6.com/186#issuecomment-1817307790)_
* `修復` 使用 auto(true) 重啟無障礙服務後 pickup 功能異常的問題 (試修) _[`issue #184`](http://issues.autojs6.com/184)_
* `修復` floaty 模組建立浮動視窗拖動時可能導致應用崩潰的問題 (試修)
* `修復` app.startActivity 無法使用簡稱引數的問題 _[`issue #182`](http://issues.autojs6.com/182)_ _[`issue #188`](http://issues.autojs6.com/188)_
* `修復` importClass 匯入的類名與全域性變數衝突時程式碼丟擲異常的問題 _[`issue #185`](http://issues.autojs6.com/185)_
* `修復` Android 7.x 無法使用無障礙服務的問題
* `修復` Android 14 可能無法正常使用 runtime.<u>loadJar/loadDex</u> 方法的問題 (試修)
* `修復` 安卓系統快速設定面板中 "佈局範圍分析" 和 "佈局層次分析" 不可用的問題 _[`issue #193`](http://issues.autojs6.com/193)_
* `修復` 自動檢查更新功能可能導致應用 [ANR](https://developer.android.com/topic/performance/vitals/anr) 的問題 (試修) _[`issue #186`](http://issues.autojs6.com/186)_
* `修復` 檔案管理器示例程式碼資料夾點選 "向上" 按鈕後無法回到工作路徑頁面的問題 _[`issue #129`](http://issues.autojs6.com/129)_
* `修復` 程式碼編輯器使用替換功能時替換按鈕無法顯示的問題
* `修復` 程式碼編輯器長按刪除時可能導致應用崩潰的問題 (試修)
* `修復` 程式碼編輯器點選 fx 按鈕無法顯示模組函式快捷面板的問題
* `修復` 程式碼編輯器模組函式快捷面板按鈕函式名稱可能溢位的問題
* `最佳化` 程式碼編輯器模組函式快捷面板適配夜間模式
* `最佳化` 打包應用啟動頁面適配夜間模式並調整應用圖示佈局
* `最佳化` 打包應用頁面支援使用軟鍵盤 ENTER 鍵實現游標跳轉
* `最佳化` 打包應用頁面支援點選 ABI 標題及庫標題切換全選狀態
* `最佳化` 打包應用頁面預設 ABI 智慧選擇並增加不可選擇項的引導提示
* `最佳化` 檔案管理器根據檔案及資料夾的型別及特徵調整選單項的顯示情況
* `最佳化` 檔案管理器資料夾右鍵選單增加打包應用選項
* `最佳化` 無障礙服務啟用但功能異常時在 AutoJs6 主頁抽屜開關處將體現異常狀態
* `最佳化` 控制檯列印錯誤訊息時附加詳細的堆疊資訊
* `最佳化` 部分依賴或本地庫版本調整 _[`CHANGELOG.md`](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG.md#v650)_

##### 更多版本歷史可參閱

* [CHANGELOG.md](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG-zh-Hant-TW.md)

******

### <a id="project-compilation-and-build"></a>專案編譯構建

******

如需對 AutoJs6 開源專案進行除錯或開發, 可使用 [Android Studio](https://pro.autojs.org/) ([Google](https://www.google.com/) 公司產品) 或 [IntelliJ IDEA](https://www.jetbrains.com/idea/) ([Jetbrains](https://www.jetbrains.com/) 公司產品).

本小節以 Android Studio 為例介紹 AutoJs6 開源專案的編譯構建方法, IntelliJ IDEA 與之類似.

#### Android Studio 準備

下載 `Android Studio Ladybug Feature Drop | 2024.2.2 RC 2` 版本 (按需選擇其一):

- [android-studio-2024.2.2.12-windows.exe](https://redirector.gvt1.com/edgedl/android/studio/install/2024.2.2.12/android-studio-2024.2.2.12-windows.exe) (1.14 GB)
- [android-studio-2024.2.2.12-windows.zip](https://redirector.gvt1.com/edgedl/android/studio/ide-zips/2024.2.2.12/android-studio-2024.2.2.12-windows.zip) (1.15 GB)

> 注: 上述版本釋出時間為 2024 年 12 月 16 日. 如需下載其他版本, 或上述連結已失效, 可訪問 [Android Studio 發行版本歸檔](https://developer.android.com/studio/archive?hl=en) 頁面.

安裝或解壓上述檔案, 執行 Android Studio 軟體 (如 `"D:\android-studio\bin\studio64.exe"`).

#### Android SDK 準備

> 注: 如果計算機系統已安裝 Android SDK (安卓軟體開發工具包), 則可跳過此小節內容.

在 Android Studio 軟體中使用快捷鍵 `CTRL + ALT + S` 開啟設定頁面:

```text
Appearance & Behavior (外觀與表現) -> 
System Settings (系統設定) -> 
Android SDK (安卓軟體開發工具包)
```

`Android SDK Location (安卓軟體開發工具包位置)` 處如果是空白內容, 可點選右側 `Edit (編輯)` 按鈕, 在彈出的視窗中多次點選 `Next (下一步)`.

> 注: 過程中可能需要同意一個或多個相關協議才能繼續.

待相關資源下載並安裝完畢, 點選 `Finish (完成)` 按鈕.  
上述 `Android SDK Location (安卓軟體開發工具包位置)` 處將自動完成路徑填寫, SDK 準備工作隨即完成.

#### Android SDK Tools 準備

AutoJs6 需要使用部分 SDK 工具 (如 NDK 及 CMake).

> 注: 如果計算機系統已安裝 AutoJs6 全部所需的 Android SDK Tools, 則可跳過此小節內容.

在 Android Studio 軟體中使用快捷鍵 `CTRL + ALT + S` 開啟設定頁面:

```text
Appearance & Behavior (外觀與表現) -> 
System Settings (系統設定) -> 
Android SDK (安卓軟體開發工具包) -> 
SDK Tools (SDK 工具) (位於右側視窗)
```

勾選 `Show Package Details (顯示包詳情)`, 依次點選 NDK 及 CMake, 確保相應版本的工具已勾選, SDK 工具的版本資訊位於 AutoJs6 專案根目錄的 `version.properties` 檔案中.

#### JDK 準備

AutoJs6 專案依賴的 `JDK (Java 開發工具包)` 發行版本不低於 `17`, 但建議不低於 `19`.

截至 2025 年 1 月 1 日, AutoJs6 可支援 JDK 最高版本為 `23`.

> 注: 如果計算機系統已安裝 JDK 且版本滿足上述要求, 則可跳過此小節內容.

JDK 可使用 IDE 直接下載, 或訪問 [Oracle 網站](https://www.oracle.com/java/technologies/downloads/) 下載.

在 Android Studio 軟體中使用快捷鍵 `CTRL + ALT + S` 開啟設定頁面:

```text
Build, Execution, Deployment (構建, 執行, 開發) -> 
Build Tools (構建工具) -> 
Gradle
```

`Gradle JDK` 處可選擇或新增不同版本的 JDK.

如果列表中已存在合適版本的 JDK (>= `17`), 則直接選擇即可.  
否則可以選擇 `Download JDK (下載 JDK)` 下載合適的 JDK, 點選 `Download (下載)` 按鈕並等待下載完成.  
也可以選擇 `Add JDK (新增 JDK)` 新增已存在的本地 JDK, 定位其目錄並完成 JDK 新增.

#### AutoJs6 資源克隆

在 Android Studio 主頁面點選 `Get from VCS (從版本控制系統獲取)` 按鈕.  
`URL (統一資源定位地址)` 處填入 `https://github.com/SuperMonster003/AutoJs6.git`,  
`Directory (目錄)` 處可根據需要修改為特定路徑.  
點選 `Clone (克隆)` 按鈕, 等待 AutoJs6 專案資源在裝置本地完成克隆.

> 注: 上述過程可能需要安裝 [Git (分散式版本控制系統)](https://git-scm.com/download).

#### AutoJs6 專案構建

克隆完成後, Android Studio 將開啟 AutoJs6 的專案視窗, 並自動完成初步的 `Dependencies (依賴)` 下載及 Gradle 構建工作.

> 注: 上述過程可能非常耗時. 若網路條件欠佳, 可能需要重試多次 (點選 Retry 按鈕).

構建完成後, Android Studio 的 `Build` 標籤頁將出現類似 `BUILD SUCCESSFUL in 1h 17m 34s` 的訊息.

打包專案並生成可安裝到安卓裝置的 APK 檔案:

- 除錯版 (Debug Version)
    - `Build (構建)` -> `Build Bundle(s) / APK(s)` -> `Build APK(s)`
    - 生成帶預設簽名的除錯版安裝包
    - 路徑示例: `"D:\AutoJs6\app\build\outputs\apk\debug\"`
- 釋出版 (Release Version)
    - `Build (構建)` -> `Generate Signed Bundle / APK`
    - 選擇 `APK` 選項
    - 準備好簽名檔案 (新建或選取), 生成已簽名的釋出版安裝包
    - 路徑示例: `"D:\AutoJs6\app\release\"`

> 參閱: [Android Docs](https://developer.android.com/studio/run?hl=zh-cn)

******

### <a id="script-development-assistance"></a>指令碼開發輔助

******

開發 AutoJs6 可執行的指令碼, 需使用合適的開發工具:

- [VSCode](https://code.visualstudio.com/download) / [WebStorm](https://www.jetbrains.com/webstorm/download/) / [HBuilderX](https://www.dcloud.io/hbuilderx.html) ...

如需在 PC 上進行指令碼編寫與除錯, VSCode 外掛可以實現 PC 與手機的互聯:

- [AutoJs6-VSCode-Extension](http://vscext-project.autojs6.com) - AutoJs6 偵錯程式 (VSCode 平臺外掛)

使用開發工具編寫程式碼時, 程式碼智慧補全功能可以更好地輔助開發者完成程式碼編寫:

- [AutoJs6-TypeScript-Declarations](http://dts-project.autojs6.com) - AutoJs6 宣告檔案 (程式碼智慧補全)

編寫程式碼時, AutoJs6 相關 API 及使用方式, 可隨時查閱應用文件:

- [AutoJs6-Documentation](http://docs-project.autojs6.com) - AutoJs6 應用文件

現有的指令碼開發專案可作為參考, 激發個人指令碼專案的創作靈感:

- [Ant-Forest](https://github.com/TonyJiangWJ/Ant-Forest) - 螞蟻森林能量自動收取指令碼 by [TonyJiangWJ](https://github.com/TonyJiangWJ)
- [Ant-Forest](https://github.com/SuperMonster003/Ant-Forest) - 螞蟻森林能量自動收取指令碼 by [SuperMonster003](https://github.com/SuperMonster003)
- [autojs](https://github.com/e1399579/autojs) - Auto.js 實用指令碼 by  [e1399579](https://github.com/e1399579)
- [autojsDemo](https://github.com/snailuncle/autojsDemo) - Auto.js 演示示例 by  [snailuncle](https://github.com/snailuncle)
- [autojs 相關倉庫](https://github.com/topics/autojs) - GitHub 與 autojs 話題相關的全部倉庫

******

### 貢獻參與

******

感謝每一位參與 AutoJs6 專案開發的貢獻人員.

|     <span style="word-break:keep-all;white-space:nowrap">貢獻人員</span>     |                   <span style="word-break:keep-all;white-space:nowrap">提交數</span>                    | <span style="word-break:keep-all;white-space:nowrap">最近提交</span> |
|:----------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------:|
|     <span style="word-break:keep-all;white-space:nowrap">[luckyloogn](https://github.com/luckyloogn)</span>      |       <span style="word-break:keep-all;white-space:nowrap">[3](https://github.com/SuperMonster003/AutoJs6/commits?author=luckyloogn)</span>        |                    <span style="word-break:keep-all;white-space:nowrap">`2025/01/01`</span>                    |
|           <span style="word-break:keep-all;white-space:nowrap">[kvii](https://github.com/kvii)</span>            |          <span style="word-break:keep-all;white-space:nowrap">[1](https://github.com/SuperMonster003/AutoJs6/commits?author=kvii)</span>           |                    <span style="word-break:keep-all;white-space:nowrap">`2024/10/16`</span>                    |
|  <span style="word-break:keep-all;white-space:nowrap">[chenguangming](https://github.com/chenguangming)</span>   | <span style="word-break:keep-all;white-space:nowrap">[2](https://github.com/SuperMonster003/AutoJs6/pulls?q=is%3Apr+author%3Achenguangming)</span> |                    <span style="word-break:keep-all;white-space:nowrap">`2024/05/14`</span>                    |
|         <span style="word-break:keep-all;white-space:nowrap">[LZX284](https://github.com/LZX284)</span>          |         <span style="word-break:keep-all;white-space:nowrap">[17](https://github.com/SuperMonster003/AutoJs6/commits?author=LZX284)</span>         |                    <span style="word-break:keep-all;white-space:nowrap">`2023/11/19`</span>                    |
|    <span style="word-break:keep-all;white-space:nowrap">[TonyJiangWJ](https://github.com/TonyJiangWJ)</span>     |       <span style="word-break:keep-all;white-space:nowrap">[4](https://github.com/SuperMonster003/AutoJs6/commits?author=TonyJiangWJ)</span>       |                    <span style="word-break:keep-all;white-space:nowrap">`2023/10/31`</span>                    |
| <span style="word-break:keep-all;white-space:nowrap">[little&#x2011;alei](https://github.com/little-alei)</span> |      <span style="word-break:keep-all;white-space:nowrap">[12](https://github.com/SuperMonster003/AutoJs6/commits?author=little-alei)</span>       |                    <span style="word-break:keep-all;white-space:nowrap">`2023/07/12`</span>                    |
|         <span style="word-break:keep-all;white-space:nowrap">[aiselp](https://github.com/aiselp)</span>          |    <span style="word-break:keep-all;white-space:nowrap">[6](https://github.com/SuperMonster003/AutoJs6/pulls?q=is%3Apr+author%3Aaiselp)</span>     |                    <span style="word-break:keep-all;white-space:nowrap">`2023/06/14`</span>                    |
|          <span style="word-break:keep-all;white-space:nowrap">[LYS86](https://github.com/LYS86)</span>           |          <span style="word-break:keep-all;white-space:nowrap">[2](https://github.com/SuperMonster003/AutoJs6/commits?author=LYS86)</span>          |                    <span style="word-break:keep-all;white-space:nowrap">`2023/06/03`</span>                    |

資料更新於 2025 年 1 月 1 日.

資料條目按 `最近提交` 降序排序.

新發起的暫未處理的 Pull Request, 將在合併處理後加入資料統計.

部分貢獻人員在 [GitHub Contributors](https://github.com/SuperMonster003/AutoJs6/graphs/contributors) 未能正常出現, 其提交記錄為空, 仍可透過 [Pull Request](https://github.com/SuperMonster003/AutoJs6/pulls) 檢視貢獻記錄.

[//]: # (
    # --------------------------------------------------------------#
    # Before committing and pushing to the remote GitHub repository #
    # --------------------------------------------------------------#
    - CHANGELOG.md
        - Update entries for AutoJs6 by checking all changed files
        - Update entries for Gradle plugins [ implementation ]
        - Update version name and released date
        - Append related GitHub issues to changelog entries
    - README.md
        - The summary of the latest changelog for committing to Git [ DO NOT commit or push ]
        - Update badges like [ android studio / rhino / ... ]
        - Update android studio download links and version names
        - Update contribution section
    - Remove the part like [ alpha / beta / ... ] of VERSION_NAME in version.properties
    - Update dependencies TypeScript declarations if needed.
    - Re-generate documentation/markdown by running the python script
    - Check the two-way versions for AutoJs6 and VSCode ext, then publish the ext to Microsoft
    - Run Gradle task "app:assembleInrtRelease"
    - Build APK to determine the final VERSION_BUILD field
    - Run Gradle task "app:appendDigestToReleasedFiles"
    - Commit and push to GitHub
    - Publish the latest release with signed APKs
)