<!--suppress HtmlDeprecatedAttribute, HttpUrlsUsage -->

<div align="center">
  <p>
    <img src="https://s1.imagehub.cc/images/2023/03/07/af8ed087c9d354b9ab6142aae7bbafb6.png" alt="autojs6-banner_800×224" border="0" width="704" />
  </p>

  <p>{{ text_autojs6_synopsis }}</p>

  <p>
    <a href="http://download.autojs6.com"><img alt="GitHub release (latest by date)" src="https://img.shields.io/github/v/release/SuperMonster003/AutoJs6"/></a>
    <a href="http://issues.autojs6.com"><img alt="GitHub closed issues" src="https://img.shields.io/github/issues/SuperMonster003/AutoJs6?color=A24232"/></a>
    <a href="http://commit.autojs6.com/99a1d8490fac5b6d55f6f183db59ad833a2064ed"><img alt="Created" src="https://img.shields.io/date/1636632233?color=2e7d32&label=created"/></a>
    <br>
    <a href="https://github.com/mozilla/rhino"><img alt="Rhino" src="https://img.shields.io/badge/rhino-1.8.1--SNAPSHOT-795548"/></a>
    <a href="https://developer.android.com/studio/archive"><img alt="Android Studio" src="https://img.shields.io/badge/android%20studio-2022.1+-B64FC8"/></a>
    <br>
    <a href="https://www.codefactor.io/repository/github/SuperMonster003/AutoJs6"><img alt="CodeFactor Grade" src="https://www.codefactor.io/repository/github/SuperMonster003/AutoJs6/badge"/></a>
    <a href="https://www.jetbrains.com/?from=AutoJs6"><img alt="JetBrains supporter" src="https://img.shields.io/badge/supporter-JetBrains-ee4677"/></a>
    <a href="http://project.autojs6.com/blob/master/LICENSE"><img alt="GitHub License" src="https://img.shields.io/github/license/SuperMonster003/AutoJs6?color=534BAE"/></a>
  </p>
</div>

******

### {{ h3_languages_with_ascii }}

******

{{ p_languages_all_supported_for_readme }}:

{{ placeholder_ul_languages_all_supported }}

******

### {{ h3_introduction }}

******

{{ p_introduction_autojs_definition }}.

{{ p_introduction_autojs_released_information }}.

{{ p_introduction_autojs6_is_based_on_autojs }}.

{{ p_introduction_related_autojs_table_announce }}:

| <span style="word-break:keep-all;white-space:nowrap">{{ table_header_introduction_related_autojs_project }}</span> |                                                             <span style="word-break:keep-all;white-space:nowrap">{{ table_header_introduction_related_autojs_app_name }}</span>                                                              | <span style="word-break:keep-all;white-space:nowrap">{{ table_header_introduction_related_autojs_developer }}</span> | <span style="word-break:keep-all;white-space:nowrap">{{ table_header_introduction_related_autojs_development_start_date }}</span> | <span style="word-break:keep-all;white-space:nowrap">{{ table_header_introduction_related_autojs_development_end_date }}</span> |
|:------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------:|:---------------------------------------------------------------------------------------------------------------------------------:|:-------------------------------------------------------------------------------------------------------------------------------:|
|     <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/hyb1996/Auto.js)</span>      |    <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/TonyJiangWJ/Auto.js/commit/268ec8895bbfa28fc7715154eb15b1c1eaaefd14#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span>     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2017/01/27`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2020/03/13`</span>                             |
|                     <span style="word-break:keep-all;white-space:nowrap">Auto.js Pro 7</span>                      |                                                                                     <span style="word-break:keep-all;white-space:nowrap">Auto.js</span>                                                                                      |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2019/03/13`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2019/07/08`</span>                             |
|                     <span style="word-break:keep-all;white-space:nowrap">Auto.js Pro 8</span>                      |                                                                                    <span style="word-break:keep-all;white-space:nowrap">AutoJsPro</span>                                                                                     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2019/10/13`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2021/07/24`</span>                             |
|   <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/TonyJiangWJ/Auto.js)</span>    | <span style="word-break:keep-all;white-space:nowrap">[Auto.js&#160;M](https://github.com/TonyJiangWJ/Auto.js/commit/268ec8895bbfa28fc7715154eb15b1c1eaaefd14#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span> |      <span style="word-break:keep-all;white-space:nowrap">[TonyJiangWJ](https://github.com/TonyJiangWJ)</span>       |                             <span style="word-break:keep-all;white-space:nowrap">`2019/11/21`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|      <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/kkevsekk1/AutoX)</span>       |                 <span style="white-space:pre">[Autox.js](https://github.com/kkevsekk1/AutoX/commit/8143e4ed893d4af05d22aa791b83a962f9959873#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span>                  |        <span style="word-break:keep-all;white-space:nowrap">[kkevsekk1](https://github.com/kkevsekk1)</span>         |                             <span style="word-break:keep-all;white-space:nowrap">`2020/07/24`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|        <span style="word-break:keep-all;white-space:nowrap">[Auto.js Pro 9](https://pro.autojs.org/)</span>        |                                                                                    <span style="word-break:keep-all;white-space:nowrap">AutoJsPro</span>                                                                                     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2021/03/28`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2023/02/09`</span>                             |
| <span style="word-break:keep-all;white-space:nowrap">[AutoJs6](https://github.com/SuperMonster003/AutoJs6)</span>  |  <span style="word-break:keep-all;white-space:nowrap">[AutoJs6](https://github.com/SuperMonster003/AutoJs6/commit/a8ce1b9acb541e9736c33134be3194c3148a15a3#diff-833a46a97033e77558372a2dce103fd6fee29aaaa899f610022a7aece592ee7bR27)</span>  |  <span style="word-break:keep-all;white-space:nowrap">[SuperMonster003](https://github.com/SuperMonster003)</span>   |                             <span style="word-break:keep-all;white-space:nowrap">`2021/12/01`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|      <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/kkevsekk1/AutoX)</span>       |            <span style="white-space:pre">[Autox.js&#160;v6](https://github.com/kkevsekk1/AutoX/commit/8b6776cff8b0fca4be4a52719b7d7d07c0a058f3#diff-51a0b488f963eb0be6c6599bf5df497313877cf5bdff3950807373912ac1cdc9R130)</span>             |           <span style="word-break:keep-all;white-space:nowrap">[wilinz](https://github.com/wilinz)</span>            |                             <span style="word-break:keep-all;white-space:nowrap">`2022/05/26`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|        <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/aiselp/AutoX)</span>        |              <span style="white-space:pre">[Autox.js&#160;v7](https://github.com/aiselp/AutoX/commit/484491fd5fe12b8203d0b09c181eb0f471c0ea9f#diff-8cff73265af19c059547b76aca8882cbaa3209291406f52df1dafbbc78e80c46R120)</span>              |           <span style="word-break:keep-all;white-space:nowrap">[aiselp](https://github.com/aiselp)</span>            |                             <span style="word-break:keep-all;white-space:nowrap">`2024/04/21`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |

{{ p_introduction_related_autojs_table_date_is_estimated }}.

{{ p_introduction_related_autojs_table_app_is_free_or_not }}.

******

### {{ h3_functions }}

******

* {{ li_function_ide_features }}
* {{ li_function_accessibility_service_support }}
* {{ li_function_floating_button_quick_actions }}
* {{ li_function_selector_api_support }}
* {{ li_function_layout_analysis_support }}
* {{ li_function_recording_and_playback_support }}
* {{ li_function_screenshot_and_image_matching_support }}
* {{ li_function_e4x_support }}
* {{ li_function_packaging_to_apk_support }}
* {{ li_function_root_features_support }}
* {{ li_function_tasker_plugin_support }}
* {{ li_function_vscode_integration_support }}

******

### {{ h3_environment }}

******

- {{ li_environment_android_os }}
- {{ li_environment_api_requirement }}

******

### {{ h3_manual }}

******

* [{{ li_manual_documentation }}](https://docs.autojs6.com)
* [{{ li_manual_user_manual }}](https://docs.autojs6.com/#/manual)
* [{{ li_manual_troubleshooting }}](https://docs.autojs6.com/#/qa)
* [{{ h3_project_compilation_and_build }}](#project-compilation-and-build)
* [{{ h3_script_development_assistance }}](#script-development-assistance)

******

### {{ h3_major_changes }}

******

{{ p_major_changes_autojs6_version_updates }}:

* {{ li_major_changes_shizuku_adb_privileges_support }}
* {{ li_major_changes_websocket_support }}
* {{ li_major_changes_new_modules }}
* {{ li_major_changes_multilingual_support }}
* {{ li_major_changes_theme_color_support }}
* {{ li_major_changes_night_mode_support }}
* {{ li_major_changes_vscode_plugin_support }}
* {{ li_major_changes_rhino_engine_upgrade }}
    * {{ li_rhino_feature_unicode_code_point_escapes_support }}
       ```javascript
       '\u{1D160}'; /* {{ text_stands_for }} "𝅘𝅥𝅮", {{ text_traditional_method_lowercase }}: '\uD834\uDD60'. */
       ```
    * {{ li_rhino_feature_object_values_support }}
       ```javascript
       Object.values({name: 'Max', age: 4}); // ['max', 4]
       ```
    * {{ li_rhino_feature_array_includes_support }}
       ```javascript
       [10, 20, NaN].includes(20); // true
       ```
    * {{ li_rhino_feature_bigint_support }}
       ```javascript
       typeof 567n === 'bigint'; // true
       ```
    * {{ li_rhino_feature_template_strings_support }}
       ```javascript
       `Lucky number: ${(Math.random() * 100).toFixed(0)}`
       ```
    * {{ li_rhino_feature_rhino_engine_new_features }}
    * {{ li_rhino_feature_rhino_engine_compatibility_list }}

******

### {{ h3_version_histories }}

******

{{ placeholder_latest_three_version_histories }}

##### {{ h5_for_more_version_history }}

* {{ placeholder_read_more_in_changelog_md }}

******

### <a id="project-compilation-and-build"></a>{{ h3_project_compilation_and_build }}

******

{{ p_project_compilation_and_build_android_studio_intellij_idea }}.

{{ p_project_compilation_and_build_android_studio_build_methods }}.

#### {{ h4_android_studio_preparation }}

{{ p_android_studio_preparation_download_android_studio }}:

- [{{ android_studio_latest_recommended_file_name_of_exe }}]({{ android_studio_latest_recommended_download_address_of_exe }}) ({{ android_studio_latest_recommended_file_size_of_exe }})
- [{{ android_studio_latest_recommended_file_name_of_zip }}]({{ android_studio_latest_recommended_download_address_of_zip }}) ({{ android_studio_latest_recommended_file_size_of_zip }})

> {{ bq_annotation_android_studio_release_date_note }}.

{{ p_android_studio_preparation_install_android_studio }}.

#### {{ h4_android_sdk_preparation }}

> {{ bq_annotation_android_sdk_preparation_skip_if_sdk_installed }}.

{{ p_android_sdk_preparation_open_settings_android_studio }}:

```text
{{ step_help }} {{ symbol_pipe }} {{ step_find_action }} {{ symbol_hash }} {{ text_input }} "Android SDK"
[ {{ text_or }} ]
{{ step_file }} {{ symbol_pipe }} {{ step_settings }} {{ symbol_hash }} {{ text_search }} "Android SDK"
[ {{ text_or }} ]
{{ step_file }} {{ symbol_pipe }} {{ step_settings }} {{ symbol_pipe }} {{ step_languages_and_frameworks }} {{ symbol_pipe }} {{ step_android_sdk }}
[ {{ text_or }} ]
{{ step_file }} {{ symbol_pipe }} {{ step_settings }} {{ symbol_pipe }} {{ step_appearance_behavior }} {{ symbol_pipe }} {{ step_system_settings }} {{ symbol_pipe }} {{ step_android_sdk }}
```

{{ p_android_sdk_preparation_edit_sdk_location }}.

> {{ bq_annotation_android_sdk_preparation_accept_agreements }}.

{{ p_android_sdk_preparation_finish_sdk_installation }}.  
{{ p_android_sdk_preparation_auto_sdk_location_filled }}.

#### {{ h4_android_sdk_tools_preparation }}

{{ p_android_sdk_tools_preparation_sdk_tools_required }}.

> {{ bq_annotation_android_sdk_tools_preparation_skip_if_tools_installed }}.

{{ p_android_sdk_tools_preparation_sdk_tools }}:

```text
{{ step_help }} {{ symbol_pipe }} {{ step_find_action }} {{ symbol_hash }} {{ text_input }} "SDK Tools"
[ {{ text_or }} ]
{{ step_file }} {{ symbol_pipe }} {{ step_settings }} {{ symbol_hash }} {{ text_search }} "SDK Tools"
[ {{ text_or }} ]
{{ step_file }} {{ symbol_pipe }} {{ step_settings }} {{ symbol_pipe }} {{ step_languages_and_frameworks }} {{ symbol_pipe }} {{ step_android_sdk }} {{ symbol_pipe }} {{ step_sdk_tools_show_details }}
[ {{ text_or }} ]
{{ step_file }} {{ symbol_pipe }} {{ step_settings }} {{ symbol_pipe }} {{ step_appearance_behavior }} {{ symbol_pipe }} {{ step_system_settings }} {{ symbol_pipe }} {{ step_android_sdk }} {{ symbol_pipe }} {{ step_sdk_tools_show_details }} 
```

{{ p_android_sdk_tools_preparation_show_package_details }}.

#### {{ h4_jdk_preparation }}

{{ p_jdk_preparation_jdk_version_requirements }}.

{{ p_jdk_preparation_jdk_max_supported_version }}.

> {{ bq_annotation_jdk_preparation_skip_if_jdk_installed }}.

{{ p_jdk_preparation_download_jdk }}.

{{ p_jdk_preparation_open_jdk_settings }}:

```text
{{ step_help }} {{ symbol_pipe }} {{ step_find_action }} {{ symbol_hash }} {{ text_input }} "Gradle JDK"
[ {{ text_or }} ]
{{ step_file }} {{ symbol_pipe }} {{ step_settings }} {{ symbol_hash }} {{ text_search }} "Gradle"
[ {{ text_or }} ]
{{ step_file }} {{ symbol_pipe }} {{ step_settings }} {{ symbol_pipe }} {{ step_build_execution_deployment }} {{ symbol_pipe }} {{ step_build_tools }} {{ symbol_pipe }} Gradle
```

{{ p_jdk_preparation_select_gradle_jdk }}.

{{ p_jdk_preparation_select_existing_jdk }}.  
{{ p_jdk_preparation_download_new_jdk }}.  
{{ p_jdk_preparation_add_existing_jdk }}.

#### {{ h4_autojs6_resources_cloning }}

{{ p_autojs6_resources_cloning_clone_from_vcs }}.  
{{ p_autojs6_resources_cloning_fill_url }},  
{{ p_autojs6_resources_cloning_fill_directory }}.  
{{ p_autojs6_resources_cloning_click_clone_button }}.

> {{ bq_annotation_autojs6_resources_cloning_install_git_note }}.

#### {{ h4_autojs6_project_building }}

{{ p_autojs6_project_cloning_autobuild_dependencies }}.

> {{ bq_annotation_autojs6_project_cloning_retry_clone }}.

{{ p_autojs6_project_building_if_failed }}:

- {{ li_project_build_step_toolbar }}
- {{ li_project_build_step_click_build_project }}
- {{ li_project_build_step_wait_build_success }}

{{ p_autojs6_project_building_failed }}.

> {{ bq_annotation_autojs6_project_building_reference }}

#### {{ h4_autojs6_project_deploy_run }}

{{ p_autojs6_project_deploy_run_overview }}.

- {{ li_deploy_run_step_select_app }}
- {{ li_deploy_run_step_select_device }}
- {{ li_deploy_run_step_click_run }}
- {{ li_deploy_run_step_wait_install }}

#### {{ h4_autojs6_project_deploy_apk }}

{{ p_autojs6_project_deploy_apk_overview }}:

- {{ step_debug_version_path }}
    - {{ step_generate_debug_apk }} {{ symbol_pipe }} `Build Bundle(s) / APK(s)` {{ symbol_pipe }} `Build APK(s)`
    - {{ step_debug_apk_path }}
    - {{ step_example_debug_path }}
- {{ step_release_version_apk }}
    - {{ step_release_version_path }} {{ symbol_pipe }} `Generate Signed Bundle / APK`
    - {{ step_select_apk_option }}
    - {{ step_prepare_signing_file }}
    - {{ step_example_release_path }}

> {{ bq_annotation_autojs6_project_deploy_apk }}

#### {{ h4_autojs6_gradle_tasks }}

{{ p_autojs6_gradle_tasks_intro }}.

{{ p_autojs6_gradle_tasks_overview }}.

- AutoJs6 [inrt:assemble]

{{ p_gradle_task_inrt_summary }}.

{{ p_gradle_task_inrt_description }}.

{{ p_gradle_task_inrt_exception }}:

> java.io.FileNotFoundException: template.apk

{{ p_gradle_task_inrt_exception_explanation }}.

> {{ bq_annotation_gradle_task_inrt_rebuild_if_needed }}

- AutoJs6 [app:bundle]

{{ p_gradle_task_app_bundle_summary }}.

{{ p_gradle_task_app_bundle_description }}.

- AutoJs6 [app:digest]

{{ p_gradle_task_app_digest_summary }}.

{{ p_gradle_task_app_digest_filename_comparison }}:

```text
{{ label_before }}:
autojs6-v6.6.2-arm64-v8a.apk
{{ label_after }}:
autojs6-v6.6.2-arm64-v8a-0f2a9d74.apk
```

> {{ text_reference }}: [Android Docs](https://developer.android.com/studio/run?hl=zh-cn)

******

### <a id="script-development-assistance"></a>{{ h3_script_development_assistance }}

******

{{ li_development_assistance_develop_scripts_for_autojs6 }}:

- [VSCode](https://code.visualstudio.com/download) / [WebStorm](https://www.jetbrains.com/webstorm/download/) / [HBuilderX](https://www.dcloud.io/hbuilderx.html) ...

{{ li_development_assistance_vscode_plugin_pc_script_development }}:

- {{ li_development_assistance_project_autojs6_vscode_extension }}

{{ li_development_assistance_code_completion_assist_development }}:

- {{ li_development_assistance_project_autojs6_typescript_declarations }}

{{ li_development_assistance_autojs6_api_reference_docs }}:

- {{ li_development_assistance_project_autojs6_documentation }}

{{ li_development_assistance_existing_projects_inspiration }}:

- {{ li_development_assistance_projects_inspiration_ant_forest_tonyjiangwj }}
- {{ li_development_assistance_projects_inspiration_ant_forest_supermonster003 }}
- {{ li_development_assistance_projects_inspiration_autojs_util_scripts_e1399579 }}
- {{ li_development_assistance_projects_inspiration_autojs_demo_snailuncle }}
- {{ li_development_assistance_projects_inspiration_autojs_related_repos }}

******

### {{ h3_contribution }}

******

{{ p_contribution_table_thank_all_contributors }}.

|         <span style="word-break:keep-all;white-space:nowrap">{{ table_header_contribution_contributors }}</span>          |                   <span style="word-break:keep-all;white-space:nowrap">{{ table_header_contribution_number_of_commits }}</span>                    | <span style="word-break:keep-all;white-space:nowrap">{{ table_header_contribution_recent_submissions }}</span> |
|:-------------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------:|
|             <span style="word-break:keep-all;white-space:nowrap">[wirsnow](https://github.com/wirsnow)</span>             |         <span style="word-break:keep-all;white-space:nowrap">[1](https://github.com/SuperMonster003/AutoJs6/commits?author=wirsnow)</span>         |                    <span style="word-break:keep-all;white-space:nowrap">`2025/05/19`</span>                    |
|         <span style="word-break:keep-all;white-space:nowrap">[TonyJiangWJ](https://github.com/TonyJiangWJ)</span>         |       <span style="word-break:keep-all;white-space:nowrap">[5](https://github.com/SuperMonster003/AutoJs6/commits?author=TonyJiangWJ)</span>       |                    <span style="word-break:keep-all;white-space:nowrap">`2025/04/24`</span>                    |
|          <span style="word-break:keep-all;white-space:nowrap">[luckyloogn](https://github.com/luckyloogn)</span>          |       <span style="word-break:keep-all;white-space:nowrap">[3](https://github.com/SuperMonster003/AutoJs6/commits?author=luckyloogn)</span>        |                    <span style="word-break:keep-all;white-space:nowrap">`2025/01/01`</span>                    |
|                <span style="word-break:keep-all;white-space:nowrap">[kvii](https://github.com/kvii)</span>                |          <span style="word-break:keep-all;white-space:nowrap">[1](https://github.com/SuperMonster003/AutoJs6/commits?author=kvii)</span>           |                    <span style="word-break:keep-all;white-space:nowrap">`2024/10/16`</span>                    |
|   <span style="word-break:keep-all;white-space:nowrap">[chenguangming](https://github.com/chenguangming) `(Tom)`</span>   | <span style="word-break:keep-all;white-space:nowrap">[2](https://github.com/SuperMonster003/AutoJs6/pulls?q=is%3Apr+author%3Achenguangming)</span> |                    <span style="word-break:keep-all;white-space:nowrap">`2024/05/14`</span>                    |
|          <span style="word-break:keep-all;white-space:nowrap">[LZX284](https://github.com/LZX284) `(AI)`</span>           |         <span style="word-break:keep-all;white-space:nowrap">[17](https://github.com/SuperMonster003/AutoJs6/commits?author=LZX284)</span>         |                    <span style="word-break:keep-all;white-space:nowrap">`2023/11/19`</span>                    |
| <span style="word-break:keep-all;white-space:nowrap">[little&#x2011;alei](https://github.com/little-alei) `(抠脚本人)`</span> |      <span style="word-break:keep-all;white-space:nowrap">[12](https://github.com/SuperMonster003/AutoJs6/commits?author=little-alei)</span>       |                    <span style="word-break:keep-all;white-space:nowrap">`2023/07/12`</span>                    |
|              <span style="word-break:keep-all;white-space:nowrap">[aiselp](https://github.com/aiselp)</span>              |    <span style="word-break:keep-all;white-space:nowrap">[6](https://github.com/SuperMonster003/AutoJs6/pulls?q=is%3Apr+author%3Aaiselp)</span>     |                    <span style="word-break:keep-all;white-space:nowrap">`2023/06/14`</span>                    |
|           <span style="word-break:keep-all;white-space:nowrap">[LYS86](https://github.com/LYS86) `(Lin)`</span>           |          <span style="word-break:keep-all;white-space:nowrap">[2](https://github.com/SuperMonster003/AutoJs6/commits?author=LYS86)</span>          |                    <span style="word-break:keep-all;white-space:nowrap">`2023/06/03`</span>                    |

{{ p_contribution_table_data_updated_on }}.

{{ p_contribution_table_data_entries_sorted_by_recent_submissions }}.

{{ p_contribution_table_new_pull_requests_pending_processing }}.

{{ p_contribution_table_some_contributors_not_appearing }}.

[//]: # (
    # --------------------------------------------------------------#
    # Before committing and pushing to the remote GitHub repository #
    # --------------------------------------------------------------#
    - IDE
        - The summary of the latest changelog for committing to Git [ DO NOT commit or push ]
    - $projectDir/version.properties
        - Remove the part like [ alpha / beta / ... ] of VERSION_NAME
    - $projectDir/.changelog/lang_zh-Hans.json
        - Update version name and released date
        - Translate into other languages
        - Update TypeScript declarations according to section `dependency` if needed
    - $projectDir/.readme/template_readme.md
        - Update badges like [ android studio / rhino / ... ]
        - Update contribution section: {{ h3_contribution }}
    - $projectDir/.readme/common.json
        - Update android studio download links and version names
        - Update contribution section: var_date_contribution_table_data_updated
    - $projectDir/.python/generate_markdown.py
        - Re-generate markdown by running the python script [ link: aj6mdgen ]
    - Others
        - Re-generate documentation by running the python script [ link: aj6docgen ]
        - Check the two-way versions for AutoJs6 and VSCode ext, then publish the ext to Microsoft if needed
        - Run Gradle task "app:assembleInrtRelease" [ shortcut: C+A+0#- ]
        - Build APK to determine the final VERSION_BUILD field [ shortcut: C+A+0#A ]
        - Run Gradle task "app:appendDigestToReleasedFiles" [ shortcut: C+A+0#= ]
        - Check VERSION_BUILD in version.properties with released apks
        - Commit and push to GitHub
        - Publish the latest release with signed APKs
)
