<!--suppress HtmlDeprecatedAttribute, HttpUrlsUsage -->

<div align="center">
  <p>
    <img src="https://s1.imagehub.cc/images/2023/03/07/af8ed087c9d354b9ab6142aae7bbafb6.png" alt="autojs6-banner_800×224" border="0" width="704" />
  </p>

  <p>JavaScript automation tool supporting accessibility service on the Android platform</p>

  <p>
    <a href="http://download.autojs6.com"><img alt="GitHub release (latest by date)" src="https://img.shields.io/github/v/release/SuperMonster003/AutoJs6"/></a>
    <a href="http://issues.autojs6.com"><img alt="GitHub closed issues" src="https://img.shields.io/github/issues/SuperMonster003/AutoJs6?color=A24232"/></a>
    <a href="http://commit.autojs6.com/99a1d8490fac5b6d55f6f183db59ad833a2064ed"><img alt="Created" src="https://img.shields.io/date/1636632233?color=2e7d32&label=created"/></a>
    <br>
    <a href="https://github.com/mozilla/rhino"><img alt="Rhino" src="https://img.shields.io/badge/rhino-1.8.1--SNAPSHOT-795548"/></a>
    <a href="https://developer.android.com/studio/archive"><img alt="Android Studio" src="https://img.shields.io/badge/android%20studio-2022.1+-B64FC8"/></a>
    <br>
    <a href="https://www.codefactor.io/repository/github/SuperMonster003/AutoJs6"><img alt="CodeFactor Grade" src="https://www.codefactor.io/repository/github/SuperMonster003/AutoJs6/badge"/></a>
    <a href="https://www.jetbrains.com/?from=AutoJs6"><img alt="JetBrains supporter" src="https://img.shields.io/badge/supporter-JetBrains-ee4677"/></a>
    <a href="http://project.autojs6.com/blob/master/LICENSE"><img alt="GitHub License" src="https://img.shields.io/github/license/SuperMonster003/AutoJs6?color=534BAE"/></a>
  </p>
</div>

******

### Languages

******

The current README.md supports the following languages:

 - [简体中文 [zh-Hans]](http://project.autojs6.com/blob/master/.readme/README-zh-Hans.md)
 - [繁體中文 (香港) [zh-Hant-HK]](http://project.autojs6.com/blob/master/.readme/README-zh-Hant-HK.md)
 - [繁體中文 (台灣) [zh-Hant-TW]](http://project.autojs6.com/blob/master/.readme/README-zh-Hant-TW.md)
 - English [en] # current
 - [Français [fr]](http://project.autojs6.com/blob/master/.readme/README-fr.md)
 - [Español [es]](http://project.autojs6.com/blob/master/.readme/README-es.md)
 - [日本語 [ja]](http://project.autojs6.com/blob/master/.readme/README-ja.md)
 - [한국어 [ko]](http://project.autojs6.com/blob/master/.readme/README-ko.md)
 - [Русский [ru]](http://project.autojs6.com/blob/master/.readme/README-ru.md)
 - [العربية [ar]](http://project.autojs6.com/blob/master/.readme/README-ar.md)

******

### Introduction

******

[Auto.js](https://github.com/hyb1996/Auto.js) is a JavaScript automation tool software for the Android platform that supports [Accessibility Service](https://developer.android.com/guide/topics/ui/accessibility/service?hl=en).

Auto.js was first released by [hyb1996](https://github.com/hyb1996) on `2017/01/27` and ceased maintenance on `2020/03/13`, with the final version name being `4.1.1 Alpha2` and build number `461`.

AutoJs6 is based on the final project of Auto.js, undergoing secondary development on `2021/12/01` and continues to be open-source and free.

The table below lists some Auto.js-related projects (sorted by development date):

| <span style="word-break:keep-all;white-space:nowrap">Project</span> |                                                             <span style="word-break:keep-all;white-space:nowrap">App Name</span>                                                              | <span style="word-break:keep-all;white-space:nowrap">Developer</span> | <span style="word-break:keep-all;white-space:nowrap">Development Start Date</span> | <span style="word-break:keep-all;white-space:nowrap">Development End Date</span> |
|:------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------:|:---------------------------------------------------------------------------------------------------------------------------------:|:-------------------------------------------------------------------------------------------------------------------------------:|
|     <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/hyb1996/Auto.js)</span>      |    <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/TonyJiangWJ/Auto.js/commit/268ec8895bbfa28fc7715154eb15b1c1eaaefd14#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span>     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2017/01/27`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2020/03/13`</span>                             |
|                     <span style="word-break:keep-all;white-space:nowrap">Auto.js Pro 7</span>                      |                                                                                     <span style="word-break:keep-all;white-space:nowrap">Auto.js</span>                                                                                      |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2019/03/13`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2019/07/08`</span>                             |
|                     <span style="word-break:keep-all;white-space:nowrap">Auto.js Pro 8</span>                      |                                                                                    <span style="word-break:keep-all;white-space:nowrap">AutoJsPro</span>                                                                                     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2019/10/13`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2021/07/24`</span>                             |
|   <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/TonyJiangWJ/Auto.js)</span>    | <span style="word-break:keep-all;white-space:nowrap">[Auto.js&#160;M](https://github.com/TonyJiangWJ/Auto.js/commit/268ec8895bbfa28fc7715154eb15b1c1eaaefd14#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span> |      <span style="word-break:keep-all;white-space:nowrap">[TonyJiangWJ](https://github.com/TonyJiangWJ)</span>       |                             <span style="word-break:keep-all;white-space:nowrap">`2019/11/21`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|      <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/kkevsekk1/AutoX)</span>       |                 <span style="white-space:pre">[Autox.js](https://github.com/kkevsekk1/AutoX/commit/8143e4ed893d4af05d22aa791b83a962f9959873#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span>                  |        <span style="word-break:keep-all;white-space:nowrap">[kkevsekk1](https://github.com/kkevsekk1)</span>         |                             <span style="word-break:keep-all;white-space:nowrap">`2020/07/24`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|        <span style="word-break:keep-all;white-space:nowrap">[Auto.js Pro 9](https://pro.autojs.org/)</span>        |                                                                                    <span style="word-break:keep-all;white-space:nowrap">AutoJsPro</span>                                                                                     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2021/03/28`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2023/02/09`</span>                             |
| <span style="word-break:keep-all;white-space:nowrap">[AutoJs6](https://github.com/SuperMonster003/AutoJs6)</span>  |  <span style="word-break:keep-all;white-space:nowrap">[AutoJs6](https://github.com/SuperMonster003/AutoJs6/commit/a8ce1b9acb541e9736c33134be3194c3148a15a3#diff-833a46a97033e77558372a2dce103fd6fee29aaaa899f610022a7aece592ee7bR27)</span>  |  <span style="word-break:keep-all;white-space:nowrap">[SuperMonster003](https://github.com/SuperMonster003)</span>   |                             <span style="word-break:keep-all;white-space:nowrap">`2021/12/01`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|      <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/kkevsekk1/AutoX)</span>       |            <span style="white-space:pre">[Autox.js&#160;v6](https://github.com/kkevsekk1/AutoX/commit/8b6776cff8b0fca4be4a52719b7d7d07c0a058f3#diff-51a0b488f963eb0be6c6599bf5df497313877cf5bdff3950807373912ac1cdc9R130)</span>             |           <span style="word-break:keep-all;white-space:nowrap">[wilinz](https://github.com/wilinz)</span>            |                             <span style="word-break:keep-all;white-space:nowrap">`2022/05/26`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|        <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/aiselp/AutoX)</span>        |              <span style="white-space:pre">[Autox.js&#160;v7](https://github.com/aiselp/AutoX/commit/484491fd5fe12b8203d0b09c181eb0f471c0ea9f#diff-8cff73265af19c059547b76aca8882cbaa3209291406f52df1dafbbc78e80c46R120)</span>              |           <span style="word-break:keep-all;white-space:nowrap">[aiselp](https://github.com/aiselp)</span>            |                             <span style="word-break:keep-all;white-space:nowrap">`2024/04/21`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |

The dates in the table are estimated and may differ from actual dates.

Auto.js Pro 7/8/9 in the table are paid versions, and the rest are free open-source versions.

******

### Functions

******

* Can be used as a JavaScript IDE (code completion/variable renaming/code formatting)
* Supports automation based on [Accessibility Service](https://developer.android.com/reference/android/accessibilityservice/AccessibilityService)
* Supports floating button quick actions (script recording and running/view package name and activity/layout analysis)
* Supports Selector API and provides control traversal/information retrieval/control operations (similar to [UiAutomator](https://developer.android.com/training/testing/ui-automator))
* Supports layout interface analysis (similar to Android Studio's LayoutInspector)
* Supports recording functionality and playback of recorded actions
* Supports screen capture/save screenshots/color search in images/image matching
* Supports [E4X](https://en.wikipedia.org/wiki/E4X) (ECMAScript for XML) for interface writing
* Supports packaging script files or projects into APK files
* Supports expanded functionality using Root privileges (screen click/slide/record/Shell)
* Supports use as a Tasker plugin
* Supports connection with VSCode for desktop development (requires [AutoJs6-VSCode-Extension](http://vscext-project.autojs6.com) plugin)

******

### Environment

******

- Android Operating System
- [API](https://developer.android.com/guide/topics/manifest/uses-sdk-element#ApiLevels) [24](https://developer.android.com/reference/android/os/Build.VERSION_CODES#N) ([7.0](https://zh.wikipedia.org/wiki/Android_Nougat)) [[N](https://developer.android.com/reference/android/os/Build.VERSION_CODES#N)] and above

******

### Manual

******

* [Application Documentation](https://docs.autojs6.com)
* [User Manual (to be written)](https://docs.autojs6.com/#/manual)
* [Troubleshooting](https://docs.autojs6.com/#/qa)
* [Project Compilation and Build](#project-compilation-and-build)
* [Script Development Assistance](#script-development-assistance)

******

### Major Changes

******

Compared to the final open-source version `4.1.1 Alpha2` of Auto.js, the main upgrades or changes in AutoJs6 are:

* Supports obtaining ADB privileges through [Shizuku](https://shizuku.rikka.app/introduction/) and using system API
* Supports building [WebSocket](https://docs.autojs6.com/#/webSocketType) instances to perform network requests based on the [WebSocket protocol](https://en.wikipedia.org/wiki/WebSocket)
* New modules [ [base64](https://docs.autojs6.com/#/base64) / [crypto](https://docs.autojs6.com/#/crypto) / [sqlite](https://docs.autojs6.com/#/sqlite) / [i18n](https://docs.autojs6.com/#/i18n) / [notice](https://docs.autojs6.com/#/notice) / [ocr](https://docs.autojs6.com/#/ocr) / [opencc](https://docs.autojs6.com/#/opencc) / [qrcode](https://docs.autojs6.com/#/qrcode) / [shizuku](https://docs.autojs6.com/#/shizuku) / ... ]
* Multilingual support [ Spanish / French / Russian / Arabic / Japanese / Korean / English / Simplified Chinese / Traditional Chinese / ... ]
* Theme color adaptation [ Grouping / Location / Search / History / Automatic Adaptation of Brightness and Contrast / ... ]
* Night mode adaptation [ Settings page / Documentation page / Layout analysis page / Floating window / ... ]
* [VSCode plugin](http://vscext-project.autojs6.com) supports both client (LAN) and server (LAN/ADB) connection methods
* [Rhino](https://github.com/mozilla/rhino/) engine upgraded from [v1.7.7.2](https://github.com/mozilla/rhino/releases/tag/Rhino1_7_7_2_Release) to [v1.8.1-SNAPSHOT](http://rhino.autojs6.com/blob/master/gradle.properties#L3)
    * Unicode [code point](https://developer.mozilla.org/en-US/docs/Glossary/Code_point) escape support for [supplementary plane](https://en.wikipedia.org/wiki/Plane_(Unicode)#Supplementary_Multilingual_Plane) characters
       ```javascript
       '\u{1D160}'; /* stands for "𝅘𝅥𝅮", traditional method: '\uD834\uDD60'. */
       ```
    * Supports [Object.values()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/values)
       ```javascript
       Object.values({name: 'Max', age: 4}); // ['max', 4]
       ```
    * Supports [Array.prototype.includes()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/includes)
       ```javascript
       [10, 20, NaN].includes(20); // true
       ```
    * Supports [BigInt](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/BigInt)
       ```javascript
       typeof 567n === 'bigint'; // true
       ```
    * Supports [template strings](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Template_literals)
       ```javascript
       `Lucky number: ${(Math.random() * 100).toFixed(0)}`
       ```
    * View more new features of the Rhino engine [here](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/RHINO.md)
    * View Rhino engine [compatibility list](https://mozilla.github.io/rhino/compat/engines.html)

******

### Version Histories

******

# v6.6.4

###### 2025/05/31

* `Hint` API change: ui.(status/navigation)BarAppearanceLight[By] -> ui.(status/navigation)BarIconLight[By]
* `Feature` util.dpToPx/spToPx/pxToDp/pxToSp methods for pixel unit conversion
* `Fix` Subtitles may be displayed incompletely when rotating the screen to landscape orientation
* `Fix` Some page content may be obscured by the side navigation bar when rotating to landscape
* `Fix` Incomplete status bar background tint area on some pages in Android 15 _[`issue #398`](http://issues.autojs6.com/398)_
* `Fix` Code editor might write files with low-confidence encoding causing decoding errors (attempted fix)
* `Improvement` Improved layout adaptability on the App and Developer pages and removed unnecessary layout categories
* `Improvement` README.md build section added multiple methods to help locate the target settings page _[`issue #404`](http://issues.autojs6.com/404)_
* `Improvement` Some dependency or local library version adjustments _[`CHANGELOG.md`](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG.md#v664)_

# v6.6.3

###### 2025/05/27

* `Feature` Version history feature: view multi-language release changelogs and statistics
* `Feature` timers.keepAlive method (now global) for keeping the script alive
* `Feature` Event listeners such as engines.on('start/stop/error', callback) for global engine events
* `Feature` images.detectMultiColors method for multi-point color verification _[`issue #374`](http://issues.autojs6.com/374)_
* `Feature` images.matchFeatures / detectAndComputeFeatures methods: full-resolution image matching (Ref to [Auto.js Pro](https://g.pro.autojs.org/)) _[`issue #366`](http://issues.autojs6.com/366)_
* `Feature` images.compressToBytes method to compress an image and generate a byte array
* `Feature` images.downsample method for pixel down-sampling and creating a new ImageWrapper
* `Feature` ui.keepScreenOn method to keep the device screen on while a UI page is focused
* `Feature` ui.root property (getter) to obtain the "window content root container" node of the UI layout
* `Feature` webview element now supports JsBridge-based web page layouts (Ref to [Auto.js Pro](https://g.pro.autojs.org/)) [see Sample Code > Layout > Interactive HTML / Vue2 + Vant (SFC)] _[`issue #281`](http://issues.autojs6.com/281)_
* `Fix` Online docs in the Home > Docs tab and Docs activity may be covered by the system navigation bar
* `Fix` Clicking Toolbar buttons on some pages could accidentally trigger the title click event
* `Fix` Blank lines in the code editor showed box glyphs on some devices
* `Fix` Color-picker dialog in the theme-color settings page could stack infinitely
* `Fix` Volume-up key failed to stop all scripts when the accessibility service was disabled
* `Fix` IME overlay issue when editing custom broadcast content in the Scheduled Tasks page
* `Fix` Controls inside webview elements could not activate the soft keyboard properly
* `Fix` APK file info dialog might fail to obtain app name and SDK info
* `Fix` File-manager sample code might fail to auto-load child directory contents when entering a project folder
* `Fix` Top content of UI mode on Android 15 was covered by the status bar
* `Fix` Status-bar background color on some Android 15 pages could not follow the theme color dynamically
* `Fix` dialogs module could not use the customView property _[`issue #364`](http://issues.autojs6.com/364)_
* `Fix` Expression parameter of dialogs.input might not return the execution result
* `Fix` Using JavaAdapter led to a ClassLoader stack overflow _[`issue #376`](http://issues.autojs6.com/376)_
* `Fix` console.setContentTextColor caused log text color to lose its default value _[`issue #346`](http://issues.autojs6.com/346)_
* `Fix` console.setContentBackgroundColor could not accept color-name arguments _[`issue #384`](http://issues.autojs6.com/384)_
* `Fix` images.compress implementation corrected: now changes encoding quality instead of pixel down-sampling
* `Fix` images.resize method did not work properly
* `Fix` engines.all could trigger ConcurrentModificationException _[`issue #394`](http://issues.autojs6.com/394)_
* `Fix` Incorrect date formats in some languages within README.md
* `Fix` Gradle build could fail due to invalid library archive length _[`issue #389`](http://issues.autojs6.com/389)_
* `Improvement` Layout Inspector supports hiding controls (by [TonyJiangWJ](https://github.com/TonyJiangWJ)) _[`pr #371`](http://pr.autojs6.com/371)_ _[`issue #355`](http://issues.autojs6.com/355)_
* `Improvement` Added gradient separators to the Layout Inspector menu for lightweight grouping
* `Improvement` project.json now supports a permissions option for script projects (by [wirsnow](https://github.com/wirsnow)) _[`pr #391`](http://pr.autojs6.com/391)_ _[`issue #362`](http://issues.autojs6.com/362)_
* `Improvement` Automatically read and check declared permissions of installed apps when packaging a single file _[`issue #362`](http://issues.autojs6.com/362)_
* `Improvement` Expanded theme-color adaptation scope; supports more widget types
* `Improvement` Adaptive drawer width on the Home page for landscape / ultra-wide screens
* `Improvement` Added horizontal and small-screen layouts for About App & Developer pages
* `Improvement` Settings-page dialogs now offer a "Use default value" menu option
* `Improvement` Floating Action Button in File Manager auto-hides when tapping elsewhere
* `Improvement` Code formatter now supports operators such as `??`, `?.`, `??=`
* `Improvement` Code editor supports reading and writing files encoded in GB18030 / UTF-16 (LE/BE) / Shift_JIS, etc.
* `Improvement` Code editor supports displaying detailed file information (path/encoding/line break format/total bytes and characters, etc.) _[`issue #395`](http://issues.autojs6.com/395)_
* `Improvement` Added operation-error prompts for intent actions (edit / view / install / send / play, etc.)
* `Improvement` webview element's url attribute supports relative paths
* `Improvement` ImageWrapper#saveTo path parameter supports relative paths
* `Improvement` images.save supports PNG file-size compression when using the quality parameter _[`issue #367`](http://issues.autojs6.com/367)_
* `Improvement` Clearing ignored update records and client-mode connection addresses is now supported
* `Improvement` Version-update information supports multi-language display (in sync with current UI language)
* `Improvement` Asynchronous loading significantly improves File Manager list scrolling smoothness
* `Improvement` Improved content and formatting of script exception messages in the console
* `Improvement` Sample code now supports resetting a folder to its initial contents
* `Improvement` Increased efficiency when checking APK signature information
* `Improvement` Optimized dialog display efficiency and information presentation for APK/media file type info
* `Improvement` Gradle build script now better adapts to newer versions _[`discussion #369`](http://discussions.autojs6.com/369)_
* `Improvement` Some dependency or local library version adjustments _[`CHANGELOG.md`](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG.md#v663)_

# v6.6.2

###### 2025/04/16

* `Feature` Methods such as ui.statusBarAppearanceLight, statusBarAppearanceLightBy, navigationBarColor, etc.
* `Feature` ui.statusBarHeight attribute (getter) for obtaining the status bar height _[`issue #357`](http://issues.autojs6.com/357)_
* `Feature` images.flip method for image flipping _[`issue #349`](http://issues.autojs6.com/349)_
* `Feature` Added "file extension" option in the settings page
* `Feature` New layout support in the theme color settings page (grouping, positioning, search, history, enhanced color palette, etc.)
* `Fix` Issue where Android 15's status bar background color did not match the theme color
* `Fix` Issue where the plugins.load method failed to properly load plugins _[`issue #290`](http://issues.autojs6.com/290)_
* `Fix` Issue where the dx library could not be used properly on Android 7.x _[`issue #293`](http://issues.autojs6.com/293)_
* `Fix` Potential synchronization issues in ScriptRuntime when using require to import built-in modules (tentative fix) _[`issue #298`](http://issues.autojs6.com/298)_
* `Fix` Issue where the notice module was missing extension methods such as getBuilder _[`issue #301`](http://issues.autojs6.com/301)_
* `Fix` Issue where methods like shizuku/shell could not accept string parameters _[`issue #310`](http://issues.autojs6.com/310)_
* `Fix` Issue where the colors.pixel method could not accept single-channel image parameters _[`issue #350`](http://issues.autojs6.com/350)_
* `Fix` Issue where methods such as engines.execScript/execScriptFile had abnormal default working directories when executing scripts _[`issue #358`](http://issues.autojs6.com/358)_ _[`issue #340`](http://issues.autojs6.com/340)_ _[`issue #339`](http://issues.autojs6.com/339)_
* `Fix` Issue where floaty.window/floaty.rawWindow could not be executed on background threads
* `Fix` Issue where floaty.getClip might not correctly retrieve clipboard content _[`issue #341`](http://issues.autojs6.com/341)_
* `Fix` Issue where ui.inflate returned values were missing prototype methods such as attr/on/click
* `Fix` Issue where incorrect scope context binding when using XML syntax to use a JavaScript expression as an attribute value _[`issue #319`](http://issues.autojs6.com/319)_
* `Fix` Issue where exceptions in some method calls could not be caught by try..catch blocks _[`issue #345`](http://issues.autojs6.com/345)_
* `Fix` Issue where generating code on the layout analysis page could cause the app to crash _[`issue #288`](http://issues.autojs6.com/288)_
* `Fix` Issue where packaged applications could not properly use the shizuku module _[`issue #227`](http://issues.autojs6.com/227)_ _[`issue #231`](http://issues.autojs6.com/231)_ _[`issue #284`](http://issues.autojs6.com/284)_ _[`issue #287`](http://issues.autojs6.com/287)_ _[`issue #304`](http://issues.autojs6.com/304)_
* `Fix` Issue in the code editor where jumping to the end of a line might actually move the cursor to the beginning of the next line
* `Fix` Issue where rapid consecutive clicks on dialog-type items in the settings page could cause the app to crash
* `Improvement` Streamlined the APK file size for the packaged application template
* `Improvement` Enhanced app (and packaged apps) support for more permissions _[`issue #338`](http://issues.autojs6.com/338)_
* `Improvement` Added support for the Pinyin library option on the packaging page
* `Improvement` Optimized the status bar background and text color on the main activity page of packaged apps
* `Improvement` Added special permission toggles (such as access all files and send notifications) to the packaged app settings page _[`issue #354`](http://issues.autojs6.com/354)_
* `Improvement` Automatically switched control text and icon colors based on the brightness of the theme color
* `Improvement` Improved visual experience when contrast between control theme color and background is too low
* `Improvement` Enhanced HEX input control in the color palette for better compatibility when pasting color values from the clipboard
* `Improvement` Set in-app navigation bar to be transparent or semi-transparent to enhance visual experience
* `Improvement` Default UI mode for status bar and navigation bar set to `md_grey_50` color in light mode
* `Improvement` Homepage drawer's accessibility service toggle now syncs with script code
* `Improvement` Homepage document page search now supports bidirectional find buttons
* `Improvement` Homepage "Files" tab now supports toggling floating button visibility via long press
* `Improvement` Code editor title text now supports auto-adjusting font size
* `Improvement` Log page floating button visibility now linked with list scrolling actions
* `Improvement` Script project configuration file project.json now supports more packaging options _[`issue #305`](http://issues.autojs6.com/305)_ _[`issue #306`](http://issues.autojs6.com/306)_
* `Improvement` Improved project.json to support lenient matching of option names and alias compatibility
* `Improvement` APK file type info dialog now includes file size and signature scheme information
* `Improvement` APK file type info dialog now supports click listeners for copying text and navigating to app details
* `Improvement` Attempted to restore com.stardust prefixed packages to improve code compatibility _[`issue #290`](http://issues.autojs6.com/290)_
* `Improvement` Enhanced floaty.window/floaty.rawWindow to support execution on both main and background threads
* `Improvement` Global getClip method now leverages floaty.getClip as needed to improve compatibility
* `Improvement` Improved compatibility when passing null paths to files.path and related methods
* `Improvement` Synchronized with the latest official upstream code of the Rhino engine and performed necessary code adaptations
* `Improvement` Enhanced README.md to better document project build and run instructions _[`issue #344`](http://issues.autojs6.com/344)_
* `Improvement` Some dependency or local library version adjustments _[`CHANGELOG.md`](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG.md#v662)_

##### For more version history, refer to

* [CHANGELOG.md](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG-en.md)

******

### <a id="project-compilation-and-build"></a>Project Compilation and Build

******

For debugging or developing the AutoJs6 open-source project, you can use [Android Studio](https://pro.autojs.org/) (a product of [Google](https://www.google.com/)) or [IntelliJ IDEA](https://www.jetbrains.com/idea/) (a product of [Jetbrains](https://www.jetbrains.com/)).

This section introduces the compilation and build methods of the AutoJs6 open-source project using Android Studio as an example. IntelliJ IDEA is similar.

#### Android Studio Preparation

Download `Android Studio Meerkat Feature Drop | 2024.3.2 Patch 1` version (choose one as needed):

- [android-studio-2024.3.2.15-windows.exe](https://redirector.gvt1.com/edgedl/android/studio/install/2024.3.2.15/android-studio-2024.3.2.15-windows.exe) (1.23 GB)
- [android-studio-2024.3.2.15-windows.zip](https://redirector.gvt1.com/edgedl/android/studio/ide-zips/2024.3.2.15/android-studio-2024.3.2.15-windows.zip) (1.23 GB)

> Note: The release date for the above version is May 28, 2025. To download other versions, or if the above link is invalid, you can visit the [Android Studio release archive](https://developer.android.com/studio/archive?hl=en) page.

Install or extract the above file, then run the Android Studio software (e.g., `"D:\android-studio\bin\studio64.exe"`).

#### Android SDK Preparation

> Note: If the Android SDK is already installed on the computer system, this section can be skipped.

Open the `Android SDK (Android Software Development Kit)` settings page (any of the following ways):

```text
Help | Find action # Input "Android SDK"
[ or ]
File | Settings # Search "Android SDK"
[ or ]
File | Settings | Language & Frameworks | Android SDK
[ or ]
File | Settings | Appearance & Behavior | System Settings | Android SDK
```

If the `Android SDK Location` field is blank, click the `Edit` button on the right and click `Next` multiple times in the pop-up window.

> Note: During the process, one or more relevant agreements may need to be accepted to continue.

Once the related resources are downloaded and installed, click the `Finish` button.  
The `Android SDK Location` field above will auto-populate with the path, completing the SDK preparation work.

#### Android SDK Tools Preparation

AutoJs6 requires certain SDK tools (like NDK and CMake).

> Note: If all required Android SDK Tools for AutoJs6 are already installed on the computer system, this section can be skipped.

Open the `SDK Tools` settings page (any of the following ways):

```text
Help | Find action # Input "SDK Tools"
[ or ]
File | Settings # Search "SDK Tools"
[ or ]
File | Settings | Language & Frameworks | Android SDK | SDK Tools (located in the right window)
[ or ]
File | Settings | Appearance & Behavior | System Settings | Android SDK | SDK Tools (located in the right window) 
```

Check `Show Package Details`, click NDK and CMake respectively to ensure the corresponding version tools are checked, the version information of the SDK tools is located in the `version.properties` file in the root directory of the AutoJs6 project.

#### JDK Preparation

The `JDK (Java Development Kit)` version required for the AutoJs6 project should be at least `17`, but `19` or higher is recommended.

As of May 31, 2025, AutoJs6 supports up to version `24` of the JDK.

> Note: If the JDK is already installed on the computer system and the version meets the above requirements, this section can be skipped.

JDK can be downloaded directly via the IDE or from the [Oracle website](https://www.oracle.com/java/technologies/downloads/).

Open the `Gradle JDK` settings page (any of the following ways):

```text
Help | Find action # Input "Gradle JDK"
[ or ]
File | Settings # Search "Gradle"
[ or ]
File | Settings | Build, Execution, Deployment | Build Tools | Gradle
```

`Gradle JDK` can be chosen or added with different versions of JDK.

If a suitable version of the JDK (>= `17`) already exists in the list, it can be selected directly.  
Alternatively, you can choose `Download JDK` to download a suitable JDK, click the `Download` button and wait for the download to complete.  
You can also choose `Add JDK` to add an existing local JDK, locating its directory and completing the JDK addition.

#### AutoJs6 Resources Cloning

Click `Get from VCS` button on the main page of Android Studio.  
Fill `URL` field with `https://github.com/SuperMonster003/AutoJs6.git`,  
The `Directory` field can be modified to a specific path if needed.  
Click the `Clone` button, wait for the AutoJs6 project resources to be cloned to the local device.

> Note: The above process may require the installation of [Git](https://git-scm.com/download).

#### AutoJs6 Project Building

After cloning, Android Studio will open the AutoJs6 project window and automatically complete the preliminary `Dependencies` download and Gradle build work.

> Note: The above process may take a long time. If network conditions are poor, it may need to be retried multiple times (click the Retry button).

If the build couldn't proceed automatically or you need to rebuild the project, follow these steps:

- From the `Run/Debug Configurations` menu in the Toolbar, select `app`, which is the main AutoJs6 application
- Click the `Build Project` (hammer icon) button on the left to start building the project. The default shortcut is CTRL + F9
- Wait for the build to complete. The `Builder Output` tab will display a message such as "BUILD SUCCESSFUL in 1h 17m 34s"

If the build fails, you can report the error message to the AutoJs6 project's [Issues](http://issues.autojs6.com) page.

> Note: For more details on building and running the app, please refer to [Android Docs](https://developer.android.com/studio/run?hl=en)

#### AutoJs6 Project Deployment (Run App)

Once the project is built successfully, it can be deployed as an application (App) to a physical device (e.g., phone/tablet) or a virtual device (e.g., Android emulator).

- In the Toolbar, select `app` from the `Run/Debug Configurations` menu, which is the main AutoJs6 application
- In the `Available Devices` dropdown on the right, choose the device on which the project app should run (physical or virtual)
- Click the `Run` (triangle icon) button on the right to launch the app. The default shortcut is `F10`
- Wait for the deployment to finish; the chosen device will automatically install and run the project app

#### AutoJs6 Project Deployment (Generate APK)

Package the project and generate an APK file that can be installed on Android devices:

- Debug Version
    - `Build` | `Build Bundle(s) / APK(s)` | `Build APK(s)`
    - Generate signed debug APK
    - Path example: `"D:\AutoJs6\app\build\outputs\apk\debug\"`
- Release Version
    - `Build` | `Generate Signed Bundle / APK`
    - Select `APK` option
    - Prepare the signing file (create new or select existing), generate the signed release package
    - Path example: `"D:\AutoJs6\app\release\"`

> Note: For more information on building an app for user release, please refer to [Android Docs](https://developer.android.com/build/build-for-release?hl=en)

#### Predefined Gradle Build Tasks for AutoJs6

Besides building the project App, AutoJs6 supports several predefined Gradle build tasks that help developers perform convenient project-related operations.

Under the `Run/Debug Configurations` menu in the Toolbar, you can find various predefined Gradle tasks, each indicated by an elephant icon on the left.

- AutoJs6 [inrt:assemble]

Assemble the "inrt" build variant, which primarily serves the AutoJs6 script packaging feature.

The AutoJs6 project has various build variants. The "inrt" variant is used for packaging scripts, generating the template file "template.apk" required for packaging.

When using the packaging feature, you might encounter the following error message:

> java.io.FileNotFoundException: template.apk

This indicates that the template file does not exist. You need to manually run the `inrt:assemble` task to generate the template file, then rebuild and redeploy the app.

> Note: When the main project code changes and you want to synchronize these changes with the packaged app, you need to rerun the `inrt:assemble` task to generate the template files and redeploy the app

- AutoJs6 [app:bundle]

Package the outputs of the debug build process, primarily for the [AutoJs6 TypeScript definitions](http://dts-project.autojs6.com) project.

After running the task, it produces the latest JAR file for the AutoJs6 project. Using the [Android d.ts Generator](https://github.com/NativeScript/android-dts-generator) (by [NativeScript](https://github.com/NativeScript)), you can generate the type definitions (d.ts format) for the main AutoJs6 app.

- AutoJs6 [app:digest]

Append digest information to the APK produced by the release build, mainly to finalize the filename before publishing the latest version of AutoJs6 to GitHub.

Below is the comparison of filenames before and after appending the digest information:

```text
Before:
autojs6-v6.6.2-arm64-v8a.apk
After:
autojs6-v6.6.2-arm64-v8a-0f2a9d74.apk
```

> Reference: [Android Docs](https://developer.android.com/studio/run?hl=zh-cn)

******

### <a id="script-development-assistance"></a>Script Development Assistance

******

To develop scripts that run with AutoJs6, appropriate development tools must be used:

- [VSCode](https://code.visualstudio.com/download) / [WebStorm](https://www.jetbrains.com/webstorm/download/) / [HBuilderX](https://www.dcloud.io/hbuilderx.html) ...

For writing and debugging scripts on a PC, the VSCode plugin can enable PC-to-phone connectivity:

- [AutoJs6-VSCode-Extension](http://vscext-project.autojs6.com) - AutoJs6 debugger (VSCode platform plugin)

When writing code using development tools, code completion functionality can better assist developers in completing code:

- [AutoJs6-TypeScript-Declarations](http://dts-project.autojs6.com) - AutoJs6 declaration files (code completion)

When writing code, AutoJs6-related API and usage can be consulted in the documentation at any time:

- [AutoJs6-Documentation](http://docs-project.autojs6.com) - AutoJs6 application documentation

Existing script development projects can serve as references and inspire creativity for personal script projects:

- [Ant-Forest](https://github.com/TonyJiangWJ/Ant-Forest) - Ant Forest energy auto-collect script by [TonyJiangWJ](https://github.com/TonyJiangWJ)
- [Ant-Forest](https://github.com/SuperMonster003/Ant-Forest) - Ant Forest energy auto-collect script by [SuperMonster003](https://github.com/SuperMonster003)
- [autojs](https://github.com/e1399579/autojs) - Auto.js utility scripts by [e1399579](https://github.com/e1399579)
- [autojsDemo](https://github.com/snailuncle/autojsDemo) - Auto.js demonstration example by [snailuncle](https://github.com/snailuncle)
- [autojs related repositories](https://github.com/topics/autojs) - All repositories related to the autojs topic on GitHub

******

### Contribution

******

Thank you to everyone who contributed to the AutoJs6 project development.

|         <span style="word-break:keep-all;white-space:nowrap">Contributors</span>          |                   <span style="word-break:keep-all;white-space:nowrap">Number of Commits</span>                    | <span style="word-break:keep-all;white-space:nowrap">Recent Submissions</span> |
|:-------------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------:|
|             <span style="word-break:keep-all;white-space:nowrap">[wirsnow](https://github.com/wirsnow)</span>             |         <span style="word-break:keep-all;white-space:nowrap">[1](https://github.com/SuperMonster003/AutoJs6/commits?author=wirsnow)</span>         |                    <span style="word-break:keep-all;white-space:nowrap">`2025/05/19`</span>                    |
|         <span style="word-break:keep-all;white-space:nowrap">[TonyJiangWJ](https://github.com/TonyJiangWJ)</span>         |       <span style="word-break:keep-all;white-space:nowrap">[5](https://github.com/SuperMonster003/AutoJs6/commits?author=TonyJiangWJ)</span>       |                    <span style="word-break:keep-all;white-space:nowrap">`2025/04/24`</span>                    |
|          <span style="word-break:keep-all;white-space:nowrap">[luckyloogn](https://github.com/luckyloogn)</span>          |       <span style="word-break:keep-all;white-space:nowrap">[3](https://github.com/SuperMonster003/AutoJs6/commits?author=luckyloogn)</span>        |                    <span style="word-break:keep-all;white-space:nowrap">`2025/01/01`</span>                    |
|                <span style="word-break:keep-all;white-space:nowrap">[kvii](https://github.com/kvii)</span>                |          <span style="word-break:keep-all;white-space:nowrap">[1](https://github.com/SuperMonster003/AutoJs6/commits?author=kvii)</span>           |                    <span style="word-break:keep-all;white-space:nowrap">`2024/10/16`</span>                    |
|   <span style="word-break:keep-all;white-space:nowrap">[chenguangming](https://github.com/chenguangming) `(Tom)`</span>   | <span style="word-break:keep-all;white-space:nowrap">[2](https://github.com/SuperMonster003/AutoJs6/pulls?q=is%3Apr+author%3Achenguangming)</span> |                    <span style="word-break:keep-all;white-space:nowrap">`2024/05/14`</span>                    |
|          <span style="word-break:keep-all;white-space:nowrap">[LZX284](https://github.com/LZX284) `(AI)`</span>           |         <span style="word-break:keep-all;white-space:nowrap">[17](https://github.com/SuperMonster003/AutoJs6/commits?author=LZX284)</span>         |                    <span style="word-break:keep-all;white-space:nowrap">`2023/11/19`</span>                    |
| <span style="word-break:keep-all;white-space:nowrap">[little&#x2011;alei](https://github.com/little-alei) `(抠脚本人)`</span> |      <span style="word-break:keep-all;white-space:nowrap">[12](https://github.com/SuperMonster003/AutoJs6/commits?author=little-alei)</span>       |                    <span style="word-break:keep-all;white-space:nowrap">`2023/07/12`</span>                    |
|              <span style="word-break:keep-all;white-space:nowrap">[aiselp](https://github.com/aiselp)</span>              |    <span style="word-break:keep-all;white-space:nowrap">[6](https://github.com/SuperMonster003/AutoJs6/pulls?q=is%3Apr+author%3Aaiselp)</span>     |                    <span style="word-break:keep-all;white-space:nowrap">`2023/06/14`</span>                    |
|           <span style="word-break:keep-all;white-space:nowrap">[LYS86](https://github.com/LYS86) `(Lin)`</span>           |          <span style="word-break:keep-all;white-space:nowrap">[2](https://github.com/SuperMonster003/AutoJs6/commits?author=LYS86)</span>          |                    <span style="word-break:keep-all;white-space:nowrap">`2023/06/03`</span>                    |

Data updated on May 27, 2025.

Data entries sorted in descending order by `recent submissions`.

Newly initiated, unprocessed Pull Requests will be included in the data statistics after merging.

Some contributors do not appear correctly in the [GitHub Contributors](https://github.com/SuperMonster003/AutoJs6/graphs/contributors) due to empty contribution records, but their contribution records can still be viewed via [Pull Request](https://github.com/SuperMonster003/AutoJs6/pulls).

[//]: # (
    # --------------------------------------------------------------#
    # Before committing and pushing to the remote GitHub repository #
    # --------------------------------------------------------------#
    - IDE
        - The summary of the latest changelog for committing to Git [ DO NOT commit or push ]
    - $projectDir/version.properties
        - Remove the part like [ alpha / beta / ... ] of VERSION_NAME
    - $projectDir/.changelog/lang_zh-Hans.json
        - Update version name and released date
        - Translate into other languages
        - Update TypeScript declarations according to section `dependency` if needed
    - $projectDir/.readme/template_readme.md
        - Update badges like [ android studio / rhino / ... ]
        - Update contribution section: Contribution
    - $projectDir/.readme/common.json
        - Update android studio download links and version names
        - Update contribution section: var_date_contribution_table_data_updated
    - $projectDir/.python/generate_markdown.py
        - Re-generate markdown by running the python script [ link: aj6mdgen ]
    - Others
        - Re-generate documentation by running the python script [ link: aj6docgen ]
        - Check the two-way versions for AutoJs6 and VSCode ext, then publish the ext to Microsoft if needed
        - Run Gradle task "app:assembleInrtRelease" [ shortcut: C+A+0#- ]
        - Build APK to determine the final VERSION_BUILD field [ shortcut: C+A+0#A ]
        - Run Gradle task "app:appendDigestToReleasedFiles" [ shortcut: C+A+0#= ]
        - Check VERSION_BUILD in version.properties with released apks
        - Commit and push to GitHub
        - Publish the latest release with signed APKs
)