/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.LambdaFunction;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Slot;
import org.mozilla.javascript.Undefined;

public class LambdaAccessorSlot
extends Slot {
    private ScriptableObject.LambdaGetterFunction getter;
    private ScriptableObject.LambdaSetterFunction setter;
    private LambdaFunction getterFunction;
    private LambdaFunction setterFunction;

    LambdaAccessorSlot(Object name, int index) {
        super(name, index, 0);
    }

    LambdaAccessorSlot(Slot oldSlot) {
        super(oldSlot);
    }

    @Override
    LambdaAccessorSlot copySlot() {
        LambdaAccessorSlot newSlot = new LambdaAccessorSlot(this);
        newSlot.value = this.value;
        newSlot.getter = this.getter;
        newSlot.setter = this.setter;
        newSlot.getterFunction = this.getterFunction;
        newSlot.setterFunction = this.setterFunction;
        newSlot.next = null;
        newSlot.orderedNext = null;
        return newSlot;
    }

    @Override
    boolean isValueSlot() {
        return false;
    }

    @Override
    boolean isSetterSlot() {
        return true;
    }

    @Override
    ScriptableObject getPropertyDescriptor(Context cx, Scriptable scope) {
        return this.buildPropertyDescriptor(cx);
    }

    public ScriptableObject buildPropertyDescriptor(Context cx) {
        boolean es6;
        NativeObject desc = new NativeObject();
        int attr = this.getAttributes();
        boolean bl = es6 = cx.getLanguageVersion() >= 200;
        if (es6) {
            if (this.getterFunction == null && this.setterFunction == null) {
                desc.defineProperty("writable", (Object)((attr & 1) == 0 ? 1 : 0), 0);
            }
        } else {
            desc.setCommonDescriptorProperties(attr, this.getterFunction == null && this.setterFunction == null);
        }
        if (this.getterFunction != null) {
            desc.defineProperty("get", (Object)this.getterFunction, 0);
        }
        if (this.setterFunction != null) {
            desc.defineProperty("set", (Object)this.setterFunction, 0);
        } else if (es6) {
            desc.defineProperty("set", Undefined.instance, 0);
        }
        if (es6) {
            desc.defineProperty("enumerable", (Object)((attr & 2) == 0 ? 1 : 0), 0);
            desc.defineProperty("configurable", (Object)((attr & 4) == 0 ? 1 : 0), 0);
        }
        return desc;
    }

    @Override
    public boolean setValue(Object value, Scriptable scope, Scriptable start, boolean isThrow) {
        if (this.setter == null) {
            if (this.getter != null) {
                this.throwNoSetterException(start, value);
                return true;
            }
        } else {
            this.setter.accept(start, value);
            return true;
        }
        return super.setValue(value, start, start, isThrow);
    }

    @Override
    public Object getValue(Scriptable owner) {
        if (this.getter != null) {
            return this.getter.apply(owner);
        }
        return super.getValue(owner);
    }

    public void setGetter(Scriptable scope, ScriptableObject.LambdaGetterFunction getter) {
        this.getter = getter;
        if (getter != null) {
            this.getterFunction = new LambdaFunction(scope, "get " + this.name, 0, (cx1, scope1, thisObj, args) -> getter.apply(thisObj));
        }
    }

    public void setSetter(Scriptable scope, ScriptableObject.LambdaSetterFunction setter) {
        this.setter = setter;
        if (setter != null) {
            this.setterFunction = new LambdaFunction(scope, "set " + this.name, 1, (cx1, scope1, thisObj, args) -> {
                setter.accept(thisObj, args[0]);
                return Undefined.instance;
            });
        }
    }

    public void replaceWith(LambdaAccessorSlot slot) {
        this.getterFunction = slot.getterFunction;
        this.getter = slot.getter;
        this.setterFunction = slot.setterFunction;
        this.setter = slot.setter;
        this.setAttributes(slot.getAttributes());
    }
}

