/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Icode;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.InterpreterData;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.NodeTransformer;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Token;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.Block;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.Jump;
import org.mozilla.javascript.ast.Scope;
import org.mozilla.javascript.ast.ScriptNode;
import org.mozilla.javascript.ast.TemplateCharacters;

class CodeGenerator
extends Icode {
    private static final int MIN_LABEL_TABLE_SIZE = 32;
    private static final int MIN_FIXUP_TABLE_SIZE = 40;
    private CompilerEnvirons compilerEnv;
    private boolean itsInFunctionFlag;
    private boolean itsInTryFlag;
    private InterpreterData itsData;
    private ScriptNode scriptOrFn;
    private int iCodeTop;
    private int stackDepth;
    private int lineNumber = -1;
    private int doubleTableTop;
    private final HashMap<String, Integer> strings = new HashMap();
    private final HashMap<BigInteger, Integer> bigInts = new HashMap();
    private int localTop;
    private int[] labelTable;
    private int labelTableTop;
    private long[] fixupTable;
    private int fixupTableTop;
    private final ArrayList<Object> literalIds = new ArrayList();
    private int exceptionTableTop;
    private static final int ECF_TAIL = 1;

    CodeGenerator() {
    }

    public InterpreterData compile(CompilerEnvirons compilerEnv, ScriptNode tree, String rawSource, boolean returnFunction) {
        this.compilerEnv = compilerEnv;
        if (Token.printTrees) {
            System.out.println("before transform:");
            System.out.println(tree.toStringTree(tree));
        }
        new NodeTransformer().transform(tree, compilerEnv);
        if (Token.printTrees) {
            System.out.println("after transform:");
            System.out.println(tree.toStringTree(tree));
        }
        this.scriptOrFn = returnFunction ? tree.getFunctionNode(0) : tree;
        this.itsData = new InterpreterData(compilerEnv.getLanguageVersion(), this.scriptOrFn.getSourceName(), rawSource, this.scriptOrFn.isInStrictMode());
        this.itsData.topLevel = true;
        if (returnFunction) {
            this.generateFunctionICode();
        } else {
            this.generateICodeFromTree(this.scriptOrFn);
        }
        return this.itsData;
    }

    private void generateFunctionICode() {
        this.itsInFunctionFlag = true;
        FunctionNode theFunction = (FunctionNode)this.scriptOrFn;
        this.itsData.itsFunctionType = theFunction.getFunctionType();
        this.itsData.itsNeedsActivation = theFunction.requiresActivation();
        this.itsData.itsRequiresArgumentObject = theFunction.requiresArgumentObject();
        if (theFunction.getFunctionName() != null) {
            this.itsData.itsName = theFunction.getName();
        }
        if (theFunction.isGenerator()) {
            this.addIcode(-69);
            this.addUint16(theFunction.getBaseLineno() & 0xFFFF);
        }
        if (theFunction.isInStrictMode()) {
            this.itsData.isStrict = true;
        }
        if (theFunction.isES6Generator()) {
            this.itsData.isES6Generator = true;
        }
        this.generateICodeFromTree(theFunction.getLastChild());
    }

    private void generateICodeFromTree(Node tree) {
        int index;
        Map.Entry e;
        Object tmp;
        this.generateNestedFunctions();
        this.generateRegExpLiterals();
        this.generateTemplateLiterals();
        this.visitStatement(tree, 0);
        this.fixLabelGotos();
        if (this.itsData.itsFunctionType == 0) {
            this.addToken(70);
        }
        if (this.itsData.itsICode.length != this.iCodeTop) {
            tmp = new byte[this.iCodeTop];
            System.arraycopy(this.itsData.itsICode, 0, tmp, 0, this.iCodeTop);
            this.itsData.itsICode = tmp;
        }
        if (this.strings.size() == 0) {
            this.itsData.itsStringTable = null;
        } else {
            this.itsData.itsStringTable = new String[this.strings.size()];
            tmp = this.strings.entrySet().iterator();
            while (tmp.hasNext()) {
                e = (Map.Entry)tmp.next();
                String str = (String)e.getKey();
                index = (Integer)e.getValue();
                if (this.itsData.itsStringTable[index] != null) {
                    Kit.codeBug();
                }
                this.itsData.itsStringTable[index] = str;
            }
        }
        if (this.doubleTableTop == 0) {
            this.itsData.itsDoubleTable = null;
        } else if (this.itsData.itsDoubleTable.length != this.doubleTableTop) {
            tmp = new double[this.doubleTableTop];
            System.arraycopy(this.itsData.itsDoubleTable, 0, tmp, 0, this.doubleTableTop);
            this.itsData.itsDoubleTable = tmp;
        }
        if (this.bigInts.size() == 0) {
            this.itsData.itsBigIntTable = null;
        } else {
            this.itsData.itsBigIntTable = new BigInteger[this.bigInts.size()];
            tmp = this.bigInts.entrySet().iterator();
            while (tmp.hasNext()) {
                e = (Map.Entry)tmp.next();
                BigInteger bigInt = (BigInteger)e.getKey();
                index = (Integer)e.getValue();
                if (this.itsData.itsBigIntTable[index] != null) {
                    Kit.codeBug();
                }
                this.itsData.itsBigIntTable[index] = bigInt;
            }
        }
        if (this.exceptionTableTop != 0 && this.itsData.itsExceptionTable.length != this.exceptionTableTop) {
            tmp = new int[this.exceptionTableTop];
            System.arraycopy(this.itsData.itsExceptionTable, 0, tmp, 0, this.exceptionTableTop);
            this.itsData.itsExceptionTable = tmp;
        }
        this.itsData.itsMaxVars = this.scriptOrFn.getParamAndVarCount();
        this.itsData.itsMaxFrameArray = this.itsData.itsMaxVars + this.itsData.itsMaxLocals + this.itsData.itsMaxStack;
        this.itsData.argNames = this.scriptOrFn.getParamAndVarNames();
        this.itsData.argIsConst = this.scriptOrFn.getParamAndVarConst();
        this.itsData.argCount = this.scriptOrFn.getParamCount();
        this.itsData.argsHasRest = this.scriptOrFn.hasRestParameter();
        this.itsData.argsHasDefaults = this.scriptOrFn.getDefaultParams() != null;
        this.itsData.rawSourceStart = this.scriptOrFn.getRawSourceStart();
        this.itsData.rawSourceEnd = this.scriptOrFn.getRawSourceEnd();
        if (this.literalIds.size() != 0) {
            this.itsData.literalIds = this.literalIds.toArray();
        }
        if (Token.printICode) {
            Interpreter.dumpICode(this.itsData);
        }
    }

    private void generateNestedFunctions() {
        int functionCount = this.scriptOrFn.getFunctionCount();
        if (functionCount == 0) {
            return;
        }
        InterpreterData[] array = new InterpreterData[functionCount];
        for (int i = 0; i != functionCount; ++i) {
            FunctionNode fn = this.scriptOrFn.getFunctionNode(i);
            CodeGenerator gen = new CodeGenerator();
            gen.compilerEnv = this.compilerEnv;
            gen.scriptOrFn = fn;
            gen.itsData = new InterpreterData(this.itsData);
            gen.generateFunctionICode();
            array[i] = gen.itsData;
            AstNode fnParent = fn.getParent();
            if (fnParent instanceof AstRoot || fnParent instanceof Scope || fnParent instanceof Block) continue;
            gen.itsData.declaredAsFunctionExpression = true;
        }
        this.itsData.itsNestedFunctions = array;
    }

    private void generateRegExpLiterals() {
        int N = this.scriptOrFn.getRegexpCount();
        if (N == 0) {
            return;
        }
        Context cx = Context.getContext();
        RegExpProxy rep = ScriptRuntime.checkRegExpProxy(cx);
        Object[] array = new Object[N];
        for (int i = 0; i != N; ++i) {
            String string = this.scriptOrFn.getRegexpString(i);
            String flags = this.scriptOrFn.getRegexpFlags(i);
            array[i] = rep.compileRegExp(cx, string, flags);
        }
        this.itsData.itsRegExpLiterals = array;
    }

    private void generateTemplateLiterals() {
        int N = this.scriptOrFn.getTemplateLiteralCount();
        if (N == 0) {
            return;
        }
        Object[] array = new Object[N];
        for (int i = 0; i != N; ++i) {
            List<TemplateCharacters> strings = this.scriptOrFn.getTemplateLiteralStrings(i);
            int j = 0;
            String[] values = new String[strings.size() * 2];
            for (TemplateCharacters s : strings) {
                values[j++] = s.getValue();
                values[j++] = s.getRawValue();
            }
            array[i] = values;
        }
        this.itsData.itsTemplateLiterals = array;
    }

    private void updateLineNumber(Node node) {
        int lineno = node.getLineno();
        if (lineno != this.lineNumber && lineno >= 0) {
            if (this.itsData.firstLinePC < 0) {
                this.itsData.firstLinePC = lineno;
            }
            this.lineNumber = lineno;
            this.addIcode(-31);
            this.addUint16(lineno & 0xFFFF);
        }
    }

    private static RuntimeException badTree(Node node) {
        throw new RuntimeException(node.toString());
    }

    private void visitStatement(Node node, int initialStackDepth) {
        int type = node.getType();
        switch (type) {
            case 122: {
                int fnIndex = node.getExistingIntProp(1);
                int fnType = this.scriptOrFn.getFunctionNode(fnIndex).getFunctionType();
                if (fnType == 3) {
                    this.addIndexOp(-24, fnIndex);
                } else if (fnType != 1) {
                    throw Kit.codeBug();
                }
                if (this.itsInFunctionFlag) break;
                this.addIndexOp(-23, fnIndex);
                this.stackChange(1);
                this.addIcode(-5);
                this.stackChange(-1);
                break;
            }
            case 136: 
            case 141: 
            case 143: 
            case 144: 
            case 146: {
                this.updateLineNumber(node);
            }
            case 150: {
                Node child;
                while (child != null) {
                    this.visitStatement(child, initialStackDepth);
                    child = child.getNext();
                }
                break;
            }
            case 2: {
                Node child;
                this.visitExpression(child, 0);
                this.addToken(2);
                this.stackChange(-1);
                break;
            }
            case 3: {
                this.addToken(3);
                break;
            }
            case 155: {
                Node child;
                int local = this.allocLocal();
                node.putIntProp(2, local);
                this.updateLineNumber(node);
                for (child = node.getFirstChild(); child != null; child = child.getNext()) {
                    this.visitStatement(child, initialStackDepth);
                }
                this.addIndexOp(-63, local);
                this.releaseLocal(local);
                break;
            }
            case 174: {
                this.addIcode(-71);
                break;
            }
            case 127: {
                Node child;
                this.updateLineNumber(node);
                this.visitExpression(child, 0);
                for (Jump caseNode = (Jump)child.getNext(); caseNode != null; caseNode = (Jump)caseNode.getNext()) {
                    if (caseNode.getType() != 128) {
                        throw CodeGenerator.badTree(caseNode);
                    }
                    Node test = caseNode.getFirstChild();
                    this.addIcode(-1);
                    this.stackChange(1);
                    this.visitExpression(test, 0);
                    this.addToken(51);
                    this.stackChange(-1);
                    this.addGoto(caseNode.target, -6);
                    this.stackChange(-1);
                }
                this.addIcode(-4);
                this.stackChange(-1);
                break;
            }
            case 145: {
                this.markTargetLabel(node);
                break;
            }
            case 6: 
            case 7: {
                Node child;
                Node target = ((Jump)node).target;
                this.visitExpression(child, 0);
                this.addGoto(target, type);
                this.stackChange(-1);
                break;
            }
            case 5: {
                Node target = ((Jump)node).target;
                this.addGoto(target, type);
                break;
            }
            case 149: {
                Node target = ((Jump)node).target;
                this.addGoto(target, -28);
                break;
            }
            case 138: {
                Node child;
                this.stackChange(1);
                int finallyRegister = CodeGenerator.getLocalBlockRef(node);
                this.addIndexOp(-29, finallyRegister);
                this.stackChange(-1);
                while (child != null) {
                    this.visitStatement(child, initialStackDepth);
                    child = child.getNext();
                }
                this.addIndexOp(-30, finallyRegister);
                break;
            }
            case 147: 
            case 148: {
                Node child;
                this.updateLineNumber(node);
                this.visitExpression(child, 0);
                this.addIcode(type == 147 ? -4 : -5);
                this.stackChange(-1);
                break;
            }
            case 90: {
                Node finallyTarget;
                Node child;
                Jump tryNode = (Jump)node;
                int exceptionObjectLocal = CodeGenerator.getLocalBlockRef(tryNode);
                int scopeLocal = this.allocLocal();
                this.addIndexOp(-13, scopeLocal);
                int tryStart = this.iCodeTop;
                boolean savedFlag = this.itsInTryFlag;
                this.itsInTryFlag = true;
                while (child != null) {
                    this.visitStatement(child, initialStackDepth);
                    child = child.getNext();
                }
                this.itsInTryFlag = savedFlag;
                Node catchTarget = tryNode.target;
                if (catchTarget != null) {
                    int catchStartPC = this.labelTable[this.getTargetLabel(catchTarget)];
                    this.addExceptionHandler(tryStart, catchStartPC, catchStartPC, false, exceptionObjectLocal, scopeLocal);
                }
                if ((finallyTarget = tryNode.getFinally()) != null) {
                    int finallyStartPC = this.labelTable[this.getTargetLabel(finallyTarget)];
                    this.addExceptionHandler(tryStart, finallyStartPC, finallyStartPC, true, exceptionObjectLocal, scopeLocal);
                }
                this.addIndexOp(-63, scopeLocal);
                this.releaseLocal(scopeLocal);
                break;
            }
            case 62: {
                Node child;
                int localIndex = CodeGenerator.getLocalBlockRef(node);
                int scopeIndex = node.getExistingIntProp(14);
                String name = child.getType() == 44 ? child.getString() : "";
                child = child.getNext();
                this.visitExpression(child, 0);
                this.addStringPrefix(name);
                this.addIndexPrefix(localIndex);
                this.addToken(62);
                this.addUint8(scopeIndex != 0 ? 1 : 0);
                this.stackChange(-1);
                break;
            }
            case 55: {
                Node child;
                this.updateLineNumber(node);
                this.visitExpression(child, 0);
                this.addToken(55);
                this.addUint16(this.lineNumber & 0xFFFF);
                this.stackChange(-1);
                break;
            }
            case 56: {
                this.updateLineNumber(node);
                this.addIndexOp(56, CodeGenerator.getLocalBlockRef(node));
                break;
            }
            case 4: {
                Node child;
                this.updateLineNumber(node);
                if (node.getIntProp(20, 0) != 0) {
                    if (child == null || this.compilerEnv.getLanguageVersion() < 200) {
                        this.addIcode(-70);
                        this.addUint16(this.lineNumber & 0xFFFF);
                        break;
                    }
                    this.visitExpression(child, 1);
                    this.addIcode(-72);
                    this.addUint16(this.lineNumber & 0xFFFF);
                    this.stackChange(-1);
                    break;
                }
                if (child == null) {
                    this.addIcode(-27);
                    break;
                }
                this.visitExpression(child, 1);
                this.addToken(4);
                this.stackChange(-1);
                break;
            }
            case 70: {
                this.updateLineNumber(node);
                this.addToken(70);
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                Node child;
                this.visitExpression(child, 0);
                this.addIndexOp(type, CodeGenerator.getLocalBlockRef(node));
                this.stackChange(-1);
                break;
            }
            case -69: {
                break;
            }
            default: {
                throw CodeGenerator.badTree(node);
            }
        }
        if (this.stackDepth != initialStackDepth) {
            throw Kit.codeBug();
        }
    }

    private void visitExpression(Node node, int contextFlags) {
        int type = node.getType();
        int savedStackDepth = this.stackDepth;
        switch (type) {
            case 122: {
                int fnIndex = node.getExistingIntProp(1);
                FunctionNode fn = this.scriptOrFn.getFunctionNode(fnIndex);
                if (fn.getFunctionType() != 2 && fn.getFunctionType() != 4) {
                    throw Kit.codeBug();
                }
                this.addIndexOp(-23, fnIndex);
                if (fn.isMethodDefinition()) {
                    this.addIcode(-37);
                }
                this.stackChange(1);
                break;
            }
            case 59: {
                int localIndex = CodeGenerator.getLocalBlockRef(node);
                this.addIndexOp(59, localIndex);
                this.stackChange(1);
                break;
            }
            case 98: {
                Node child;
                Node lastChild = node.getLastChild();
                for (child = node.getFirstChild(); child != lastChild; child = child.getNext()) {
                    this.visitExpression(child, 0);
                    this.addIcode(-4);
                    this.stackChange(-1);
                }
                this.visitExpression(child, contextFlags & 1);
                break;
            }
            case 152: {
                this.stackChange(1);
                break;
            }
            case 30: 
            case 43: 
            case 76: {
                Node child;
                boolean isOptionalChainingCall = node.getIntProp(30, 0) == 1;
                CompleteOptionalCallJump completeOptionalCallJump = null;
                if (type == 30) {
                    this.visitExpression(child, 0);
                } else {
                    completeOptionalCallJump = this.generateCallFunAndThis(child, isOptionalChainingCall);
                    if (completeOptionalCallJump != null) {
                        this.resolveForwardGoto(completeOptionalCallJump.putArgsAndDoCallLabel);
                    }
                }
                int argCount = 0;
                while ((child = child.getNext()) != null) {
                    this.visitExpression(child, 0);
                    ++argCount;
                }
                int callType = node.getIntProp(10, 0);
                if (type != 76 && callType != 0) {
                    this.addIndexOp(-25, argCount);
                    this.addUint8(callType);
                    this.addUint8(type == 30 ? 1 : 0);
                    this.addUint16(this.lineNumber & 0xFFFF);
                } else if (node.getIntProp(31, 0) == 1) {
                    this.addIndexOp(-85, argCount);
                } else {
                    if (type == 43 && (contextFlags & 1) != 0 && !this.compilerEnv.isGenerateDebugInfo() && !this.itsInTryFlag) {
                        type = -62;
                    }
                    this.addIndexOp(type, argCount);
                }
                if (type == 30) {
                    this.stackChange(-argCount);
                } else {
                    this.stackChange(-1 - argCount);
                }
                if (argCount > this.itsData.itsMaxCalleeArgs) {
                    this.itsData.itsMaxCalleeArgs = argCount;
                }
                if (completeOptionalCallJump == null) break;
                this.resolveForwardGoto(completeOptionalCallJump.afterLabel);
                break;
            }
            case 117: 
            case 118: {
                Node child;
                this.visitExpression(child, 0);
                this.addIcode(-1);
                this.stackChange(1);
                int afterSecondJumpStart = this.iCodeTop;
                int jump = type == 118 ? 7 : 6;
                this.addGotoOp(jump);
                this.stackChange(-1);
                this.addIcode(-4);
                this.stackChange(-1);
                child = child.getNext();
                this.visitExpression(child, contextFlags & 1);
                this.resolveForwardGoto(afterSecondJumpStart);
                break;
            }
            case 115: {
                Node child;
                Node ifThen = child.getNext();
                Node ifElse = ifThen.getNext();
                this.visitExpression(child, 0);
                int elseJumpStart = this.iCodeTop;
                this.addGotoOp(7);
                this.stackChange(-1);
                this.visitExpression(ifThen, contextFlags & 1);
                int afterElseJumpStart = this.iCodeTop;
                this.addGotoOp(5);
                this.resolveForwardGoto(elseJumpStart);
                this.stackDepth = savedStackDepth;
                this.visitExpression(ifElse, contextFlags & 1);
                this.resolveForwardGoto(afterElseJumpStart);
                break;
            }
            case 33: 
            case 34: {
                Node child;
                this.visitExpression(child, 0);
                child = child.getNext();
                if (node.getIntProp(30, 0) == 1) {
                    this.addIcode(-1);
                    this.stackChange(1);
                    int putUndefinedLabel = this.iCodeTop;
                    this.addGotoOp(-83);
                    this.stackChange(-1);
                    this.addStringOp(type, child.getString());
                    int afterLabel = this.iCodeTop;
                    this.addGotoOp(5);
                    this.resolveForwardGoto(putUndefinedLabel);
                    this.addIcode(-4);
                    this.addStringOp(44, "undefined");
                    this.resolveForwardGoto(afterLabel);
                    break;
                }
                if (node.getIntProp(31, 0) == 1) {
                    this.addStringOp(type == 33 ? 35 : 36, child.getString());
                    break;
                }
                this.addStringOp(type, child.getString());
                break;
            }
            case 31: {
                Node child;
                boolean isName = child.getType() == 54;
                this.visitExpression(child, 0);
                child = child.getNext();
                this.visitExpression(child, 0);
                if (node.getIntProp(31, 0) == 1) {
                    this.addIcode(-86);
                } else if (isName) {
                    this.addIcode(0);
                } else {
                    this.addToken(31);
                }
                this.stackChange(-1);
                break;
            }
            case 39: {
                Node child;
                this.visitExpression(child, 0);
                child = child.getNext();
                if (node.getIntProp(30, 0) == 1) {
                    this.addIcode(-1);
                    this.stackChange(1);
                    int putUndefinedLabel = this.iCodeTop;
                    this.addGotoOp(-83);
                    this.stackChange(-1);
                    this.finishGetElemGeneration(child);
                    int afterLabel = this.iCodeTop;
                    this.addGotoOp(5);
                    this.resolveForwardGoto(putUndefinedLabel);
                    this.addIcode(-4);
                    this.addStringOp(44, "undefined");
                    this.resolveForwardGoto(afterLabel);
                    break;
                }
                if (node.getIntProp(31, 0) == 1) {
                    this.visitExpression(child, 0);
                    this.addToken(40);
                    this.stackChange(-1);
                    break;
                }
                this.finishGetElemGeneration(child);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 51: 
            case 52: 
            case 57: 
            case 58: 
            case 81: {
                Node child;
                this.visitExpression(child, 0);
                child = child.getNext();
                this.visitExpression(child, 0);
                this.addToken(type);
                this.stackChange(-1);
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 139: {
                Node child;
                this.visitExpression(child, 0);
                if (type == 139) {
                    this.addIcode(-4);
                    this.addIcode(-57);
                    break;
                }
                this.addToken(type);
                break;
            }
            case 73: 
            case 75: {
                Node child;
                this.visitExpression(child, 0);
                if (node.getIntProp(30, 0) == 1) {
                    this.addIcode(-1);
                    this.stackChange(1);
                    int afterLabel = this.iCodeTop;
                    this.addGotoOp(-83);
                    this.stackChange(-1);
                    this.addToken(type);
                    this.resolveForwardGoto(afterLabel);
                    break;
                }
                this.addToken(type);
                break;
            }
            case 37: 
            case 153: {
                Node child;
                this.visitExpression(child, 0);
                child = child.getNext();
                String property = child.getString();
                child = child.getNext();
                if (type == 153) {
                    this.addIcode(-1);
                    this.stackChange(1);
                    this.addStringOp(33, property);
                    this.stackChange(-1);
                }
                this.visitExpression(child, 0);
                this.addStringOp(node.getIntProp(31, 0) == 1 ? 38 : 37, property);
                this.stackChange(-1);
                break;
            }
            case 41: 
            case 154: {
                Node child;
                this.visitExpression(child, 0);
                child = child.getNext();
                this.visitExpression(child, 0);
                child = child.getNext();
                if (type == 154) {
                    this.addIcode(-2);
                    this.stackChange(2);
                    this.addToken(39);
                    this.stackChange(-1);
                    this.stackChange(-1);
                }
                this.visitExpression(child, 0);
                this.addToken(node.getIntProp(31, 0) == 1 ? 42 : 41);
                this.stackChange(-2);
                break;
            }
            case 74: 
            case 156: {
                Node child;
                this.visitExpression(child, 0);
                child = child.getNext();
                if (type == 156) {
                    this.addIcode(-1);
                    this.stackChange(1);
                    this.addToken(73);
                    this.stackChange(-1);
                }
                this.visitExpression(child, 0);
                this.addToken(74);
                this.stackChange(-1);
                break;
            }
            case 8: 
            case 80: {
                Node child;
                String name = child.getString();
                this.visitExpression(child, 0);
                child = child.getNext();
                this.visitExpression(child, 0);
                this.addStringOp(type, name);
                this.stackChange(-1);
                break;
            }
            case 169: {
                Node child;
                String name = child.getString();
                this.visitExpression(child, 0);
                child = child.getNext();
                this.visitExpression(child, 0);
                this.addStringOp(-66, name);
                this.stackChange(-1);
                break;
            }
            case 151: {
                int index = -1;
                if (this.itsInFunctionFlag && !this.itsData.itsNeedsActivation) {
                    index = this.scriptOrFn.getIndexForNameNode(node);
                }
                if (index == -1) {
                    this.addStringOp(-14, node.getString());
                    this.stackChange(1);
                    break;
                }
                this.addVarOp(60, index);
                this.stackChange(1);
                this.addToken(32);
                break;
            }
            case 44: 
            case 46: 
            case 54: {
                this.addStringOp(type, node.getString());
                this.stackChange(1);
                break;
            }
            case 119: 
            case 120: {
                Node child;
                this.visitIncDec(node, child);
                break;
            }
            case 45: {
                double num = node.getDouble();
                int inum = (int)num;
                if ((double)inum == num) {
                    if (inum == 0) {
                        this.addIcode(-58);
                        if (1.0 / num < 0.0) {
                            this.addToken(29);
                        }
                    } else if (inum == 1) {
                        this.addIcode(-59);
                    } else if ((short)inum == inum) {
                        this.addIcode(-32);
                        this.addUint16(inum & 0xFFFF);
                    } else {
                        this.addIcode(-33);
                        this.addInt(inum);
                    }
                } else {
                    int index = this.getDoubleIndex(num);
                    this.addIndexOp(45, index);
                }
                this.stackChange(1);
                break;
            }
            case 60: {
                if (this.itsData.itsNeedsActivation) {
                    Kit.codeBug();
                }
                int index = this.scriptOrFn.getIndexForNameNode(node);
                this.addVarOp(60, index);
                this.stackChange(1);
                break;
            }
            case 61: {
                Node child;
                if (this.itsData.itsNeedsActivation) {
                    Kit.codeBug();
                }
                int index = this.scriptOrFn.getIndexForNameNode(child);
                child = child.getNext();
                this.visitExpression(child, 0);
                this.addVarOp(61, index);
                break;
            }
            case 170: {
                Node child;
                if (this.itsData.itsNeedsActivation) {
                    Kit.codeBug();
                }
                int index = this.scriptOrFn.getIndexForNameNode(child);
                child = child.getNext();
                this.visitExpression(child, 0);
                this.addVarOp(170, index);
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 69: 
            case 79: {
                this.addToken(type);
                this.stackChange(1);
                break;
            }
            case 67: 
            case 68: {
                this.addIndexOp(type, CodeGenerator.getLocalBlockRef(node));
                this.stackChange(1);
                break;
            }
            case 89: {
                this.addBigInt(node.getBigInt());
                this.stackChange(1);
                break;
            }
            case 53: {
                int index = node.getExistingIntProp(4);
                this.addIndexOp(53, index);
                this.stackChange(1);
                break;
            }
            case 71: 
            case 72: {
                Node child;
                this.visitLiteral(node, child);
                break;
            }
            case 171: {
                Node child;
                this.visitArrayComprehension(node, child, child.getNext());
                break;
            }
            case 77: {
                Node child;
                this.visitExpression(child, 0);
                if (node.getIntProp(30, 0) == 1) {
                    this.addIcode(-1);
                    this.stackChange(1);
                    int putUndefinedLabel = this.iCodeTop;
                    this.addGotoOp(-83);
                    this.stackChange(-1);
                    this.addStringOp(type, (String)node.getProp(17));
                    int afterLabel = this.iCodeTop;
                    this.addGotoOp(5);
                    this.resolveForwardGoto(putUndefinedLabel);
                    this.addIcode(-4);
                    this.addStringOp(44, "undefined");
                    this.resolveForwardGoto(afterLabel);
                    break;
                }
                this.addStringOp(type, (String)node.getProp(17));
                break;
            }
            case 85: 
            case 86: 
            case 87: 
            case 88: {
                Node child;
                int memberTypeFlags = node.getIntProp(16, 0);
                int childCount = 0;
                do {
                    this.visitExpression(child, 0);
                    ++childCount;
                } while ((child = child.getNext()) != null);
                this.addIndexOp(type, memberTypeFlags);
                this.stackChange(1 - childCount);
                break;
            }
            case 160: {
                Node child;
                this.updateLineNumber(node);
                this.visitExpression(child, 0);
                this.addIcode(-60);
                this.stackChange(-1);
                int queryPC = this.iCodeTop;
                this.visitExpression(child.getNext(), 0);
                this.addBackwardGoto(-61, queryPC);
                break;
            }
            case 82: 
            case 83: 
            case 84: {
                Node child;
                this.visitExpression(child, 0);
                this.addToken(type);
                break;
            }
            case 78: 
            case 179: {
                Node child;
                if (child != null) {
                    this.visitExpression(child, 0);
                } else {
                    this.addIcode(-57);
                    this.stackChange(1);
                }
                if (type == 78) {
                    this.addToken(78);
                } else {
                    this.addIcode(-73);
                }
                this.addUint16(node.getLineno() & 0xFFFF);
                break;
            }
            case 173: {
                Node enterWith = node.getFirstChild();
                Node with = enterWith.getNext();
                this.visitExpression(enterWith.getFirstChild(), 0);
                this.addToken(2);
                this.stackChange(-1);
                this.visitExpression(with.getFirstChild(), 0);
                this.addToken(3);
                break;
            }
            case 180: {
                this.visitTemplateLiteral(node);
                break;
            }
            case 185: {
                Node child;
                this.visitExpression(child, 0);
                child = child.getNext();
                this.addIcode(-1);
                this.stackChange(1);
                int end = this.iCodeTop;
                this.addGotoOp(-84);
                this.stackChange(-1);
                this.addIcode(-4);
                this.visitExpression(child, 0);
                this.stackChange(-1);
                this.resolveForwardGoto(end);
                break;
            }
            default: {
                throw CodeGenerator.badTree(node);
            }
        }
        if (savedStackDepth + 1 != this.stackDepth) {
            Kit.codeBug();
        }
    }

    private void finishGetElemGeneration(Node child) {
        this.visitExpression(child, 0);
        this.addToken(39);
        this.stackChange(-1);
    }

    private CompleteOptionalCallJump generateCallFunAndThis(Node left, boolean isOptionalChainingCall) {
        int type = left.getType();
        switch (type) {
            case 44: {
                String name = left.getString();
                if (isOptionalChainingCall) {
                    this.addStringOp(-19, name);
                    this.stackChange(2);
                    return this.completeOptionalCallJump();
                }
                this.addStringOp(-15, name);
                this.stackChange(2);
                break;
            }
            case 33: 
            case 39: {
                Node target = left.getFirstChild();
                this.visitExpression(target, 0);
                Node id = target.getNext();
                if (type == 33) {
                    String property = id.getString();
                    if (isOptionalChainingCall) {
                        this.addStringOp(-20, property);
                        this.stackChange(1);
                        return this.completeOptionalCallJump();
                    }
                    this.addStringOp(-16, property);
                    this.stackChange(1);
                    break;
                }
                this.visitExpression(id, 0);
                if (isOptionalChainingCall) {
                    this.addIcode(-21);
                    return this.completeOptionalCallJump();
                }
                this.addIcode(-17);
                break;
            }
            default: {
                this.visitExpression(left, 0);
                if (isOptionalChainingCall) {
                    this.addIcode(-22);
                    this.stackChange(1);
                    return this.completeOptionalCallJump();
                }
                this.addIcode(-18);
                this.stackChange(1);
            }
        }
        return null;
    }

    private CompleteOptionalCallJump completeOptionalCallJump() {
        this.addIcode(-1);
        this.stackChange(1);
        int putArgsAndDoCallLabel = this.iCodeTop;
        this.addGotoOp(-84);
        this.stackChange(-1);
        this.addIcode(-4);
        this.addIcode(-4);
        this.addStringOp(44, "undefined");
        int afterLabel = this.iCodeTop;
        this.addGotoOp(5);
        return new CompleteOptionalCallJump(putArgsAndDoCallLabel, afterLabel);
    }

    private void visitIncDec(Node node, Node child) {
        int incrDecrMask = node.getExistingIntProp(13);
        int childType = child.getType();
        if (child.getIntProp(31, 0) == 1) {
            this.visitSuperIncDec(node, child, childType, incrDecrMask);
            return;
        }
        switch (childType) {
            case 60: {
                if (this.itsData.itsNeedsActivation) {
                    Kit.codeBug();
                }
                int i = this.scriptOrFn.getIndexForNameNode(child);
                this.addVarOp(-7, i);
                this.addUint8(incrDecrMask);
                this.stackChange(1);
                break;
            }
            case 44: {
                String name = child.getString();
                this.addStringOp(-8, name);
                this.addUint8(incrDecrMask);
                this.stackChange(1);
                break;
            }
            case 33: {
                Node object = child.getFirstChild();
                this.visitExpression(object, 0);
                String property = object.getNext().getString();
                this.addStringOp(-9, property);
                this.addUint8(incrDecrMask);
                break;
            }
            case 39: {
                Node object = child.getFirstChild();
                this.visitExpression(object, 0);
                Node index = object.getNext();
                this.visitExpression(index, 0);
                this.addIcode(-10);
                this.addUint8(incrDecrMask);
                this.stackChange(-1);
                break;
            }
            case 73: {
                Node ref = child.getFirstChild();
                this.visitExpression(ref, 0);
                this.addIcode(-11);
                this.addUint8(incrDecrMask);
                break;
            }
            default: {
                throw CodeGenerator.badTree(node);
            }
        }
    }

    private void visitSuperIncDec(Node node, Node child, int childType, int incrDecrMask) {
        Node index;
        Node object = child.getFirstChild();
        this.visitExpression(object, 0);
        switch (childType) {
            case 33: {
                this.addStringOp(35, object.getNext().getString());
                break;
            }
            case 39: {
                index = object.getNext();
                this.visitExpression(index, 0);
                this.addToken(40);
                this.stackChange(-1);
                break;
            }
            default: {
                throw CodeGenerator.badTree(node);
            }
        }
        if ((incrDecrMask & 2) != 0) {
            this.addIcode(-1);
            this.stackChange(1);
        }
        this.addToken(79);
        this.stackChange(1);
        this.addIcode(-3);
        this.addIcode(-59);
        this.stackChange(1);
        if ((incrDecrMask & 1) == 0) {
            this.addToken(21);
        } else {
            this.addToken(22);
        }
        this.stackChange(-1);
        switch (childType) {
            case 33: {
                this.addStringOp(38, object.getNext().getString());
                this.stackChange(-1);
                break;
            }
            case 39: {
                index = object.getNext();
                this.visitExpression(index, 0);
                this.addToken(42);
                this.stackChange(-2);
                break;
            }
        }
        if ((incrDecrMask & 2) != 0) {
            this.addIcode(-4);
            this.stackChange(-1);
        }
    }

    private void visitLiteral(Node node, Node child) {
        int type = node.getType();
        if (type == 71) {
            this.visitArrayLiteral(node, child);
        } else if (type == 72) {
            this.visitObjectLiteral(node, child);
        } else {
            throw CodeGenerator.badTree(node);
        }
    }

    private void visitObjectLiteral(Node node, Node child) {
        Object[] propertyIds = (Object[])node.getProp(12);
        int count = propertyIds == null ? 0 : propertyIds.length;
        boolean hasAnyComputedProperty = propertyIds != null && Arrays.stream(propertyIds).anyMatch(id -> id instanceof Node);
        int nextLiteralIndex = this.literalIds.size();
        this.literalIds.add(propertyIds);
        this.addIndexOp(-34, nextLiteralIndex);
        this.addUint8(hasAnyComputedProperty ? 1 : 0);
        this.stackChange(4);
        int i = 0;
        while (child != null) {
            Object propertyId;
            Object object = propertyId = propertyIds == null ? null : propertyIds[i];
            if (propertyId instanceof Node) {
                Node computedPropertyNode = (Node)propertyId;
                this.visitExpression(computedPropertyNode.first, 0);
                this.addIcode(-82);
                this.stackChange(-1);
            }
            this.visitLiteralValue(child);
            child = child.getNext();
            ++i;
        }
        this.addToken(72);
        this.stackChange(-3);
    }

    private void visitArrayLiteral(Node node, Node child) {
        int count = 0;
        for (Node n = child; n != null; n = n.getNext()) {
            ++count;
        }
        this.addIndexOp(-35, count);
        this.stackChange(2);
        while (child != null) {
            this.visitLiteralValue(child);
            child = child.getNext();
        }
        int[] skipIndexes = (int[])node.getProp(11);
        if (skipIndexes == null) {
            this.addToken(71);
        } else {
            int index = this.literalIds.size();
            this.literalIds.add(skipIndexes);
            this.addIndexOp(-38, index);
        }
        this.stackChange(-1);
    }

    private void visitLiteralValue(Node child) {
        int childType = child.getType();
        if (childType == 165) {
            this.visitExpression(child.getFirstChild(), 0);
            this.addIcode(-64);
        } else if (childType == 166) {
            this.visitExpression(child.getFirstChild(), 0);
            this.addIcode(-65);
        } else if (childType == 177) {
            this.visitExpression(child.getFirstChild(), 0);
            this.addIcode(-36);
        } else {
            this.visitExpression(child, 0);
            this.addIcode(-36);
        }
        this.stackChange(-1);
    }

    private void visitTemplateLiteral(Node node) {
        int index = node.getExistingIntProp(27);
        this.addIndexOp(-81, index);
        this.stackChange(1);
    }

    private void visitArrayComprehension(Node node, Node initStmt, Node expr) {
        this.visitStatement(initStmt, this.stackDepth);
        this.visitExpression(expr, 0);
    }

    private static int getLocalBlockRef(Node node) {
        Node localBlock = (Node)node.getProp(3);
        return localBlock.getExistingIntProp(2);
    }

    private int getTargetLabel(Node target) {
        int label = target.labelId();
        if (label != -1) {
            return label;
        }
        label = this.labelTableTop;
        if (this.labelTable == null || label == this.labelTable.length) {
            if (this.labelTable == null) {
                this.labelTable = new int[32];
            } else {
                int[] tmp = new int[this.labelTable.length * 2];
                System.arraycopy(this.labelTable, 0, tmp, 0, label);
                this.labelTable = tmp;
            }
        }
        this.labelTableTop = label + 1;
        this.labelTable[label] = -1;
        target.labelId(label);
        return label;
    }

    private void markTargetLabel(Node target) {
        int label = this.getTargetLabel(target);
        if (this.labelTable[label] != -1) {
            Kit.codeBug();
        }
        this.labelTable[label] = this.iCodeTop;
    }

    private void addGoto(Node target, int gotoOp) {
        int targetPC;
        int label = this.getTargetLabel(target);
        if (label >= this.labelTableTop) {
            Kit.codeBug();
        }
        if ((targetPC = this.labelTable[label]) != -1) {
            this.addBackwardGoto(gotoOp, targetPC);
        } else {
            int gotoPC = this.iCodeTop;
            this.addGotoOp(gotoOp);
            int top = this.fixupTableTop;
            if (this.fixupTable == null || top == this.fixupTable.length) {
                if (this.fixupTable == null) {
                    this.fixupTable = new long[40];
                } else {
                    long[] tmp = new long[this.fixupTable.length * 2];
                    System.arraycopy(this.fixupTable, 0, tmp, 0, top);
                    this.fixupTable = tmp;
                }
            }
            this.fixupTableTop = top + 1;
            this.fixupTable[top] = (long)label << 32 | (long)gotoPC;
        }
    }

    private void fixLabelGotos() {
        for (int i = 0; i < this.fixupTableTop; ++i) {
            long fixup = this.fixupTable[i];
            int label = (int)(fixup >> 32);
            int jumpSource = (int)fixup;
            int pc = this.labelTable[label];
            if (pc == -1) {
                throw Kit.codeBug();
            }
            this.resolveGoto(jumpSource, pc);
        }
        this.fixupTableTop = 0;
    }

    private void addBackwardGoto(int gotoOp, int jumpPC) {
        int fromPC = this.iCodeTop;
        if (fromPC <= jumpPC) {
            throw Kit.codeBug();
        }
        this.addGotoOp(gotoOp);
        this.resolveGoto(fromPC, jumpPC);
    }

    private void resolveForwardGoto(int fromPC) {
        if (this.iCodeTop < fromPC + 3) {
            throw Kit.codeBug();
        }
        this.resolveGoto(fromPC, this.iCodeTop);
    }

    private void resolveGoto(int fromPC, int jumpPC) {
        int offset = jumpPC - fromPC;
        if (0 <= offset && offset <= 2) {
            throw Kit.codeBug();
        }
        int offsetSite = fromPC + 1;
        if (offset != (short)offset) {
            if (this.itsData.longJumps == null) {
                this.itsData.longJumps = new HashMap<Integer, Integer>();
            }
            this.itsData.longJumps.put(offsetSite, jumpPC);
            offset = 0;
        }
        byte[] array = this.itsData.itsICode;
        array[offsetSite] = (byte)(offset >> 8);
        array[offsetSite + 1] = (byte)offset;
    }

    private void addToken(int token) {
        if (!Icode.validTokenCode(token)) {
            throw Kit.codeBug();
        }
        this.addUint8(token);
    }

    private void addIcode(int icode) {
        if (!Icode.validIcode(icode)) {
            throw Kit.codeBug();
        }
        this.addUint8(icode & 0xFF);
    }

    private void addUint8(int value) {
        if ((value & 0xFFFFFF00) != 0) {
            throw Kit.codeBug();
        }
        int top = this.iCodeTop;
        byte[] array = this.itsData.itsICode;
        if (top == array.length) {
            array = this.increaseICodeCapacity(1);
        }
        array[top] = (byte)value;
        this.iCodeTop = top + 1;
    }

    private void addUint16(int value) {
        if ((value & 0xFFFF0000) != 0) {
            throw Kit.codeBug();
        }
        int top = this.iCodeTop;
        byte[] array = this.itsData.itsICode;
        if (top + 2 > array.length) {
            array = this.increaseICodeCapacity(2);
        }
        array[top] = (byte)(value >>> 8);
        array[top + 1] = (byte)value;
        this.iCodeTop = top + 2;
    }

    private void addInt(int i) {
        int top = this.iCodeTop;
        byte[] array = this.itsData.itsICode;
        if (top + 4 > array.length) {
            array = this.increaseICodeCapacity(4);
        }
        array[top] = (byte)(i >>> 24);
        array[top + 1] = (byte)(i >>> 16);
        array[top + 2] = (byte)(i >>> 8);
        array[top + 3] = (byte)i;
        this.iCodeTop = top + 4;
    }

    private int getDoubleIndex(double num) {
        int index = this.doubleTableTop;
        if (index == 0) {
            this.itsData.itsDoubleTable = new double[64];
        } else if (this.itsData.itsDoubleTable.length == index) {
            double[] na = new double[index * 2];
            System.arraycopy(this.itsData.itsDoubleTable, 0, na, 0, index);
            this.itsData.itsDoubleTable = na;
        }
        this.itsData.itsDoubleTable[index] = num;
        this.doubleTableTop = index + 1;
        return index;
    }

    private void addGotoOp(int gotoOp) {
        int top = this.iCodeTop;
        byte[] array = this.itsData.itsICode;
        if (top + 3 > array.length) {
            array = this.increaseICodeCapacity(3);
        }
        array[top] = (byte)gotoOp;
        this.iCodeTop = top + 1 + 2;
    }

    private void addVarOp(int op, int varIndex) {
        switch (op) {
            case 170: {
                if (varIndex < 128) {
                    this.addIcode(-68);
                    this.addUint8(varIndex);
                    return;
                }
                this.addIndexOp(-67, varIndex);
                return;
            }
            case 60: 
            case 61: {
                if (varIndex < 128) {
                    this.addIcode(op == 60 ? -55 : -56);
                    this.addUint8(varIndex);
                    return;
                }
            }
            case -7: {
                this.addIndexOp(op, varIndex);
                return;
            }
        }
        throw Kit.codeBug();
    }

    private void addStringOp(int op, String str) {
        this.addStringPrefix(str);
        if (Icode.validIcode(op)) {
            this.addIcode(op);
        } else {
            this.addToken(op);
        }
    }

    private void addIndexOp(int op, int index) {
        this.addIndexPrefix(index);
        if (Icode.validIcode(op)) {
            this.addIcode(op);
        } else {
            this.addToken(op);
        }
    }

    private void addStringPrefix(String str) {
        int index = this.strings.getOrDefault(str, -1);
        if (index == -1) {
            index = this.strings.size();
            this.strings.put(str, index);
        }
        if (index < 4) {
            this.addIcode(-48 - index);
        } else if (index <= 255) {
            this.addIcode(-52);
            this.addUint8(index);
        } else if (index <= 65535) {
            this.addIcode(-53);
            this.addUint16(index);
        } else {
            this.addIcode(-54);
            this.addInt(index);
        }
    }

    private void addBigInt(BigInteger n) {
        int index = this.bigInts.getOrDefault(n, -1);
        if (index == -1) {
            index = this.bigInts.size();
            this.bigInts.put(n, index);
        }
        if (index < 4) {
            this.addIcode(-74 - index);
        } else if (index <= 255) {
            this.addIcode(-78);
            this.addUint8(index);
        } else if (index <= 65535) {
            this.addIcode(-79);
            this.addUint16(index);
        } else {
            this.addIcode(-80);
            this.addInt(index);
        }
        this.addToken(89);
    }

    private void addIndexPrefix(int index) {
        if (index < 0) {
            Kit.codeBug();
        }
        if (index < 6) {
            this.addIcode(-39 - index);
        } else if (index <= 255) {
            this.addIcode(-45);
            this.addUint8(index);
        } else if (index <= 65535) {
            this.addIcode(-46);
            this.addUint16(index);
        } else {
            this.addIcode(-47);
            this.addInt(index);
        }
    }

    private void addExceptionHandler(int icodeStart, int icodeEnd, int handlerStart, boolean isFinally, int exceptionObjectLocal, int scopeLocal) {
        int top = this.exceptionTableTop;
        int[] table = this.itsData.itsExceptionTable;
        if (table == null) {
            if (top != 0) {
                Kit.codeBug();
            }
            this.itsData.itsExceptionTable = table = new int[12];
        } else if (table.length == top) {
            table = new int[table.length * 2];
            System.arraycopy(this.itsData.itsExceptionTable, 0, table, 0, top);
            this.itsData.itsExceptionTable = table;
        }
        table[top + 0] = icodeStart;
        table[top + 1] = icodeEnd;
        table[top + 2] = handlerStart;
        table[top + 3] = isFinally ? 1 : 0;
        table[top + 4] = exceptionObjectLocal;
        table[top + 5] = scopeLocal;
        this.exceptionTableTop = top + 6;
    }

    private byte[] increaseICodeCapacity(int extraSize) {
        int top = this.iCodeTop;
        int capacity = this.itsData.itsICode.length;
        if (top + extraSize <= capacity) {
            throw Kit.codeBug();
        }
        if (top + extraSize > (capacity *= 2)) {
            capacity = top + extraSize;
        }
        byte[] array = new byte[capacity];
        System.arraycopy(this.itsData.itsICode, 0, array, 0, top);
        this.itsData.itsICode = array;
        return array;
    }

    private void stackChange(int change) {
        if (change <= 0) {
            this.stackDepth += change;
        } else {
            int newDepth = this.stackDepth + change;
            if (newDepth > this.itsData.itsMaxStack) {
                this.itsData.itsMaxStack = newDepth;
            }
            this.stackDepth = newDepth;
        }
    }

    private int allocLocal() {
        int localSlot = this.localTop++;
        if (this.localTop > this.itsData.itsMaxLocals) {
            this.itsData.itsMaxLocals = this.localTop;
        }
        return localSlot;
    }

    private void releaseLocal(int localSlot) {
        --this.localTop;
        if (localSlot != this.localTop) {
            Kit.codeBug();
        }
    }

    private static final class CompleteOptionalCallJump {
        private final int putArgsAndDoCallLabel;
        private final int afterLabel;

        public CompleteOptionalCallJump(int putArgsAndDoCallLabel, int afterLabel) {
            this.putArgsAndDoCallLabel = putArgsAndDoCallLabel;
            this.afterLabel = afterLabel;
        }
    }
}

