## 颜色搜索

颜色搜索支持以下 5 种搜索方式, 所有方式均不区分大小写.

### 1. 颜色名称 (当前语言)

以当前语言显示的颜色名称作为关键字的搜索方式.

#### 示例 1.1: 红

可匹配全部颜色名称中包含 "红" 的颜色, 如 "红", "绯红", "红宝石", "红 (200)" 等.

#### 示例 1.2: 蓝50

可匹配全部颜色名称中包含 "蓝50" 的颜色, 匹配时会忽略所有 "非字母或数字字符", 如 [空格/括号/斜杠/连字符] 等. 因此 "蓝50" 可以匹配 "蓝 (50)", "蓝 (500)" 以及 "浅蓝 (50)" 等, 但不可以匹配 "蓝绿 (50)", 因为 "绿" 不可被忽略.

### 2. 颜色名称 (英文)

以 "$" 开头, 启用英文颜色名称搜索方式.

#### 示例 2.1: $red

可匹配全部英文颜色名称中包含 "red" 的颜色, 如 "红", "鲜红", "橙红" 等. 即使当前显示语言并非英语, 也可通过英文关键字搜索到对应的颜色.

#### 示例 2.2: $blue50

同示例 1.2, 可匹配 "蓝 (50)", "蓝 (500)" 以及 "浅蓝 (50)" 等.

### 3. HEX

以 "#" 开头, 启用 HEX 搜索方式.

#### 示例 3.1: #FF007F

可匹配 HEX 为 "#FF007F" 的 "玫瑰红" 颜色.

#### 示例 3.2: #FF

可匹配所有 HEX 以 "#FF" 开头的颜色, 如 "#FF8099", "#FF00CB", "#FFFAFA" 等.

### 4. 正则表达式

以 "/" 开头, 以 "/" 结尾, 启用正则表达式搜索方式, 类似 JavaScript 语法.

#### 示例 4.1: /红|橙|黄/

可匹配所有颜色名称中包含 "红" 或 "橙" 或 "黄" 的颜色.

#### 示例 4.2: /\b50\b/

可匹配所有颜色名称中包含 50 且前后均有分词边界的颜色, 如 "红 (50)", "粉 (50)", "黄 (50)" 等, 但不包含 "红 (500)", "粉 (500)" 等.

#### 示例 4.3: /石\B/

可匹配所有颜色名称中包含 "石" 但不以其作为分词结尾边界的颜色, 如 "红雀石绿", "尖晶石红" 等, 但不包含 "绿松石", "红宝石" 等.

#### 示例 4.4: /^[\u4e00-\u9fff]{5}$/

可匹配所有颜色名称中恰好包含且仅包含 5 个常用汉字的颜色, 如 "薰衣草紫红", "勃艮第酒红", "橄榄军服绿" 等.

#### 示例 4.5: /red|orange/

类似示例 2.2, 正则表达式也会匹配英文名称颜色. /red|orange/ 可匹配 "鲜红", "燃橙", "灰紫红" 等.

### 5. HEX 正则表达式

以 "#/" 开头, 以 "/" 结尾, 启用 HEX 正则表达式搜索方式.

#### 示例 5.1: #/FF\b/

可匹配所有 HEX 包含 "FF" 且作为分词结尾边界的颜色, 可表示为 "#xxxxFF". 如 "#2962FF", "#D94DFF", "#F0F8FF" 等.

#### 示例 5.2: #/#FF/

可匹配所有 HEX 包含 "#FF" 的颜色, 与示例 3.2 效果完全相同, 可表示为 "#FFxxxx".

#### 示例 5.3: #/#..FF/

可匹配所有 HEX "中间" 包含 "FF" 的颜色, 可表示为 "#xxFFxx". 如 "#CCFF00", "#66FFE6", "#00FF7F" 等.

#### 示例 5.4: #/#((?<!0).){2}0000/

可匹配所有 HEX 仅包含红色分量的颜色, 可表示为 "#xx0000" (排除黑色). 如 "#8B0000", "#D50000", "#FF0000" 等.

#### 示例 5.5: #/#0000(.(?!0)){2}/

可匹配所有 HEX 仅包含蓝色分量的颜色, 可表示为 "#0000xx" (排除黑色). 如 "#00008B", "#0000CD", "#0000FF" 等.

#### 示例 5.6: #/#00((?!0).)(.(?<!0))00/

可匹配所有 HEX 仅包含绿色分量的颜色, 可表示为 "#00xx00" (排除黑色). 如 "#006400", "#00FF00" 等.