<!--suppress HtmlDeprecatedAttribute, HttpUrlsUsage -->

<div align="center">
  <p>
    <img src="https://s1.imagehub.cc/images/2023/03/07/af8ed087c9d354b9ab6142aae7bbafb6.png" alt="autojs6-banner_800×224" border="0" width="704" />
  </p>

  <p>Android 平台支持无障碍服务的 JavaScript 自动化工具</p>

  <p>
    <a href="http://download.autojs6.com"><img alt="GitHub release (latest by date)" src="https://img.shields.io/github/v/release/SuperMonster003/AutoJs6"/></a>
    <a href="http://issues.autojs6.com"><img alt="GitHub closed issues" src="https://img.shields.io/github/issues/SuperMonster003/AutoJs6?color=A24232"/></a>
    <a href="http://commit.autojs6.com/99a1d8490fac5b6d55f6f183db59ad833a2064ed"><img alt="Created" src="https://img.shields.io/date/1636632233?color=2e7d32&label=created"/></a>
    <br>
    <a href="https://github.com/mozilla/rhino"><img alt="Rhino" src="https://img.shields.io/badge/rhino-1.8.1--SNAPSHOT-795548"/></a>
    <a href="https://developer.android.com/studio/archive"><img alt="Android Studio" src="https://img.shields.io/badge/android%20studio-2022.1+-B64FC8"/></a>
    <br>
    <a href="https://www.codefactor.io/repository/github/SuperMonster003/AutoJs6"><img alt="CodeFactor Grade" src="https://www.codefactor.io/repository/github/SuperMonster003/AutoJs6/badge"/></a>
    <a href="https://www.jetbrains.com/?from=AutoJs6"><img alt="JetBrains supporter" src="https://img.shields.io/badge/supporter-JetBrains-ee4677"/></a>
    <a href="http://project.autojs6.com/blob/master/LICENSE"><img alt="GitHub License" src="https://img.shields.io/github/license/SuperMonster003/AutoJs6?color=534BAE"/></a>
  </p>
</div>

******

### 语言 (Languages)

******

当前自述文件 `README.md` 支持以下语言:

 - 简体中文 [zh-Hans] # 当前
 - [繁體中文 (香港) [zh-Hant-HK]](http://project.autojs6.com/blob/master/.readme/README-zh-Hant-HK.md)
 - [繁體中文 (台灣) [zh-Hant-TW]](http://project.autojs6.com/blob/master/.readme/README-zh-Hant-TW.md)
 - [English [en]](http://project.autojs6.com/blob/master/.readme/README-en.md)
 - [Français [fr]](http://project.autojs6.com/blob/master/.readme/README-fr.md)
 - [Español [es]](http://project.autojs6.com/blob/master/.readme/README-es.md)
 - [日本語 [ja]](http://project.autojs6.com/blob/master/.readme/README-ja.md)
 - [한국어 [ko]](http://project.autojs6.com/blob/master/.readme/README-ko.md)
 - [Русский [ru]](http://project.autojs6.com/blob/master/.readme/README-ru.md)
 - [العربية [ar]](http://project.autojs6.com/blob/master/.readme/README-ar.md)

******

### 简介

******

[Auto.js](https://github.com/hyb1996/Auto.js) 是一款 Android 平台支持 [无障碍服务](https://developer.android.com/guide/topics/ui/accessibility/service?hl=zh-cn) 的 JavaScript 自动化工具软件.

Auto.js 由 [hyb1996](https://github.com/hyb1996) 于 `2017/01/27` 初次发布, 于 `2020/03/13` 停止维护, 最终版本名称为 `4.1.1 Alpha2`, 构建版本号为 `461`.

AutoJs6 在 Auto.js 最终项目的基础上, 于 `2021/12/01` 进行二次开发, 继续保持开源免费.

下表列举了部分 Auto.js 相关项目 (按开发日期排序):

| <span style="word-break:keep-all;white-space:nowrap">项目</span> |                                                             <span style="word-break:keep-all;white-space:nowrap">应用名称</span>                                                              | <span style="word-break:keep-all;white-space:nowrap">开发者</span> | <span style="word-break:keep-all;white-space:nowrap">开发日期</span> | <span style="word-break:keep-all;white-space:nowrap">终止开发日期</span> |
|:------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------:|:---------------------------------------------------------------------------------------------------------------------------------:|:-------------------------------------------------------------------------------------------------------------------------------:|
|     <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/hyb1996/Auto.js)</span>      |    <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/TonyJiangWJ/Auto.js/commit/268ec8895bbfa28fc7715154eb15b1c1eaaefd14#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span>     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2017/01/27`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2020/03/13`</span>                             |
|                     <span style="word-break:keep-all;white-space:nowrap">Auto.js Pro 7</span>                      |                                                                                     <span style="word-break:keep-all;white-space:nowrap">Auto.js</span>                                                                                      |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2019/03/13`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2019/07/08`</span>                             |
|                     <span style="word-break:keep-all;white-space:nowrap">Auto.js Pro 8</span>                      |                                                                                    <span style="word-break:keep-all;white-space:nowrap">AutoJsPro</span>                                                                                     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2019/10/13`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2021/07/24`</span>                             |
|   <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/TonyJiangWJ/Auto.js)</span>    | <span style="word-break:keep-all;white-space:nowrap">[Auto.js&#160;M](https://github.com/TonyJiangWJ/Auto.js/commit/268ec8895bbfa28fc7715154eb15b1c1eaaefd14#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span> |      <span style="word-break:keep-all;white-space:nowrap">[TonyJiangWJ](https://github.com/TonyJiangWJ)</span>       |                             <span style="word-break:keep-all;white-space:nowrap">`2019/11/21`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|      <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/kkevsekk1/AutoX)</span>       |                 <span style="white-space:pre">[Autox.js](https://github.com/kkevsekk1/AutoX/commit/8143e4ed893d4af05d22aa791b83a962f9959873#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span>                  |        <span style="word-break:keep-all;white-space:nowrap">[kkevsekk1](https://github.com/kkevsekk1)</span>         |                             <span style="word-break:keep-all;white-space:nowrap">`2020/07/24`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|        <span style="word-break:keep-all;white-space:nowrap">[Auto.js Pro 9](https://pro.autojs.org/)</span>        |                                                                                    <span style="word-break:keep-all;white-space:nowrap">AutoJsPro</span>                                                                                     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2021/03/28`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2023/02/09`</span>                             |
| <span style="word-break:keep-all;white-space:nowrap">[AutoJs6](https://github.com/SuperMonster003/AutoJs6)</span>  |  <span style="word-break:keep-all;white-space:nowrap">[AutoJs6](https://github.com/SuperMonster003/AutoJs6/commit/a8ce1b9acb541e9736c33134be3194c3148a15a3#diff-833a46a97033e77558372a2dce103fd6fee29aaaa899f610022a7aece592ee7bR27)</span>  |  <span style="word-break:keep-all;white-space:nowrap">[SuperMonster003](https://github.com/SuperMonster003)</span>   |                             <span style="word-break:keep-all;white-space:nowrap">`2021/12/01`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|      <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/kkevsekk1/AutoX)</span>       |            <span style="white-space:pre">[Autox.js&#160;v6](https://github.com/kkevsekk1/AutoX/commit/8b6776cff8b0fca4be4a52719b7d7d07c0a058f3#diff-51a0b488f963eb0be6c6599bf5df497313877cf5bdff3950807373912ac1cdc9R130)</span>             |           <span style="word-break:keep-all;white-space:nowrap">[wilinz](https://github.com/wilinz)</span>            |                             <span style="word-break:keep-all;white-space:nowrap">`2022/05/26`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|        <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/aiselp/AutoX)</span>        |              <span style="white-space:pre">[Autox.js&#160;v7](https://github.com/aiselp/AutoX/commit/484491fd5fe12b8203d0b09c181eb0f471c0ea9f#diff-8cff73265af19c059547b76aca8882cbaa3209291406f52df1dafbbc78e80c46R120)</span>              |           <span style="word-break:keep-all;white-space:nowrap">[aiselp](https://github.com/aiselp)</span>            |                             <span style="word-break:keep-all;white-space:nowrap">`2024/04/21`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |

表格中的日期为预估值, 实际可能存在出入.

表格中 Auto.js Pro 7/8/9 为付费版本, 其余为免费开源版本.

******

### 功能

******

* 可用作 JavaScript IDE (代码补全/变量重命名/代码格式化)
* 支持基于 [无障碍服务](https://developer.android.com/reference/android/accessibilityservice/AccessibilityService) 的自动化操作
* 支持浮动按钮快捷操作 (脚本录制及运行/查看包名及活动/布局分析)
* 支持选择器 API 并提供控件遍历/获取信息/控件操作 (类似 [UiAutomator](https://developer.android.com/training/testing/ui-automator))
* 支持布局界面分析 (类似 Android Studio 的 LayoutInspector)
* 支持录制功能及录制回放
* 支持屏幕截图/保存截图/图片找色/图片匹配
* 支持 [E4X](https://zh.wikipedia.org/wiki/E4X) (ECMAScript for XML) 编写界面
* 支持将脚本文件或项目打包为 APK 文件
* 支持利用 Root 权限扩展功能 (屏幕点击/滑动/录制/Shell)
* 支持作为 Tasker 插件使用
* 支持与 VSCode 连接并进行桌面开发 (需要 [AutoJs6-VSCode-Extension](http://vscext-project.autojs6.com) 插件)

******

### 环境

******

- Android 操作系统
- [API](https://developer.android.com/guide/topics/manifest/uses-sdk-element#ApiLevels) [24](https://developer.android.com/reference/android/os/Build.VERSION_CODES#N) ([7.0](https://zh.wikipedia.org/wiki/Android_Nougat)) [[N](https://developer.android.com/reference/android/os/Build.VERSION_CODES#N)] 及以上

******

### 指南

******

* [应用文档](https://docs.autojs6.com)
* [使用手册 (待编写)](https://docs.autojs6.com/#/manual)
* [疑难解答](https://docs.autojs6.com/#/qa)
* [项目编译构建](#project-compilation-and-build)
* [脚本开发辅助](#script-development-assistance)

******

### 主要变更

******

相较于 Auto.js 最终开源版本 `4.1.1 Alpha2`, AutoJs6 主要进行了以下升级或变更:

* 支持通过 [Shizuku](https://shizuku.rikka.app/introduction/) 获得 ADB 特权并使用系统 API
* 支持构建 [WebSocket](https://docs.autojs6.com/#/webSocketType) 实例以完成基于 [WebSocket 协议](https://zh.wikipedia.org/wiki/WebSocket) 的网络请求
* 新增模块 [ [base64](https://docs.autojs6.com/#/base64) / [crypto](https://docs.autojs6.com/#/crypto) / [sqlite](https://docs.autojs6.com/#/sqlite) / [i18n](https://docs.autojs6.com/#/i18n) / [notice](https://docs.autojs6.com/#/notice) / [ocr](https://docs.autojs6.com/#/ocr) / [opencc](https://docs.autojs6.com/#/opencc) / [qrcode](https://docs.autojs6.com/#/qrcode) / [shizuku](https://docs.autojs6.com/#/shizuku) / ... ]
* 多语言适配 [ 西 / 法 / 俄 / 阿 / 日 / 韩 / 英 / 简中 / 繁中 / ... ]
* 主题色适配 [ 分组 / 定位 / 搜索 / 历史记录 / 亮度及对比度自动适配 / ... ]
* 夜间模式适配 [ 设置页面 / 文档页面 / 布局分析页面 / 浮动窗口 / ... ]
* [VSCode 插件](http://vscext-project.autojs6.com) 支持客户端 (LAN) 及服务端 (LAN/ADB) 连接方式
* [Rhino](https://github.com/mozilla/rhino/) 引擎由 [v1.7.7.2](https://github.com/mozilla/rhino/releases/tag/Rhino1_7_7_2_Release) 升级至 [v1.8.1-SNAPSHOT](http://rhino.autojs6.com/blob/master/gradle.properties#L3)
    * Unicode [码位](https://developer.mozilla.org/zh-CN/docs/Glossary/Code_point) 转义支持 [辅助平面](https://zh.wikipedia.org/wiki/Unicode%E5%AD%97%E7%AC%A6%E5%B9%B3%E9%9D%A2%E6%98%A0%E5%B0%84#%E7%AC%AC%E4%B8%80%E8%BC%94%E5%8A%A9%E5%B9%B3%E9%9D%A2) 字符
       ```javascript
       '\u{1D160}'; /* 表示 "𝅘𝅥𝅮", 传统方式: '\uD834\uDD60'. */
       ```
    * 支持 [Object.values()](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Global_Objects/Object/values)
       ```javascript
       Object.values({name: 'Max', age: 4}); // ['max', 4]
       ```
    * 支持 [Array.prototype.includes()](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Global_Objects/Array/includes)
       ```javascript
       [10, 20, NaN].includes(20); // true
       ```
    * 支持 [BigInt](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Global_Objects/BigInt)
       ```javascript
       typeof 567n === 'bigint'; // true
       ```
    * 支持 [模板字符串](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Template_literals)
       ```javascript
       `Lucky number: ${(Math.random() * 100).toFixed(0)}`
       ```
    * 查看 Rhino 引擎 [更多新特性](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/RHINO.md)
    * 查看 Rhino 引擎 [兼容性列表](https://mozilla.github.io/rhino/compat/engines.html)

******

### 版本历史

******

# v6.6.4

###### 2025/05/31

* `提示` API 变更: ui.(status/navigation)BarAppearanceLight[By] -> ui.(status/navigation)BarIconLight[By]
* `新增` util.dpToPx/spToPx/pxToDp/pxToSp 方法, 用于像素单位转换
* `修复` 屏幕旋转至横向时子标题可能显示不完整的问题
* `修复` 屏幕旋转至横向时部分页面内容被侧边导航栏遮挡的问题
* `修复` Android 15 部分页面状态栏背景着色区域不完整的问题 _[`issue #398`](http://issues.autojs6.com/398)_
* `修复` 代码编辑器可能使用置信度不足的编码写入文件导致内容解码异常的问题 (试修)
* `优化` 关于应用与开发者页面增加布局适配通用性并去除不必要的布局分类
* `优化` README.md 项目编译构建小节添加多种方式便于定位目标设置页面 _[`issue #404`](http://issues.autojs6.com/404)_
* `优化` 部分依赖或本地库版本调整 _[`CHANGELOG.md`](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG.md#v664)_

# v6.6.3

###### 2025/05/27

* `新增` 版本历史功能, 可查看发行版本历史更新记录 (多语言) 与统计数据
* `新增` timers.keepAlive 方法 (已全局化), 用于保持脚本活跃状态
* `新增` engines.on('start/stop/error', callback) 等事件监听方法, 用于监听脚本引擎全局事件
* `新增` images.detectMultiColors 方法, 用于多点颜色校验 _[`issue #374`](http://issues.autojs6.com/374)_
* `新增` images.matchFeatures/detectAndComputeFeatures 方法, 支持全分辨率找图 (Ref to [Auto.js Pro](https://g.pro.autojs.org/)) _[`issue #366`](http://issues.autojs6.com/366)_
* `新增` images.compressToBytes 方法, 用于压缩图像并生成字节数组
* `新增` images.downsample 方法, 用于像素降采样并生成新的 ImageWrapper
* `新增` ui.keepScreenOn 方法, 用于 UI 页面获取焦点时保持设备屏幕常亮
* `新增` ui.root 属性 (getter), 用于获取 UI 页面布局的 "窗口内容根容器" 节点
* `新增` webview 元素支持基于 JsBridge 的 Web 页面布局 (Ref to [Auto.js Pro](https://g.pro.autojs.org/)) [参阅 示例代码 > 布局 > 可交互 HTML / Vue2 + Vant (SFC)] _[`issue #281`](http://issues.autojs6.com/281)_
* `修复` 主页文档标签及文档活动页面显示在线文档时部分内容被系统导航栏遮挡的问题
* `修复` 部分页面 Toolbar 点击按钮时可能导致标题点击事件误触发的问题
* `修复` 部分设备代码编辑器空行显示方框字符的问题
* `修复` 主题色设置页面调色盘对话框可能无限叠加的问题
* `修复` 无障碍服务关闭时音量加键停止所有脚本功能失效的问题
* `修复` 定时任务页面编辑自定义广播内容时出现的输入法遮挡问题
* `修复` webview 元素中的控件无法正常激活输入法软键盘的问题
* `修复` APK 文件类型信息对话框可能无法获取应用名称及 SDK 信息的问题
* `修复` 文件管理器示例代码进入项目目录时可能无法自动加载子目录文件内容的问题
* `修复` Android 15 UI 模式顶部内容被状态栏覆盖的问题
* `修复` Android 15 部分页面状态栏背景颜色可能无法动态跟随主题色的问题
* `修复` dialogs 模块无法正常使用 customView 属性的问题 _[`issue #364`](http://issues.autojs6.com/364)_
* `修复` dialogs.input 方法的表达式参数可能无法获得执行结果的问题
* `修复` 使用 JavaAdapter 时导致 ClassLoader 调用栈溢出的问题 _[`issue #376`](http://issues.autojs6.com/376)_
* `修复` console.setContentTextColor 方法导致日志字体颜色丢失默认值的问题 _[`issue #346`](http://issues.autojs6.com/346)_
* `修复` console.setContentBackgroundColor 方法无法接受颜色名称参数的问题 _[`issue #384`](http://issues.autojs6.com/384)_
* `修复` images.compress 方法实现原理由像素降采样修正为编码质量变化
* `修复` images.resize 方法无法正常使用的问题
* `修复` engines.all 方法可能触发 ConcurrentModificationException 的问题 _[`issue #394`](http://issues.autojs6.com/394)_
* `修复` README.md 中部分语言日期格式不正确的问题
* `修复` Gradle 构建脚本可能因获取到无效库档案文件长度而导致构建失败的问题 _[`issue #389`](http://issues.autojs6.com/389)_
* `优化` 布局分析支持控件隐藏 (by [TonyJiangWJ](https://github.com/TonyJiangWJ)) _[`pr #371`](http://pr.autojs6.com/371)_ _[`issue #355`](http://issues.autojs6.com/355)_
* `优化` 布局分析菜单添加渐变分隔线实现一定程度的功能分组
* `优化` 脚本项目配置文件 project.json 支持 permissions 选项 (by [wirsnow](https://github.com/wirsnow)) _[`pr #391`](http://pr.autojs6.com/391)_ _[`issue #362`](http://issues.autojs6.com/362)_
* `优化` 打包单文件时自动读取并勾选已安装应用的声明权限 _[`issue #362`](http://issues.autojs6.com/362)_
* `优化` 主题色扩充适配范围并支持更多控件类型
* `优化` 主页抽屉在横向屏幕或超宽屏幕的宽度适应性
* `优化` 关于应用与开发者页面增加水平布局及小屏布局适配
* `优化` 设置页面对话框相关设置支持 "使用默认值" 菜单选项
* `优化` 文件管理器浮动按钮展开后点击其他区域可自动隐藏
* `优化` 代码编辑器格式化代码支持 `??`, `?.`, `??=` 等运算符
* `优化` 代码编辑器支持 GB18030 / UTF-16 (LE/BE) / Shift_JIS 等编码的文件读写
* `优化` 代码编辑器支持显示文件详细信息 (路径/编码/换行符/字节及字符总数等) _[`issue #395`](http://issues.autojs6.com/395)_
* `优化` 意图相关操作 (编辑/查看/安装/发送/播放等) 增加操作异常提示
* `优化` webview 元素的 url 属性支持相对路径
* `优化` ImageWrapper#saveTo 方法的路径参数支持相对路径
* `优化` images.save 方法使用 quality 参数时支持 png 格式的文件体积压缩 _[`issue #367`](http://issues.autojs6.com/367)_
* `优化` 已忽略更新记录及客户端模式连接地址记录支持清空操作
* `优化` 版本更新信息支持多语言显示 (与当前显示语言同步)
* `优化` 使用异步加载方式一定程度提升文件管理器列表滑动流畅性
* `优化` 脚本异常消息在控制台的显示内容与格式
* `优化` 示例代码支持将文件夹重置为初始内容
* `优化` APK 文件签名信息提升检测效率
* `优化` APK 文件类型信息及媒体文件类型信息优化对话框显示效率及信息展示逻辑
* `优化` Gradle 构建脚本提升版本自适应能力 _[`discussion #369`](http://discussions.autojs6.com/369)_
* `优化` 部分依赖或本地库版本调整 _[`CHANGELOG.md`](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG.md#v663)_

# v6.6.2

###### 2025/04/16

* `新增` ui.statusBarAppearanceLight/statusBarAppearanceLightBy/navigationBarColor 等方法
* `新增` ui.statusBarHeight 属性 (getter), 用于获取状态栏高度 _[`issue #357`](http://issues.autojs6.com/357)_
* `新增` images.flip 方法, 用于图像翻转 _[`issue #349`](http://issues.autojs6.com/349)_
* `新增` 设置页面增加 "文件扩展名" 设置选项
* `新增` 主题色设置页面增加新布局支持 (分组/定位/搜索/历史记录/调色盘增强等)
* `修复` Android 15 状态栏背景颜色与主题色不一致的问题
* `修复` plugins.load 方法无法正常加载插件的问题 _[`issue #290`](http://issues.autojs6.com/290)_
* `修复` dx 库在 Android 7.x 无法正常使用的问题 _[`issue #293`](http://issues.autojs6.com/293)_
* `修复` ScriptRuntime 使用 require 引用内置模块时可能出现的同步状态异常 (试修) _[`issue #298`](http://issues.autojs6.com/298)_
* `修复` notice 模块缺失 getBuilder 等扩展方法的问题 _[`issue #301`](http://issues.autojs6.com/301)_
* `修复` shizuku/shell 等方法无法接受字符串参数的问题 _[`issue #310`](http://issues.autojs6.com/310)_
* `修复` colors.pixel 方法无法接受单通道图像参数的问题 _[`issue #350`](http://issues.autojs6.com/350)_
* `修复` engines.execScript/execScriptFile 等方法执行脚本时默认工作路径异常 _[`issue #358`](http://issues.autojs6.com/358)_ _[`issue #340`](http://issues.autojs6.com/340)_ _[`issue #339`](http://issues.autojs6.com/339)_
* `修复` floaty.window/floaty.rawWindow 无法在子线程执行的问题
* `修复` floaty.getClip 可能无法正常获取剪切板内容的问题 _[`issue #341`](http://issues.autojs6.com/341)_
* `修复` ui.inflate 返回值丢失 attr/on/click 等原型方法的问题
* `修复` 使用 XML 语法将 JavaScript 表达式作为属性值时, 其作用域上下文绑定错误的问题 _[`issue #319`](http://issues.autojs6.com/319)_
* `修复` 部分方法调用出现异常时无法被 try..catch 块捕获的问题 _[`issue #345`](http://issues.autojs6.com/345)_
* `修复` 布局分析页面生成代码时可能导致应用崩溃的问题 _[`issue #288`](http://issues.autojs6.com/288)_
* `修复` 打包应用无法正常使用 shizuku 模块的问题 _[`issue #227`](http://issues.autojs6.com/227)_ _[`issue #231`](http://issues.autojs6.com/231)_ _[`issue #284`](http://issues.autojs6.com/284)_ _[`issue #287`](http://issues.autojs6.com/287)_ _[`issue #304`](http://issues.autojs6.com/304)_
* `修复` 代码编辑器跳转到行尾时可能跳转到下一行起始位置的问题
* `修复` 设置页面连续快速点击对话框类型项目时可能导致应用崩溃的问题
* `优化` 精简打包应用模板 APK 文件大小
* `优化` 应用 (以及打包应用) 支持更多权限 _[`issue #338`](http://issues.autojs6.com/338)_
* `优化` 打包页面支持 Pinyin 库选项
* `优化` 打包应用主活动页面优化状态栏背景及文字颜色
* `优化` 打包应用设置页面增加访问所有文件和发送通知等特殊权限开关 _[`issue #354`](http://issues.autojs6.com/354)_
* `优化` 控件的文字及图标根据主题色亮度值自动切换合适的颜色
* `优化` 部分控件主题色与背景色对比度过低时的视觉体验
* `优化` 调色盘 HEX 输入控件增强剪贴板粘贴色值时的兼容性
* `优化` 应用内页面导航栏设置为透明或半透明以增强视觉体验
* `优化` UI 模式状态栏及导航栏默认为 `md_grey_50` 色值且设置为亮色模式
* `优化` 主页抽屉无障碍服务开关支持与脚本代码同步
* `优化` 主页文档页面搜索时支持双向查找按钮
* `优化` 主页 "文件" 标签支持通过长按切换浮动按钮可见状态
* `优化` 代码编辑器标题文字支持字体大小自适应
* `优化` 日志页面浮动按钮可见状态与列表滚动操作联动
* `优化` 脚本项目配置文件 project.json 支持更多打包选项 _[`issue #305`](http://issues.autojs6.com/305)_ _[`issue #306`](http://issues.autojs6.com/306)_
* `优化` 脚本项目配置文件 project.json 支持选项名称宽松匹配及别名兼容
* `优化` APK 文件类型信息对话框增加文件大小与签名方案信息
* `优化` APK 文件类型信息对话框增加点击监听器支持文本复制与应用详情跳转
* `优化` 尝试恢复 com.stardust 前缀包以便提升代码兼容性 _[`issue #290`](http://issues.autojs6.com/290)_
* `优化` floaty.window/floaty.rawWindow 同时支持主线程和子线程执行
* `优化` getClip 全局方法适时借助 floaty.getClip 方法以提升兼容性
* `优化` files.path 及相关方法传入空值路径参数时的兼容性
* `优化` 同步最新的 Rhino 引擎官方上游代码并进行必要的代码适配
* `优化` README.md 完善项目构建与运行相关内容 _[`issue #344`](http://issues.autojs6.com/344)_
* `优化` 部分依赖或本地库版本调整 _[`CHANGELOG.md`](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG.md#v662)_

##### 更多版本历史可参阅

* [CHANGELOG.md](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG-zh-Hans.md)

******

### <a id="project-compilation-and-build"></a>项目编译构建

******

如需对 AutoJs6 开源项目进行调试或开发, 可使用 [Android Studio](https://pro.autojs.org/) ([Google](https://www.google.com/) 公司产品) 或 [IntelliJ IDEA](https://www.jetbrains.com/idea/) ([Jetbrains](https://www.jetbrains.com/) 公司产品).

本小节以 Android Studio 为例介绍 AutoJs6 开源项目的编译构建方法, IntelliJ IDEA 与之类似.

#### Android Studio 准备

下载 `Android Studio Meerkat Feature Drop | 2024.3.2 Patch 1` 版本 (按需选择其一):

- [android-studio-2024.3.2.15-windows.exe](https://redirector.gvt1.com/edgedl/android/studio/install/2024.3.2.15/android-studio-2024.3.2.15-windows.exe) (1.23 GB)
- [android-studio-2024.3.2.15-windows.zip](https://redirector.gvt1.com/edgedl/android/studio/ide-zips/2024.3.2.15/android-studio-2024.3.2.15-windows.zip) (1.23 GB)

> 注: 上述版本发布时间为 2025 年 5 月 28 日. 如需下载其他版本, 或上述链接已失效, 可访问 [Android Studio 发行版本归档](https://developer.android.com/studio/archive?hl=en) 页面.

安装或解压上述文件, 运行 Android Studio 软件 (如 `"D:\android-studio\bin\studio64.exe"`).

#### Android SDK 准备

> 注: 如果计算机系统已安装 Android SDK (安卓软件开发工具包), 则可跳过此小节内容.

打开 `Android SDK (安卓软件开发工具包)` 设置页面 (任选一种方式):

```text
Help (帮助) | Find action (查找操作) # 输入 "Android SDK"
[ 或 ]
File (文件) | Settings (设置) # 搜索 "Android SDK"
[ 或 ]
File (文件) | Settings (设置) | Language & Frameworks (语言和框架) | Android SDK (安卓软件开发工具包)
[ 或 ]
File (文件) | Settings (设置) | Appearance & Behavior (外观与行为) | System Settings (系统设置) | Android SDK (安卓软件开发工具包)
```

`Android SDK Location (安卓软件开发工具包位置)` 处如果是空白内容, 可点击右侧 `Edit (编辑)` 按钮, 在弹出的窗口中多次点击 `Next (下一步)`.

> 注: 过程中可能需要同意一个或多个相关协议才能继续.

待相关资源下载并安装完毕, 点击 `Finish (完成)` 按钮.  
上述 `Android SDK Location (安卓软件开发工具包位置)` 处将自动完成路径填写, SDK 准备工作随即完成.

#### Android SDK Tools 准备

AutoJs6 需要使用部分 SDK 工具 (如 NDK 及 CMake).

> 注: 如果计算机系统已安装 AutoJs6 全部所需的 Android SDK Tools, 则可跳过此小节内容.

打开 `SDK Tools (SDK 工具)` 设置页面 (任选一种方式):

```text
Help (帮助) | Find action (查找操作) # 输入 "SDK Tools"
[ 或 ]
File (文件) | Settings (设置) # 搜索 "SDK Tools"
[ 或 ]
File (文件) | Settings (设置) | Language & Frameworks (语言和框架) | Android SDK (安卓软件开发工具包) | SDK Tools (SDK 工具) (位于右侧窗口)
[ 或 ]
File (文件) | Settings (设置) | Appearance & Behavior (外观与行为) | System Settings (系统设置) | Android SDK (安卓软件开发工具包) | SDK Tools (SDK 工具) (位于右侧窗口) 
```

勾选 `Show Package Details (显示包详情)`, 依次点击 NDK 及 CMake, 确保相应版本的工具已勾选, SDK 工具的版本信息位于 AutoJs6 项目根目录的 `version.properties` 文件中.

#### JDK 准备

AutoJs6 项目依赖的 `JDK (Java 开发工具包)` 发行版本不低于 `17`, 但建议不低于 `19`.

截至 2025 年 5 月 31 日, AutoJs6 可支持 JDK 最高版本为 `24`.

> 注: 如果计算机系统已安装 JDK 且版本满足上述要求, 则可跳过此小节内容.

JDK 可使用 IDE 直接下载, 或访问 [Oracle 网站](https://www.oracle.com/java/technologies/downloads/) 下载.

打开 `Gradle JDK` 设置页面 (任选一种方式):

```text
Help (帮助) | Find action (查找操作) # 输入 "Gradle JDK"
[ 或 ]
File (文件) | Settings (设置) # 搜索 "Gradle"
[ 或 ]
File (文件) | Settings (设置) | Build, Execution, Deployment (构建, 执行, 部署) | Build Tools (构建工具) | Gradle
```

`Gradle JDK` 处可选择或添加不同版本的 JDK.

如果列表中已存在合适版本的 JDK (>= `17`), 则直接选择即可.  
否则可以选择 `Download JDK (下载 JDK)` 下载合适的 JDK, 点击 `Download (下载)` 按钮并等待下载完成.  
也可以选择 `Add JDK (添加 JDK)` 添加已存在的本地 JDK, 定位其目录并完成 JDK 添加.

#### AutoJs6 资源克隆

在 Android Studio 主页面点击 `Get from VCS (从版本控制系统获取)` 按钮.  
`URL (统一资源定位地址)` 处填入 `https://github.com/SuperMonster003/AutoJs6.git`,  
`Directory (目录)` 处可根据需要修改为特定路径.  
点击 `Clone (克隆)` 按钮, 等待 AutoJs6 项目资源在设备本地完成克隆.

> 注: 上述过程可能需要安装 [Git (分布式版本控制系统)](https://git-scm.com/download).

#### AutoJs6 项目构建

克隆完成后, Android Studio 将打开 AutoJs6 的项目窗口, 并自动完成初步的 `Dependencies (依赖)` 下载及 Gradle 构建工作.

> 注: 上述过程可能非常耗时. 若网络条件欠佳, 可能需要重试多次 (点击 Retry 按钮).

如果构建未能自动进行, 或需要再次构建项目, 可执行以下步骤:

- 在 `Toolbar (工具栏)` 中, 从 `Run/Debug Configurations (运行/调试配置)` 菜单中选择 `app`, 这是 AutoJs6 的主应用
- 点击左侧的 `Build Project (构建项目)` 按钮 (形如铁锤) 开始构建项目, 默认快捷键为 CTRL + F9
- 等待构建完成, `Builder Output (构建输出)` 标签页将出现类似 "BUILD SUCCESSFUL in 1h 17m 34s" 的消息

如果构建失败, 可将异常消息反馈到 AutoJs6 项目的 [议题 (Issues)](http://issues.autojs6.com) 页面.

> 注: 关于如何构建并运行应用的更多内容, 可参阅 [Android Docs](https://developer.android.com/studio/run?hl=zh-cn)

#### AutoJs6 项目部署 (运行 App)

项目构建成功后, 可将项目作为应用程序 (简称 App) 部署到实体设备 (如手机/平板电脑) 或虚拟设备 (如 Android 模拟器) 中.

- 在 `Toolbar (工具栏)` 中, 从 `Run/Debug Configurations (运行/调试配置)` 菜单中选择 `app`, 这是 AutoJs6 的主应用
- 在右侧 `Available Devices (可用设备)` 菜单中, 选择需要运行项目 App 的设备 (实体设备或虚拟设备)
- 点击右侧的 `Run (运行)` 按钮 (形如三角形) 开始运行项目, 默认快捷键为 `F10`
- 等待部署完成, 指定设备将自动安装并运行项目 App

#### AutoJs6 项目部署 (生成 APK)

打包项目并生成可安装到安卓设备的 APK 文件:

- 调试版 (Debug Version)
    - `Build (构建)` | `Build Bundle(s) / APK(s)` | `Build APK(s)`
    - 生成带默认签名的调试版安装包
    - 路径示例: `"D:\AutoJs6\app\build\outputs\apk\debug\"`
- 发布版 (Release Version)
    - `Build (构建)` | `Generate Signed Bundle / APK`
    - 选择 `APK` 选项
    - 准备好签名文件 (新建或选取), 生成已签名的发布版安装包
    - 路径示例: `"D:\AutoJs6\app\release\"`

> 注: 关于如何构建应用以向用户发布的更多内容, 可参阅 [Android Docs](https://developer.android.com/build/build-for-release?hl=zh-cn)

#### AutoJs6 预置 Gradle 构建任务

除了构建项目 App 之外, AutoJs6 还支持一些预置的 Gradle 构建任务, 这些任务可以帮助开发者完成与项目相关的便捷操作.

在 `Toolbar (工具栏)` 的 `Run/Debug Configurations (运行/调试配置)` 菜单中, 可看到各个 Gradle 预置任务, 每个任务左侧均显示带小象图标的任务标识.

- AutoJs6 [inrt:assemble]

组装 "inrt" 构建变体, 主要服务于 AutoJs6 脚本打包功能.

AutoJs6 项目拥有不同的构建变体, 其中 "inrt" 变体用于实现 AutoJs6 的脚本打包功能, 生成打包功能依赖的模板文件 "template.apk".

使用打包功能时可能会出现以下异常消息:

> java.io.FileNotFoundException: template.apk

这表明模板文件不存在, 需要手动运行一次 `inrt:assemble` 任务, 生成模板文件, 然后再次构建并部署 App.

> 注: 当主项目代码发生变更, 且希望将变更同步到打包应用时, 需要重新运行 `inrt:assemble` 任务生成模板文件并再次部署 App

- AutoJs6 [app:bundle]

打包 debug 版本编译过程产物, 主要服务于 [AutoJs6 声明文件](http://dts-project.autojs6.com) 项目.

任务运行后生成一个 AutoJs6 项目最新的 JAR 文件, 利用 [Android d.ts Generator](https://github.com/NativeScript/android-dts-generator) (by [NativeScript](https://github.com/NativeScript)) 工具可生成 AutoJs6 主应用的声明文件 (d.ts 格式).

- AutoJs6 [app:digest]

附加摘要信息到 release 版本编译产生的 APK 文件, 主要服务于 AutoJs6 发布最新版本到 GitHub 前确定最终的文件名.

以下为附加摘要信息前后的文件名对比:

```text
前:
autojs6-v6.6.2-arm64-v8a.apk
后:
autojs6-v6.6.2-arm64-v8a-0f2a9d74.apk
```

> 参阅: [Android Docs](https://developer.android.com/studio/run?hl=zh-cn)

******

### <a id="script-development-assistance"></a>脚本开发辅助

******

开发 AutoJs6 可运行的脚本, 需使用合适的开发工具:

- [VSCode](https://code.visualstudio.com/download) / [WebStorm](https://www.jetbrains.com/webstorm/download/) / [HBuilderX](https://www.dcloud.io/hbuilderx.html) ...

如需在 PC 上进行脚本编写与调试, VSCode 插件可以实现 PC 与手机的互联:

- [AutoJs6-VSCode-Extension](http://vscext-project.autojs6.com) - AutoJs6 调试器 (VSCode 平台插件)

使用开发工具编写代码时, 代码智能补全功能可以更好地辅助开发者完成代码编写:

- [AutoJs6-TypeScript-Declarations](http://dts-project.autojs6.com) - AutoJs6 声明文件 (代码智能补全)

编写代码时, AutoJs6 相关 API 及使用方式, 可随时查阅应用文档:

- [AutoJs6-Documentation](http://docs-project.autojs6.com) - AutoJs6 应用文档

现有的脚本开发项目可作为参考, 激发个人脚本项目的创作灵感:

- [Ant-Forest](https://github.com/TonyJiangWJ/Ant-Forest) - 蚂蚁森林能量自动收取脚本 by [TonyJiangWJ](https://github.com/TonyJiangWJ)
- [Ant-Forest](https://github.com/SuperMonster003/Ant-Forest) - 蚂蚁森林能量自动收取脚本 by [SuperMonster003](https://github.com/SuperMonster003)
- [autojs](https://github.com/e1399579/autojs) - Auto.js 实用脚本 by  [e1399579](https://github.com/e1399579)
- [autojsDemo](https://github.com/snailuncle/autojsDemo) - Auto.js 演示示例 by  [snailuncle](https://github.com/snailuncle)
- [autojs 相关仓库](https://github.com/topics/autojs) - GitHub 与 autojs 话题相关的全部仓库

******

### 贡献参与

******

感谢每一位参与 AutoJs6 项目开发的贡献人员.

|         <span style="word-break:keep-all;white-space:nowrap">贡献人员</span>          |                   <span style="word-break:keep-all;white-space:nowrap">提交数</span>                    | <span style="word-break:keep-all;white-space:nowrap">最近提交</span> |
|:-------------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------:|
|             <span style="word-break:keep-all;white-space:nowrap">[wirsnow](https://github.com/wirsnow)</span>             |         <span style="word-break:keep-all;white-space:nowrap">[1](https://github.com/SuperMonster003/AutoJs6/commits?author=wirsnow)</span>         |                    <span style="word-break:keep-all;white-space:nowrap">`2025/05/19`</span>                    |
|         <span style="word-break:keep-all;white-space:nowrap">[TonyJiangWJ](https://github.com/TonyJiangWJ)</span>         |       <span style="word-break:keep-all;white-space:nowrap">[5](https://github.com/SuperMonster003/AutoJs6/commits?author=TonyJiangWJ)</span>       |                    <span style="word-break:keep-all;white-space:nowrap">`2025/04/24`</span>                    |
|          <span style="word-break:keep-all;white-space:nowrap">[luckyloogn](https://github.com/luckyloogn)</span>          |       <span style="word-break:keep-all;white-space:nowrap">[3](https://github.com/SuperMonster003/AutoJs6/commits?author=luckyloogn)</span>        |                    <span style="word-break:keep-all;white-space:nowrap">`2025/01/01`</span>                    |
|                <span style="word-break:keep-all;white-space:nowrap">[kvii](https://github.com/kvii)</span>                |          <span style="word-break:keep-all;white-space:nowrap">[1](https://github.com/SuperMonster003/AutoJs6/commits?author=kvii)</span>           |                    <span style="word-break:keep-all;white-space:nowrap">`2024/10/16`</span>                    |
|   <span style="word-break:keep-all;white-space:nowrap">[chenguangming](https://github.com/chenguangming) `(Tom)`</span>   | <span style="word-break:keep-all;white-space:nowrap">[2](https://github.com/SuperMonster003/AutoJs6/pulls?q=is%3Apr+author%3Achenguangming)</span> |                    <span style="word-break:keep-all;white-space:nowrap">`2024/05/14`</span>                    |
|          <span style="word-break:keep-all;white-space:nowrap">[LZX284](https://github.com/LZX284) `(AI)`</span>           |         <span style="word-break:keep-all;white-space:nowrap">[17](https://github.com/SuperMonster003/AutoJs6/commits?author=LZX284)</span>         |                    <span style="word-break:keep-all;white-space:nowrap">`2023/11/19`</span>                    |
| <span style="word-break:keep-all;white-space:nowrap">[little&#x2011;alei](https://github.com/little-alei) `(抠脚本人)`</span> |      <span style="word-break:keep-all;white-space:nowrap">[12](https://github.com/SuperMonster003/AutoJs6/commits?author=little-alei)</span>       |                    <span style="word-break:keep-all;white-space:nowrap">`2023/07/12`</span>                    |
|              <span style="word-break:keep-all;white-space:nowrap">[aiselp](https://github.com/aiselp)</span>              |    <span style="word-break:keep-all;white-space:nowrap">[6](https://github.com/SuperMonster003/AutoJs6/pulls?q=is%3Apr+author%3Aaiselp)</span>     |                    <span style="word-break:keep-all;white-space:nowrap">`2023/06/14`</span>                    |
|           <span style="word-break:keep-all;white-space:nowrap">[LYS86](https://github.com/LYS86) `(Lin)`</span>           |          <span style="word-break:keep-all;white-space:nowrap">[2](https://github.com/SuperMonster003/AutoJs6/commits?author=LYS86)</span>          |                    <span style="word-break:keep-all;white-space:nowrap">`2023/06/03`</span>                    |

数据更新于 2025 年 5 月 27 日.

数据条目按 `最近提交` 降序排序.

新发起的暂未处理的 Pull Request, 将在合并处理后加入数据统计.

部分贡献人员在 [GitHub Contributors](https://github.com/SuperMonster003/AutoJs6/graphs/contributors) 未能正常出现, 其提交记录为空, 仍可通过 [Pull Request](https://github.com/SuperMonster003/AutoJs6/pulls) 查看贡献记录.

[//]: # (
    # --------------------------------------------------------------#
    # Before committing and pushing to the remote GitHub repository #
    # --------------------------------------------------------------#
    - IDE
        - The summary of the latest changelog for committing to Git [ DO NOT commit or push ]
    - $projectDir/version.properties
        - Remove the part like [ alpha / beta / ... ] of VERSION_NAME
    - $projectDir/.changelog/lang_zh-Hans.json
        - Update version name and released date
        - Translate into other languages
        - Update TypeScript declarations according to section `dependency` if needed
    - $projectDir/.readme/template_readme.md
        - Update badges like [ android studio / rhino / ... ]
        - Update contribution section: 贡献参与
    - $projectDir/.readme/common.json
        - Update android studio download links and version names
        - Update contribution section: var_date_contribution_table_data_updated
    - $projectDir/.python/generate_markdown.py
        - Re-generate markdown by running the python script [ link: aj6mdgen ]
    - Others
        - Re-generate documentation by running the python script [ link: aj6docgen ]
        - Check the two-way versions for AutoJs6 and VSCode ext, then publish the ext to Microsoft if needed
        - Run Gradle task "app:assembleInrtRelease" [ shortcut: C+A+0#- ]
        - Build APK to determine the final VERSION_BUILD field [ shortcut: C+A+0#A ]
        - Run Gradle task "app:appendDigestToReleasedFiles" [ shortcut: C+A+0#= ]
        - Check VERSION_BUILD in version.properties with released apks
        - Commit and push to GitHub
        - Publish the latest release with signed APKs
)