<!--suppress HtmlDeprecatedAttribute, HttpUrlsUsage -->

<div align="center">
  <p>
    <img src="https://s1.imagehub.cc/images/2023/03/07/af8ed087c9d354b9ab6142aae7bbafb6.png" alt="autojs6-banner_800×224" border="0" width="704" />
  </p>

  <p>안드로이드 플랫폼에서 접근성 서비스를 지원하는 JavaScript 자동화 도구</p>

  <p>
    <a href="http://download.autojs6.com"><img alt="GitHub release (latest by date)" src="https://img.shields.io/github/v/release/SuperMonster003/AutoJs6"/></a>
    <a href="http://issues.autojs6.com"><img alt="GitHub closed issues" src="https://img.shields.io/github/issues/SuperMonster003/AutoJs6?color=A24232"/></a>
    <a href="http://commit.autojs6.com/99a1d8490fac5b6d55f6f183db59ad833a2064ed"><img alt="Created" src="https://img.shields.io/date/1636632233?color=2e7d32&label=created"/></a>
    <br>
    <a href="https://github.com/mozilla/rhino"><img alt="Rhino" src="https://img.shields.io/badge/rhino-1.8.1--SNAPSHOT-795548"/></a>
    <a href="https://developer.android.com/studio/archive"><img alt="Android Studio" src="https://img.shields.io/badge/android%20studio-2022.1+-B64FC8"/></a>
    <br>
    <a href="https://www.codefactor.io/repository/github/SuperMonster003/AutoJs6"><img alt="CodeFactor Grade" src="https://www.codefactor.io/repository/github/SuperMonster003/AutoJs6/badge"/></a>
    <a href="https://www.jetbrains.com/?from=AutoJs6"><img alt="JetBrains supporter" src="https://img.shields.io/badge/supporter-JetBrains-ee4677"/></a>
    <a href="http://project.autojs6.com/blob/master/LICENSE"><img alt="GitHub License" src="https://img.shields.io/github/license/SuperMonster003/AutoJs6?color=534BAE"/></a>
  </p>
</div>

******

### 언어 (Languages)

******

현재 README.md 파일에서 지원하는 언어:

 - [简体中文 [zh-Hans]](http://project.autojs6.com/blob/master/.readme/README-zh-Hans.md)
 - [繁體中文 (香港) [zh-Hant-HK]](http://project.autojs6.com/blob/master/.readme/README-zh-Hant-HK.md)
 - [繁體中文 (台灣) [zh-Hant-TW]](http://project.autojs6.com/blob/master/.readme/README-zh-Hant-TW.md)
 - [English [en]](http://project.autojs6.com/blob/master/.readme/README-en.md)
 - [Français [fr]](http://project.autojs6.com/blob/master/.readme/README-fr.md)
 - [Español [es]](http://project.autojs6.com/blob/master/.readme/README-es.md)
 - [日本語 [ja]](http://project.autojs6.com/blob/master/.readme/README-ja.md)
 - 한국어 [ko] # 현재
 - [Русский [ru]](http://project.autojs6.com/blob/master/.readme/README-ru.md)
 - [العربية [ar]](http://project.autojs6.com/blob/master/.readme/README-ar.md)

******

### 소개

******

[Auto.js](https://github.com/hyb1996/Auto.js) Android 플랫폼에서 [접근성 서비스](https://developer.android.com/guide/topics/ui/accessibility/service?hl=zh-cn)를 지원하는 JavaScript 자동화 도구 소프트웨어입니다.

Auto.js는 [hyb1996](https://github.com/hyb1996)에 의해 `2017/01/27` 처음 출시되었으며, `2020/03/13` 에 유지보수가 중단되었고, 최종 버전 이름은 `4.1.1 Alpha2`, 빌드 버전 번호는 `461` 입니다.

AutoJs6는 Auto.js 최종 프로젝트를 기반으로 `2021/12/01` 에 다시 개발되어 계속해서 오픈 소스로 무료로 유지됩니다.

다음 표는 일부 Auto.js 관련 프로젝트를 나열한 것입니다 (개발 날짜 순으로 정렬됨):

| <span style="word-break:keep-all;white-space:nowrap">프로젝트</span> |                                                             <span style="word-break:keep-all;white-space:nowrap">앱 이름</span>                                                              | <span style="word-break:keep-all;white-space:nowrap">개발자</span> | <span style="word-break:keep-all;white-space:nowrap">개발 시작 날짜</span> | <span style="word-break:keep-all;white-space:nowrap">개발 종료 날짜</span> |
|:------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------:|:---------------------------------------------------------------------------------------------------------------------------------:|:-------------------------------------------------------------------------------------------------------------------------------:|
|     <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/hyb1996/Auto.js)</span>      |    <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/TonyJiangWJ/Auto.js/commit/268ec8895bbfa28fc7715154eb15b1c1eaaefd14#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span>     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2017/01/27`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2020/03/13`</span>                             |
|                     <span style="word-break:keep-all;white-space:nowrap">Auto.js Pro 7</span>                      |                                                                                     <span style="word-break:keep-all;white-space:nowrap">Auto.js</span>                                                                                      |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2019/03/13`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2019/07/08`</span>                             |
|                     <span style="word-break:keep-all;white-space:nowrap">Auto.js Pro 8</span>                      |                                                                                    <span style="word-break:keep-all;white-space:nowrap">AutoJsPro</span>                                                                                     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2019/10/13`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2021/07/24`</span>                             |
|   <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/TonyJiangWJ/Auto.js)</span>    | <span style="word-break:keep-all;white-space:nowrap">[Auto.js&#160;M](https://github.com/TonyJiangWJ/Auto.js/commit/268ec8895bbfa28fc7715154eb15b1c1eaaefd14#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span> |      <span style="word-break:keep-all;white-space:nowrap">[TonyJiangWJ](https://github.com/TonyJiangWJ)</span>       |                             <span style="word-break:keep-all;white-space:nowrap">`2019/11/21`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|      <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/kkevsekk1/AutoX)</span>       |                 <span style="white-space:pre">[Autox.js](https://github.com/kkevsekk1/AutoX/commit/8143e4ed893d4af05d22aa791b83a962f9959873#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span>                  |        <span style="word-break:keep-all;white-space:nowrap">[kkevsekk1](https://github.com/kkevsekk1)</span>         |                             <span style="word-break:keep-all;white-space:nowrap">`2020/07/24`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|        <span style="word-break:keep-all;white-space:nowrap">[Auto.js Pro 9](https://pro.autojs.org/)</span>        |                                                                                    <span style="word-break:keep-all;white-space:nowrap">AutoJsPro</span>                                                                                     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2021/03/28`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2023/02/09`</span>                             |
| <span style="word-break:keep-all;white-space:nowrap">[AutoJs6](https://github.com/SuperMonster003/AutoJs6)</span>  |  <span style="word-break:keep-all;white-space:nowrap">[AutoJs6](https://github.com/SuperMonster003/AutoJs6/commit/a8ce1b9acb541e9736c33134be3194c3148a15a3#diff-833a46a97033e77558372a2dce103fd6fee29aaaa899f610022a7aece592ee7bR27)</span>  |  <span style="word-break:keep-all;white-space:nowrap">[SuperMonster003](https://github.com/SuperMonster003)</span>   |                             <span style="word-break:keep-all;white-space:nowrap">`2021/12/01`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|      <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/kkevsekk1/AutoX)</span>       |            <span style="white-space:pre">[Autox.js&#160;v6](https://github.com/kkevsekk1/AutoX/commit/8b6776cff8b0fca4be4a52719b7d7d07c0a058f3#diff-51a0b488f963eb0be6c6599bf5df497313877cf5bdff3950807373912ac1cdc9R130)</span>             |           <span style="word-break:keep-all;white-space:nowrap">[wilinz](https://github.com/wilinz)</span>            |                             <span style="word-break:keep-all;white-space:nowrap">`2022/05/26`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|        <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/aiselp/AutoX)</span>        |              <span style="white-space:pre">[Autox.js&#160;v7](https://github.com/aiselp/AutoX/commit/484491fd5fe12b8203d0b09c181eb0f471c0ea9f#diff-8cff73265af19c059547b76aca8882cbaa3209291406f52df1dafbbc78e80c46R120)</span>              |           <span style="word-break:keep-all;white-space:nowrap">[aiselp](https://github.com/aiselp)</span>            |                             <span style="word-break:keep-all;white-space:nowrap">`2024/04/21`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |

표에 표시된 날짜는 예상 날짜로, 실제 날짜와 다를 수 있습니다.

표에 나열된 Auto.js Pro 7/8/9 는 유료 버전이며, 그 외는 무료 오픈 소스 버전입니다.

******

### 기능

******

* JavaScript IDE로 사용 가능 (코드 자동 완성/변수 이름 변경/코드 포맷팅)
* [접근성 서비스](https://developer.android.com/reference/android/accessibilityservice/AccessibilityService)를 기반으로 한 자동화 작업 지원
* 플로팅 버튼 단축 작업 지원 (스크립트 녹화 및 실행/패키지명 및 활동 보기/레이아웃 분석)
* 선택기 API 지원 및 컨트롤 탐색/정보 가져오기/컨트롤 작업 지원 ( [UiAutomator](https://developer.android.com/training/testing/ui-automator)와 유사)
* 레이아웃 화면 분석 지원 (안드로이드 스튜디오의 LayoutInspector와 유사)
* 녹화 기능 및 녹화 재생 지원
* 스크린샷 찍기/스크린샷 저장/이미지 색상 찾기/이미지 매칭 지원
* [E4X](https://zh.wikipedia.org/wiki/E4X) (ECMAScript for XML) 인터페이스 작성 지원
* 스크립트 파일 또는 프로젝트를 APK 파일로 패키징 지원
* Root 권한을 이용한 기능 확장 지원 (화면 클릭/스크롤/녹화/Shell)
* Tasker 플러그인으로 사용 가능
* VSCode와 연결하여 데스크톱 개발 지원 ( [AutoJs6-VSCode-Extension](http://vscext-project.autojs6.com) 플러그인 필요)

******

### 환경

******

- Android 운영 체제
- [API](https://developer.android.com/guide/topics/manifest/uses-sdk-element#ApiLevels) [24](https://developer.android.com/reference/android/os/Build.VERSION_CODES#N) ([7.0](https://zh.wikipedia.org/wiki/Android_Nougat)) [[N](https://developer.android.com/reference/android/os/Build.VERSION_CODES#N)] 이상

******

### 매뉴얼

******

* [문서](https://docs.autojs6.com)
* [사용 설명서 (작성 중)](https://docs.autojs6.com/#/manual)
* [문제 해결](https://docs.autojs6.com/#/qa)
* [프로젝트 컴파일 및 빌드](#project-compilation-and-build)
* [스크립트 개발 지원](#script-development-assistance)

******

### 주요 변경 사항

******

Auto.js 최종 오픈 소스 버전 `4.1.1 Alpha2` 와 비교하여 AutoJs6는 주요한 다음과 같은 업그레이드 및 변동사항이 있습니다:

* [Shizuku](https://shizuku.rikka.app/introduction/)를 통해 ADB 특권을 얻고 시스템 API 사용 지원
* [WebSocket](https://docs.autojs6.com/#/webSocketType) 인스턴스를 생성하여 [WebSocket 프로토콜](https://zh.wikipedia.org/wiki/WebSocket)에 기반한 네트워크 요청 지원
* 새로운 모듈 추가 [ [base64](https://docs.autojs6.com/#/base64) / [crypto](https://docs.autojs6.com/#/crypto) / [sqlite](https://docs.autojs6.com/#/sqlite) / [i18n](https://docs.autojs6.com/#/i18n) / [notice](https://docs.autojs6.com/#/notice) / [ocr](https://docs.autojs6.com/#/ocr) / [opencc](https://docs.autojs6.com/#/opencc) / [qrcode](https://docs.autojs6.com/#/qrcode) / [shizuku](https://docs.autojs6.com/#/shizuku) / ... ]
* 다국어 지원 [ 서 / 프 / 러 / 아 / 일 / 한 / 영어 / 중국어 / 번체 중 ... ]
* 테마 색상 적응 [ 그룹화 / 위치 / 검색 / 기록 / 밝기 및 대비 자동 적응 / ...]
* 야경 모드 지원 [ 설정 페이지 / 문서 페이지 / 레이아웃 분석 페이지 / 플로팅 창 / ... ]
* [VSCode 플러그인](http://vscext-project.autojs6.com) 지원 클라이언트 (LAN) 및 서버 (LAN/ADB) 연결 방식
* [Rhino](https://github.com/mozilla/rhino/) 엔진을 [v1.7.7.2](https://github.com/mozilla/rhino/releases/tag/Rhino1_7_7_2_Release)에서 [v1.8.1-SNAPSHOT](http://rhino.autojs6.com/blob/master/gradle.properties#L3)로 업그레이드
    * 유니코드 [코드 포인트](https://developer.mozilla.org/zh-CN/docs/Glossary/Code_point) 이스케이프 지원 [보조 평면](https://zh.wikipedia.org/wiki/Unicode%E5%AD%97%E7%AC%A6%E5%B9%B3%E9%9D%A2%E6%98%A0%E5%B0%84#%E7%AC%AC%E4%B8%80%E8%BC%94%E5%8A%A9%E5%B9%B3%E9%9D%A2) 문자
       ```javascript
       '\u{1D160}'; /* 의 의미 "𝅘𝅥𝅮", 전통적인 방법: '\uD834\uDD60'. */
       ```
    * [Object.values()](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Global_Objects/Object/values) 지원
       ```javascript
       Object.values({name: 'Max', age: 4}); // ['max', 4]
       ```
    * [Array.prototype.includes()](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Global_Objects/Array/includes) 지원
       ```javascript
       [10, 20, NaN].includes(20); // true
       ```
    * [BigInt](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Global_Objects/BigInt) 지원
       ```javascript
       typeof 567n === 'bigint'; // true
       ```
    * [템플릿 문자열](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Template_literals) 지원
       ```javascript
       `Lucky number: ${(Math.random() * 100).toFixed(0)}`
       ```
    * Rhino 엔진의 [더 많은 새로운 기능](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/RHINO.md) 보기
    * Rhino 엔진 [호환성 목록](https://mozilla.github.io/rhino/compat/engines.html) 보기

******

### 버전 역사

******

# v6.6.4

###### 2025/05/31

* `힌트` API 변경: ui.(status/navigation)BarAppearanceLight[By] -> ui.(status/navigation)BarIconLight[By]
* `추가` util.dpToPx/spToPx/pxToDp/pxToSp 메서드(픽셀 단위 변환용)
* `수정` 화면을 가로 모드로 회전하면 자막이 완전히 표시되지 않을 수 있는 문제
* `수정` 화면을 가로 모드로 회전하면 일부 페이지 콘텐츠가 사이드 내비게이션 바에 가려지는 문제
* `수정` Android 15 일부 페이지에서 상태 표시줄 배경 색칠 영역이 불완전한 문제 _[`issue #398`](http://issues.autojs6.com/398)_
* `수정` 코드 편집기가 신뢰도 낮은 인코딩으로 파일을 기록해 디코딩 오류가 발생할 수 있는 문제(수정 시도)
* `개선` 앱 및 개발자 페이지 레이아웃 호환성 개선 및 불필요한 레이아웃 분류 제거
* `개선` README.md 빌드 섹션에 여러 방법 추가로 대상 설정 페이지 찾기 용이화 _[`issue #404`](http://issues.autojs6.com/404)_
* `개선` 일부 의존성 또는 로컬 라이브러리 버전 조정 _[`CHANGELOG.md`](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG.md#v664)_

# v6.6.3

###### 2025/05/27

* `추가` 버전 히스토리 기능: 다국어 변경 로그 및 통계 보기
* `추가` timers.keepAlive 메서드 (전역으로 승격) 로 스크립트 활성 유지
* `추가` engines.on('start/stop/error', callback) 등의 이벤트 리스너로 엔진 전역 이벤트 수신
* `추가` images.detectMultiColors 메서드로 여러 지점 색상 검사 _[`issue #374`](http://issues.autojs6.com/374)_
* `추가` images.matchFeatures/detectAndComputeFeatures: 풀 해상도 이미지 검색 (참조 [Auto.js Pro](https://g.pro.autojs.org/)) _[`issue #366`](http://issues.autojs6.com/366)_
* `추가` images.compressToBytes 메서드로 이미지를 압축하여 바이트 배열 반환
* `추가` images.downsample 메서드로 해상도를 낮추고 새로운 ImageWrapper 생성
* `추가` ui.keepScreenOn 메서드로 UI 페이지가 포커스될 때 화면 켜짐 유지
* `추가` ui.root 프로퍼티 (getter) 로 UI 레이아웃 내 '윈도우 콘텐츠 루트 컨테이너' 노드를 가져옴
* `추가` webview 요소가 JsBridge 기반 웹 페이지 레이아웃 지원 (참조 [Auto.js Pro](https://g.pro.autojs.org/)) [예: Layout > Interactive HTML / Vue2 + Vant (SFC)] _[`issue #281`](http://issues.autojs6.com/281)_
* `수정` Docs 탭 및 Docs 액티비티의 온라인 문서가 시스템 네비게이션 바에 가려질 수 있는 문제 수정
* `수정` 일부 페이지에서 Toolbar 버튼을 누르면 제목 클릭 이벤트가 잘못 발생하는 문제 수정
* `수정` 코드 편집기 빈 줄이 일부 기기에서 사각형으로 보이는 문제 수정
* `수정` 테마 색상 설정의 컬러 피커 대화상자가 무한 중첩되는 문제 수정
* `수정` 접근성 서비스가 꺼진 상태에서 볼륨 업 키가 모든 스크립트를 중지하지 않는 문제 수정
* `수정` 예약 작업에서 사용자 정의 브로드캐스트 메시지를 편집할 때 IME가 입력 영역을 덮는 문제 수정
* `수정` webview 내부 컨트롤이 소프트 키보드를 정상적으로 호출하지 못하는 문제 수정
* `수정` APK 정보 대화상자가 앱 이름이나 SDK 정보를 가져오지 못하는 문제 수정
* `수정` 파일 관리자 예제에서 프로젝트 폴더 진입 시 하위 폴더 내용이 로드되지 않는 문제 수정
* `수정` Android 15 UI 모드에서 상태 표시줄이 상단 콘텐츠를 가리는 문제 수정
* `수정` Android 15 일부 페이지에서 상태 표시줄 배경색이 테마 색상과 동기화되지 않는 문제 수정
* `수정` dialogs 모듈이 customView 프로퍼티를 지원하지 않는 문제 수정 _[`issue #364`](http://issues.autojs6.com/364)_
* `수정` dialogs.input 의 expression 매개변수가 실행 결과를 반환하지 않는 문제 수정
* `수정` JavaAdapter 사용 시 ClassLoader 스택 오버플로우가 발생하는 문제 수정 _[`issue #376`](http://issues.autojs6.com/376)_
* `수정` console.setContentTextColor 가 기본 텍스트 색상을 리셋하는 문제 수정 _[`issue #346`](http://issues.autojs6.com/346)_
* `수정` console.setContentBackgroundColor 가 색상 이름을 허용하지 않는 문제 수정 _[`issue #384`](http://issues.autojs6.com/384)_
* `수정` images.compress 구현 수정: 다운샘플링 대신 인코딩 품질을 변경
* `수정` images.resize 메서드가 올바르게 동작하지 않는 문제 수정
* `수정` engines.all 이 ConcurrentModificationException 을 발생시킬 수 있는 문제 수정 _[`issue #394`](http://issues.autojs6.com/394)_
* `수정` README.md 일부 언어의 날짜 형식 오류 수정
* `수정` Gradle 빌드가 라이브러리 아카이브 크기 오류로 실패할 수 있는 문제 수정 _[`issue #389`](http://issues.autojs6.com/389)_
* `개선` 레이아웃 인스펙터가 요소 숨기기 지원 (기여 [TonyJiangWJ](https://github.com/TonyJiangWJ)) _[`pr #371`](http://pr.autojs6.com/371)_ _[`issue #355`](http://issues.autojs6.com/355)_
* `개선` 레이아웃 인스펙터 메뉴에 기능 그룹화를 위한 그라데이션 구분선 추가
* `개선` project.json 이 스크립트 프로젝트 permissions 옵션 지원 (기여 [wirsnow](https://github.com/wirsnow)) _[`pr #391`](http://pr.autojs6.com/391)_ _[`issue #362`](http://issues.autojs6.com/362)_
* `개선` 단일 파일 패키징 시 설치된 앱의 선언 권한을 자동 읽어 표시 _[`issue #362`](http://issues.autojs6.com/362)_
* `개선` 테마 색상 적용 범위 확대, 더 많은 위젯 지원
* `개선` 메인 페이지 드로어 폭이 가로 및 초광폭 화면에 적응
* `개선` ‘앱 정보’ 및 ‘개발자 정보’ 페이지에 가로 및 컴팩트 레이아웃 추가
* `개선` 설정 대화상자에 '기본값 사용' 메뉴 추가
* `개선` 파일 관리자 FAB가 영역 밖을 터치하면 자동으로 숨김
* `개선` 코드 포매터가 `??`, `?.`, `??=` 연산자 지원
* `개선` 코드 편집기가 GB18030 / UTF-16 (LE/BE) / Shift_JIS 등 인코딩의 파일 읽기·쓰기를 지원
* `개선` 코드 편집기가 파일 상세 정보(경로/인코딩/줄바꿈 형식/총 바이트 및 문자 수 등) 표시를 지원 _[`issue #395`](http://issues.autojs6.com/395)_
* `개선` Intent 작업(편집/보기/설치/전송/재생 등)의 오류 메시지 추가
* `개선` webview 요소의 url 속성이 상대 경로 지원
* `개선` ImageWrapper#saveTo 의 path 매개변수가 상대 경로 지원
* `개선` images.save 가 PNG 압축을 quality 매개변수로 지원 _[`issue #367`](http://issues.autojs6.com/367)_
* `개선` 무시한 업데이트 목록 및 클라이언트 모드 주소 초기화 기능 추가
* `개선` 버전 업데이트 정보가 현재 UI 언어로 표시
* `개선` 비동기 로드로 파일 관리자 리스트 스크롤 부드러움 향상
* `개선` 콘솔 스크립트 예외 메시지 내용 및 형식 개선
* `개선` 샘플 코드 폴더를 초기 내용으로 재설정 기능
* `개선` APK 서명 검증 속도 향상
* `개선` APK/미디어 파일 정보 대화상자 속도 및 표시 로직 최적화
* `개선` Gradle 빌드 스크립트가 최신 버전에 더 유연하게 대응 _[`discussion #369`](http://discussions.autojs6.com/369)_
* `개선` 일부 의존성 또는 로컬 라이브러리 버전 조정 _[`CHANGELOG.md`](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG.md#v663)_

# v6.6.2

###### 2025/04/16

* `추가` ui.statusBarAppearanceLight, statusBarAppearanceLightBy, navigationBarColor 등의 메서드
* `추가` ui.statusBarHeight 속성 (getter) 을 사용하여 상태 표시줄의 높이를 가져옴 _[`issue #357`](http://issues.autojs6.com/357)_
* `추가` images.flip 메서드를 통해 이미지를 반전 _[`issue #349`](http://issues.autojs6.com/349)_
* `추가` 설정 페이지에 '파일 확장자' 옵션 추가
* `추가` 테마 설정 페이지가 그룹화, 정렬, 검색, 기록, 컬러 피커 개선 등 새로운 레이아웃을 지원
* `수정` Android 15 에서 상태 표시줄 배경색이 테마 색상과 일치하지 않는 문제를 수정
* `수정` plugins.load 메서드가 플러그인을 올바르게 로드하지 못하는 문제를 수정 _[`issue #290`](http://issues.autojs6.com/290)_
* `수정` Android 7.x 에서 dx 라이브러리가 올바르게 동작하지 않는 문제를 수정 _[`issue #293`](http://issues.autojs6.com/293)_
* `수정` require 를 사용해 내장 모듈을 가져올 때 ScriptRuntime 의 동기화 상태에 문제가 발생하는 (임시 해결) 문제를 수정 _[`issue #298`](http://issues.autojs6.com/298)_
* `수정` notice 모듈에 getBuilder 등의 확장 메서드가 없는 문제를 수정 _[`issue #301`](http://issues.autojs6.com/301)_
* `수정` shizuku/shell 메서드가 문자열 파라미터를 받지 않는 문제를 수정 _[`issue #310`](http://issues.autojs6.com/310)_
* `수정` colors.pixel 메서드가 단일 채널 이미지 파라미터를 받지 않는 문제를 수정 _[`issue #350`](http://issues.autojs6.com/350)_
* `수정` engines.execScript / execScriptFile 메서드가 스크립트 실행 시 기본 작업 디렉토리를 잘못 설정하는 문제를 수정 _[`issue #358`](http://issues.autojs6.com/358)_ _[`issue #340`](http://issues.autojs6.com/340)_ _[`issue #339`](http://issues.autojs6.com/339)_
* `수정` floaty.window / floaty.rawWindow 가 서브 스레드에서 실행되지 않는 문제를 수정
* `수정` floaty.getClip 이 클립보드 내용을 올바르게 가져오지 못하는 문제를 수정 _[`issue #341`](http://issues.autojs6.com/341)_
* `수정` ui.inflate 의 반환 값에서 attr, on, click 등의 프로토타입 메서드가 누락되는 문제를 수정
* `수정` XML 구문을 사용하여 JavaScript 표현식을 속성 값으로 사용할 때, 스코프 컨텍스트가 올바르게 바인딩되지 않는 문제 _[`issue #319`](http://issues.autojs6.com/319)_
* `수정` 일부 메서드 호출 시 발생하는 예외가 try..catch 로 처리되지 않는 문제를 수정 _[`issue #345`](http://issues.autojs6.com/345)_
* `수정` 레이아웃 분석 페이지에서 코드 생성 중 앱이 종료되는 문제를 수정 _[`issue #288`](http://issues.autojs6.com/288)_
* `수정` 패키지화된 앱에서 shizuku 모듈을 제대로 사용할 수 없는 문제를 수정 _[`issue #227`](http://issues.autojs6.com/227)_ _[`issue #231`](http://issues.autojs6.com/231)_ _[`issue #284`](http://issues.autojs6.com/284)_ _[`issue #287`](http://issues.autojs6.com/287)_ _[`issue #304`](http://issues.autojs6.com/304)_
* `수정` 코드 에디터에서 줄 끝으로 이동할 때 커서가 다음 줄 맨 앞으로 이동하는 문제를 수정
* `수정` 설정 페이지의 다이얼로그 요소를 연속해서 빠르게 탭할 경우 앱이 종료되는 문제를 수정
* `개선` 패키지 앱 템플릿의 APK 파일 크기 최적화
* `개선` 앱 (및 패키지 앱) 이 더 많은 권한을 지원하도록 개선 _[`issue #338`](http://issues.autojs6.com/338)_
* `개선` 패키징 페이지에 Pinyin 라이브러리 옵션 추가
* `개선` 패키지 앱 메인 페이지에서 상태 표시줄 배경과 텍스트 색상을 최적화
* `개선` 패키지 앱 설정 페이지에 전체 파일 접근 및 알림 전송과 같은 특수 권한용 스위치 추가 _[`issue #354`](http://issues.autojs6.com/354)_
* `개선` 컨트롤의 텍스트와 아이콘 색상이 테마의 밝기에 따라 자동으로 조정되도록 개선
* `개선` 컨트롤 색상과 배경 간의 대비가 낮을 때 시각적 경험 개선
* `개선` 컬러 피커의 HEX 입력란에서 클립보드에서 붙여넣기 시 호환성 개선
* `개선` 앱 내비게이션 바를 시각적 경험을 위해 투명 또는 반투명으로 설정
* `개선` 라이트 모드에서 상태 표시줄과 내비게이션 바의 기본 UI 모드가 `md_grey_50` 색상으로 설정되도록 개선
* `개선` 홈 드로어의 접근성 서비스 스위치가 스크립트 코드와 동기화되도록 개선
* `개선` 메인 페이지의 문서 페이지에 양방향 검색 버튼 추가
* `개선` 메인 페이지 '파일' 탭에서 길게 눌러 플로팅 버튼의 표시 상태를 전환할 수 있도록 개선
* `개선` 코드 에디터 타이틀이 폰트 크기를 자동으로 조절하도록 개선
* `개선` 로그 페이지의 플로팅 버튼 표시가 리스트 스크롤 동작과 연동되도록 개선
* `개선` 스크립트 프로젝트의 project.json 설정 파일이 더 많은 패키징 옵션을 지원하도록 개선 _[`issue #305`](http://issues.autojs6.com/305)_ _[`issue #306`](http://issues.autojs6.com/306)_
* `개선` project.json 설정 파일이 옵션 이름의 유연한 매칭과 별칭 호환을 지원하도록 개선
* `개선` APK 파일 정보 대화상자에 파일 크기와 서명 스킴 정보를 추가
* `개선` APK 파일 정보 대화상자가 텍스트 복사 및 앱 상세 정보로 이동하기 위한 클릭 리스너를 지원하도록 개선
* `개선` com.stardust 접두어를 가진 패키지를 복원하여 코드 호환성을 개선 _[`issue #290`](http://issues.autojs6.com/290)_
* `개선` floaty.window / floaty.rawWindow 메서드가 메인 스레드와 서브 스레드 모두에서 실행되도록 개선
* `개선` 글로벌 메서드 getClip 이 필요에 따라 floaty.getClip 을 사용하도록 하여 호환성을 개선
* `개선` files.path 및 관련 메서드가 null 경로일 경우에도 적절하게 처리되도록 개선
* `개선` 최신 공식 Rhino 엔진과의 동기화 및 코드 조정
* `개선` README.md 를 개선하여 프로젝트 빌드 및 실행 방법에 대한 문서를 보강 _[`issue #344`](http://issues.autojs6.com/344)_
* `개선` 일부 의존성 또는 로컬 라이브러리 버전 조정 _[`CHANGELOG.md`](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG.md#v662)_

##### 더 많은 버전 기록은 참조하십시오

* [CHANGELOG.md](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG-ko.md)

******

### <a id="project-compilation-and-build"></a>프로젝트 컴파일 및 빌드

******

AutoJs6 오픈 소스 프로젝트를 디버깅하거나 개발하려면 [Android Studio](https://pro.autojs.org/) ([Google](https://www.google.com/) 제품) 또는 [IntelliJ IDEA](https://www.jetbrains.com/idea/) ([Jetbrains](https://www.jetbrains.com/) 제품)를 사용할 수 있습니다.

이 섹션에서는 Android Studio를 사용하여 AutoJs6 오픈 소스 프로젝트를 컴파일하고 빌드하는 방법에 대해 설명합니다. IntelliJ IDEA도 이와 유사합니다.

#### Android Studio 준비

`Android Studio Meerkat Feature Drop | 2024.3.2 Patch 1` 버전을 다운로드하십시오 (필요에 따라 선택):

- [android-studio-2024.3.2.15-windows.exe](https://redirector.gvt1.com/edgedl/android/studio/install/2024.3.2.15/android-studio-2024.3.2.15-windows.exe) (1.23 GB)
- [android-studio-2024.3.2.15-windows.zip](https://redirector.gvt1.com/edgedl/android/studio/ide-zips/2024.3.2.15/android-studio-2024.3.2.15-windows.zip) (1.23 GB)

> 메모: 상기 버전 출시 날짜는 2025 년 5 월 28 일입니다. 다른 버전을 다운로드하거나 상기 링크가 만료되었을 경우, [Android Studio 릴리스 아카이브](https://developer.android.com/studio/archive?hl=en) 페이지를 방문하십시오.

위의 파일을 설치하거나 압축을 풀고 Android Studio 소프트웨어를 실행합니다 (예: `"D:\android-studio\bin\studio64.exe"`).

#### Android SDK 준비

> 메모: 시스템에 이미 Android SDK(안드로이드 소프트웨어 개발 키트)가 설치되어 있는 경우, 이 섹션을 건너뛸 수 있습니다.

`Android SDK (Android 소프트웨어 개발 키트)` 설정 페이지 열기(아래 방법 중 하나):

```text
Help (도움말) | Find action (동작 찾기) # 입력 "Android SDK"
[ 또는 ]
File (파일) | Settings (설정) # 검색 "Android SDK"
[ 또는 ]
File (파일) | Settings (설정) | Language & Frameworks (언어 및 프레임워크) | Android SDK (안드로이드 소프트웨어 개발 키트)
[ 또는 ]
File (파일) | Settings (설정) | Appearance & Behavior (모양 및 동작) | System Settings (시스템 설정) | Android SDK (안드로이드 소프트웨어 개발 키트)
```

`Android SDK Location` (안드로이드 소프트웨어 개발 키트 위치) 필드가 비어 있는 경우, 오른쪽의 `Edit` (편집) 버튼을 클릭하고, 팝업 창에서 여러 번 `Next` (다음)를 클릭합니다.

> 메모: 과정 중 하나 이상의 관련 계약을 동의해야 계속 진행할 수 있습니다.

관련 리소스가 다운로드 및 설치를 완료하면, `Finish` (완료) 버튼을 클릭합니다.  
위의 `Android SDK Location` (안드로이드 소프트웨어 개발 키트 위치) 필드에 경로가 자동으로 작성되고, SDK 준비 작업이 완료됩니다.

#### Android SDK 도구 준비

AutoJs6은 일부 SDK 도구 (예: NDK 및 CMake)를 사용해야 합니다.

> 메모: 시스템에 AutoJs6이 필요한 모든 Android SDK 도구가 설치되어 있는 경우, 이 섹션을 건너뛸 수 있습니다.

`SDK Tools (SDK 도구)` 설정 페이지 열기(아래 방법 중 하나):

```text
Help (도움말) | Find action (동작 찾기) # 입력 "SDK Tools"
[ 또는 ]
File (파일) | Settings (설정) # 검색 "SDK Tools"
[ 또는 ]
File (파일) | Settings (설정) | Language & Frameworks (언어 및 프레임워크) | Android SDK (안드로이드 소프트웨어 개발 키트) | SDK Tools (SDK 도구) (오른쪽 창에 위치)
[ 또는 ]
File (파일) | Settings (설정) | Appearance & Behavior (모양 및 동작) | System Settings (시스템 설정) | Android SDK (안드로이드 소프트웨어 개발 키트) | SDK Tools (SDK 도구) (오른쪽 창에 위치) 
```

`Show Package Details` (패키지 세부사항 표시)를 선택하고, NDK와 CMake를 차례로 클릭하여 해당 버전의 도구가 선택되었는지 확인하십시오, SDK 도구 버전 정보는 AutoJs6 프로젝트 루트 디렉터리에 있는 `version.properties` 파일에 있습니다.

#### JDK 준비

AutoJs6 프로젝트는 `JDK (Java 개발 도구 키트)` 버전이 `17` 이상이어야 하지만, `19` 이상을 권장합니다.

2025 년 5 월 31 일 기준으로, AutoJs6이 지원하는 최대 JDK 버전은 `24` 입니다.

> 메모: 시스템에 JDK가 설치되어 있고, 버전이 위의 요구 사항을 충족하는 경우, 이 섹션을 건너뛸 수 있습니다.

JDK는 IDE에서 직접 다운로드하거나 [Oracle 웹사이트](https://www.oracle.com/java/technologies/downloads/) 에서 다운로드할 수 있습니다.

`Gradle JDK` 설정 페이지 열기(아래 방법 중 하나):

```text
Help (도움말) | Find action (동작 찾기) # 입력 "Gradle JDK"
[ 또는 ]
File (파일) | Settings (설정) # 검색 "Gradle"
[ 또는 ]
File (파일) | Settings (설정) | Build, Execution, Deployment (빌드, 실행, 배포) | Build Tools (구축 도구) | Gradle
```

`Gradle JDK` 에서 다양한 버전의 JDK를 선택하거나 추가할 수 있습니다.

목록에 적합한 버전의 JDK(>= `17`)가 있는 경우, 직접 선택하십시오.  
그렇지 않으면 `Download JDK (JDK 다운로드)` 를 선택하여 적절한 JDK를 다운로드하고, `Download (다운로드)` 버튼을 클릭하여 완료될 때까지 기다립니다.  
`Add JDK (JDK 추가)` 를 선택하여 이미 존재하는 로컬 JDK를 추가하고 디렉토리를 지정하여 JDK 추가를 완료할 수 있습니다.

#### AutoJs6 자원 복제

Android Studio 메인 화면에서 `Get from VCS (버전 관리 시스템에서 가져오기)` 버튼을 클릭합니다.  
`URL (통합 자원 위치)` 에 `https://github.com/SuperMonster003/AutoJs6.git` 을 입력합니다,  
`Directory (디렉토리)` 에서 필요한 경우 특정 경로로 수정할 수 있습니다.  
`Clone (복제)` 버튼을 클릭하고 AutoJs6 프로젝트 리소스를 장치에 로컬로 복제될 때까지 기다립니다.

> 메모: 과정 중 [Git (분산 버전 관리 시스템)](https://git-scm.com/download)을 설치해야 할 수도 있습니다.

#### AutoJs6 프로젝트 빌드

복제가 완료된 후, Android Studio가 AutoJs6 프로젝트 창을 열고 초기 `Dependencies(의존성)` 다운로드 및 Gradle 빌드를 자동으로 완료합니다.

> 메모: 상기 과정은 시간이 많이 소요될 수 있습니다. 네트워크 상태가 좋지 않으면 여러 번 재시도해야 할 수 있습니다 (Retry 버튼을 클릭).

빌드가 자동으로 진행되지 않거나 프로젝트를 다시 빌드해야 하는 경우, 다음 단계를 따르십시오:

- 툴바의 `Run/Debug Configurations` 메뉴에서 `app` 을 선택합니다. 이는 AutoJs6의 메인 앱입니다
- 좌측의 `Build Project` (망치 아이콘) 버튼을 클릭하여 프로젝트 빌드를 시작합니다. 기본 단축키는 CTRL + F9입니다
- 빌드가 완료될 때까지 기다립니다. `Builder Output` 탭에 "BUILD SUCCESSFUL in 1h 17m 34s"와 같은 메시지가 표시됩니다

빌드에 실패하면, 에러 메시지를 AutoJs6 프로젝트의 [Issues](http://issues.autojs6.com) 페이지에 보고할 수 있습니다.

> 참고: 앱 빌드 및 실행에 대한 자세한 내용은 [Android Docs](https://developer.android.com/studio/run?hl=en)를 참조하십시오

#### AutoJs6 프로젝트 배포 (앱 실행)

프로젝트가 성공적으로 빌드된 후, 이를 실제 디바이스(예: 휴대폰/태블릿)나 가상 디바이스(예: Android 에뮬레이터)에 앱으로 배포할 수 있습니다.

- 툴바에서 `Run/Debug Configurations` 메뉴의 `app` 을 선택합니다. 이는 AutoJs6의 메인 앱입니다
- 우측의 `Available Devices` 드롭다운 목록에서 프로젝트 앱을 실행할 디바이스(실제 또는 가상)를 선택합니다
- 우측의 `Run` (삼각형 아이콘) 버튼을 클릭하여 앱을 실행합니다. 기본 단축키는 `F10` 입니다
- 배포가 완료될 때까지 기다리면 선택된 디바이스가 자동으로 앱을 설치하고 실행합니다

#### AutoJs6 프로젝트 배포 (APK 생성)

프로젝트를 패키징하여 Android 디바이스에 설치할 수 있는 APK 파일을 생성합니다:

- 디버그 버전 (Debug Version)
    - `Build (구축)` | `Build Bundle(s) / APK(s)` | `Build APK(s)`
    - 기본 서명을 포함한 디버그 버전 APK 생성
    - 경로 예시: `"D:\AutoJs6\app\build\outputs\apk\debug\"`
- 릴리즈 버전 (Release Version)
    - `Build (구축)` | `Generate Signed Bundle / APK`
    - `APK` 옵션 선택
    - 서명 파일을 준비하고 (새로 만들거나 선택) 서명된 릴리즈 버전 설치 패키지를 생성합니다
    - 경로 예시: `"D:\AutoJs6\app\release\"`

> 참고: 사용자에게 릴리스할 앱 빌드 방법에 대한 자세한 내용은 [Android Docs](https://developer.android.com/build/build-for-release?hl=en)를 참조하십시오

#### AutoJs6용 미리 정의된 Gradle 빌드 작업

프로젝트 앱 빌드 외에도 AutoJs6는 개발자가 프로젝트 관련 편리한 작업을 수행하는 데 도움이 되는 여러 미리 정의된 Gradle 빌드 작업을 지원합니다.

툴바의 `Run/Debug Configurations` 메뉴에서, 좌측에 코끼리 아이콘이 표시된 다양한 미리 정의된 Gradle 작업들을 확인할 수 있습니다.

- AutoJs6 [inrt:assemble]

"inrt" 빌드 변형을 어셈블합니다. 이는 주로 AutoJs6 스크립트 패키징 기능을 위한 것입니다.

AutoJs6 프로젝트에는 다양한 빌드 변형이 있습니다. 그 중 "inrt" 변형은 스크립트 패키징 기능을 위해 사용되며, 패키징에 필요한 템플릿 파일 "template.apk"를 생성합니다.

패키징 기능 사용 시 다음과 같은 오류 메시지가 나타날 수 있습니다:

> java.io.FileNotFoundException: template.apk

이는 템플릿 파일이 존재하지 않음을 나타냅니다. 템플릿 파일을 생성하기 위해 `inrt:assemble` 작업을 수동으로 실행한 후, 앱을 다시 빌드하고 배포하십시오.

> 참고: 메인 프로젝트 코드에 변경이 발생하고, 패키징된 앱에 해당 변경 사항을 동기화하려면 `inrt:assemble` 작업을 다시 실행하여 템플릿 파일을 생성한 후 앱을 재배포해야 합니다

- AutoJs6 [app:bundle]

디버그 빌드 과정의 산출물을 패키징합니다. 이는 주로 [AutoJs6 타입 정의](http://dts-project.autojs6.com) 프로젝트를 위한 것입니다.

작업 실행 후, AutoJs6 프로젝트의 최신 JAR 파일이 생성됩니다. [Android d.ts Generator](https://github.com/NativeScript/android-dts-generator) (by [NativeScript](https://github.com/NativeScript)) 도구를 이용하여 AutoJs6 메인 앱의 타입 정의(d.ts 형식)를 생성할 수 있습니다.

- AutoJs6 [app:digest]

릴리즈 빌드로 생성된 APK 파일에 다이제스트 정보를 추가합니다. 이는 GitHub에 최신 버전의 AutoJs6를 게시하기 전에 최종 파일 이름을 결정하는 데 사용됩니다.

다음은 다이제스트 정보 추가 전후의 파일 이름 비교입니다:

```text
전:
autojs6-v6.6.2-arm64-v8a.apk
후:
autojs6-v6.6.2-arm64-v8a-0f2a9d74.apk
```

> 참조: [Android Docs](https://developer.android.com/studio/run?hl=zh-cn)

******

### <a id="script-development-assistance"></a>스크립트 개발 지원

******

AutoJs6에서 실행 가능한 스크립트를 개발하려면 적합한 개발 도구를 사용하십시오:

- [VSCode](https://code.visualstudio.com/download) / [WebStorm](https://www.jetbrains.com/webstorm/download/) / [HBuilderX](https://www.dcloud.io/hbuilderx.html) ...

PC에서 스크립트를 작성하고 디버깅하려면 VSCode 플러그인을 사용하여 PC와 휴대폰을 연결할 수 있습니다:

- [AutoJs6-VSCode-Extension](http://vscext-project.autojs6.com) - AutoJs6 디버거 (VSCode 플랫폼 플러그인)

개발 도구를 사용하여 코드를 작성할 때, 코드 자동 완성 기능은 개발자를 더 잘 도울 수 있습니다:

- [AutoJs6-TypeScript-Declarations](http://dts-project.autojs6.com) - AutoJs6 선언 파일 (코드 자동 완성)

코드를 작성할 때, AutoJs6 관련 API 및 사용 방법을 문서에서 조회할 수 있습니다:

- [AutoJs6-Documentation](http://docs-project.autojs6.com) - AutoJs6 문서

기존의 스크립트 개발 프로젝트는 개인 스크립트 프로젝트 창작에 영감을 줄 수 있습니다:

- [Ant-Forest](https://github.com/TonyJiangWJ/Ant-Forest) - ant forest 에너지 자동 수집 스크립트 by [TonyJiangWJ](https://github.com/TonyJiangWJ)
- [Ant-Forest](https://github.com/SuperMonster003/Ant-Forest) - ant forest 에너지 자동 수집 스크립트 by [SuperMonster003](https://github.com/SuperMonster003)
- [autojs](https://github.com/e1399579/autojs) - Auto.js 유용한 스크립트 by [e1399579](https://github.com/e1399579)
- [autojsDemo](https://github.com/snailuncle/autojsDemo) - Auto.js 데모 예제 by [snailuncle](https://github.com/snailuncle)
- [autojs 관련 저장소](https://github.com/topics/autojs) - GitHub에서 autojs 주제와 관련된 모든 저장소

******

### 기여 참여

******

AutoJs6 프로젝트 개발에 참여한 모든 기여자분들께 감사합니다.

|         <span style="word-break:keep-all;white-space:nowrap">기여자</span>          |                   <span style="word-break:keep-all;white-space:nowrap">커밋 수</span>                    | <span style="word-break:keep-all;white-space:nowrap">최근 제출</span> |
|:-------------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------:|
|             <span style="word-break:keep-all;white-space:nowrap">[wirsnow](https://github.com/wirsnow)</span>             |         <span style="word-break:keep-all;white-space:nowrap">[1](https://github.com/SuperMonster003/AutoJs6/commits?author=wirsnow)</span>         |                    <span style="word-break:keep-all;white-space:nowrap">`2025/05/19`</span>                    |
|         <span style="word-break:keep-all;white-space:nowrap">[TonyJiangWJ](https://github.com/TonyJiangWJ)</span>         |       <span style="word-break:keep-all;white-space:nowrap">[5](https://github.com/SuperMonster003/AutoJs6/commits?author=TonyJiangWJ)</span>       |                    <span style="word-break:keep-all;white-space:nowrap">`2025/04/24`</span>                    |
|          <span style="word-break:keep-all;white-space:nowrap">[luckyloogn](https://github.com/luckyloogn)</span>          |       <span style="word-break:keep-all;white-space:nowrap">[3](https://github.com/SuperMonster003/AutoJs6/commits?author=luckyloogn)</span>        |                    <span style="word-break:keep-all;white-space:nowrap">`2025/01/01`</span>                    |
|                <span style="word-break:keep-all;white-space:nowrap">[kvii](https://github.com/kvii)</span>                |          <span style="word-break:keep-all;white-space:nowrap">[1](https://github.com/SuperMonster003/AutoJs6/commits?author=kvii)</span>           |                    <span style="word-break:keep-all;white-space:nowrap">`2024/10/16`</span>                    |
|   <span style="word-break:keep-all;white-space:nowrap">[chenguangming](https://github.com/chenguangming) `(Tom)`</span>   | <span style="word-break:keep-all;white-space:nowrap">[2](https://github.com/SuperMonster003/AutoJs6/pulls?q=is%3Apr+author%3Achenguangming)</span> |                    <span style="word-break:keep-all;white-space:nowrap">`2024/05/14`</span>                    |
|          <span style="word-break:keep-all;white-space:nowrap">[LZX284](https://github.com/LZX284) `(AI)`</span>           |         <span style="word-break:keep-all;white-space:nowrap">[17](https://github.com/SuperMonster003/AutoJs6/commits?author=LZX284)</span>         |                    <span style="word-break:keep-all;white-space:nowrap">`2023/11/19`</span>                    |
| <span style="word-break:keep-all;white-space:nowrap">[little&#x2011;alei](https://github.com/little-alei) `(抠脚本人)`</span> |      <span style="word-break:keep-all;white-space:nowrap">[12](https://github.com/SuperMonster003/AutoJs6/commits?author=little-alei)</span>       |                    <span style="word-break:keep-all;white-space:nowrap">`2023/07/12`</span>                    |
|              <span style="word-break:keep-all;white-space:nowrap">[aiselp](https://github.com/aiselp)</span>              |    <span style="word-break:keep-all;white-space:nowrap">[6](https://github.com/SuperMonster003/AutoJs6/pulls?q=is%3Apr+author%3Aaiselp)</span>     |                    <span style="word-break:keep-all;white-space:nowrap">`2023/06/14`</span>                    |
|           <span style="word-break:keep-all;white-space:nowrap">[LYS86](https://github.com/LYS86) `(Lin)`</span>           |          <span style="word-break:keep-all;white-space:nowrap">[2](https://github.com/SuperMonster003/AutoJs6/commits?author=LYS86)</span>          |                    <span style="word-break:keep-all;white-space:nowrap">`2023/06/03`</span>                    |

데이터 갱신일: 2025 년 5 월 27 일.

데이터 항목은 `최근 제출` 순으로 내림차순 정렬됩니다.

처리되지 않은 새로 발행된 Pull Request는 병합 처리 후 데이터 통계에 추가될 것입니다.

일부 기여자는 [GitHub Contributors](https://github.com/SuperMonster003/AutoJs6/graphs/contributors)에서 정상적으로 표시되지 않으며, 그들의 제출 기록이 비어 있습니다. 그러나 [Pull Request](https://github.com/SuperMonster003/AutoJs6/pulls)를 통해 기여 기록을 확인할 수 있습니다.

[//]: # (
    # --------------------------------------------------------------#
    # Before committing and pushing to the remote GitHub repository #
    # --------------------------------------------------------------#
    - IDE
        - The summary of the latest changelog for committing to Git [ DO NOT commit or push ]
    - $projectDir/version.properties
        - Remove the part like [ alpha / beta / ... ] of VERSION_NAME
    - $projectDir/.changelog/lang_zh-Hans.json
        - Update version name and released date
        - Translate into other languages
        - Update TypeScript declarations according to section `dependency` if needed
    - $projectDir/.readme/template_readme.md
        - Update badges like [ android studio / rhino / ... ]
        - Update contribution section: 기여 참여
    - $projectDir/.readme/common.json
        - Update android studio download links and version names
        - Update contribution section: var_date_contribution_table_data_updated
    - $projectDir/.python/generate_markdown.py
        - Re-generate markdown by running the python script [ link: aj6mdgen ]
    - Others
        - Re-generate documentation by running the python script [ link: aj6docgen ]
        - Check the two-way versions for AutoJs6 and VSCode ext, then publish the ext to Microsoft if needed
        - Run Gradle task "app:assembleInrtRelease" [ shortcut: C+A+0#- ]
        - Build APK to determine the final VERSION_BUILD field [ shortcut: C+A+0#A ]
        - Run Gradle task "app:appendDigestToReleasedFiles" [ shortcut: C+A+0#= ]
        - Check VERSION_BUILD in version.properties with released apks
        - Commit and push to GitHub
        - Publish the latest release with signed APKs
)