<!--suppress HtmlDeprecatedAttribute, HttpUrlsUsage -->

<div align="center">
  <p>
    <img src="https://s1.imagehub.cc/images/2023/03/07/af8ed087c9d354b9ab6142aae7bbafb6.png" alt="autojs6-banner_800×224" border="0" width="704" />
  </p>

  <p>أداة أتمتة JavaScript لنظام Android مدعومة بخدمة الوصول</p>

  <p>
    <a href="http://download.autojs6.com"><img alt="GitHub release (latest by date)" src="https://img.shields.io/github/v/release/SuperMonster003/AutoJs6"/></a>
    <a href="http://issues.autojs6.com"><img alt="GitHub closed issues" src="https://img.shields.io/github/issues/SuperMonster003/AutoJs6?color=A24232"/></a>
    <a href="http://commit.autojs6.com/99a1d8490fac5b6d55f6f183db59ad833a2064ed"><img alt="Created" src="https://img.shields.io/date/1636632233?color=2e7d32&label=created"/></a>
    <br>
    <a href="https://github.com/mozilla/rhino"><img alt="Rhino" src="https://img.shields.io/badge/rhino-1.8.1--SNAPSHOT-795548"/></a>
    <a href="https://developer.android.com/studio/archive"><img alt="Android Studio" src="https://img.shields.io/badge/android%20studio-2022.1+-B64FC8"/></a>
    <br>
    <a href="https://www.codefactor.io/repository/github/SuperMonster003/AutoJs6"><img alt="CodeFactor Grade" src="https://www.codefactor.io/repository/github/SuperMonster003/AutoJs6/badge"/></a>
    <a href="https://www.jetbrains.com/?from=AutoJs6"><img alt="JetBrains supporter" src="https://img.shields.io/badge/supporter-JetBrains-ee4677"/></a>
    <a href="http://project.autojs6.com/blob/master/LICENSE"><img alt="GitHub License" src="https://img.shields.io/github/license/SuperMonster003/AutoJs6?color=534BAE"/></a>
  </p>
</div>

******

### اللغات

******

ملف README.md الحالي يدعم اللغات التالية:

 - [简体中文 [zh-Hans]](http://project.autojs6.com/blob/master/.readme/README-zh-Hans.md)
 - [繁體中文 (香港) [zh-Hant-HK]](http://project.autojs6.com/blob/master/.readme/README-zh-Hant-HK.md)
 - [繁體中文 (台灣) [zh-Hant-TW]](http://project.autojs6.com/blob/master/.readme/README-zh-Hant-TW.md)
 - [English [en]](http://project.autojs6.com/blob/master/.readme/README-en.md)
 - [Français [fr]](http://project.autojs6.com/blob/master/.readme/README-fr.md)
 - [Español [es]](http://project.autojs6.com/blob/master/.readme/README-es.md)
 - [日本語 [ja]](http://project.autojs6.com/blob/master/.readme/README-ja.md)
 - [한국어 [ko]](http://project.autojs6.com/blob/master/.readme/README-ko.md)
 - [Русский [ru]](http://project.autojs6.com/blob/master/.readme/README-ru.md)
 - العربية [ar] # حالي

******

### المقدمة

******

[Auto.js](https://github.com/hyb1996/Auto.js) هو برنامج أتمتة JavaScript مدعوم على منصة Android مع [خدمة الوصول](https://developer.android.com/guide/topics/ui/accessibility/service?hl=zh-cn).

تم إصدار Auto.js لأول مرة بواسطة [hyb1996](https://github.com/hyb1996) في `2017/01/27`، وتوقف الصيانة في `2020/03/13`، وكان الإصدار الأخير هو `4.1.1 Alpha2` ورقم البنية `461`.

تم تطوير AutoJs6 استنادًا إلى المشروع النهائي لـ Auto.js في `2021/12/01`، ويستمر في أن يكون مفتوح المصدر ومجاني.

الجدول أدناه يضم بعض المشاريع ذات الصلة بـ Auto.js (مرتبة حسب تاريخ التطوير):

| <span style="word-break:keep-all;white-space:nowrap">المشروع</span> |                                                             <span style="word-break:keep-all;white-space:nowrap">اسم التطبيق</span>                                                              | <span style="word-break:keep-all;white-space:nowrap">المطور</span> | <span style="word-break:keep-all;white-space:nowrap">تاريخ بداية التطوير</span> | <span style="word-break:keep-all;white-space:nowrap">تاريخ نهاية التطوير</span> |
|:------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------:|:---------------------------------------------------------------------------------------------------------------------------------:|:-------------------------------------------------------------------------------------------------------------------------------:|
|     <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/hyb1996/Auto.js)</span>      |    <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/TonyJiangWJ/Auto.js/commit/268ec8895bbfa28fc7715154eb15b1c1eaaefd14#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span>     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2017/01/27`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2020/03/13`</span>                             |
|                     <span style="word-break:keep-all;white-space:nowrap">Auto.js Pro 7</span>                      |                                                                                     <span style="word-break:keep-all;white-space:nowrap">Auto.js</span>                                                                                      |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2019/03/13`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2019/07/08`</span>                             |
|                     <span style="word-break:keep-all;white-space:nowrap">Auto.js Pro 8</span>                      |                                                                                    <span style="word-break:keep-all;white-space:nowrap">AutoJsPro</span>                                                                                     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2019/10/13`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2021/07/24`</span>                             |
|   <span style="word-break:keep-all;white-space:nowrap">[Auto.js](https://github.com/TonyJiangWJ/Auto.js)</span>    | <span style="word-break:keep-all;white-space:nowrap">[Auto.js&#160;M](https://github.com/TonyJiangWJ/Auto.js/commit/268ec8895bbfa28fc7715154eb15b1c1eaaefd14#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span> |      <span style="word-break:keep-all;white-space:nowrap">[TonyJiangWJ](https://github.com/TonyJiangWJ)</span>       |                             <span style="word-break:keep-all;white-space:nowrap">`2019/11/21`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|      <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/kkevsekk1/AutoX)</span>       |                 <span style="white-space:pre">[Autox.js](https://github.com/kkevsekk1/AutoX/commit/8143e4ed893d4af05d22aa791b83a962f9959873#diff-5e01f7d37a66e4ca03deefc205d8e7008661cdd0284a05aaba1858e6b7bf9103R2)</span>                  |        <span style="word-break:keep-all;white-space:nowrap">[kkevsekk1](https://github.com/kkevsekk1)</span>         |                             <span style="word-break:keep-all;white-space:nowrap">`2020/07/24`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|        <span style="word-break:keep-all;white-space:nowrap">[Auto.js Pro 9](https://pro.autojs.org/)</span>        |                                                                                    <span style="word-break:keep-all;white-space:nowrap">AutoJsPro</span>                                                                                     |          <span style="word-break:keep-all;white-space:nowrap">[hyb1996](https://github.com/hyb1996)</span>           |                             <span style="word-break:keep-all;white-space:nowrap">`2021/03/28`</span>                              |                            <span style="word-break:keep-all;white-space:nowrap">`2023/02/09`</span>                             |
| <span style="word-break:keep-all;white-space:nowrap">[AutoJs6](https://github.com/SuperMonster003/AutoJs6)</span>  |  <span style="word-break:keep-all;white-space:nowrap">[AutoJs6](https://github.com/SuperMonster003/AutoJs6/commit/a8ce1b9acb541e9736c33134be3194c3148a15a3#diff-833a46a97033e77558372a2dce103fd6fee29aaaa899f610022a7aece592ee7bR27)</span>  |  <span style="word-break:keep-all;white-space:nowrap">[SuperMonster003](https://github.com/SuperMonster003)</span>   |                             <span style="word-break:keep-all;white-space:nowrap">`2021/12/01`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|      <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/kkevsekk1/AutoX)</span>       |            <span style="white-space:pre">[Autox.js&#160;v6](https://github.com/kkevsekk1/AutoX/commit/8b6776cff8b0fca4be4a52719b7d7d07c0a058f3#diff-51a0b488f963eb0be6c6599bf5df497313877cf5bdff3950807373912ac1cdc9R130)</span>             |           <span style="word-break:keep-all;white-space:nowrap">[wilinz](https://github.com/wilinz)</span>            |                             <span style="word-break:keep-all;white-space:nowrap">`2022/05/26`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |
|        <span style="word-break:keep-all;white-space:nowrap">[AutoX](https://github.com/aiselp/AutoX)</span>        |              <span style="white-space:pre">[Autox.js&#160;v7](https://github.com/aiselp/AutoX/commit/484491fd5fe12b8203d0b09c181eb0f471c0ea9f#diff-8cff73265af19c059547b76aca8882cbaa3209291406f52df1dafbbc78e80c46R120)</span>              |           <span style="word-break:keep-all;white-space:nowrap">[aiselp](https://github.com/aiselp)</span>            |                             <span style="word-break:keep-all;white-space:nowrap">`2024/04/21`</span>                              |                                  <span style="word-break:keep-all;white-space:nowrap">-</span>                                  |

التواريخ في الجدول هي تقديرات وقد تختلف عن الواقع.

في الجدول، تعد إصدارات Auto.js Pro 7/8/9 مدفوعة، والبقية مفتوحة المصدر ومجانية.

******

### الوظائف

******

* يمكن استخدامه كبيئة تطوير تكاملية (IDE) لـ JavaScript (إكمال الكود / إعادة تسمية المتغيرات / تنسيق الكود)
* دعم تشغيل الأتمتة باستناد إلى [خدمة الوصول](https://developer.android.com/reference/android/accessibilityservice/AccessibilityService)
* دعم الإجراءات السريعة لزر الطفو (تسجيل وتشغيل السكربت / عرض حزمة النشاط / تحليل التخطيط)
* دعم واجهة برمجة التطبيقات الخاصة بالموصل وتوفير التصفح/استرجاع المعلومات/تشغيل الموصلات (مشابه لـ [UiAutomator](https://developer.android.com/training/testing/ui-automator))
* دعم تحليل واجهة التخطيط (مشابه لـ LayoutInspector في Android Studio)
* دعم ميزة التسجيل وتشغيل التسجيل
* دعم لقطة الشاشة/حفظ لقطة الشاشة/البحث عن اللون في الصورة/مطابقة الصورة
* دعم كتابة الواجهة باستخدام [E4X](https://zh.wikipedia.org/wiki/E4X) (ECMAScript for XML)
* دعم تجميع ملفات أو مشاريع السكربت إلى ملفات APK
* دعم توسيع الميزات باستخدام صلاحيات الروت (النقر, السحب, التسجيل, أوامر shell)
* دعم الاستخدام كمكون إضافي لـ Tasker
* دعم الاتصال بـ VSCode وتطوير سطح المكتب (تحتاج إلى المكون الإضافي [AutoJs6-VSCode-Extension](http://vscext-project.autojs6.com))

******

### البيئة

******

- نظام تشغيل Android
- [API](https://developer.android.com/guide/topics/manifest/uses-sdk-element#ApiLevels) [24](https://developer.android.com/reference/android/os/Build.VERSION_CODES#N) ([7.0](https://zh.wikipedia.org/wiki/Android_Nougat)) [[N](https://developer.android.com/reference/android/os/Build.VERSION_CODES#N)] وما بعده

******

### الدليل

******

* [وثائق التطبيق](https://docs.autojs6.com)
* [دليل المستخدم (قيد الإنشاء)](https://docs.autojs6.com/#/manual)
* [استكشاف الأخطاء وإصلاحها](https://docs.autojs6.com/#/qa)
* [تجميع وبناء المشروع](#project-compilation-and-build)
* [مساعدة تطوير السكريبت](#script-development-assistance)

******

### التغييرات الرئيسية

******

مقارنةً بالإصدار النهائي المفتوح المصدر لـ Auto.js `4.1.1 Alpha2`، فإن AutoJs6 قد أجرت التحديثات أو التغييرات الرئيسية التالية:

* دعم امتيازات ADB باستخدام [Shizuku](https://shizuku.rikka.app/introduction/) واستخدام واجهة برمجة التطبيقات للنظام
* دعم بناء مثيلات [WebSocket](https://docs.autojs6.com/#/webSocketType) لإرسال طلبات الشبكة استنادًا إلى [بروتوكول WebSocket](https://zh.wikipedia.org/wiki/WebSocket)
* وحدات جديدة [ [base64](https://docs.autojs6.com/#/base64) / [crypto](https://docs.autojs6.com/#/crypto) / [sqlite](https://docs.autojs6.com/#/sqlite) / [i18n](https://docs.autojs6.com/#/i18n) / [notice](https://docs.autojs6.com/#/notice) / [ocr](https://docs.autojs6.com/#/ocr) / [opencc](https://docs.autojs6.com/#/opencc) / [qrcode](https://docs.autojs6.com/#/qrcode) / [shizuku](https://docs.autojs6.com/#/shizuku) / ... ]
* دعم التكيف متعدد اللغات [ الإسبانية / الفرنسية / الروسية / العربية / اليابانية / الكورية / الإنجليزية / الصينية المبسطة / الصينية التقليدية / ... ]
* تكييف ألوان الموضوع [ التجميع / الموقع / البحث / السجل / التكييف التلقائي للسطوع والتباين / ... ]
* دعم وضع الليل [ صفحة الإعدادات / صفحة الوثائق / صفحة تحليل التخطيط / النافذة العائمة / ... ]
* دعم الاتصال بـ [المكون الإضافي لـ VSCode](http://vscext-project.autojs6.com) بطرق الاتصال عبر الشبكة المحلية (LAN) و ADB
* تم ترقية محرك [Rhino](https://github.com/mozilla/rhino/) من [v1.7.7.2](https://github.com/mozilla/rhino/releases/tag/Rhino1_7_7_2_Release) إلى [v1.8.1-SNAPSHOT](http://rhino.autojs6.com/blob/master/gradle.properties#L3)
    * دعم هروب نقطة الرمز Unicode [للأحرف متعددة المستويات](https://zh.wikipedia.org/wiki/Unicode%E5%AD%97%E7%AC%A6%E5%B9%B3%E9%9D%A2%E6%98%A0%E5%B0%84#%E7%AC%AC%E4%B8%80%E8%BC%94%E5%8A%A9%E5%B9%B3%E9%9D%A2)
       ```javascript
       '\u{1D160}'; /* تمثل "𝅘𝅥𝅮", طريقة تقليدية: '\uD834\uDD60'. */
       ```
    * دعم [Object.values()](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Global_Objects/Object/values)
       ```javascript
       Object.values({name: 'Max', age: 4}); // ['max', 4]
       ```
    * دعم [Array.prototype.includes()](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Global_Objects/Array/includes)
       ```javascript
       [10, 20, NaN].includes(20); // true
       ```
    * دعم [BigInt](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Global_Objects/BigInt)
       ```javascript
       typeof 567n === 'bigint'; // true
       ```
    * دعم [القوالب النصية](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Template_literals)
       ```javascript
       `Lucky number: ${(Math.random() * 100).toFixed(0)}`
       ```
    * عرض [المزيد من الميزات الجديدة](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/RHINO.md) لمحرك Rhino
    * عرض [قائمة التوافق](https://mozilla.github.io/rhino/compat/engines.html) لمحرك Rhino

******

### تاريخ الإصدارات

******

# v6.6.4

###### 2025/05/31

* `تلميح` تغيير API: ui.(status/navigation)BarAppearanceLight[By] -> ui.(status/navigation)BarIconLight[By]
* `إضافة جديدة` طرق util.dpToPx/spToPx/pxToDp/pxToSp لتحويل وحدات البكسل
* `تصليح` مشكلة عرض العنوان الفرعي بشكل غير مكتمل عند تدوير الشاشة إلى الوضع الأفقي
* `تصليح` مشكلة تغطية جزء من محتوى الصفحة بواسطة شريط التنقل الجانبي عند التدوير إلى الوضع الأفقي
* `تصليح` منطقة تلوين خلفية شريط الحالة غير مكتملة في بعض الصفحات على Android 15 _[`issue #398`](http://issues.autojs6.com/398)_
* `تصليح` قد يستخدم محرر الأكواد ترميزًا منخفض الثقة عند الكتابة مما يؤدي إلى أخطاء فك الترميز (محاولة إصلاح)
* `تحسين` زيادة توافق التخطيط في صفحات التطبيق والمطور وإزالة تصنيفات التخطيط غير الضرورية
* `تحسين` في README.md، قسم البناء، إضافة طرق متعددة لتسهيل تحديد صفحة إعداد الهدف _[`issue #404`](http://issues.autojs6.com/404)_
* `تحسين` تعديلات على إصدارات بعض التبعيات أو المكتبات المحلية _[`CHANGELOG.md`](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG.md#v664)_

# v6.6.3

###### 2025/05/27

* `إضافة جديدة` ميزة سجل الإصدارات: عرض سجل التغييرات متعدد اللغات والإحصائيات
* `إضافة جديدة` الدالة timers.keepAlive (أصبحت عالمية) للحفاظ على بقاء السكربت نشطًا
* `إضافة جديدة` مستمعو الأحداث مثل engines.on('start/stop/error', callback) لأحداث المحرك العامة
* `إضافة جديدة` الدالة images.detectMultiColors للتحقق من ألوان متعددة النقاط _[`issue #374`](http://issues.autojs6.com/374)_
* `إضافة جديدة` الدوال images.matchFeatures/detectAndComputeFeatures: بحث صور بدقة كاملة (انظر [Auto.js Pro](https://g.pro.autojs.org/)) _[`issue #366`](http://issues.autojs6.com/366)_
* `إضافة جديدة` الدالة images.compressToBytes لضغط الصورة وإنتاج مصفوفة بايتات
* `إضافة جديدة` الدالة images.downsample لخفض الدقة وإنشاء ImageWrapper جديد
* `إضافة جديدة` الدالة ui.keepScreenOn لإبقاء الشاشة مضاءة عند تركيز صفحة الواجهة
* `إضافة جديدة` خاصية ui.root (getter) للحصول على عقدة "حاوية المحتوى الجذرية للنافذة" في تخطيط الواجهة
* `إضافة جديدة` عنصر webview يدعم تخطيطات صفحات الويب عبر JsBridge (انظر [Auto.js Pro](https://g.pro.autojs.org/)) [مثال: Layout > Interactive HTML / Vue2 + Vant (SFC)] _[`issue #281`](http://issues.autojs6.com/281)_
* `تصليح` قد يتم حجب بعض محتوى الوثائق عبر الإنترنت في تبويب Docs وصفحة الوثائق بواسطة شريط التنقل
* `تصليح` في بعض الصفحات قد يؤدي النقر على أزرار شريط الأدوات إلى تفعيل حدث النقر على العنوان بالخطأ
* `تصليح` السطور الفارغة في محرّر الشيفرة تظهر كرموز مربّعة على بعض الأجهزة
* `تصليح` مربع حوار لوحة الألوان في إعداد لون السمة قد يتراكم بلا حدود
* `تصليح` زر رفع الصوت لا يوقف جميع السكربتات عند تعطيل خدمة الوصول
* `تصليح` تداخل لوحة المفاتيح عند تحرير بث مخصّص في صفحة المهام المجدولة
* `تصليح` عناصر التحكم داخل webview لا تستطيع تفعيل لوحة المفاتيح البرمجية بشكل صحيح
* `تصليح` قد يفشل مربع معلومات APK في جلب اسم التطبيق أو معلومات SDK
* `تصليح` قد لا يتم تحميل محتوى المجلدات الفرعية تلقائيًا عند دخول مجلد مشروع في مثال مدير الملفات
* `تصليح` تغطية المحتوى العلوي بشريط الحالة في وضع الواجهة على Android 15
* `تصليح` لون خلفية شريط الحالة في بعض صفحات Android 15 لا يتبع لون السمة ديناميكيًا
* `تصليح` وحدة dialogs لا تدعم الخاصية customView _[`issue #364`](http://issues.autojs6.com/364)_
* `تصليح` قد لا يُرجع معامِل التعبير في dialogs.input نتيجة التنفيذ
* `تصليح` استخدام JavaAdapter يسبب تجاوز مكدس ClassLoader _[`issue #376`](http://issues.autojs6.com/376)_
* `تصليح` console.setContentTextColor يفقد اللون الافتراضي للنص _[`issue #346`](http://issues.autojs6.com/346)_
* `تصليح` console.setContentBackgroundColor لا يقبل أسماء الألوان _[`issue #384`](http://issues.autojs6.com/384)_
* `تصليح` تم تصحيح آلية images.compress: تغيّر جودة التشفير بدل خفض البكسلات
* `تصليح` الدالة images.resize لا تعمل بشكل صحيح
* `تصليح` engines.all قد يطلق ConcurrentModificationException _[`issue #394`](http://issues.autojs6.com/394)_
* `تصليح` تنسيقات تاريخ غير صحيحة في بعض اللغات داخل README.md
* `تصليح` قد تفشل عملية بناء Gradle بسبب طول غير صالح لأرشيف مكتبة _[`issue #389`](http://issues.autojs6.com/389)_
* `تحسين` مصحح التخطيط يدعم إخفاء العناصر (بواسطة [TonyJiangWJ](https://github.com/TonyJiangWJ)) _[`pr #371`](http://pr.autojs6.com/371)_ _[`issue #355`](http://issues.autojs6.com/355)_
* `تحسين` إضافة فواصل متدرّجة في قائمة مصحح التخطيط لتجميع الوظائف
* `تحسين` يدعم project.json خيار permissions لمشاريع السكربتات (بواسطة [wirsnow](https://github.com/wirsnow)) _[`pr #391`](http://pr.autojs6.com/391)_ _[`issue #362`](http://issues.autojs6.com/362)_
* `تحسين` عند حزم ملف واحد تُقرأ أذونات التطبيق المثبت وتُحدد تلقائيًا _[`issue #362`](http://issues.autojs6.com/362)_
* `تحسين` توسيع نطاق تطبيق لون السمة ودعم المزيد من عناصر الواجهة
* `تحسين` تكيّف عرض الدرج الرئيسي للشاشات الأفقية والعريضة جدًا
* `تحسين` إضافة تخطيطات أفقية وصغيرة للصفحات «حول التطبيق» و«المطور»
* `تحسين` حوار إعدادات يوفر خيار "استخدام القيمة الافتراضية"
* `تحسين` زر الإجراء العائم في مدير الملفات يختفي تلقائيًا عند النقر خارجَه
* `تحسين` مُنسّق الشيفرة يدعم العناصر `??` و `?.` و `??=`
* `تحسين` يدعم محرّر الشيفرة قراءة وكتابة الملفات بترميزات GB18030 / UTF-16 (LE/BE) / Shift_JIS وغيرها
* `تحسين` يدعم محرّر الشيفرة عرض معلومات تفصيلية عن الملف (المسار/الترميز/فاصل الأسطر/إجمالي البايتات والحروف، إلخ.) _[`issue #395`](http://issues.autojs6.com/395)_
* `تحسين` إضافة رسائل خطأ لعمليات Intent (تحرير/عرض/تثبيت/إرسال/تشغيل وغيرها)
* `تحسين` خاصية url في webview تدعم المسارات النسبية
* `تحسين` وسيط path في ImageWrapper#saveTo يدعم المسارات النسبية
* `تحسين` images.save يدعم ضغط ملفات PNG عند استخدام الوسيط quality _[`issue #367`](http://issues.autojs6.com/367)_
* `تحسين` دعم مسح سجلات التحديثات المُتجاهَلة وعناوين وضع العميل
* `تحسين` معلومات التحديث تعرض بعدة لغات متزامنة مع لغة الواجهة الحالية
* `تحسين` التحميل غير المتزامن يحسّن سلاسة التمرير في قائمة مدير الملفات
* `تحسين` تحسين محتوى وتنسيق رسائل استثناء السكربت في وحدة التحكم
* `تحسين` أمثلة الشيفرة تدعم إعادة تعيين المجلد إلى محتواه الأصلي
* `تحسين` زيادة كفاءة التحقق من توقيع APK
* `تحسين` تحسين سرعة عرض وحالة معلومات حوارات ملفات APK/الوسائط
* `تحسين` نص بناء Gradle أصبح أكثر قدرة على التكيّف مع الإصدارات الجديدة _[`discussion #369`](http://discussions.autojs6.com/369)_
* `تحسين` تعديلات على إصدارات بعض التبعيات أو المكتبات المحلية _[`CHANGELOG.md`](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG.md#v663)_

# v6.6.2

###### 2025/04/16

* `إضافة جديدة` طرق مثل ui.statusBarAppearanceLight و statusBarAppearanceLightBy و navigationBarColor وغيرها.
* `إضافة جديدة` الخاصية ui.statusBarHeight (getter) المستخدمة للحصول على ارتفاع شريط الحالة _[`issue #357`](http://issues.autojs6.com/357)_
* `إضافة جديدة` طريقة images.flip لقلب الصور _[`issue #349`](http://issues.autojs6.com/349)_
* `إضافة جديدة` تمت إضافة خيار "امتداد الملف" في صفحة الإعدادات
* `إضافة جديدة` صفحة إعدادات اللون الموضوع تدعم الآن تنسيقاً جديداً (تجميع، تحديد موضع، بحث، سجل، تحسين لوحة الألوان، الخ)
* `تصليح` المشكلة التي كان فيها لون خلفية شريط الحالة على Android 15 لا يتطابق مع لون الموضوع
* `تصليح` المشكلة التي كان فيها طريقة plugins.load لا تحمل الإضافات بشكل صحيح _[`issue #290`](http://issues.autojs6.com/290)_
* `تصليح` المشكلة التي كان فيها مكتبة dx لا تعمل بشكل صحيح على Android 7.x _[`issue #293`](http://issues.autojs6.com/293)_
* `تصليح` المشكلة التي كان فيها ScriptRuntime قد يظهر حالة تزامن غير طبيعية عند استخدام require لاستيراد الوحدات المدمجة (حل مؤقت) _[`issue #298`](http://issues.autojs6.com/298)_
* `تصليح` المشكلة التي كان فيها وحدة notice تفتقر إلى طرق التمديد مثل getBuilder _[`issue #301`](http://issues.autojs6.com/301)_
* `تصليح` المشكلة التي كان فيها طرق shizuku/shell لا تقبل معاملات نصية _[`issue #310`](http://issues.autojs6.com/310)_
* `تصليح` المشكلة التي كان فيها طريقة colors.pixel لا تقبل معاملات الصور ذات القناة الواحدة _[`issue #350`](http://issues.autojs6.com/350)_
* `تصليح` المشكلة التي كان فيها طرق engines.execScript/execScriptFile تستخدم مسار عمل افتراضي غير صحيح عند تنفيذ السكريبتات _[`issue #358`](http://issues.autojs6.com/358)_ _[`issue #340`](http://issues.autojs6.com/340)_ _[`issue #339`](http://issues.autojs6.com/339)_
* `تصليح` المشكلة التي كان فيها floaty.window/floaty.rawWindow لا يمكن تنفيذها في الخيوط الثانوية
* `تصليح` المشكلة التي كان فيها floaty.getClip قد لا يسترجع محتوى الحافظة بشكل صحيح _[`issue #341`](http://issues.autojs6.com/341)_
* `تصليح` المشكلة التي كان فيها ناتج ui.inflate يفتقد إلى طرق البروتوتايب مثل attr و on و click
* `تصليح` مشكلة يتم فيها ربط سياق النطاق بشكل غير صحيح عند استخدام صياغة XML لاستخدام تعبير JavaScript كقيمة لخاصية _[`issue #319`](http://issues.autojs6.com/319)_
* `تصليح` المشكلة التي كانت فيها استثناءات بعض الطرق لا يتم التقاطها بواسطة كتلة try..catch _[`issue #345`](http://issues.autojs6.com/345)_
* `تصليح` المشكلة التي كان فيها توليد الكود في صفحة تحليل التخطيطات قد يؤدي إلى تعطل التطبيق _[`issue #288`](http://issues.autojs6.com/288)_
* `تصليح` المشكلة التي كان فيها التطبيقات المعبأة لا يمكنها استخدام وحدة shizuku بشكل صحيح _[`issue #227`](http://issues.autojs6.com/227)_ _[`issue #231`](http://issues.autojs6.com/231)_ _[`issue #284`](http://issues.autojs6.com/284)_ _[`issue #287`](http://issues.autojs6.com/287)_ _[`issue #304`](http://issues.autojs6.com/304)_
* `تصليح` المشكلة في محرر الكود حيث الانتقال إلى نهاية السطر قد ينقل المؤشر إلى بداية السطر التالي
* `تصليح` المشكلة التي كان فيها النقر المتتالي السريع على العناصر الحوارية في صفحة الإعدادات قد يؤدي إلى تعطل التطبيق
* `تحسين` تحسين حجم ملف APK في قالب التطبيق المعبأ
* `تحسين` التطبيق (والتطبيقات المعبأة) الآن يدعم المزيد من الأذونات _[`issue #338`](http://issues.autojs6.com/338)_
* `تحسين` تمت إضافة خيار لمكتبة Pinyin في صفحة التعبئة
* `تحسين` تحسين خلفية شريط الحالة ولون النص في الصفحة الرئيسية للتطبيقات المعبأة
* `تحسين` إضافة مفاتيح لتبديل الأذونات الخاصة (الوصول إلى جميع الملفات وإرسال الإشعارات) في صفحة إعدادات التطبيقات المعبأة _[`issue #354`](http://issues.autojs6.com/354)_
* `تحسين` التكيف التلقائي لألوان نصوص وأيقونات عناصر التحكم بناءً على سطوع لون الموضوع
* `تحسين` تحسين التجربة البصرية عند انخفاض التباين بين لون عنصر التحكم وخلفيته
* `تحسين` تحسين توافقية حقل إدخال HEX في لوحة الألوان عند لصق القيم من الحافظة
* `تحسين` تعيين شريط التنقل في التطبيق ليكون شفافاً أو شبه شفاف لتحسين التجربة البصرية
* `تحسين` وضع واجهة المستخدم الافتراضي لشريط الحالة وشريط التنقل مضبوط على اللون `md_grey_50` في الوضع الفاتح
* `تحسين` مفتاح خدمة إمكانية الوصول في القائمة الرئيسية يتزامن الآن مع كود السكريبت
* `تحسين` صفحة الوثائق في الصفحة الرئيسية تدعم الآن أزرار البحث الثنائي الاتجاه
* `تحسين` علامة تبويب "الملفات" في الصفحة الرئيسية تسمح بتغيير ظهور الزر العائم عبر الضغط المطول
* `تحسين` عنوان محرر الكود يدعم الآن تغيير حجم الخط تلقائياً
* `تحسين` ظهور الزر العائم في صفحة السجلات مرتبط بحركات التمرير في القائمة
* `تحسين` ملف إعداد project.json لمشروع السكريبت يدعم الآن المزيد من خيارات التعبئة _[`issue #305`](http://issues.autojs6.com/305)_ _[`issue #306`](http://issues.autojs6.com/306)_
* `تحسين` ملف project.json يدعم الآن مطابقة أكثر مرونة لأسماء الخيارات والتوافق مع الأسماء المستعارة
* `تحسين` حوار معلومات نوع ملف APK يشمل الآن حجم الملف ومعلومات توقيع المخطط
* `تحسين` حوار معلومات نوع ملف APK يدعم الآن مستمعي النقر لنسخ النص والتنقل إلى تفاصيل التطبيق
* `تحسين` محاولة لاستعادة الحزم التي تحمل بادئة com.stardust لتحسين توافقية الكود _[`issue #290`](http://issues.autojs6.com/290)_
* `تحسين` طرق floaty.window/floaty.rawWindow أصبحت تدعم التنفيذ في الخيط الرئيسي والثانوي
* `تحسين` الطريقة العامة getClip تستخدم الآن floaty.getClip عند الحاجة لتحسين التوافقية
* `تحسين` تحسين توافقية طرق files.path والطرق المرتبطة عند تمرير قيمة فارغة لمسار
* `تحسين` المزامنة مع أحدث إصدار رسمي لمحرك Rhino وتعديل الكود اللازم
* `تحسين` تحسين README.md لتوثيق أفضل لعملية بناء وتشغيل المشروع _[`issue #344`](http://issues.autojs6.com/344)_
* `تحسين` تعديلات على إصدارات بعض التبعيات أو المكتبات المحلية _[`CHANGELOG.md`](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG.md#v662)_

##### لمزيد من تاريخ الإصدارات، ارجع إلى

* [CHANGELOG.md](http://project.autojs6.com/blob/master/app/src/main/assets-app/doc/CHANGELOG-ar.md)

******

### <a id="project-compilation-and-build"></a>تجميع وبناء المشروع

******

لتصحيح أو تطوير مشروع AutoJs6، يمكنك استخدام [Android Studio](https://pro.autojs.org/) (منتج من [Google](https://www.google.com/)) أو [IntelliJ IDEA](https://www.jetbrains.com/idea/) (منتج من [Jetbrains](https://www.jetbrains.com/)).

يتناول هذا القسم طرق بناء وتجميع مشروع AutoJs6 المفتوح المصدر مستخدمًا Android Studio كمثال، يمكن استخدام IntelliJ IDEA بنفس الطريقة.

#### تحضير Android Studio

قم بتنزيل إصدار `Android Studio Meerkat Feature Drop | 2024.3.2 Patch 1` (حدد أحدها حسب الحاجة):

- [android-studio-2024.3.2.15-windows.exe](https://redirector.gvt1.com/edgedl/android/studio/install/2024.3.2.15/android-studio-2024.3.2.15-windows.exe) (1.23 GB)
- [android-studio-2024.3.2.15-windows.zip](https://redirector.gvt1.com/edgedl/android/studio/ide-zips/2024.3.2.15/android-studio-2024.3.2.15-windows.zip) (1.23 GB)

> ملاحظة: تاريخ الإصدار بالنسخة المذكورة أعلاه هو 28 May 2025. إذا كنت بحاجة إلى تنزيل إصدار آخر، أو إذا كان الرابط المذكور غير صالح، يمكنك زيارة [أرشيف إصدارات Android Studio](https://developer.android.com/studio/archive?hl=en).

قم بتثبيت أو فك ضغط الملف المذكور سابقًا، ثم قم بتشغيل برنامج Android Studio (مثل `"D:\android-studio\bin\studio64.exe"`).

#### تحضير Android SDK

> ملاحظة: إذا كان نظام الكمبيوتر يحتوي بالفعل على Android SDK (مجموعة تطوير البرمجيات لنظام أندرويد)، فيمكنك تخطي هذا القسم.

افتح صفحة إعدادات `Android SDK (مجموعة تطوير برمجيات أندرويد)` (بأيٍّ من الطرق التالية):

```text
Help (مساعدة) | Find action (بحث عن إجراء) # إدخال "Android SDK"
[ أو ]
File (ملف) | Settings (إعدادات) # بحث "Android SDK"
[ أو ]
File (ملف) | Settings (إعدادات) | Language & Frameworks (اللغات وأُطر العمل) | Android SDK (مجموعة تطوير البرامج لنظام Android)
[ أو ]
File (ملف) | Settings (إعدادات) | Appearance & Behavior (المظهر والسلوك) | System Settings (إعدادات النظام) | Android SDK (مجموعة تطوير البرامج لنظام Android)
```

إذا كان حقل `موقع Android SDK (Android SDK Location)` فارغًا، يمكنك النقر على زر `تحرير (Edit)` على اليمين، والنقر على `التالي (Next)` عدة مرات في النافذة المنبثقة.

> ملاحظة: قد يتطلب الأمر الموافقة على اتفاقية واحدة أو أكثر للاستمرار في العملية.

عندما يتم تنزيل وتثبيت الموارد ذات الصلة، انقر على زر `إنهاء (Finish)`.  
سيتم تلقائيًا ملء المسار في حقل `موقع Android SDK (Android SDK Location)` المشار إليه أعلاه، وسيتم إنجاز أعمال التحضير للـ SDK.

#### تحضير أدوات Android SDK

AutoJs6 يتطلب استخدام بعض أدوات SDK (مثل NDK وCMake).

> ملاحظة: إذا كان النظام يحتوي بالفعل على جميع أدوات Android SDK المطلوبة لمشروع AutoJs6، فيمكنك تخطي هذا القسم.

افتح صفحة إعدادات `SDK Tools (أدوات SDK)` (بأيٍّ من الطرق التالية):

```text
Help (مساعدة) | Find action (بحث عن إجراء) # إدخال "SDK Tools"
[ أو ]
File (ملف) | Settings (إعدادات) # بحث "SDK Tools"
[ أو ]
File (ملف) | Settings (إعدادات) | Language & Frameworks (اللغات وأُطر العمل) | Android SDK (مجموعة تطوير البرامج لنظام Android) | SDK Tools  (أدوات SDK) (في النافذة اليمنى)
[ أو ]
File (ملف) | Settings (إعدادات) | Appearance & Behavior (المظهر والسلوك) | System Settings (إعدادات النظام) | Android SDK (مجموعة تطوير البرامج لنظام Android) | SDK Tools  (أدوات SDK) (في النافذة اليمنى) 
```

حدد `إظهار تفاصيل الحزمة (Show Package Details)`، وقم بالنقر على NDK و CMake، وتأكد من تحديد الأدوات الخاصة بها ,تقع معلومات إصدار أدوات SDK في ملف `version.properties` في جذر مشروع AutoJs6.

#### تحضير JDK

يعتمد مشروع AutoJs6 على إصدار `JDK (مجموعة تطوير جافا)` بإصدار لا يقل عن `17`، ولكن يفضل الإصدار الذي لا يقل عن `19`.

اعتبارًا من 31 May 2025، الإصدار الأقصى المدعوم من JDK لمشروع AutoJs6 هو `24`.

> ملاحظة: إذا كان نظام الكمبيوتر يحتوي على JDK والإصدار يفي بالمتطلبات المذكورة أعلاه، فيمكنك تخطي هذا القسم.

يمكن تنزيل JDK مباشرةً باستخدام IDE، أو زيارة [موقع Oracle](https://www.oracle.com/java/technologies/downloads/) لتنزيله.

افتح صفحة إعدادات `Gradle JDK` (بأيٍّ من الطرق التالية):

```text
Help (مساعدة) | Find action (بحث عن إجراء) # إدخال "Gradle JDK"
[ أو ]
File (ملف) | Settings (إعدادات) # بحث "Gradle"
[ أو ]
File (ملف) | Settings (إعدادات) | Build, Execution, Deployment (البناء، التنفيذ، النشر) | Build Tools (أدوات البناء) | Gradle
```

يمكنك اختيار أو إضافة إصدار JDK مختلف في حقل `Gradle JDK`.

إذا كان الإصدار المناسب للـ JDK (>= `17`) موجوداً بالفعل في القائمة، فيمكنك تحديده مباشرةً.  
يمكنك اختيار `Download JDK (تنزيل JDK)` لتنزيل JDK المناسب، انقر على زر `Download (تنزيل)` وانتظر حتى يكتمل التنزيل.  
يمكنك أيضًا اختيار `Add JDK (إضافة JDK)` لإضافة JDK موجود محليًا، وتحديد مساره وإكمال الإضافة.

#### استنساخ موارد AutoJs6

في شاشة Android Studio الرئيسية، انقر على زر `Get from VCS (الحصول من نظام التحكم في الإصدارات)`.  
أدخل العنوان `https://github.com/SuperMonster003/AutoJs6.git` في حقل `URL (عنوان الموارد الموحدة)`,  
يمكن تعديل المسار في حقل `Directory (المجلد)` حسب الحاجة.  
انقر على زر `Clone (استنساخ)`، وانتظر حتى يكتمل استنساخ موارد مشروع AutoJs6 محليًا.

> ملاحظة: قد تتطلب العملية المذكورة أعلاه تثبيت [Git (نظام التحكم في الإصدار الموزع)](https://git-scm.com/download).

#### بناء مشروع AutoJs6

عند اكتمال الاستنساخ، سيفتح Android Studio نافذة مشروع AutoJs6، ويكمل تلقائيًا تنزيل `Dependencies (التبعيات)` الأساسية وبناء Gradle.

> ملاحظة: قد تستغرق العملية المذكورة أعلاه وقتًا طويلًا. إذا كانت حالة الشبكة غير جيدة، قد تحتاج إلى المحاولة عدة مرات (بالنقر على زر Retry).

إذا لم يتمكن البناء من المتابعة تلقائيًا أو إذا كنت بحاجة إلى إعادة بناء المشروع، فاتبع الخطوات التالية:

- من قائمة `Run/Debug Configurations` في شريط الأدوات، اختر `app`، وهو التطبيق الرئيسي لـ AutoJs6
- انقر على زر `Build Project` (رمز المطرقة) على اليسار لبدء بناء المشروع. الاختصار الافتراضي هو CTRL + F9
- انتظر انتهاء البناء. ستظهر رسالة في تبويب `Builder Output` مثل "BUILD SUCCESSFUL in 1h 17m 34s"

إذا فشل البناء، يمكنك الإبلاغ عن رسالة الخطأ في صفحة [Issues](http://issues.autojs6.com) لمشروع AutoJs6.

> ملحوظة: لمزيد من التفاصيل حول كيفية بناء وتشغيل التطبيق، يرجى الرجوع إلى [Android Docs](https://developer.android.com/studio/run?hl=en)

#### نشر مشروع AutoJs6 (تشغيل التطبيق)

بمجرد بناء المشروع بنجاح، يمكن نشره كتطبيق (App) على جهاز فعلي (مثل الهاتف/اللوحي) أو جهاز افتراضي (مثل محاكي Android).

- في شريط الأدوات، اختر `app` من قائمة `Run/Debug Configurations`، وهو التطبيق الرئيسي لـ AutoJs6
- في القائمة المنسدلة `Available Devices` على اليمين، اختر الجهاز الذي يجب تشغيل تطبيق المشروع عليه (جهاز فعلي أو افتراضي)
- انقر على زر `Run` (رمز المثلث) على اليمين لتشغيل التطبيق. الاختصار الافتراضي هو `F10`
- انتظر انتهاء النشر؛ سيقوم الجهاز المحدد بتثبيت وتشغيل التطبيق تلقائيًا

#### نشر مشروع AutoJs6 (إنشاء APK)

حزم المشروع وإنشاء ملف APK يمكن تثبيته على أجهزة Android:

- نسخة تجريبية (Debug Version)
    - `Build (بناء)` | `Build Bundle(s) / APK(s)` | `Build APK(s)`
    - توليد حزمة تثبيت الإصدار التجريبي مع التوقيع الافتراضي
    - مثال على المسار: `"D:\AutoJs6\app\build\outputs\apk\debug\"`
- نسخة مطروحة (Release Version)
    - `Build (بناء)` | `Generate Signed Bundle / APK`
    - اختيار خيار `APK`
    - قم بإعداد ملف التوقيع (تكوين جديد أو اختيار موجود)، وتوليد حزمة تثبيت الإصدار المطروح
    - مثال على المسار: `"D:\AutoJs6\app\release\"`

> ملحوظة: لمزيد من المعلومات حول كيفية بناء التطبيق لإصداره للمستخدمين، يرجى الرجوع إلى [Android Docs](https://developer.android.com/build/build-for-release?hl=en)

#### مهام بناء Gradle المحددة مسبقًا لـ AutoJs6

بالإضافة إلى بناء التطبيق، يدعم AutoJs6 عدة مهام بناء Gradle المحددة مسبقًا التي تساعد المطورين في تنفيذ العمليات المتعلقة بالمشروع بسهولة.

ضمن قائمة `Run/Debug Configurations` في شريط الأدوات، يمكنك العثور على المهام المحددة مسبقًا لـ Gradle، حيث تظهر أيقونة الفيل على اليسار لكل مهمة.

- AutoJs6 [inrt:assemble]

تجميع نسخة البناء "inrt"، التي تخدم بشكل أساسي ميزة تغليف نصوص AutoJs6.

يمتلك مشروع AutoJs6 نسخ بناء مختلفة. النسخة "inrt" تُستخدم لتغليف النصوص، حيث تقوم بإنشاء ملف النموذج "template.apk" المطلوب للتغليف.

عند استخدام ميزة التغليف، قد تواجه رسالة الخطأ التالية:

> java.io.FileNotFoundException: template.apk

هذا يشير إلى أن ملف النموذج غير موجود. يجب تشغيل مهمة `inrt:assemble` يدويًا لإنشاء ملف النموذج، ثم إعادة البناء والنشر مرة أخرى.

> ملحوظة: عند حدوث تغييرات في كود المشروع الرئيسي ورغبتك في مزامنة هذه التغييرات مع التطبيق المعبأ، يتعين عليك إعادة تشغيل مهمة `inrt:assemble` لتوليد ملفات القالب وإعادة نشر التطبيق

- AutoJs6 [app:bundle]

حزم مخرجات عملية البناء بوضع التصحيح، وتستخدم بشكل رئيسي لمشروع [تعريفات AutoJs6](http://dts-project.autojs6.com).

بعد تشغيل المهمة، يتم إنتاج أحدث ملف JAR لمشروع AutoJs6. باستخدام أداة [Android d.ts Generator](https://github.com/NativeScript/android-dts-generator) (من [NativeScript](https://github.com/NativeScript)) يمكنك إنشاء تعريفات الأنواع (بتنسيق d.ts) للتطبيق الرئيسي لـ AutoJs6.

- AutoJs6 [app:digest]

إلحاق معلومات الملخص بملف APK الذي تم إنتاجه من بناء الإصدار، وذلك لتحديد الاسم النهائي للملف قبل نشر أحدث نسخة من AutoJs6 على GitHub.

فيما يلي مقارنة بين أسماء الملفات قبل وبعد إلحاق معلومات الملخص:

```text
قبل:
autojs6-v6.6.2-arm64-v8a.apk
بعد:
autojs6-v6.6.2-arm64-v8a-0f2a9d74.apk
```

> مرجع: [Android Docs](https://developer.android.com/studio/run?hl=zh-cn)

******

### <a id="script-development-assistance"></a>مساعدة تطوير السكريبت

******

لتطوير سكربتات يمكن تشغيلها بواسطة AutoJs6، تحتاج إلى استخدام أدوات تطوير مناسبة:

- [VSCode](https://code.visualstudio.com/download) / [WebStorm](https://www.jetbrains.com/webstorm/download/) / [HBuilderX](https://www.dcloud.io/hbuilderx.html) ...

إذا كنت بحاجة إلى كتابة وتصحيح السكربتات على الكمبيوتر الشخصي، يمكن لمكون VSCode الإضافي تحقيق الاتصال بين الكمبيوتر والهاتف:

- [AutoJs6-VSCode-Extension](http://vscext-project.autojs6.com) - مصحح الأخطاء لـ AutoJs6 (مكون إضافي لـ VSCode)

أثناء كتابة الكود باستخدام أدوات التطوير، يمكن أن تساعد ميزة الإكمال التلقائي الذكية في إكمال الكود:

- [AutoJs6-TypeScript-Declarations](http://dts-project.autojs6.com) - ملفات تعريف AutoJs6 (إكمال الكود الذكي)

أثناء كتابة الكود، يمكن الرجوع إلى الوثائق التطبيقية لـ AutoJs6 والمعلومات حول استخدام API ذات الصلة:

- [AutoJs6-Documentation](http://docs-project.autojs6.com) - وثائق تطبيق AutoJs6

مشاريع تطوير السكربتات الموجودة يمكن أن تكون مرجعًا وإلهامًا لإنشاء المشاريع الشخصية:

- [Ant-Forest](https://github.com/TonyJiangWJ/Ant-Forest) - سكربت لجمع الطاقة تلقائيًا في غابة النمل بواسطة [TonyJiangWJ](https://github.com/TonyJiangWJ)
- [Ant-Forest](https://github.com/SuperMonster003/Ant-Forest) - سكربت لجمع الطاقة تلقائيًا في غابة النمل بواسطة [SuperMonster003](https://github.com/SuperMonster003)
- [autojs](https://github.com/e1399579/autojs) - سكربتات مفيدة لـ Auto.js بواسطة [e1399579](https://github.com/e1399579)
- [autojsDemo](https://github.com/snailuncle/autojsDemo) - أمثلة تجريبية لـ Auto.js بواسطة [snailuncle](https://github.com/snailuncle)
- [المستودعات ذات الصلة بـ autojs](https://github.com/topics/autojs) - جميع المستودعات المتعلقة بـ autojs على GitHub

******

### المشاركة بالإسهام

******

شكرًا لكل من ساهم في تطوير مشروع AutoJs6.

|         <span style="word-break:keep-all;white-space:nowrap">المساهمون</span>          |                   <span style="word-break:keep-all;white-space:nowrap">عدد الإرساليات</span>                    | <span style="word-break:keep-all;white-space:nowrap">أحدث الإرساليات</span> |
|:-------------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------------------------------------------:|:--------------------------------------------------------------------------------------------------------------:|
|             <span style="word-break:keep-all;white-space:nowrap">[wirsnow](https://github.com/wirsnow)</span>             |         <span style="word-break:keep-all;white-space:nowrap">[1](https://github.com/SuperMonster003/AutoJs6/commits?author=wirsnow)</span>         |                    <span style="word-break:keep-all;white-space:nowrap">`2025/05/19`</span>                    |
|         <span style="word-break:keep-all;white-space:nowrap">[TonyJiangWJ](https://github.com/TonyJiangWJ)</span>         |       <span style="word-break:keep-all;white-space:nowrap">[5](https://github.com/SuperMonster003/AutoJs6/commits?author=TonyJiangWJ)</span>       |                    <span style="word-break:keep-all;white-space:nowrap">`2025/04/24`</span>                    |
|          <span style="word-break:keep-all;white-space:nowrap">[luckyloogn](https://github.com/luckyloogn)</span>          |       <span style="word-break:keep-all;white-space:nowrap">[3](https://github.com/SuperMonster003/AutoJs6/commits?author=luckyloogn)</span>        |                    <span style="word-break:keep-all;white-space:nowrap">`2025/01/01`</span>                    |
|                <span style="word-break:keep-all;white-space:nowrap">[kvii](https://github.com/kvii)</span>                |          <span style="word-break:keep-all;white-space:nowrap">[1](https://github.com/SuperMonster003/AutoJs6/commits?author=kvii)</span>           |                    <span style="word-break:keep-all;white-space:nowrap">`2024/10/16`</span>                    |
|   <span style="word-break:keep-all;white-space:nowrap">[chenguangming](https://github.com/chenguangming) `(Tom)`</span>   | <span style="word-break:keep-all;white-space:nowrap">[2](https://github.com/SuperMonster003/AutoJs6/pulls?q=is%3Apr+author%3Achenguangming)</span> |                    <span style="word-break:keep-all;white-space:nowrap">`2024/05/14`</span>                    |
|          <span style="word-break:keep-all;white-space:nowrap">[LZX284](https://github.com/LZX284) `(AI)`</span>           |         <span style="word-break:keep-all;white-space:nowrap">[17](https://github.com/SuperMonster003/AutoJs6/commits?author=LZX284)</span>         |                    <span style="word-break:keep-all;white-space:nowrap">`2023/11/19`</span>                    |
| <span style="word-break:keep-all;white-space:nowrap">[little&#x2011;alei](https://github.com/little-alei) `(抠脚本人)`</span> |      <span style="word-break:keep-all;white-space:nowrap">[12](https://github.com/SuperMonster003/AutoJs6/commits?author=little-alei)</span>       |                    <span style="word-break:keep-all;white-space:nowrap">`2023/07/12`</span>                    |
|              <span style="word-break:keep-all;white-space:nowrap">[aiselp](https://github.com/aiselp)</span>              |    <span style="word-break:keep-all;white-space:nowrap">[6](https://github.com/SuperMonster003/AutoJs6/pulls?q=is%3Apr+author%3Aaiselp)</span>     |                    <span style="word-break:keep-all;white-space:nowrap">`2023/06/14`</span>                    |
|           <span style="word-break:keep-all;white-space:nowrap">[LYS86](https://github.com/LYS86) `(Lin)`</span>           |          <span style="word-break:keep-all;white-space:nowrap">[2](https://github.com/SuperMonster003/AutoJs6/commits?author=LYS86)</span>          |                    <span style="word-break:keep-all;white-space:nowrap">`2023/06/03`</span>                    |

تم تحديث البيانات في 27 May 2025.

تم تصنيف سجلات البيانات بترتيب تنازلي حسب `أحدث الإرساليات`.

طلبات السحب الجديدة غير المعالجة بعد، سيتم إدراجها في الإحصاءات بعد الدمج.

بعض المساهمين قد لا يظهرون بشكل صحيح في [GitHub Contributors](https://github.com/SuperMonster003/AutoJs6/graphs/contributors)، سجلات إسهاماتهم قد تكون فارغة، لكن يمكن مراجعة سجلات الإسهامات عبر [Pull Request](https://github.com/SuperMonster003/AutoJs6/pulls).

[//]: # (
    # --------------------------------------------------------------#
    # Before committing and pushing to the remote GitHub repository #
    # --------------------------------------------------------------#
    - IDE
        - The summary of the latest changelog for committing to Git [ DO NOT commit or push ]
    - $projectDir/version.properties
        - Remove the part like [ alpha / beta / ... ] of VERSION_NAME
    - $projectDir/.changelog/lang_zh-Hans.json
        - Update version name and released date
        - Translate into other languages
        - Update TypeScript declarations according to section `dependency` if needed
    - $projectDir/.readme/template_readme.md
        - Update badges like [ android studio / rhino / ... ]
        - Update contribution section: المشاركة بالإسهام
    - $projectDir/.readme/common.json
        - Update android studio download links and version names
        - Update contribution section: var_date_contribution_table_data_updated
    - $projectDir/.python/generate_markdown.py
        - Re-generate markdown by running the python script [ link: aj6mdgen ]
    - Others
        - Re-generate documentation by running the python script [ link: aj6docgen ]
        - Check the two-way versions for AutoJs6 and VSCode ext, then publish the ext to Microsoft if needed
        - Run Gradle task "app:assembleInrtRelease" [ shortcut: C+A+0#- ]
        - Build APK to determine the final VERSION_BUILD field [ shortcut: C+A+0#A ]
        - Run Gradle task "app:appendDigestToReleasedFiles" [ shortcut: C+A+0#= ]
        - Check VERSION_BUILD in version.properties with released apks
        - Commit and push to GitHub
        - Publish the latest release with signed APKs
)