/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.config;

import java.security.AccessController;
import java.util.Objects;
import org.mozilla.javascript.config.RhinoProperties;

public class RhinoConfig {
    private static final RhinoProperties INSTANCE = AccessController.doPrivileged(RhinoProperties::init);

    private static String get(String property, String defaultValue) {
        Object ret = INSTANCE.get(property);
        if (ret != null) {
            return ret.toString();
        }
        return defaultValue;
    }

    public static String get(String property) {
        return RhinoConfig.get(property, (String)null);
    }

    public static <T extends Enum<T>> T get(String property, T defaultValue) {
        Objects.requireNonNull(defaultValue, "defaultValue must not be null");
        Object ret = INSTANCE.get(property);
        if (ret != null) {
            Class<T> enumType = defaultValue.getDeclaringClass();
            for (Enum enm : (Enum[])enumType.getEnumConstants()) {
                if (!enm.name().equalsIgnoreCase(ret.toString())) continue;
                return (T)enm;
            }
        }
        return defaultValue;
    }

    public static boolean get(String property, boolean defaultValue) {
        Object ret = INSTANCE.get(property);
        if (ret instanceof Boolean) {
            return (Boolean)ret;
        }
        if (ret == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(ret.toString());
    }

    public static int get(String property, int defaultValue) {
        Object ret = INSTANCE.get(property);
        if (ret instanceof Number) {
            return ((Number)ret).intValue();
        }
        if (ret != null) {
            try {
                return Integer.decode(ret.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }
}

