/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.LambdaConstructor;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolKey;
import org.mozilla.javascript.Undefined;

public class NativeSymbol
extends ScriptableObject
implements Symbol {
    private static final long serialVersionUID = -589539749749830003L;
    public static final String CLASS_NAME = "Symbol";
    public static final String TYPE_NAME = "symbol";
    private static final Object GLOBAL_TABLE_KEY = new Object();
    private final SymbolKey key;
    private final SymbolKind kind;
    private final NativeSymbol symbolData;

    public static void init(Context cx, Scriptable scope, boolean sealed) {
        LambdaConstructor ctor = new LambdaConstructor(scope, CLASS_NAME, 0, 1, NativeSymbol::js_constructor);
        ctor.setPrototypePropertyAttributes(7);
        ctor.defineConstructorMethod(scope, "for", 1, (lcx, lscope, thisObj, args) -> NativeSymbol.js_for(lscope, args, ctor), 2, 3);
        ctor.defineConstructorMethod(scope, "keyFor", 1, NativeSymbol::js_keyFor, 2, 3);
        ctor.definePrototypeMethod(scope, "toString", 0, NativeSymbol::js_toString, 2, 3);
        ctor.definePrototypeMethod(scope, "valueOf", 0, NativeSymbol::js_valueOf, 2, 3);
        ctor.definePrototypeMethod(scope, SymbolKey.TO_PRIMITIVE, 1, NativeSymbol::js_valueOf, 3, 3);
        ctor.definePrototypeProperty(SymbolKey.TO_STRING_TAG, (Object)CLASS_NAME, 3);
        ctor.definePrototypeProperty(cx, "description", NativeSymbol::js_description, 3);
        ScriptableObject.defineProperty(scope, CLASS_NAME, ctor, 2);
        NativeSymbol.createStandardSymbol(scope, ctor, "iterator", SymbolKey.ITERATOR);
        NativeSymbol.createStandardSymbol(scope, ctor, "species", SymbolKey.SPECIES);
        NativeSymbol.createStandardSymbol(scope, ctor, "toStringTag", SymbolKey.TO_STRING_TAG);
        NativeSymbol.createStandardSymbol(scope, ctor, "hasInstance", SymbolKey.HAS_INSTANCE);
        NativeSymbol.createStandardSymbol(scope, ctor, "isConcatSpreadable", SymbolKey.IS_CONCAT_SPREADABLE);
        NativeSymbol.createStandardSymbol(scope, ctor, "isRegExp", SymbolKey.IS_REGEXP);
        NativeSymbol.createStandardSymbol(scope, ctor, "toPrimitive", SymbolKey.TO_PRIMITIVE);
        NativeSymbol.createStandardSymbol(scope, ctor, "match", SymbolKey.MATCH);
        NativeSymbol.createStandardSymbol(scope, ctor, "matchAll", SymbolKey.MATCH_ALL);
        NativeSymbol.createStandardSymbol(scope, ctor, "replace", SymbolKey.REPLACE);
        NativeSymbol.createStandardSymbol(scope, ctor, "search", SymbolKey.SEARCH);
        NativeSymbol.createStandardSymbol(scope, ctor, "split", SymbolKey.SPLIT);
        NativeSymbol.createStandardSymbol(scope, ctor, "unscopables", SymbolKey.UNSCOPABLES);
        if (sealed) {
            ctor.sealObject();
        }
    }

    NativeSymbol(SymbolKey key, SymbolKind kind) {
        this.key = key;
        this.symbolData = this;
        this.kind = kind;
    }

    public NativeSymbol(NativeSymbol s) {
        this.key = s.key;
        this.symbolData = s.symbolData;
        this.kind = s.kind;
    }

    SymbolKind getKind() {
        return this.kind;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    private static NativeSymbol createRegisteredSymbol(Scriptable scope, LambdaConstructor ctor, String name) {
        NativeSymbol sym = new NativeSymbol(new SymbolKey(name), SymbolKind.REGISTERED);
        sym.setPrototype(ctor.getClassPrototype());
        sym.setParentScope(scope);
        return sym;
    }

    private static void createStandardSymbol(Scriptable scope, LambdaConstructor ctor, String name, SymbolKey key) {
        NativeSymbol sym = new NativeSymbol(key, SymbolKind.BUILT_IN);
        sym.setPrototype(ctor.getClassPrototype());
        sym.setParentScope(scope);
        ctor.defineProperty(name, (Object)sym, 7);
    }

    private static NativeSymbol getSelf(Scriptable thisObj) {
        return LambdaConstructor.convertThisObject(thisObj, NativeSymbol.class);
    }

    private static NativeSymbol js_constructor(Context cx, Scriptable scope, Object[] args) {
        String desc = null;
        if (args.length > 0 && !Undefined.isUndefined(args[0])) {
            desc = ScriptRuntime.toString(args[0]);
        }
        if (args.length > 1) {
            return new NativeSymbol((SymbolKey)args[1], SymbolKind.REGULAR);
        }
        return new NativeSymbol(new SymbolKey(desc), SymbolKind.REGULAR);
    }

    private static String js_toString(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return NativeSymbol.getSelf(thisObj).toString();
    }

    private static Object js_valueOf(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return NativeSymbol.getSelf((Scriptable)thisObj).symbolData;
    }

    private static Object js_description(Scriptable thisObj) {
        return NativeSymbol.getSelf(thisObj).getKey().getDescription();
    }

    private static Object js_for(Scriptable scope, Object[] args, LambdaConstructor constructor) {
        String name = args.length > 0 ? ScriptRuntime.toString(args[0]) : ScriptRuntime.toString(Undefined.instance);
        Map<String, NativeSymbol> table = NativeSymbol.getGlobalMap(scope);
        return table.computeIfAbsent(name, k -> NativeSymbol.createRegisteredSymbol(scope, constructor, name));
    }

    private static Object js_keyFor(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object s;
        Object object = s = args.length > 0 ? args[0] : Undefined.instance;
        if (!(s instanceof NativeSymbol)) {
            throw ScriptRuntime.throwCustomError(cx, scope, "TypeError", "Not a Symbol");
        }
        NativeSymbol sym = (NativeSymbol)s;
        Map<String, NativeSymbol> table = NativeSymbol.getGlobalMap(scope);
        for (Map.Entry<String, NativeSymbol> e : table.entrySet()) {
            if (e.getValue().key != sym.key) continue;
            return e.getKey();
        }
        return Undefined.instance;
    }

    public String toString() {
        return this.key.toString();
    }

    private static boolean isStrictMode() {
        Context cx = Context.getCurrentContext();
        return cx != null && cx.isStrictMode();
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        if (!this.isSymbol()) {
            super.put(name, start, value);
        } else if (NativeSymbol.isStrictMode()) {
            throw ScriptRuntime.typeErrorById("msg.no.assign.symbol.strict", new Object[0]);
        }
    }

    @Override
    public void put(int index, Scriptable start, Object value) {
        if (!this.isSymbol()) {
            super.put(index, start, value);
        } else if (NativeSymbol.isStrictMode()) {
            throw ScriptRuntime.typeErrorById("msg.no.assign.symbol.strict", new Object[0]);
        }
    }

    @Override
    public void put(Symbol key, Scriptable start, Object value) {
        if (!this.isSymbol()) {
            super.put(key, start, value);
        } else if (NativeSymbol.isStrictMode()) {
            throw ScriptRuntime.typeErrorById("msg.no.assign.symbol.strict", new Object[0]);
        }
    }

    public boolean isSymbol() {
        return this.symbolData == this;
    }

    @Override
    public String getTypeOf() {
        return this.isSymbol() ? TYPE_NAME : super.getTypeOf();
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object x) {
        return this.key.equals(x);
    }

    SymbolKey getKey() {
        return this.key;
    }

    private static Map<String, NativeSymbol> getGlobalMap(Scriptable scope) {
        ScriptableObject top = (ScriptableObject)NativeSymbol.getTopLevelScope(scope);
        HashMap map = (HashMap)top.getAssociatedValue(GLOBAL_TABLE_KEY);
        if (map == null) {
            map = new HashMap();
            top.associateValue(GLOBAL_TABLE_KEY, map);
        }
        return map;
    }

    static enum SymbolKind {
        REGULAR,
        BUILT_IN,
        REGISTERED;

    }
}

