/*
 * Decompiled with CFR 0.152.
 */
package io.noties.prism4j;

import io.noties.prism4j.Cloner;
import io.noties.prism4j.GrammarImpl;
import io.noties.prism4j.Prism4j;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GrammarUtils {
    private static final Cloner CLONER = Cloner.create();

    @Nullable
    public static Prism4j.Token findToken(@NotNull Prism4j.Grammar grammar, @NotNull String path) {
        String[] parts = path.split("/");
        return GrammarUtils.findToken(grammar, parts, 0);
    }

    @Nullable
    private static Prism4j.Token findToken(@NotNull Prism4j.Grammar grammar, @NotNull String[] parts, int index) {
        String part = parts[index];
        boolean last = index == parts.length - 1;
        for (Prism4j.Token token : grammar.tokens()) {
            if (!part.equals(token.name())) continue;
            if (last) {
                return token;
            }
            Prism4j.Grammar inside = GrammarUtils.findFirstInsideGrammar(token);
            if (inside == null) break;
            return GrammarUtils.findToken(inside, parts, index + 1);
        }
        return null;
    }

    public static void insertBeforeToken(@NotNull Prism4j.Grammar grammar, @NotNull String path, Prism4j.Token ... tokens) {
        if (tokens == null || tokens.length == 0) {
            return;
        }
        String[] parts = path.split("/");
        GrammarUtils.insertBeforeToken(grammar, parts, 0, tokens);
    }

    private static void insertBeforeToken(@NotNull Prism4j.Grammar grammar, @NotNull String[] parts, int index, @NotNull Prism4j.Token[] tokens) {
        String part = parts[index];
        boolean last = index == parts.length - 1;
        List<Prism4j.Token> grammarTokens = grammar.tokens();
        int size = grammarTokens.size();
        for (int i = 0; i < size; ++i) {
            Prism4j.Token token = grammarTokens.get(i);
            if (!part.equals(token.name())) continue;
            if (last) {
                GrammarUtils.insertTokensAt(i, grammarTokens, tokens);
                break;
            }
            Prism4j.Grammar inside = GrammarUtils.findFirstInsideGrammar(token);
            if (inside == null) break;
            GrammarUtils.insertBeforeToken(inside, parts, index + 1, tokens);
            break;
        }
    }

    @Nullable
    public static Prism4j.Grammar findFirstInsideGrammar(@NotNull Prism4j.Token token) {
        Prism4j.Grammar grammar = null;
        for (Prism4j.Pattern pattern : token.patterns()) {
            if (pattern.inside() == null) continue;
            grammar = pattern.inside();
            break;
        }
        return grammar;
    }

    private static void insertTokensAt(int start, @NotNull List<Prism4j.Token> grammarTokens, @NotNull Prism4j.Token[] tokens) {
        int length = tokens.length;
        for (int i = 0; i < length; ++i) {
            grammarTokens.add(start + i, tokens[i]);
        }
    }

    @NotNull
    public static Prism4j.Grammar clone(@NotNull Prism4j.Grammar grammar) {
        return CLONER.clone(grammar);
    }

    @NotNull
    public static Prism4j.Token clone(@NotNull Prism4j.Token token) {
        return CLONER.clone(token);
    }

    @NotNull
    public static Prism4j.Pattern clone(@NotNull Prism4j.Pattern pattern) {
        return CLONER.clone(pattern);
    }

    @NotNull
    public static Prism4j.Grammar extend(@NotNull Prism4j.Grammar grammar, @NotNull String name, Prism4j.Token ... tokens) {
        int size;
        int n = size = tokens != null ? tokens.length : 0;
        if (size == 0) {
            return new GrammarImpl(name, GrammarUtils.clone(grammar).tokens());
        }
        HashMap<String, Prism4j.Token> overrides = new HashMap<String, Prism4j.Token>(size);
        for (Prism4j.Token token : tokens) {
            overrides.put(token.name(), token);
        }
        List<Prism4j.Token> origins = grammar.tokens();
        ArrayList<Prism4j.Token> out = new ArrayList<Prism4j.Token>(origins.size());
        for (Prism4j.Token origin : origins) {
            Prism4j.Token override = (Prism4j.Token)overrides.get(origin.name());
            if (override != null) {
                out.add(override);
                continue;
            }
            out.add(GrammarUtils.clone(origin));
        }
        return new GrammarImpl(name, out);
    }

    @NotNull
    public static Prism4j.Grammar extend(@NotNull Prism4j.Grammar grammar, @NotNull String name, @NotNull TokenFilter filter, Prism4j.Token ... tokens) {
        Map<String, Prism4j.Token> overrides;
        int size;
        int n = size = tokens != null ? tokens.length : 0;
        if (size == 0) {
            overrides = Collections.emptyMap();
        } else {
            overrides = new HashMap(size);
            for (Prism4j.Token token : tokens) {
                overrides.put(token.name(), token);
            }
        }
        List<Prism4j.Token> origins = grammar.tokens();
        ArrayList<Prism4j.Token> out = new ArrayList<Prism4j.Token>(origins.size());
        for (Prism4j.Token origin : origins) {
            if (!filter.test(origin)) continue;
            Prism4j.Token override = (Prism4j.Token)overrides.get(origin.name());
            if (override != null) {
                out.add(override);
                continue;
            }
            out.add(GrammarUtils.clone(origin));
        }
        return new GrammarImpl(name, out);
    }

    @NotNull
    public static Prism4j.Grammar require(@NotNull Prism4j prism4j, @NotNull String name) {
        Prism4j.Grammar grammar = prism4j.grammar(name);
        if (grammar == null) {
            throw new IllegalStateException("Unexpected state, requested language is not found: " + name);
        }
        return grammar;
    }

    private GrammarUtils() {
    }

    public static interface TokenFilter {
        public boolean test(@NotNull Prism4j.Token var1);
    }
}

