/**
 * This file was generated by kysely-codegen.
 * Please do not edit it manually.
 */

import type { ColumnType } from "kysely";

export type AuthProviderType = "google" | "oidc" | "saml";

export type Generated<T> = T extends ColumnType<infer S, infer I, infer U>
  ? ColumnType<S, I | undefined, U>
  : ColumnType<T, T | undefined, T>;

export type Int8 = ColumnType<string, bigint | number | string, bigint | number | string>;

export type Json = JsonValue;

export type JsonArray = JsonValue[];

export type JsonObject = {
  [x: string]: JsonValue | undefined;
};

export type JsonPrimitive = boolean | number | string | null;

export type JsonValue = JsonArray | JsonObject | JsonPrimitive;

export type Timestamp = ColumnType<Date, Date | string, Date | string>;

export interface Attachments {
  createdAt: Generated<Timestamp>;
  creatorId: string;
  deletedAt: Timestamp | null;
  fileExt: string;
  fileName: string;
  filePath: string;
  fileSize: Int8 | null;
  id: Generated<string>;
  mimeType: string | null;
  pageId: string | null;
  spaceId: string | null;
  type: string | null;
  updatedAt: Generated<Timestamp>;
  workspaceId: string;
}

export interface AuthAccounts {
  authProviderId: string | null;
  createdAt: Generated<Timestamp>;
  deletedAt: Timestamp | null;
  id: Generated<string>;
  providerUserId: string;
  updatedAt: Generated<Timestamp>;
  userId: string;
  workspaceId: string;
}

export interface AuthProviders {
  allowSignup: Generated<boolean>;
  createdAt: Generated<Timestamp>;
  creatorId: string | null;
  deletedAt: Timestamp | null;
  id: Generated<string>;
  isEnabled: Generated<boolean>;
  name: string;
  oidcClientId: string | null;
  oidcClientSecret: string | null;
  oidcIssuer: string | null;
  samlCertificate: string | null;
  samlUrl: string | null;
  type: AuthProviderType;
  updatedAt: Generated<Timestamp>;
  workspaceId: string;
}

export interface Backlinks {
  createdAt: Generated<Timestamp>;
  id: Generated<string>;
  sourcePageId: string;
  targetPageId: string;
  updatedAt: Generated<Timestamp>;
  workspaceId: string;
}

export interface Billing {
  amount: Int8 | null;
  cancelAt: Timestamp | null;
  cancelAtPeriodEnd: boolean | null;
  canceledAt: Timestamp | null;
  createdAt: Generated<Timestamp>;
  currency: string | null;
  deletedAt: Timestamp | null;
  endedAt: Timestamp | null;
  id: Generated<string>;
  interval: string | null;
  metadata: Json | null;
  periodEndAt: Timestamp | null;
  periodStartAt: Timestamp;
  quantity: Int8 | null;
  status: string;
  stripeCustomerId: string | null;
  stripeItemId: string | null;
  stripePriceId: string | null;
  stripeProductId: string | null;
  stripeSubscriptionId: string;
  updatedAt: Generated<Timestamp>;
  workspaceId: string;
}

export interface Comments {
  content: Json | null;
  createdAt: Generated<Timestamp>;
  creatorId: string | null;
  deletedAt: Timestamp | null;
  editedAt: Timestamp | null;
  id: Generated<string>;
  pageId: string;
  parentCommentId: string | null;
  resolvedAt: Timestamp | null;
  selection: string | null;
  type: string | null;
  workspaceId: string;
}

export interface Groups {
  createdAt: Generated<Timestamp>;
  creatorId: string | null;
  deletedAt: Timestamp | null;
  description: string | null;
  id: Generated<string>;
  isDefault: boolean;
  name: string;
  updatedAt: Generated<Timestamp>;
  workspaceId: string;
}

export interface GroupUsers {
  createdAt: Generated<Timestamp>;
  groupId: string;
  id: Generated<string>;
  updatedAt: Generated<Timestamp>;
  userId: string;
}

export interface PageHistory {
  content: Json | null;
  coverPhoto: string | null;
  createdAt: Generated<Timestamp>;
  icon: string | null;
  id: Generated<string>;
  lastUpdatedById: string | null;
  pageId: string;
  slug: string | null;
  slugId: string | null;
  spaceId: string;
  title: string | null;
  updatedAt: Generated<Timestamp>;
  version: number | null;
  workspaceId: string;
}

export interface Pages {
  content: Json | null;
  coverPhoto: string | null;
  createdAt: Generated<Timestamp>;
  creatorId: string | null;
  deletedAt: Timestamp | null;
  deletedById: string | null;
  icon: string | null;
  id: Generated<string>;
  isLocked: Generated<boolean>;
  lastUpdatedById: string | null;
  parentPageId: string | null;
  position: string | null;
  slugId: string;
  spaceId: string;
  textContent: string | null;
  title: string | null;
  tsv: string | null;
  updatedAt: Generated<Timestamp>;
  workspaceId: string;
  ydoc: Buffer | null;
}

export interface SpaceMembers {
  addedById: string | null;
  createdAt: Generated<Timestamp>;
  deletedAt: Timestamp | null;
  groupId: string | null;
  id: Generated<string>;
  role: string;
  spaceId: string;
  updatedAt: Generated<Timestamp>;
  userId: string | null;
}

export interface Spaces {
  createdAt: Generated<Timestamp>;
  creatorId: string | null;
  defaultRole: Generated<string>;
  deletedAt: Timestamp | null;
  description: string | null;
  id: Generated<string>;
  logo: string | null;
  name: string | null;
  slug: string;
  updatedAt: Generated<Timestamp>;
  visibility: Generated<string>;
  workspaceId: string;
}

export interface Users {
  avatarUrl: string | null;
  createdAt: Generated<Timestamp>;
  deactivatedAt: Timestamp | null;
  deletedAt: Timestamp | null;
  email: string;
  emailVerifiedAt: Timestamp | null;
  id: Generated<string>;
  invitedById: string | null;
  lastActiveAt: Timestamp | null;
  lastLoginAt: Timestamp | null;
  locale: string | null;
  name: string | null;
  password: string | null;
  role: string | null;
  settings: Json | null;
  timezone: string | null;
  updatedAt: Generated<Timestamp>;
  workspaceId: string | null;
}

export interface UserTokens {
  createdAt: Generated<Timestamp>;
  expiresAt: Timestamp | null;
  id: Generated<string>;
  token: string;
  type: string;
  usedAt: Timestamp | null;
  userId: string;
  workspaceId: string | null;
}

export interface WorkspaceInvitations {
  createdAt: Generated<Timestamp>;
  email: string | null;
  groupIds: string[] | null;
  id: Generated<string>;
  invitedById: string | null;
  role: string;
  token: string;
  updatedAt: Generated<Timestamp>;
  workspaceId: string;
}

export interface Workspaces {
  billingEmail: string | null;
  createdAt: Generated<Timestamp>;
  customDomain: string | null;
  defaultRole: Generated<string>;
  defaultSpaceId: string | null;
  deletedAt: Timestamp | null;
  description: string | null;
  emailDomains: Generated<string[] | null>;
  enforceSso: Generated<boolean>;
  hostname: string | null;
  id: Generated<string>;
  licenseKey: string | null;
  logo: string | null;
  name: string | null;
  plan: string | null;
  settings: Json | null;
  status: string | null;
  stripeCustomerId: string | null;
  trialEndAt: Timestamp | null;
  updatedAt: Generated<Timestamp>;
}

export interface DB {
  attachments: Attachments;
  authAccounts: AuthAccounts;
  authProviders: AuthProviders;
  backlinks: Backlinks;
  billing: Billing;
  comments: Comments;
  groups: Groups;
  groupUsers: GroupUsers;
  pageHistory: PageHistory;
  pages: Pages;
  spaceMembers: SpaceMembers;
  spaces: Spaces;
  users: Users;
  userTokens: UserTokens;
  workspaceInvitations: WorkspaceInvitations;
  workspaces: Workspaces;
}
