"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ERC721 = [
    {
        'constant': true,
        'inputs': [],
        'name': 'name',
        'outputs': [
            {
                'name': '',
                'type': 'string',
            },
        ],
        'payable': false,
        'stateMutability': 'view',
        'type': 'function',
    },
    {
        'constant': true,
        'inputs': [
            {
                'name': '',
                'type': 'uint256',
            },
        ],
        'name': 'kittyIndexToApproved',
        'outputs': [
            {
                'name': '',
                'type': 'address',
            },
        ],
        'payable': false,
        'stateMutability': 'view',
        'type': 'function',
    },
    {
        'constant': true,
        'inputs': [
            {
                'name': '',
                'type': 'address',
            },
            {
                'name': '',
                'type': 'uint256',
            },
        ],
        'name': 'allowed',
        'outputs': [
            {
                'name': '',
                'type': 'address',
            },
        ],
        'payable': false,
        'stateMutability': 'view',
        'type': 'function',
    },
    {
        'constant': true,
        'inputs': [
            {
                'name': '_tokenId',
                'type': 'uint256',
            },
        ],
        'name': 'getApproved',
        'outputs': [
            {
                'name': '',
                'type': 'address',
            },
        ],
        'payable': false,
        'stateMutability': 'view',
        'type': 'function',
    },
    {
        'constant': false,
        'inputs': [
            {
                'name': '_to',
                'type': 'address',
            },
            {
                'name': '_tokenId',
                'type': 'uint256',
            },
        ],
        'name': 'approve',
        'outputs': [],
        'payable': false,
        'stateMutability': 'nonpayable',
        'type': 'function',
    },
    {
        'constant': true,
        'inputs': [],
        'name': 'totalSupply',
        'outputs': [
            {
                'name': '',
                'type': 'uint256',
            },
        ],
        'payable': false,
        'stateMutability': 'view',
        'type': 'function',
    },
    {
        "constant": false,
        "inputs": [
            {
                "name": "_to",
                "type": "address"
            },
            {
                "name": "_tokenId",
                "type": "uint256"
            }
        ],
        "name": "transfer",
        "outputs": [],
        "payable": false,
        "stateMutability": "nonpayable",
        "type": "function"
    },
    {
        'constant': false,
        'inputs': [
            {
                'name': '_from',
                'type': 'address',
            },
            {
                'name': '_to',
                'type': 'address',
            },
            {
                'name': '_tokenId',
                'type': 'uint256',
            },
        ],
        'name': 'transferFrom',
        'outputs': [],
        'payable': false,
        'stateMutability': 'nonpayable',
        'type': 'function',
    },
    {
        'constant': true,
        'inputs': [
            {
                'name': '_owner',
                'type': 'address',
            },
            {
                'name': '_index',
                'type': 'uint256',
            },
        ],
        'name': 'tokenOfOwnerByIndex',
        'outputs': [
            {
                'name': '',
                'type': 'uint256',
            },
        ],
        'payable': false,
        'stateMutability': 'view',
        'type': 'function',
    },
    {
        'constant': false,
        'inputs': [
            {
                'name': '_from',
                'type': 'address',
            },
            {
                'name': '_to',
                'type': 'address',
            },
            {
                'name': '_tokenId',
                'type': 'uint256',
            },
        ],
        'name': 'safeTransferFrom',
        'outputs': [],
        'payable': false,
        'stateMutability': 'nonpayable',
        'type': 'function',
    },
    {
        'constant': true,
        'inputs': [
            {
                'name': '_tokenId',
                'type': 'uint256',
            },
        ],
        'name': 'exists',
        'outputs': [
            {
                'name': '',
                'type': 'bool',
            },
        ],
        'payable': false,
        'stateMutability': 'view',
        'type': 'function',
    },
    {
        'constant': true,
        'inputs': [
            {
                'name': '_index',
                'type': 'uint256',
            },
        ],
        'name': 'tokenByIndex',
        'outputs': [
            {
                'name': '',
                'type': 'uint256',
            },
        ],
        'payable': false,
        'stateMutability': 'view',
        'type': 'function',
    },
    {
        'constant': true,
        'inputs': [
            {
                'name': '_tokenId',
                'type': 'uint256',
            },
        ],
        'name': 'ownerOf',
        'outputs': [
            {
                'name': '',
                'type': 'address',
            },
        ],
        'payable': false,
        'stateMutability': 'view',
        'type': 'function',
    },
    {
        'constant': true,
        'inputs': [
            {
                'name': '_owner',
                'type': 'address',
            },
        ],
        'name': 'balanceOf',
        'outputs': [
            {
                'name': '',
                'type': 'uint256',
            },
        ],
        'payable': false,
        'stateMutability': 'view',
        'type': 'function',
    },
    {
        'constant': true,
        'inputs': [],
        'name': 'symbol',
        'outputs': [
            {
                'name': '',
                'type': 'string',
            },
        ],
        'payable': false,
        'stateMutability': 'view',
        'type': 'function',
    },
    {
        'constant': false,
        'inputs': [
            {
                'name': '_to',
                'type': 'address',
            },
            {
                'name': '_approved',
                'type': 'bool',
            },
        ],
        'name': 'setApprovalForAll',
        'outputs': [],
        'payable': false,
        'stateMutability': 'nonpayable',
        'type': 'function',
    },
    {
        'constant': false,
        'inputs': [
            {
                'name': '_from',
                'type': 'address',
            },
            {
                'name': '_to',
                'type': 'address',
            },
            {
                'name': '_tokenId',
                'type': 'uint256',
            },
            {
                'name': '_data',
                'type': 'bytes',
            },
        ],
        'name': 'safeTransferFrom',
        'outputs': [],
        'payable': false,
        'stateMutability': 'nonpayable',
        'type': 'function',
    },
    {
        'constant': true,
        'inputs': [
            {
                'name': '_tokenId',
                'type': 'uint256',
            },
        ],
        'name': 'tokenURI',
        'outputs': [
            {
                'name': '',
                'type': 'string',
            },
        ],
        'payable': false,
        'stateMutability': 'view',
        'type': 'function',
    },
    {
        'constant': true,
        'inputs': [
            {
                'name': '_owner',
                'type': 'address',
            },
            {
                'name': '_operator',
                'type': 'address',
            },
        ],
        'name': 'isApprovedForAll',
        'outputs': [
            {
                'name': '',
                'type': 'bool',
            },
        ],
        'payable': false,
        'stateMutability': 'view',
        'type': 'function',
    },
    {
        'inputs': [
            {
                'name': '_name',
                'type': 'string',
            },
            {
                'name': '_symbol',
                'type': 'string',
            },
        ],
        'payable': false,
        'stateMutability': 'nonpayable',
        'type': 'constructor',
    },
    {
        'anonymous': false,
        'inputs': [
            {
                'indexed': true,
                'name': '_from',
                'type': 'address',
            },
            {
                'indexed': true,
                'name': '_to',
                'type': 'address',
            },
            {
                'indexed': false,
                'name': '_tokenId',
                'type': 'uint256',
            },
        ],
        'name': 'Transfer',
        'type': 'event',
    },
    {
        'anonymous': false,
        'inputs': [
            {
                'indexed': true,
                'name': '_owner',
                'type': 'address',
            },
            {
                'indexed': true,
                'name': '_approved',
                'type': 'address',
            },
            {
                'indexed': false,
                'name': '_tokenId',
                'type': 'uint256',
            },
        ],
        'name': 'Approval',
        'type': 'event',
    },
    {
        'anonymous': false,
        'inputs': [
            {
                'indexed': true,
                'name': '_owner',
                'type': 'address',
            },
            {
                'indexed': true,
                'name': '_operator',
                'type': 'address',
            },
            {
                'indexed': false,
                'name': '_approved',
                'type': 'bool',
            },
        ],
        'name': 'ApprovalForAll',
        'type': 'event',
    },
];
//# sourceMappingURL=ERC721v3.js.map