//@ts-nocheck
// DO NOT MODIFY THIS FILE. This file is automatically generated by Tina
import { gql } from 'tinacms'
export type Maybe<T> = T | null
export type InputMaybe<T> = Maybe<T>
export type Exact<T extends { [key: string]: unknown }> = {
  [K in keyof T]: T[K]
}
export type MakeOptional<T, K extends keyof T> = Omit<T, K> & {
  [SubKey in K]?: Maybe<T[SubKey]>
}
export type MakeMaybe<T, K extends keyof T> = Omit<T, K> & {
  [SubKey in K]: Maybe<T[SubKey]>
}
/** All built-in and custom scalars, mapped to their actual values */
export type Scalars = {
  ID: string
  String: string
  Boolean: boolean
  Int: number
  Float: number
  /** References another document, used as a foreign key */
  Reference: any
  JSON: any
}

export type SystemInfo = {
  __typename?: 'SystemInfo'
  filename: Scalars['String']
  basename: Scalars['String']
  breadcrumbs: Array<Scalars['String']>
  path: Scalars['String']
  relativePath: Scalars['String']
  extension: Scalars['String']
  template: Scalars['String']
  collection: Collection
}

export type SystemInfoBreadcrumbsArgs = {
  excludeExtension?: InputMaybe<Scalars['Boolean']>
}

export type PageInfo = {
  __typename?: 'PageInfo'
  hasPreviousPage: Scalars['Boolean']
  hasNextPage: Scalars['Boolean']
  startCursor: Scalars['String']
  endCursor: Scalars['String']
}

export type Node = {
  id: Scalars['ID']
}

export type Document = {
  sys?: Maybe<SystemInfo>
  id: Scalars['ID']
  form: Scalars['JSON']
  values: Scalars['JSON']
}

/** A relay-compliant pagination connection */
export type Connection = {
  totalCount: Scalars['Float']
}

export type Query = {
  __typename?: 'Query'
  getCollection: Collection
  getCollections: Array<Collection>
  node: Node
  getDocument: DocumentNode
  getDocumentList: DocumentConnection
  getDocumentFields: Scalars['JSON']
  getPostsDocument: PostsDocument
  getPostsList: PostsConnection
}

export type QueryGetCollectionArgs = {
  collection?: InputMaybe<Scalars['String']>
}

export type QueryNodeArgs = {
  id?: InputMaybe<Scalars['String']>
}

export type QueryGetDocumentArgs = {
  collection?: InputMaybe<Scalars['String']>
  relativePath?: InputMaybe<Scalars['String']>
}

export type QueryGetDocumentListArgs = {
  before?: InputMaybe<Scalars['String']>
  after?: InputMaybe<Scalars['String']>
  first?: InputMaybe<Scalars['Float']>
  last?: InputMaybe<Scalars['Float']>
}

export type QueryGetPostsDocumentArgs = {
  relativePath?: InputMaybe<Scalars['String']>
}

export type QueryGetPostsListArgs = {
  before?: InputMaybe<Scalars['String']>
  after?: InputMaybe<Scalars['String']>
  first?: InputMaybe<Scalars['Float']>
  last?: InputMaybe<Scalars['Float']>
}

export type DocumentConnectionEdges = {
  __typename?: 'DocumentConnectionEdges'
  cursor?: Maybe<Scalars['String']>
  node?: Maybe<DocumentNode>
}

export type DocumentConnection = Connection & {
  __typename?: 'DocumentConnection'
  pageInfo?: Maybe<PageInfo>
  totalCount: Scalars['Float']
  edges?: Maybe<Array<Maybe<DocumentConnectionEdges>>>
}

export type Collection = {
  __typename?: 'Collection'
  name: Scalars['String']
  slug: Scalars['String']
  label?: Maybe<Scalars['String']>
  path: Scalars['String']
  format?: Maybe<Scalars['String']>
  matches?: Maybe<Scalars['String']>
  templates?: Maybe<Array<Maybe<Scalars['JSON']>>>
  fields?: Maybe<Array<Maybe<Scalars['JSON']>>>
  documents: DocumentConnection
}

export type CollectionDocumentsArgs = {
  before?: InputMaybe<Scalars['String']>
  after?: InputMaybe<Scalars['String']>
  first?: InputMaybe<Scalars['Float']>
  last?: InputMaybe<Scalars['Float']>
}

export type DocumentNode = PostsDocument

export type PostsAuthor = {
  __typename?: 'PostsAuthor'
  name?: Maybe<Scalars['String']>
  picture?: Maybe<Scalars['String']>
}

export type PostsOgImage = {
  __typename?: 'PostsOgImage'
  url?: Maybe<Scalars['String']>
}

export type Posts = {
  __typename?: 'Posts'
  title?: Maybe<Scalars['String']>
  excerpt?: Maybe<Scalars['String']>
  coverImage?: Maybe<Scalars['String']>
  date?: Maybe<Scalars['String']>
  author?: Maybe<PostsAuthor>
  ogImage?: Maybe<PostsOgImage>
  body?: Maybe<Scalars['String']>
}

export type PostsDocument = Node &
  Document & {
    __typename?: 'PostsDocument'
    id: Scalars['ID']
    sys: SystemInfo
    data: Posts
    form: Scalars['JSON']
    values: Scalars['JSON']
    dataJSON: Scalars['JSON']
  }

export type PostsConnectionEdges = {
  __typename?: 'PostsConnectionEdges'
  cursor?: Maybe<Scalars['String']>
  node?: Maybe<PostsDocument>
}

export type PostsConnection = Connection & {
  __typename?: 'PostsConnection'
  pageInfo?: Maybe<PageInfo>
  totalCount: Scalars['Float']
  edges?: Maybe<Array<Maybe<PostsConnectionEdges>>>
}

export type Mutation = {
  __typename?: 'Mutation'
  addPendingDocument: DocumentNode
  updateDocument: DocumentNode
  createDocument: DocumentNode
  updatePostsDocument: PostsDocument
  createPostsDocument: PostsDocument
}

export type MutationAddPendingDocumentArgs = {
  collection: Scalars['String']
  relativePath: Scalars['String']
  template?: InputMaybe<Scalars['String']>
}

export type MutationUpdateDocumentArgs = {
  collection?: InputMaybe<Scalars['String']>
  relativePath: Scalars['String']
  params: DocumentMutation
}

export type MutationCreateDocumentArgs = {
  collection?: InputMaybe<Scalars['String']>
  relativePath: Scalars['String']
  params: DocumentMutation
}

export type MutationUpdatePostsDocumentArgs = {
  relativePath: Scalars['String']
  params: PostsMutation
}

export type MutationCreatePostsDocumentArgs = {
  relativePath: Scalars['String']
  params: PostsMutation
}

export type DocumentMutation = {
  posts?: InputMaybe<PostsMutation>
}

export type PostsAuthorMutation = {
  name?: InputMaybe<Scalars['String']>
  picture?: InputMaybe<Scalars['String']>
}

export type PostsOgImageMutation = {
  url?: InputMaybe<Scalars['String']>
}

export type PostsMutation = {
  title?: InputMaybe<Scalars['String']>
  excerpt?: InputMaybe<Scalars['String']>
  coverImage?: InputMaybe<Scalars['String']>
  date?: InputMaybe<Scalars['String']>
  author?: InputMaybe<PostsAuthorMutation>
  ogImage?: InputMaybe<PostsOgImageMutation>
  body?: InputMaybe<Scalars['String']>
}

export type PostsPartsFragment = {
  __typename?: 'Posts'
  title?: string | null
  excerpt?: string | null
  coverImage?: string | null
  date?: string | null
  body?: string | null
  author?: {
    __typename: 'PostsAuthor'
    name?: string | null
    picture?: string | null
  } | null
  ogImage?: { __typename: 'PostsOgImage'; url?: string | null } | null
}

export type GetPostsDocumentQueryVariables = Exact<{
  relativePath: Scalars['String']
}>

export type GetPostsDocumentQuery = {
  __typename?: 'Query'
  getPostsDocument: {
    __typename?: 'PostsDocument'
    id: string
    sys: {
      __typename?: 'SystemInfo'
      filename: string
      basename: string
      breadcrumbs: Array<string>
      path: string
      relativePath: string
      extension: string
    }
    data: {
      __typename?: 'Posts'
      title?: string | null
      excerpt?: string | null
      coverImage?: string | null
      date?: string | null
      body?: string | null
      author?: {
        __typename: 'PostsAuthor'
        name?: string | null
        picture?: string | null
      } | null
      ogImage?: { __typename: 'PostsOgImage'; url?: string | null } | null
    }
  }
}

export type GetPostsListQueryVariables = Exact<{ [key: string]: never }>

export type GetPostsListQuery = {
  __typename?: 'Query'
  getPostsList: {
    __typename?: 'PostsConnection'
    totalCount: number
    edges?: Array<{
      __typename?: 'PostsConnectionEdges'
      node?: {
        __typename?: 'PostsDocument'
        id: string
        sys: {
          __typename?: 'SystemInfo'
          filename: string
          basename: string
          breadcrumbs: Array<string>
          path: string
          relativePath: string
          extension: string
        }
        data: {
          __typename?: 'Posts'
          title?: string | null
          excerpt?: string | null
          coverImage?: string | null
          date?: string | null
          body?: string | null
          author?: {
            __typename: 'PostsAuthor'
            name?: string | null
            picture?: string | null
          } | null
          ogImage?: { __typename: 'PostsOgImage'; url?: string | null } | null
        }
      } | null
    } | null> | null
  }
}

export const PostsPartsFragmentDoc = gql`
  fragment PostsParts on Posts {
    title
    excerpt
    coverImage
    date
    author {
      __typename
      name
      picture
    }
    ogImage {
      __typename
      url
    }
    body
  }
`
export const GetPostsDocumentDocument = gql`
  query getPostsDocument($relativePath: String!) {
    getPostsDocument(relativePath: $relativePath) {
      sys {
        filename
        basename
        breadcrumbs
        path
        relativePath
        extension
      }
      id
      data {
        ...PostsParts
      }
    }
  }
  ${PostsPartsFragmentDoc}
`
export const GetPostsListDocument = gql`
  query getPostsList {
    getPostsList {
      totalCount
      edges {
        node {
          id
          sys {
            filename
            basename
            breadcrumbs
            path
            relativePath
            extension
          }
          data {
            ...PostsParts
          }
        }
      }
    }
  }
  ${PostsPartsFragmentDoc}
`
export type Requester<C = {}> = <R, V>(
  doc: DocumentNode,
  vars?: V,
  options?: C
) => Promise<R>
export function getSdk<C>(requester: Requester<C>) {
  return {
    getPostsDocument(
      variables: GetPostsDocumentQueryVariables,
      options?: C
    ): Promise<{
      data: GetPostsDocumentQuery
      variables: GetPostsDocumentQueryVariables
      query: string
    }> {
      return requester<
        {
          data: GetPostsDocumentQuery
          variables: GetPostsDocumentQueryVariables
          query: string
        },
        GetPostsDocumentQueryVariables
      >(GetPostsDocumentDocument, variables, options)
    },
    getPostsList(
      variables?: GetPostsListQueryVariables,
      options?: C
    ): Promise<{
      data: GetPostsListQuery
      variables: GetPostsListQueryVariables
      query: string
    }> {
      return requester<
        {
          data: GetPostsListQuery
          variables: GetPostsListQueryVariables
          query: string
        },
        GetPostsListQueryVariables
      >(GetPostsListDocument, variables, options)
    },
  }
}
export type Sdk = ReturnType<typeof getSdk>

// TinaSDK generated code
import { staticRequest } from 'tinacms'
const requester: (doc: any, vars?: any, options?: any) => Promise<any> = async (
  doc,
  vars,
  _options
) => {
  let data = {}
  try {
    data = await staticRequest({
      query: doc,
      variables: vars,
    })
  } catch (e) {
    // swallow errors related to document creation
    console.warn('Warning: There was an error when fetching data')
    console.warn(e)
  }

  return { data, query: doc, variables: vars || {} }
}

/**
 * @experimental this class can be used but may change in the future
 **/
export const ExperimentalGetTinaClient = () => getSdk(requester)
