# Invalid relative `href` and external `as` values

#### Why This Error Occurred

Somewhere you are utilizing the `next/link` component, `Router#push`, or `Router#replace` with a relative route in your `href` that has an external `as` value. The `as` value must be relative also or only `href` should be used with an external URL.

Note: this error will only show when the `next/link` component is clicked not when only rendered.

**Incompatible `href` and `as`**

```jsx
import Link from 'next/link'

export default function Page(props) {
  return (
    <>
      <Link href="/invalid" as="mailto:john@example.com">
        <a>Invalid link</a>
      </Link>
    </>
  )
}
```

**Compatible `href` and `as`**

```jsx
import Link from 'next/link'

export default function Page(props) {
  return (
    <>
      <Link href="mailto:john@example.com">
        <a>Invalid link</a>
      </Link>
    </>
  )
}
```

#### Possible Ways to Fix It

Look for any usage of the `next/link` component, `Router#push`, or `Router#replace` and make sure that the provided `href` and `as` values are compatible

### Useful Links

- [Routing section in Documentation](https://nextjs.org/docs/routing/introduction)
