/*
 * Decompiled with CFR 0.152.
 */
package com.github.promeg.tinypinyin.lexicons.java.cncity;

import com.github.promeg.pinyinhelper.PinyinMapDict;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public final class CnCityDict
extends PinyinMapDict {
    static volatile CnCityDict singleton = null;
    final Map<String, String[]> mDict = new HashMap<String, String[]>();

    private CnCityDict() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CnCityDict getInstance() {
        if (singleton != null) return singleton;
        Class<CnCityDict> clazz = CnCityDict.class;
        synchronized (CnCityDict.class) {
            if (singleton != null) return singleton;
            singleton = new CnCityDict();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    public Map<String, String[]> mapping() {
        return this.mDict;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        BufferedReader reader = null;
        try {
            String line;
            ClassLoader classloader = Thread.currentThread().getContextClassLoader();
            InputStream is = classloader.getResourceAsStream("tinypinyin/cncity.txt");
            reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                String[] keyAndValue = line.split("\\s+");
                if (keyAndValue == null || keyAndValue.length != 2) continue;
                String[] pinyinStrs = keyAndValue[0].split("'");
                this.mDict.put(keyAndValue[1], pinyinStrs);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

