/*
 * Symphony - A modern community (forum/SNS/blog) platform written in Java.
 * Copyright (C) 2012-2017,  b3log.org & hacpai.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.b3log.symphony.model;

/**
 * This class defines all common model relevant keys.
 *
 * @author <a href="http://88250.b3log.org">Liang Ding</a>
 * @version 1.63.0.0, Dec 5, 2017
 * @since 0.2.0
 */
public final class Common {

    /**
     * Key of command.
     */
    public static final String CMD = "cmd";

    /**
     * Key of User-Agent.
     */
    public static final String USER_AGENT = "User-Agent";

    /**
     * Key of add article domains.
     */
    public static final String ADD_ARTICLE_DOMAINS = "addArticleDomains";

    /**
     * Key of data.
     */
    public static final String DATA = "data";

    /**
     * Key of ISBN.
     */
    public static final String ISBN = "ISBN";

    /**
     * Key of mans.
     */
    public static final String MANS = "mans";

    /**
     * Key of man HTML.
     */
    public static final String MAN_HTML = "manHTML";

    /**
     * Key of man command.
     */
    public static final String MAN_CMD = "manCmd";

    /**
     * Key of requisite.
     */
    public static final String REQUISITE = "requisite";

    /**
     * Key of requisite message.
     */
    public static final String REQUISITE_MSG = "requisiteMsg";

    /**
     * Key of following user articles.
     */
    public static final String FOLLOWING_USER_ARTICLES = "followingUserArticles";

    /**
     * Key of following tag articles.
     */
    public static final String FOLLOWING_TAG_ARTICLES = "followingTagArticles";

    /**
     * Key of command.
     */
    public static final String COMMAND = "command";

    /**
     * Key of need captcha.
     */
    public static final String NEED_CAPTCHA = "needCaptcha";

    /**
     * Key of wrong count.
     */
    public static final String WRON_COUNT = "wrongCount";

    /**
     * Key of remember login.
     */
    public static final String REMEMBER_LOGIN = "rememberLogin";

    /**
     * Key of stick articles.
     */
    public static final String STICK_ARTICLES = "stickArticles";

    /**
     * Key of id.
     */
    public static final String ID = "id";

    /**
     * Key of name.
     */
    public static final String NAME = "name";

    /**
     * Key of language.
     */
    public static final String LANGUAGE = "language";

    /**
     * Key of languages.
     */
    public static final String LANGUAGES = "languages";

    /**
     * Key of timezone.
     */
    public static final String TIMEZONE = "timezone";

    /**
     * Key of timezones.
     */
    public static final String TIMEZONES = "timezones";

    /**
     * Key of forge.
     */
    public static final String FORGE = "forge";

    /**
     * Key of selected.
     */
    public static final String SELECTED = "selected";

    /**
     * Key of last modified.
     */
    public static final String LAST_MOD = "lastModified";

    /**
     * Key of invited user count.
     */
    public static final String INVITED_USER_COUNT = "invitedUserCnt";

    /**
     * Key of 'sys announce' notifications.
     */
    public static final String SYS_ANNOUNCE_NOTIFICATIONS = "sysAnnounceNotifications";

    /**
     * Key of unread 'sys announce' notifications count.
     */
    public static final String UNREAD_SYS_ANNOUNCE_NOTIFICATION_CNT = "unreadSysAnnounceNotificationCnt";

    /**
     * Key of unread 'new follower' notifications count.
     */
    public static final String UNREAD_NEW_FOLLOWER_NOTIFICATION_CNT = "unreadNewFollowerNotificationCnt";

    /**
     * Key of mouse effects.
     */
    public static final String MOUSE_EFFECTS = "mouseEffects";

    /**
     * Key of is mobile device.
     */
    public static final String IS_MOBILE = "isMobile";

    /**
     * Key of messages.
     */
    public static final String MESSAGES = "messages";

    /**
     * Max length of UA.
     */
    public static final int MAX_LENGTH_UA = 255;

    /**
     * Key of words.
     */
    public static final String WORDS = "words";

    /**
     * Key of word.
     */
    public static final String WORD = "word";

    /**
     * Key of key.
     */
    public static final String KEY = "key";

    /**
     * Key of money.
     */
    public static final String MONEY = "money";

    /**
     * Key of title.
     */
    public static final String TITLE = "title";

    /**
     * Key of WebSocket scheme.
     */
    public static final String WEBSOCKET_SCHEME = "wsScheme";

    /**
     * Key of broadcast point.
     */
    public static final String BROADCAST_POINT = "broadcastPoint";

    /**
     * Key of at.
     */
    public static final String AT = "at";

    /**
     * Key of time ago.
     */
    public static final String TIME_AGO = "timeAgo";

    /**
     * Key of comment time ago.
     */
    public static final String CMT_TIME_AGO = "cmtTimeAgo";

    /**
     * Key of time.
     */
    public static final String TIME = "time";

    /**
     * Key of rewarded count.
     */
    public static final String REWARED_COUNT = "rewardedCnt";

    /**
     * Key of thanked count.
     */
    public static final String THANKED_COUNT = "thankedCnt";

    /**
     * Key of CSRF token.
     */
    public static final String CSRF_TOKEN = "csrfToken";

    /**
     * Key of city.
     */
    public static final String CITY = "city";

    /**
     * Key of city found.
     */
    public static final String CITY_FOUND = "cityFound";

    /**
     * Key of country.
     */
    public static final String COUNTRY = "country";

    /**
     * Key of province.
     */
    public static final String PROVINCE = "province";

    /**
     * Key of new user.
     */
    public static final String NEW_USER = "newUser";

    /**
     * Key of is reserved.
     */
    public static final String IS_RESERVED = "isReserved";

    /**
     * Key of data id.
     */
    public static final String DATA_ID = "dataId";

    /**
     * Key of data title.
     */
    public static final String DATA_TITLE = "dataTitle";

    /**
     * Key of data link.
     */
    public static final String DATA_LINK = "dataLink";

    /**
     * Key of memo.
     */
    public static final String MEMO = "memo";

    /**
     * Key of point.
     */
    public static final String POINT = "point";

    /**
     * Key of elapsed.
     */
    public static final String ELAPSED = "elapsed";

    /**
     * Key of closed 1A0001.
     */
    public static final String CLOSED_1A0001 = "closed1A0001";

    /**
     * Key of closed.
     */
    public static final String CLOSED = "closed";

    /**
     * Key of end.
     */
    public static final String END = "end";

    /**
     * Key of hour.
     */
    public static final String HOUR = "hour";

    /**
     * Key of collected.
     */
    public static final String COLLECTED = "collected";

    /**
     * Key of participated.
     */
    public static final String PARTICIPATED = "participated";

    /**
     * Key of to user.
     */
    public static final String TO_USER = "toUser";

    /**
     * Key of amount.
     */
    public static final String AMOUNT = "amount";

    /**
     * Key of small or large.
     */
    public static final String SMALL_OR_LARGE = "smallOrLarge";

    /**
     * Key of is daily checkin.
     */
    public static final String IS_DAILY_CHECKIN = "isDailyCheckin";

    /**
     * Key of use captcha checkin.
     */
    public static final String USE_CAPTCHA_CHECKIN = "useCaptchaCheckin";

    /**
     * Key of mini postfix.
     */
    public static final String MINI_POSTFIX = "miniPostfix";

    /**
     * Value of mini postfix.
     */
    public static final String MINI_POSTFIX_VALUE = ".min";

    /**
     * Static resource version.
     */
    public static final String STATIC_RESOURCE_VERSION = "staticResourceVersion";

    /**
     * Key of go to.
     */
    public static final String GOTO = "goto";

    /**
     * Key of current user.
     */
    public static final String CURRENT_USER = "currentUser";

    /**
     * Key of current.
     */
    public static final String CURRENT = "current";

    /**
     * Key of is logged in.
     */
    public static final String IS_LOGGED_IN = "isLoggedIn";

    /**
     * Key of is admin.
     */
    public static final String IS_ADMIN_LOGGED_IN = "isAdminLoggedIn";

    /**
     * Key of is following.
     */
    public static final String IS_FOLLOWING = "isFollowing";

    /**
     * Key of is watching.
     */
    public static final String IS_WATCHING = "isWatching";

    /**
     * Key of is my article.
     */
    public static final String IS_MY_ARTICLE = "isMyArticle";

    /**
     * Key of logout URL.
     */
    public static final String LOGOUT_URL = "logoutURL";

    /**
     * Key of type.
     */
    public static final String TYPE = "type";

    /**
     * Key of activity.
     */
    public static final String ACTIVITY = "activity";

    /**
     * Key of recent articles.
     */
    public static final String RECENT_ARTICLES = "recentArticles";

    /**
     * Key of recent.
     */
    public static final String RECENT = "recent";

    /**
     * Key of timeline.
     */
    public static final String TIMELINE = "timeline";

    /**
     * Key of timelines.
     */
    public static final String TIMELINES = "timelines";

    /**
     * Key of hot articles.
     */
    public static final String HOT_ARTICLES = "hotArticles";

    /**
     * Key of hot.
     */
    public static final String HOT = "hot";

    /**
     * Key of perfect articles.
     */
    public static final String PERFECT_ARTICLES = "perfectArticles";

    /**
     * Key of perfect.
     */
    public static final String PERFECT = "perfect";

    /**
     * Key of side tags.
     */
    public static final String SIDE_TAGS = "sideTags";

    /**
     * Key of navigation trend tags.
     */
    public static final String NAV_TREND_TAGS = "navTrendTags";

    /**
     * Key of new tags.
     */
    public static final String NEW_TAGS = "newTags";

    /**
     * Key of trend tags.
     */
    public static final String TREND_TAGS = "trendTags";

    /**
     * Key of cold tags.
     */
    public static final String COLD_TAGS = "coldTags";

    /**
     * Key of side hot articles.
     */
    public static final String SIDE_HOT_ARTICLES = "sideHotArticles";

    /**
     * Key of side random articles.
     */
    public static final String SIDE_RANDOM_ARTICLES = "sideRandomArticles";

    /**
     * Key of side relevant articles.
     */
    public static final String SIDE_RELEVANT_ARTICLES = "sideRelevantArticles";

    /**
     * Key of side latest comments.
     */
    public static final String SIDE_LATEST_CMTS = "sideLatestCmts";

    /**
     * Key of latest articles.
     */
    public static final String LATEST_ARTICLES = "latestArticles";

    /**
     * Key of index articles.
     */
    public static final String INDEX_ARTICLES = "indexArticles";

    /**
     * Key of index.
     */
    public static final String INDEX = "index";

    /**
     * Key of user id.
     */
    public static final String USER_ID = "userId";

    /**
     * Key of user home articles.
     */
    public static final String USER_HOME_ARTICLES = "userHomeArticles";

    /**
     * Key of user home comments.
     */
    public static final String USER_HOME_COMMENTS = "userHomeComments";

    /**
     * Key of user home following users.
     */
    public static final String USER_HOME_FOLLOWING_USERS = "userHomeFollowingUsers";

    /**
     * Key of user home following tags.
     */
    public static final String USER_HOME_FOLLOWING_TAGS = "userHomeFollowingTags";

    /**
     * Key of user home following articles.
     */
    public static final String USER_HOME_FOLLOWING_ARTICLES = "userHomeFollowingArticles";

    /**
     * Key of user home follower users.
     */
    public static final String USER_HOME_FOLLOWER_USERS = "userHomeFollowerUsers";

    /**
     * Key of user home points.
     */
    public static final String USER_HOME_POINTS = "userHomePoints";

    /**
     * Key of 'point' notifications.
     */
    public static final String POINT_NOTIFICATIONS = "pointNotifications";

    /**
     * Key of unread 'point' notifications count.
     */
    public static final String UNREAD_POINT_NOTIFICATION_CNT = "unreadPointNotificationCnt";

    /**
     * Key of 'commented' notifications.
     */
    public static final String COMMENTED_NOTIFICATIONS = "commentedNotifications";

    /**
     * Key of 'reply' notifications.
     */
    public static final String REPLY_NOTIFICATIONS = "replyNotifications";

    /**
     * Key of unread notifications count.
     */
    public static final String UNREAD_NOTIFICATION_CNT = "unreadNotificationCnt";

    /**
     * Key of unread 'commented' notifications count.
     */
    public static final String UNREAD_COMMENTED_NOTIFICATION_CNT = "unreadCommentedNotificationCnt";

    /**
     * Key of unread 'reply' notifications count.
     */
    public static final String UNREAD_REPLY_NOTIFICATION_CNT = "unreadReplyNotificationCnt";

    /**
     * Key of 'at' notifications.
     */
    public static final String AT_NOTIFICATIONS = "atNotifications";

    /**
     * Key of unread 'at' notifications count.
     */
    public static final String UNREAD_AT_NOTIFICATION_CNT = "unreadAtNotificationCnt";

    /**
     * Key of 'following' notifications.
     */
    public static final String FOLLOWING_NOTIFICATIONS = "followingNotifications";

    /**
     * Key of unread 'broadcast' notifications count.
     */
    public static final String UNREAD_BROADCAST_NOTIFICATION_CNT = "unreadBroadcastNotificationCnt";

    /**
     * Key of 'broadcast' notifications.
     */
    public static final String BROADCAST_NOTIFICATIONS = "broadcastNotifications";

    /**
     * Key of unread 'following' notifications count.
     */
    public static final String UNREAD_FOLLOWING_NOTIFICATION_CNT = "unreadFollowingNotificationCnt";

    /**
     * Key of follower user count.
     */
    public static final String FOLLOWER_USER_CNT = "followerUserCnt";

    /**
     * Key of following user count.
     */
    public static final String FOLLOWING_USER_CNT = "followingUserCnt";

    /**
     * Key of following article count.
     */
    public static final String FOLLOWING_ARTICLE_CNT = "followingArticleCnt";

    /**
     * Key of following tag count.
     */
    public static final String FOLLOWING_TAG_CNT = "followingTagCnt";

    /**
     * Key of author name.
     */
    public static final String AUTHOR_NAME = "authorName";

    /**
     * Key of author email.
     */
    public static final String AUTHOR_EMAIL = "authorEmail";

    /**
     * Key of author URL.
     */
    public static final String AUTHOR_URL = "authorURL";

    /**
     * Key of author avatar URL.
     */
    public static final String AUTHOR_AVATAR_URL = "authorAvatarURL";

    /**
     * Key of UA.
     */
    public static final String UA = "ua";

    /**
     * Key of IP.
     */
    public static final String IP = "ip";

    /**
     * Key of content HTML.
     */
    public static final String CONTENT_HTML = "contentHTML";

    /**
     * Key of is article author.
     */
    public static final String IS_ARTICLE_AUTHOR = "isArticleAuthor";

    /**
     * Key of content.
     */
    public static final String CONTENT = "content";

    /**
     * Key of thumbnail URL.
     */
    public static final String THUMBNAIL_URL = "thumbnailURL";

    /**
     * Key of thumbnail update time.
     */
    public static final String THUMBNAIL_UPDATE_TIME = "thumbnailUpdateTime";

    /**
     * Key of URL.
     */
    public static final String URL = "url";

    /**
     * Key of update time.
     */
    public static final String UPDATE_TIME = "updateTime";

    /**
     * Key of Create time.
     */
    public static final String CREATE_TIME = "createTime";

    /**
     * Key of version.
     */
    public static final String VERSION = "version";

    /**
     * Key of year.
     */
    public static final String YEAR = "year";

    /**
     * Key of site visit statistic code.
     */
    public static final String SITE_VISIT_STAT_CODE = "siteVisitStatCode";

    /**
     * Key of macro head PC.
     */
    public static final String MACRO_HEAD_PC_CODE = "macroHeadPCCode";

    /**
     * Key of macro head mobile code.
     */
    public static final String MACRO_HEAD_MOBILE_CODE = "macroHeadMobileCode";

    /**
     * Key of footer PC code.
     */
    public static final String FOOTER_PC_CODE = "footerPCCode";

    /**
     * Key of footer mobile code.
     */
    public static final String FOOTER_MOBILE_CODE = "footerMobileCode";

    /**
     * Key of online visitor count.
     */
    public static final String ONLINE_VISITOR_CNT = "onlineVisitorCnt";

    /**
     * Key of online member count.
     */
    public static final String ONLINE_MEMBER_CNT = "onlineMemberCnt";

    /**
     * Key of online chat count.
     */
    public static final String ONLINE_CHAT_CNT = "onlineChatCnt";

    /**
     * Key of article channel count.
     */
    public static final String ARTICLE_CHANNEL_CNT = "articleChannelCnt";

    /**
     * Key of article list channel count.
     */
    public static final String ARTICLE_LIST_CHANNEL_CNT = "articleListChannelCnt";

    /**
     * Key of symphony key.
     */
    public static final String SYMPHONY_KEY = "symphonyKey";

    /**
     * Key of from client.
     */
    public static final String FROM_CLIENT = "fromClient";

    /**
     * Key of article comments page size.
     */
    public static final String ARTICLE_COMMENTS_PAGE_SIZE = "articleCommentsPageSize";

    /**
     * Key of weight.
     */
    public static final String WEIGHT = "weight";

    /**
     * Key of viewable.
     */
    public static final String DISCUSSION_VIEWABLE = "discussionViewable";

    /**
     * Key of usernames.
     */
    public static final String USER_NAMES = "userNames";

    /**
     * Key of username or email.
     */
    public static final String USER_NAME_OR_EMAIL = "userNameOrEmail";

    /**
     * Key of operation.
     */
    public static final String OPERATION = "operation";

    /**
     * Key of rewarded.
     */
    public static final String REWARDED = "rewarded";

    /**
     * Key of thanked.
     */
    public static final String THANKED = "thanked";

    /**
     * Key of display type.
     */
    public static final String DISPLAY_TYPE = "displayType";

    /**
     * Key of description.
     */
    public static final String DESCRIPTION = "description";

    /**
     * Key of balance.
     */
    public static final String BALANCE = "balance";

    /**
     * Key of plus.
     */
    public static final String PLAUS = "plus";

    /**
     * Key of referral.
     */
    public static final String REFERRAL = "referral";

    /**
     * Key of top balance users.
     */
    public static final String TOP_BALANCE_USERS = "topBalanceUsers";

    /**
     * Key of top consumption users.
     */
    public static final String TOP_CONSUMPTION_USERS = "topConsumptionUsers";

    /**
     * Key of top checkin users.
     */
    public static final String TOP_CHECKIN_USERS = "topCheckinUsers";

    /**
     * Private constructor.
     */
    private Common() {
    }
}
