/*
 * Symphony - A modern community (forum/SNS/blog) platform written in Java.
 * Copyright (C) 2012-2017,  b3log.org & hacpai.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.b3log.symphony.model;

/**
 * This class defines all book model relevant keys.
 *
 * @author <a href="http://88250.b3log.org">Liang Ding</a>
 * @version 1.1.0.1, Jan 5, 2017
 */
public final class Book {

    /**
     * Book.
     */
    public static final String BOOK = "book";

    /**
     * Books.
     */
    public static final String BOOKS = "books";

    /**
     * Key of book title.
     */
    public static final String BOOK_TITLE = "bookTitle";

    /**
     * Key of book sub title.
     */
    public static final String BOOK_SUB_TITLE = "bookSubTitle";

    /**
     * Key of book original title.
     */
    public static final String BOOK_ORIGINAL_TITLE = "bookOriginalTitle";

    /**
     * Key of book alt title.
     */
    public static final String BOOK_ALT_TITLE = "bookAltTitle";

    /**
     * Key of book douban URL.
     */
    public static final String BOOK_DOUBAN_URL = "bookDoubanURL";

    /**
     * Key of book author.
     */
    public static final String BOOK_AUTHOR = "bookAuthor";

    /**
     * Key of book author intro.
     */
    public static final String BOOK_AUTHOR_INTRO = "bookAuthorIntro";

    /**
     * Key of book binding.
     */
    public static final String BOOK_BINDING = "bookBinding";

    /**
     * Key of book catalog.
     */
    public static final String BOOK_CATALOG = "bookCatalog";

    /**
     * Key of book image URL.
     */
    public static final String BOOK_IMG_URL = "bookImgURL";

    /**
     * Key of book ISBN 10.
     */
    public static final String BOOK_ISBN10 = "bookISBN10";

    /**
     * Key of book ISBN 13.
     */
    public static final String BOOK_ISBN13 = "bookISBN13";

    /**
     * Key of book pages.
     */
    public static final String BOOK_PAGES = "bookPages";

    /**
     * Key of book price.
     */
    public static final String BOOK_PRICE = "bookPrice";

    /**
     * Key of book publish date.
     */
    public static final String BOOK_PUBLISH_DATE = "bookPublishDate";

    /**
     * Key of book publisher.
     */
    public static final String BOOK_PUBLISHER = "bookPublisher";

    /**
     * Key of book series.
     */
    public static final String BOOK_SERIES = "bookSeries";

    /**
     * Key of book summary.
     */
    public static final String BOOK_SUMMARY = "bookSummary";

    /**
     * Key of book tags.
     */
    public static final String BOOK_TAGS = "bookTags";

    /**
     * Key of book translator.
     */
    public static final String BOOK_TRANSLATOR = "bookTranslator";

    //// Transient ////

    /**
     * Key of book id.
     */
    public static final String BOOK_T_ID = "bookId";
}
