---
id: getting_started
title: Getting Started
---

This section shows you how to get up and running with Captum.


## Installing Captum

#### Installation Requirements:

- Python >= 3.6
- PyTorch >= 1.2
- numpy

Captum is easily installed via
[Anaconda](https://www.anaconda.com/distribution/#download-section) (recommended)
or `pip`:

<!--DOCUSAURUS_CODE_TABS-->
<!--conda-->
```bash
conda install captum -c pytorch
```
<!--pip-->
```bash
pip install captum
```
<!--END_DOCUSAURUS_CODE_TABS-->

For more detailed installation instructions, please see the
[Project Readme](https://github.com/pytorch/captum/blob/master/README.md)
on GitHub.


## Tutorials

We have several tutorials to help get you off the ground with Captum.  The tutorials are Jupyter notebooks and cover the basics along with demonstrating usage of Captum with models of different modalities.

View the tutorials page [here](../tutorials/).


## API Reference

For an in-depth reference of the various Captum internals, see our
[API Reference](../api).


## Contributing

You'd like to contribute to Captum? Great! Please see
[here](https://github.com/pytorch/captum/blob/master/CONTRIBUTING.md)
for how to help out.
