# typed: strict
# frozen_string_literal: true

########################################################################################################################
# This file is auto-generated. If you have an issue, please create a GitHub issue.                                     #
########################################################################################################################

$VERBOSE = nil
$LOAD_PATH.unshift(File.join(File.dirname(__FILE__), "..", "lib"))

require "minitest/autorun"
require "webmock/minitest"

require "shopify_api"
require_relative "../../test_helper"

class PaymentTransaction202510Test < Test::Unit::TestCase
  def setup
    super

    test_session = ShopifyAPI::Auth::Session.new(id: "id", shop: "test-shop.myshopify.io", access_token: "this_is_a_test_token")
    ShopifyAPI::Context.activate_session(test_session)
    modify_context(api_version: "2025-10")
  end

  def teardown
    super

    ShopifyAPI::Context.deactivate_session
  end

  sig do
    void
  end
  def test_1()
    stub_request(:get, "https://test-shop.myshopify.io/admin/api/2025-10/shopify_payments/balance/transactions.json?payout_id=623721858")
      .with(
        headers: {"X-Shopify-Access-Token"=>"this_is_a_test_token", "Accept"=>"application/json"},
        body: {}
      )
      .to_return(status: 200, body: JSON.generate({"transactions" => [{"id" => 716142630, "type" => "debit", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "-0.75", "fee" => "0.00", "net" => "-0.75", "source_id" => 514396116, "source_type" => "adjustment", "source_order_id" => nil, "source_order_transaction_id" => nil, "processed_at" => "2024-10-31T20:00:00-04:00", "adjustment_order_transactions" => [], "adjustment_reason" => "tax_adjustment"}, {"id" => 476425693, "type" => "credit", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "1.50", "fee" => "0.00", "net" => "1.50", "source_id" => 206869143, "source_type" => "adjustment", "source_order_id" => nil, "source_order_transaction_id" => nil, "processed_at" => "2024-10-31T20:00:00-04:00", "adjustment_order_transactions" => [], "adjustment_reason" => "tax_adjustment"}, {"id" => 396322840, "type" => "credit", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "0.25", "fee" => "0.00", "net" => "0.25", "source_id" => 105592054, "source_type" => "adjustment", "source_order_id" => nil, "source_order_transaction_id" => nil, "processed_at" => "2024-10-31T20:00:00-04:00", "adjustment_order_transactions" => [], "adjustment_reason" => "tax_adjustment"}, {"id" => 348058882, "type" => "debit", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "-0.75", "fee" => "0.00", "net" => "-0.75", "source_id" => 616988872, "source_type" => "adjustment", "source_order_id" => nil, "source_order_transaction_id" => nil, "processed_at" => "2024-10-31T20:00:00-04:00", "adjustment_order_transactions" => [], "adjustment_reason" => "tax_adjustment"}, {"id" => 699519475, "type" => "debit", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "-50.00", "fee" => "0.00", "net" => "-50.00", "source_id" => 460709370, "source_type" => "adjustment", "source_order_id" => nil, "source_order_transaction_id" => nil, "processed_at" => "2024-01-11T07:34:56-05:00", "adjustment_order_transactions" => [], "adjustment_reason" => "billing"}, {"id" => 77412310, "type" => "credit", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "50.00", "fee" => "0.00", "net" => "50.00", "source_id" => 374511569, "source_type" => "Payments::Balance::AdjustmentReversal", "source_order_id" => nil, "source_order_transaction_id" => nil, "processed_at" => "2024-01-11T07:34:56-05:00", "adjustment_order_transactions" => nil, "adjustment_reason" => nil}, {"id" => 1044362223, "type" => "refund", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "-3.45", "fee" => "0.00", "net" => "-3.45", "source_id" => 1006917261, "source_type" => "Payments::Refund", "source_order_id" => 217130470, "source_order_transaction_id" => 1006917261, "processed_at" => "2024-01-10T07:34:56-05:00", "adjustment_order_transactions" => nil, "adjustment_reason" => nil}, {"id" => 1006917261, "type" => "refund", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "-3.45", "fee" => "0.00", "net" => "-3.45", "source_id" => 1006917261, "source_type" => "Payments::Refund", "source_order_id" => 217130470, "source_order_transaction_id" => 1006917261, "processed_at" => "2024-01-10T07:34:56-05:00", "adjustment_order_transactions" => nil, "adjustment_reason" => nil}, {"id" => 777128868, "type" => "refund", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "-8.05", "fee" => "0.00", "net" => "-8.05", "source_id" => 777128868, "source_type" => "Payments::Refund", "source_order_id" => nil, "source_order_transaction_id" => nil, "processed_at" => "2024-01-10T07:34:56-05:00", "adjustment_order_transactions" => nil, "adjustment_reason" => nil}, {"id" => 758509248, "type" => "adjustment", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "-1.50", "fee" => "-0.25", "net" => "-1.75", "source_id" => 764194150, "source_type" => "charge", "source_order_id" => nil, "source_order_transaction_id" => nil, "processed_at" => "2024-01-10T07:34:56-05:00", "adjustment_order_transactions" => nil, "adjustment_reason" => nil}, {"id" => 746296004, "type" => "charge", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "10.00", "fee" => "2.00", "net" => "8.00", "source_id" => 746296004, "source_type" => "charge", "source_order_id" => 625362839, "source_order_transaction_id" => 890672011, "processed_at" => "2024-01-10T07:34:56-05:00", "adjustment_order_transactions" => nil, "adjustment_reason" => nil}, {"id" => 515523000, "type" => "charge", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "11.50", "fee" => "0.65", "net" => "10.85", "source_id" => 1006917261, "source_type" => "Payments::Refund", "source_order_id" => 217130470, "source_order_transaction_id" => 1006917261, "processed_at" => "2024-01-10T07:34:56-05:00", "adjustment_order_transactions" => nil, "adjustment_reason" => nil}, {"id" => 482793472, "type" => "adjustment", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "0.45", "fee" => "0.00", "net" => "0.45", "source_id" => 204289877, "source_type" => "charge", "source_order_id" => 217130470, "source_order_transaction_id" => 567994517, "processed_at" => "2024-01-10T07:34:56-05:00", "adjustment_order_transactions" => nil, "adjustment_reason" => nil}, {"id" => 382557793, "type" => "adjustment", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "0.20", "fee" => "0.00", "net" => "0.20", "source_id" => 204289877, "source_type" => "charge", "source_order_id" => 217130470, "source_order_transaction_id" => 567994517, "processed_at" => "2024-01-10T07:34:56-05:00", "adjustment_order_transactions" => nil, "adjustment_reason" => nil}, {"id" => 365577382, "type" => "adjustment", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "-3.45", "fee" => "0.00", "net" => "-3.45", "source_id" => 1006917261, "source_type" => "Payments::Refund", "source_order_id" => 217130470, "source_order_transaction_id" => 1006917261, "processed_at" => "2024-01-10T07:34:56-05:00", "adjustment_order_transactions" => nil, "adjustment_reason" => nil}, {"id" => 201521674, "type" => "refund", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "-2.00", "fee" => "0.00", "net" => "-2.00", "source_id" => 971443537, "source_type" => "charge", "source_order_id" => 625362839, "source_order_transaction_id" => 461790020, "processed_at" => "2024-01-10T07:34:56-05:00", "adjustment_order_transactions" => nil, "adjustment_reason" => nil}, {"id" => 188711209, "type" => "capture", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "-11.37", "fee" => "0.00", "net" => "-11.37", "source_id" => 188711209, "source_type" => "charge", "source_order_id" => 923751907, "source_order_transaction_id" => 972637531, "processed_at" => "2024-01-10T07:34:56-05:00", "adjustment_order_transactions" => nil, "adjustment_reason" => nil}, {"id" => 977134221, "type" => "dispute", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "-100.00", "fee" => "15.00", "net" => "-115.00", "source_id" => 297752803, "source_type" => "Payments::Dispute", "source_order_id" => 625362839, "source_order_transaction_id" => 897736458, "processed_at" => "2023-12-31T07:34:56-05:00", "adjustment_order_transactions" => nil, "adjustment_reason" => nil}, {"id" => 774282320, "type" => "dispute", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "-100.00", "fee" => "15.00", "net" => "-115.00", "source_id" => 46484353, "source_type" => "Payments::Dispute", "source_order_id" => 625362839, "source_order_transaction_id" => 897736458, "processed_at" => "2023-12-31T07:34:56-05:00", "adjustment_order_transactions" => nil, "adjustment_reason" => nil}, {"id" => 726130462, "type" => "dispute", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "-11.50", "fee" => "15.00", "net" => "-26.50", "source_id" => 598735659, "source_type" => "Payments::Dispute", "source_order_id" => 625362839, "source_order_transaction_id" => 897736458, "processed_at" => "2023-12-31T07:34:56-05:00", "adjustment_order_transactions" => nil, "adjustment_reason" => nil}, {"id" => 590656313, "type" => "dispute", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "-100.00", "fee" => "15.00", "net" => "-115.00", "source_id" => 297752803, "source_type" => "Payments::Dispute", "source_order_id" => 625362839, "source_order_transaction_id" => 897736458, "processed_at" => "2023-12-31T07:34:56-05:00", "adjustment_order_transactions" => nil, "adjustment_reason" => nil}, {"id" => 585267611, "type" => "dispute", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "-50.00", "fee" => "0.00", "net" => "-50.00", "source_id" => 46484353, "source_type" => "Payments::Dispute", "source_order_id" => 625362839, "source_order_transaction_id" => 897736458, "processed_at" => "2023-12-31T07:34:56-05:00", "adjustment_order_transactions" => nil, "adjustment_reason" => nil}, {"id" => 295058327, "type" => "dispute", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "100.00", "fee" => "-15.00", "net" => "115.00", "source_id" => 297752803, "source_type" => "Payments::Dispute", "source_order_id" => 625362839, "source_order_transaction_id" => 897736458, "processed_at" => "2023-12-31T07:34:56-05:00", "adjustment_order_transactions" => nil, "adjustment_reason" => nil}, {"id" => 144665135, "type" => "dispute", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "2.83", "fee" => "-15.00", "net" => "17.83", "source_id" => 297752803, "source_type" => "Payments::Dispute", "source_order_id" => 625362839, "source_order_transaction_id" => 897736458, "processed_at" => "2023-12-31T07:34:56-05:00", "adjustment_order_transactions" => nil, "adjustment_reason" => nil}, {"id" => 1039379438, "type" => "debit", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "-10.00", "fee" => "0.00", "net" => "-10.00", "source_id" => 98265485, "source_type" => "adjustment", "source_order_id" => nil, "source_order_transaction_id" => nil, "processed_at" => "2016-08-04T18:07:57-04:00", "adjustment_order_transactions" => [], "adjustment_reason" => "channel_transfer"}, {"id" => 996672915, "type" => "debit", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "-100.00", "fee" => "0.00", "net" => "-100.00", "source_id" => 996672915, "source_type" => "Payments::Balance::AdjustmentReversal", "source_order_id" => nil, "source_order_transaction_id" => nil, "processed_at" => "2016-08-04T18:07:57-04:00", "adjustment_order_transactions" => nil, "adjustment_reason" => nil}, {"id" => 972818242, "type" => "reserve", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "-42.00", "fee" => "0.00", "net" => "-42.00", "source_id" => nil, "source_type" => nil, "source_order_id" => nil, "source_order_transaction_id" => nil, "processed_at" => "2016-08-04T18:07:57-04:00", "adjustment_order_transactions" => nil, "adjustment_reason" => nil}, {"id" => 951890146, "type" => "advance", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "100.00", "fee" => "0.00", "net" => "100.00", "source_id" => nil, "source_type" => nil, "source_order_id" => nil, "source_order_transaction_id" => nil, "processed_at" => "2016-08-04T18:07:57-04:00", "adjustment_order_transactions" => nil, "adjustment_reason" => nil}, {"id" => 911614749, "type" => "debit", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "100.00", "fee" => "0.00", "net" => "100.00", "source_id" => 31693764, "source_type" => "adjustment", "source_order_id" => nil, "source_order_transaction_id" => nil, "processed_at" => "2016-08-04T18:07:57-04:00", "adjustment_order_transactions" => [], "adjustment_reason" => "shop_cash_refund"}, {"id" => 843310825, "type" => "charge", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "11.50", "fee" => "0.63", "net" => "10.87", "source_id" => 843310825, "source_type" => "charge", "source_order_id" => 625362839, "source_order_transaction_id" => 897736458, "processed_at" => "2016-08-04T18:07:57-04:00", "adjustment_order_transactions" => nil, "adjustment_reason" => nil}, {"id" => 841651232, "type" => "debit", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "-100.00", "fee" => "0.00", "net" => "-100.00", "source_id" => 841651232, "source_type" => "Payments::Balance::AdjustmentReversal", "source_order_id" => nil, "source_order_transaction_id" => nil, "processed_at" => "2016-08-04T18:07:57-04:00", "adjustment_order_transactions" => nil, "adjustment_reason" => nil}, {"id" => 777723124, "type" => "debit", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "-100.00", "fee" => "0.00", "net" => "-100.00", "source_id" => 777723124, "source_type" => "Payments::Balance::AdjustmentReversal", "source_order_id" => nil, "source_order_transaction_id" => nil, "processed_at" => "2016-08-04T18:07:57-04:00", "adjustment_order_transactions" => nil, "adjustment_reason" => nil}, {"id" => 744334347, "type" => "credit", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "100.00", "fee" => "0.00", "net" => "100.00", "source_id" => 14450113, "source_type" => "adjustment", "source_order_id" => nil, "source_order_transaction_id" => nil, "processed_at" => "2016-08-04T18:07:57-04:00", "adjustment_order_transactions" => [{"id" => 348327371, "amount" => "11.50", "order" => {"id" => 625362839, "name" => "#1001"}}], "adjustment_reason" => "shopify_collective_credit"}, {"id" => 717600021, "type" => "credit", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "100.00", "fee" => "0.00", "net" => "100.00", "source_id" => 717600021, "source_type" => "adjustment", "source_order_id" => nil, "source_order_transaction_id" => nil, "processed_at" => "2016-08-04T18:07:57-04:00", "adjustment_order_transactions" => [], "adjustment_reason" => "chargeback_protection"}, {"id" => 645292099, "type" => "credit", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "100.00", "fee" => "0.00", "net" => "100.00", "source_id" => 717600021, "source_type" => "adjustment", "source_order_id" => nil, "source_order_transaction_id" => nil, "processed_at" => "2016-08-04T18:07:57-04:00", "adjustment_order_transactions" => [], "adjustment_reason" => "chargeback_protection"}, {"id" => 637679484, "type" => "SHOPIFY_COLLECTIVE_DEBIT_REVERSAL", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "1.00", "fee" => "0.00", "net" => "1.00", "source_id" => 637679484, "source_type" => "Payments::Balance::AdjustmentReversal", "source_order_id" => nil, "source_order_transaction_id" => nil, "processed_at" => "2016-08-04T18:07:57-04:00", "adjustment_order_transactions" => nil, "adjustment_reason" => nil}, {"id" => 620327031, "type" => "charge", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "11.50", "fee" => "0.63", "net" => "10.87", "source_id" => 620327031, "source_type" => "charge", "source_order_id" => nil, "source_order_transaction_id" => nil, "processed_at" => "2016-08-04T18:07:57-04:00", "adjustment_order_transactions" => nil, "adjustment_reason" => nil}, {"id" => 524892362, "type" => "debit", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "-100.00", "fee" => "0.00", "net" => "-100.00", "source_id" => 87730317, "source_type" => "adjustment", "source_order_id" => 625362839, "source_order_transaction_id" => nil, "processed_at" => "2016-08-04T18:07:57-04:00", "adjustment_order_transactions" => [{"id" => 348327371, "amount" => "11.50", "order" => {"id" => 625362839, "name" => "#1001"}}], "adjustment_reason" => "shopify_collective_debit"}, {"id" => 510004917, "type" => "debit", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "100.00", "fee" => "0.00", "net" => "100.00", "source_id" => 504962724, "source_type" => "adjustment", "source_order_id" => nil, "source_order_transaction_id" => nil, "processed_at" => "2016-08-04T18:07:57-04:00", "adjustment_order_transactions" => [], "adjustment_reason" => "shop_cash_campaign_billing"}, {"id" => 504303358, "type" => "seller_protection_credit_reversal", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "-100.00", "fee" => "0.00", "net" => "-100.00", "source_id" => 504303358, "source_type" => "Payments::Balance::AdjustmentReversal", "source_order_id" => nil, "source_order_transaction_id" => nil, "processed_at" => "2016-08-04T18:07:57-04:00", "adjustment_order_transactions" => nil, "adjustment_reason" => nil}, {"id" => 459441379, "type" => "credit", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "100.00", "fee" => "0.00", "net" => "100.00", "source_id" => 14450113, "source_type" => "adjustment", "source_order_id" => nil, "source_order_transaction_id" => nil, "processed_at" => "2016-08-04T18:07:57-04:00", "adjustment_order_transactions" => [{"id" => 348327371, "amount" => "11.50", "order" => {"id" => 625362839, "name" => "#1001"}}], "adjustment_reason" => "shopify_collective_credit"}, {"id" => 427940661, "type" => "credit", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "150.00", "fee" => "0.00", "net" => "150.00", "source_id" => 427940661, "source_type" => "Payments::Balance::AdjustmentReversal", "source_order_id" => nil, "source_order_transaction_id" => nil, "processed_at" => "2016-08-04T18:07:57-04:00", "adjustment_order_transactions" => nil, "adjustment_reason" => nil}, {"id" => 381560291, "type" => "debit", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "-150.00", "fee" => "0.00", "net" => "-150.00", "source_id" => 381560291, "source_type" => "adjustment", "source_order_id" => nil, "source_order_transaction_id" => nil, "processed_at" => "2016-08-04T18:07:57-04:00", "adjustment_order_transactions" => [], "adjustment_reason" => "chargeback_protection"}, {"id" => 357948134, "type" => "charge", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "10.00", "fee" => "0.46", "net" => "9.54", "source_id" => 971443537, "source_type" => "charge", "source_order_id" => 625362839, "source_order_transaction_id" => 461790020, "processed_at" => "2016-08-04T18:07:57-04:00", "adjustment_order_transactions" => nil, "adjustment_reason" => nil}, {"id" => 344667176, "type" => "credit", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "100.50", "fee" => "0.50", "net" => "100.00", "source_id" => 291591126, "source_type" => "adjustment", "source_order_id" => nil, "source_order_transaction_id" => nil, "processed_at" => "2016-08-04T18:07:57-04:00", "adjustment_order_transactions" => [], "adjustment_reason" => "shop_cash"}, {"id" => 316417004, "type" => "charge", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "11.50", "fee" => "0.50", "net" => "11.00", "source_id" => 316417004, "source_type" => "charge", "source_order_id" => 753768948, "source_order_transaction_id" => 316417004, "processed_at" => "2016-08-04T18:07:57-04:00", "adjustment_order_transactions" => nil, "adjustment_reason" => nil}, {"id" => 294868963, "type" => "debit", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "-100.00", "fee" => "0.00", "net" => "-100.00", "source_id" => 294868963, "source_type" => "Payments::Balance::AdjustmentReversal", "source_order_id" => nil, "source_order_transaction_id" => nil, "processed_at" => "2016-08-04T18:07:57-04:00", "adjustment_order_transactions" => nil, "adjustment_reason" => nil}, {"id" => 268738895, "type" => "credit", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "1000.00", "fee" => "0.00", "net" => "1000.00", "source_id" => 60315799, "source_type" => "adjustment", "source_order_id" => nil, "source_order_transaction_id" => nil, "processed_at" => "2016-08-04T18:07:57-04:00", "adjustment_order_transactions" => [], "adjustment_reason" => "anomaly"}, {"id" => 232023232, "type" => "reserve", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "42.00", "fee" => "0.00", "net" => "42.00", "source_id" => nil, "source_type" => nil, "source_order_id" => nil, "source_order_transaction_id" => nil, "processed_at" => "2016-08-04T18:07:57-04:00", "adjustment_order_transactions" => nil, "adjustment_reason" => nil}, {"id" => 222417706, "type" => "advance_funding", "test" => false, "payout_id" => 623721858, "payout_status" => "paid", "currency" => "USD", "amount" => "-10.00", "fee" => "0.00", "net" => "-10.00", "source_id" => nil, "source_type" => nil, "source_order_id" => nil, "source_order_transaction_id" => nil, "processed_at" => "2016-08-04T18:07:57-04:00", "adjustment_order_transactions" => nil, "adjustment_reason" => nil}]}), headers: {})

    response = ShopifyAPI::PaymentTransaction.transactions(
      payout_id: "623721858",
    )

    assert_requested(:get, "https://test-shop.myshopify.io/admin/api/2025-10/shopify_payments/balance/transactions.json?payout_id=623721858")

    response = response.first if response.respond_to?(:first)

    # Assert attributes are correctly typed preventing Sorbet errors downstream
    if response.respond_to?(:original_state)
      response&.original_state&.each do |key, value|
        begin
          response.send(key)
        rescue TypeError => error
          fail TypeError.new("#{self.class}##{key} is mistyped: #{error.message}")
        end
        response.send(key)
      end
    end
  end

end
