# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `rbi` gem.
# Please instead update this file by running `bin/tapioca gem rbi`.

module RBI; end

class RBI::ASTVisitor
  abstract!

  def initialize(*args, &blk); end

  sig { abstract.params(node: T.nilable(AST::Node)).void }
  def visit(node); end

  sig { params(nodes: T::Array[AST::Node]).void }
  def visit_all(nodes); end

  private

  sig { params(node: AST::Node).returns(String) }
  def parse_expr(node); end

  sig { params(node: AST::Node).returns(String) }
  def parse_name(node); end
end

class RBI::Arg < ::RBI::Node
  sig { params(value: String, loc: T.nilable(RBI::Loc)).void }
  def initialize(value, loc: T.unsafe(nil)); end

  sig { params(other: T.nilable(Object)).returns(T::Boolean) }
  def ==(other); end

  sig { override.params(v: RBI::Printer).void }
  def accept_printer(v); end

  sig { returns(String) }
  def to_s; end

  sig { returns(String) }
  def value; end
end

class RBI::Attr < ::RBI::NodeWithComments
  include ::RBI::Indexable

  abstract!

  sig { params(name: Symbol, names: T::Array[Symbol], visibility: RBI::Visibility, sigs: T::Array[RBI::Sig], loc: T.nilable(RBI::Loc), comments: T::Array[RBI::Comment]).void }
  def initialize(name, names, visibility: T.unsafe(nil), sigs: T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil)); end

  sig { override.params(v: RBI::Printer).void }
  def accept_printer(v); end

  sig { override.params(other: RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  sig { abstract.returns(T::Array[String]) }
  def fully_qualified_names; end

  sig { override.returns(T::Array[String]) }
  def index_ids; end

  sig { override.params(other: RBI::Node).void }
  def merge_with(other); end

  sig { returns(T::Array[Symbol]) }
  def names; end

  def names=(_arg0); end

  sig { override.returns(T::Boolean) }
  def oneline?; end

  sig { returns(T::Array[RBI::Sig]) }
  def sigs; end

  sig { returns(RBI::Visibility) }
  def visibility; end

  def visibility=(_arg0); end
end

class RBI::AttrAccessor < ::RBI::Attr
  sig { params(name: Symbol, names: Symbol, visibility: RBI::Visibility, sigs: T::Array[RBI::Sig], loc: T.nilable(RBI::Loc), comments: T::Array[RBI::Comment], block: T.nilable(T.proc.params(node: RBI::AttrAccessor).void)).void }
  def initialize(name, *names, visibility: T.unsafe(nil), sigs: T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  sig { override.params(other: RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  sig { override.returns(T::Array[String]) }
  def fully_qualified_names; end

  sig { override.returns(String) }
  def to_s; end
end

class RBI::AttrReader < ::RBI::Attr
  sig { params(name: Symbol, names: Symbol, visibility: RBI::Visibility, sigs: T::Array[RBI::Sig], loc: T.nilable(RBI::Loc), comments: T::Array[RBI::Comment], block: T.nilable(T.proc.params(node: RBI::AttrReader).void)).void }
  def initialize(name, *names, visibility: T.unsafe(nil), sigs: T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  sig { override.params(other: RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  sig { override.returns(T::Array[String]) }
  def fully_qualified_names; end

  sig { override.returns(String) }
  def to_s; end
end

class RBI::AttrWriter < ::RBI::Attr
  sig { params(name: Symbol, names: Symbol, visibility: RBI::Visibility, sigs: T::Array[RBI::Sig], loc: T.nilable(RBI::Loc), comments: T::Array[RBI::Comment], block: T.nilable(T.proc.params(node: RBI::AttrWriter).void)).void }
  def initialize(name, *names, visibility: T.unsafe(nil), sigs: T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  sig { override.params(other: RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  sig { override.returns(T::Array[String]) }
  def fully_qualified_names; end

  sig { override.returns(String) }
  def to_s; end
end

class RBI::BlankLine < ::RBI::Comment
  sig { params(loc: T.nilable(RBI::Loc)).void }
  def initialize(loc: T.unsafe(nil)); end

  sig { override.params(v: RBI::Printer).void }
  def accept_printer(v); end
end

class RBI::BlockParam < ::RBI::Param
  sig { params(name: String, loc: T.nilable(RBI::Loc), comments: T::Array[RBI::Comment], block: T.nilable(T.proc.params(node: RBI::BlockParam).void)).void }
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  sig { params(other: T.nilable(Object)).returns(T::Boolean) }
  def ==(other); end

  sig { override.params(v: RBI::Printer).void }
  def accept_printer(v); end

  sig { override.params(v: RBI::Printer, last: T::Boolean).void }
  def print_comment_leading_space(v, last:); end

  sig { override.returns(String) }
  def to_s; end
end

class RBI::Class < ::RBI::Scope
  sig { params(name: String, superclass_name: T.nilable(String), loc: T.nilable(RBI::Loc), comments: T::Array[RBI::Comment], block: T.nilable(T.proc.params(node: RBI::Class).void)).void }
  def initialize(name, superclass_name: T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  sig { override.params(other: RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  sig { override.returns(String) }
  def fully_qualified_name; end

  sig { returns(String) }
  def name; end

  def name=(_arg0); end

  sig { override.params(v: RBI::Printer).void }
  def print_header(v); end

  sig { returns(T.nilable(String)) }
  def superclass_name; end

  def superclass_name=(_arg0); end
end

class RBI::Comment < ::RBI::Node
  sig { params(text: String, loc: T.nilable(RBI::Loc)).void }
  def initialize(text, loc: T.unsafe(nil)); end

  sig { params(other: Object).returns(T::Boolean) }
  def ==(other); end

  sig { override.params(v: RBI::Printer).void }
  def accept_printer(v); end

  sig { returns(String) }
  def text; end

  def text=(_arg0); end
end

class RBI::ConflictTree < ::RBI::Tree
  sig { params(left_name: String, right_name: String).void }
  def initialize(left_name: T.unsafe(nil), right_name: T.unsafe(nil)); end

  sig { override.params(v: RBI::Printer).void }
  def accept_printer(v); end

  sig { returns(RBI::Tree) }
  def left; end

  def right; end
end

class RBI::Const < ::RBI::NodeWithComments
  include ::RBI::Indexable

  sig { params(name: String, value: String, loc: T.nilable(RBI::Loc), comments: T::Array[RBI::Comment], block: T.nilable(T.proc.params(node: RBI::Const).void)).void }
  def initialize(name, value, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  sig { override.params(v: RBI::Printer).void }
  def accept_printer(v); end

  sig { override.params(other: RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  sig { returns(String) }
  def fully_qualified_name; end

  sig { override.returns(T::Array[String]) }
  def index_ids; end

  sig { returns(String) }
  def name; end

  sig { override.returns(String) }
  def to_s; end

  def value; end
end

class RBI::ConstBuilder < ::RBI::ASTVisitor
  sig { void }
  def initialize; end

  sig { returns(T::Array[String]) }
  def names; end

  def names=(_arg0); end

  sig { override.params(node: T.nilable(AST::Node)).void }
  def visit(node); end

  class << self
    sig { params(node: T.nilable(AST::Node)).returns(T.nilable(String)) }
    def visit(node); end
  end
end

class RBI::Error < ::StandardError; end

class RBI::Extend < ::RBI::Mixin
  include ::RBI::Indexable

  sig { params(name: String, names: String, loc: T.nilable(RBI::Loc), comments: T::Array[RBI::Comment], block: T.nilable(T.proc.params(node: RBI::Extend).void)).void }
  def initialize(name, *names, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  sig { override.params(other: RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  sig { override.returns(T::Array[String]) }
  def index_ids; end

  sig { override.returns(String) }
  def to_s; end
end

class RBI::File
  sig { params(strictness: T.nilable(String), comments: T::Array[RBI::Comment], block: T.nilable(T.proc.params(file: RBI::File).void)).void }
  def initialize(strictness: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  sig { params(node: RBI::Node).void }
  def <<(node); end

  sig { params(v: RBI::Printer).void }
  def accept_printer(v); end

  sig { returns(T::Array[RBI::Comment]) }
  def comments; end

  def comments=(_arg0); end

  sig { returns(T::Boolean) }
  def empty?; end

  sig { params(out: T.any(IO, StringIO), indent: Integer, print_locs: T::Boolean, max_line_length: T.nilable(Integer)).void }
  def print(out: T.unsafe(nil), indent: T.unsafe(nil), print_locs: T.unsafe(nil), max_line_length: T.unsafe(nil)); end

  sig { returns(RBI::Tree) }
  def root; end

  def root=(_arg0); end

  sig { void }
  def set_empty_body_content; end

  sig { params(command: String, reason: T.nilable(String), display_heading: T::Boolean).void }
  def set_file_header(command, reason: T.unsafe(nil), display_heading: T.unsafe(nil)); end

  sig { returns(T.nilable(String)) }
  def strictness; end

  def strictness=(_arg0); end

  sig { params(indent: Integer, print_locs: T::Boolean, max_line_length: T.nilable(Integer)).returns(String) }
  def string(indent: T.unsafe(nil), print_locs: T.unsafe(nil), max_line_length: T.unsafe(nil)); end

  sig { void }
  def transform_rbi!; end

  sig { returns(String) }
  def transformed_string; end
end

class RBI::Group < ::RBI::Tree
  sig { params(kind: RBI::Group::Kind).void }
  def initialize(kind); end

  sig { override.params(v: RBI::Printer).void }
  def accept_printer(v); end

  sig { returns(RBI::Group::Kind) }
  def kind; end
end

class RBI::Group::Kind < ::T::Enum
  enums do
    Mixins = new
    RequiredAncestors = new
    Helpers = new
    TypeMembers = new
    MixesInClassMethods = new
    Sends = new
    Attrs = new
    TStructFields = new
    TEnums = new
    Inits = new
    Methods = new
    SingletonClasses = new
    Consts = new
  end
end

class RBI::Helper < ::RBI::NodeWithComments
  include ::RBI::Indexable

  sig { params(name: String, loc: T.nilable(RBI::Loc), comments: T::Array[RBI::Comment], block: T.nilable(T.proc.params(node: RBI::Helper).void)).void }
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  sig { override.params(v: RBI::Printer).void }
  def accept_printer(v); end

  sig { override.params(other: RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  sig { override.returns(T::Array[String]) }
  def index_ids; end

  sig { returns(String) }
  def name; end

  sig { override.returns(String) }
  def to_s; end
end

class RBI::Include < ::RBI::Mixin
  include ::RBI::Indexable

  sig { params(name: String, names: String, loc: T.nilable(RBI::Loc), comments: T::Array[RBI::Comment], block: T.nilable(T.proc.params(node: RBI::Include).void)).void }
  def initialize(name, *names, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  sig { override.params(other: RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  sig { override.returns(T::Array[String]) }
  def index_ids; end

  sig { override.returns(String) }
  def to_s; end
end

class RBI::Index < ::RBI::Visitor
  sig { void }
  def initialize; end

  sig { params(id: String).returns(T::Array[RBI::Node]) }
  def [](id); end

  sig { params(nodes: RBI::Node).void }
  def index(*nodes); end

  sig { returns(T::Array[String]) }
  def keys; end

  sig { override.params(node: T.nilable(RBI::Node)).void }
  def visit(node); end

  private

  sig { params(node: T.all(RBI::Indexable, RBI::Node)).void }
  def index_node(node); end

  class << self
    sig { params(node: RBI::Node).returns(RBI::Index) }
    def index(*node); end
  end
end

module RBI::Indexable
  interface!

  sig { abstract.returns(T::Array[String]) }
  def index_ids; end
end

class RBI::KwArg < ::RBI::Arg
  sig { params(keyword: String, value: String, loc: T.nilable(RBI::Loc)).void }
  def initialize(keyword, value, loc: T.unsafe(nil)); end

  sig { params(other: T.nilable(Object)).returns(T::Boolean) }
  def ==(other); end

  sig { override.params(v: RBI::Printer).void }
  def accept_printer(v); end

  sig { returns(String) }
  def keyword; end

  sig { returns(String) }
  def to_s; end
end

class RBI::KwOptParam < ::RBI::Param
  sig { params(name: String, value: String, loc: T.nilable(RBI::Loc), comments: T::Array[RBI::Comment], block: T.nilable(T.proc.params(node: RBI::KwOptParam).void)).void }
  def initialize(name, value, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  sig { params(other: T.nilable(Object)).returns(T::Boolean) }
  def ==(other); end

  sig { override.params(v: RBI::Printer).void }
  def accept_printer(v); end

  sig { override.params(v: RBI::Printer, last: T::Boolean).void }
  def print_comment_leading_space(v, last:); end

  sig { override.returns(String) }
  def to_s; end

  sig { returns(String) }
  def value; end
end

class RBI::KwParam < ::RBI::Param
  sig { params(name: String, loc: T.nilable(RBI::Loc), comments: T::Array[RBI::Comment], block: T.nilable(T.proc.params(node: RBI::KwParam).void)).void }
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  sig { params(other: T.nilable(Object)).returns(T::Boolean) }
  def ==(other); end

  sig { override.params(v: RBI::Printer).void }
  def accept_printer(v); end

  sig { override.params(v: RBI::Printer, last: T::Boolean).void }
  def print_comment_leading_space(v, last:); end

  sig { override.returns(String) }
  def to_s; end
end

class RBI::KwRestParam < ::RBI::Param
  sig { params(name: String, loc: T.nilable(RBI::Loc), comments: T::Array[RBI::Comment], block: T.nilable(T.proc.params(node: RBI::KwRestParam).void)).void }
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  sig { params(other: T.nilable(Object)).returns(T::Boolean) }
  def ==(other); end

  sig { override.params(v: RBI::Printer).void }
  def accept_printer(v); end

  sig { override.params(v: RBI::Printer, last: T::Boolean).void }
  def print_comment_leading_space(v, last:); end

  sig { override.returns(String) }
  def to_s; end
end

class RBI::Loc
  sig { params(file: T.nilable(String), begin_line: T.nilable(Integer), end_line: T.nilable(Integer), begin_column: T.nilable(Integer), end_column: T.nilable(Integer)).void }
  def initialize(file: T.unsafe(nil), begin_line: T.unsafe(nil), end_line: T.unsafe(nil), begin_column: T.unsafe(nil), end_column: T.unsafe(nil)); end

  def begin_column; end

  sig { returns(T.nilable(Integer)) }
  def begin_line; end

  def end_column; end
  def end_line; end

  sig { returns(T.nilable(String)) }
  def file; end

  sig { returns(String) }
  def to_s; end

  class << self
    sig { params(file: String, ast_loc: T.any(Parser::Source::Map, Parser::Source::Range)).returns(RBI::Loc) }
    def from_ast_loc(file, ast_loc); end
  end
end

class RBI::MergeTree < ::RBI::Tree
  sig { params(loc: T.nilable(RBI::Loc), comments: T::Array[RBI::Comment], conflicts: T::Array[RBI::Rewriters::Merge::Conflict], block: T.nilable(T.proc.params(node: RBI::Tree).void)).void }
  def initialize(loc: T.unsafe(nil), comments: T.unsafe(nil), conflicts: T.unsafe(nil), &block); end

  sig { returns(T::Array[RBI::Rewriters::Merge::Conflict]) }
  def conflicts; end
end

class RBI::Method < ::RBI::NodeWithComments
  include ::RBI::Indexable

  sig { params(name: String, params: T::Array[RBI::Param], is_singleton: T::Boolean, visibility: RBI::Visibility, sigs: T::Array[RBI::Sig], loc: T.nilable(RBI::Loc), comments: T::Array[RBI::Comment], block: T.nilable(T.proc.params(node: RBI::Method).void)).void }
  def initialize(name, params: T.unsafe(nil), is_singleton: T.unsafe(nil), visibility: T.unsafe(nil), sigs: T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  sig { params(param: RBI::Param).void }
  def <<(param); end

  sig { override.params(v: RBI::Printer).void }
  def accept_printer(v); end

  sig { override.params(other: RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  sig { returns(String) }
  def fully_qualified_name; end

  sig { override.returns(T::Array[String]) }
  def index_ids; end

  sig { returns(T::Boolean) }
  def inline_params?; end

  sig { returns(T::Boolean) }
  def is_singleton; end

  def is_singleton=(_arg0); end

  sig { override.params(other: RBI::Node).void }
  def merge_with(other); end

  sig { returns(String) }
  def name; end

  def name=(_arg0); end

  sig { override.returns(T::Boolean) }
  def oneline?; end

  sig { returns(T::Array[RBI::Param]) }
  def params; end

  sig { returns(T::Array[RBI::Sig]) }
  def sigs; end

  def sigs=(_arg0); end

  sig { override.returns(String) }
  def to_s; end

  sig { returns(RBI::Visibility) }
  def visibility; end

  def visibility=(_arg0); end
end

class RBI::MixesInClassMethods < ::RBI::Mixin
  include ::RBI::Indexable

  sig { params(name: String, names: String, loc: T.nilable(RBI::Loc), comments: T::Array[RBI::Comment], block: T.nilable(T.proc.params(node: RBI::MixesInClassMethods).void)).void }
  def initialize(name, *names, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  sig { override.params(other: RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  sig { override.returns(T::Array[String]) }
  def index_ids; end

  sig { override.returns(String) }
  def to_s; end
end

class RBI::Mixin < ::RBI::NodeWithComments
  abstract!

  sig { params(name: String, names: T::Array[String], loc: T.nilable(RBI::Loc), comments: T::Array[RBI::Comment]).void }
  def initialize(name, names, loc: T.unsafe(nil), comments: T.unsafe(nil)); end

  sig { override.params(v: RBI::Printer).void }
  def accept_printer(v); end

  sig { override.params(other: RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  sig { returns(T::Array[String]) }
  def names; end

  def names=(_arg0); end
end

class RBI::Module < ::RBI::Scope
  sig { params(name: String, loc: T.nilable(RBI::Loc), comments: T::Array[RBI::Comment], block: T.nilable(T.proc.params(node: RBI::Module).void)).void }
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  sig { override.params(other: RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  sig { override.returns(String) }
  def fully_qualified_name; end

  sig { returns(String) }
  def name; end

  def name=(_arg0); end

  sig { override.params(v: RBI::Printer).void }
  def print_header(v); end
end

class RBI::Node
  abstract!

  sig { params(loc: T.nilable(RBI::Loc)).void }
  def initialize(loc: T.unsafe(nil)); end

  sig { abstract.params(v: RBI::Printer).void }
  def accept_printer(v); end

  sig { params(_other: RBI::Node).returns(T::Boolean) }
  def compatible_with?(_other); end

  sig { void }
  def detach; end

  sig { returns(RBI::Group::Kind) }
  def group_kind; end

  sig { returns(T.nilable(RBI::Loc)) }
  def loc; end

  def loc=(_arg0); end

  sig { params(other: RBI::Node).void }
  def merge_with(other); end

  sig { returns(T::Boolean) }
  def oneline?; end

  sig { returns(T.nilable(RBI::ConflictTree)) }
  def parent_conflict_tree; end

  sig { returns(T.nilable(RBI::Scope)) }
  def parent_scope; end

  sig { returns(T.nilable(RBI::Tree)) }
  def parent_tree; end

  def parent_tree=(_arg0); end

  sig { params(out: T.any(IO, StringIO), indent: Integer, print_locs: T::Boolean, max_line_length: T.nilable(Integer)).void }
  def print(out: T.unsafe(nil), indent: T.unsafe(nil), print_locs: T.unsafe(nil), max_line_length: T.unsafe(nil)); end

  sig { params(v: RBI::Printer).void }
  def print_blank_line_before(v); end

  sig { params(node: RBI::Node).void }
  def replace(node); end

  sig { params(indent: Integer, print_locs: T::Boolean, max_line_length: T.nilable(Integer)).returns(String) }
  def string(indent: T.unsafe(nil), print_locs: T.unsafe(nil), max_line_length: T.unsafe(nil)); end
end

class RBI::NodeWithComments < ::RBI::Node
  abstract!

  sig { params(loc: T.nilable(RBI::Loc), comments: T::Array[RBI::Comment]).void }
  def initialize(loc: T.unsafe(nil), comments: T.unsafe(nil)); end

  sig { returns(T::Array[String]) }
  def annotations; end

  sig { returns(T::Array[RBI::Comment]) }
  def comments; end

  def comments=(_arg0); end

  sig { override.params(other: RBI::Node).void }
  def merge_with(other); end

  sig { override.returns(T::Boolean) }
  def oneline?; end
end

class RBI::OptParam < ::RBI::Param
  sig { params(name: String, value: String, loc: T.nilable(RBI::Loc), comments: T::Array[RBI::Comment], block: T.nilable(T.proc.params(node: RBI::OptParam).void)).void }
  def initialize(name, value, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  sig { params(other: T.nilable(Object)).returns(T::Boolean) }
  def ==(other); end

  sig { override.params(v: RBI::Printer).void }
  def accept_printer(v); end

  sig { override.params(v: RBI::Printer, last: T::Boolean).void }
  def print_comment_leading_space(v, last:); end

  sig { returns(String) }
  def value; end
end

class RBI::Param < ::RBI::NodeWithComments
  abstract!

  sig { params(name: String, loc: T.nilable(RBI::Loc), comments: T::Array[RBI::Comment]).void }
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil)); end

  sig { override.params(v: RBI::Printer).void }
  def accept_printer(v); end

  sig { returns(T::Array[String]) }
  def comments_lines; end

  sig { returns(String) }
  def name; end

  sig { params(v: RBI::Printer, last: T::Boolean).void }
  def print_comment_leading_space(v, last:); end

  sig { override.returns(String) }
  def to_s; end
end

class RBI::ParseError < ::StandardError
  sig { params(message: String, location: RBI::Loc).void }
  def initialize(message, location); end

  sig { returns(RBI::Loc) }
  def location; end
end

class RBI::Parser
  sig { void }
  def initialize; end

  sig { params(path: String).returns(RBI::Tree) }
  def parse_file(path); end

  sig { params(string: String).returns(RBI::Tree) }
  def parse_string(string); end

  private

  sig { params(content: String, file: String).returns(RBI::Tree) }
  def parse(content, file:); end

  class << self
    sig { params(path: String).returns(RBI::Tree) }
    def parse_file(path); end

    sig { params(paths: T::Array[String]).returns(T::Array[RBI::Tree]) }
    def parse_files(paths); end

    sig { params(string: String).returns(RBI::Tree) }
    def parse_string(string); end

    sig { params(strings: T::Array[String]).returns(T::Array[RBI::Tree]) }
    def parse_strings(strings); end
  end
end

class RBI::Printer < ::RBI::Visitor
  sig { params(out: T.any(IO, StringIO), indent: Integer, print_locs: T::Boolean, max_line_length: T.nilable(Integer)).void }
  def initialize(out: T.unsafe(nil), indent: T.unsafe(nil), print_locs: T.unsafe(nil), max_line_length: T.unsafe(nil)); end

  sig { returns(Integer) }
  def current_indent; end

  sig { void }
  def dedent; end

  def in_visibility_group; end
  def in_visibility_group=(_arg0); end

  sig { void }
  def indent; end

  sig { returns(T.nilable(Integer)) }
  def max_line_length; end

  sig { returns(T.nilable(RBI::Node)) }
  def previous_node; end

  sig { params(string: String).void }
  def print(string); end

  sig { returns(T::Boolean) }
  def print_locs; end

  def print_locs=(_arg0); end

  sig { params(string: String).void }
  def printl(string); end

  sig { params(string: T.nilable(String)).void }
  def printn(string = T.unsafe(nil)); end

  sig { params(string: T.nilable(String)).void }
  def printt(string = T.unsafe(nil)); end

  sig { override.params(node: T.nilable(RBI::Node)).void }
  def visit(node); end

  sig { override.params(nodes: T::Array[RBI::Node]).void }
  def visit_all(nodes); end

  sig { params(file: RBI::File).void }
  def visit_file(file); end
end

class RBI::Private < ::RBI::Visibility
  sig { params(loc: T.nilable(RBI::Loc), comments: T::Array[RBI::Comment], block: T.nilable(T.proc.params(node: RBI::Private).void)).void }
  def initialize(loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end
end

class RBI::Protected < ::RBI::Visibility
  sig { params(loc: T.nilable(RBI::Loc), comments: T::Array[RBI::Comment], block: T.nilable(T.proc.params(node: RBI::Protected).void)).void }
  def initialize(loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end
end

class RBI::Public < ::RBI::Visibility
  sig { params(loc: T.nilable(RBI::Loc), comments: T::Array[RBI::Comment], block: T.nilable(T.proc.params(node: RBI::Public).void)).void }
  def initialize(loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end
end

class RBI::ReqParam < ::RBI::Param
  sig { params(name: String, loc: T.nilable(RBI::Loc), comments: T::Array[RBI::Comment], block: T.nilable(T.proc.params(node: RBI::ReqParam).void)).void }
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  sig { params(other: T.nilable(Object)).returns(T::Boolean) }
  def ==(other); end
end

class RBI::RequiresAncestor < ::RBI::NodeWithComments
  include ::RBI::Indexable

  sig { params(name: String, loc: T.nilable(RBI::Loc), comments: T::Array[RBI::Comment]).void }
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil)); end

  sig { override.params(v: RBI::Printer).void }
  def accept_printer(v); end

  sig { override.returns(T::Array[String]) }
  def index_ids; end

  sig { returns(String) }
  def name; end

  sig { override.returns(String) }
  def to_s; end
end

class RBI::RestParam < ::RBI::Param
  sig { params(name: String, loc: T.nilable(RBI::Loc), comments: T::Array[RBI::Comment], block: T.nilable(T.proc.params(node: RBI::RestParam).void)).void }
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  sig { params(other: T.nilable(Object)).returns(T::Boolean) }
  def ==(other); end

  sig { override.params(v: RBI::Printer).void }
  def accept_printer(v); end

  sig { override.params(v: RBI::Printer, last: T::Boolean).void }
  def print_comment_leading_space(v, last:); end

  sig { override.returns(String) }
  def to_s; end
end

module RBI::Rewriters; end

class RBI::Rewriters::AddSigTemplates < ::RBI::Visitor
  sig { params(with_todo_comment: T::Boolean).void }
  def initialize(with_todo_comment: T.unsafe(nil)); end

  sig { override.params(node: T.nilable(RBI::Node)).void }
  def visit(node); end

  private

  sig { params(attr: RBI::Attr).void }
  def add_attr_sig(attr); end

  sig { params(method: RBI::Method).void }
  def add_method_sig(method); end

  sig { params(node: RBI::NodeWithComments).void }
  def add_todo_comment(node); end
end

class RBI::Rewriters::Annotate < ::RBI::Visitor
  sig { params(annotation: String, annotate_scopes: T::Boolean, annotate_properties: T::Boolean).void }
  def initialize(annotation, annotate_scopes: T.unsafe(nil), annotate_properties: T.unsafe(nil)); end

  sig { override.params(node: T.nilable(RBI::Node)).void }
  def visit(node); end

  private

  sig { params(node: RBI::NodeWithComments).void }
  def annotate_node(node); end

  sig { params(node: RBI::Node).returns(T::Boolean) }
  def root?(node); end
end

class RBI::Rewriters::Deannotate < ::RBI::Visitor
  sig { params(annotation: String).void }
  def initialize(annotation); end

  sig { override.params(node: T.nilable(RBI::Node)).void }
  def visit(node); end

  private

  sig { params(node: RBI::NodeWithComments).void }
  def deannotate_node(node); end
end

class RBI::Rewriters::GroupNodes < ::RBI::Visitor
  sig { override.params(node: T.nilable(RBI::Node)).void }
  def visit(node); end
end

class RBI::Rewriters::Merge
  sig { params(left_name: String, right_name: String, keep: RBI::Rewriters::Merge::Keep).void }
  def initialize(left_name: T.unsafe(nil), right_name: T.unsafe(nil), keep: T.unsafe(nil)); end

  sig { params(tree: RBI::Tree).void }
  def merge(tree); end

  sig { returns(RBI::MergeTree) }
  def tree; end

  class << self
    sig { params(left: RBI::Tree, right: RBI::Tree, left_name: String, right_name: String, keep: RBI::Rewriters::Merge::Keep).returns(RBI::MergeTree) }
    def merge_trees(left, right, left_name: T.unsafe(nil), right_name: T.unsafe(nil), keep: T.unsafe(nil)); end
  end
end

class RBI::Rewriters::Merge::Conflict < ::T::Struct
  const :left, RBI::Node
  const :left_name, String
  const :right, RBI::Node
  const :right_name, String

  sig { returns(String) }
  def to_s; end

  class << self
    def inherited(s); end
  end
end

class RBI::Rewriters::Merge::ConflictTreeMerger < ::RBI::Visitor
  sig { override.params(node: T.nilable(RBI::Node)).void }
  def visit(node); end

  sig { override.params(nodes: T::Array[RBI::Node]).void }
  def visit_all(nodes); end

  private

  sig { params(left: RBI::Tree, right: RBI::Tree).void }
  def merge_conflict_trees(left, right); end
end

class RBI::Rewriters::Merge::Keep < ::T::Enum
  enums do
    NONE = new
    LEFT = new
    RIGHT = new
  end
end

class RBI::Rewriters::Merge::TreeMerger < ::RBI::Visitor
  sig { params(output: RBI::Tree, left_name: String, right_name: String, keep: RBI::Rewriters::Merge::Keep).void }
  def initialize(output, left_name: T.unsafe(nil), right_name: T.unsafe(nil), keep: T.unsafe(nil)); end

  sig { returns(T::Array[RBI::Rewriters::Merge::Conflict]) }
  def conflicts; end

  sig { override.params(node: T.nilable(RBI::Node)).void }
  def visit(node); end

  private

  sig { returns(RBI::Tree) }
  def current_scope; end

  sig { params(left: RBI::Scope, right: RBI::Scope).void }
  def make_conflict_scope(left, right); end

  sig { params(left: RBI::Node, right: RBI::Node).void }
  def make_conflict_tree(left, right); end

  sig { params(node: RBI::Node).returns(T.nilable(RBI::Node)) }
  def previous_definition(node); end

  sig { params(left: RBI::Scope, right: RBI::Scope).returns(RBI::Scope) }
  def replace_scope_header(left, right); end
end

class RBI::Rewriters::NestNonPublicMethods < ::RBI::Visitor
  sig { override.params(node: T.nilable(RBI::Node)).void }
  def visit(node); end
end

class RBI::Rewriters::NestSingletonMethods < ::RBI::Visitor
  sig { override.params(node: T.nilable(RBI::Node)).void }
  def visit(node); end
end

class RBI::Rewriters::RemoveKnownDefinitions < ::RBI::Visitor
  sig { params(index: RBI::Index).void }
  def initialize(index); end

  sig { returns(T::Array[RBI::Rewriters::RemoveKnownDefinitions::Operation]) }
  def operations; end

  sig { override.params(node: T.nilable(RBI::Node)).void }
  def visit(node); end

  sig { params(nodes: T::Array[RBI::Node]).void }
  def visit_all(nodes); end

  private

  sig { params(node: RBI::Node, previous: RBI::Node).returns(T::Boolean) }
  def can_delete_node?(node, previous); end

  sig { params(node: RBI::Node, previous: RBI::Node).void }
  def delete_node(node, previous); end

  sig { params(node: RBI::Indexable).returns(T.nilable(RBI::Node)) }
  def previous_definition_for(node); end

  class << self
    sig { params(tree: RBI::Tree, index: RBI::Index).returns([RBI::Tree, T::Array[RBI::Rewriters::RemoveKnownDefinitions::Operation]]) }
    def remove(tree, index); end
  end
end

class RBI::Rewriters::RemoveKnownDefinitions::Operation < ::T::Struct
  const :deleted_node, RBI::Node
  const :duplicate_of, RBI::Node

  sig { returns(String) }
  def to_s; end

  class << self
    def inherited(s); end
  end
end

class RBI::Rewriters::SortNodes < ::RBI::Visitor
  sig { override.params(node: T.nilable(RBI::Node)).void }
  def visit(node); end

  private

  sig { params(kind: RBI::Group::Kind).returns(Integer) }
  def group_rank(kind); end

  sig { params(node: RBI::Node).returns(T.nilable(String)) }
  def node_name(node); end

  sig { params(node: RBI::Node).returns(Integer) }
  def node_rank(node); end

  sig { params(node: RBI::Node).void }
  def sort_node_names!(node); end
end

class RBI::Scope < ::RBI::Tree
  include ::RBI::Indexable

  abstract!

  def initialize(*args, &blk); end

  sig { override.params(v: RBI::Printer).void }
  def accept_printer(v); end

  sig { returns(T.self_type) }
  def dup_empty; end

  sig { abstract.returns(String) }
  def fully_qualified_name; end

  sig { override.returns(T::Array[String]) }
  def index_ids; end

  sig { params(v: RBI::Printer).void }
  def print_body(v); end

  sig { abstract.params(v: RBI::Printer).void }
  def print_header(v); end

  sig { override.returns(String) }
  def to_s; end
end

class RBI::ScopeConflict < ::RBI::Tree
  sig { params(left: RBI::Scope, right: RBI::Scope, left_name: String, right_name: String).void }
  def initialize(left:, right:, left_name: T.unsafe(nil), right_name: T.unsafe(nil)); end

  sig { override.params(v: RBI::Printer).void }
  def accept_printer(v); end

  sig { returns(RBI::Scope) }
  def left; end

  sig { override.returns(T::Boolean) }
  def oneline?; end

  def right; end
end

class RBI::Send < ::RBI::NodeWithComments
  include ::RBI::Indexable

  sig { params(method: String, args: T::Array[RBI::Arg], loc: T.nilable(RBI::Loc), comments: T::Array[RBI::Comment], block: T.nilable(T.proc.params(node: RBI::Send).void)).void }
  def initialize(method, args = T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  sig { params(arg: RBI::Arg).void }
  def <<(arg); end

  sig { params(other: T.nilable(Object)).returns(T::Boolean) }
  def ==(other); end

  sig { override.params(v: RBI::Printer).void }
  def accept_printer(v); end

  sig { returns(T::Array[RBI::Arg]) }
  def args; end

  sig { override.params(other: RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  sig { override.returns(T::Array[String]) }
  def index_ids; end

  sig { returns(String) }
  def method; end

  sig { returns(String) }
  def to_s; end
end

class RBI::Sig < ::RBI::Node
  sig { params(params: T::Array[RBI::SigParam], return_type: T.nilable(String), is_abstract: T::Boolean, is_override: T::Boolean, is_overridable: T::Boolean, type_params: T::Array[String], checked: T.nilable(Symbol), loc: T.nilable(RBI::Loc), block: T.nilable(T.proc.params(node: RBI::Sig).void)).void }
  def initialize(params: T.unsafe(nil), return_type: T.unsafe(nil), is_abstract: T.unsafe(nil), is_override: T.unsafe(nil), is_overridable: T.unsafe(nil), type_params: T.unsafe(nil), checked: T.unsafe(nil), loc: T.unsafe(nil), &block); end

  sig { params(param: RBI::SigParam).void }
  def <<(param); end

  sig { params(other: Object).returns(T::Boolean) }
  def ==(other); end

  sig { override.params(v: RBI::Printer).void }
  def accept_printer(v); end

  sig { returns(T.nilable(Symbol)) }
  def checked; end

  def checked=(_arg0); end

  sig { returns(T::Boolean) }
  def inline_params?; end

  sig { returns(T::Boolean) }
  def is_abstract; end

  def is_abstract=(_arg0); end
  def is_overridable; end
  def is_overridable=(_arg0); end
  def is_override; end
  def is_override=(_arg0); end

  sig { override.returns(T::Boolean) }
  def oneline?; end

  sig { returns(T::Array[RBI::SigParam]) }
  def params; end

  sig { returns(T.nilable(String)) }
  def return_type; end

  def return_type=(_arg0); end

  sig { returns(T::Array[String]) }
  def type_params; end

  private

  sig { params(v: RBI::Printer).void }
  def print_as_block(v); end

  sig { params(v: RBI::Printer).void }
  def print_as_line(v); end

  sig { returns(T::Array[String]) }
  def sig_modifiers; end
end

class RBI::SigBuilder < ::RBI::ASTVisitor
  sig { void }
  def initialize; end

  sig { returns(RBI::Sig) }
  def current; end

  def current=(_arg0); end

  sig { override.params(node: T.nilable(AST::Node)).void }
  def visit(node); end

  sig { params(node: AST::Node).void }
  def visit_send(node); end

  class << self
    sig { params(node: AST::Node).returns(RBI::Sig) }
    def build(node); end
  end
end

class RBI::SigParam < ::RBI::NodeWithComments
  sig { params(name: String, type: String, loc: T.nilable(RBI::Loc), comments: T::Array[RBI::Comment], block: T.nilable(T.proc.params(node: RBI::SigParam).void)).void }
  def initialize(name, type, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  sig { params(other: Object).returns(T::Boolean) }
  def ==(other); end

  sig { override.params(v: RBI::Printer).void }
  def accept_printer(v); end

  sig { returns(T::Array[String]) }
  def comments_lines; end

  sig { returns(String) }
  def name; end

  sig { params(v: RBI::Printer, last: T::Boolean).void }
  def print_comment_leading_space(v, last:); end

  def type; end
end

class RBI::SingletonClass < ::RBI::Scope
  sig { params(loc: T.nilable(RBI::Loc), comments: T::Array[RBI::Comment], block: T.nilable(T.proc.params(node: RBI::SingletonClass).void)).void }
  def initialize(loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  sig { override.returns(String) }
  def fully_qualified_name; end

  sig { override.params(v: RBI::Printer).void }
  def print_header(v); end
end

class RBI::Struct < ::RBI::Scope
  sig { params(name: String, members: T::Array[Symbol], keyword_init: T::Boolean, loc: T.nilable(RBI::Loc), comments: T::Array[RBI::Comment], block: T.nilable(T.proc.params(struct: RBI::Struct).void)).void }
  def initialize(name, members: T.unsafe(nil), keyword_init: T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  sig { override.params(other: RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  sig { override.returns(String) }
  def fully_qualified_name; end

  sig { returns(T::Boolean) }
  def keyword_init; end

  def keyword_init=(_arg0); end

  sig { returns(T::Array[Symbol]) }
  def members; end

  def members=(_arg0); end

  sig { returns(String) }
  def name; end

  def name=(_arg0); end

  sig { override.params(v: RBI::Printer).void }
  def print_header(v); end
end

class RBI::TEnum < ::RBI::Class
  sig { params(name: String, loc: T.nilable(RBI::Loc), comments: T::Array[RBI::Comment], block: T.nilable(T.proc.params(klass: RBI::TEnum).void)).void }
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end
end

class RBI::TEnumBlock < ::RBI::NodeWithComments
  include ::RBI::Indexable

  sig { params(names: T::Array[String], loc: T.nilable(RBI::Loc), comments: T::Array[RBI::Comment], block: T.nilable(T.proc.params(node: RBI::TEnumBlock).void)).void }
  def initialize(names = T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  sig { params(name: String).void }
  def <<(name); end

  sig { override.params(v: RBI::Printer).void }
  def accept_printer(v); end

  sig { returns(T::Boolean) }
  def empty?; end

  sig { override.returns(T::Array[String]) }
  def index_ids; end

  sig { override.params(other: RBI::Node).void }
  def merge_with(other); end

  sig { returns(T::Array[String]) }
  def names; end

  sig { override.returns(String) }
  def to_s; end
end

class RBI::TStruct < ::RBI::Class
  sig { params(name: String, loc: T.nilable(RBI::Loc), comments: T::Array[RBI::Comment], block: T.nilable(T.proc.params(klass: RBI::TStruct).void)).void }
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end
end

class RBI::TStructConst < ::RBI::TStructField
  include ::RBI::Indexable

  sig { params(name: String, type: String, default: T.nilable(String), loc: T.nilable(RBI::Loc), comments: T::Array[RBI::Comment], block: T.nilable(T.proc.params(node: RBI::TStructConst).void)).void }
  def initialize(name, type, default: T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  sig { override.params(other: RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  sig { override.returns(T::Array[String]) }
  def fully_qualified_names; end

  sig { override.returns(T::Array[String]) }
  def index_ids; end

  sig { override.returns(String) }
  def to_s; end
end

class RBI::TStructField < ::RBI::NodeWithComments
  abstract!

  sig { params(name: String, type: String, default: T.nilable(String), loc: T.nilable(RBI::Loc), comments: T::Array[RBI::Comment]).void }
  def initialize(name, type, default: T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil)); end

  sig { override.params(v: RBI::Printer).void }
  def accept_printer(v); end

  sig { override.params(other: RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  sig { returns(T.nilable(String)) }
  def default; end

  def default=(_arg0); end

  sig { abstract.returns(T::Array[String]) }
  def fully_qualified_names; end

  sig { returns(String) }
  def name; end

  def name=(_arg0); end
  def type; end
  def type=(_arg0); end
end

class RBI::TStructProp < ::RBI::TStructField
  include ::RBI::Indexable

  sig { params(name: String, type: String, default: T.nilable(String), loc: T.nilable(RBI::Loc), comments: T::Array[RBI::Comment], block: T.nilable(T.proc.params(node: RBI::TStructProp).void)).void }
  def initialize(name, type, default: T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  sig { override.params(other: RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  sig { override.returns(T::Array[String]) }
  def fully_qualified_names; end

  sig { override.returns(T::Array[String]) }
  def index_ids; end

  sig { override.returns(String) }
  def to_s; end
end

class RBI::Tree < ::RBI::NodeWithComments
  sig { params(loc: T.nilable(RBI::Loc), comments: T::Array[RBI::Comment], block: T.nilable(T.proc.params(node: RBI::Tree).void)).void }
  def initialize(loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  sig { params(node: RBI::Node).void }
  def <<(node); end

  sig { override.params(v: RBI::Printer).void }
  def accept_printer(v); end

  sig { params(with_todo_comment: T::Boolean).void }
  def add_sig_templates!(with_todo_comment: T.unsafe(nil)); end

  sig { params(annotation: String, annotate_scopes: T::Boolean, annotate_properties: T::Boolean).void }
  def annotate!(annotation, annotate_scopes: T.unsafe(nil), annotate_properties: T.unsafe(nil)); end

  sig { params(name: String, superclass_name: T.nilable(String), block: T.nilable(T.proc.params(scope: RBI::Scope).void)).returns(RBI::Scope) }
  def create_class(name, superclass_name: T.unsafe(nil), &block); end

  sig { params(name: String, value: String).void }
  def create_constant(name, value:); end

  sig { params(name: String).void }
  def create_extend(name); end

  sig { params(name: String).void }
  def create_include(name); end

  sig { params(name: String, parameters: T::Array[RBI::TypedParam], return_type: String, class_method: T::Boolean, visibility: RBI::Visibility).void }
  def create_method(name, parameters: T.unsafe(nil), return_type: T.unsafe(nil), class_method: T.unsafe(nil), visibility: T.unsafe(nil)); end

  sig { params(name: String).void }
  def create_mixes_in_class_methods(name); end

  sig { params(name: String, block: T.nilable(T.proc.params(scope: RBI::Scope).void)).returns(RBI::Scope) }
  def create_module(name, &block); end

  sig { params(constant: Module, block: T.nilable(T.proc.params(scope: RBI::Scope).void)).void }
  def create_path(constant, &block); end

  sig { params(name: String, value: String).void }
  def create_type_member(name, value: T.unsafe(nil)); end

  sig { params(annotation: String).void }
  def deannotate!(annotation); end

  sig { returns(T::Boolean) }
  def empty?; end

  sig { void }
  def group_nodes!; end

  sig { returns(RBI::Index) }
  def index; end

  sig { params(other: RBI::Tree, left_name: String, right_name: String, keep: RBI::Rewriters::Merge::Keep).returns(RBI::MergeTree) }
  def merge(other, left_name: T.unsafe(nil), right_name: T.unsafe(nil), keep: T.unsafe(nil)); end

  sig { void }
  def nest_non_public_methods!; end

  sig { void }
  def nest_singleton_methods!; end

  sig { returns(T::Array[RBI::Node]) }
  def nodes; end

  sig { override.returns(T::Boolean) }
  def oneline?; end

  sig { void }
  def sort_nodes!; end

  private

  sig { params(node: RBI::Node).returns(RBI::Node) }
  def create_node(node); end

  sig { returns(T::Hash[String, RBI::Node]) }
  def nodes_cache; end

  sig { params(name: String).returns(T::Boolean) }
  def valid_method_name?(name); end
end

RBI::Tree::SPECIAL_METHOD_NAMES = T.let(T.unsafe(nil), Array)

class RBI::TreeBuilder < ::RBI::ASTVisitor
  sig { params(file: String, comments: T::Array[Parser::Source::Comment], nodes_comments_assoc: T::Hash[Parser::Source::Map, T::Array[Parser::Source::Comment]]).void }
  def initialize(file:, comments: T.unsafe(nil), nodes_comments_assoc: T.unsafe(nil)); end

  sig { void }
  def post_process; end

  sig { returns(RBI::Tree) }
  def tree; end

  sig { override.params(node: T.nilable(Object)).void }
  def visit(node); end

  private

  sig { void }
  def assoc_dangling_comments; end

  sig { returns(RBI::Tree) }
  def current_scope; end

  sig { returns(T::Array[RBI::Sig]) }
  def current_sigs; end

  sig { params(node: AST::Node).returns(T::Array[RBI::Comment]) }
  def node_comments(node); end

  sig { params(node: AST::Node).returns(RBI::Loc) }
  def node_loc(node); end

  sig { params(node: AST::Node).returns(T.nilable(RBI::Node)) }
  def parse_block(node); end

  sig { params(node: AST::Node).returns(RBI::Node) }
  def parse_const_assign(node); end

  sig { params(node: AST::Node).returns(RBI::Method) }
  def parse_def(node); end

  sig { params(node: AST::Node).returns(RBI::TEnumBlock) }
  def parse_enum(node); end

  sig { params(node: AST::Node).returns(RBI::Param) }
  def parse_param(node); end

  sig { params(node: AST::Node).returns(RBI::RequiresAncestor) }
  def parse_requires_ancestor(node); end

  sig { params(node: AST::Node).returns(RBI::Scope) }
  def parse_scope(node); end

  sig { params(node: AST::Node).returns(T.nilable(RBI::Node)) }
  def parse_send(node); end

  sig { params(node: AST::Node).returns(T::Array[RBI::Arg]) }
  def parse_send_args(node); end

  sig { params(node: AST::Node).returns(RBI::Sig) }
  def parse_sig(node); end

  sig { params(node: AST::Node).returns(RBI::Struct) }
  def parse_struct(node); end

  sig { params(node: AST::Node).returns([String, String, T.nilable(String)]) }
  def parse_tstruct_prop(node); end

  sig { void }
  def separate_header_comments; end

  sig { void }
  def set_root_tree_loc; end

  sig { params(node: AST::Node).returns(T::Boolean) }
  def struct_definition?(node); end
end

class RBI::TypeMember < ::RBI::NodeWithComments
  sig { params(name: String, value: String, loc: T.nilable(RBI::Loc), comments: T::Array[RBI::Comment], block: T.nilable(T.proc.params(node: RBI::TypeMember).void)).void }
  def initialize(name, value, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  sig { override.params(v: RBI::Printer).void }
  def accept_printer(v); end

  sig { returns(String) }
  def fully_qualified_name; end

  sig { returns(String) }
  def name; end

  sig { override.returns(String) }
  def to_s; end

  def value; end
end

RBI::VERSION = T.let(T.unsafe(nil), String)

class RBI::Visibility < ::RBI::NodeWithComments
  abstract!

  sig { params(visibility: Symbol, loc: T.nilable(RBI::Loc), comments: T::Array[RBI::Comment]).void }
  def initialize(visibility, loc: T.unsafe(nil), comments: T.unsafe(nil)); end

  sig { params(other: RBI::Visibility).returns(T::Boolean) }
  def ==(other); end

  sig { override.params(v: RBI::Printer).void }
  def accept_printer(v); end

  sig { returns(T::Boolean) }
  def private?; end

  sig { returns(T::Boolean) }
  def protected?; end

  sig { returns(T::Boolean) }
  def public?; end

  sig { returns(Symbol) }
  def visibility; end
end

class RBI::VisibilityGroup < ::RBI::Tree
  sig { params(visibility: RBI::Visibility).void }
  def initialize(visibility); end

  sig { override.params(v: RBI::Printer).void }
  def accept_printer(v); end

  sig { override.returns(T::Boolean) }
  def oneline?; end

  sig { returns(RBI::Visibility) }
  def visibility; end
end

class RBI::Visitor
  abstract!

  def initialize(*args, &blk); end

  sig { abstract.params(node: T.nilable(RBI::Node)).void }
  def visit(node); end

  sig { params(nodes: T::Array[RBI::Node]).void }
  def visit_all(nodes); end
end
