# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `concurrent-ruby` gem.
# Please instead update this file by running `bin/tapioca gem concurrent-ruby`.

module Concurrent
  extend ::Concurrent::Utility::EngineDetector
  extend ::Concurrent::Utility::NativeExtensionLoader
  extend ::Logger::Severity
  extend ::Concurrent::Concern::Logging
  extend ::Concurrent::Concern::Deprecation

  private

  def abort_transaction; end
  def atomically; end
  def call_dataflow(method, executor, *inputs, &block); end
  def dataflow(*inputs, &block); end
  def dataflow!(*inputs, &block); end
  def dataflow_with(executor, *inputs, &block); end
  def dataflow_with!(executor, *inputs, &block); end
  def leave_transaction; end
  def monotonic_time; end

  class << self
    def abort_transaction; end
    def atomically; end
    def call_dataflow(method, executor, *inputs, &block); end
    def create_simple_logger(level = T.unsafe(nil), output = T.unsafe(nil)); end
    def create_stdlib_logger(level = T.unsafe(nil), output = T.unsafe(nil)); end
    def dataflow(*inputs, &block); end
    def dataflow!(*inputs, &block); end
    def dataflow_with(executor, *inputs, &block); end
    def dataflow_with!(executor, *inputs, &block); end
    def disable_at_exit_handlers!; end
    def executor(executor_identifier); end
    def global_fast_executor; end
    def global_immediate_executor; end
    def global_io_executor; end
    def global_logger; end
    def global_logger=(value); end
    def global_timer_set; end
    def leave_transaction; end
    def monotonic_time; end
    def new_fast_executor(opts = T.unsafe(nil)); end
    def new_io_executor(opts = T.unsafe(nil)); end
    def physical_processor_count; end
    def processor_count; end
    def processor_counter; end
    def use_simple_logger(level = T.unsafe(nil), output = T.unsafe(nil)); end
    def use_stdlib_logger(level = T.unsafe(nil), output = T.unsafe(nil)); end
  end
end

class Concurrent::AbstractExchanger < ::Concurrent::Synchronization::Object
  def initialize; end

  def exchange(value, timeout = T.unsafe(nil)); end
  def exchange!(value, timeout = T.unsafe(nil)); end
  def try_exchange(value, timeout = T.unsafe(nil)); end

  private

  def do_exchange(value, timeout); end
end

Concurrent::AbstractExchanger::CANCEL = T.let(T.unsafe(nil), Object)

class Concurrent::AbstractExecutorService < ::Concurrent::Synchronization::LockableObject
  include ::Logger::Severity
  include ::Concurrent::Concern::Logging
  include ::Concurrent::ExecutorService
  include ::Concurrent::Concern::Deprecation

  def initialize(opts = T.unsafe(nil), &block); end

  def auto_terminate=(value); end
  def auto_terminate?; end
  def fallback_policy; end
  def kill; end
  def name; end
  def running?; end
  def shutdown; end
  def shutdown?; end
  def shuttingdown?; end
  def to_s; end
  def wait_for_termination(timeout = T.unsafe(nil)); end

  private

  def handle_fallback(*args); end
  def ns_auto_terminate?; end
  def ns_execute(*args, &task); end
  def ns_kill_execution; end
  def ns_shutdown_execution; end
end

Concurrent::AbstractExecutorService::FALLBACK_POLICIES = T.let(T.unsafe(nil), Array)

class Concurrent::AbstractThreadLocalVar
  def initialize(default = T.unsafe(nil), &default_block); end

  def bind(value, &block); end
  def value; end
  def value=(value); end

  protected

  def allocate_storage; end
  def default; end
end

class Concurrent::Agent < ::Concurrent::Synchronization::LockableObject
  include ::Concurrent::Concern::Observable

  def initialize(initial, opts = T.unsafe(nil)); end

  def <<(action); end
  def await; end
  def await_for(timeout); end
  def await_for!(timeout); end
  def deref; end
  def error; end
  def error_mode; end
  def failed?; end
  def post(*args, &action); end
  def reason; end
  def restart(new_value, opts = T.unsafe(nil)); end
  def send(*args, &action); end
  def send!(*args, &action); end
  def send_off(*args, &action); end
  def send_off!(*args, &action); end
  def send_via(executor, *args, &action); end
  def send_via!(executor, *args, &action); end
  def stopped?; end
  def value; end
  def wait(timeout = T.unsafe(nil)); end

  private

  def enqueue_action_job(action, args, executor); end
  def enqueue_await_job(latch); end
  def execute_next_job; end
  def handle_error(error); end
  def ns_enqueue_job(job, index = T.unsafe(nil)); end
  def ns_find_last_job_for_thread; end
  def ns_initialize(initial, opts); end
  def ns_post_next_job; end
  def ns_validate(value); end

  class << self
    def await(*agents); end
    def await_for(timeout, *agents); end
    def await_for!(timeout, *agents); end
  end
end

Concurrent::Agent::AWAIT_ACTION = T.let(T.unsafe(nil), Proc)
Concurrent::Agent::AWAIT_FLAG = T.let(T.unsafe(nil), Object)
Concurrent::Agent::DEFAULT_ERROR_HANDLER = T.let(T.unsafe(nil), Proc)
Concurrent::Agent::DEFAULT_VALIDATOR = T.let(T.unsafe(nil), Proc)
Concurrent::Agent::ERROR_MODES = T.let(T.unsafe(nil), Array)

class Concurrent::Agent::Error < ::StandardError
  def initialize(message = T.unsafe(nil)); end
end

class Concurrent::Agent::Job < ::Struct
  def action; end
  def action=(_); end
  def args; end
  def args=(_); end
  def caller; end
  def caller=(_); end
  def executor; end
  def executor=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def members; end
    def new(*_arg0); end
  end
end

class Concurrent::Agent::ValidationError < ::Concurrent::Agent::Error
  def initialize(message = T.unsafe(nil)); end
end

class Concurrent::Array < ::Array; end
Concurrent::ArrayImplementation = Array

module Concurrent::Async
  mixes_in_class_methods ::Concurrent::Async::ClassMethods

  def async; end
  def await; end
  def call; end
  def cast; end
  def init_synchronization; end

  class << self
    def included(base); end
    def validate_argc(obj, method, *args); end
  end
end

class Concurrent::Async::AsyncDelegator < ::Concurrent::Synchronization::LockableObject
  def initialize(delegate); end

  def method_missing(method, *args, &block); end
  def perform; end
  def reset_if_forked; end

  private

  def respond_to_missing?(method, include_private = T.unsafe(nil)); end
end

class Concurrent::Async::AwaitDelegator
  def initialize(delegate); end

  def method_missing(method, *args, &block); end

  private

  def respond_to_missing?(method, include_private = T.unsafe(nil)); end
end

module Concurrent::Async::ClassMethods
  def new(*args, &block); end
end

class Concurrent::Atom < ::Concurrent::Synchronization::Object
  include ::Concurrent::Concern::Observable

  def initialize(value, opts = T.unsafe(nil)); end

  def __initialize_atomic_fields__; end
  def compare_and_set(old_value, new_value); end
  def deref; end
  def reset(new_value); end
  def swap(*args); end
  def value; end

  private

  def compare_and_set_value(expected, value); end
  def swap_value(value); end
  def update_value(&block); end
  def valid?(new_value); end
  def value=(value); end

  class << self
    def new(*args, &block); end
  end
end

class Concurrent::AtomicBoolean < ::Concurrent::MutexAtomicBoolean
  def inspect; end
  def to_s; end
end

Concurrent::AtomicBooleanImplementation = Concurrent::MutexAtomicBoolean

module Concurrent::AtomicDirectUpdate
  def try_update; end
  def try_update!; end
  def update; end
end

class Concurrent::AtomicFixnum < ::Concurrent::MutexAtomicFixnum
  def inspect; end
  def to_s; end
end

Concurrent::AtomicFixnumImplementation = Concurrent::MutexAtomicFixnum

class Concurrent::AtomicMarkableReference < ::Concurrent::Synchronization::Object
  def initialize(value = T.unsafe(nil), mark = T.unsafe(nil)); end

  def __initialize_atomic_fields__; end
  def compare_and_set(expected_val, new_val, expected_mark, new_mark); end
  def compare_and_swap(expected_val, new_val, expected_mark, new_mark); end
  def get; end
  def mark; end
  def marked?; end
  def set(new_val, new_mark); end
  def try_update; end
  def try_update!; end
  def update; end
  def value; end

  private

  def compare_and_set_reference(expected, value); end
  def immutable_array(*args); end
  def reference; end
  def reference=(value); end
  def swap_reference(value); end
  def update_reference(&block); end

  class << self
    def new(*args, &block); end
  end
end

module Concurrent::AtomicNumericCompareAndSetWrapper
  def compare_and_set(old_value, new_value); end
end

class Concurrent::AtomicReference < ::Concurrent::MutexAtomicReference
  def inspect; end
  def to_s; end
end

Concurrent::AtomicReferenceImplementation = Concurrent::MutexAtomicReference

class Concurrent::CRubySet < ::Set
  def initialize(*args, &block); end

  def &(*args); end
  def +(*args); end
  def -(*args); end
  def <(*args); end
  def <<(*args); end
  def <=(*args); end
  def ==(*args); end
  def ===(*args); end
  def >(*args); end
  def >=(*args); end
  def ^(*args); end
  def add(*args); end
  def add?(*args); end
  def classify(*args); end
  def clear(*args); end
  def collect!(*args); end
  def compare_by_identity(*args); end
  def compare_by_identity?(*args); end
  def delete(*args); end
  def delete?(*args); end
  def delete_if(*args); end
  def difference(*args); end
  def disjoint?(*args); end
  def divide(*args); end
  def each(*args); end
  def empty?(*args); end
  def eql?(*args); end
  def filter!(*args); end
  def flatten(*args); end
  def flatten!(*args); end
  def flatten_merge(*args); end
  def freeze(*args); end
  def hash(*args); end
  def include?(*args); end
  def inspect(*args); end
  def intersect?(*args); end
  def intersection(*args); end
  def keep_if(*args); end
  def length(*args); end
  def map!(*args); end
  def member?(*args); end
  def merge(*args); end
  def pretty_print(*args); end
  def pretty_print_cycle(*args); end
  def proper_subset?(*args); end
  def proper_superset?(*args); end
  def reject!(*args); end
  def replace(*args); end
  def reset(*args); end
  def select!(*args); end
  def size(*args); end
  def subset?(*args); end
  def subtract(*args); end
  def superset?(*args); end
  def to_a(*args); end
  def to_s(*args); end
  def to_set(*args); end
  def union(*args); end
  def |(*args); end

  private

  def initialize_copy(other); end
end

class Concurrent::CachedThreadPool < ::Concurrent::ThreadPoolExecutor
  def initialize(opts = T.unsafe(nil)); end

  private

  def ns_initialize(opts); end
end

class Concurrent::CancelledOperationError < ::Concurrent::Error; end
module Concurrent::Collection; end

class Concurrent::Collection::CopyOnNotifyObserverSet < ::Concurrent::Synchronization::LockableObject
  def initialize; end

  def add_observer(observer = T.unsafe(nil), func = T.unsafe(nil), &block); end
  def count_observers; end
  def delete_observer(observer); end
  def delete_observers; end
  def notify_and_delete_observers(*args, &block); end
  def notify_observers(*args, &block); end

  protected

  def ns_initialize; end

  private

  def duplicate_and_clear_observers; end
  def duplicate_observers; end
  def notify_to(observers, *args); end
end

class Concurrent::Collection::CopyOnWriteObserverSet < ::Concurrent::Synchronization::LockableObject
  def initialize; end

  def add_observer(observer = T.unsafe(nil), func = T.unsafe(nil), &block); end
  def count_observers; end
  def delete_observer(observer); end
  def delete_observers; end
  def notify_and_delete_observers(*args, &block); end
  def notify_observers(*args, &block); end

  protected

  def ns_initialize; end

  private

  def clear_observers_and_return_old; end
  def notify_to(observers, *args); end
  def observers; end
  def observers=(new_set); end
end

Concurrent::Collection::MapImplementation = Concurrent::Collection::MriMapBackend

class Concurrent::Collection::MriMapBackend < ::Concurrent::Collection::NonConcurrentMapBackend
  def initialize(options = T.unsafe(nil)); end

  def []=(key, value); end
  def clear; end
  def compute(key); end
  def compute_if_absent(key); end
  def compute_if_present(key); end
  def delete(key); end
  def delete_pair(key, value); end
  def get_and_set(key, value); end
  def merge_pair(key, value); end
  def replace_if_exists(key, new_value); end
  def replace_pair(key, old_value, new_value); end
end

class Concurrent::Collection::NonConcurrentMapBackend
  def initialize(options = T.unsafe(nil)); end

  def [](key); end
  def []=(key, value); end
  def clear; end
  def compute(key); end
  def compute_if_absent(key); end
  def compute_if_present(key); end
  def delete(key); end
  def delete_pair(key, value); end
  def each_pair; end
  def get_and_set(key, value); end
  def get_or_default(key, default_value); end
  def key?(key); end
  def merge_pair(key, value); end
  def replace_if_exists(key, new_value); end
  def replace_pair(key, old_value, new_value); end
  def size; end

  private

  def _get(key); end
  def _set(key, value); end
  def dupped_backend; end
  def initialize_copy(other); end
  def pair?(key, expected_value); end
  def store_computed_value(key, new_value); end
end

class Concurrent::Collection::NonConcurrentPriorityQueue < ::Concurrent::Collection::RubyNonConcurrentPriorityQueue
  def <<(item); end
  def deq; end
  def enq(item); end
  def has_priority?(item); end
  def shift; end
  def size; end
end

Concurrent::Collection::NonConcurrentPriorityQueueImplementation = Concurrent::Collection::RubyNonConcurrentPriorityQueue

class Concurrent::Collection::RubyNonConcurrentPriorityQueue
  def initialize(opts = T.unsafe(nil)); end

  def <<(item); end
  def clear; end
  def delete(item); end
  def deq; end
  def empty?; end
  def enq(item); end
  def has_priority?(item); end
  def include?(item); end
  def length; end
  def peek; end
  def pop; end
  def push(item); end
  def shift; end
  def size; end

  private

  def ordered?(x, y); end
  def sink(k); end
  def swap(x, y); end
  def swim(k); end

  class << self
    def from_list(list, opts = T.unsafe(nil)); end
  end
end

module Concurrent::Concern; end

module Concurrent::Concern::Deprecation
  include ::Logger::Severity
  include ::Concurrent::Concern::Logging
  extend ::Logger::Severity
  extend ::Concurrent::Concern::Logging
  extend ::Concurrent::Concern::Deprecation

  def deprecated(message, strip = T.unsafe(nil)); end
  def deprecated_method(old_name, new_name); end
end

module Concurrent::Concern::Dereferenceable
  def deref; end
  def value; end

  protected

  def apply_deref_options(value); end
  def ns_set_deref_options(opts); end
  def set_deref_options(opts = T.unsafe(nil)); end
  def value=(value); end
end

module Concurrent::Concern::Logging
  include ::Logger::Severity

  def log(level, progname, message = T.unsafe(nil), &block); end
end

module Concurrent::Concern::Obligation
  include ::Concurrent::Concern::Dereferenceable

  def complete?; end
  def exception(*args); end
  def fulfilled?; end
  def incomplete?; end
  def no_error!(timeout = T.unsafe(nil)); end
  def pending?; end
  def realized?; end
  def reason; end
  def rejected?; end
  def state; end
  def unscheduled?; end
  def value(timeout = T.unsafe(nil)); end
  def value!(timeout = T.unsafe(nil)); end
  def wait(timeout = T.unsafe(nil)); end
  def wait!(timeout = T.unsafe(nil)); end

  protected

  def compare_and_set_state(next_state, *expected_current); end
  def event; end
  def get_arguments_from(opts = T.unsafe(nil)); end
  def if_state(*expected_states); end
  def init_obligation; end
  def ns_check_state?(expected); end
  def ns_set_state(value); end
  def set_state(success, value, reason); end
  def state=(value); end
end

module Concurrent::Concern::Observable
  def add_observer(observer = T.unsafe(nil), func = T.unsafe(nil), &block); end
  def count_observers; end
  def delete_observer(observer); end
  def delete_observers; end
  def with_observer(observer = T.unsafe(nil), func = T.unsafe(nil), &block); end

  protected

  def observers; end
  def observers=(_arg0); end
end

class Concurrent::ConcurrentUpdateError < ::ThreadError; end
Concurrent::ConcurrentUpdateError::CONC_UP_ERR_BACKTRACE = T.let(T.unsafe(nil), Array)
class Concurrent::ConfigurationError < ::Concurrent::Error; end
class Concurrent::CountDownLatch < ::Concurrent::MutexCountDownLatch; end
Concurrent::CountDownLatchImplementation = Concurrent::MutexCountDownLatch

class Concurrent::CyclicBarrier < ::Concurrent::Synchronization::LockableObject
  def initialize(parties, &block); end

  def broken?; end
  def number_waiting; end
  def parties; end
  def reset; end
  def wait(timeout = T.unsafe(nil)); end

  protected

  def ns_generation_done(generation, status, continue = T.unsafe(nil)); end
  def ns_initialize(parties, &block); end
  def ns_next_generation; end
end

class Concurrent::CyclicBarrier::Generation < ::Struct
  def status; end
  def status=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def members; end
    def new(*_arg0); end
  end
end

class Concurrent::Delay < ::Concurrent::Synchronization::LockableObject
  include ::Concurrent::Concern::Dereferenceable
  include ::Concurrent::Concern::Obligation

  def initialize(opts = T.unsafe(nil), &block); end

  def reconfigure(&block); end
  def value(timeout = T.unsafe(nil)); end
  def value!(timeout = T.unsafe(nil)); end
  def wait(timeout = T.unsafe(nil)); end

  protected

  def ns_initialize(opts, &block); end

  private

  def execute_task_once; end
end

class Concurrent::DependencyCounter
  def initialize(count, &block); end

  def update(time, value, reason); end
end

class Concurrent::Error < ::StandardError; end

class Concurrent::Event < ::Concurrent::Synchronization::LockableObject
  def initialize; end

  def reset; end
  def set; end
  def set?; end
  def try?; end
  def wait(timeout = T.unsafe(nil)); end

  protected

  def ns_initialize; end
  def ns_set; end
end

class Concurrent::Exchanger < ::Concurrent::RubyExchanger; end
Concurrent::ExchangerImplementation = Concurrent::RubyExchanger

module Concurrent::ExecutorService
  include ::Logger::Severity
  include ::Concurrent::Concern::Logging

  def <<(task); end
  def can_overflow?; end
  def post(*args, &task); end
  def serialized?; end
end

class Concurrent::FixedThreadPool < ::Concurrent::ThreadPoolExecutor
  def initialize(num_threads, opts = T.unsafe(nil)); end
end

class Concurrent::Future < ::Concurrent::IVar
  def initialize(opts = T.unsafe(nil), &block); end

  def cancel; end
  def cancelled?; end
  def execute; end
  def set(value = T.unsafe(nil), &block); end
  def wait_or_cancel(timeout); end

  protected

  def ns_initialize(value, opts); end

  class << self
    def execute(opts = T.unsafe(nil), &block); end
  end
end

Concurrent::GLOBAL_FAST_EXECUTOR = T.let(T.unsafe(nil), Concurrent::Delay)
Concurrent::GLOBAL_IMMEDIATE_EXECUTOR = T.let(T.unsafe(nil), Concurrent::ImmediateExecutor)
Concurrent::GLOBAL_IO_EXECUTOR = T.let(T.unsafe(nil), Concurrent::Delay)
Concurrent::GLOBAL_LOGGER = T.let(T.unsafe(nil), Concurrent::AtomicReference)
Concurrent::GLOBAL_MONOTONIC_CLOCK = T.let(T.unsafe(nil), T.untyped)
Concurrent::GLOBAL_TIMER_SET = T.let(T.unsafe(nil), Concurrent::Delay)
class Concurrent::Hash < ::Hash; end
Concurrent::HashImplementation = Hash

class Concurrent::IVar < ::Concurrent::Synchronization::LockableObject
  include ::Concurrent::Concern::Dereferenceable
  include ::Concurrent::Concern::Obligation
  include ::Concurrent::Concern::Observable

  def initialize(value = T.unsafe(nil), opts = T.unsafe(nil), &block); end

  def add_observer(observer = T.unsafe(nil), func = T.unsafe(nil), &block); end
  def fail(reason = T.unsafe(nil)); end
  def set(value = T.unsafe(nil)); end
  def try_set(value = T.unsafe(nil), &block); end

  protected

  def check_for_block_or_value!(block_given, value); end
  def complete(success, value, reason); end
  def complete_without_notification(success, value, reason); end
  def notify_observers(value, reason); end
  def ns_complete_without_notification(success, value, reason); end
  def ns_initialize(value, opts); end
  def safe_execute(task, args = T.unsafe(nil)); end
end

class Concurrent::IllegalOperationError < ::Concurrent::Error; end

class Concurrent::ImmediateExecutor < ::Concurrent::AbstractExecutorService
  include ::Concurrent::SerialExecutorService

  def initialize; end

  def <<(task); end
  def kill; end
  def post(*args, &task); end
  def running?; end
  def shutdown; end
  def shutdown?; end
  def shuttingdown?; end
  def wait_for_termination(timeout = T.unsafe(nil)); end
end

class Concurrent::ImmutabilityError < ::Concurrent::Error; end

module Concurrent::ImmutableStruct
  include ::Concurrent::Synchronization::AbstractStruct

  def ==(other); end
  def [](member); end
  def each(&block); end
  def each_pair(&block); end
  def inspect; end
  def merge(other, &block); end
  def select(&block); end
  def to_a; end
  def to_h; end
  def to_s; end
  def values; end
  def values_at(*indexes); end

  private

  def initialize_copy(original); end

  class << self
    def included(base); end
    def new(*args, &block); end
  end
end

Concurrent::ImmutableStruct::FACTORY = T.let(T.unsafe(nil), T.untyped)

class Concurrent::IndirectImmediateExecutor < ::Concurrent::ImmediateExecutor
  def initialize; end

  def post(*args, &task); end
end

class Concurrent::InitializationError < ::Concurrent::Error; end
class Concurrent::LifecycleError < ::Concurrent::Error; end

class Concurrent::LockFreeStack < ::Concurrent::Synchronization::Object
  include ::Enumerable

  def initialize(head = T.unsafe(nil)); end

  def __initialize_atomic_fields__; end
  def clear; end
  def clear_each(&block); end
  def clear_if(head); end
  def compare_and_clear(head); end
  def compare_and_pop(head); end
  def compare_and_push(head, value); end
  def each(head = T.unsafe(nil)); end
  def empty?(head = T.unsafe(nil)); end
  def inspect; end
  def peek; end
  def pop; end
  def push(value); end
  def replace_if(head, new_head); end
  def to_s; end

  private

  def compare_and_set_head(expected, value); end
  def head; end
  def head=(value); end
  def swap_head(value); end
  def update_head(&block); end

  class << self
    def new(*args, &block); end
    def of1(value); end
    def of2(value1, value2); end
  end
end

Concurrent::LockFreeStack::EMPTY = T.let(T.unsafe(nil), Concurrent::LockFreeStack::Node)

class Concurrent::LockFreeStack::Node
  def initialize(value, next_node); end

  def next_node; end
  def value; end
  def value=(_arg0); end

  class << self
    def [](*_arg0); end
  end
end

class Concurrent::MVar < ::Concurrent::Synchronization::Object
  include ::Concurrent::Concern::Dereferenceable

  def initialize(value = T.unsafe(nil), opts = T.unsafe(nil)); end

  def borrow(timeout = T.unsafe(nil)); end
  def empty?; end
  def full?; end
  def modify(timeout = T.unsafe(nil)); end
  def modify!; end
  def put(value, timeout = T.unsafe(nil)); end
  def set!(value); end
  def take(timeout = T.unsafe(nil)); end
  def try_put!(value); end
  def try_take!; end

  protected

  def synchronize(&block); end

  private

  def unlocked_empty?; end
  def unlocked_full?; end
  def wait_for_empty(timeout); end
  def wait_for_full(timeout); end
  def wait_while(condition, timeout); end

  class << self
    def new(*args, &block); end
  end
end

Concurrent::MVar::EMPTY = T.let(T.unsafe(nil), Object)
Concurrent::MVar::TIMEOUT = T.let(T.unsafe(nil), Object)

class Concurrent::Map < ::Concurrent::Collection::MriMapBackend
  def initialize(options = T.unsafe(nil), &block); end

  def [](key); end
  def []=(key, value); end
  def each; end
  def each_key; end
  def each_pair; end
  def each_value; end
  def empty?; end
  def fetch(key, default_value = T.unsafe(nil)); end
  def fetch_or_store(key, default_value = T.unsafe(nil)); end
  def get(key); end
  def inspect; end
  def key(value); end
  def keys; end
  def marshal_dump; end
  def marshal_load(hash); end
  def put(key, value); end
  def put_if_absent(key, value); end
  def value?(value); end
  def values; end

  private

  def initialize_copy(other); end
  def populate_from(hash); end
  def raise_fetch_no_key; end
  def validate_options_hash!(options); end
end

class Concurrent::MaxRestartFrequencyError < ::Concurrent::Error; end

class Concurrent::Maybe < ::Concurrent::Synchronization::Object
  include ::Comparable

  def initialize(just, nothing); end

  def <=>(other); end
  def fulfilled?; end
  def just; end
  def just?; end
  def nothing; end
  def nothing?; end
  def or(other); end
  def reason; end
  def rejected?; end
  def value; end

  class << self
    def from(*args); end
    def just(value); end
    def nothing(error = T.unsafe(nil)); end

    private

    def new(*args, &block); end
  end
end

Concurrent::Maybe::NONE = T.let(T.unsafe(nil), Object)

class Concurrent::MultipleAssignmentError < ::Concurrent::Error
  def initialize(message = T.unsafe(nil), inspection_data = T.unsafe(nil)); end

  def inspect; end
  def inspection_data; end
end

class Concurrent::MultipleErrors < ::Concurrent::Error
  def initialize(errors, message = T.unsafe(nil)); end

  def errors; end
end

module Concurrent::MutableStruct
  include ::Concurrent::Synchronization::AbstractStruct

  def ==(other); end
  def [](member); end
  def []=(member, value); end
  def each(&block); end
  def each_pair(&block); end
  def inspect; end
  def merge(other, &block); end
  def select(&block); end
  def to_a; end
  def to_h; end
  def to_s; end
  def values; end
  def values_at(*indexes); end

  private

  def initialize_copy(original); end

  class << self
    def new(*args, &block); end
  end
end

Concurrent::MutableStruct::FACTORY = T.let(T.unsafe(nil), T.untyped)

class Concurrent::MutexAtomicBoolean < ::Concurrent::Synchronization::LockableObject
  def initialize(initial = T.unsafe(nil)); end

  def false?; end
  def make_false; end
  def make_true; end
  def true?; end
  def value; end
  def value=(value); end

  protected

  def ns_initialize(initial); end

  private

  def ns_make_value(value); end
end

class Concurrent::MutexAtomicFixnum < ::Concurrent::Synchronization::LockableObject
  def initialize(initial = T.unsafe(nil)); end

  def compare_and_set(expect, update); end
  def decrement(delta = T.unsafe(nil)); end
  def down(delta = T.unsafe(nil)); end
  def increment(delta = T.unsafe(nil)); end
  def up(delta = T.unsafe(nil)); end
  def update; end
  def value; end
  def value=(value); end

  protected

  def ns_initialize(initial); end

  private

  def ns_set(value); end
end

class Concurrent::MutexAtomicReference < ::Concurrent::Synchronization::LockableObject
  include ::Concurrent::AtomicDirectUpdate
  include ::Concurrent::AtomicNumericCompareAndSetWrapper

  def initialize(value = T.unsafe(nil)); end

  def _compare_and_set(old_value, new_value); end
  def compare_and_swap(old_value, new_value); end
  def get; end
  def get_and_set(new_value); end
  def set(new_value); end
  def swap(new_value); end
  def value; end
  def value=(new_value); end

  protected

  def ns_initialize(value); end
end

class Concurrent::MutexCountDownLatch < ::Concurrent::Synchronization::LockableObject
  def initialize(count = T.unsafe(nil)); end

  def count; end
  def count_down; end
  def wait(timeout = T.unsafe(nil)); end

  protected

  def ns_initialize(count); end
end

class Concurrent::MutexSemaphore < ::Concurrent::Synchronization::LockableObject
  def initialize(count); end

  def acquire(permits = T.unsafe(nil)); end
  def available_permits; end
  def drain_permits; end
  def reduce_permits(reduction); end
  def release(permits = T.unsafe(nil)); end
  def try_acquire(permits = T.unsafe(nil), timeout = T.unsafe(nil)); end

  protected

  def ns_initialize(count); end

  private

  def try_acquire_now(permits); end
  def try_acquire_timed(permits, timeout); end
end

Concurrent::NULL = T.let(T.unsafe(nil), Object)
Concurrent::NULL_LOGGER = T.let(T.unsafe(nil), Proc)

module Concurrent::Options
  class << self
    def executor(executor_identifier); end
    def executor_from_options(opts = T.unsafe(nil)); end
  end
end

class Concurrent::Promise < ::Concurrent::IVar
  def initialize(opts = T.unsafe(nil), &block); end

  def catch(&block); end
  def execute; end
  def fail(reason = T.unsafe(nil)); end
  def flat_map(&block); end
  def on_error(&block); end
  def on_success(&block); end
  def rescue(&block); end
  def set(value = T.unsafe(nil), &block); end
  def then(*args, &block); end
  def zip(*others); end

  protected

  def complete(success, value, reason); end
  def notify_child(child); end
  def ns_initialize(value, opts); end
  def on_fulfill(result); end
  def on_reject(reason); end
  def realize(task); end
  def root?; end
  def set_pending; end
  def set_state!(success, value, reason); end
  def synchronized_set_state!(success, value, reason); end

  class << self
    def aggregate(method, *promises); end
    def all?(*promises); end
    def any?(*promises); end
    def execute(opts = T.unsafe(nil), &block); end
    def fulfill(value, opts = T.unsafe(nil)); end
    def reject(reason, opts = T.unsafe(nil)); end
    def zip(*promises); end
  end
end

class Concurrent::PromiseExecutionError < ::StandardError; end

module Concurrent::Promises
  extend ::Concurrent::Promises::FactoryMethods::Configuration
  extend ::Concurrent::Promises::FactoryMethods
end

class Concurrent::Promises::AbstractAnyPromise < ::Concurrent::Promises::BlockedPromise; end

class Concurrent::Promises::AbstractEventFuture < ::Concurrent::Synchronization::Object
  include ::Concurrent::Promises::InternalStates

  def initialize(promise, default_executor); end

  def __initialize_atomic_fields__; end
  def add_callback_clear_delayed_node(node); end
  def add_callback_notify_blocked(promise, index); end
  def blocks; end
  def callbacks; end
  def chain(*args, &task); end
  def chain_on(executor, *args, &task); end
  def chain_resolvable(resolvable); end
  def default_executor; end
  def inspect; end
  def internal_state; end
  def on_resolution(*args, &callback); end
  def on_resolution!(*args, &callback); end
  def on_resolution_using(executor, *args, &callback); end
  def pending?; end
  def promise; end
  def resolve_with(state, raise_on_reassign = T.unsafe(nil), reserved = T.unsafe(nil)); end
  def resolved?; end
  def state; end
  def tangle(resolvable); end
  def to_s; end
  def touch; end
  def touched?; end
  def wait(timeout = T.unsafe(nil)); end
  def waiting_threads; end
  def with_default_executor(executor); end
  def with_hidden_resolvable; end

  private

  def add_callback(method, *args); end
  def async_callback_on_resolution(state, executor, args, callback); end
  def call_callback(method, state, args); end
  def call_callbacks(state); end
  def callback_clear_delayed_node(state, node); end
  def callback_notify_blocked(state, promise, index); end
  def compare_and_set_internal_state(expected, value); end
  def internal_state=(value); end
  def swap_internal_state(value); end
  def update_internal_state(&block); end
  def wait_until_resolved(timeout); end
  def with_async(executor, *args, &block); end

  class << self
    def new(*args, &block); end
  end
end

class Concurrent::Promises::AbstractFlatPromise < ::Concurrent::Promises::BlockedPromise
  def initialize(delayed_because, blockers_count, event_or_future); end

  def touch; end

  private

  def add_delayed_of(future); end
  def on_resolvable(resolved_future, index); end
  def resolvable?(countdown, future, index); end
  def touched?; end
end

class Concurrent::Promises::AbstractPromise < ::Concurrent::Synchronization::Object
  include ::Concurrent::Promises::InternalStates

  def initialize(future); end

  def default_executor; end
  def delayed_because; end
  def event; end
  def future; end
  def inspect; end
  def state; end
  def to_s; end
  def touch; end

  private

  def evaluate_to(*args, block); end
  def resolve_with(new_state, raise_on_reassign = T.unsafe(nil)); end

  class << self
    def new(*args, &block); end
  end
end

class Concurrent::Promises::AnyFulfilledFuturePromise < ::Concurrent::Promises::AnyResolvedFuturePromise
  private

  def resolvable?(countdown, future, index); end
end

class Concurrent::Promises::AnyResolvedEventPromise < ::Concurrent::Promises::AbstractAnyPromise
  def initialize(delayed, blockers_count, default_executor); end

  private

  def on_resolvable(resolved_future, index); end
  def resolvable?(countdown, future, index); end
end

class Concurrent::Promises::AnyResolvedFuturePromise < ::Concurrent::Promises::AbstractAnyPromise
  def initialize(delayed, blockers_count, default_executor); end

  private

  def on_resolvable(resolved_future, index); end
  def resolvable?(countdown, future, index); end
end

class Concurrent::Promises::BlockedPromise < ::Concurrent::Promises::InnerPromise
  def initialize(delayed, blockers_count, future); end

  def blocked_by; end
  def delayed_because; end
  def on_blocker_resolution(future, index); end
  def touch; end

  private

  def clear_and_propagate_touch(stack_or_element = T.unsafe(nil)); end
  def on_resolvable(resolved_future, index); end
  def process_on_blocker_resolution(future, index); end
  def resolvable?(countdown, future, index); end

  class << self
    def add_delayed(delayed1, delayed2); end
    def new_blocked_by(blockers, *args, &block); end
    def new_blocked_by1(blocker, *args, &block); end
    def new_blocked_by2(blocker1, blocker2, *args, &block); end
  end
end

class Concurrent::Promises::BlockedTaskPromise < ::Concurrent::Promises::BlockedPromise
  def initialize(delayed, blockers_count, default_executor, executor, args, &task); end

  def executor; end
end

class Concurrent::Promises::ChainPromise < ::Concurrent::Promises::BlockedTaskPromise
  private

  def on_resolvable(resolved_future, index); end
end

class Concurrent::Promises::DelayPromise < ::Concurrent::Promises::InnerPromise
  def initialize(default_executor); end

  def delayed_because; end
  def touch; end
end

class Concurrent::Promises::Event < ::Concurrent::Promises::AbstractEventFuture
  def &(other); end
  def any(event_or_future); end
  def delay; end
  def schedule(intended_time); end
  def then(*args, &task); end
  def to_event; end
  def to_future; end
  def with_default_executor(executor); end
  def zip(other); end
  def |(event_or_future); end

  private

  def callback_on_resolution(state, args, callback); end
  def rejected_resolution(raise_on_reassign, state); end
end

class Concurrent::Promises::EventWrapperPromise < ::Concurrent::Promises::BlockedPromise
  def initialize(delayed, blockers_count, default_executor); end

  private

  def on_resolvable(resolved_future, index); end
end

module Concurrent::Promises::FactoryMethods
  include ::Concurrent::Promises::FactoryMethods::Configuration
  extend ::Concurrent::ReInclude
  extend ::Concurrent::Promises::FactoryMethods
  extend ::Concurrent::Promises::FactoryMethods::Configuration

  def any(*futures_and_or_events); end
  def any_event(*futures_and_or_events); end
  def any_event_on(default_executor, *futures_and_or_events); end
  def any_fulfilled_future(*futures_and_or_events); end
  def any_fulfilled_future_on(default_executor, *futures_and_or_events); end
  def any_resolved_future(*futures_and_or_events); end
  def any_resolved_future_on(default_executor, *futures_and_or_events); end
  def delay(*args, &task); end
  def delay_on(default_executor, *args, &task); end
  def fulfilled_future(value, default_executor = T.unsafe(nil)); end
  def future(*args, &task); end
  def future_on(default_executor, *args, &task); end
  def make_future(argument = T.unsafe(nil), default_executor = T.unsafe(nil)); end
  def rejected_future(reason, default_executor = T.unsafe(nil)); end
  def resolvable_event; end
  def resolvable_event_on(default_executor = T.unsafe(nil)); end
  def resolvable_future; end
  def resolvable_future_on(default_executor = T.unsafe(nil)); end
  def resolved_event(default_executor = T.unsafe(nil)); end
  def resolved_future(fulfilled, value, reason, default_executor = T.unsafe(nil)); end
  def schedule(intended_time, *args, &task); end
  def schedule_on(default_executor, intended_time, *args, &task); end
  def zip(*futures_and_or_events); end
  def zip_events(*futures_and_or_events); end
  def zip_events_on(default_executor, *futures_and_or_events); end
  def zip_futures(*futures_and_or_events); end
  def zip_futures_on(default_executor, *futures_and_or_events); end
end

module Concurrent::Promises::FactoryMethods::Configuration
  def default_executor; end
end

class Concurrent::Promises::FlatEventPromise < ::Concurrent::Promises::AbstractFlatPromise
  def initialize(delayed, blockers_count, default_executor); end

  private

  def process_on_blocker_resolution(future, index); end
end

class Concurrent::Promises::FlatFuturePromise < ::Concurrent::Promises::AbstractFlatPromise
  def initialize(delayed, blockers_count, levels, default_executor); end

  private

  def process_on_blocker_resolution(future, index); end
end

class Concurrent::Promises::Future < ::Concurrent::Promises::AbstractEventFuture
  def &(other); end
  def any(event_or_future); end
  def apply(args, block); end
  def delay; end
  def exception(*args); end
  def flat(level = T.unsafe(nil)); end
  def flat_event; end
  def flat_future(level = T.unsafe(nil)); end
  def fulfilled?; end
  def inspect; end
  def on_fulfillment(*args, &callback); end
  def on_fulfillment!(*args, &callback); end
  def on_fulfillment_using(executor, *args, &callback); end
  def on_rejection(*args, &callback); end
  def on_rejection!(*args, &callback); end
  def on_rejection_using(executor, *args, &callback); end
  def reason(timeout = T.unsafe(nil), timeout_value = T.unsafe(nil)); end
  def rejected?; end
  def rescue(*args, &task); end
  def rescue_on(executor, *args, &task); end
  def result(timeout = T.unsafe(nil)); end
  def run(run_test = T.unsafe(nil)); end
  def schedule(intended_time); end
  def then(*args, &task); end
  def then_on(executor, *args, &task); end
  def to_event; end
  def to_future; end
  def to_s; end
  def value(timeout = T.unsafe(nil), timeout_value = T.unsafe(nil)); end
  def value!(timeout = T.unsafe(nil), timeout_value = T.unsafe(nil)); end
  def wait!(timeout = T.unsafe(nil)); end
  def with_default_executor(executor); end
  def zip(other); end
  def |(event_or_future); end

  private

  def async_callback_on_fulfillment(state, executor, args, callback); end
  def async_callback_on_rejection(state, executor, args, callback); end
  def callback_on_fulfillment(state, args, callback); end
  def callback_on_rejection(state, args, callback); end
  def callback_on_resolution(state, args, callback); end
  def rejected_resolution(raise_on_reassign, state); end
  def run_test(v); end
  def wait_until_resolved!(timeout = T.unsafe(nil)); end
end

class Concurrent::Promises::FutureWrapperPromise < ::Concurrent::Promises::BlockedPromise
  def initialize(delayed, blockers_count, default_executor); end

  private

  def on_resolvable(resolved_future, index); end
end

class Concurrent::Promises::ImmediateEventPromise < ::Concurrent::Promises::InnerPromise
  def initialize(default_executor); end
end

class Concurrent::Promises::ImmediateFuturePromise < ::Concurrent::Promises::InnerPromise
  def initialize(default_executor, fulfilled, value, reason); end
end

class Concurrent::Promises::InnerPromise < ::Concurrent::Promises::AbstractPromise; end
module Concurrent::Promises::InternalStates; end

class Concurrent::Promises::InternalStates::Fulfilled < ::Concurrent::Promises::InternalStates::ResolvedWithResult
  def initialize(value); end

  def apply(args, block); end
  def fulfilled?; end
  def reason; end
  def to_sym; end
  def value; end
end

class Concurrent::Promises::InternalStates::FulfilledArray < ::Concurrent::Promises::InternalStates::Fulfilled
  def apply(args, block); end
end

Concurrent::Promises::InternalStates::PENDING = T.let(T.unsafe(nil), Concurrent::Promises::InternalStates::Pending)

class Concurrent::Promises::InternalStates::PartiallyRejected < ::Concurrent::Promises::InternalStates::ResolvedWithResult
  def initialize(value, reason); end

  def apply(args, block); end
  def fulfilled?; end
  def reason; end
  def to_sym; end
  def value; end
end

class Concurrent::Promises::InternalStates::Pending < ::Concurrent::Promises::InternalStates::State
  def resolved?; end
  def to_sym; end
end

Concurrent::Promises::InternalStates::RESERVED = T.let(T.unsafe(nil), Concurrent::Promises::InternalStates::Reserved)
Concurrent::Promises::InternalStates::RESOLVED = T.let(T.unsafe(nil), Concurrent::Promises::InternalStates::Fulfilled)

class Concurrent::Promises::InternalStates::Rejected < ::Concurrent::Promises::InternalStates::ResolvedWithResult
  def initialize(reason); end

  def apply(args, block); end
  def fulfilled?; end
  def reason; end
  def to_sym; end
  def value; end
end

class Concurrent::Promises::InternalStates::Reserved < ::Concurrent::Promises::InternalStates::Pending; end

class Concurrent::Promises::InternalStates::ResolvedWithResult < ::Concurrent::Promises::InternalStates::State
  def apply; end
  def fulfilled?; end
  def reason; end
  def resolved?; end
  def result; end
  def to_sym; end
  def value; end
end

class Concurrent::Promises::InternalStates::State
  def resolved?; end
  def to_sym; end
end

class Concurrent::Promises::RescuePromise < ::Concurrent::Promises::BlockedTaskPromise
  def initialize(delayed, blockers_count, default_executor, executor, args, &task); end

  private

  def on_resolvable(resolved_future, index); end
end

module Concurrent::Promises::Resolvable
  include ::Concurrent::Promises::InternalStates
end

class Concurrent::Promises::ResolvableEvent < ::Concurrent::Promises::Event
  include ::Concurrent::Promises::Resolvable

  def resolve(raise_on_reassign = T.unsafe(nil), reserved = T.unsafe(nil)); end
  def wait(timeout = T.unsafe(nil), resolve_on_timeout = T.unsafe(nil)); end
  def with_hidden_resolvable; end
end

class Concurrent::Promises::ResolvableEventPromise < ::Concurrent::Promises::AbstractPromise
  def initialize(default_executor); end
end

class Concurrent::Promises::ResolvableFuture < ::Concurrent::Promises::Future
  include ::Concurrent::Promises::Resolvable

  def evaluate_to(*args, &block); end
  def evaluate_to!(*args, &block); end
  def fulfill(value, raise_on_reassign = T.unsafe(nil), reserved = T.unsafe(nil)); end
  def reason(timeout = T.unsafe(nil), timeout_value = T.unsafe(nil), resolve_on_timeout = T.unsafe(nil)); end
  def reject(reason, raise_on_reassign = T.unsafe(nil), reserved = T.unsafe(nil)); end
  def resolve(fulfilled = T.unsafe(nil), value = T.unsafe(nil), reason = T.unsafe(nil), raise_on_reassign = T.unsafe(nil), reserved = T.unsafe(nil)); end
  def result(timeout = T.unsafe(nil), resolve_on_timeout = T.unsafe(nil)); end
  def value(timeout = T.unsafe(nil), timeout_value = T.unsafe(nil), resolve_on_timeout = T.unsafe(nil)); end
  def value!(timeout = T.unsafe(nil), timeout_value = T.unsafe(nil), resolve_on_timeout = T.unsafe(nil)); end
  def wait(timeout = T.unsafe(nil), resolve_on_timeout = T.unsafe(nil)); end
  def wait!(timeout = T.unsafe(nil), resolve_on_timeout = T.unsafe(nil)); end
  def with_hidden_resolvable; end
end

class Concurrent::Promises::ResolvableFuturePromise < ::Concurrent::Promises::AbstractPromise
  def initialize(default_executor); end
end

class Concurrent::Promises::RunFuturePromise < ::Concurrent::Promises::AbstractFlatPromise
  def initialize(delayed, blockers_count, default_executor, run_test); end

  private

  def process_on_blocker_resolution(future, index); end
end

class Concurrent::Promises::ScheduledPromise < ::Concurrent::Promises::InnerPromise
  def initialize(default_executor, intended_time); end

  def inspect; end
  def intended_time; end
end

class Concurrent::Promises::ThenPromise < ::Concurrent::Promises::BlockedTaskPromise
  def initialize(delayed, blockers_count, default_executor, executor, args, &task); end

  private

  def on_resolvable(resolved_future, index); end
end

class Concurrent::Promises::ZipEventEventPromise < ::Concurrent::Promises::BlockedPromise
  def initialize(delayed, blockers_count, default_executor); end

  private

  def on_resolvable(resolved_future, index); end
end

class Concurrent::Promises::ZipEventsPromise < ::Concurrent::Promises::BlockedPromise
  def initialize(delayed, blockers_count, default_executor); end

  private

  def on_resolvable(resolved_future, index); end
end

class Concurrent::Promises::ZipFutureEventPromise < ::Concurrent::Promises::BlockedPromise
  def initialize(delayed, blockers_count, default_executor); end

  private

  def on_resolvable(resolved_future, index); end
  def process_on_blocker_resolution(future, index); end
end

class Concurrent::Promises::ZipFuturesPromise < ::Concurrent::Promises::BlockedPromise
  def initialize(delayed, blockers_count, default_executor); end

  private

  def on_resolvable(resolved_future, index); end
  def process_on_blocker_resolution(future, index); end
end

module Concurrent::ReInclude
  def extended(base); end
  def include(*modules); end
  def included(base); end
end

class Concurrent::ReadWriteLock < ::Concurrent::Synchronization::Object
  def initialize; end

  def acquire_read_lock; end
  def acquire_write_lock; end
  def has_waiters?; end
  def release_read_lock; end
  def release_write_lock; end
  def with_read_lock; end
  def with_write_lock; end
  def write_locked?; end

  private

  def max_readers?(c = T.unsafe(nil)); end
  def max_writers?(c = T.unsafe(nil)); end
  def running_readers(c = T.unsafe(nil)); end
  def running_readers?(c = T.unsafe(nil)); end
  def running_writer?(c = T.unsafe(nil)); end
  def waiting_writer?(c = T.unsafe(nil)); end
  def waiting_writers(c = T.unsafe(nil)); end

  class << self
    def new(*args, &block); end
  end
end

Concurrent::ReadWriteLock::MAX_READERS = T.let(T.unsafe(nil), Integer)
Concurrent::ReadWriteLock::MAX_WRITERS = T.let(T.unsafe(nil), Integer)
Concurrent::ReadWriteLock::RUNNING_WRITER = T.let(T.unsafe(nil), Integer)
Concurrent::ReadWriteLock::WAITING_WRITER = T.let(T.unsafe(nil), Integer)

class Concurrent::ReentrantReadWriteLock < ::Concurrent::Synchronization::Object
  def initialize; end

  def acquire_read_lock; end
  def acquire_write_lock; end
  def release_read_lock; end
  def release_write_lock; end
  def try_read_lock; end
  def try_write_lock; end
  def with_read_lock; end
  def with_write_lock; end

  private

  def max_readers?(c = T.unsafe(nil)); end
  def max_writers?(c = T.unsafe(nil)); end
  def running_readers(c = T.unsafe(nil)); end
  def running_readers?(c = T.unsafe(nil)); end
  def running_writer?(c = T.unsafe(nil)); end
  def waiting_or_running_writer?(c = T.unsafe(nil)); end
  def waiting_writers(c = T.unsafe(nil)); end

  class << self
    def new(*args, &block); end
  end
end

Concurrent::ReentrantReadWriteLock::MAX_READERS = T.let(T.unsafe(nil), Integer)
Concurrent::ReentrantReadWriteLock::MAX_WRITERS = T.let(T.unsafe(nil), Integer)
Concurrent::ReentrantReadWriteLock::READER_BITS = T.let(T.unsafe(nil), Integer)
Concurrent::ReentrantReadWriteLock::READ_LOCK_MASK = T.let(T.unsafe(nil), Integer)
Concurrent::ReentrantReadWriteLock::RUNNING_WRITER = T.let(T.unsafe(nil), Integer)
Concurrent::ReentrantReadWriteLock::WAITING_WRITER = T.let(T.unsafe(nil), Integer)
Concurrent::ReentrantReadWriteLock::WRITER_BITS = T.let(T.unsafe(nil), Integer)
Concurrent::ReentrantReadWriteLock::WRITE_LOCK_HELD = T.let(T.unsafe(nil), Integer)
Concurrent::ReentrantReadWriteLock::WRITE_LOCK_MASK = T.let(T.unsafe(nil), Integer)
class Concurrent::RejectedExecutionError < ::Concurrent::Error; end
class Concurrent::ResourceLimitError < ::Concurrent::Error; end

class Concurrent::RubyExchanger < ::Concurrent::AbstractExchanger
  def initialize; end

  def __initialize_atomic_fields__; end
  def compare_and_set_slot(expected, value); end
  def slot; end
  def slot=(value); end
  def swap_slot(value); end
  def update_slot(&block); end

  private

  def do_exchange(value, timeout); end

  class << self
    def new(*args, &block); end
  end
end

class Concurrent::RubyExchanger::Node < ::Concurrent::Synchronization::Object
  def initialize(item); end

  def __initialize_atomic_fields__; end
  def compare_and_set_value(expected, value); end
  def item; end
  def latch; end
  def swap_value(value); end
  def update_value(&block); end
  def value; end
  def value=(value); end

  class << self
    def new(*args, &block); end
  end
end

class Concurrent::RubyExecutorService < ::Concurrent::AbstractExecutorService
  def initialize(*args, &block); end

  def kill; end
  def post(*args, &task); end
  def shutdown; end
  def wait_for_termination(timeout = T.unsafe(nil)); end

  private

  def ns_running?; end
  def ns_shutdown?; end
  def ns_shutdown_execution; end
  def ns_shuttingdown?; end
  def stop_event; end
  def stopped_event; end
end

class Concurrent::RubySingleThreadExecutor < ::Concurrent::RubyThreadPoolExecutor
  def initialize(opts = T.unsafe(nil)); end
end

class Concurrent::RubyThreadLocalVar < ::Concurrent::AbstractThreadLocalVar
  def value; end
  def value=(value); end

  protected

  def allocate_storage; end

  private

  def get_default; end
  def get_threadlocal_array(thread = T.unsafe(nil)); end
  def next_index; end
  def set_threadlocal_array(array, thread = T.unsafe(nil)); end
  def value_for(thread); end

  class << self
    def semi_sync(&block); end
    def thread_finalizer(id); end
    def thread_local_finalizer(index); end
  end
end

Concurrent::RubyThreadLocalVar::FREE = T.let(T.unsafe(nil), Array)
Concurrent::RubyThreadLocalVar::LOCK = T.let(T.unsafe(nil), Thread::Mutex)
Concurrent::RubyThreadLocalVar::THREAD_LOCAL_ARRAYS = T.let(T.unsafe(nil), Hash)

class Concurrent::RubyThreadPoolExecutor < ::Concurrent::RubyExecutorService
  def initialize(opts = T.unsafe(nil)); end

  def can_overflow?; end
  def completed_task_count; end
  def idletime; end
  def largest_length; end
  def length; end
  def max_length; end
  def max_queue; end
  def min_length; end
  def queue_length; end
  def ready_worker(worker); end
  def remaining_capacity; end
  def remove_busy_worker(worker); end
  def scheduled_task_count; end
  def synchronous; end
  def worker_died(worker); end
  def worker_not_old_enough(worker); end
  def worker_task_completed; end

  private

  def ns_add_busy_worker; end
  def ns_assign_worker(*args, &task); end
  def ns_enqueue(*args, &task); end
  def ns_execute(*args, &task); end
  def ns_initialize(opts); end
  def ns_kill_execution; end
  def ns_limited_queue?; end
  def ns_prune_pool; end
  def ns_ready_worker(worker, success = T.unsafe(nil)); end
  def ns_remove_busy_worker(worker); end
  def ns_reset_if_forked; end
  def ns_shutdown_execution; end
  def ns_worker_died(worker); end
  def ns_worker_not_old_enough(worker); end
end

Concurrent::RubyThreadPoolExecutor::DEFAULT_MAX_POOL_SIZE = T.let(T.unsafe(nil), Integer)
Concurrent::RubyThreadPoolExecutor::DEFAULT_MAX_QUEUE_SIZE = T.let(T.unsafe(nil), Integer)
Concurrent::RubyThreadPoolExecutor::DEFAULT_MIN_POOL_SIZE = T.let(T.unsafe(nil), Integer)
Concurrent::RubyThreadPoolExecutor::DEFAULT_THREAD_IDLETIMEOUT = T.let(T.unsafe(nil), Integer)

class Concurrent::RubyThreadPoolExecutor::Worker
  include ::Logger::Severity
  include ::Concurrent::Concern::Logging

  def initialize(pool, id); end

  def <<(message); end
  def kill; end
  def stop; end

  private

  def create_worker(queue, pool, idletime); end
  def run_task(pool, task, args); end
end

class Concurrent::SafeTaskExecutor < ::Concurrent::Synchronization::LockableObject
  def initialize(task, opts = T.unsafe(nil)); end

  def execute(*args); end
end

class Concurrent::ScheduledTask < ::Concurrent::IVar
  include ::Comparable

  def initialize(delay, opts = T.unsafe(nil), &task); end

  def <=>(other); end
  def cancel; end
  def cancelled?; end
  def execute; end
  def executor; end
  def initial_delay; end
  def process_task; end
  def processing?; end
  def reschedule(delay); end
  def reset; end
  def schedule_time; end

  protected

  def ns_reschedule(delay); end
  def ns_schedule(delay); end

  class << self
    def execute(delay, opts = T.unsafe(nil), &task); end
  end
end

class Concurrent::Semaphore < ::Concurrent::MutexSemaphore; end
Concurrent::SemaphoreImplementation = Concurrent::MutexSemaphore

module Concurrent::SerialExecutorService
  include ::Logger::Severity
  include ::Concurrent::Concern::Logging
  include ::Concurrent::ExecutorService

  def serialized?; end
end

class Concurrent::SerializedExecution < ::Concurrent::Synchronization::LockableObject
  include ::Logger::Severity
  include ::Concurrent::Concern::Logging

  def initialize; end

  def post(executor, *args, &task); end
  def posts(posts); end

  private

  def call_job(job); end
  def ns_initialize; end
  def work(job); end
end

class Concurrent::SerializedExecution::Job < ::Struct
  def args; end
  def args=(_); end
  def block; end
  def block=(_); end
  def call; end
  def executor; end
  def executor=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def members; end
    def new(*_arg0); end
  end
end

class Concurrent::SerializedExecutionDelegator < ::SimpleDelegator
  include ::Logger::Severity
  include ::Concurrent::Concern::Logging
  include ::Concurrent::ExecutorService
  include ::Concurrent::SerialExecutorService

  def initialize(executor); end

  def post(*args, &task); end
end

class Concurrent::Set < ::Concurrent::CRubySet; end
Concurrent::SetImplementation = Concurrent::CRubySet

module Concurrent::SettableStruct
  include ::Concurrent::Synchronization::AbstractStruct

  def ==(other); end
  def [](member); end
  def []=(member, value); end
  def each(&block); end
  def each_pair(&block); end
  def inspect; end
  def merge(other, &block); end
  def select(&block); end
  def to_a; end
  def to_h; end
  def to_s; end
  def values; end
  def values_at(*indexes); end

  private

  def initialize_copy(original); end

  class << self
    def new(*args, &block); end
  end
end

Concurrent::SettableStruct::FACTORY = T.let(T.unsafe(nil), T.untyped)

class Concurrent::SimpleExecutorService < ::Concurrent::RubyExecutorService
  def <<(task); end
  def kill; end
  def post(*args, &task); end
  def running?; end
  def shutdown; end
  def shutdown?; end
  def shuttingdown?; end
  def wait_for_termination(timeout = T.unsafe(nil)); end

  private

  def ns_initialize(*args); end

  class << self
    def <<(task); end
    def post(*args); end
  end
end

class Concurrent::SingleThreadExecutor < ::Concurrent::RubySingleThreadExecutor; end
Concurrent::SingleThreadExecutorImplementation = Concurrent::RubySingleThreadExecutor
module Concurrent::Synchronization; end

class Concurrent::Synchronization::AbstractLockableObject < ::Concurrent::Synchronization::Object
  protected

  def ns_broadcast; end
  def ns_signal; end
  def ns_wait(timeout = T.unsafe(nil)); end
  def ns_wait_until(timeout = T.unsafe(nil), &condition); end
  def synchronize; end
end

class Concurrent::Synchronization::AbstractObject
  def initialize; end

  def full_memory_barrier; end

  class << self
    def attr_volatile(*names); end
  end
end

module Concurrent::Synchronization::AbstractStruct
  def initialize(*values); end

  def length; end
  def members; end
  def size; end

  protected

  def ns_each; end
  def ns_each_pair; end
  def ns_equality(other); end
  def ns_get(member); end
  def ns_initialize_copy; end
  def ns_inspect; end
  def ns_merge(other, &block); end
  def ns_select; end
  def ns_to_h; end
  def ns_values; end
  def ns_values_at(indexes); end
  def pr_underscore(clazz); end

  class << self
    def define_struct_class(parent, base, name, members, &block); end
  end
end

class Concurrent::Synchronization::Condition < ::Concurrent::Synchronization::LockableObject
  def initialize(lock); end

  def broadcast; end
  def ns_broadcast; end
  def ns_signal; end
  def ns_wait(timeout = T.unsafe(nil)); end
  def ns_wait_until(timeout = T.unsafe(nil), &condition); end
  def signal; end
  def wait(timeout = T.unsafe(nil)); end
  def wait_until(timeout = T.unsafe(nil), &condition); end

  class << self
    def private_new(*args, &block); end
  end
end

module Concurrent::Synchronization::ConditionSignalling
  protected

  def ns_broadcast; end
  def ns_signal; end
end

class Concurrent::Synchronization::Lock < ::Concurrent::Synchronization::LockableObject
  def broadcast; end
  def signal; end
  def wait(timeout = T.unsafe(nil)); end
  def wait_until(timeout = T.unsafe(nil), &condition); end
end

class Concurrent::Synchronization::LockableObject < ::Concurrent::Synchronization::MutexLockableObject
  def new_condition; end
end

Concurrent::Synchronization::LockableObjectImplementation = Concurrent::Synchronization::MutexLockableObject

class Concurrent::Synchronization::MonitorLockableObject < ::Concurrent::Synchronization::AbstractLockableObject
  include ::Concurrent::Synchronization::ConditionSignalling

  def initialize(*defaults); end

  protected

  def ns_wait(timeout = T.unsafe(nil)); end
  def synchronize; end

  private

  def initialize_copy(other); end

  class << self
    def new(*args, &block); end
  end
end

module Concurrent::Synchronization::MriAttrVolatile
  mixes_in_class_methods ::Concurrent::Synchronization::MriAttrVolatile::ClassMethods

  def full_memory_barrier; end

  class << self
    def included(base); end
  end
end

module Concurrent::Synchronization::MriAttrVolatile::ClassMethods
  def attr_volatile(*names); end
end

class Concurrent::Synchronization::MriObject < ::Concurrent::Synchronization::AbstractObject
  include ::Concurrent::Synchronization::MriAttrVolatile
  extend ::Concurrent::Synchronization::MriAttrVolatile::ClassMethods

  def initialize; end
end

class Concurrent::Synchronization::MutexLockableObject < ::Concurrent::Synchronization::AbstractLockableObject
  include ::Concurrent::Synchronization::ConditionSignalling

  def initialize(*defaults); end

  protected

  def ns_wait(timeout = T.unsafe(nil)); end
  def synchronize; end

  private

  def initialize_copy(other); end

  class << self
    def new(*args, &block); end
  end
end

class Concurrent::Synchronization::Object < ::Concurrent::Synchronization::MriObject
  def initialize; end

  private

  def __initialize_atomic_fields__; end

  class << self
    def atomic_attribute?(name); end
    def atomic_attributes(inherited = T.unsafe(nil)); end
    def attr_atomic(*names); end
    def ensure_safe_initialization_when_final_fields_are_present; end
    def safe_initialization!; end
    def safe_initialization?; end

    private

    def define_initialize_atomic_fields; end
  end
end

Concurrent::Synchronization::ObjectImplementation = Concurrent::Synchronization::MriObject

module Concurrent::Synchronization::RbxAttrVolatile
  mixes_in_class_methods ::Concurrent::Synchronization::RbxAttrVolatile::ClassMethods

  def full_memory_barrier; end

  class << self
    def included(base); end
  end
end

module Concurrent::Synchronization::RbxAttrVolatile::ClassMethods
  def attr_volatile(*names); end
end

class Concurrent::Synchronization::RbxLockableObject < ::Concurrent::Synchronization::AbstractLockableObject
  def initialize(*defaults); end

  protected

  def ns_broadcast; end
  def ns_signal; end
  def ns_wait(timeout = T.unsafe(nil)); end
  def synchronize(&block); end

  private

  def initialize_copy(other); end

  class << self
    def new(*args, &block); end
  end
end

class Concurrent::Synchronization::RbxObject < ::Concurrent::Synchronization::AbstractObject
  include ::Concurrent::Synchronization::RbxAttrVolatile
  extend ::Concurrent::Synchronization::RbxAttrVolatile::ClassMethods

  def initialize; end
end

module Concurrent::Synchronization::TruffleRubyAttrVolatile
  mixes_in_class_methods ::Concurrent::Synchronization::TruffleRubyAttrVolatile::ClassMethods

  def full_memory_barrier; end

  class << self
    def included(base); end
  end
end

module Concurrent::Synchronization::TruffleRubyAttrVolatile::ClassMethods
  def attr_volatile(*names); end
end

class Concurrent::Synchronization::TruffleRubyObject < ::Concurrent::Synchronization::AbstractObject
  include ::Concurrent::Synchronization::TruffleRubyAttrVolatile
  extend ::Concurrent::Synchronization::TruffleRubyAttrVolatile::ClassMethods

  def initialize; end
end

Concurrent::Synchronization::Volatile = Concurrent::Synchronization::MriAttrVolatile

class Concurrent::SynchronizedDelegator < ::SimpleDelegator
  def initialize(obj); end

  def method_missing(method, *args, &block); end
  def setup; end
  def teardown; end
end

class Concurrent::TVar < ::Concurrent::Synchronization::Object
  def initialize(value); end

  def unsafe_increment_version; end
  def unsafe_lock; end
  def unsafe_value; end
  def unsafe_value=(value); end
  def unsafe_version; end
  def value; end
  def value=(value); end

  class << self
    def new(*args, &block); end
  end
end

class Concurrent::ThreadLocalVar < ::Concurrent::RubyThreadLocalVar; end
Concurrent::ThreadLocalVarImplementation = Concurrent::RubyThreadLocalVar
class Concurrent::ThreadPoolExecutor < ::Concurrent::RubyThreadPoolExecutor; end
Concurrent::ThreadPoolExecutorImplementation = Concurrent::RubyThreadPoolExecutor
module Concurrent::ThreadSafe; end

module Concurrent::ThreadSafe::Util
  class << self
    def make_synchronized_on_cruby(klass); end
    def make_synchronized_on_rbx(klass); end
    def make_synchronized_on_truffleruby(klass); end
  end
end

Concurrent::ThreadSafe::Util::CPU_COUNT = T.let(T.unsafe(nil), Integer)
Concurrent::ThreadSafe::Util::FIXNUM_BIT_SIZE = T.let(T.unsafe(nil), Integer)
Concurrent::ThreadSafe::Util::MAX_INT = T.let(T.unsafe(nil), Integer)
class Concurrent::TimeoutError < ::Concurrent::Error; end

class Concurrent::TimerSet < ::Concurrent::RubyExecutorService
  def initialize(opts = T.unsafe(nil)); end

  def kill; end
  def post(delay, *args, &task); end

  private

  def ns_initialize(opts); end
  def ns_post_task(task); end
  def ns_reset_if_forked; end
  def ns_shutdown_execution; end
  def post_task(task); end
  def process_tasks; end
  def remove_task(task); end
end

class Concurrent::TimerTask < ::Concurrent::RubyExecutorService
  include ::Concurrent::Concern::Dereferenceable
  include ::Concurrent::Concern::Observable

  def initialize(opts = T.unsafe(nil), &task); end

  def execute; end
  def execution_interval; end
  def execution_interval=(value); end
  def running?; end
  def timeout_interval; end
  def timeout_interval=(value); end

  private

  def execute_task(completion); end
  def ns_initialize(opts, &task); end
  def ns_kill_execution; end
  def ns_shutdown_execution; end
  def schedule_next_task(interval = T.unsafe(nil)); end
  def timeout_task(completion); end

  class << self
    def execute(opts = T.unsafe(nil), &task); end
  end
end

Concurrent::TimerTask::EXECUTION_INTERVAL = T.let(T.unsafe(nil), Integer)
Concurrent::TimerTask::TIMEOUT_INTERVAL = T.let(T.unsafe(nil), Integer)

class Concurrent::Transaction
  def initialize; end

  def abort; end
  def commit; end
  def read(tvar); end
  def unlock; end
  def valid?; end
  def write(tvar, value); end

  class << self
    def current; end
    def current=(transaction); end
  end
end

Concurrent::Transaction::ABORTED = T.let(T.unsafe(nil), Object)
class Concurrent::Transaction::AbortError < ::StandardError; end
class Concurrent::Transaction::LeaveError < ::StandardError; end

class Concurrent::Transaction::ReadLogEntry < ::Struct
  def tvar; end
  def tvar=(_); end
  def version; end
  def version=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def members; end
    def new(*_arg0); end
  end
end

class Concurrent::Tuple
  include ::Enumerable

  def initialize(size); end

  def cas(i, old_value, new_value); end
  def compare_and_set(i, old_value, new_value); end
  def each; end
  def get(i); end
  def set(i, value); end
  def size; end
  def volatile_get(i); end
  def volatile_set(i, value); end
end

Concurrent::Tuple::Tuple = Array
module Concurrent::Utility; end

module Concurrent::Utility::EngineDetector
  def on_cruby?; end
  def on_jruby?; end
  def on_jruby_9000?; end
  def on_linux?; end
  def on_osx?; end
  def on_rbx?; end
  def on_truffleruby?; end
  def on_windows?; end
  def ruby_engine; end
  def ruby_version(version = T.unsafe(nil), comparison, major, minor, patch); end
end

module Concurrent::Utility::NativeExtensionLoader
  def allow_c_extensions?; end
  def c_extensions_loaded?; end
  def java_extensions_loaded?; end
  def load_native_extensions; end

  private

  def load_error_path(error); end
  def set_c_extensions_loaded; end
  def set_java_extensions_loaded; end
  def try_load_c_extension(path); end
end

module Concurrent::Utility::NativeInteger
  extend ::Concurrent::Utility::NativeInteger

  def ensure_integer(value); end
  def ensure_integer_and_bounds(value); end
  def ensure_lower_bound(value); end
  def ensure_positive(value); end
  def ensure_positive_and_no_zero(value); end
  def ensure_upper_bound(value); end
end

Concurrent::Utility::NativeInteger::MAX_VALUE = T.let(T.unsafe(nil), Integer)
Concurrent::Utility::NativeInteger::MIN_VALUE = T.let(T.unsafe(nil), Integer)

class Concurrent::Utility::ProcessorCounter
  def initialize; end

  def physical_processor_count; end
  def processor_count; end

  private

  def compute_physical_processor_count; end
  def compute_processor_count; end
end

Concurrent::VERSION = T.let(T.unsafe(nil), String)
